/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.controller;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.client.repackaged.com.google.common.base.Splitter;
import com.google.gson.Gson;
import com.viztrend.exception.ViztrendJiraException;
import com.viztrend.safe.alm.jira.ImportUtil;
import com.viztrend.safe.alm.jira.TFSUtils;
import com.viztrend.safe.controller.PIJourneyController;
import com.viztrend.safe.persistence.entity.AlmAccount;
import com.viztrend.safe.persistence.entity.Answer;
import com.viztrend.safe.persistence.entity.AnswerTemplate;
import com.viztrend.safe.persistence.entity.Container;
import com.viztrend.safe.persistence.entity.Option;
import com.viztrend.safe.persistence.entity.PiAgenda;
import com.viztrend.safe.persistence.entity.PiAgendaDay;
import com.viztrend.safe.persistence.entity.PiContainerCapacity;
import com.viztrend.safe.persistence.entity.PiDay;
import com.viztrend.safe.persistence.entity.PiJourney;
import com.viztrend.safe.persistence.entity.PiJourneyEvent;
import com.viztrend.safe.persistence.entity.PiJourneyEventTemplate;
import com.viztrend.safe.persistence.entity.PiProgramRole;
import com.viztrend.safe.persistence.entity.PiSite;
import com.viztrend.safe.persistence.entity.PiSos;
import com.viztrend.safe.persistence.entity.PiSystemRole;
import com.viztrend.safe.persistence.entity.PiTeamBreakoutTeam;
import com.viztrend.safe.persistence.entity.PiTeamCapacity;
import com.viztrend.safe.persistence.entity.PiUserCapacity;
import com.viztrend.safe.persistence.entity.Question;
import com.viztrend.safe.persistence.entity.ServerCache;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.StateScheme;
import com.viztrend.safe.persistence.entity.Team;
import com.viztrend.safe.persistence.entity.TeamSprintVelocity;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.dto.SecureUser;
import com.viztrend.safe.persistence.repository.AlmAccountRepository;
import com.viztrend.safe.persistence.repository.AnswerRepository;
import com.viztrend.safe.persistence.repository.AnswerTemplateRepository;
import com.viztrend.safe.persistence.repository.ContainerRepository;
import com.viztrend.safe.persistence.repository.CustomRepository;
import com.viztrend.safe.persistence.repository.PiAgendaDayRepository;
import com.viztrend.safe.persistence.repository.PiAgendaRepository;
import com.viztrend.safe.persistence.repository.PiDayRepository;
import com.viztrend.safe.persistence.repository.PiJourneyEventRepository;
import com.viztrend.safe.persistence.repository.PiJourneyEventTemplateRepository;
import com.viztrend.safe.persistence.repository.PiJourneyRepository;
import com.viztrend.safe.persistence.repository.PiProgramRoleRepository;
import com.viztrend.safe.persistence.repository.PiSiteRepository;
import com.viztrend.safe.persistence.repository.PiSosRepository;
import com.viztrend.safe.persistence.repository.PiSystemRoleRepository;
import com.viztrend.safe.persistence.repository.PiTeamBreakoutRepository;
import com.viztrend.safe.persistence.repository.PiTeamCapacityRepository;
import com.viztrend.safe.persistence.repository.PiUserCapacityRepository;
import com.viztrend.safe.persistence.repository.QuestionRepository;
import com.viztrend.safe.persistence.repository.ServerCacheRepository;
import com.viztrend.safe.persistence.repository.SessionBoardRepository;
import com.viztrend.safe.persistence.repository.SessionRepository;
import com.viztrend.safe.persistence.repository.StateSchemeRepository;
import com.viztrend.safe.persistence.repository.TeamSprintVelocityRepository;
import com.viztrend.safe.persistence.repository.UserRepository;
import com.viztrend.safe.service.ExportService;
import com.viztrend.safe.service.PiJourneyService;
import com.viztrend.safe.service.UserService;
import com.viztrend.safe.utils.AlmUtils;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.PushSender;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.UserContextUtil;
import java.io.IOException;
import java.io.Serializable;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.bson.types.ObjectId;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.safety.Whitelist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/pijourney"})
@RestController
public class PIJourneyController {
    private static final Logger LOGGER = LoggerFactory.getLogger(PIJourneyController.class);
    @Autowired
    private StateSchemeRepository stateSchemeRepository;
    @Autowired
    private PiJourneyRepository piJourneyRepository;
    @Autowired
    private PiDayRepository piDayRepository;
    @Autowired
    private PiSiteRepository piSiteRepository;
    @Autowired
    private PiAgendaRepository piAgendaRepository;
    @Autowired
    private PiAgendaDayRepository piAgendaDayRepository;
    @Autowired
    private PiJourneyEventRepository piJourneyEventRepository;
    @Autowired
    private PiJourneyEventTemplateRepository piJourneyEventTemplateRepository;
    @Autowired
    private SessionBoardRepository sessionBoardRepository;
    @Autowired
    private SessionRepository sessionRepository;
    @Autowired
    private Environment env;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private TFSUtils tfsUtils;
    @Autowired
    private AlmAccountRepository almAccountRepository;
    @Autowired
    private PiSystemRoleRepository piSystemRoleRepository;
    @Autowired
    private PiProgramRoleRepository piProgramRoleRepository;
    @Autowired
    private QuestionRepository questionRepository;
    @Autowired
    private AnswerRepository answerRepository;
    @Autowired
    private PiSosRepository piSosRepository;
    @Autowired
    private AnswerTemplateRepository answerTemplateRepository;
    @Autowired
    private PiTeamCapacityRepository piTeamCapacityRepository;
    @Autowired
    private PiUserCapacityRepository piUserCapacityRepository;
    @Autowired
    private PiTeamBreakoutRepository piTeamBreakoutRepository;
    @Autowired
    private ContainerRepository containerRepository;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private ImportUtil importUtil;
    @Autowired
    private PiJourneyService piJourneyService;
    @Autowired
    private TeamSprintVelocityRepository teamSprintVelocityRepository;
    @Autowired
    private ServerCacheRepository serverCacheRepository;
    @Autowired
    private CustomRepository<Object> customRepository;
    @Autowired
    private UserService userService;
    @Autowired
    private ExportService exportService;
    private String pfvDays2 = "[{\"title\":\"Day 1\",\"startTime\":9.0,\"endTime\":18.0},{\"title\":\"Day 2\",\"startTime\":9.0,\"endTime\":18.0}]";
    private String pfvDays3 = "[{\"title\":\"Day 1\",\"startTime\":9.0,\"endTime\":18.0},{\"title\":\"Day 2\",\"startTime\":9.0,\"endTime\":18.0},{\"title\":\"Day 3\",\"startTime\":9.0,\"endTime\":18.0}]";
    private String pfvAgendaDays2 = "[{\"events\":[{\"startTime\":8,\"endTime\":9,\"title\":\"Business Context\",\"type\":\"event\",\"color\":\"#00B890\",\"description\":\"State of the business and upcoming objectives\",\"attachments\":[],\"rooms\":[],\"category\":\"agenda\",\"sequence\":1000,\"presenters\":[]},{\"startTime\":9,\"endTime\":10.5,\"title\":\"Product/Solution Vision\",\"type\":\"event\",\"color\":\"#FF8B2E\",\"description\":\"Vision and prioritized features\",\"attachments\":[],\"rooms\":[],\"category\":\"agenda\",\"sequence\":2000,\"presenters\":[]},{\"startTime\":10.5,\"endTime\":11.5,\"title\":\"Architecture Vision & development practices\",\"type\":\"event\",\"color\":\"#008AE3\",\"description\":\"Architecture, common frameworks, etc\",\"attachments\":[],\"rooms\":[],\"category\":\"agenda\",\"sequence\":3000,\"presenters\":[]},{\"startTime\":11.5,\"endTime\":13,\"title\":\"Planning context and lunch\",\"type\":\"event\",\"color\":\"#869193\",\"description\":\"Facilitator explains planning process\",\"attachments\":[],\"rooms\":[],\"category\":\"agenda\",\"sequence\":4000,\"presenters\":[]},{\"startTime\":13,\"endTime\":16,\"title\":\"Team breakouts\",\"type\":\"breakout\",\"color\":\"#AF385A\",\"description\":\"Teams develop draft plans and identify risks and impediments\\nArchitects and Product Managers circulate\",\"attachments\":[],\"rooms\":[],\"category\":\"agenda\",\"sequence\":5000,\"presenters\":[]},{\"startTime\":16,\"endTime\":17,\"title\":\"Draft plan review\",\"type\":\"event\",\"color\":\"#FFE93A\",\"description\":\"Teams present draft plans, risks, and impediments\",\"attachments\":[],\"rooms\":[],\"category\":\"agenda\",\"sequence\":6000,\"presenters\":[]},{\"startTime\":17,\"endTime\":18,\"title\":\"Management review & problem solving\",\"type\":\"event\",\"color\":\"#FF8B2E\",\"description\":\"Adjustments made based on challenges, risks, and impediments\",\"attachments\":[],\"rooms\":[],\"category\":\"agenda\",\"sequence\":7000,\"presenters\":[]}]},{\"events\":[{\"startTime\":8,\"endTime\":9,\"title\":\"Planning adjustments\",\"type\":\"event\",\"color\":\"#00B890\",\"description\":\"Planning adjustments made based on previous day's management meeting\",\"attachments\":[],\"rooms\":[],\"category\":\"agenda\",\"sequence\":1000,\"presenters\":[]},{\"startTime\":9,\"endTime\":11,\"title\":\"Team Breakouts\",\"type\":\"breakout\",\"color\":\"#FF8B2E\",\"description\":\"Teams develop final plans and refine risks impediments\\nBusiness Owners circulate and assign business value to team objectives\",\"attachments\":[],\"rooms\":[],\"category\":\"agenda\",\"sequence\":2000,\"presenters\":[]},{\"startTime\":11,\"endTime\":13,\"title\":\"Final plan review & lunch\",\"type\":\"event\",\"color\":\"#008AE3\",\"description\":\"Teams present final plans, risks, and impediments\",\"attachments\":[],\"rooms\":[],\"category\":\"agenda\",\"sequence\":3000,\"presenters\":[]},{\"startTime\":13,\"endTime\":14,\"title\":\"Program Risks\",\"type\":\"event\",\"color\":\"#869193\",\"description\":\"Remaining program-level risks are discussed and roamed\",\"attachments\":[],\"rooms\":[],\"category\":\"agenda\",\"sequence\":4000,\"presenters\":[]},{\"startTime\":14,\"endTime\":14.25,\"title\":\"PI confidence vote\",\"type\":\"event\",\"color\":\"#AF385A\",\"description\":\"Team and program confidence vote\",\"attachments\":[],\"rooms\":[],\"category\":\"agenda\",\"sequence\":5000,\"presenters\":[]},{\"startTime\":14.25,\"endTime\":16.5,\"title\":\"Plan rework if necessary\",\"type\":\"event\",\"color\":\"#FFE93A\",\"description\":\"If necessary, planning continues until commitment is achieved\",\"attachments\":[],\"rooms\":[],\"category\":\"agenda\",\"sequence\":6000,\"presenters\":[]},{\"startTime\":16.5,\"endTime\":17,\"title\":\"Planning retrospective & moving forward\",\"type\":\"event\",\"color\":\"#FF8B2E\",\"description\":\"Retrospective\\nMoving Forward\\nFinal Instructions\",\"attachments\":[],\"rooms\":[],\"category\":\"agenda\",\"sequence\":7000,\"presenters\":[]}]}]";
    private String pfvAgendaDays3 = "[{\"events\":[{\"startTime\":8,\"endTime\":8.5,\"title\":\"Opening\",\"type\":\"event\",\"color\":\"#00B890\",\"description\":\"Introduction, agenda, objectives, and working agreements (Facilitator)\\nPlanning Context and Deliverables (Facilitator)\\nART and PI Planning context as needed (Facilitator)\\nReview of release cadence -Iterations and PIs (Facilitator)\",\"attachments\":[],\"rooms\":[],\"category\":\"agenda\",\"sequence\":1000,\"presenters\":[]},{\"startTime\":8.5,\"endTime\":9,\"title\":\"Business Context\",\"type\":\"event\",\"color\":\"#FF8B2E\",\"description\":\"State of the business (Executive)\\nUpcoming objectives (Executive)\",\"attachments\":[],\"rooms\":[],\"category\":\"agenda\",\"sequence\":2000,\"presenters\":[]},{\"startTime\":9,\"endTime\":10.5,\"title\":\"Product/Solution Vision\",\"type\":\"event\",\"color\":\"#008AE3\",\"description\":\"Vision of solution, products/services, and prioritized features (Product Management)\\nVision of solution features or components (Individual Solution Owners)\",\"attachments\":[],\"rooms\":[],\"category\":\"agenda\",\"sequence\":3000,\"presenters\":[]},{\"startTime\":10.5,\"endTime\":10.75,\"title\":\"Break\",\"type\":\"break\",\"color\":\"#869193\",\"description\":\"\",\"attachments\":[],\"rooms\":[],\"category\":\"agenda\",\"sequence\":4000,\"presenters\":[]},{\"startTime\":10.75,\"endTime\":11.25,\"title\":\"Architecture Vision\",\"type\":\"event\",\"color\":\"#AF385A\",\"description\":\"Vision for architecture, new architecture epics, common frameworks, NFRs (Technology Office, System Architect)\",\"attachments\":[],\"rooms\":[],\"category\":\"agenda\",\"sequence\":5000,\"presenters\":[]},{\"startTime\":11.25,\"endTime\":11.75,\"title\":\"Development Practices\",\"type\":\"event\",\"color\":\"#FFE93A\",\"description\":\"Updates on project setup, agile tooling, improvements in engineering practices, etc. (Development Management)\",\"attachments\":[],\"rooms\":[],\"category\":\"agenda\",\"sequence\":6000,\"presenters\":[]},{\"startTime\":11.75,\"endTime\":12.25,\"title\":\"Planning Requirements\",\"type\":\"event\",\"color\":\"#FF8B2E\",\"description\":\"Specific planning process, draft plan acceptance criteria, etc. (Facilitator)\",\"attachments\":[],\"rooms\":[],\"category\":\"agenda\",\"sequence\":7000,\"presenters\":[]},{\"title\":\"Meal Break\",\"startTime\":12.25,\"endTime\":13,\"type\":\"break\",\"category\":\"agenda\",\"attachments\":[],\"rooms\":[],\"category\":\"agenda\",\"sequence\":8000,\"presenters\":[]},{\"title\":\"Team Breakouts (1 of 2)\",\"startTime\":13,\"endTime\":16,\"type\":\"breakout\",\"description\":\"Features broken into stories (each team)\\nPI plan and objectives drafted (each team)\\nRisks and impediments identified (each team)\\nHourly Scrum of Scrums checkpoint to discuss planning status, program impediments, and dependencies (Scrum Masters)\\nProgram Board continuously updated (Scrum Masters)\\nArchitects and Product Managers circulate\",\"category\":\"agenda\",\"attachments\":[],\"rooms\":[],\"category\":\"agenda\",\"sequence\":9000,\"presenters\":[]},{\"startTime\":16,\"endTime\":17,\"title\":\"Management Review\",\"type\":\"event\",\"color\":\"#FF8B2E\",\"description\":\"It\u2019s likely that the draft plans present challenges such as scope, people and resource constraints, and dependencies. During the problem-solving meeting, management may negotiate scope changes and resolve other problems by agreeing to various planning adjustments\",\"attachments\":[],\"rooms\":[],\"category\":\"agenda\",\"sequence\":7000,\"presenters\":[]}]},{\"events\":[{\"startTime\":8,\"endTime\":9,\"title\":\"Team Synchronization\",\"type\":\"event\",\"color\":\"#FF8B2E\",\"description\":\"Distributed teams collaborate with Product Management and Solution Owners to synchronize\",\"attachments\":[],\"rooms\":[],\"category\":\"agenda\",\"sequence\":2000,\"presenters\":[]},{\"startTime\":9,\"endTime\":10,\"title\":\"Draft Plan Review\",\"type\":\"event\",\"color\":\"#008AE3\",\"description\":\"Capacity and Load\\nOverview of plan flow\\nDraft PI objectives\\nProgram risks, impediments, and Program Board dependencies\",\"attachments\":[],\"rooms\":[],\"category\":\"agenda\",\"sequence\":3000,\"presenters\":[]},{\"startTime\":10,\"endTime\":10.25,\"title\":\"Break\",\"type\":\"break\",\"color\":\"#869193\",\"description\":\"\",\"attachments\":[],\"rooms\":[],\"category\":\"agenda\",\"sequence\":4000,\"presenters\":[]},{\"startTime\":10.25,\"endTime\":11.25,\"title\":\"Management Review and Problem Solving\",\"type\":\"event\",\"color\":\"#AF385A\",\"description\":\"Discussion of scope, challenges to plan, risks, and impediments (Line Management, Product Management, Architects, and Team Representatives)\\nConducted with all teams in attendance\\nAdjustments of scope and resources as necessary (same as above)\",\"attachments\":[],\"rooms\":[],\"category\":\"agenda\",\"sequence\":5000,\"presenters\":[]},{\"startTime\":11.25,\"endTime\":11.75,\"title\":\"Planning Adjustments\",\"type\":\"event\",\"color\":\"#FFE93A\",\"description\":\"Management review and problem-solving meeting readout \u2013 adjustments to plan, scope, resources, etc. (Managers)\",\"attachments\":[],\"rooms\":[],\"category\":\"agenda\",\"sequence\":6000,\"presenters\":[]},{\"startTime\":11.75,\"endTime\":12.5,\"title\":\"Meal\",\"type\":\"break\",\"color\":\"#869193\",\"description\":\"\",\"attachments\":[],\"rooms\":[],\"category\":\"agenda\",\"sequence\":7000,\"presenters\":[]},{\"title\":\"Team Breakouts (2 of 2)\",\"startTime\":12.5,\"endTime\":15,\"type\":\"breakout\",\"category\":\"agenda\",\"description\":\"PI plan and objectives finalized\\nRisks and impediments finalized\\nHourly Scrum of Scrums checkpoint to discuss planning status, program impediments, and dependencies (Scrum Masters)\\nProgram Board continuously updated (Scrum Masters)\\nArchitects and Product Managers circulate\\nBusiness Owners review objectives and assign business value\",\"attachments\":[],\"rooms\":[],\"category\":\"agenda\",\"sequence\":8000,\"presenters\":[]}]},{\"events\":[{\"startTime\":8,\"endTime\":9,\"title\":\"Team Synchronization & Finalized Objectives\",\"type\":\"event\",\"color\":\"#FF8B2E\",\"description\":\"Distributed teams collaborate with Product Management and Solution Owners to synchronize\\nBusiness Owners review objectives and finalize business value\",\"attachments\":[],\"rooms\":[],\"category\":\"agenda\",\"sequence\":2000,\"presenters\":[]},{\"startTime\":9,\"endTime\":11,\"title\":\"Final Plan Review\",\"type\":\"event\",\"color\":\"#008AE3\",\"description\":\"Changes to capacity and load\\nFinal PI objectives with business value\\nProgram risks, impediments, and Program Board dependencies\",\"attachments\":[],\"rooms\":[],\"category\":\"agenda\",\"sequence\":3000,\"presenters\":[]},{\"startTime\":11,\"endTime\":11.25,\"title\":\"Break\",\"type\":\"break\",\"color\":\"#869193\",\"description\":\"\",\"attachments\":[],\"rooms\":[],\"category\":\"agenda\",\"sequence\":4000,\"presenters\":[]},{\"startTime\":11.25,\"endTime\":12.25,\"title\":\"Program Risks\",\"type\":\"event\",\"color\":\"#AF385A\",\"description\":\"Remaining program risks are discussed and roamed -- resolved, owned, accepted, or\\nmitigated (Facilitator, with Management at front of room)\",\"attachments\":[],\"rooms\":[],\"category\":\"agenda\",\"sequence\":5000,\"presenters\":[]},{\"startTime\":12.25,\"endTime\":13,\"title\":\"Meal Break\",\"type\":\"event\",\"color\":\"#869193\",\"description\":\"\",\"attachments\":[],\"rooms\":[],\"category\":\"agenda\",\"sequence\":6000,\"presenters\":[]},{\"startTime\":13,\"endTime\":13.25,\"title\":\"PI Confidence Vote\",\"type\":\"event\",\"color\":\"#869193\",\"description\":\"Facilitator asks team-by-team for fist of five \u201cconfidence factor\u201d and PI commitment\\nFacilitator asks all teams for a fist of five \u201cconfidence factor\u201d for the ART as a whole\",\"attachments\":[],\"rooms\":[],\"category\":\"agenda\",\"sequence\":7000,\"presenters\":[]},{\"title\":\"Plan Rework if Necessary\",\"startTime\":13.25,\"endTime\":14.5,\"type\":\"event\",\"category\":\"agenda\",\"color\":\"#869193\",\"description\":\"If high confidence is not achieved, adjust scope and continue planning until commitment is achieved\\nRisks and impediments finalized\\nHourly Scrum of Scrums checkpoint to discuss planning status, program impediments, and dependencies (Scrum Masters)\\nProgram Board continuously updated (Scrum Masters)\\nArchitects and Product Managers circulate\\nBusiness Owners review objectives and assign business value\",\"attachments\":[],\"rooms\":[],\"category\":\"agenda\",\"sequence\":8000,\"presenters\":[]},{\"title\":\"Planning Retrospective\",\"startTime\":14.5,\"endTime\":15.0,\"type\":\"event\",\"category\":\"agenda\",\"color\":\"#869193\",\"description\":\"Process for capturing plans, risks, program board, and improvement backlog items in tooling (Facilitator)\\nFinal Instructions and closing remarks (Facilitator)\",\"attachments\":[],\"rooms\":[],\"category\":\"agenda\",\"sequence\":9000,\"presenters\":[]}]}]";
    private String pfvSetupEvents = "[]";

    private StateScheme getDefaultStateScheme() {
        StateScheme defaultStateScheme = this.stateSchemeRepository.findByIsDefaultIsTrue();
        return defaultStateScheme;
    }

    private String getNewMongoId() {
        return ObjectId.get().toString();
    }

    private List<PiJourneyEventTemplate> getDefaultEventTemplates() {
        ArrayList<PiJourneyEventTemplate> list = new ArrayList<PiJourneyEventTemplate>();
        PiJourneyEventTemplate event = null;
        event = new PiJourneyEventTemplate();
        event.setEventType("event");
        event.setTitle("Scrum of Scrums");
        event.setColor("#00B890");
        event.setType("event");
        event.setIsSystem(Boolean.valueOf(true));
        event.setCategory("agenda");
        list.add(event);
        event = new PiJourneyEventTemplate();
        event.setEventType("event");
        event.setTitle("PO Sync");
        event.setColor("#FF8B2E");
        event.setType("event");
        event.setIsSystem(Boolean.valueOf(true));
        event.setCategory("agenda");
        list.add(event);
        event = new PiJourneyEventTemplate();
        event.setEventType("event");
        event.setTitle("Inspect & Adapt");
        event.setColor("#008AE3");
        event.setType("event");
        event.setIsSystem(Boolean.valueOf(true));
        event.setCategory("agenda");
        list.add(event);
        event = new PiJourneyEventTemplate();
        event.setEventType("event");
        event.setTitle("Business Context");
        event.setColor("#AF385A");
        event.setType("event");
        event.setIsSystem(Boolean.valueOf(true));
        event.setCategory("agenda");
        list.add(event);
        event = new PiJourneyEventTemplate();
        event.setEventType("event");
        event.setTitle("Business Logic");
        event.setColor("#FFE93A");
        event.setType("event");
        event.setIsSystem(Boolean.valueOf(true));
        event.setCategory("agenda");
        list.add(event);
        event = new PiJourneyEventTemplate();
        event.setEventType("break");
        event.setTitle("Meal Break");
        event.setColor("#869193");
        event.setType("break");
        event.setIsSystem(Boolean.valueOf(true));
        event.setCategory("agenda");
        list.add(event);
        event = new PiJourneyEventTemplate();
        event.setEventType("event");
        event.setTitle("Scrum of Scrums");
        event.setColor("#00B890");
        event.setType("event");
        event.setIsSystem(Boolean.valueOf(true));
        event.setCategory("program");
        list.add(event);
        event = new PiJourneyEventTemplate();
        event.setEventType("event");
        event.setTitle("Inspect & Adapt");
        event.setColor("#FF8B2E");
        event.setType("event");
        event.setIsSystem(Boolean.valueOf(true));
        event.setCategory("program");
        list.add(event);
        event = new PiJourneyEventTemplate();
        event.setEventType("event");
        event.setTitle("Program Refinement");
        event.setColor("#008AE3");
        event.setType("event");
        event.setIsSystem(Boolean.valueOf(true));
        event.setCategory("program");
        list.add(event);
        event = new PiJourneyEventTemplate();
        event.setEventType("event");
        event.setTitle("Business Context");
        event.setColor("#AF385A");
        event.setType("event");
        event.setIsSystem(Boolean.valueOf(true));
        event.setCategory("program");
        list.add(event);
        event = new PiJourneyEventTemplate();
        event.setEventType("event");
        event.setTitle("Business Logic");
        event.setColor("#FFE93A");
        event.setType("event");
        event.setIsSystem(Boolean.valueOf(true));
        event.setCategory("program");
        list.add(event);
        return list;
    }

    private void addDateWithPrefilledValue(PiJourney journey, SessionBoard sessionBoard, int daysForTemplate) {
        Gson gson = new Gson();
        PiAgenda agenda = journey.getAgenda();
        1 daysTT = new /* Unavailable Anonymous Inner Class!! */;
        ArrayList days = new ArrayList();
        if (daysForTemplate == 3) {
            days = (ArrayList)gson.fromJson(this.pfvDays3, daysTT.getType());
        } else if (daysForTemplate == 2) {
            days = (ArrayList)gson.fromJson(this.pfvDays2, daysTT.getType());
        }
        2 agendaDaysTT = new /* Unavailable Anonymous Inner Class!! */;
        ArrayList agendaDays = null;
        if (daysForTemplate == 3) {
            agendaDays = (ArrayList)gson.fromJson(this.pfvAgendaDays3, agendaDaysTT.getType());
        } else if (daysForTemplate == 2) {
            agendaDays = (ArrayList)gson.fromJson(this.pfvAgendaDays2, agendaDaysTT.getType());
        }
        ArrayList<PiJourneyEvent> piJourneyEvents = new ArrayList<PiJourneyEvent>();
        ArrayList piTeamBreakout = new ArrayList();
        if (PropertyValidator.isValid((Collection)agendaDays)) {
            for (int i = 0; i < agendaDays.size(); ++i) {
                PiAgendaDay agendaDay = (PiAgendaDay)agendaDays.get(i);
                ((PiDay)days.get(i)).setPiJourneyId(journey.getId());
                ((PiDay)days.get(i)).setId(this.getNewMongoId());
                agendaDay.setDay((PiDay)days.get(i));
                agendaDay.setId(this.getNewMongoId());
                if (!PropertyValidator.isValid((Collection)agendaDay.getEvents())) continue;
                for (PiJourneyEvent event : agendaDay.getEvents()) {
                    event.setPiJourneyId(journey.getId());
                    event.setId(this.getNewMongoId());
                    piJourneyEvents.add(event);
                }
            }
        }
        this.piTeamBreakoutRepository.save(piTeamBreakout);
        this.piJourneyEventRepository.save(piJourneyEvents);
        this.piDayRepository.save((Iterable)days);
        this.piAgendaDayRepository.save((Iterable)agendaDays);
        journey.setDays(days);
        agenda.setPiAgendaDays(agendaDays);
        this.piAgendaRepository.save((Object)agenda);
        this.piJourneyRepository.save((Object)journey);
        this.userService.setOnboardingMeta("Start_Planning_Agenda", true);
    }

    @RequestMapping(value={"/addDateWithPrefilledValue/{sessionBoardId}/{journeyId}/{days}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> addDateWithPrefilledValueCall(@PathVariable(value="sessionBoardId") String sessionBoardId, @PathVariable(value="journeyId") String journeyId, @PathVariable(value="days") int days) {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        PiJourney piJourney = this.piJourneyRepository.findById(journeyId);
        SessionBoard sessionBoard = this.sessionBoardRepository.findById(sessionBoardId);
        this.addDateWithPrefilledValue(piJourney, sessionBoard, days);
        responseJson.put("success", true);
        responseJson.put("journey", (Boolean)piJourney);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/getUsers/{pageIndex}/{pageSize}"})
    @ResponseBody
    public ResponseEntity<Object> getUsers(@PathVariable(value="pageIndex") Integer pageIndex, @PathVariable(value="pageSize") Integer pageSize) {
        HashMap<String, List> responseJson = new HashMap<String, List>();
        PageRequest pageable = new PageRequest(pageIndex.intValue(), pageSize.intValue());
        String loggedinCompanyId = UserContextUtil.getUserContext().getCurrentCompany().getId();
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        String tenant = String.valueOf(secureUser.getUserContextDTO().getContextMap().get("tenant"));
        Query query = new Query();
        query.with((Pageable)pageable);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"updatedOn"}));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"rowStatus").is((Object)0));
        Criteria userCompanyCriteria = new Criteria().andOperator(new Criteria[]{Criteria.where((String)"userCompanies").ne(null), Criteria.where((String)"userCompanies.company.id").is((Object)loggedinCompanyId)});
        Criteria tenantCriteria = Criteria.where((String)"tenant").is((Object)tenant);
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        Criteria criteria0 = new Criteria().orOperator(new Criteria[]{userCompanyCriteria, tenantCriteria});
        query.addCriteria((CriteriaDefinition)criteria0);
        List users = this.mongoTemplate.find(query, User.class);
        LOGGER.debug("before get user pijourney");
        responseJson.put("users", users);
        LOGGER.debug("after get user pijourney");
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/searchUsers"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> searchUsers(@RequestBody HashMap<String, Object> reqbody) {
        try {
            Map responseJson = this.piJourneyService.searchUsers(reqbody);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception ex) {
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/createUser"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> createUser(@RequestBody User inputUser) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        inputUser.setArchive(false);
        if (PropertyValidator.isValid((Object)inputUser.getFirstName())) {
            User existing;
            SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            String tenant = String.valueOf(secureUser.getUserContextDTO().getContextMap().get("tenant"));
            if (PropertyValidator.isValid((Object)inputUser.getEmail()) && PropertyValidator.isValid((Object)(existing = this.userRepository.findByEmailAndTenant(inputUser.getEmail(), tenant)))) {
                if (existing.getRowStatus() != -2) {
                    responseJson.put("success", false);
                    responseJson.put("reason", "AlreadyExist");
                    return new ResponseEntity(responseJson, HttpStatus.OK);
                }
                existing.setFirstName(inputUser.getFirstName());
                existing.setLastName(inputUser.getLastName());
                existing.setRowStatus(0);
                existing = (User)this.userRepository.save((Object)existing);
                responseJson.put("success", true);
                responseJson.put("user", existing);
                return new ResponseEntity(responseJson, HttpStatus.OK);
            }
            existing = this.userRepository.findByFirstNameAndLastNameAndUserTypeAndTenant(inputUser.getFirstName(), inputUser.getLastName(), inputUser.getUserType().toString(), tenant);
            if (PropertyValidator.isValid((Object)existing)) {
                if (existing.getRowStatus() != -2) {
                    responseJson.put("success", false);
                    responseJson.put("reason", "AlreadyExist");
                    return new ResponseEntity(responseJson, HttpStatus.OK);
                }
                existing.setFirstName(inputUser.getFirstName());
                existing.setLastName(inputUser.getLastName());
                existing.setRowStatus(0);
                existing = (User)this.userRepository.save((Object)existing);
                responseJson.put("success", true);
                responseJson.put("user", existing);
                return new ResponseEntity(responseJson, HttpStatus.OK);
            }
            inputUser.setTenant(tenant);
            if (inputUser.getFullName() == null) {
                inputUser.setFullName(inputUser.getFirstName() + " " + inputUser.getLastName());
            }
            inputUser.setUserName(null);
            inputUser = (User)this.userRepository.save((Object)inputUser);
            responseJson.put("success", true);
            responseJson.put("user", inputUser);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        responseJson.put("success", false);
        return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
    }

    @RequestMapping(value={"/searchUserOnAlm/{almAccount}/{query}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> searchUserOnAlm(@PathVariable(value="almAccount") String almAccountId, @PathVariable(value="query") String query) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        AlmAccount almAccount = this.almAccountRepository.findById(almAccountId);
        try {
            String response = null;
            if (almAccount.getType().equals("tfs")) {
                try {
                    response = this.tfsUtils.getUsers("10", query, almAccount);
                    responseJson.put("success", true);
                    responseJson.put("almType", "tfs");
                    responseJson.put("content", response);
                }
                catch (ViztrendJiraException e) {
                    if (e.getCode() == 401) {
                        responseJson.put("success", false);
                        responseJson.put("reason", 401);
                    } else if (e.getCode() == 404) {
                        responseJson.put("success", false);
                        responseJson.put("reason", 404);
                    }
                }
            } else {
                String responseData = this.importUtil.searchJiraUsers(query, almAccount.getUsername(), almAccount.getPassword(), almAccount);
                responseJson.put("almType", "jira");
                responseJson.put("success", true);
                responseJson.put("content", responseData);
            }
        }
        catch (ViztrendJiraException e) {
            String err = StringUtils.getTraceString((Throwable)e);
            LOGGER.error(err);
            responseJson.put("kendisError", e.getAlmError());
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/getJiraUser/{almAccount}/{userId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getJiraUser(@PathVariable(value="almAccount") String almAccountId, @PathVariable(value="userId") String userId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        AlmAccount almAccount = this.almAccountRepository.findById(almAccountId);
        String responseData = this.importUtil.retrieveJiraUserById(userId, almAccount.getUsername(), almAccount.getPassword(), almAccount);
        responseJson.put("almType", "jira");
        responseJson.put("content", responseData);
        responseJson.put("success", true);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/getJourney/{sessionId}/{sessionBoardId}"})
    @ResponseBody
    public ResponseEntity<Object> getJourney(@PathVariable(value="sessionId") String sessionId, @PathVariable(value="sessionBoardId") String sessionBoardId) {
        HashMap responseJson = this.piJourneyService.getPiJourneyData(sessionId, sessionBoardId);
        responseJson.put("success", true);
        return new ResponseEntity((Object)responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/getJourneyDate/{sessionId}"})
    @ResponseBody
    public ResponseEntity<Object> getJourneyDate(@PathVariable(value="sessionId") String sessionId) {
        ArrayList days;
        HashMap<String, Comparable<Boolean>> responseJson = new HashMap<String, Comparable<Boolean>>();
        responseJson.put("success", Boolean.valueOf(false));
        PiJourney piJourney = this.piJourneyRepository.findBySessionId(sessionId);
        if (PropertyValidator.isValid((Object)piJourney) && PropertyValidator.isValid((Collection)(days = piJourney.getDays()))) {
            int i;
            for (i = 0; i < days.size(); ++i) {
                if (((PiDay)days.get(i)).getStartDate() == null) continue;
                responseJson.put("startDate", ((PiDay)days.get(i)).getStartDate());
                break;
            }
            for (i = days.size() - 1; i >= 0; --i) {
                if (((PiDay)days.get(i)).getStartDate() == null) continue;
                responseJson.put("endDate", ((PiDay)days.get(i)).getStartDate());
                break;
            }
            responseJson.put("success", Boolean.valueOf(true));
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/public_share/getJourney/{token}"})
    @ResponseBody
    public ResponseEntity<Object> getJourneyPublic(@PathVariable(value="token") String token) {
        ServerCache serverCache = this.serverCacheRepository.findByKey(token);
        if (PropertyValidator.isValid((Object)serverCache)) {
            String json = serverCache.getValue();
            Map kv = (Map)new Gson().fromJson(json, Map.class);
            String sessionId = (String)kv.get("id");
            HashMap responseJson = this.piJourneyService.getPiJourneyData(sessionId, null);
            responseJson.put("success", true);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        responseJson.put("success", false);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/getRoomsInfo/{sessionId}"})
    @ResponseBody
    public ResponseEntity<Object> getRoomsInfo(@PathVariable(value="sessionId") String sessionId) {
        HashMap<String, Serializable> responseJson = new HashMap<String, Serializable>();
        PiJourney piJourney = this.piJourneyRepository.findBySessionId(sessionId);
        if (!PropertyValidator.isValid((Object)piJourney)) {
            responseJson.put("success", Boolean.valueOf(false));
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        ArrayList<PiJourneyEvent> events = new ArrayList<PiJourneyEvent>();
        if (PropertyValidator.isValid((Collection)piJourney.getAgenda().getPiAgendaDays())) {
            for (PiAgendaDay agendaDay : piJourney.getAgenda().getPiAgendaDays()) {
                if (!PropertyValidator.isValid((Collection)agendaDay.getEvents())) continue;
                for (PiJourneyEvent event : agendaDay.getEvents()) {
                    event.setStartDate(agendaDay.getDay().getStartDate());
                    events.add(event);
                }
            }
        }
        PiSite defaultSite = null;
        if (PropertyValidator.isValid((Collection)piJourney.getSites())) {
            for (PiSite site : piJourney.getSites()) {
                if (!site.getIsDefault().booleanValue()) continue;
                defaultSite = site;
                TimeZone timeZone = TimeZone.getTimeZone(defaultSite.getTimeZone());
                if (timeZone.inDaylightTime(new Date())) {
                    defaultSite.setUseDst(Boolean.valueOf(true));
                    break;
                }
                defaultSite.setUseDst(Boolean.valueOf(false));
                break;
            }
        }
        responseJson.put("success", Boolean.valueOf(true));
        responseJson.put("events", events);
        responseJson.put("defaultSite", (Serializable)defaultSite);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/saveSiteInPiJourney/{journeyId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> savePiJourneySite(@RequestBody PiSite piSite, @PathVariable(value="journeyId") String journeyId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        if (!PropertyValidator.isValid((Object)piSite) || !PropertyValidator.isValid((Object)journeyId)) {
            responseJson.put("success", false);
            responseJson.put("reason", "Invalid Input");
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        PiJourney piJourney = this.piJourneyRepository.findById(journeyId);
        if (PropertyValidator.isValid((Collection)piJourney.getSites())) {
            for (PiSite site : piJourney.getSites()) {
                if (!site.getCountryCode().equals(piSite.getCountryCode()) || !site.getCity().equals(piSite.getCity())) continue;
                responseJson.put("success", false);
                responseJson.put("reason", "AlreadyExist");
                return new ResponseEntity(responseJson, HttpStatus.OK);
            }
            if (piJourney.getSites().size() >= 10) {
                responseJson.put("success", false);
                responseJson.put("reason", "LimitExceed");
                return new ResponseEntity(responseJson, HttpStatus.OK);
            }
        }
        TimeZone timeZone = TimeZone.getTimeZone(piSite.getTimeZone());
        piSite.setDstSavings(timeZone.getDSTSavings());
        piSite.setRawOffset(timeZone.getRawOffset());
        if (piSite.getIsDefault() != null && piSite.getIsDefault().booleanValue()) {
            double minSequence = Double.MAX_VALUE;
            if (PropertyValidator.isValid((Collection)piJourney.getSites())) {
                for (PiSite site : piJourney.getSites()) {
                    if (!site.getIsDefault().booleanValue()) continue;
                    minSequence = site.getSequence() - 1000.0;
                    site.setIsDefault(Boolean.valueOf(false));
                    this.piSiteRepository.save((Object)site);
                    break;
                }
            } else {
                minSequence = 0.0;
                piSite.setIsDefault(Boolean.valueOf(true));
            }
            piSite.setSequence(Double.valueOf(minSequence));
        } else {
            double maxSequence = 0.0;
            if (PropertyValidator.isValid((Collection)piJourney.getSites())) {
                for (PiSite site : piJourney.getSites()) {
                    if (!(site.getSequence() > maxSequence)) continue;
                    maxSequence = site.getSequence();
                }
                maxSequence += 1000.0;
            } else {
                piSite.setIsDefault(Boolean.valueOf(true));
            }
            piSite.setSequence(Double.valueOf(maxSequence));
        }
        piSite = (PiSite)this.piSiteRepository.save((Object)piSite);
        ArrayList<PiSite> piJourneySites = piJourney.getSites();
        if (!PropertyValidator.isValid((Collection)piJourneySites)) {
            piJourneySites = new ArrayList<PiSite>();
        }
        piJourneySites.add(piSite);
        piJourney.setSites(piJourneySites);
        this.piJourneyRepository.save((Object)piJourney);
        Collections.sort(piJourneySites, new /* Unavailable Anonymous Inner Class!! */);
        for (PiSite site : piJourneySites) {
            TimeZone _timeZone = TimeZone.getTimeZone(site.getTimeZone());
            if (_timeZone.inDaylightTime(new Date())) {
                site.setUseDst(Boolean.valueOf(true));
                continue;
            }
            site.setUseDst(Boolean.valueOf(false));
        }
        responseJson.put("success", true);
        responseJson.put("savedSites", piJourneySites);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/saveSiteSequence/{journeyId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveSite(@PathVariable(value="journeyId") String journeyId, @RequestBody PiSite piSite) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        if (!PropertyValidator.isValid((Object)piSite)) {
            responseJson.put("success", false);
            responseJson.put("reason", "Invalid Input");
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        piSite = (PiSite)this.piSiteRepository.save((Object)piSite);
        PiJourney piJourney = this.piJourneyRepository.findById(journeyId);
        ArrayList piJourneySites = piJourney.getSites();
        if (PropertyValidator.isValid((Collection)piJourneySites)) {
            Collections.sort(piJourneySites, new /* Unavailable Anonymous Inner Class!! */);
            ((PiSite)piJourneySites.get(0)).setIsDefault(Boolean.valueOf(true));
        }
        this.piSiteRepository.save((Iterable)piJourneySites);
        for (PiSite site : piJourneySites) {
            TimeZone timeZone = TimeZone.getTimeZone(site.getTimeZone());
            if (timeZone.inDaylightTime(new Date())) {
                site.setUseDst(Boolean.valueOf(true));
                continue;
            }
            site.setUseDst(Boolean.valueOf(false));
        }
        responseJson.put("savedSites", piJourneySites);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/savePiDay/{journeyId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> savePiDay(@PathVariable(value="journeyId") String journeyId, @RequestBody PiDay inputDay) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        PiJourney journey = (PiJourney)this.piJourneyRepository.findOne((Serializable)((Object)journeyId));
        if (journey == null) {
            responseJson.put("success", false);
            responseJson.put("reason", "Invalid Input");
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        if (journey != null && journey.getDays().size() >= 7 && inputDay.getId() == null) {
            responseJson.put("success", false);
            responseJson.put("reason", "You cannot add more than 7 Planning days to your Planning agenda..");
            responseJson.put("days", journey.getDays());
            return new ResponseEntity(responseJson, HttpStatus.ACCEPTED);
        }
        if (inputDay.getId() == null) {
            inputDay.setPiJourneyId(journeyId);
            PiDay saveDay = (PiDay)this.piDayRepository.save((Object)inputDay);
            if (journey.getDays() == null) {
                journey.setDays(new ArrayList());
            }
            journey.getDays().add(saveDay);
            responseJson.put("day", saveDay);
            PiAgenda agenda = journey.getAgenda();
            PiAgendaDay agendaDay = new PiAgendaDay();
            agendaDay.setDay(saveDay);
            agendaDay.setEvents(new ArrayList());
            if (agenda.getPiAgendaDays() == null) {
                agenda.setPiAgendaDays(new ArrayList());
            }
            agendaDay = (PiAgendaDay)this.piAgendaDayRepository.save((Object)agendaDay);
            agenda.getPiAgendaDays().add(agendaDay);
            this.piAgendaRepository.save((Object)agenda);
            this.piJourneyRepository.save((Object)journey);
            this.userService.setOnboardingMeta("Start_Planning_Agenda", true);
            responseJson.put("agendaDay", agendaDay);
        } else {
            PiDay saveDay = (PiDay)this.piDayRepository.findOne((Serializable)((Object)inputDay.getId()));
            saveDay.setTitle(inputDay.getTitle());
            saveDay.setStartDate(inputDay.getStartDate());
            saveDay.setEndDate(inputDay.getEndDate());
            saveDay.setStartTime(inputDay.getStartTime());
            saveDay.setEndTime(inputDay.getEndTime());
            saveDay = (PiDay)this.piDayRepository.save((Object)saveDay);
            responseJson.put("day", saveDay);
        }
        responseJson.put("success", true);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/deletePiDay/{journeyId}/{dayId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> deletePiDay(@PathVariable(value="journeyId") String journeyId, @PathVariable(value="dayId") String dayId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        PiJourney journey = (PiJourney)this.piJourneyRepository.findOne((Serializable)((Object)journeyId));
        if (journey == null) {
            responseJson.put("success", false);
            responseJson.put("reason", "Invalid Input");
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        try {
            int index = -1;
            for (int i = 0; i < journey.getDays().size(); ++i) {
                if (!((PiDay)journey.getDays().get(i)).getId().equals(dayId)) continue;
                index = i;
                break;
            }
            if (index > -1) {
                journey.getDays().remove(index);
                this.piJourneyRepository.save((Object)journey);
                this.piDayRepository.delete((Serializable)((Object)dayId));
                PiAgenda agenda = journey.getAgenda();
                PiAgendaDay agendaDay = (PiAgendaDay)agenda.getPiAgendaDays().get(index);
                if (PropertyValidator.isValid((Collection)agendaDay.getEvents())) {
                    this.piJourneyEventRepository.delete((Iterable)agendaDay.getEvents());
                }
                this.piAgendaDayRepository.delete((Serializable)((Object)agendaDay.getId()));
                agenda.getPiAgendaDays().remove(index);
                this.piAgendaRepository.save((Object)agenda);
                responseJson.put("dayId", dayId);
                responseJson.put("success", true);
                return new ResponseEntity(responseJson, HttpStatus.OK);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        responseJson.put("success", false);
        responseJson.put("reason", "Invalid Input");
        return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
    }

    @RequestMapping(value={"/savePiSite/{journeyId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> savePiSite(@PathVariable(value="journeyId") String journeyId, @RequestBody PiSite inputSite) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        if (inputSite.getCountry() == null || inputSite.getTimeZone() == null) {
            responseJson.put("success", false);
            responseJson.put("reason", "Invalid Input");
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        PiJourney journey = (PiJourney)this.piJourneyRepository.findOne((Serializable)((Object)journeyId));
        if (journey == null) {
            responseJson.put("success", false);
            responseJson.put("reason", "Invalid Input");
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        if (inputSite.getId() == null) {
            inputSite.setPiJourneyId(journeyId);
            PiSite saveSite = (PiSite)this.piSiteRepository.save((Object)inputSite);
            if (journey.getSites() == null) {
                journey.setSites(new ArrayList());
            }
            journey.getSites().add(saveSite);
            this.piJourneyRepository.save((Object)journey);
            responseJson.put("site", saveSite);
        } else {
            PiSite saveSite = (PiSite)this.piSiteRepository.findOne((Serializable)((Object)inputSite.getId()));
            saveSite.setCountry(inputSite.getCountry());
            saveSite.setProvince(inputSite.getProvince());
            saveSite.setCity(inputSite.getCity());
            saveSite.setTimeZone(inputSite.getTimeZone());
            saveSite = (PiSite)this.piSiteRepository.save((Object)saveSite);
            responseJson.put("site", saveSite);
        }
        responseJson.put("success", true);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/deletePiSite/{journeyId}/{siteId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> deletePiSite(@PathVariable(value="journeyId") String journeyId, @PathVariable(value="siteId") String siteId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        PiJourney journey = (PiJourney)this.piJourneyRepository.findOne((Serializable)((Object)journeyId));
        if (journey == null) {
            responseJson.put("success", false);
            responseJson.put("reason", "Invalid Input");
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        try {
            int index = -1;
            for (int i = 0; i < journey.getSites().size(); ++i) {
                if (!((PiSite)journey.getSites().get(i)).getId().equals(siteId)) continue;
                index = i;
                break;
            }
            if (index > -1) {
                if (((PiSite)journey.getSites().get(index)).getIsDefault().booleanValue()) {
                    responseJson.put("success", false);
                    responseJson.put("reason", "Default");
                    return new ResponseEntity(responseJson, HttpStatus.OK);
                }
                journey.getSites().remove(index);
                this.piJourneyRepository.save((Object)journey);
                this.piSiteRepository.delete((Serializable)((Object)siteId));
                responseJson.put("siteId", siteId);
                responseJson.put("success", true);
                return new ResponseEntity(responseJson, HttpStatus.OK);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        responseJson.put("success", false);
        responseJson.put("reason", "Invalid Input");
        return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
    }

    @RequestMapping(value={"/getTimeZones"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> timeZones() {
        ArrayList<String> zones = new ArrayList<String>();
        for (String i : TimeZone.getAvailableIDs()) {
            zones.add(new Gson().toJson((Object)TimeZone.getTimeZone(i)));
        }
        return new ResponseEntity(zones, HttpStatus.OK);
    }

    @RequestMapping(value={"/getPiAgenda/{agendaId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getPiAgenda(@PathVariable(value="agendaId") String agendaId) {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        PiAgenda agenda = this.piJourneyService.getPiAgendaData(agendaId);
        responseJson.put("success", true);
        responseJson.put("agenda", (Boolean)agenda);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/public_share/getPiAgenda/{agendaId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getPiAgendaPublic(@PathVariable(value="agendaId") String agendaId) {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        PiAgenda agenda = this.piJourneyService.getPiAgendaData(agendaId);
        responseJson.put("success", true);
        responseJson.put("agenda", (Boolean)agenda);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/getPiAgendaDay/{agendaDayId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getPiAgendaDay(@PathVariable(value="agendaDayId") String agendaDayId) {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        PiAgendaDay agendaDay = (PiAgendaDay)this.piAgendaDayRepository.findOne((Serializable)((Object)agendaDayId));
        agendaDay.getEvents();
        responseJson.put("success", true);
        responseJson.put("agendaDay", (Boolean)agendaDay);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/savePiAgendaDay/{journeyId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> savePiEvent(@PathVariable(value="journeyId") String journeyId, @RequestBody PiAgendaDay inputAgendaDay) {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        PiAgendaDay savedAgendaDay = (PiAgendaDay)this.piAgendaDayRepository.findOne((Serializable)((Object)inputAgendaDay.getId()));
        ArrayList finalEvents = new ArrayList();
        ArrayList<PiJourneyEvent> eventsToAdd = new ArrayList<PiJourneyEvent>();
        ArrayList<PiJourneyEvent> eventsToDelete = new ArrayList<PiJourneyEvent>();
        ArrayList<PiJourneyEvent> eventsToUpdate = new ArrayList<PiJourneyEvent>();
        HashMap<String, PiJourneyEvent> inputEventsMap = new HashMap<String, PiJourneyEvent>();
        for (PiJourneyEvent event : inputAgendaDay.getEvents()) {
            if (event.getId() == null) {
                eventsToAdd.add(event);
                continue;
            }
            if (event.getRowStatus() == 1) {
                eventsToDelete.add(event);
                continue;
            }
            inputEventsMap.put(event.getId(), event);
        }
        for (PiJourneyEvent event : savedAgendaDay.getEvents()) {
            PiJourneyEvent inpuevent = (PiJourneyEvent)inputEventsMap.get(event.getId());
            if (PropertyValidator.isValid((Object)inpuevent)) {
                if (inpuevent.getRowStatus() != 0) continue;
                eventsToUpdate.add(inpuevent);
                continue;
            }
            eventsToUpdate.add(event);
        }
        this.piJourneyEventRepository.save(eventsToAdd);
        this.piJourneyEventRepository.save(eventsToUpdate);
        this.piJourneyEventRepository.delete(eventsToDelete);
        finalEvents.addAll(eventsToUpdate);
        finalEvents.addAll(eventsToAdd);
        savedAgendaDay.setEvents(finalEvents);
        savedAgendaDay = (PiAgendaDay)this.piAgendaDayRepository.save((Object)savedAgendaDay);
        responseJson.put("success", true);
        responseJson.put("agendaDay", (Boolean)savedAgendaDay);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/deletePiAgendaEvent/{journeyId}/{agendaDayId}/{eventId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<Object> deletePiAgendaEvent(@PathVariable(value="journeyId") String journeyId, @PathVariable(value="agendaDayId") String agendaDayId, @PathVariable(value="eventId") String eventId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        PiAgendaDay agendaDay = (PiAgendaDay)this.piAgendaDayRepository.findOne((Serializable)((Object)agendaDayId));
        PiJourneyEvent event = (PiJourneyEvent)this.piJourneyEventRepository.findOne((Serializable)((Object)eventId));
        if (PropertyValidator.isValid((Object)event)) {
            int index = -1;
            for (int i = 0; i < agendaDay.getEvents().size(); ++i) {
                PiJourneyEvent e = (PiJourneyEvent)agendaDay.getEvents().get(i);
                if (!e.getId().equals(event.getId())) continue;
                index = i;
                break;
            }
            if (index > -1) {
                agendaDay.getEvents().remove(index);
                agendaDay = (PiAgendaDay)this.piAgendaDayRepository.save((Object)agendaDay);
            }
            this.piJourneyEventRepository.delete((Object)event);
            responseJson.put("success", true);
            responseJson.put("agendaDayId", agendaDayId);
            responseJson.put("eventId", eventId);
        } else {
            responseJson.put("success", false);
            responseJson.put("reason", "NotFound");
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/savePiAgendaEvent/{journeyId}/{agendaDayId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> savePiEvent(@PathVariable(value="journeyId") String journeyId, @PathVariable(value="agendaDayId") String agendaDayId, @RequestBody HashMap<String, Object> reqbody) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        String fieldToEdit = (String)reqbody.get("field");
        String eventStr = (String)reqbody.get("event");
        ObjectMapper mapper = new ObjectMapper();
        PiJourneyEvent inputEvent = null;
        try {
            inputEvent = (PiJourneyEvent)mapper.readValue(eventStr, PiJourneyEvent.class);
        }
        catch (JsonParseException e) {
            LOGGER.error(e.getMessage());
        }
        catch (JsonMappingException e) {
            LOGGER.error(e.getMessage());
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage());
        }
        if (inputEvent == null) {
            responseJson.put("success", false);
            responseJson.put("reason", "EventNotFound");
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        if (PropertyValidator.isValid((Object)inputEvent.getId())) {
            PiJourneyEvent existingEvent = (PiJourneyEvent)this.piJourneyEventRepository.findOne((Serializable)((Object)inputEvent.getId()));
            if (fieldToEdit.equals("time")) {
                existingEvent.setStartTime(inputEvent.getStartTime());
                existingEvent.setEndTime(inputEvent.getEndTime());
            } else if (fieldToEdit.equals("event")) {
                existingEvent.setTitle(inputEvent.getTitle());
                existingEvent.setType(inputEvent.getType());
                existingEvent.setColor(inputEvent.getColor());
            } else if (fieldToEdit.equals("title")) {
                existingEvent.setTitle(inputEvent.getTitle());
            } else if (fieldToEdit.equals("description")) {
                Document.OutputSettings outputSettings = new Document.OutputSettings();
                outputSettings.prettyPrint(false);
                existingEvent.setDescription(Jsoup.clean((String)inputEvent.getDescription(), (String)"", (Whitelist)Whitelist.relaxed().addTags(new String[]{"<script>", "<html>", "<body>"}), (Document.OutputSettings)outputSettings));
            } else if (fieldToEdit.equals("attachments")) {
                existingEvent.setAttachments(inputEvent.getAttachments());
            } else if (fieldToEdit.equals("presenters")) {
                existingEvent.setPresenters(inputEvent.getPresenters());
            } else if (fieldToEdit.equals("rooms")) {
                existingEvent.setRooms(inputEvent.getRooms());
            }
            existingEvent.setPiJourneyId(journeyId);
            this.piJourneyEventRepository.save((Object)existingEvent);
            existingEvent = (PiJourneyEvent)this.piJourneyEventRepository.findOne((Serializable)((Object)existingEvent.getId()));
            responseJson.put("success", true);
            responseJson.put("isNew", false);
            responseJson.put("event", existingEvent);
        } else {
            inputEvent.setPiJourneyId(journeyId);
            inputEvent = (PiJourneyEvent)this.piJourneyEventRepository.save((Object)inputEvent);
            PiAgendaDay agendaDay = (PiAgendaDay)this.piAgendaDayRepository.findOne((Serializable)((Object)agendaDayId));
            if (agendaDay.getEvents() == null) {
                agendaDay.setEvents(new ArrayList());
            }
            agendaDay.getEvents().add(inputEvent);
            agendaDay = (PiAgendaDay)this.piAgendaDayRepository.save((Object)agendaDay);
            responseJson.put("success", true);
            responseJson.put("isNew", true);
            responseJson.put("event", inputEvent);
            responseJson.put("agendaDay", agendaDay);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/savePiEventTemplate"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> savePiEventTemplate(@RequestBody PiJourneyEventTemplate piJourneyEventTemplate) {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        if (piJourneyEventTemplate.getTitle() == null || piJourneyEventTemplate.getType() == null) {
            responseJson.put("success", false);
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        piJourneyEventTemplate = (PiJourneyEventTemplate)this.piJourneyEventTemplateRepository.save((Object)piJourneyEventTemplate);
        responseJson.put("success", true);
        responseJson.put("event", (Boolean)piJourneyEventTemplate);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/saveSystemRole"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveSystemRole(@RequestBody PiSystemRole inputPiSystemRole) {
        boolean isNew;
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        if (inputPiSystemRole.getTitle() == null) {
            responseJson.put("success", false);
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        PiSystemRole find = this.customRepository.findSystemRoleByTitle(inputPiSystemRole.getTitle());
        if (PropertyValidator.isValid((Object)find)) {
            responseJson.put("success", false);
            responseJson.put("reason", "AlreadyExist");
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        boolean bl = isNew = !PropertyValidator.isValid((Object)inputPiSystemRole.getId());
        if (!isNew && inputPiSystemRole.getIsSystem().booleanValue()) {
            responseJson.put("success", false);
            responseJson.put("reason", "SystemRole");
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        PiSystemRole newRole = (PiSystemRole)this.piSystemRoleRepository.save((Object)inputPiSystemRole);
        responseJson.put("success", true);
        responseJson.put("systemRole", newRole);
        responseJson.put("isNew", isNew);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/getPiEventTemplates"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getPiEventTemplates() {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        List eventTemplates = this.piJourneyEventTemplateRepository.findAll();
        if (!PropertyValidator.isValid((Collection)eventTemplates)) {
            eventTemplates = this.getDefaultEventTemplates();
            this.piJourneyEventTemplateRepository.save((Iterable)eventTemplates);
        }
        responseJson.put("success", true);
        responseJson.put("events", eventTemplates);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/getTeamCapacityData/{sessionId}/{sessionBoardId}/{journeyId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getTeamCapacityData(@PathVariable(value="sessionId") String sessionId, @PathVariable(value="sessionBoardId") String sessionBoardId, @PathVariable(value="journeyId") String journeyId) {
        HashMap<String, Serializable> responseJson = new HashMap<String, Serializable>();
        SessionBoard sessionBoard = this.sessionBoardRepository.findById(sessionBoardId);
        PiJourney piJourney = this.piJourneyRepository.findById(journeyId);
        List savedTeamsCapacity = this.piTeamCapacityRepository.findByPiJourneyIdAndSessionId(journeyId, sessionId);
        HashMap teamsCapacityMap = new HashMap();
        if (PropertyValidator.isValid((Collection)savedTeamsCapacity)) {
            savedTeamsCapacity.forEach(tc -> teamsCapacityMap.put(tc.getTeam().getId(), tc));
        }
        ArrayList<Object> teamsCapacity = new ArrayList<Object>();
        ArrayList<PiTeamCapacity> teamsCapacityToAdd = new ArrayList<PiTeamCapacity>();
        if (PropertyValidator.isValid((Collection)sessionBoard.getTeams())) {
            for (Team team : sessionBoard.getTeams()) {
                if (PropertyValidator.isValid(teamsCapacityMap.get(team.getId()))) {
                    teamsCapacity.add(teamsCapacityMap.get(team.getId()));
                    teamsCapacityMap.remove(team.getId());
                    continue;
                }
                PiTeamCapacity teamCapacity = new PiTeamCapacity();
                teamCapacity.setPiJourneyId(journeyId);
                teamCapacity.setSessionId(sessionId);
                teamCapacity.setTeam(team);
                teamCapacity.setSites(new ArrayList());
                teamCapacity.setUsersCapacity(new ArrayList());
                teamsCapacityToAdd.add(teamCapacity);
            }
        }
        if (PropertyValidator.isValid(teamsCapacityToAdd)) {
            this.piTeamCapacityRepository.save(teamsCapacityToAdd);
            teamsCapacity.addAll(teamsCapacityToAdd);
        }
        ArrayList teamsCapacityToDelete = new ArrayList();
        for (String teamId : teamsCapacityMap.keySet()) {
            teamsCapacityToDelete.add(teamsCapacityMap.get(teamId));
        }
        responseJson.put("success", Boolean.valueOf(true));
        responseJson.put("sessionBoard", (Serializable)sessionBoard);
        responseJson.put("teamsCapacity", teamsCapacity);
        responseJson.put("defaultUserCapacity", piJourney.getDefaultUserCapacity());
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/getTeamCapacityForTeam/{teamCapacityId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getTeamCapacityForTeam(@PathVariable(value="teamCapacityId") String teamCapacityId) {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        PiTeamCapacity teamCapacity = this.piTeamCapacityRepository.findById(teamCapacityId);
        responseJson.put("success", true);
        responseJson.put("teamCapacity", (Boolean)teamCapacity);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/getProgramRoleData/{sessionId}/{sessionBoardId}/{journeyId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getProgramRoleData(@PathVariable(value="sessionId") String sessionId, @PathVariable(value="sessionBoardId") String sessionBoardId, @PathVariable(value="journeyId") String journeyId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        SessionBoard sessionBoard = this.sessionBoardRepository.findById(sessionBoardId);
        List programRoles = this.piProgramRoleRepository.findByPiJourneyId(journeyId);
        responseJson.put("success", true);
        responseJson.put("sessionBoard", sessionBoard);
        responseJson.put("programRoles", programRoles);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/saveSiteInTeamCapacity/{teamCapacityId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveTeamCapacitySite(@RequestBody PiSite piSite, @PathVariable(value="teamCapacityId") String teamCapacityId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        if (!PropertyValidator.isValid((Object)piSite) || !PropertyValidator.isValid((Object)teamCapacityId)) {
            responseJson.put("success", false);
            responseJson.put("reason", "Invalid Input");
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        PiTeamCapacity piTeamCapacity = this.piTeamCapacityRepository.findById(teamCapacityId);
        if (PropertyValidator.isValid((Collection)piTeamCapacity.getSites()) && piTeamCapacity.getSites().size() >= 10) {
            responseJson.put("success", false);
            responseJson.put("reason", "LimitExceed");
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        piSite.setDstSavings(TimeZone.getTimeZone(piSite.getTimeZone()).getDSTSavings());
        piSite.setRawOffset(TimeZone.getTimeZone(piSite.getTimeZone()).getRawOffset());
        piSite = (PiSite)this.piSiteRepository.save((Object)piSite);
        ArrayList teamCapacitySites = piTeamCapacity.getSites();
        teamCapacitySites.add(piSite);
        piTeamCapacity.setSites(teamCapacitySites);
        this.piTeamCapacityRepository.save((Object)piTeamCapacity);
        responseJson.put("success", true);
        responseJson.put("savedSites", teamCapacitySites);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/deletePiSiteForTeamCapacity/{teamCapacityId}/{siteId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<Object> deletePiSiteForTeamCapacity(@PathVariable(value="teamCapacityId") String teamCapacityId, @PathVariable(value="siteId") String siteId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        PiTeamCapacity piTeamCapacity = this.piTeamCapacityRepository.findById(teamCapacityId);
        if (piTeamCapacity == null) {
            responseJson.put("success", false);
            responseJson.put("reason", "Invalid Input");
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        try {
            int index = -1;
            for (int i = 0; i < piTeamCapacity.getSites().size(); ++i) {
                if (!((PiSite)piTeamCapacity.getSites().get(i)).getId().equals(siteId)) continue;
                index = i;
                break;
            }
            if (index > -1) {
                piTeamCapacity.getSites().remove(index);
                ArrayList<PiUserCapacity> usersCapacity = new ArrayList<PiUserCapacity>();
                if (PropertyValidator.isValid((Collection)piTeamCapacity.getUsersCapacity())) {
                    for (PiUserCapacity uc : piTeamCapacity.getUsersCapacity()) {
                        if (!PropertyValidator.isValid((Object)uc.getSite()) || !uc.getSite().getId().equals(siteId)) continue;
                        uc.setSite(null);
                        usersCapacity.add(uc);
                    }
                }
                if (PropertyValidator.isValid(usersCapacity)) {
                    this.piUserCapacityRepository.save(usersCapacity);
                }
                this.piTeamCapacityRepository.save((Object)piTeamCapacity);
                this.piSiteRepository.delete((Serializable)((Object)siteId));
                responseJson.put("siteId", siteId);
                responseJson.put("success", true);
                return new ResponseEntity(responseJson, HttpStatus.OK);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        responseJson.put("success", false);
        responseJson.put("reason", "Invalid Input");
        return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
    }

    @RequestMapping(value={"/saveProgramRole"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveProgramRole(@RequestBody PiProgramRole inputPiProgramRole) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        if (inputPiProgramRole.getPiJourneyId() == null || inputPiProgramRole.getUser() == null || inputPiProgramRole.getSystemRole() == null) {
            responseJson.put("success", false);
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        List find = this.piProgramRoleRepository.findBySystemRoleAndUserAndPiJourneyId(inputPiProgramRole.getSystemRole(), inputPiProgramRole.getUser(), inputPiProgramRole.getPiJourneyId());
        if (PropertyValidator.isValid((Collection)find) && (find.size() > 1 || ((PiProgramRole)find.get(0)).getTeamId() == null)) {
            responseJson.put("success", false);
            responseJson.put("reason", "AlreadyExist");
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        PiProgramRole newRole = (PiProgramRole)this.piProgramRoleRepository.save((Object)inputPiProgramRole);
        newRole.getUser();
        newRole.getSystemRole();
        responseJson.put("success", true);
        responseJson.put("programRole", newRole);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/deleteProgramRole"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<Object> deleteProgramRole(@RequestBody PiProgramRole inputPiProgramRole) {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        this.piProgramRoleRepository.delete((Object)inputPiProgramRole);
        responseJson.put("success", true);
        responseJson.put("programRole", (Boolean)inputPiProgramRole);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/saveTeamRole"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveTeamRole(@RequestBody PiProgramRole inputPiProgramRole) {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        if (inputPiProgramRole.getPiJourneyId() == null || inputPiProgramRole.getTeamId() == null || inputPiProgramRole.getSystemRole() == null) {
            responseJson.put("success", false);
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        responseJson.put("isNew", true);
        PiProgramRole find = this.piProgramRoleRepository.findBySystemRoleAndTeamIdAndPiJourneyId(inputPiProgramRole.getSystemRole(), inputPiProgramRole.getTeamId(), inputPiProgramRole.getPiJourneyId());
        if (PropertyValidator.isValid((Object)find)) {
            inputPiProgramRole.setId(find.getId());
            responseJson.put("isNew", false);
        }
        PiProgramRole newRole = (PiProgramRole)this.piProgramRoleRepository.save((Object)inputPiProgramRole);
        newRole.getUser();
        newRole.getSystemRole();
        responseJson.put("success", true);
        responseJson.put("teamRole", (Boolean)newRole);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/deleteTeamRole"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<Object> deleteTeamRole(@RequestBody PiProgramRole inputPiProgramRole) {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        this.piProgramRoleRepository.delete((Object)inputPiProgramRole);
        responseJson.put("success", true);
        responseJson.put("programRole", (Boolean)inputPiProgramRole);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/setDefaultUserCapacity/{journeyId}"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseEntity<Object> setDefaultUserCapacity(@PathVariable(value="journeyId") String journeyId, @RequestBody HashMap<String, Float> payload) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        Float capacityValue = payload.get("capacity");
        PiJourney piJoureny = this.piJourneyRepository.findById(journeyId);
        piJoureny.setDefaultUserCapacity(capacityValue);
        this.piJourneyRepository.save((Object)piJoureny);
        responseJson.put("success", true);
        responseJson.put("capacity", String.valueOf(capacityValue));
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/addUserInTeamCapacity/{sessionBoardId}/{journeyId}/{teamCapacityId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> addUserInTeamCapacity(@PathVariable(value="sessionBoardId") String sessionBoardId, @PathVariable(value="journeyId") String journeyId, @PathVariable(value="teamCapacityId") String teamCapacityId, @RequestBody PiUserCapacity inputPiUserCapacity) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        if (inputPiUserCapacity.getPiJourneyId() == null || inputPiUserCapacity.getUser() == null || inputPiUserCapacity.getTeamId() == null) {
            responseJson.put("success", false);
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        PiUserCapacity find = this.piUserCapacityRepository.findByPiJourneyIdAndSessionBoardIdAndTeamIdAndUserAndSystemRole(journeyId, sessionBoardId, inputPiUserCapacity.getTeamId(), inputPiUserCapacity.getUser(), inputPiUserCapacity.getSystemRole());
        if (PropertyValidator.isValid((Object)find)) {
            responseJson.put("success", false);
            responseJson.put("reason", "AlreadyExist");
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        PiJourney piJoureny = this.piJourneyRepository.findById(journeyId);
        PiTeamCapacity teamCapacity = (PiTeamCapacity)this.piTeamCapacityRepository.findOne((Serializable)((Object)teamCapacityId));
        SessionBoard sessionBoard = this.sessionBoardRepository.findById(sessionBoardId);
        inputPiUserCapacity.setPiJourneyId(journeyId);
        inputPiUserCapacity.setSessionBoardId(sessionBoardId);
        if (PropertyValidator.isValid((Collection)sessionBoard.getContainers())) {
            ArrayList<PiContainerCapacity> containersCapacity = new ArrayList<PiContainerCapacity>();
            for (Container container : sessionBoard.getContainers()) {
                PiContainerCapacity containerCapacity = new PiContainerCapacity();
                String containerId = container.getOriginItemId();
                if (containerId == null) {
                    containerId = container.getId();
                }
                containerCapacity.setContainerId(containerId);
                containerCapacity.setCapacity(piJoureny.getDefaultUserCapacity());
                containersCapacity.add(containerCapacity);
            }
            inputPiUserCapacity.setContainersCapacity(containersCapacity);
        }
        if (teamCapacity.getUsersCapacity() == null) {
            teamCapacity.setUsersCapacity(new ArrayList());
        }
        inputPiUserCapacity = (PiUserCapacity)this.piUserCapacityRepository.save((Object)inputPiUserCapacity);
        teamCapacity.getUsersCapacity().add(inputPiUserCapacity);
        teamCapacity = (PiTeamCapacity)this.piTeamCapacityRepository.save((Object)teamCapacity);
        Session session = sessionBoard.getSession();
        SessionBoard activeSessionBoard = this.sessionBoardRepository.findById(session.getActiveSessionBoard());
        ArrayList sprintVelocities = this.updateTeamCapacity(teamCapacity, null, activeSessionBoard, inputPiUserCapacity.getMetaMap());
        responseJson.put("success", true);
        responseJson.put("teamCapacity", teamCapacity);
        responseJson.put("teamSprintVelocities", sprintVelocities);
        responseJson.put("userCapacity", inputPiUserCapacity);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    private ArrayList<TeamSprintVelocity> updateTeamCapacity(PiTeamCapacity teamCapacity, PiContainerCapacity containerCapacity, SessionBoard activeSessionBoard, String metaMap) {
        HashMap<String, ArrayList<PiContainerCapacity>> piContainersCapacityMap = new HashMap<String, ArrayList<PiContainerCapacity>>();
        if (PropertyValidator.isValid((Collection)teamCapacity.getUsersCapacity())) {
            for (PiUserCapacity uc : teamCapacity.getUsersCapacity()) {
                if (!PropertyValidator.isValid((Collection)uc.getContainersCapacity())) continue;
                for (PiContainerCapacity cc : uc.getContainersCapacity()) {
                    if (containerCapacity != null && (containerCapacity == null || !containerCapacity.getContainerId().equals(cc.getContainerId()))) continue;
                    ArrayList<PiContainerCapacity> array = (ArrayList<PiContainerCapacity>)piContainersCapacityMap.get(cc.getContainerId());
                    if (array == null) {
                        array = new ArrayList<PiContainerCapacity>();
                        piContainersCapacityMap.put(cc.getContainerId(), array);
                    }
                    array.add(cc);
                }
            }
        }
        ArrayList<TeamSprintVelocity> sprintVelocities = this.teamSprintVelocityRepository.findBySessionBoardIdAndTeamId(activeSessionBoard.getId(), teamCapacity.getTeam().getId());
        HashMap<String, TeamSprintVelocity> sprintVelocityMap = new HashMap<String, TeamSprintVelocity>();
        if (PropertyValidator.isValid((Collection)sprintVelocities)) {
            for (TeamSprintVelocity tsv : sprintVelocities) {
                sprintVelocityMap.put(tsv.getSprintId(), tsv);
            }
        }
        if (sprintVelocities == null) {
            sprintVelocities = new ArrayList<TeamSprintVelocity>();
        }
        if (PropertyValidator.isValid((Collection)activeSessionBoard.getContainers())) {
            for (Container container : activeSessionBoard.getContainers()) {
                String containerId = container.getOriginItemId();
                if (containerId == null) {
                    containerId = container.getId();
                }
                if (containerCapacity != null && (containerCapacity == null || !containerCapacity.getContainerId().equals(containerId))) continue;
                TeamSprintVelocity tsv = (TeamSprintVelocity)sprintVelocityMap.get(container.getId());
                if (tsv == null) {
                    tsv = new TeamSprintVelocity();
                    tsv.setSprintId(container.getId());
                    tsv.setTeamId(teamCapacity.getTeam().getId());
                    tsv.setVelocity(Double.valueOf(0.0));
                    tsv.setSessionBoardId(activeSessionBoard.getId());
                }
                tsv.setAutoUpdate(Boolean.valueOf(true));
                tsv.setManualUpdate(Boolean.valueOf(false));
                sprintVelocities.add(tsv);
                double valocity = 0.0;
                ArrayList ccArray = (ArrayList)piContainersCapacityMap.get(containerId);
                if (PropertyValidator.isValid((Collection)ccArray)) {
                    for (PiContainerCapacity cc : ccArray) {
                        if (cc.getCapacity() == null) continue;
                        valocity += (double)cc.getCapacity().floatValue();
                    }
                }
                tsv.setVelocity(Double.valueOf(valocity));
            }
        }
        this.teamSprintVelocityRepository.save(sprintVelocities);
        if (PropertyValidator.isValid((Collection)activeSessionBoard.getTeams())) {
            String cid = UserContextUtil.getUserContext().getCurrentCompany().getId();
            String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
            new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        }
        return sprintVelocities;
    }

    @RequestMapping(value={"/removeUserFromTeamCapacity/{sessionId}/{teamCapacityId}/{userCapacityId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> removeUserFromTeamCapacity(@PathVariable(value="sessionId") String sessionId, @PathVariable(value="teamCapacityId") String teamCapacityId, @PathVariable(value="userCapacityId") String userCapacityId, @RequestBody Map<String, Object> params) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        PiTeamCapacity teamCapacity = (PiTeamCapacity)this.piTeamCapacityRepository.findOne((Serializable)((Object)teamCapacityId));
        if (teamCapacity == null) {
            responseJson.put("success", false);
            responseJson.put("reason", "TeamCapacityNotFound");
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        int index = -1;
        if (PropertyValidator.isValid((Collection)teamCapacity.getUsersCapacity())) {
            for (int i = 0; i < teamCapacity.getUsersCapacity().size(); ++i) {
                PiUserCapacity uc = (PiUserCapacity)teamCapacity.getUsersCapacity().get(i);
                if (!uc.getId().equals(userCapacityId)) continue;
                index = i;
                break;
            }
        }
        if (index > -1) {
            teamCapacity.getUsersCapacity().remove(index);
            this.piTeamCapacityRepository.save((Object)teamCapacity);
            this.piUserCapacityRepository.delete((Serializable)((Object)userCapacityId));
            Session session = this.sessionRepository.findById(sessionId);
            SessionBoard activeSessionBoard = this.sessionBoardRepository.findById(session.getActiveSessionBoard());
            ArrayList sprintVelocities = this.updateTeamCapacity(teamCapacity, null, activeSessionBoard, (String)params.get("metaMap"));
            responseJson.put("success", true);
            responseJson.put("teamSprintVelocities", sprintVelocities);
            responseJson.put("userCapacityId", userCapacityId);
        } else {
            responseJson.put("success", false);
            responseJson.put("reason", "NotFound");
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/updateUserCapacity/{sessionId}/{teamCapacityId}/{userCapacityId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> updateUserCapacity(@PathVariable(value="sessionId") String sessionId, @PathVariable(value="teamCapacityId") String teamCapacityId, @PathVariable(value="userCapacityId") String userCapacityId, @RequestBody PiContainerCapacity inputPiContainerCapacity) {
        HashMap<String, Serializable> responseJson = new HashMap<String, Serializable>();
        PiUserCapacity userCapacity = (PiUserCapacity)this.piUserCapacityRepository.findOne((Serializable)((Object)userCapacityId));
        if (!PropertyValidator.isValid((Collection)userCapacity.getContainersCapacity())) {
            userCapacity.setContainersCapacity(new ArrayList());
        }
        int index = -1;
        for (int i = 0; i < userCapacity.getContainersCapacity().size(); ++i) {
            PiContainerCapacity containerCapacity = (PiContainerCapacity)userCapacity.getContainersCapacity().get(i);
            if (!containerCapacity.getContainerId().equals(inputPiContainerCapacity.getContainerId())) continue;
            index = i;
            break;
        }
        if (index > -1) {
            ((PiContainerCapacity)userCapacity.getContainersCapacity().get(index)).setCapacity(inputPiContainerCapacity.getCapacity());
        } else {
            userCapacity.getContainersCapacity().add(inputPiContainerCapacity);
        }
        this.piUserCapacityRepository.save((Object)userCapacity);
        PiTeamCapacity teamCapacity = this.piTeamCapacityRepository.findById(teamCapacityId);
        Session session = this.sessionRepository.findById(sessionId);
        SessionBoard activeSessionBoard = this.sessionBoardRepository.findById(session.getActiveSessionBoard());
        ArrayList sprintVelocities = this.updateTeamCapacity(teamCapacity, inputPiContainerCapacity, activeSessionBoard, inputPiContainerCapacity.getMetaMap());
        responseJson.put("success", Boolean.valueOf(true));
        responseJson.put("containerCapacity", (Serializable)inputPiContainerCapacity);
        responseJson.put("teamSprintVelocities", sprintVelocities);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/saveTeamBreakoutEvent/{journeyId}/{agendaDayId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveTeamBreakout(@PathVariable(value="journeyId") String journeyId, @PathVariable(value="agendaDayId") String agendaDayId, @RequestBody PiJourneyEvent inputPiJourneyEvent) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        if (inputPiJourneyEvent.getPiJourneyId() == null || !PropertyValidator.isValid((Object)inputPiJourneyEvent.getTitle())) {
            responseJson.put("success", false);
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        boolean isNew = !PropertyValidator.isValid((Object)inputPiJourneyEvent.getId());
        inputPiJourneyEvent.setType("breakout");
        inputPiJourneyEvent.setPiJourneyId(journeyId);
        if (isNew) {
            inputPiJourneyEvent = (PiJourneyEvent)this.piJourneyEventRepository.save((Object)inputPiJourneyEvent);
            PiAgendaDay agendaDay = (PiAgendaDay)this.piAgendaDayRepository.findOne((Serializable)((Object)agendaDayId));
            if (agendaDay.getEvents() == null) {
                agendaDay.setEvents(new ArrayList());
            }
            agendaDay.getEvents().add(inputPiJourneyEvent);
            this.piAgendaDayRepository.save((Object)agendaDay);
        } else {
            PiJourneyEvent existingBreakoutEvent = (PiJourneyEvent)this.piJourneyEventRepository.findOne((Serializable)((Object)inputPiJourneyEvent.getId()));
            existingBreakoutEvent.setTitle(inputPiJourneyEvent.getTitle());
            existingBreakoutEvent.setStartTime(inputPiJourneyEvent.getStartTime());
            existingBreakoutEvent.setEndTime(inputPiJourneyEvent.getEndTime());
            existingBreakoutEvent.setExcludeLocations(inputPiJourneyEvent.getExcludeLocations());
            inputPiJourneyEvent = (PiJourneyEvent)this.piJourneyEventRepository.save((Object)existingBreakoutEvent);
        }
        responseJson.put("success", true);
        responseJson.put("isNew", isNew);
        responseJson.put("teamBreakoutEvent", inputPiJourneyEvent);
        responseJson.put("agendaDayId", agendaDayId);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/removeTeamBreakoutEvent/{agendaDayId}/{breakoutEventId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<Object> removeTeamBreakout(@PathVariable(value="agendaDayId") String agendaDayId, @PathVariable(value="breakoutEventId") String breakoutEventId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        PiAgendaDay agendaDay = (PiAgendaDay)this.piAgendaDayRepository.findOne((Serializable)((Object)agendaDayId));
        int index = -1;
        for (int i = 0; i < agendaDay.getEvents().size(); ++i) {
            PiJourneyEvent breakoutEvent = (PiJourneyEvent)agendaDay.getEvents().get(i);
            if (!breakoutEvent.getId().equals(breakoutEventId)) continue;
            index = i;
        }
        if (index > -1) {
            agendaDay.getEvents().remove(index);
            this.piAgendaDayRepository.save((Object)agendaDay);
            this.piJourneyEventRepository.delete((Serializable)((Object)breakoutEventId));
            responseJson.put("success", true);
            responseJson.put("agendaDayId", agendaDayId);
            responseJson.put("teamBreakoutEventId", breakoutEventId);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        responseJson.put("success", false);
        responseJson.put("reason", "NotFound");
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/addTeamInTeamBreakoutEvent/{breakoutEventId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> addTeamInTeamBreakout(@PathVariable(value="breakoutEventId") String breakoutEventId, @RequestBody PiTeamBreakoutTeam inputPiTeamBreakoutTeam) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        if (inputPiTeamBreakoutTeam.getTeamId() == null || !PropertyValidator.isValid((Object)inputPiTeamBreakoutTeam.getStartTime()) || !PropertyValidator.isValid((Object)inputPiTeamBreakoutTeam.getEndTime())) {
            responseJson.put("success", false);
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        PiJourneyEvent teamBreakoutEvent = (PiJourneyEvent)this.piJourneyEventRepository.findOne((Serializable)((Object)breakoutEventId));
        if (teamBreakoutEvent.getTeams() == null) {
            teamBreakoutEvent.setTeams(new ArrayList());
        }
        for (int i = 0; i < teamBreakoutEvent.getTeams().size(); ++i) {
            PiTeamBreakoutTeam team = (PiTeamBreakoutTeam)teamBreakoutEvent.getTeams().get(i);
            if (!team.getTeamId().equals(inputPiTeamBreakoutTeam.getTeamId())) continue;
            responseJson.put("success", false);
            responseJson.put("reason", "AlreadyExist");
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        teamBreakoutEvent.getTeams().add(inputPiTeamBreakoutTeam);
        this.piJourneyEventRepository.save((Object)teamBreakoutEvent);
        responseJson.put("success", true);
        responseJson.put("teamBreakoutEvent", teamBreakoutEvent);
        responseJson.put("teamBreakoutTeam", inputPiTeamBreakoutTeam);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/updateTeamInTeamBreakoutEvent/{breakoutEventId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> updateTeamInTeamBreakout(@PathVariable(value="breakoutEventId") String breakoutEventId, @RequestBody PiTeamBreakoutTeam inputPiTeamBreakoutTeam) {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        if (!(inputPiTeamBreakoutTeam.getTeamId() != null && PropertyValidator.isValid((Object)inputPiTeamBreakoutTeam.getStartTime()) && PropertyValidator.isValid((Object)inputPiTeamBreakoutTeam.getEndTime()) && PropertyValidator.isValid((Object)inputPiTeamBreakoutTeam.getRoom()))) {
            responseJson.put("success", false);
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        PiJourneyEvent teamBreakoutEvent = (PiJourneyEvent)this.piJourneyEventRepository.findOne((Serializable)((Object)breakoutEventId));
        for (int i = 0; i < teamBreakoutEvent.getTeams().size(); ++i) {
            PiTeamBreakoutTeam team = (PiTeamBreakoutTeam)teamBreakoutEvent.getTeams().get(i);
            if (!team.getTeamId().equals(inputPiTeamBreakoutTeam.getTeamId())) continue;
            team.setStartDate(inputPiTeamBreakoutTeam.getStartDate());
            team.setEndDate(inputPiTeamBreakoutTeam.getEndDate());
            team.setStartTime(inputPiTeamBreakoutTeam.getStartTime());
            team.setEndTime(inputPiTeamBreakoutTeam.getEndTime());
            team.setRoom(inputPiTeamBreakoutTeam.getRoom());
        }
        this.piJourneyEventRepository.save((Object)teamBreakoutEvent);
        responseJson.put("success", true);
        responseJson.put("teamBreakoutEvent", (Boolean)teamBreakoutEvent);
        responseJson.put("teamBreakoutTeam", (Boolean)inputPiTeamBreakoutTeam);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/removeTeamInTeamBreakoutEvent/{breakoutEventId}/{teamId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<Object> removeTeamInTeamBreakoutEvent(@PathVariable(value="breakoutEventId") String breakoutEventId, @PathVariable(value="teamId") String teamId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        PiJourneyEvent teamBreakoutEvent = (PiJourneyEvent)this.piJourneyEventRepository.findOne((Serializable)((Object)breakoutEventId));
        int index = -1;
        for (int i = 0; i < teamBreakoutEvent.getTeams().size(); ++i) {
            PiTeamBreakoutTeam team = (PiTeamBreakoutTeam)teamBreakoutEvent.getTeams().get(i);
            if (!team.getTeamId().equals(teamId)) continue;
            index = i;
        }
        if (index > -1) {
            teamBreakoutEvent.getTeams().remove(index);
            this.piJourneyEventRepository.save((Object)teamBreakoutEvent);
            responseJson.put("success", true);
            responseJson.put("teamBreakoutEventId", breakoutEventId);
            responseJson.put("teamId", teamId);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        responseJson.put("success", false);
        responseJson.put("reason", "NotFound");
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/deleteBreakOutRoom/{breakoutEventId}/{teamId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> deleteBreakOutRoom(@PathVariable(value="breakoutEventId") String breakoutEventId, @PathVariable(value="teamId") String teamId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        PiJourneyEvent teamBreakoutEvent = (PiJourneyEvent)this.piJourneyEventRepository.findOne((Serializable)((Object)breakoutEventId));
        for (int i = 0; i < teamBreakoutEvent.getTeams().size(); ++i) {
            PiTeamBreakoutTeam team = (PiTeamBreakoutTeam)teamBreakoutEvent.getTeams().get(i);
            if (!team.getTeamId().equals(teamId)) continue;
            team.setRoom(null);
            this.piJourneyEventRepository.save((Object)teamBreakoutEvent);
            responseJson.put("success", true);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        responseJson.put("success", false);
        responseJson.put("reason", "NotFound");
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/editBreakOutTime/{breakoutEventId}/{teamId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> editBreakOutTime(@RequestBody HashMap<String, Object> requestBody, @PathVariable(value="breakoutEventId") String breakoutEventId, @PathVariable(value="teamId") String teamId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        PiJourneyEvent teamBreakoutEvent = (PiJourneyEvent)this.piJourneyEventRepository.findOne((Serializable)((Object)breakoutEventId));
        for (int i = 0; i < teamBreakoutEvent.getTeams().size(); ++i) {
            PiTeamBreakoutTeam team = (PiTeamBreakoutTeam)teamBreakoutEvent.getTeams().get(i);
            if (!team.getTeamId().equals(teamId)) continue;
            Float startTime = Float.valueOf(Float.parseFloat((String)requestBody.get("startTime")));
            Float endTime = Float.valueOf(Float.parseFloat((String)requestBody.get("endTime")));
            team.setStartTime(startTime);
            team.setEndTime(endTime);
            this.piJourneyEventRepository.save((Object)teamBreakoutEvent);
            responseJson.put("success", true);
            responseJson.put("startTime", startTime);
            responseJson.put("endTime", endTime);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        responseJson.put("success", false);
        responseJson.put("reason", "NotFound");
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/saveSetupEvent/{piJourneyId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveSetupEvent(@PathVariable(value="piJourneyId") String piJourneyId, @RequestBody PiJourneyEvent inputPiJourneyEvent) {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        if (!(PropertyValidator.isValid((Object)inputPiJourneyEvent.getTitle()) && PropertyValidator.isValid((Object)inputPiJourneyEvent.getPiJourneyId()) && PropertyValidator.isValid((Object)inputPiJourneyEvent.getType()))) {
            responseJson.put("success", false);
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        inputPiJourneyEvent.setPiJourneyId(piJourneyId);
        inputPiJourneyEvent.setCategory("setup");
        if (PropertyValidator.isValid((Object)inputPiJourneyEvent.getId())) {
            responseJson.put("isNew", false);
        } else {
            responseJson.put("isNew", true);
        }
        inputPiJourneyEvent = (PiJourneyEvent)this.piJourneyEventRepository.save((Object)inputPiJourneyEvent);
        responseJson.put("success", true);
        responseJson.put("journeyEvent", (Boolean)inputPiJourneyEvent);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/updateSprintDates"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> updateSprintDates(@RequestBody Container inputContainer) {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        Container container = (Container)this.containerRepository.findOne((Serializable)((Object)inputContainer.getId()));
        container.setStartDate(inputContainer.getStartDate());
        container.setEndDate(inputContainer.getEndDate());
        container = (Container)this.containerRepository.save((Object)container);
        responseJson.put("success", true);
        responseJson.put("container", (Boolean)container);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/deleteSetupEvent/{piJourneyId}/{eventId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<Object> deleteSetupEvent(@PathVariable(value="piJourneyId") String piJourneyId, @PathVariable(value="eventId") String eventId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        this.piJourneyEventRepository.delete((Serializable)((Object)eventId));
        responseJson.put("success", true);
        responseJson.put("eventId", eventId);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/getSetupEvents/{piJourneyId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getSetupEvents(@PathVariable(value="piJourneyId") String piJourneyId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        responseJson.put("success", true);
        List events = this.piJourneyEventRepository.findByPiJourneyIdAndCategory(piJourneyId, "setup");
        responseJson.put("events", events);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/updateUserCapacityFields/{userCapacityId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> updateUserCapacityFields(@PathVariable(value="userCapacityId") String userCapacityId, @RequestBody HashMap<String, String> requestBody) {
        try {
            HashMap<String, Object> responseJson = new HashMap<String, Object>();
            PiUserCapacity userCapacity = (PiUserCapacity)this.piUserCapacityRepository.findOne((Serializable)((Object)userCapacityId));
            String field = requestBody.get("field");
            String teamId = requestBody.get("teamId");
            String valueStr = requestBody.get("value");
            String userStr = requestBody.get("user");
            String sessionBoardId = requestBody.get("sessionId");
            Gson g = new Gson();
            6 SR = new /* Unavailable Anonymous Inner Class!! */;
            7 U = new /* Unavailable Anonymous Inner Class!! */;
            User user = (User)g.fromJson(userStr, U.getType());
            PiSite value = null;
            if (field.equals("role")) {
                if (valueStr == null) {
                    userCapacity.setSystemRole(null);
                } else {
                    PiSystemRole systemRole = (PiSystemRole)g.fromJson(valueStr, SR.getType());
                    PiUserCapacity find = this.piUserCapacityRepository.findByTeamIdAndSystemRoleAndSessionBoardIdAndUser(teamId, systemRole, sessionBoardId, user);
                    if (PropertyValidator.isValid((Object)find)) {
                        responseJson.put("success", false);
                        return new ResponseEntity(responseJson, HttpStatus.OK);
                    }
                    userCapacity.setSystemRole(systemRole);
                    value = systemRole;
                }
            } else if (field.equals("site")) {
                if (valueStr == null) {
                    userCapacity.setSite(null);
                } else {
                    8 S = new /* Unavailable Anonymous Inner Class!! */;
                    PiSite site = (PiSite)g.fromJson(valueStr, S.getType());
                    userCapacity.setSite(site);
                    value = site;
                }
            }
            this.piUserCapacityRepository.save((Object)userCapacity);
            responseJson.put("success", true);
            responseJson.put("feild", field);
            responseJson.put("value", value);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(e.getStackTrace().toString());
            return new ResponseEntity(HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/getTeams/{sessionId}/{sessionBoardId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getTeams(@PathVariable(value="sessionId") String sessionId, @PathVariable(value="sessionBoardId") String sessionBoardId) {
        SessionBoard currentSessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardId));
        List teamList = currentSessionBoard.getTeams();
        return new ResponseEntity((Object)teamList, HttpStatus.OK);
    }

    @RequestMapping(value={"/savePiSos/{sessionBoardId}/{sessionId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> savePiSos(@RequestBody PiSos inputSos, @PathVariable(value="sessionBoardId") String sessionBoardId, @PathVariable(value="sessionId") String sessionId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        HashMap<String, Object> pushJson = new HashMap<String, Object>();
        if (inputSos.getSessionId().equals("") || inputSos.getTitle().equals("")) {
            responseJson.put("success", false);
            responseJson.put("reason", "Invalid Input");
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        if (PropertyValidator.isValid((Object)inputSos.getId())) {
            PiSos savedSos = this.piSosRepository.findById(inputSos.getId());
            savedSos.setTitle(inputSos.getTitle());
            savedSos.setRoomLink(inputSos.getRoomLink());
            savedSos.setRoomTitle(inputSos.getRoomTitle());
            savedSos.setStartDate(inputSos.getStartDate());
            savedSos.setStartTime(inputSos.getStartTime());
            savedSos.setEndDate(inputSos.getEndDate());
            savedSos.setEndTime(inputSos.getEndTime());
            savedSos.setSessionId(inputSos.getSessionId());
            savedSos.setPiJourneyId(inputSos.getPiJourneyId());
            savedSos = (PiSos)this.piSosRepository.save((Object)savedSos);
            responseJson.put("sos", savedSos);
            pushJson.put("sos", savedSos);
            pushJson.put("metaMap", "{\"event\":\"sosSave\", \"type\":\"sos\", \"syncId\":\"" + savedSos.getMetaMap() + "\", \"sessionId\":\"" + sessionId + "\"}");
        } else {
            List existingSos = this.piSosRepository.findBySessionId(inputSos.getSessionId());
            if (existingSos.size() < 7) {
                List answerTemplate = this.answerTemplateRepository.findByName("Sos");
                AnswerTemplate at = new AnswerTemplate();
                at = answerTemplate.isEmpty() ? this.setAnswerTemplate() : (AnswerTemplate)answerTemplate.get(0);
                inputSos.setAnswerTemplate(at);
                if (existingSos.isEmpty()) {
                    List defaultQuestions = this.setQuestions();
                    defaultQuestions = this.questionRepository.save((Iterable)defaultQuestions);
                    List<Answer> defaultQuestionAnswers = new ArrayList();
                    SessionBoard currentSessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardId));
                    List teamList = currentSessionBoard.getTeams();
                    for (Question savedQuestion : defaultQuestions) {
                        for (Team team : teamList) {
                            Answer answer = new Answer();
                            answer.setQuestion(savedQuestion);
                            answer.setTeam(team);
                            defaultQuestionAnswers.add(answer);
                        }
                    }
                    defaultQuestionAnswers = this.answerRepository.save(defaultQuestionAnswers);
                    inputSos.setQuestions(defaultQuestions);
                }
                PiSos piSos = (PiSos)this.piSosRepository.save((Object)inputSos);
                responseJson.put("sos", piSos);
                pushJson.put("sos", piSos);
                pushJson.put("metaMap", "{\"event\":\"sosSave\", \"type\":\"sos\", \"syncId\":\"" + piSos.getMetaMap() + "\", \"sessionId\":\"" + sessionId + "\"}");
            } else {
                return new ResponseEntity(HttpStatus.NO_CONTENT);
            }
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            PushSender.sendMsg((String)mapper.writeValueAsString(pushJson));
        }
        catch (JsonProcessingException e) {
            LOGGER.debug(e.getMessage());
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/getPiSosList/{sessionId}/{sessionBoardId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> fetchPiSos(@PathVariable(value="sessionId") String sessionId, @PathVariable(value="sessionBoardId") String sessionBoardId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        List piSosList = this.piSosRepository.findBySessionId(sessionId);
        SessionBoard sessionBoard = this.sessionBoardRepository.findById(sessionBoardId);
        responseJson.put("sessionBoard", sessionBoard);
        responseJson.put("piSosList", piSosList);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/fetchAnswerTemplate"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> fetchAnswerTemplate() {
        List answerTemplate = this.answerTemplateRepository.findByName("Sos");
        AnswerTemplate sosAnswerTemplate = (AnswerTemplate)answerTemplate.get(0);
        return new ResponseEntity((Object)sosAnswerTemplate, HttpStatus.OK);
    }

    public AnswerTemplate setAnswerTemplate() {
        AnswerTemplate at = new AnswerTemplate();
        at.setName("Sos");
        at.setFieldType("dropdown");
        ArrayList<Option> ansOptions = new ArrayList<Option>();
        Option op = new Option();
        op.setLabel("Y");
        op.setValue("Yes");
        op.setColor("rgba(9, 193, 153, 0.3)");
        ansOptions.add(op);
        Option op1 = new Option();
        op1.setLabel("N");
        op1.setValue("No");
        op1.setColor("rgba(247, 152, 28, 0.3)");
        ansOptions.add(op1);
        Option op2 = new Option();
        op2.setLabel("NY");
        op2.setValue("Not Yet");
        op2.setColor("rgba(25, 145, 235, 0.3)");
        ansOptions.add(op2);
        Option op3 = new Option();
        op3.setLabel("B");
        op3.setValue("Blocked");
        op3.setColor("rgba(244, 81, 87, 0.3)");
        ansOptions.add(op3);
        Option op4 = new Option();
        op4.setLabel("NA");
        op4.setValue("N/A");
        op4.setColor("rgba(0, 0, 0, 0.1)");
        ansOptions.add(op4);
        at.setOptions(ansOptions);
        at = (AnswerTemplate)this.answerTemplateRepository.save((Object)at);
        return at;
    }

    public List<Question> setQuestions() {
        ArrayList<Question> questions = new ArrayList<Question>();
        Question q1 = new Question();
        String qtn1 = "Have you identified the capacity for each iteration in the PI?";
        q1.setQuestionText(qtn1);
        questions.add(q1);
        Question q2 = new Question();
        String qtn2 = "Have you identified most of the stories for the first two iterations and begun estimating?";
        q2.setQuestionText(qtn2);
        questions.add(q2);
        Question q3 = new Question();
        String qtn3 = "Have you begun resolving dependencies with other teams?";
        q3.setQuestionText(qtn3);
        questions.add(q3);
        Question q4 = new Question();
        String qtn4 = "Are you discussing trade-offs and conflicting priorities with business owners?";
        q4.setQuestionText(qtn4);
        questions.add(q4);
        Question q5 = new Question();
        String qtn5 = "Have you identified program risks?";
        q5.setQuestionText(qtn5);
        questions.add(q5);
        Question q6 = new Question();
        String qtn6 = "Will you be ready to start writing PI objectives in the next 15 minutes?";
        q6.setQuestionText(qtn6);
        questions.add(q6);
        Question q7 = new Question();
        String qtn7 = "Is there anything you need to discuss with other Scrum Masters? If so, stay for the meet-after.";
        q7.setQuestionText(qtn7);
        questions.add(q7);
        return questions;
    }

    @RequestMapping(value={"/getQuestionsAndAnswers/{sosId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> fetchAnswersAndQuestions(@RequestBody List<Team> sosTeams, @PathVariable(value="sosId") String sosId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        if (!PropertyValidator.isValid((Object)sosId)) {
            responseJson.put("success", false);
            responseJson.put("reason", "Invalid Input");
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        PiSos piSos = this.piSosRepository.findById(sosId);
        ArrayList questions = piSos.getQuestions();
        if (!PropertyValidator.isValid((Collection)questions)) {
            questions = new ArrayList();
        }
        ArrayList<String> questionIds = new ArrayList<String>();
        ArrayList<String> teamIds = new ArrayList<String>();
        for (Question question : questions) {
            if (!PropertyValidator.isValid((Object)question)) continue;
            questionIds.add(question.getId());
        }
        for (Team sosTeam : sosTeams) {
            teamIds.add(sosTeam.getId());
        }
        List answers = this.answerRepository.findByQuestionIdInAndTeamIdIn(questionIds, teamIds);
        responseJson.put("questions", questions);
        responseJson.put("answers", answers);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/updateTemplate"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> editAnswerTemplate(@RequestBody List<Option> options) {
        List answerTemplate = this.answerTemplateRepository.findByName("Sos");
        AnswerTemplate at = (AnswerTemplate)answerTemplate.get(0);
        at.setOptions(options);
        at = (AnswerTemplate)this.answerTemplateRepository.save((Object)at);
        return new ResponseEntity((Object)at, HttpStatus.OK);
    }

    @RequestMapping(value={"/deleteQuestion/{questionId}/{sosId}/{syncId}/{sessionId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> deleteQuestion(@PathVariable(value="sosId") String sosId, @PathVariable(value="questionId") String questionId, @PathVariable(value="syncId") String syncId, @PathVariable(value="sessionId") String sessionId) {
        HashMap<String, List> responseJson = new HashMap<String, List>();
        ArrayList<String> questionIdToDelete = new ArrayList<String>();
        questionIdToDelete.add(questionId);
        ArrayList<String> questionIdToFind = new ArrayList<String>();
        PiSos piSos = this.piSosRepository.findById(sosId);
        List questions = piSos.getQuestions();
        this.questionRepository.delete((Serializable)((Object)questionId));
        this.answerRepository.deleteByQuestionIdIn(questionIdToDelete);
        questions.removeIf(question -> question.getId().equals(questionId));
        piSos.setQuestions(questions);
        piSos = (PiSos)this.piSosRepository.save((Object)piSos);
        for (Question question2 : questions) {
            questionIdToFind.add(question2.getId());
        }
        List answers = this.answerRepository.findByQuestionIdIn(questionIdToFind);
        responseJson.put("savedQuestions", questions);
        responseJson.put("savedAnswers", answers);
        HashMap<String, String> pushJson = new HashMap<String, String>();
        pushJson.put("question", questionId);
        pushJson.put("metaMap", "{\"event\":\"sosQuestionRemove\", \"type\":\"sos\", \"syncId\":\"" + syncId + "\", \"sessionId\":\"" + sessionId + "\"}");
        ObjectMapper mapper = new ObjectMapper();
        try {
            PushSender.sendMsg((String)mapper.writeValueAsString(pushJson));
        }
        catch (JsonProcessingException e) {
            LOGGER.debug(e.getMessage());
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/saveAnswer/{sessionId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveAnswer(@RequestBody Answer inputAnswer, @PathVariable(value="sessionId") String sessionId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        if (!(PropertyValidator.isValid((Object)inputAnswer.getTeam()) && PropertyValidator.isValid((Object)inputAnswer.getQuestion()) && PropertyValidator.isValid((Object)inputAnswer.getSelectedAnswer()))) {
            responseJson.put("success", false);
            responseJson.put("reason", "Invalid Input");
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        Question question = this.questionRepository.findById(inputAnswer.getQuestion().getId());
        if (!PropertyValidator.isValid((Object)question)) {
            return new ResponseEntity(HttpStatus.NO_CONTENT);
        }
        Answer savedAnswer = (Answer)this.answerRepository.save((Object)inputAnswer);
        responseJson.put("savedAnswer", savedAnswer);
        HashMap<String, Object> pushJson = new HashMap<String, Object>();
        pushJson.put("answer", savedAnswer);
        pushJson.put("metaMap", "{\"event\":\"sosAnswerSave\", \"type\":\"sos\", \"syncId\":\"" + savedAnswer.getMetaMap() + "\", \"sessionId\":\"" + sessionId + "\"}");
        ObjectMapper mapper = new ObjectMapper();
        try {
            PushSender.sendMsg((String)mapper.writeValueAsString(pushJson));
        }
        catch (JsonProcessingException e) {
            LOGGER.debug(e.getMessage());
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/saveQuestion/{sosId}/{sessionId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveQuestion(@RequestBody Question inputQuestion, @PathVariable(value="sosId") String sosId, @PathVariable(value="sessionId") String sessionId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        if (!PropertyValidator.isValid((Object)inputQuestion.getQuestionText())) {
            responseJson.put("success", false);
            responseJson.put("reason", "Invalid Input");
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        if (PropertyValidator.isValid((Object)inputQuestion.getId())) {
            Question savedQuestion = this.questionRepository.findById(inputQuestion.getId());
            if (!PropertyValidator.isValid((Object)savedQuestion)) {
                return new ResponseEntity(HttpStatus.NO_CONTENT);
            }
            savedQuestion.setQuestionText(inputQuestion.getQuestionText());
            savedQuestion = (Question)this.questionRepository.save((Object)savedQuestion);
            responseJson.put("savedQuestion", savedQuestion);
            HashMap<String, Object> pushJson = new HashMap<String, Object>();
            pushJson.put("question", savedQuestion);
            pushJson.put("sosId", sosId);
            pushJson.put("metaMap", "{\"event\":\"sosQuestionSave\", \"type\":\"sos\", \"syncId\":\"" + savedQuestion.getMetaMap() + "\", \"sessionId\":\"" + sessionId + "\"}");
            ObjectMapper mapper = new ObjectMapper();
            try {
                PushSender.sendMsg((String)mapper.writeValueAsString(pushJson));
            }
            catch (JsonProcessingException e) {
                LOGGER.debug(e.getMessage());
            }
        } else {
            Question savedQuestion = (Question)this.questionRepository.save((Object)inputQuestion);
            PiSos sos = (PiSos)this.piSosRepository.findOne((Serializable)((Object)sosId));
            ArrayList<Question> savedQuestions = sos.getQuestions();
            if (!PropertyValidator.isValid((Collection)savedQuestions)) {
                savedQuestions = new ArrayList<Question>();
            }
            savedQuestions.add(savedQuestion);
            sos.setQuestions(savedQuestions);
            this.piSosRepository.save((Object)sos);
            responseJson.put("savedQuestion", savedQuestion);
            HashMap<String, Object> pushJson = new HashMap<String, Object>();
            pushJson.put("question", savedQuestion);
            pushJson.put("sosId", sosId);
            pushJson.put("metaMap", "{\"event\":\"sosQuestionSave\", \"type\":\"sos\", \"syncId\":\"" + savedQuestion.getMetaMap() + "\", \"sessionId\":\"" + sessionId + "\"}");
            ObjectMapper mapper = new ObjectMapper();
            try {
                PushSender.sendMsg((String)mapper.writeValueAsString(pushJson));
            }
            catch (JsonProcessingException e) {
                LOGGER.debug(e.getMessage());
            }
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/addAnswers/{sessionId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> addAnswers(@RequestBody List<Answer> inputAnswers, @PathVariable(value="sessionId") String sessionId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        ArrayList<String> questionIds = new ArrayList<String>();
        ArrayList<String> teamIds = new ArrayList<String>();
        for (Answer answer : inputAnswers) {
            if (!PropertyValidator.isValid((Object)answer.getTeam()) || !PropertyValidator.isValid((Object)answer.getQuestion())) {
                responseJson.put("success", false);
                responseJson.put("reason", "Invalid Input");
                return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
            }
            questionIds.add(answer.getQuestion().getId());
            String teamId = answer.getTeam().getId();
            if (teamIds.contains(teamId)) continue;
            teamIds.add(teamId);
        }
        List answers = this.answerRepository.findByQuestionIdInAndTeamIdIn(questionIds, teamIds);
        if (!PropertyValidator.isValid((Collection)answers)) {
            List savedAnswers = this.answerRepository.save(inputAnswers);
            responseJson.put("savedAnswers", savedAnswers);
            HashMap<String, Object> pushJson = new HashMap<String, Object>();
            pushJson.put("answers", savedAnswers);
            pushJson.put("metaMap", "{\"event\":\"sosAnswersAdd\", \"type\":\"sos\", \"syncId\":\"" + ((Answer)savedAnswers.get(0)).getMetaMap() + "\", \"sessionId\":\"" + sessionId + "\"}");
            ObjectMapper mapper = new ObjectMapper();
            try {
                PushSender.sendMsg((String)mapper.writeValueAsString(pushJson));
            }
            catch (JsonProcessingException e) {
                LOGGER.debug(e.getMessage());
            }
        } else {
            responseJson.put("savedAnswers", answers);
            HashMap<String, Object> pushJson = new HashMap<String, Object>();
            pushJson.put("answers", answers);
            pushJson.put("metaMap", "{\"event\":\"sosAnswersAdd\", \"type\":\"sos\", \"syncId\":\"" + ((Answer)answers.get(0)).getMetaMap() + "\", \"sessionId\":\"" + sessionId + "\"}");
            ObjectMapper mapper = new ObjectMapper();
            try {
                PushSender.sendMsg((String)mapper.writeValueAsString(pushJson));
            }
            catch (JsonProcessingException e) {
                LOGGER.debug(e.getMessage());
            }
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/copyQuestions/{copyFromSosId}/{copyToSosId}/{copyAnswers}/{syncId}/{sessionId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> copyQuestions(@PathVariable(value="copyFromSosId") String copyFromSosId, @PathVariable(value="copyToSosId") String copyToSosId, @PathVariable(value="copyAnswers") boolean copyAnswers, @PathVariable(value="syncId") String syncId, @PathVariable(value="sessionId") String sessionId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        HashMap<String, Object> pushJson = new HashMap<String, Object>();
        PiSos copyFromPiSos = this.piSosRepository.findById(copyFromSosId);
        PiSos copyToPiSos = this.piSosRepository.findById(copyToSosId);
        Session session = this.sessionRepository.findById(sessionId);
        SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)session.getActiveSessionBoard()));
        if (!PropertyValidator.isValid((Object)copyFromPiSos) || !PropertyValidator.isValid((Object)copyToPiSos)) {
            responseJson.put("success", false);
            responseJson.put("reason", "Invalid Input");
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        List copyFromQuestions = copyFromPiSos.getQuestions();
        List<Question> copyToQuestions = new ArrayList();
        List<Answer> copyToAnswersEmpty = new ArrayList();
        if (PropertyValidator.isValid((Collection)copyFromQuestions)) {
            for (Question copiedQuestion : copyFromQuestions) {
                Gson gson = new Gson();
                Question newQuestion = (Question)gson.fromJson(gson.toJson((Object)copiedQuestion), Question.class);
                copyToQuestions.add(newQuestion);
            }
            for (Question copiedQuestion : copyToQuestions) {
                copiedQuestion.setId(null);
            }
            copyToQuestions = this.questionRepository.save(copyToQuestions);
            copyToPiSos.setQuestions(copyToQuestions);
            this.piSosRepository.save((Object)copyToPiSos);
            if (copyAnswers) {
                ArrayList questionIds = new ArrayList();
                HashMap questionTitleMap = new HashMap();
                for (Object question : copyFromQuestions) {
                    questionIds.add(question.getId());
                }
                List copiedAnswers = this.answerRepository.findByQuestionIdIn((List)questionIds);
                for (Question question : copyFromQuestions) {
                    ArrayList<Answer> answers = new ArrayList<Answer>();
                    for (Answer answer : copiedAnswers) {
                        if (!answer.getQuestion().getId().equals(question.getId())) continue;
                        answers.add(answer);
                    }
                    questionTitleMap.put(question.getQuestionText(), answers);
                }
                copiedAnswers = new ArrayList();
                for (Question question : copyToQuestions) {
                    String questionMapKey = question.getQuestionText();
                    if (!questionTitleMap.containsKey(questionMapKey)) continue;
                    List newAnswers = (List)questionTitleMap.get(questionMapKey);
                    for (Answer answer : newAnswers) {
                        answer.setQuestion(question);
                        answer.setId(null);
                    }
                    copiedAnswers.addAll(newAnswers);
                }
                copiedAnswers = this.answerRepository.save(copiedAnswers);
                responseJson.put("savedAnswers", copiedAnswers);
                pushJson.put("answers", copiedAnswers);
            } else {
                for (Question question : copyToQuestions) {
                    for (Team team : sessionBoard.getTeams()) {
                        Answer emptyAnswerForQuestion = new Answer();
                        emptyAnswerForQuestion.setTeam(team);
                        emptyAnswerForQuestion.setQuestion(question);
                        copyToAnswersEmpty.add(emptyAnswerForQuestion);
                    }
                }
                copyToAnswersEmpty = this.answerRepository.save(copyToAnswersEmpty);
            }
            responseJson.put("savedQuestions", copyToQuestions);
            responseJson.put("savedAnswersEmpty", copyToAnswersEmpty);
            pushJson.put("questions", copyToQuestions);
            pushJson.put("metaMap", "{\"event\":\"copyQuestions\", \"type\":\"sos\", \"syncId\":\"" + syncId + "\", \"sessionId\":\"" + sessionId + "\"}");
            ObjectMapper mapper = new ObjectMapper();
            try {
                PushSender.sendMsg((String)mapper.writeValueAsString(pushJson));
            }
            catch (JsonProcessingException e) {
                LOGGER.debug(e.getMessage());
            }
        } else {
            responseJson.put("savedQuestions", new ArrayList());
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/setDefaultQuestions/{sosId}/{sessionBoardId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> setDefaultQuestions(@PathVariable(value="sosId") String sosId, @PathVariable(value="sessionBoardId") String sessionBoardId) {
        HashMap responseJson = new HashMap();
        PiSos piSos = this.piSosRepository.findById(sosId);
        List piSosQuestions = piSos.getQuestions();
        if (PropertyValidator.isValid((Collection)piSosQuestions)) {
            boolean nullsOnly = piSosQuestions.stream().allMatch(x -> x == null);
            if (piSosQuestions.size() > 0 && !nullsOnly) {
                ArrayList<String> questionIds = new ArrayList<String>();
                for (Question savedQuestion : piSosQuestions) {
                    questionIds.add(savedQuestion.getId());
                }
                List savedAnswers = this.answerRepository.findByQuestionIdIn(questionIds);
                responseJson.put("savedQuestions", piSosQuestions);
                responseJson.put("savedAnswers", savedAnswers);
                return new ResponseEntity(responseJson, HttpStatus.OK);
            }
        }
        List defaultQuestions = this.setQuestions();
        defaultQuestions = this.questionRepository.save((Iterable)defaultQuestions);
        List<Answer> defaultQuestionAnswers = new ArrayList();
        SessionBoard currentSessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardId));
        List teamList = currentSessionBoard.getTeams();
        for (Question savedQuestion : defaultQuestions) {
            for (Team team : teamList) {
                Answer answer = new Answer();
                answer.setQuestion(savedQuestion);
                answer.setTeam(team);
                defaultQuestionAnswers.add(answer);
            }
        }
        defaultQuestionAnswers = this.answerRepository.save(defaultQuestionAnswers);
        piSos.setQuestions(defaultQuestions);
        this.piSosRepository.save((Object)piSos);
        responseJson.put("savedQuestions", defaultQuestions);
        responseJson.put("savedAnswers", defaultQuestionAnswers);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/deleteSos/{sosId}/{syncId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<Object> deleteSos(@PathVariable(value="sosId") String sosId, @PathVariable(value="syncId") String syncId) {
        PiSos sosToDelete = this.piSosRepository.findById(sosId);
        List questionsOfSosToDelete = sosToDelete.getQuestions();
        if (PropertyValidator.isValid((Collection)questionsOfSosToDelete)) {
            boolean nullsOnly = questionsOfSosToDelete.stream().allMatch(x -> x == null);
            ArrayList<String> questionIdsToDelete = new ArrayList<String>();
            if (!nullsOnly) {
                for (Question question : questionsOfSosToDelete) {
                    questionIdsToDelete.add(question.getId());
                }
                this.answerRepository.deleteByQuestionIdIn(questionIdsToDelete);
                this.questionRepository.deleteByIdIn(questionIdsToDelete);
            }
        }
        this.piSosRepository.delete((Serializable)((Object)sosId));
        HashMap<String, String> pushJson = new HashMap<String, String>();
        pushJson.put("sosId", sosId);
        pushJson.put("metaMap", "{\"event\":\"sosDelete\", \"type\":\"sos\", \"syncId\":\"" + syncId + "\"}");
        ObjectMapper mapper = new ObjectMapper();
        try {
            PushSender.sendMsg((String)mapper.writeValueAsString(pushJson));
        }
        catch (JsonProcessingException e) {
            LOGGER.debug(e.getMessage());
        }
        return new ResponseEntity(HttpStatus.OK);
    }

    @RequestMapping(value={"/showLocationInCapacity/{journeyId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> showLocationInCapacity(@PathVariable(value="journeyId") String journeyId, @RequestBody HashMap<String, Object> body) {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        Boolean show = (Boolean)body.get("show");
        PiJourney journey = (PiJourney)this.piJourneyRepository.findOne((Serializable)((Object)journeyId));
        if (show.booleanValue()) {
            journey.setShowLocationInCapacity(Boolean.valueOf(true));
        } else {
            journey.setShowLocationInCapacity(Boolean.valueOf(false));
        }
        this.piJourneyRepository.save((Object)journey);
        responseJson.put("success", true);
        responseJson.put("value", show);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/showRoleInCapacity/{journeyId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> showRoleInCapacity(@PathVariable(value="journeyId") String journeyId, @RequestBody HashMap<String, Object> body) {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        Boolean show = (Boolean)body.get("show");
        PiJourney journey = (PiJourney)this.piJourneyRepository.findOne((Serializable)((Object)journeyId));
        if (show.booleanValue()) {
            journey.setShowRoleInCapacity(Boolean.valueOf(true));
        } else {
            journey.setShowRoleInCapacity(Boolean.valueOf(false));
        }
        this.piJourneyRepository.save((Object)journey);
        responseJson.put("success", true);
        responseJson.put("value", show);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/excludeColumnInAgenda/{agendaId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> excludeColumnInAgenda(@PathVariable(value="agendaId") String agendaId, @RequestBody HashMap<String, Object> body) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        String column = (String)body.get("column");
        Boolean exclude = (Boolean)body.get("exclude");
        PiAgenda agenda = (PiAgenda)this.piAgendaRepository.findOne((Serializable)((Object)agendaId));
        if (exclude.booleanValue()) {
            if (agenda.getExcludeColumns() == null) {
                agenda.setExcludeColumns(new ArrayList());
            }
            if (!agenda.getExcludeColumns().contains(column)) {
                agenda.getExcludeColumns().add(column);
            }
            this.piAgendaRepository.save((Object)agenda);
        } else if (PropertyValidator.isValid((Collection)agenda.getExcludeColumns()) && agenda.getExcludeColumns().contains(column)) {
            agenda.getExcludeColumns().remove(column);
            this.piAgendaRepository.save((Object)agenda);
        }
        responseJson.put("success", true);
        responseJson.put("column", column);
        responseJson.put("status", exclude);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/createShareUrl/{journeyId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> createShareUrl(@PathVariable(value="journeyId") String journeyId, @RequestBody HashMap<String, String> body) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        PiJourney piJourney = (PiJourney)this.piJourneyRepository.findOne((Serializable)((Object)journeyId));
        if (piJourney.getShareUrl() != null) {
            responseJson.put("success", false);
            responseJson.put("reason", "AlreadyExist");
        } else {
            String params = body.get("params");
            String accessToken = UUID.randomUUID().toString();
            ServerCache serverCache = new ServerCache();
            serverCache.setKey(accessToken);
            serverCache.setValue(params);
            serverCache.setTime(new Date());
            this.serverCacheRepository.save((Object)serverCache);
            String url = "/pijourney/public_share/root?token=" + accessToken;
            piJourney.setShareUrl(url);
            this.piJourneyRepository.save((Object)piJourney);
            responseJson.put("success", true);
            responseJson.put("url", url);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/stopPublicShare/{journeyId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> stopPublicShare(@PathVariable(value="journeyId") String journeyId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        PiJourney piJourney = (PiJourney)this.piJourneyRepository.findOne((Serializable)((Object)journeyId));
        if (piJourney.getShareUrl() == null) {
            responseJson.put("success", false);
            responseJson.put("reason", "NotExist");
        } else {
            String url = piJourney.getShareUrl();
            String accessToken = this.getParam(url, "token");
            this.serverCacheRepository.deleteByKey(accessToken);
            piJourney.setShareUrl(null);
            this.piJourneyRepository.save((Object)piJourney);
            responseJson.put("success", true);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/public_share/decryptShareUrl"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> decryptShareUrl(@RequestBody HashMap<String, String> body, HttpServletRequest request) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        String token = body.get("token");
        ServerCache serverCache = this.serverCacheRepository.findByKey(token);
        if (PropertyValidator.isValid((Object)serverCache)) {
            responseJson.put("success", true);
            responseJson.put("params", serverCache.getValue());
        } else {
            responseJson.put("success", false);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    private String getParam(String url, String name) {
        String params = url.substring(url.indexOf("?") + 1, url.length());
        Map split = Splitter.on((String)"&").withKeyValueSeparator("=").split((CharSequence)params);
        return (String)split.get(name);
    }

    @RequestMapping(value={"/exportProgramRoleData/tab/{sessionBoardId}/{journeyId}/{downloadType}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> exportProgramRoleTab(@PathVariable(value="sessionBoardId") String sessionBoardId, @PathVariable(value="journeyId") String journeyId, @PathVariable(value="downloadType") String downloadType) {
        try {
            HashMap responseJson = new HashMap();
            List programRoles = this.piProgramRoleRepository.findByPiJourneyId(journeyId);
            SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardId));
            String[] teamSequence = sessionBoard.getTeamSequence();
            List teamList = sessionBoard.getTeams();
            String filePath = this.exportService.exportProgramAndTeamRoles(programRoles, teamList, downloadType, teamSequence);
            SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy");
            String downloadName = AlmUtils.cleanText((String)sessionBoard.getSession().getTitle()) + "_Program_Roles_" + formatter.format(new Date()) + ".xls";
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("srcPath", URLEncoder.encode(filePath, "UTF-8"));
            data.put("name", URLEncoder.encode(downloadName, "UTF-8"));
            return new ResponseEntity(data, HttpStatus.OK);
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            return new ResponseEntity((Object)ex, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/export/questionsAndAnswers/{sosId}/{sessionBoardId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> exportQuestionAndAnswers(@RequestBody List<Team> teamsSelected, @PathVariable(value="sosId") String sosId, @PathVariable(value="sessionBoardId") String sessionBoardId) {
        try {
            int totalTeams = 0;
            HashMap<String, Object> responseJson = new HashMap<String, Object>();
            List<Team> selectedTeams = teamsSelected;
            SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardId));
            totalTeams = sessionBoard.getTeams().size();
            if (!PropertyValidator.isValid((Object)sosId)) {
                responseJson.put("success", false);
                responseJson.put("reason", "Invalid Input");
                return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
            }
            PiSos piSos = this.piSosRepository.findById(sosId);
            ArrayList questions = piSos.getQuestions();
            if (!PropertyValidator.isValid((Collection)questions)) {
                questions = new ArrayList();
            }
            ArrayList<String> questionIds = new ArrayList<String>();
            ArrayList<String> teamIds = new ArrayList<String>();
            for (Question question : questions) {
                questionIds.add(question.getId());
            }
            for (Team sosTeam : selectedTeams) {
                teamIds.add(sosTeam.getId());
            }
            List answers = this.answerRepository.findByQuestionIdInAndTeamIdIn(questionIds, teamIds);
            responseJson.put("questions", questions);
            responseJson.put("answers", answers);
            String filePath = this.exportService.exportQuestionAnswers(selectedTeams, questions, answers, totalTeams);
            SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy");
            String downloadName = AlmUtils.cleanText((String)sessionBoard.getSession().getTitle()) + "_Planning_SOS_" + formatter.format(new Date()) + ".xls";
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("srcPath", URLEncoder.encode(filePath, "UTF-8"));
            data.put("name", URLEncoder.encode(downloadName, "UTF-8"));
            return new ResponseEntity(data, HttpStatus.OK);
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            return new ResponseEntity((Object)"Error Fetching Logs", HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/export-team-capacity"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> exportTeamCapacity(@RequestBody HashMap<String, Object> requestBody) {
        try {
            String filePath = "";
            HashMap<String, Object> response = new HashMap<String, Object>();
            String piJourneyId = (String)requestBody.get("piJourneyId");
            String teamId = (String)requestBody.get("teamId");
            String sessionId = (String)requestBody.get("sessionId");
            String type = (String)requestBody.get("type");
            List teamIds = (List)requestBody.get("teamIds");
            List filteredColumns = (List)requestBody.get("filteredColumns");
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").in((Collection)teamIds));
            List teamList = this.mongoTemplate.find(query, Team.class);
            Query query2 = new Query();
            query2.addCriteria((CriteriaDefinition)Criteria.where((String)"id").in((Collection)teamIds));
            query2.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)true));
            List teamListDeleted = this.mongoTemplate.find(query2, Team.class);
            teamList.addAll(teamListDeleted);
            HashMap<String, Team> teamIdsMap = new HashMap<String, Team>();
            HashMap<String, PiTeamCapacity> teamsCapacityListMap = new HashMap<String, PiTeamCapacity>();
            ArrayList teamsOrderedList = new ArrayList();
            for (Team team : teamList) {
                teamIdsMap.put(team.getId(), team);
            }
            for (String teamIdOrder : teamIds) {
                teamsOrderedList.add(teamIdsMap.get(teamIdOrder));
            }
            SessionBoard sessionBoard = new SessionBoard();
            if (PropertyValidator.isValid((Object)piJourneyId)) {
                Session session = (Session)this.sessionRepository.findOne((Serializable)((Object)sessionId));
                sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)session.getActiveSessionBoard()));
                List teamCapacityList = this.piTeamCapacityRepository.findByPiJourneyIdAndSessionId(piJourneyId, sessionId);
                ArrayList teamsCapacityOrdered = new ArrayList();
                for (PiTeamCapacity tc : teamCapacityList) {
                    teamsCapacityListMap.put(tc.getTeam().getId(), tc);
                }
                for (String teamIdOrder : teamIds) {
                    teamsCapacityOrdered.add(teamsCapacityListMap.get(teamIdOrder));
                }
                if (type.equals("team")) {
                    if (!PropertyValidator.isValid((Object)teamId)) {
                        filePath = this.exportService.exportTeamCapacity(sessionBoard, teamsCapacityOrdered, null, type, teamId, teamsOrderedList, filteredColumns);
                        response.put("cap", teamCapacityList);
                    } else {
                        Team team = new Team();
                        team.setId(teamId);
                        PiTeamCapacity teamCapacity = this.piTeamCapacityRepository.findByPiJourneyIdAndSessionIdAndTeam(piJourneyId, sessionId, team);
                        filePath = this.exportService.exportTeamCapacity(sessionBoard, null, teamCapacity, type, teamId, teamsOrderedList, filteredColumns);
                        response.put("cap", teamCapacity);
                    }
                } else if (type.equals("All")) {
                    filePath = this.exportService.exportTeamCapacity(sessionBoard, teamsCapacityOrdered, null, type, teamId, teamsOrderedList, filteredColumns);
                    response.put("allCap", teamCapacityList);
                }
            } else {
                response.put("error", true);
                response.put("message", "Pi Journey Id invalid");
                return new ResponseEntity(HttpStatus.BAD_REQUEST);
            }
            SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy");
            String downloadName = AlmUtils.cleanText((String)sessionBoard.getSession().getTitle()) + "Team Capacity" + formatter.format(new Date()) + ".xls";
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("srcPath", URLEncoder.encode(filePath, "UTF-8"));
            data.put("name", URLEncoder.encode(downloadName, "UTF-8"));
            return new ResponseEntity(data, HttpStatus.OK);
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            return new ResponseEntity((Object)ex, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/export-pi-agenda/{sessionBoardId}/{piAgendaId}/{piJourneyId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> exportPiAgendaToExcel(@PathVariable(value="sessionBoardId") String sessionBoardId, @PathVariable(value="piAgendaId") String piAgendaId, @PathVariable(value="piJourneyId") String piJourneyId, @RequestBody List<String> selectedColumns) {
        try {
            SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardId));
            PiAgenda piAgenda = (PiAgenda)this.piAgendaRepository.findOne((Serializable)((Object)piAgendaId));
            ArrayList piAgendaDay = piAgenda.getPiAgendaDays();
            PiJourney piJourney = this.piJourneyRepository.findById(piJourneyId);
            ArrayList piJourneySitesList = piJourney.getSites();
            String filePath = this.exportService.exportPiAgendaData((List)piAgendaDay, selectedColumns, sessionBoardId, (List)piJourneySitesList);
            SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy");
            String downloadName = AlmUtils.cleanText((String)sessionBoard.getSession().getTitle()) + "_PI_Agenda_" + formatter.format(new Date()) + ".xls";
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("srcPath", URLEncoder.encode(filePath, "UTF-8"));
            data.put("name", URLEncoder.encode(downloadName, "UTF-8"));
            return new ResponseEntity(data, HttpStatus.OK);
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            return new ResponseEntity((Object)ex, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/team-sprint-velocity/{sessionBoardId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> fetchTeamSprintVelocity(@PathVariable String sessionBoardId) {
        HashMap<String, List> responseJson = new HashMap<String, List>();
        SessionBoard sessionBoard = new SessionBoard();
        sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardId));
        ArrayList<SessionBoard> sessionBoards = new ArrayList<SessionBoard>();
        sessionBoards.add(sessionBoard);
        List teamSprintVelocityList = this.teamSprintVelocityRepository.findBySessionBoardId(sessionBoardId);
        responseJson.put("teamSprintVelocityList", teamSprintVelocityList);
        responseJson.put("teams", sessionBoard.getTeams());
        responseJson.put("sprints", sessionBoard.getContainers());
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    static /* synthetic */ PiJourneyService access$000(PIJourneyController x0) {
        return x0.piJourneyService;
    }
}

