/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.viztrend.safe.exception.KendisException;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.ItemLink;
import com.viztrend.safe.service.MyViewService;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/my-view"})
@RestController
public class MyViewController {
    private static final Logger LOGGER = LoggerFactory.getLogger(MyViewController.class);
    @Autowired
    private MyViewService myViewService;

    @RequestMapping(value={"/list-dependencies"}, method={RequestMethod.POST})
    public ResponseEntity<Object> getDependenciesList(@RequestBody HashMap<String, Object> requestBody) {
        LOGGER.debug("*****getDependenciesList**** -----> /my-view/list-dependencies   START");
        Instant startTime = Instant.now();
        HashMap responseJson = new HashMap();
        String userId = (String)requestBody.get("userId");
        if (!PropertyValidator.isValid((Object)userId)) {
            throw new KendisException("UserId is required to fetch My View Dependencies.");
        }
        HashMap dependenciesListMap = this.myViewService.getDependenciesListByUserId(userId);
        dependenciesListMap.keySet().forEach(key -> responseJson.put(key, dependenciesListMap.get(key)));
        Instant endTime = Instant.now();
        LOGGER.debug("Elapsed Time: " + Duration.between(startTime, endTime).toString());
        LOGGER.debug("*****getDependenciesList**** -----> /my-view/list-dependencies   END");
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/list-risks"}, method={RequestMethod.POST})
    public ResponseEntity<Object> getRisksList(@RequestBody HashMap<String, Object> requestBody) {
        Instant startTime = Instant.now();
        HashMap responseJson = new HashMap();
        LOGGER.debug("*****getRisksList**** -----> /my-view/list-risks   START");
        String userId = (String)requestBody.get("userId");
        if (!PropertyValidator.isValid((Object)userId)) {
            throw new KendisException("UserId is required to fetch My View Risks.");
        }
        HashMap risksListMap = this.myViewService.getRisksListByUserId(userId);
        risksListMap.keySet().forEach(key -> responseJson.put(key, risksListMap.get(key)));
        LOGGER.debug("*****getRisksList**** -----> /my-view/list-risks   END");
        Instant endTime = Instant.now();
        LOGGER.debug("Elapsed Time: " + Duration.between(startTime, endTime).toString());
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/save/dependency"}, method={RequestMethod.POST})
    public ResponseEntity<Object> saveDependency(@RequestBody HashMap<String, Object> requestBody) {
        HashMap<String, ItemLink> responseJson = new HashMap<String, ItemLink>();
        LOGGER.debug("*****saveDependency**** -----> /my-view/save/dependency  START");
        String itemJson = (String)requestBody.get("item");
        if (!PropertyValidator.isValid((Object)itemJson)) {
            throw new KendisException("item Field is Required.");
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            Item item = (Item)mapper.readValue(itemJson, mapper.getTypeFactory().constructType(Item.class));
            responseJson.put("link", this.myViewService.saveDependency(item));
        }
        catch (JsonProcessingException e) {
            LOGGER.error(e.getMessage());
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        LOGGER.debug("*****saveDependency**** -----> /my-view/save/dependency  END");
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/delete/dependency"}, method={RequestMethod.POST})
    public ResponseEntity<Object> deleteDependency(@RequestBody HashMap<String, Object> requestBody) {
        HashMap responseJson = new HashMap();
        LOGGER.debug("*****deleteDependency**** -----> /my-view/delete/dependency  START");
        String linkId = (String)requestBody.get("linkId");
        String sourceItemId = (String)requestBody.get("sourceItemId");
        String targetItemId = (String)requestBody.get("targetItemId");
        if (!(PropertyValidator.isValid((Object)linkId) && PropertyValidator.isValid((Object)sourceItemId) && PropertyValidator.isValid((Object)targetItemId))) {
            throw new KendisException("linkId,sourceItemId,targetItemId all fields are required");
        }
        ItemLink itemLink = new ItemLink();
        itemLink.setId(linkId);
        itemLink.setSourceItemId(sourceItemId);
        itemLink.setTargetItemId(targetItemId);
        this.myViewService.deleteDependency(itemLink);
        LOGGER.debug("*****deleteDependency**** -----> /my-view/delete/dependency  END");
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/list-impediments"}, method={RequestMethod.POST})
    public ResponseEntity<Object> getImpedimentsListByUserId(@RequestBody HashMap<String, Object> requestBody) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            LOGGER.debug("*****getImpedimentsListByUserId**** -----> /my-view/list-impediments   START");
            String userId = (String)requestBody.get("userId");
            if (!PropertyValidator.isValid((Object)userId)) {
                responseJson.put("kendisError", "userId is required");
                LOGGER.error("*****getImpedimentsListByUserId**** -----> userId is required.");
                return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
            }
            HashMap impedimentsListByUserId = this.myViewService.getImpedimentsListByUserId(userId);
            impedimentsListByUserId.keySet().forEach(key -> responseJson.put((String)key, impedimentsListByUserId.get(key)));
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error("*****getImpedimentsListByUserId**** -----> Exception Occurred. ---------------");
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        LOGGER.debug("*****getImpedimentsListByUserId**** -----> /my-view/list-impediments   END");
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/list-actionpoints"}, method={RequestMethod.POST})
    public ResponseEntity<Object> getActionPointsByMention(@RequestBody HashMap<String, Object> requestBody) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            LOGGER.debug("*****getActionPointsByMention**** -----> /my-view/list-actionpoints   START");
            String dataMentionId = (String)requestBody.get("data-mention-id");
            if (!PropertyValidator.isValid((Object)dataMentionId)) {
                responseJson.put("kendisError", "dataMentionId is required");
                LOGGER.error("*****getActionPointsByMention**** -----> dataMentionId is required.");
                return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
            }
            HashMap impedimentsListByUserId = this.myViewService.getActionPointsByMentionId(dataMentionId);
            impedimentsListByUserId.keySet().forEach(key -> responseJson.put((String)key, impedimentsListByUserId.get(key)));
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error("*****getActionPointsByMention**** -----> Exception Occurred. ---------------");
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        LOGGER.debug("*****getActionPointsByMention**** -----> /my-view/list-actionpoints   END");
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/load-action-point/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<Object> loadActionPointWithTemplate(@PathVariable(value="id") String id) {
        HashMap<String, Exception> responseJson = new HashMap<String, Exception>();
        try {
            LOGGER.debug("*****loadActionPointWithTemplate**** -----> /my-view/load-action-point   START");
            HashMap responseMap = this.myViewService.loadActionPointWithTemplate(id);
            responseMap.keySet().forEach(key -> responseJson.put((String)key, (Exception)responseMap.get(key)));
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error("*****loadActionPointWithTemplate**** -----> Exception Occurred. ---------------");
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        LOGGER.debug("*****loadActionPointWithTemplate**** -----> /my-view/load-action-point   END");
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }
}

