/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.controller;

import com.amazonaws.util.IOUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.net.InternetDomainName;
import com.google.gson.Gson;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.tool.xml.XMLWorkerHelper;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.stripe.Stripe;
import com.stripe.model.Customer;
import com.stripe.model.PaymentIntent;
import com.stripe.model.PaymentMethod;
import com.stripe.param.CustomerCreateParams;
import com.viztrend.safe.alm.jira.ImportUtil;
import com.viztrend.safe.alm.jira.JiraOauthUtil;
import com.viztrend.safe.alm.jira.JiraUtils;
import com.viztrend.safe.alm.jira.TFSUtils;
import com.viztrend.safe.config.filter.SystemAuthenticaitonFilter;
import com.viztrend.safe.controller.MVCController;
import com.viztrend.safe.controller.SolutionController;
import com.viztrend.safe.persistence.entity.AlmAccount;
import com.viztrend.safe.persistence.entity.Company;
import com.viztrend.safe.persistence.entity.Config;
import com.viztrend.safe.persistence.entity.Invitation;
import com.viztrend.safe.persistence.entity.JiraOauthToken;
import com.viztrend.safe.persistence.entity.PaymentDetails;
import com.viztrend.safe.persistence.entity.PaymentPackageConfig;
import com.viztrend.safe.persistence.entity.SAMLConfig;
import com.viztrend.safe.persistence.entity.ServerCache;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.VatCountry;
import com.viztrend.safe.persistence.repository.AlmAccountRepository;
import com.viztrend.safe.persistence.repository.CompanyRepository;
import com.viztrend.safe.persistence.repository.ConfigRepository;
import com.viztrend.safe.persistence.repository.InvitationRepository;
import com.viztrend.safe.persistence.repository.PaymentRecordRepository;
import com.viztrend.safe.persistence.repository.PaymentTransactionsRepository;
import com.viztrend.safe.persistence.repository.SAMLConfigRepository;
import com.viztrend.safe.persistence.repository.ServerCacheRepository;
import com.viztrend.safe.persistence.repository.UserRepository;
import com.viztrend.safe.persistence.repository.WebhookActivityRepository;
import com.viztrend.safe.service.ALMSyncService;
import com.viztrend.safe.service.ALMSyncServiceImpl;
import com.viztrend.safe.service.PaymentService;
import com.viztrend.safe.utils.EncDecUtility;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.S3Utils;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.SystemUtil;
import com.viztrend.safe.utils.TwoFactorAuthUtil;
import com.viztrend.safe.utils.UserContextUtil;
import com.viztrend.safe.vos.PaymentChargeVO;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.ConnectException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.bson.types.ObjectId;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
public class MVCController {
    @Autowired
    private AlmAccountRepository almAccountRepository;
    @Autowired
    private CompanyRepository companyRepository;
    @Autowired
    InvitationRepository invitationRepository;
    @Autowired
    private ImportUtil importUtil;
    @Autowired
    private TFSUtils tFSUtils;
    @Autowired
    ConfigRepository configRepository;
    @Autowired
    private PaymentRecordRepository paymentRecordRepository;
    @Autowired
    private SAMLConfigRepository samlConfigRepository;
    @Autowired
    private PaymentService paymentService;
    @Autowired
    private ALMSyncService aLMSyncService;
    @Autowired
    private Environment env;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private PaymentTransactionsRepository paymentTransactionsRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private SystemAuthenticaitonFilter systemAuthenticaitonFilter;
    @Autowired
    private ServerCacheRepository serverCacheRepository;
    @Autowired
    private WebhookActivityRepository webhookActivityRepository;
    private static final Logger LOGGER = LoggerFactory.getLogger(SolutionController.class);

    @RequestMapping(value={"/login"})
    public String login(HttpServletRequest request, HttpServletResponse response, Model model) {
        model.addAttribute("saml", (Object)false);
        boolean isLocalDeployment = this.env.getProperty("isLocalDeployment").equals("true");
        if (isLocalDeployment && this.companyRepository.count() < 1L) {
            return "welcome";
        }
        if (!isLocalDeployment && this.env.getProperty("app.env").equals("prod")) {
            SAMLConfig samlConfig;
            String subDomain;
            Company company;
            ImmutableList parts;
            String accessDomain = request.getServerName();
            if (InternetDomainName.isValid((String)accessDomain) && (parts = InternetDomainName.from((String)accessDomain).parts()).size() > 1 && PropertyValidator.isValid((Object)(company = this.companyRepository.findByUrlPrefixIgnoreCase(subDomain = (String)parts.get(0)))) && PropertyValidator.isValid((Object)(samlConfig = this.samlConfigRepository.findByTenant(company.getTenant())))) {
                model.addAttribute("saml", (Object)true);
            }
        } else {
            List samlConfigList = this.samlConfigRepository.findAll();
            if (PropertyValidator.isValid((Collection)samlConfigList)) {
                model.addAttribute("saml", (Object)true);
            }
        }
        try {
            model.addAttribute("error", (Object)EncDecUtility.decryptSimple((String)request.getParameter("error")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "login";
    }

    @RequestMapping(value={"/org"})
    public String releaseTrain(Model model) {
        model.addAttribute("companyId", (Object)UserContextUtil.getUserContext().getCurrentCompanyId());
        if (UserContextUtil.getUserContext().getCurrentCompany().isEnableArt()) {
            model.addAttribute("content_file", (Object)"releasetrain");
        } else {
            model.addAttribute("content_file", (Object)"demorequest");
        }
        model.addAttribute("content_css", (Object)"");
        return "kendis";
    }

    @RequestMapping(value={"/batches"})
    public String batches(Model model) {
        if (UserContextUtil.getUserContext().getCurrentCompany().isEnableArt()) {
            String cid = UserContextUtil.getUserContext().getCurrentCompany().getId();
            model.addAttribute("companyId", (Object)cid);
            if (!UserContextUtil.getUserContext().getCurrentCompany().checkFlagOnORG("batches")) {
                return this.rootHandling(null, null, model);
            }
            return "batches";
        }
        return "";
    }

    @RequestMapping(value={"/objectives"})
    public String objectives(Model model) {
        if (UserContextUtil.getUserContext().getCurrentCompany().isEnableArt()) {
            String cid = UserContextUtil.getUserContext().getCurrentCompany().getId();
            model.addAttribute("companyId", (Object)cid);
            if (!UserContextUtil.getUserContext().getCurrentCompany().checkFlagOnORG("objectives")) {
                return this.rootHandling(null, null, model);
            }
            return "objectives";
        }
        return "";
    }

    @RequestMapping(value={"/backlog-item"})
    public String backlogItemView(Model model) {
        return "rt-backlog-item-view";
    }

    @RequestMapping(value={"/mfa"})
    public String postLogin(Model model) {
        model.addAttribute("user", (Object)new User());
        return "mfa";
    }

    @RequestMapping(value={"/authError"})
    public String authError(HttpServletRequest request, Model model) {
        HashMap<String, String> errorsMap = new HashMap<String, String>();
        String authText = "Jira Auth";
        if (PropertyValidator.isValid((Object)request.getParameter("authType")) && "azure".equalsIgnoreCase(request.getParameter("authType"))) {
            authText = "Azure DevOps";
        }
        errorsMap.put("error", request.getParameter("error"));
        errorsMap.put("authText", authText);
        model.addAttribute("errorsMap", errorsMap);
        return "auth-error";
    }

    @RequestMapping(value={"/sos"})
    public String home(Model model) {
        model.addAttribute("companyId", (Object)UserContextUtil.getUserContext().getCurrentCompanyId());
        model.addAttribute("content_file", (Object)"sos");
        model.addAttribute("content_css", (Object)"");
        model.addAttribute("is_sos_page", (Object)true);
        return "kendis";
    }

    @RequestMapping(value={"/gantt-chart"})
    public String ganttChart(Model model) {
        return "gantt-chart";
    }

    @RequestMapping(value={"/board-sos"})
    public String sos(Model model) {
        model.addAttribute("companyId", (Object)UserContextUtil.getUserContext().getCurrentCompanyId());
        model.addAttribute("content_file", (Object)"sos");
        model.addAttribute("content_css", (Object)"");
        model.addAttribute("is_sos_page", (Object)false);
        return "sos";
    }

    @RequestMapping(value={"/share"})
    public String confidenceVote(Model model) {
        Boolean isLoggedInUser = PropertyValidator.isValid((Object)UserContextUtil.getUserContext());
        model.addAttribute("isLoggedInUser", (Object)isLoggedInUser);
        return "public-confidence-vote";
    }

    @RequestMapping(value={"/kendisboard"})
    public String kendisBoard(Model model) {
        return "kendis-board";
    }

    @RequestMapping(value={"/dynamic-fields"})
    public String dynamicFields(Model model) {
        return "dynamic-fields";
    }

    @RequestMapping(value={"/pijourney/public_share/root"})
    public String agendaShare(Model model) {
        return "pi-journey-public";
    }

    @RequestMapping(value={"/graphx/public_share/board/root"})
    public String boardShare(Model model) {
        return "collab-public";
    }

    @RequestMapping(value={"/unAuthorized"})
    public String unAuthError() {
        return "unAuth";
    }

    @RequestMapping(value={"/mfaactivation"})
    public String postLoginActivation() {
        return "mfaActivation";
    }

    @PostMapping(value={"/postreccode"})
    @ResponseBody
    public ResponseEntity<Object> postRecoveryCode(@RequestBody String code) {
        try {
            if (UserContextUtil.getUserContext() != null && UserContextUtil.getUserContext().getLoggedInUser().isRequireMFACode()) {
                User currUser = this.userRepository.findById(UserContextUtil.getUserContext().getLoggedInUser().getId());
                if (currUser.getrecoveryMFACode() != null && currUser.getrecoveryMFACode().equals(code)) {
                    UserContextUtil.getUserContext().getLoggedInUser().setRequireMFACode(false);
                    currUser.setRequireMFACode(false);
                    this.userRepository.save((Object)currUser);
                    return new ResponseEntity((Object)true, HttpStatus.OK);
                }
                return new ResponseEntity((Object)false, HttpStatus.OK);
            }
            return new ResponseEntity((Object)false, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
            e.printStackTrace();
            return new ResponseEntity(null, HttpStatus.OK);
        }
    }

    @RequestMapping(value={"/postcode/{code}"})
    public ResponseEntity<Object> postCode(@PathVariable(value="code") String code) {
        HashMap<String, Integer> responseData = new HashMap<String, Integer>();
        try {
            if (UserContextUtil.getUserContext() != null && UserContextUtil.getUserContext().getLoggedInUser().isRequireMFACode()) {
                User currUser = this.userRepository.findById(UserContextUtil.getUserContext().getLoggedInUser().getId());
                TwoFactorAuthUtil twoFactorAuthUtil = new TwoFactorAuthUtil();
                if (PropertyValidator.isValid((Object)code) && twoFactorAuthUtil.verifyCodeWithTolerance(currUser.getMfaCodeSec(), code, System.currentTimeMillis(), 1)) {
                    UserContextUtil.getUserContext().getLoggedInUser().setRequireMFACode(false);
                    currUser.setRequireMFACode(false);
                    this.userRepository.save((Object)currUser);
                    UserContextUtil.getUserContext().getLoggedInUser().setRequireMFACode(false);
                    responseData.put("message", 1);
                    return new ResponseEntity(responseData, HttpStatus.OK);
                }
                responseData.put("message", 2);
            } else {
                responseData.put("message", 2);
            }
            return new ResponseEntity(responseData, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResponseEntity(responseData, HttpStatus.OK);
        }
    }

    @RequestMapping(value={"/continue"}, method={RequestMethod.POST})
    public String ContinueMFA(@RequestBody HashMap<String, Object> MFA, Model model) throws IOException {
        Date date = new Date();
        HashMap<String, Object> vars = new HashMap<String, Object>();
        User saveduser = this.userRepository.findByUserNameIgnoreCase(UserContextUtil.getUserContext().getLoggedInUser().getUserName());
        saveduser.setMfaCodeSec((String)MFA.get("secretKey"));
        saveduser.setRequireMFACode(true);
        saveduser.setrecoveryMFACode((String)MFA.get("recoveryKey"));
        saveduser.setMfaCreatedDate(date);
        saveduser.setreckeyUpdatedDate(date);
        this.userRepository.save((Object)saveduser);
        vars.put("createdDate", new Date());
        vars.put("email", saveduser.getEmail());
        UserContextUtil.getUserContext().getLoggedInUser().setMfaCodeSec(saveduser.getMfaCodeSec());
        UserContextUtil.getUserContext().getLoggedInUser().setMfaCreatedDate(date);
        UserContextUtil.getUserContext().getLoggedInUser().setRequireMFACode(saveduser.isRequireMFACode());
        model.addAttribute("companyId", (Object)UserContextUtil.getUserContext().getCurrentCompanyId());
        model.addAttribute("content_file", (Object)"boards");
        model.addAttribute("content_css", (Object)"lrg-lftpnl");
        return "kendis";
    }

    @RequestMapping(value={"/fcfd12345de8c9f955175a63a81ab3ec.txt"})
    public String verify() {
        return "fcfd12345de8c9f955175a63a81ab3ec";
    }

    @RequestMapping(value={"/DomainVerification.html"})
    public String verifyDomainForIBM() {
        return "DomainVerification";
    }

    @RequestMapping(value={"/maintenance"})
    public String maintenance(HttpServletRequest request, HttpServletResponse response) {
        if (!"true".equals(this.env.getProperty("maintenance"))) {
            try {
                response.sendRedirect("/");
            }
            catch (IOException e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
        } else {
            return "maintenance";
        }
        return null;
    }

    @RequestMapping(value={"/welcome"})
    public String welcome(@RequestParam(name="jiraSignupinfo", required=false) String jiraSignupinfo, Model model, HttpServletRequest request) {
        List companies;
        if (this.env.getProperty("isLocalDeployment").equals("true") && !PropertyValidator.isValid((Object)request.getParameter("token")) && PropertyValidator.isValid((Collection)(companies = this.companyRepository.findAll()))) {
            return "login";
        }
        if (PropertyValidator.isValid((Object)jiraSignupinfo)) {
            try {
                String signupInfo = this.aLMSyncService.getJiraSignupInfo(jiraSignupinfo);
                model.addAttribute("jiraSignupinfo", (Object)signupInfo);
                String userInfo = EncDecUtility.decryptSimple((String)jiraSignupinfo);
                model.addAttribute("userInfo", (Object)userInfo);
            }
            catch (Exception e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
        }
        if (PropertyValidator.isValid((Object)request.getParameter("token"))) {
            if (this.verifyInvite(request.getParameter("token"))) {
                return "welcome";
            }
            model.addAttribute("error", (Object)"Token has expired or does not exist anymore.");
            return "error";
        }
        return "welcome";
    }

    private boolean verifyInvite(String token) {
        boolean isSuccess = false;
        try {
            Invitation invitation = this.invitationRepository.findById(token);
            if (PropertyValidator.isValid((Object)invitation)) {
                JSONObject jObj = new JSONObject(invitation.getInviteJson());
                Date currDate = new Date();
                Date inviteDate = new Date(jObj.getLong("invitationTime"));
                Calendar c = Calendar.getInstance();
                c.setTime(inviteDate);
                c.add(5, 14);
                if (c.getTime().getTime() >= currDate.getTime()) {
                    isSuccess = true;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return isSuccess;
    }

    @RequestMapping(value={"/welcome-survey"})
    public String welcomeSurvey() {
        return "welcome-survey";
    }

    @RequestMapping(value={"/tfsgettest"})
    public String tfsGettest(Model model) {
        StringBuffer ids = new StringBuffer();
        StringBuffer result = new StringBuffer();
        for (int j = 0; j < 2; ++j) {
            for (int i = 1; i < 200; ++i) {
                ids.append("," + i);
            }
            String idsStr = ids.toString();
            idsStr = idsStr.substring(1, idsStr.length());
            String url = "https://dev.azure.com/loxvo1/15691a74-153e-488c-83f0-46ecdc9e42ba/_apis/wit/workItems?$expand=relations&$depth=1&ids=" + idsStr;
            result.append(this.tFSUtils.getRequest(url, null));
        }
        model.addAttribute("result", (Object)result);
        return "tfs-access-token";
    }

    @RequestMapping(value={"/tfsgettest1"})
    public String tfsGettest1(Model model) {
        return "tfs-access-token";
    }

    @RequestMapping(value={"/jira-oauth"})
    public String jiraOauth(Model model) {
        return "/jira-oauth";
    }

    public String encodeValue(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex.getCause());
        }
    }

    public static void main(String[] args) throws Exception {
        String privateKey = "MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQDFkPMZQaTqsSXI+bSI65rSVaDzic6WFA3WCZMVMi7lYXJAUdkXo4DgdfvEBO21Bno3bXIoxqS411G8S53I39yhSp7z2vcB76uQQifi0LEaklZfbTnFUXcKCyfwgKPp0tQVA+JZei6hnscbSw8qEItdc69ReZ6SK+3LHhvFUUP1nLhJDsgdPHRXSllgZzqvWAXQupGYZVANpBJuK+KAfiaVXCgA71N9xx/5XTSFi5K+e1T4HVnKAzDasAUt7Mmad+1PE+56Gpa73FLk1Ww+xaAEvss6LehjyWHM5iNswoNYzrNS2k6ZYkDnZxUlbrPDELETbz/n3YgBHGUlyrXi2PBjAgMBAAECggEAAtMctqq6meRofuQbEa4Uq5cv0uuQeZLV086VPMNX6k2nXYYODYl36T2mmNndMC5khvBYpn6Ykk/5yjBmlB2nQOMZPLFPwMZVdJ2Nhm+naJLZC0o7fje49PrN2mFsdoZeI+LHVLIrgoILpLdBAz/zTiW+RvLvMnXQU4wdp4eO6i8J/Jwh0AY8rWsAGkk1mdZDwklPZZiwR3z+DDsDwPxFs8z6cE5rWJd2c/fhAQrHwOXyrQPsGyLHTOqS3BkjtEZrKRUlfdgV76VlThwrE5pAWuO0GPyfK/XCklwcNS1a5XxCOq3uUogWRhCsqUX6pYfAVS6xzX56MGDndQVlp7U5uQKBgQDyTDwhsNTWlmr++FyYrc6liSF9NEMBNDubrfLJH1kaOp590bE8fu3BG0UlkVcueUr05e33Kx1DMSFW72lR4dht1jruWsbFp6LlT3SUtyW2kcSet3fC8gySs2r6NncsZ2XFPoxTkalKpQ1atGoBe3XIKeT8RDZtgoLztQy7/7yANQKBgQDQvSHEKS5SttoFFf4YkUh2QmNX5m7XaDlTLB/3xjnlz8NWOweK1aVysb4t2Tct/SR4ZZ/qZDBlaaj4X9h9nlxxIMoXEyX6Ilc4tyCWBXxn6HFMSa/Rrq662Vzz228cPvW2XGOQWdj7IqwKO9cXgJkI5W84YtMtYrTPLDSjhfpxNwKBgGVCoPq/iSOpN0wZhbE1KiCaP8mwlrQhHSxBtS6CkF1a1DPm97g9n6VNfUdnB1Vf0YipsxrSBOe416MaaRyUUzwMBRLqExo1pelJnIIuTG+RWeeu6zkoqUKCAxpQuttu1uRo8IJYZLTSZ9NZhNfbveyKPa2D4G9B1PJ+3rSO+ztlAoGAZNRHQEMILkpHLBfAgsuC7iUJacdUmVauAiAZXQ1yoDDo0Xl4HjcvUSTMkccQIXXbLREh2w4EVqhgR4G8yIk7bCYDmHvWZ2o5KZtD8VO7EVI1kD0z4Zx4qKcggGbp2AINnMYqDetopX7NDbB0KNUklyiEvf72tUCtyDk5QBgSrqcCgYEAnlg3ByRd/qTFz/darZi9ehT68Cq0CS7/B9YvfnF7YKTAv6J2Hd/i9jGKcc27x6IMi0vf7zrqCyTMq56omiLdu941oWfsOnwffWRBInvrUWTj6yGHOYUtg2z4xESUoFYDeWwe/vX6TugL3oXSX3Sy3KWGlJhn/OmsN2fgajHRip0\\=";
    }

    @RequestMapping(value={"/jira-oauth/{key}"})
    public String getJiraOauthToken(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="key") String key, Model model) {
        AlmAccount almAccount;
        String oauthToken = request.getParameter("oauth_token");
        String oauthVerfier = request.getParameter("oauth_verifier");
        Map map = request.getParameterMap();
        boolean isProfile = true;
        String cacheForProfileKey = UserContextUtil.getUserContext().getLoggedInUser().getId() + key;
        ServerCache serverCache = this.serverCacheRepository.findByKey(cacheForProfileKey);
        String userId = null;
        if (!PropertyValidator.isValid((Object)serverCache)) {
            serverCache = this.serverCacheRepository.findByKey(key);
            isProfile = false;
        }
        if (!PropertyValidator.isValid((Object)serverCache)) {
            model.addAttribute("error", (Object)"Callback URL in JIRA App Link And Alm Account mismatch");
            return "/jira-oauth";
        }
        Map kv = (Map)new Gson().fromJson(serverCache.getValue(), Map.class);
        if (isProfile) {
            userId = (String)kv.get("userId");
        }
        String consumerKey = (String)kv.get("consumerKey");
        String privateKey = (String)kv.get("privateKey");
        String jiraBaseUrl = (String)kv.get("jiraBaseUrl");
        String almAccountName = (String)kv.get("almAccountName");
        String almAccountId = (String)kv.get("almAccountId");
        String kendisCallback = (String)kv.get("kendisCallback");
        Boolean forceUsingAuth = (Boolean)kv.get("forceUsingAuth");
        String callbackKey = (String)kv.get("callbackKey");
        String authUrl = (String)kv.get("authUrl");
        if (isProfile) {
            almAccount = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almAccountId));
            authUrl = almAccount.getJiraAuthRedirectURL();
        }
        if (!PropertyValidator.isValid((Object)privateKey) && PropertyValidator.isValid((Object)(almAccount = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almAccountId)))) && PropertyValidator.isValid((Object)almAccount.getJiraOauthToken())) {
            consumerKey = almAccount.getJiraOauthToken().getConsumerKey();
            privateKey = almAccount.getJiraOauthToken().getPrivateKey();
            jiraBaseUrl = almAccount.getUrl();
        }
        String authorizationUrl = jiraBaseUrl + "/plugins/servlet/oauth/authorize";
        if (PropertyValidator.isValid((Object)authUrl)) {
            authorizationUrl = authUrl + "/plugins/servlet/oauth/authorize";
        }
        String requestTokenUrl = jiraBaseUrl + "/plugins/servlet/oauth/request-token";
        String accessTokenUrl = jiraBaseUrl + "/plugins/servlet/oauth/access-token";
        String tokenAuthorizedUrl = authUrl;
        try {
            if (oauthVerfier == null || oauthToken == null) {
                Map tempTokenMap = JiraOauthUtil.getTempTokenMap((String)consumerKey, (String)privateKey, (String)authorizationUrl, (String)requestTokenUrl, (String)tokenAuthorizedUrl);
                response.sendRedirect(authorizationUrl + "?oauth_token=" + (String)tempTokenMap.get("token"));
            } else {
                HashMap<String, Object> authMap = new HashMap<String, Object>();
                if (PropertyValidator.isValid((Object)almAccountName)) {
                    authMap.put("almAccountName", almAccountName);
                }
                if (PropertyValidator.isValid((Object)kendisCallback)) {
                    authMap.put("kendisCallback", kendisCallback);
                }
                if (PropertyValidator.isValid((Object)almAccountId)) {
                    authMap.put("almAccountId", almAccountId);
                }
                if (forceUsingAuth != null) {
                    authMap.put("forceUsingAuth", forceUsingAuth);
                }
                if (PropertyValidator.isValid((Object)callbackKey)) {
                    authMap.put("callbackKey", callbackKey);
                }
                authMap.put("jiraBaseUrl", jiraBaseUrl);
                authMap.put("oauthToken", oauthToken);
                authMap.put("oauthVerfier", oauthVerfier);
                authMap.put("consumerKey", consumerKey);
                authMap.put("privateKey", privateKey);
                authMap.put("authUrl", authUrl);
                String accessToken = JiraOauthUtil.getAccessToken((String)oauthToken, (String)oauthVerfier, (String)consumerKey, (String)privateKey, (String)accessTokenUrl, (String)tokenAuthorizedUrl);
                authMap.put("accessToken", accessToken);
                AlmAccount almAcc = new AlmAccount();
                almAcc.setUrl(jiraBaseUrl);
                almAcc.setUsername("");
                almAcc.setPassword("");
                JiraOauthToken jiraOauthToken = new JiraOauthToken();
                jiraOauthToken.setConsumerKey(consumerKey);
                jiraOauthToken.setPrivateKey(privateKey);
                jiraOauthToken.setOauthToken(oauthToken);
                jiraOauthToken.setOauthVerfier(oauthVerfier);
                jiraOauthToken.setAccessToken(accessToken);
                almAcc.setJiraOauthToken(jiraOauthToken);
                almAcc.setJiraAuthRedirectURL(tokenAuthorizedUrl);
                String result = this.importUtil.validateJiraUser(jiraBaseUrl, "", "", almAcc);
                if (PropertyValidator.isValid((Object)result)) {
                    Map jiraUser = (Map)new Gson().fromJson(result, Map.class);
                    String username = (String)jiraUser.get("name");
                    authMap.put("jiraUserName", username);
                }
                Gson gson = new Gson();
                String jsonauthMapJSON = gson.toJson(authMap);
                serverCache.setValue(jsonauthMapJSON);
                this.serverCacheRepository.save((Object)serverCache);
                String scheme = request.getScheme();
                String host = request.getHeader("Host");
                String contextPath = request.getContextPath();
                String resultPath = scheme + "://" + host + contextPath;
                if (isProfile) {
                    URI oldUri = new URI(resultPath + kendisCallback);
                    String appendQuery = "profileKey=" + key + "&almId=" + almAccountId + "&userId=" + userId;
                    String newQuery = oldUri.getQuery();
                    kendisCallback = newQuery == null ? kendisCallback + "?" + appendQuery : kendisCallback + "&" + appendQuery;
                    resultPath = resultPath + kendisCallback;
                } else {
                    resultPath = resultPath + "/administration?key=" + key + "#almaccounts";
                }
                response.sendRedirect(resultPath);
            }
        }
        catch (Exception ex) {
            String appendQuery;
            int errorCode = 1;
            String errorMessage = "";
            String errorDetails = "";
            if (ex instanceof UnknownHostException) {
                errorCode = 2;
                errorMessage = ex.getMessage();
                errorDetails = StringUtils.getTraceString((Throwable)ex);
            } else if (ex instanceof HttpResponseException) {
                errorCode = 3;
                errorMessage = ex.getMessage();
                errorDetails = StringUtils.getTraceString((Throwable)ex);
            } else if (ex instanceof ConnectException) {
                errorCode = 4;
                errorMessage = ex.getMessage();
                errorDetails = StringUtils.getTraceString((Throwable)ex);
            } else {
                errorMessage = ex.getMessage();
                errorDetails = StringUtils.getTraceString((Throwable)ex);
            }
            kv.put("errorMessage", errorMessage);
            kv.put("errorDetails", errorDetails);
            Gson gson = new Gson();
            String jsonauthMapJSON = gson.toJson((Object)kv);
            serverCache.setValue(jsonauthMapJSON);
            this.serverCacheRepository.save((Object)serverCache);
            String scheme = request.getScheme();
            String host = request.getHeader("Host");
            String contextPath = request.getContextPath();
            String resultPath = scheme + "://" + host + contextPath;
            if (isProfile) {
                appendQuery = "profileKey=" + key + "&almId=" + almAccountId + "&userId=" + userId + "&errorCode=" + errorCode;
                kendisCallback = kendisCallback.contains("?") ? kendisCallback + "&" + appendQuery : kendisCallback + "?" + appendQuery;
                resultPath = resultPath + kendisCallback;
            } else {
                appendQuery = "key=" + key + "&errorCode=" + errorCode;
                resultPath = resultPath + "/administration?" + appendQuery + "#almaccounts";
            }
            try {
                response.sendRedirect(resultPath);
            }
            catch (IOException e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
        return "";
    }

    @RequestMapping(value={"/tfsposttest"})
    public String tfsPosttest(Model model) {
        String url = "https://dev.azure.com/loxvo1/test/_apis/wit/workitems/$bug?api-version=4.1";
        JSONArray ja = new JSONArray();
        try {
            JSONObject jo = new JSONObject();
            jo.put("op", (Object)"add");
            jo.put("path", (Object)"/fields/System.Title");
            jo.put("value", (Object)"Sample task");
            ja.put((Object)jo);
        }
        catch (JSONException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        model.addAttribute("result", (Object)this.tFSUtils.patchRequest(url, ja.toString(), null));
        return "tfs-access-token";
    }

    @RequestMapping(value={"/forgotpassword"})
    public String forgotpassword(HttpServletRequest request, HttpServletResponse response, Model model) {
        try {
            if (PropertyValidator.isValid((Object)request.getParameter("t"))) {
                String t = EncDecUtility.decryptSimple((String)request.getParameter("t"));
                model.addAttribute("email", (Object)t);
            }
        }
        catch (Exception e) {
            StringUtils.getTraceString((Throwable)e);
        }
        return "forgotpassword";
    }

    @RequestMapping(value={"/trial"})
    public String trial() {
        return "trial";
    }

    @RequestMapping(value={"/golab"})
    public String golab() {
        return "golab";
    }

    @RequestMapping(value={"/collab"})
    public String collab() {
        return "collab";
    }

    @RequestMapping(value={"/cancelPaymentKey"}, method={RequestMethod.GET})
    public void cancelPaymentKey(HttpServletResponse response) {
        try {
            response.sendRedirect("/");
        }
        catch (IOException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }

    @RequestMapping(value={"/pricing"})
    public String pricing() {
        return "pricing";
    }

    @RequestMapping(value={"/fixencryption"})
    public String fixencryption(@RequestParam String param) {
        if (param == null || !param.equals("fixit")) {
            return null;
        }
        String accountid = null;
        String password = null;
        DB database = this.mongoTemplate.getDb();
        DBCollection collection = database.getCollection("almAccount");
        BasicDBObject query = new BasicDBObject("password", (Object)new BasicDBObject("$exists", (Object)true));
        DBCursor cursor = collection.find((DBObject)query);
        while (cursor.hasNext()) {
            try {
                DBObject obj = cursor.next();
                String pass = String.valueOf(obj.get("password"));
                ObjectId objectId = (ObjectId)obj.get("_id");
                if (!pass.startsWith("AQICAHiFt/")) {
                    accountid = String.valueOf(obj.get("_id"));
                    password = pass;
                    BasicDBObject newDocument = new BasicDBObject();
                    String decPass = pass;
                    try {
                        decPass = EncDecUtility.decryptTemp((String)pass);
                    }
                    catch (Exception ex) {
                        LOGGER.debug(ex.getMessage());
                    }
                    if (!PropertyValidator.isValid((Object)decPass)) continue;
                    LOGGER.debug("converting  :" + pass + " for account :" + objectId);
                    newDocument.put((Object)"password", (Object)EncDecUtility.encryptKMS((String)decPass));
                    BasicDBObject updateObject = new BasicDBObject();
                    updateObject.put((Object)"$set", (Object)newDocument);
                    BasicDBObject updateQuery = new BasicDBObject();
                    updateQuery.put((Object)"_id", (Object)objectId);
                    collection.update((DBObject)updateQuery, (DBObject)updateObject);
                    continue;
                }
                LOGGER.debug("password already encrypted :" + pass + " for account :" + objectId);
            }
            catch (Exception ex) {
                LOGGER.debug("===================== ALM Account ============= :" + accountid + " password :" + password);
                ex.printStackTrace();
            }
        }
        DBCollection collection1 = database.getCollection("user");
        BasicDBObject query1 = new BasicDBObject();
        DBCursor cursor1 = collection1.find((DBObject)query1);
        while (cursor1.hasNext()) {
            try {
                DBObject obj = cursor1.next();
                ObjectId objectId = (ObjectId)obj.get("_id");
                accountid = String.valueOf(obj.get("_id"));
                DBObject credObj = (DBObject)obj.get("almCredentials");
                if (credObj == null) continue;
                BasicDBList list = (BasicDBList)credObj;
                for (Object singleObj : list) {
                    DBObject singleObj1 = (DBObject)singleObj;
                    password = String.valueOf(singleObj1.get("almPassword"));
                    if (!password.startsWith("AQICAHiFt/")) {
                        try {
                            password = EncDecUtility.decryptTemp((String)password);
                        }
                        catch (Exception ex) {
                            LOGGER.debug(ex.getMessage());
                        }
                        if (!PropertyValidator.isValid((Object)password)) continue;
                        singleObj1.put("almPassword", (Object)EncDecUtility.encryptKMS((String)password));
                        continue;
                    }
                    LOGGER.debug("password already encrypted :" + password + " for user :" + accountid);
                }
                LOGGER.debug("converting :" + password + " for user :" + accountid);
                BasicDBObject newDocument = new BasicDBObject();
                newDocument.put((Object)"almCredentials", (Object)credObj);
                BasicDBObject updateObject = new BasicDBObject();
                updateObject.put((Object)"$set", (Object)newDocument);
                BasicDBObject updateQuery = new BasicDBObject();
                updateQuery.put((Object)"_id", (Object)objectId);
                collection1.update((DBObject)updateQuery, (DBObject)updateObject);
            }
            catch (Exception ex) {
                LOGGER.debug("===================== User Account ============= :" + accountid + " Passowrd : " + password);
                ex.printStackTrace();
            }
        }
        return "";
    }

    @RequestMapping(value={"/new-profile"})
    public String newProfile() {
        return "new-profile-popup";
    }

    @RequestMapping(value={"/pricing-plan"})
    public String pricingplan() {
        return "pricing-plan";
    }

    @RequestMapping(value={"/pricing-new"})
    public String pricingnew() {
        return "pricing-new";
    }

    @RequestMapping(value={"/roadmaps"})
    public String roadmaps() {
        return "roadmaps";
    }

    @RequestMapping(value={"/sprint-report"})
    public String landSprintReportPage(Model model) {
        model.addAttribute("companyId", (Object)UserContextUtil.getUserContext().getCurrentCompanyId());
        model.addAttribute("content_file", (Object)"sprint-report");
        model.addAttribute("content_css", (Object)"");
        model.addAttribute("is_spreport_page", (Object)true);
        return "kendis";
    }

    @RequestMapping(value={"/roadmap"})
    public String landRoadmapPage(Model model) {
        model.addAttribute("companyId", (Object)UserContextUtil.getUserContext().getCurrentCompanyId());
        model.addAttribute("content_file", (Object)"roadmap");
        model.addAttribute("content_css", (Object)"");
        model.addAttribute("is_roadmap_page", (Object)true);
        return "kendis";
    }

    @RequestMapping(value={"/board-roadmap"})
    public String landRoadmapComponent(Model model) {
        model.addAttribute("companyId", (Object)UserContextUtil.getUserContext().getCurrentCompanyId());
        model.addAttribute("content_file", (Object)"roadmap");
        model.addAttribute("content_css", (Object)"");
        model.addAttribute("is_roadmap_page", (Object)false);
        return "roadmap";
    }

    @RequestMapping(value={"/cfg"})
    public String loadCFG(Model model) {
        model.addAttribute("companyId", (Object)UserContextUtil.getUserContext().getCurrentCompanyId());
        model.addAttribute("content_file", (Object)"cfg-item");
        model.addAttribute("content_css", (Object)"");
        model.addAttribute("is_page", (Object)true);
        return "kendis";
    }

    @RequestMapping(value={"/cfg-{item}"})
    public String loadItemCFG(Model model, HttpServletRequest request, @PathVariable(value="item") String code) {
        model.addAttribute("companyId", (Object)UserContextUtil.getUserContext().getCurrentCompanyId());
        model.addAttribute("content_file", (Object)"cfg-item");
        model.addAttribute("content_css", (Object)"");
        model.addAttribute("highcharts", (Object)request.getParameter("highcharts"));
        model.addAttribute("datepicker", (Object)request.getParameter("datepicker"));
        model.addAttribute("view_css", (Object)request.getParameter("type"));
        model.addAttribute("is_page", (Object)false);
        return "cfg-item";
    }

    @RequestMapping(value={"/charts", "/charts/board-progress", "/charts/scope-changes", "/charts/dependencies-progress", "/charts/dependencies-dashboard", "/charts/objectives-dashboard", "/board-progress", "/scope-changes", "/dependencies-progress", "/dependencies-dashboard", "/objectives-dashboard"})
    public String charts(Model model) {
        model.addAttribute("companyId", (Object)UserContextUtil.getUserContext().getCurrentCompanyId());
        model.addAttribute("content_file", (Object)"report-chart");
        model.addAttribute("content_css", (Object)"smart-report");
        return "kendis";
    }

    @RequestMapping(value={"/charts-content"})
    public String charts2() {
        return "report-chart-content";
    }

    private String loadGanttCSS() {
        StringBuilder css = new StringBuilder();
        try {
            InputStream is = null;
            is = this.getClass().getResourceAsStream("/static/assets/css/gantt.stockholm.css");
            css.append(IOUtils.toString((InputStream)is));
            is.close();
            is = this.getClass().getResourceAsStream("/static/assets/css/gantt.css");
            css.append(IOUtils.toString((InputStream)is));
            is.close();
        }
        catch (Exception e) {
            LOGGER.debug("road map css exp  : s" + e.getMessage());
        }
        return css.toString();
    }

    @RequestMapping(value={"/accounts"})
    public String accounts(HttpServletRequest request, HttpServletResponse response, Model model) {
        List companies = (List)UserContextUtil.getUserContext().getUserContextDTO().getContextMap().get("companies");
        String parentDomain = InternetDomainName.from((String)request.getServerName()).topPrivateDomain().toString();
        for (Company company : companies) {
            String url = request.getScheme() + "://" + company.getUrlPrefix() + "." + parentDomain + ":" + request.getServerPort();
            company.setUrl(url);
        }
        model.addAttribute("companies", (Object)companies);
        return "accounts";
    }

    @RequestMapping(value={"/resetpassword"})
    public String resetPassword(HttpServletRequest request, HttpServletResponse response) {
        return "resetpassword";
    }

    @RequestMapping(value={"/denied"})
    public String inactiveAccount(HttpServletRequest request, HttpServletResponse response, Model model) {
        SAMLConfig config;
        String defaultMsg = "Your account is inactive, please contact your Kendis admin to activate your account. ";
        model.addAttribute("custom_message", (Object)defaultMsg);
        if ("true".equals(request.getParameter("saml"))) {
            model.addAttribute("custom_message", (Object)"Your account supports Single Sign-On. You can <a href='/login/saml'>sign in</a> with your Corporate Account.");
        } else if (UserContextUtil.getUserContext().getLoggedInUser().isLdap()) {
            Config config2;
            boolean loginFromLdap;
            List configList = this.configRepository.findAll();
            if (PropertyValidator.isValid((Collection)configList) && (loginFromLdap = (config2 = (Config)configList.get(0)).getLdapConfig().isLogin()) && PropertyValidator.isValid((Object)config2.getLdapConfig().getCustomMsg())) {
                model.addAttribute("custom_message", (Object)config2.getLdapConfig().getCustomMsg());
            }
        } else if (UserContextUtil.getUserContext().getLoggedInUser().isOkta() && PropertyValidator.isValid((Object)(config = this.samlConfigRepository.findByTenant(UserContextUtil.getUserContext().getCurrentCompany().getTenant())).getCustomMsg())) {
            model.addAttribute("custom_message", (Object)config.getCustomMsg());
        }
        return "inactive";
    }

    @RequestMapping(value={"/no-signup"})
    public String signUp(HttpServletRequest request, HttpServletResponse response) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                Cookie cookie = cookies[i];
                cookie.setValue(null);
                cookie.setMaxAge(0);
                response.addCookie(cookie);
            }
        }
        request.getSession().invalidate();
        return "sign-up";
    }

    @RequestMapping(value={"/sboard"})
    public String sboard() {
        return "sessionboards";
    }

    @RequestMapping(value={"/almsetup"})
    public String almSetup() {
        return "almsetup";
    }

    @RequestMapping(value={"/kendistest"})
    public String kendisTest() {
        return "kendistest";
    }

    @RequestMapping(value={"/importcsv"})
    public String importCSV() {
        return "importcsv";
    }

    @RequestMapping(value={"/profile"})
    public String profile() {
        return "profile";
    }

    @RequestMapping(value={"/ui-templates"})
    public String loadTemplates(Model model) {
        return "ui-templates";
    }

    @RequestMapping(value={"/old-session"})
    public String oldBoard(Model model) {
        model.addAttribute("companyId", (Object)UserContextUtil.getUserContext().getCurrentCompanyId());
        return "board";
    }

    @RequestMapping(value={"/session"})
    public String board(Model model) {
        model.addAttribute("companyId", (Object)UserContextUtil.getUserContext().getCurrentCompanyId());
        model.addAttribute("is_jira", (Object)true);
        return "piboard";
    }

    @RequestMapping(value={"/connection"})
    public String connection(Model model) {
        model.addAttribute("companyId", (Object)UserContextUtil.getUserContext().getCurrentCompanyId());
        return "connection";
    }

    @RequestMapping(value={"/pisession"})
    public String piBoard(Model model) {
        model.addAttribute("companyId", (Object)UserContextUtil.getUserContext().getCurrentCompanyId());
        return "piboard";
    }

    @RequestMapping(value={"/pisessioncan"})
    public String piBoardCan(Model model) {
        model.addAttribute("companyId", (Object)UserContextUtil.getUserContext().getCurrentCompanyId());
        return "piboard-can";
    }

    @RequestMapping(value={"/pisessionabc"})
    public String piBoardAbc(Model model) {
        model.addAttribute("companyId", (Object)UserContextUtil.getUserContext().getCurrentCompanyId());
        return "piboard-hybrid";
    }

    @RequestMapping(value={"/sessions"})
    public String boards(Model model) {
        model.addAttribute("companyId", (Object)UserContextUtil.getUserContext().getCurrentCompanyId());
        model.addAttribute("content_file", (Object)"boards");
        model.addAttribute("content_css", (Object)"lrg-lftpnl");
        return "kendis";
    }

    @RequestMapping(value={"/webhook-health"})
    public String webhookHealth(Model model) {
        return "webhookHealth";
    }

    @RequestMapping(value={"/administration"})
    public String administration(Model model) {
        model.addAttribute("companyId", (Object)UserContextUtil.getUserContext().getCurrentCompanyId());
        return "administration";
    }

    @RequestMapping(value={"/report"})
    public String reprot(Model model) {
        model.addAttribute("companyId", (Object)UserContextUtil.getUserContext().getCurrentCompanyId());
        model.addAttribute("content_file", (Object)"report");
        model.addAttribute("content_css", (Object)"reports rpg");
        return "kendis";
    }

    @RequestMapping(value={"/dashboard"})
    public String landDashBoardPage(Model model) {
        model.addAttribute("companyId", (Object)UserContextUtil.getUserContext().getCurrentCompanyId());
        model.addAttribute("content_file", (Object)"kendis-dashboard");
        model.addAttribute("content_css", (Object)"");
        model.addAttribute("is_spreport_page", (Object)true);
        return "kendis-dashboard";
    }

    @RequestMapping(value={"/riskregister"})
    public String riskRegister() {
        return "riskregister";
    }

    @RequestMapping(value={"/gameplay"})
    public String gamePlay(@RequestParam String id) {
        return "game-play";
    }

    @RequestMapping(value={"/my-view"})
    public String myView() {
        return "my-view";
    }

    @RequestMapping(value={"/flexboard"})
    public String flexBoard() {
        return "flexboard";
    }

    @RequestMapping(value={"/solutions"})
    public String solutionBoard() {
        return "solutionboard";
    }

    @RequestMapping(value={"/alm"})
    public String setupAlm(ModelAndView model) {
        model.addObject("testPath", (Object)"test value");
        return "setups";
    }

    @RequestMapping(value={"/"})
    public String rootHandling(HttpServletRequest request, HttpServletResponse response, Model model) {
        String referer;
        if (request != null && response != null && (referer = request.getHeader("referer")) != null) {
            try {
                String query = new URL(referer).getQuery();
                if (query != null && query.contains("referer=")) {
                    String refererUrl = query.substring(query.indexOf("=") + 1, query.length());
                    response.sendRedirect("/" + refererUrl);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        model.addAttribute("companyId", (Object)UserContextUtil.getUserContext().getCurrentCompanyId());
        model.addAttribute("content_file", (Object)"boards");
        model.addAttribute("content_css", (Object)"lrg-lftpnl");
        return "kendis";
    }

    @RequestMapping(value={"/userslimit"})
    public String usersLimit(HttpServletRequest request, Model model) {
        String t = request.getParameter("t");
        if (t != null) {
            try {
                String dt = EncDecUtility.decrypt((String)t);
                String[] dtArr = dt.split(":");
                model.addAttribute("pusers", (Object)dtArr[0]);
                model.addAttribute("email", (Object)dtArr[1]);
                if (dtArr.length > 2) {
                    model.addAttribute("isGuest", (Object)dtArr[2]);
                }
            }
            catch (Exception e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
        } else {
            model.addAttribute("pusers", (Object)4);
            model.addAttribute("email", (Object)"arbab@kendis.io");
        }
        return "userslimit";
    }

    @RequestMapping(value={"/system"})
    public String monitor(HttpServletRequest request, HttpServletResponse response, Model model) throws Exception {
        if (!SystemUtil.isSysEnabled) {
            return null;
        }
        if (UserContextUtil.getUserContext() != null) {
            model.addAttribute("debug", (Object)UserContextUtil.getUserContext().isDebug());
        }
        if (this.env.getProperty("isLocalDeployment").equals("true")) {
            return "system";
        }
        return null;
    }

    @RequestMapping(value={"/browse"})
    public String browseItem(Model model) {
        if (UserContextUtil.getUserContext().getCurrentCompany().isEnableArt()) {
            String cid = UserContextUtil.getUserContext().getCurrentCompany().getId();
            model.addAttribute("companyId", (Object)cid);
            return "browse";
        }
        return "";
    }

    @RequestMapping(value={"/repay"}, method={RequestMethod.POST})
    public ResponseEntity<Object> rePayBill(@RequestBody String requestBody) {
        Object intent = null;
        HashMap responseData = new HashMap();
        Date nextPaymentDate = null;
        Gson gson = new Gson();
        1 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap requestMap = (HashMap)gson.fromJson(requestBody, T.getType());
        try {
            String failedTranctionId = (String)requestMap.get("transaction_Id");
            String payment_method_id = (String)requestMap.get("payment_method_id");
            String payment_intent_id = (String)requestMap.get("payment_intent_id");
            String customerId = "";
            Company paymentDetails = this.companyRepository.findById(UserContextUtil.getUserContext().getCurrentCompanyId());
            if (paymentDetails != null) {
                paymentDetails = this.paymentService.fixPaymentPlanForCompany(paymentDetails);
                customerId = paymentDetails.getPaymentDetails().getCustomerId();
                PaymentChargeVO pcVO = this.paymentService.charge(paymentDetails, customerId, payment_intent_id, false, true);
                responseData = this.generateResponse(pcVO, paymentDetails.getPaymentDetails().getPlanType());
                if (pcVO.getIntent() != null && pcVO.getIntent().getStatus().equals("requires_action")) {
                    return new ResponseEntity((Object)responseData, HttpStatus.ACCEPTED);
                }
                if (pcVO.getIntent() != null && pcVO.getIntent().getStatus().equals("succeeded")) {
                    if (payment_method_id != null) {
                        paymentDetails.getPaymentDetails().setIntent_id(payment_method_id);
                    }
                    if (pcVO.getDate() != null) {
                        nextPaymentDate = pcVO.getDate();
                    } else if (pcVO.getError() != null) {
                        HashMap<String, String> responseJson = new HashMap<String, String>();
                        responseJson.put("message", pcVO.getError());
                        return new ResponseEntity(responseJson, HttpStatus.NOT_ACCEPTABLE);
                    }
                    if (nextPaymentDate != null) {
                        paymentDetails.setNextPaymentDate(nextPaymentDate);
                        paymentDetails.setExpiryDate(null);
                        paymentDetails.setRetry(false);
                        this.paymentTransactionsRepository.delete((Serializable)((Object)failedTranctionId));
                    }
                    this.companyRepository.save((Object)paymentDetails);
                }
            }
        }
        catch (Exception ex) {
            StringUtils.getTraceString((Throwable)ex);
            HashMap<String, String> errorResponse = new HashMap<String, String>();
            errorResponse.put("message", ex.getMessage());
            return new ResponseEntity(errorResponse, HttpStatus.ACCEPTED);
        }
        return new ResponseEntity(responseData, HttpStatus.ACCEPTED);
    }

    @RequestMapping(value={"/createCustomer/{isTransaction}"}, method={RequestMethod.POST})
    public ResponseEntity<Object> createCustomer(@RequestBody PaymentDetails paymentDetailsNew, @PathVariable(value="isTransaction") Boolean isTransaction) {
        if (!isTransaction.booleanValue()) {
            PaymentDetails paymentDetails = (PaymentDetails)this.paymentRecordRepository.save((Object)paymentDetailsNew);
        }
        if (paymentDetailsNew.getIntent_id() != null) {
            this.paymentRecordRepository.delete((Serializable)((Object)paymentDetailsNew.getIntent_id()));
        }
        Stripe.apiKey = this.env.getProperty("stripe.apiKey");
        HashMap<String, String> customerParams = new HashMap<String, String>();
        customerParams.put("email", paymentDetailsNew.getEmail());
        customerParams.put("source", paymentDetailsNew.getStripeSource());
        PaymentDetails paymentDetails = this.companyRepository.findById(UserContextUtil.getUserContext().getCurrentCompanyId()).getPaymentDetails();
        String customerId = null;
        if (paymentDetails != null) {
            customerId = paymentDetails.getCustomerId();
        }
        Customer customer = null;
        Date nextPaymentDate = null;
        Company company = null;
        Company oldCompanyData = new Company();
        try {
            if (customerId != null) {
                customer = Customer.retrieve((String)customerId);
            }
            if (customerId != null && !Boolean.TRUE.equals(customer.getDeleted())) {
                customer.update(customerParams);
            } else {
                customer = Customer.create(customerParams);
            }
            company = this.companyRepository.findById(UserContextUtil.getUserContext().getCurrentCompany().getId());
            oldCompanyData.setUserCount(paymentDetailsNew.getUserCount());
            oldCompanyData.setExpiryDate(company.getExpiryDate());
            paymentDetails = new PaymentDetails();
            paymentDetails.setCustomerId(customer.getId());
            paymentDetails.setEmail(paymentDetailsNew.getEmail());
            paymentDetails.setAddress(paymentDetailsNew.getAddress());
            paymentDetails.setName(paymentDetailsNew.getName());
            paymentDetails.setCountry(paymentDetailsNew.getCountry());
            paymentDetails.setPostalCode(paymentDetailsNew.getPostalCode());
            paymentDetails.setVatCountry(new VatCountry(paymentDetailsNew.getVatCountryId()));
            paymentDetails.setCity(paymentDetailsNew.getCity());
            paymentDetails.setBillingCompanyName(paymentDetailsNew.getBillingCompanyName());
            paymentDetails.setVatNo(paymentDetailsNew.getVatNo());
            company.setPaymentFormat("new");
            company.setDuration(paymentDetailsNew.getDuration());
            company.setUserCount(paymentDetailsNew.getUserCount());
            company.setPlanPrice(paymentDetailsNew.getPlanPrice());
            company.setTotalPrice(paymentDetailsNew.getTotalPrice());
            company.setVatPct(paymentDetailsNew.getVatPct());
            company.setPaymentDetails(paymentDetails);
            company.setExpiryDate(null);
            if (company.getNextPaymentDate() == null) {
                Object pcVO = null;
                if (pcVO.getDate() != null) {
                    nextPaymentDate = pcVO.getDate();
                } else if (pcVO.getError() != null) {
                    HashMap<String, String> responseJson = new HashMap<String, String>();
                    responseJson.put("message", pcVO.getError());
                    return new ResponseEntity(responseJson, HttpStatus.NOT_ACCEPTABLE);
                }
            }
            if (nextPaymentDate != null) {
                company.setNextPaymentDate(nextPaymentDate);
                company.setRetry(false);
            } else {
                Calendar cal = Calendar.getInstance();
                cal.add(2, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                company.setNextPaymentDate(cal.getTime());
                company.setRetry(true);
            }
            this.companyRepository.save((Object)company);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            HashMap<String, String> responseJson = new HashMap<String, String>();
            responseJson.put("message", e.getMessage());
            return new ResponseEntity(responseJson, HttpStatus.NOT_ACCEPTABLE);
        }
        return new ResponseEntity((Object)company, HttpStatus.ACCEPTED);
    }

    @RequestMapping(value={"/pay"}, method={RequestMethod.POST})
    public ResponseEntity<Object> paymentMethod(@RequestBody String requestBody) {
        Gson gson = new Gson();
        2 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap requestMap = (HashMap)gson.fromJson(requestBody, T.getType());
        String email = (String)requestMap.get("email");
        String name = (String)requestMap.get("name");
        String country = (String)requestMap.get("country");
        String address = (String)requestMap.get("address");
        String vatNo = (String)requestMap.get("vatNo");
        double planPrice = (Double)requestMap.get("planPrice");
        double vatPct = (Double)requestMap.get("vatPct");
        double totalPrice = (Double)requestMap.get("totalPrice");
        String vatCountryId = (String)requestMap.get("vatCountryId");
        double duration = (Double)requestMap.get("duration");
        String userCount = (String)requestMap.get("userCount");
        String planType = (String)requestMap.get("planType");
        String payment_method_id = (String)requestMap.get("payment_method_id");
        String payment_intent_id = (String)requestMap.get("payment_intent_id");
        String billingCompanyName = (String)requestMap.get("billingCompanyName");
        BigDecimal roundedplanPrice = null;
        BigDecimal roundedChargedAmount = null;
        roundedplanPrice = new BigDecimal(planPrice).setScale(0, RoundingMode.HALF_UP);
        long resultplanPrice = roundedplanPrice.longValue();
        roundedChargedAmount = new BigDecimal(totalPrice).setScale(0, RoundingMode.HALF_UP);
        long resultChargedAmount = roundedChargedAmount.longValue();
        planPrice = resultplanPrice;
        totalPrice = resultChargedAmount;
        Company company = null;
        Company oldCompanyData = new Company();
        PaymentChargeVO pcVO = null;
        Customer customer = null;
        PaymentDetails paymentDetails = null;
        Date nextPaymentDate = null;
        try {
            HashMap<String, String> customerParams = new HashMap<String, String>();
            String customerId = null;
            customerParams.put("email", email);
            paymentDetails = this.companyRepository.findById(UserContextUtil.getUserContext().getCurrentCompanyId()).getPaymentDetails();
            if (paymentDetails != null) {
                customerId = paymentDetails.getCustomerId();
            }
            if (customerId != null) {
                customer = Customer.retrieve((String)customerId);
            }
            if (customerId != null && !Boolean.TRUE.equals(customer.getDeleted())) {
                customer.update(customerParams);
            } else {
                customer = Customer.create((CustomerCreateParams)new CustomerCreateParams.Builder().setEmail(email).build());
                customerId = customer.getId();
            }
            company = this.companyRepository.findById(UserContextUtil.getUserContext().getCurrentCompany().getId());
            oldCompanyData.setUserCount(Long.parseLong(userCount));
            oldCompanyData.setExpiryDate(company.getExpiryDate());
            PaymentPackageConfig paymentPackageConfig = PropertyValidator.isValid((Object)company.getPaymentPackageConfig()) ? company.getPaymentPackageConfig() : new PaymentPackageConfig();
            paymentDetails = new PaymentDetails();
            paymentDetails.setCustomerId(customerId);
            paymentDetails.setIntent_id(payment_method_id);
            paymentDetails.setEmail(email);
            paymentDetails.setAddress(address);
            paymentDetails.setName(name);
            paymentDetails.setCountry(country);
            paymentDetails.setVatCountry(new VatCountry(vatCountryId));
            paymentDetails.setBillingCompanyName(billingCompanyName);
            paymentDetails.setVatNo(vatNo);
            if (planType.equalsIgnoreCase("Basic")) {
                paymentDetails.setPlanType(PaymentDetails.PlanType.Basic.toString());
                paymentPackageConfig.setSAML(Boolean.valueOf(false));
                paymentPackageConfig.setLDAP(Boolean.valueOf(false));
                paymentPackageConfig.setLiveChat(Boolean.valueOf(false));
                paymentPackageConfig.setoAuth(Boolean.valueOf(false));
                paymentPackageConfig.setSecurity(Boolean.valueOf(false));
                paymentPackageConfig.setSolutionBoard(Boolean.valueOf(false));
                paymentPackageConfig.setMFA(Boolean.valueOf(false));
            } else {
                paymentDetails.setPlanType(PaymentDetails.PlanType.Premium.toString());
                paymentPackageConfig.setSAML(Boolean.valueOf(true));
                paymentPackageConfig.setLDAP(Boolean.valueOf(true));
                paymentPackageConfig.setLiveChat(Boolean.valueOf(true));
                paymentPackageConfig.setoAuth(Boolean.valueOf(true));
                paymentPackageConfig.setSecurity(Boolean.valueOf(true));
                paymentPackageConfig.setSolutionBoard(Boolean.valueOf(true));
                paymentPackageConfig.setMFA(Boolean.valueOf(true));
            }
            company.setPaymentPackageConfig(paymentPackageConfig);
            company.setDuration((long)duration);
            company.setUserCount(Long.parseLong(userCount));
            company.setPlanPrice((long)planPrice);
            company.setTotalPrice((long)totalPrice);
            company.setVatPct((float)vatPct);
            company.setPaymentDetails(paymentDetails);
            company.setExpiryDate(null);
            company.setPaymentFormat("new");
            UserContextUtil.getUserContext().getCurrentCompany().setPaymentPackageConfig(paymentPackageConfig);
            if (company.getNextPaymentDate() == null) {
                pcVO = this.paymentService.charge(company, customerId, payment_intent_id, false, false);
                if (pcVO.getIntent() != null && pcVO.getIntent().getStatus().equals("requires_action")) {
                    return new ResponseEntity((Object)this.generateResponse(pcVO, planType), HttpStatus.ACCEPTED);
                }
                if (pcVO.getDate() != null) {
                    nextPaymentDate = pcVO.getDate();
                } else if (pcVO.getError() != null) {
                    HashMap<String, String> responseJson = new HashMap<String, String>();
                    responseJson.put("message", pcVO.getError());
                    return new ResponseEntity(responseJson, HttpStatus.ACCEPTED);
                }
            }
            if (nextPaymentDate != null) {
                company.setNextPaymentDate(nextPaymentDate);
                company.setRetry(false);
            } else {
                Calendar cal = Calendar.getInstance();
                cal.add(2, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                company.setNextPaymentDate(cal.getTime());
                company.setRetry(true);
            }
            company.getPaymentDetails().setCustomerId(pcVO.getCustomerId());
            this.companyRepository.save((Object)company);
            return new ResponseEntity((Object)this.generateResponse(pcVO, company.getPaymentDetails().getPlanType()), HttpStatus.ACCEPTED);
        }
        catch (Exception e) {
            StringUtils.getTraceString((Throwable)e);
            HashMap<String, String> errorResponse = new HashMap<String, String>();
            errorResponse.put("message", e.getMessage());
            return new ResponseEntity(errorResponse, HttpStatus.ACCEPTED);
        }
    }

    private HashMap<String, Object> generateResponse(PaymentChargeVO pcVo, String planType) {
        PaymentIntent intent = pcVo.getIntent() != null ? pcVo.getIntent() : null;
        HashMap<String, Object> responseData = new HashMap<String, Object>();
        if (intent != null && intent.getStatus().equals("requires_action") && intent.getNextAction().getType().equals("use_stripe_sdk")) {
            responseData.put("requires_action", true);
            responseData.put("payment_intent_client_secret", intent.getClientSecret());
        } else if (intent != null && intent.getStatus().equals("succeeded")) {
            responseData.put("success", true);
            responseData.put("plantype", planType);
        } else {
            responseData.put("Error", pcVo.getError());
            return responseData;
        }
        return responseData;
    }

    @RequestMapping(value={"/changeCard"}, method={RequestMethod.POST})
    public ResponseEntity<Object> changeCard(@RequestBody PaymentDetails paymentDetailsNew) {
        HashMap responseJson;
        Stripe.apiKey = this.env.getProperty("stripe.apiKey");
        HashMap<String, String> customerParams = new HashMap<String, String>();
        customerParams.put("email", paymentDetailsNew.getEmail());
        Company company = this.companyRepository.findById(UserContextUtil.getUserContext().getCurrentCompanyId());
        PaymentDetails paymentDetails = company.getPaymentDetails();
        String customerId = null;
        if (paymentDetails == null) {
            HashMap responseJson2 = new HashMap();
            return new ResponseEntity(responseJson2, HttpStatus.NOT_ACCEPTABLE);
        }
        customerId = paymentDetails.getCustomerId();
        paymentDetails.setIntent_id(paymentDetailsNew.getStripeSource());
        paymentDetails.setEmail(paymentDetailsNew.getEmail());
        paymentDetails.setName(paymentDetailsNew.getName());
        Customer customer = null;
        try {
            if (customerId != null) {
                try {
                    customer = Customer.retrieve((String)customerId);
                }
                catch (Exception e) {
                    LOGGER.error(StringUtils.getTraceString((Throwable)e));
                }
            }
            if (customer != null && customerId != null && !Boolean.TRUE.equals(customer.getDeleted())) {
                customer.update(customerParams);
            } else {
                customer = Customer.create(customerParams);
                paymentDetails.setCustomerId(customer.getId());
            }
            Date normalizedNextPaymentDate = this.normalizedDate(company.getNextPaymentDate());
            Date normalizedCurrentDate = this.normalizedDate(new Date());
            if (normalizedNextPaymentDate.equals(normalizedCurrentDate) || normalizedNextPaymentDate.before(normalizedCurrentDate)) {
                if (company.getExpiryDate() != null) {
                    company.setExpiryDate(null);
                }
                company.setRetry(true);
            }
            company.setPaymentDetails(paymentDetails);
            this.companyRepository.save((Object)company);
            PaymentMethod paymentMethod = PaymentMethod.retrieve((String)paymentDetailsNew.getStripeSource());
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("customer", customer.getId());
            PaymentMethod updatedPaymentMethod = paymentMethod.attach(params);
            responseJson = new HashMap();
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            HashMap<String, String> responseJson3 = new HashMap<String, String>();
            responseJson3.put("message", e.getMessage());
            return new ResponseEntity(responseJson3, HttpStatus.NOT_ACCEPTABLE);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/fetchPaymentRecord/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<Object> fetchCustomer(@PathVariable(value="id") String id) {
        PaymentDetails paymentRecord = this.paymentRecordRepository.findByStripeSource(id);
        return new ResponseEntity((Object)paymentRecord, HttpStatus.ACCEPTED);
    }

    @RequestMapping(value={"/createCustomer/{isTransaction}/{planType}"}, method={RequestMethod.POST})
    public ResponseEntity<Object> createCustomer(@RequestBody PaymentDetails paymentDetailsNew, @PathVariable(value="isTransaction") Boolean isTransaction, @PathVariable(value="planType") String planType) {
        if (!isTransaction.booleanValue()) {
            PaymentDetails paymentDetailsSaved = (PaymentDetails)this.paymentRecordRepository.save((Object)paymentDetailsNew);
            return new ResponseEntity((Object)paymentDetailsSaved.getId(), HttpStatus.ACCEPTED);
        }
        if (paymentDetailsNew.getId() != null) {
            this.paymentRecordRepository.delete((Serializable)((Object)paymentDetailsNew.getId()));
        }
        Stripe.apiKey = this.env.getProperty("stripe.apiKey");
        HashMap<String, String> customerParams = new HashMap<String, String>();
        customerParams.put("email", paymentDetailsNew.getEmail());
        PaymentDetails paymentDetails = this.companyRepository.findById(UserContextUtil.getUserContext().getCurrentCompanyId()).getPaymentDetails();
        String customerId = null;
        if (paymentDetails != null) {
            customerId = paymentDetails.getCustomerId();
        }
        Customer customer = null;
        Date nextPaymentDate = null;
        Company company = null;
        Company oldCompanyData = new Company();
        try {
            if (customerId != null) {
                customer = Customer.retrieve((String)customerId);
            }
            if (customerId != null && !Boolean.TRUE.equals(customer.getDeleted())) {
                customer.update(customerParams);
            } else {
                customer = Customer.create(customerParams);
            }
            company = this.companyRepository.findById(UserContextUtil.getUserContext().getCurrentCompany().getId());
            oldCompanyData.setUserCount(paymentDetailsNew.getUserCount());
            oldCompanyData.setExpiryDate(company.getExpiryDate());
            PaymentPackageConfig paymentPackageConfig = PropertyValidator.isValid((Object)company.getPaymentPackageConfig()) ? company.getPaymentPackageConfig() : new PaymentPackageConfig();
            paymentDetails = new PaymentDetails();
            paymentDetails.setCustomerId(customer.getId());
            paymentDetails.setEmail(paymentDetailsNew.getEmail());
            paymentDetails.setAddress(paymentDetailsNew.getAddress());
            paymentDetails.setName(paymentDetailsNew.getName());
            paymentDetails.setCountry(paymentDetailsNew.getCountry());
            paymentDetails.setPostalCode(paymentDetailsNew.getPostalCode());
            paymentDetails.setVatCountry(new VatCountry(paymentDetailsNew.getVatCountryId()));
            paymentDetails.setCity(paymentDetailsNew.getCity());
            paymentDetails.setBillingCompanyName(paymentDetailsNew.getBillingCompanyName());
            paymentDetails.setVatNo(paymentDetailsNew.getVatNo());
            if (planType.equalsIgnoreCase("Basic")) {
                paymentDetails.setPlanType(PaymentDetails.PlanType.Basic.toString());
                paymentPackageConfig.setSAML(Boolean.valueOf(false));
                paymentPackageConfig.setLDAP(Boolean.valueOf(false));
                paymentPackageConfig.setLiveChat(Boolean.valueOf(false));
                paymentPackageConfig.setoAuth(Boolean.valueOf(false));
                paymentPackageConfig.setSecurity(Boolean.valueOf(false));
                paymentPackageConfig.setMFA(Boolean.valueOf(false));
                paymentPackageConfig.setSolutionBoard(Boolean.valueOf(false));
            } else {
                paymentDetails.setPlanType(PaymentDetails.PlanType.Premium.toString());
                paymentPackageConfig.setSAML(Boolean.valueOf(true));
                paymentPackageConfig.setLDAP(Boolean.valueOf(true));
                paymentPackageConfig.setLiveChat(Boolean.valueOf(true));
                paymentPackageConfig.setoAuth(Boolean.valueOf(true));
                paymentPackageConfig.setSecurity(Boolean.valueOf(true));
                paymentPackageConfig.setSolutionBoard(Boolean.valueOf(true));
                paymentPackageConfig.setMFA(Boolean.valueOf(true));
            }
            company.setPaymentPackageConfig(paymentPackageConfig);
            company.setDuration(paymentDetailsNew.getDuration());
            company.setUserCount(paymentDetailsNew.getUserCount());
            company.setPlanPrice(paymentDetailsNew.getPlanPrice());
            company.setTotalPrice(paymentDetailsNew.getTotalPrice());
            company.setVatPct(paymentDetailsNew.getVatPct());
            company.setPaymentDetails(paymentDetails);
            company.setExpiryDate(null);
            if (nextPaymentDate != null) {
                company.setNextPaymentDate(nextPaymentDate);
                company.setRetry(false);
            } else {
                Calendar cal = Calendar.getInstance();
                cal.add(2, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                company.setNextPaymentDate(cal.getTime());
                company.setRetry(true);
            }
            this.companyRepository.save((Object)company);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            HashMap<String, String> responseJson = new HashMap<String, String>();
            responseJson.put("message", e.getMessage());
            return new ResponseEntity(responseJson, HttpStatus.NOT_ACCEPTABLE);
        }
        return new ResponseEntity((Object)company, HttpStatus.ACCEPTED);
    }

    @RequestMapping(value={"/jira/server/oauth2"})
    public void jiraServerOauth2(HttpServletRequest request, HttpServletResponse response) {
        AlmAccount almAccount;
        CloseableHttpClient httpClient = HttpClients.createMinimal();
        String error = request.getParameter("error");
        String code = request.getParameter("code");
        String serverCacheKey = request.getParameter("state");
        String cacheForProfileKey = UserContextUtil.getUserContext().getLoggedInUser().getId() + serverCacheKey;
        ServerCache serverCache = this.serverCacheRepository.findByKey(cacheForProfileKey);
        if (!PropertyValidator.isValid((Object)serverCache)) {
            if (!PropertyValidator.isValid((Object)error)) {
                error = "No cache found against state.";
            }
            try {
                response.sendRedirect("/authError?error=" + error + "&authType=jira");
            }
            catch (Exception exception) {
                LOGGER.error(StringUtils.getTraceString((Throwable)exception));
            }
        }
        HashMap serverCacheMap = (HashMap)new Gson().fromJson(serverCache.getValue(), HashMap.class);
        String baseUrl = (String)serverCacheMap.get("kendisCallback");
        String baseUrlHash = (String)serverCacheMap.get("kendisCallbackHash");
        String almAccountId = (String)serverCacheMap.get("almAccountId");
        String userId = (String)serverCacheMap.get("userId");
        String oAuthCallbackUrl = (String)serverCacheMap.get("authUrl");
        String almUrl = (String)serverCacheMap.get("url");
        String secretKey = (String)serverCacheMap.get("secretKey");
        String clientId = (String)serverCacheMap.get("clientId");
        Boolean isProfileObj = serverCacheMap.getOrDefault("isProfile", false);
        String scheme = request.getScheme();
        String host = request.getHeader("Host");
        boolean isProfile = isProfileObj instanceof String ? Boolean.parseBoolean((String)((Object)isProfileObj)) : isProfileObj;
        HashMap<String, Object> redirectQueryParams = new HashMap<String, Object>();
        redirectQueryParams.put("baseUrl", baseUrl);
        redirectQueryParams.put("baseUrlHash", baseUrlHash);
        redirectQueryParams.put("isProfile", isProfile);
        redirectQueryParams.put("serverCacheKey", serverCacheKey);
        redirectQueryParams.put("almAccountId", almAccountId);
        redirectQueryParams.put("userId", userId);
        redirectQueryParams.put("scheme", scheme);
        redirectQueryParams.put("host", host);
        if (!PropertyValidator.isValid((Object)secretKey) && PropertyValidator.isValid((Object)(almAccount = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almAccountId)))) && PropertyValidator.isValid((Object)almAccount.getJiraOauthToken())) {
            secretKey = almAccount.getSecretKey();
            oAuthCallbackUrl = almAccount.getAuthUrl();
        }
        serverCacheMap.put("type", "ServerAuth2");
        try {
            String postRequestQuery = almUrl + "/rest/oauth2/latest/token?client_id=" + clientId + "&client_secret=" + secretKey + "&code=" + code + "&grant_type=" + "authorization_code" + "&redirect_uri=" + oAuthCallbackUrl;
            HttpPost httpPost = new HttpPost(postRequestQuery);
            httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded");
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            String content = JiraUtils.convertStreamToString((InputStream)httpResponse.getEntity().getContent());
            JSONObject jsonResponse = new JSONObject(content);
            if (!jsonResponse.isNull("access_token")) {
                HashMap<String, Object> parameterMap = new HashMap<String, Object>();
                parameterMap.put("almAccountId", almAccountId);
                parameterMap.put("authUrl", oAuthCallbackUrl);
                parameterMap.put("isCloud", false);
                parameterMap.put("jiraServerAuthType", JiraOauthToken.ServerAuthType.AUTH_2_0);
                parameterMap.put("clientId", clientId);
                parameterMap.put("clientSecret", secretKey);
                parameterMap.put("url", almUrl);
                AlmAccount almAccount2 = this.createAlmAccountWithJiraAuthToken(jsonResponse, parameterMap);
                if (isProfile) {
                    almAccount2.setIsTaggedUser(Boolean.valueOf(true));
                    almAccount2.setAdminAlmAcc(Boolean.valueOf(false));
                }
                String result = this.importUtil.validateJiraUser(almUrl, "", "", almAccount2);
                String username = null;
                if (PropertyValidator.isValid((Object)result)) {
                    Map jiraUser = (Map)new Gson().fromJson(result, Map.class);
                    username = (String)jiraUser.get("name");
                    almAccount2.setUsername(username);
                }
                HashMap<String, Object> cacheValues = new HashMap<String, Object>();
                cacheValues.put("jiraUserName", username);
                cacheValues.put("clientId", clientId);
                cacheValues.put("isCloud", false);
                cacheValues.put("serverAuthType", JiraOauthToken.ServerAuthType.AUTH_2_0.name());
                this.cacheJiraOauth2Token(jsonResponse, serverCache, cacheValues);
                if (PropertyValidator.isValid((Object)baseUrl)) {
                    String redirectUrl = this.getRedirectQuery(redirectQueryParams);
                    response.sendRedirect(redirectUrl);
                }
            } else {
                int errorCode = 1;
                if (jsonResponse.has("error") || jsonResponse.has("error_description")) {
                    serverCacheMap.put("errorMessage", jsonResponse.get("error"));
                    serverCacheMap.put("errorDetails", jsonResponse.get("error_description"));
                } else if (jsonResponse.has("errors") || jsonResponse.has("fieldErrors")) {
                    JSONObject errorList = Collections.singletonList(jsonResponse.get("errors"));
                    serverCacheMap.put("errorMessage", jsonResponse.has("fieldErrors") ? jsonResponse.get("fieldErrors") : "Internal Server Error");
                    serverCacheMap.put("errorDetails", jsonResponse.has("fieldErrors") ? errorList : jsonResponse);
                }
                Gson gson = new Gson();
                String jsonAuthMapJSON = gson.toJson((Object)serverCacheMap);
                serverCache.setValue(jsonAuthMapJSON);
                this.serverCacheRepository.save((Object)serverCache);
                redirectQueryParams.put("errorCode", errorCode);
                try {
                    String redirectUrl = this.getRedirectQuery(redirectQueryParams);
                    response.sendRedirect(redirectUrl);
                }
                catch (IOException e) {
                    LOGGER.error(StringUtils.getTraceString((Throwable)e));
                }
            }
        }
        catch (Exception ex) {
            String errorMessage = ex.getMessage();
            String errorDetails = StringUtils.getTraceString((Throwable)ex);
            int errorCode = 1;
            if (ex instanceof UnknownHostException) {
                errorCode = 2;
            } else if (ex instanceof HttpResponseException) {
                errorCode = 3;
            } else if (ex instanceof ConnectException) {
                errorCode = 4;
            }
            serverCacheMap.put("errorMessage", errorMessage);
            serverCacheMap.put("errorDetails", errorDetails);
            Gson gson = new Gson();
            String jsonAuthMapJSON = gson.toJson((Object)serverCacheMap);
            serverCache.setValue(jsonAuthMapJSON);
            this.serverCacheRepository.save((Object)serverCache);
            redirectQueryParams.put("errorCode", errorCode);
            try {
                String redirectUrl = this.getRedirectQuery(redirectQueryParams);
                response.sendRedirect(redirectUrl);
            }
            catch (IOException e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
        }
    }

    @RequestMapping(value={"/jira/oauth2"})
    public void jiraOauth2Filter(HttpServletRequest request, HttpServletResponse response) {
        CloseableHttpClient httpclient = HttpClients.createMinimal();
        String code = request.getParameter("code");
        String serverCacheKey = request.getParameter("state");
        boolean isProfile = true;
        boolean saveOnJiraAuthComplete = false;
        String cacheForProfileKey = UserContextUtil.getUserContext().getLoggedInUser().getId() + serverCacheKey;
        ServerCache serverCache = this.serverCacheRepository.findByKey(cacheForProfileKey);
        AlmAccount editAlm = null;
        if (!PropertyValidator.isValid((Object)serverCache)) {
            serverCache = this.serverCacheRepository.findByKey(serverCacheKey);
            isProfile = false;
        }
        HashMap serverCacheMap = (HashMap)new Gson().fromJson(serverCache.getValue(), HashMap.class);
        String clientSecret = (String)serverCacheMap.get("secretKey");
        String clientId = (String)serverCacheMap.get("clientId");
        String almAccountId = (String)serverCacheMap.get("almAccountId");
        String userId = (String)serverCacheMap.get("userId");
        String kendisCallback = (String)serverCacheMap.get("kendisCallback");
        String oAuthCallbackUrl = (String)serverCacheMap.get("authUrl");
        if (PropertyValidator.isValid(serverCacheMap.get("saveOnJiraAuthComplete"))) {
            saveOnJiraAuthComplete = (Boolean)serverCacheMap.get("saveOnJiraAuthComplete");
        }
        if (PropertyValidator.isValid((Object)almAccountId)) {
            editAlm = this.almAccountRepository.findById(almAccountId);
            if (!PropertyValidator.isValid((Object)clientSecret)) {
                clientSecret = editAlm.getSecretKey();
            }
        }
        try {
            HttpPost post = new HttpPost("https://auth.atlassian.com/oauth/token");
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("grant_type", (Object)"authorization_code");
            jsonObj.put("client_id", (Object)clientId);
            jsonObj.put("client_secret", (Object)clientSecret);
            jsonObj.put("redirect_uri", (Object)oAuthCallbackUrl);
            jsonObj.put("code", (Object)code);
            StringEntity entity = new StringEntity(jsonObj.toString());
            post.setEntity((HttpEntity)entity);
            post.setHeader("Content-type", "application/json");
            HttpResponse postResponse = httpclient.execute((HttpUriRequest)post);
            String content = JiraUtils.convertStreamToString((InputStream)postResponse.getEntity().getContent());
            JSONObject jsonObjResponse = new JSONObject(content);
            if (!jsonObjResponse.isNull("access_token")) {
                AlmAccount almAcc = new AlmAccount();
                if (PropertyValidator.isValid((Object)almAccountId) && PropertyValidator.isValid((Object)editAlm)) {
                    almAcc = editAlm;
                }
                almAcc.setUrl(kendisCallback);
                almAcc.setUsername("");
                almAcc.setPassword("");
                JiraOauthToken jiraOauthToken = new JiraOauthToken();
                jiraOauthToken.setCloud(true);
                jiraOauthToken.setAccessToken(jsonObjResponse.getString("access_token"));
                jiraOauthToken.setRefreshToken(jsonObjResponse.getString("refresh_token"));
                jiraOauthToken.setExpiresAt(JiraUtils.getJiraTokenExpiry((String)jsonObjResponse.getString("expires_in")));
                almAcc.setJiraOauthToken(jiraOauthToken);
                String cloudId = ALMSyncServiceImpl.getJiraAccessibleResource((AlmAccount)almAcc, (String)"id");
                jiraOauthToken = almAcc.getJiraOauthToken();
                jiraOauthToken.setCloudId(cloudId);
                almAcc.setJiraOauthToken(jiraOauthToken);
                String result = this.importUtil.validateJiraUser(kendisCallback, "", "", almAcc);
                String username = null;
                if (PropertyValidator.isValid((Object)result)) {
                    Map jiraUser = (Map)new Gson().fromJson(result, Map.class);
                    username = (String)jiraUser.get("emailAddress");
                    if (saveOnJiraAuthComplete && PropertyValidator.isValid((Object)almAccountId) && PropertyValidator.isValid((Object)editAlm)) {
                        JiraUtils.updateJiraOauthInAlmAccUser((String)almAccountId, (JiraOauthToken)jiraOauthToken, null);
                    }
                }
                HashMap<String, String> cacheValues = new HashMap<String, String>();
                cacheValues.put("jiraUserName", username);
                cacheValues.put("cloudId", cloudId);
                this.cacheJiraOauth2Token(jsonObjResponse, serverCache, cacheValues);
                if (PropertyValidator.isValid((Object)kendisCallback)) {
                    if (isProfile) {
                        String query = "profileKey=" + serverCacheKey + "&almId=" + almAccountId + "&userId=" + userId;
                        kendisCallback = kendisCallback.contains("?") ? kendisCallback + "&" + query : kendisCallback + "?" + query;
                        response.sendRedirect(kendisCallback);
                    } else {
                        String query = "?key=" + serverCacheKey + "#almaccounts";
                        response.sendRedirect(kendisCallback + query);
                    }
                }
            } else {
                String appendQuery;
                int errorCode = 1;
                if (jsonObjResponse.has("error")) {
                    serverCacheMap.put("errorMessage", jsonObjResponse.get("error"));
                    serverCacheMap.put("errorDetails", jsonObjResponse.get("error_description"));
                }
                Gson gson = new Gson();
                String jsonauthMapJSON = gson.toJson((Object)serverCacheMap);
                serverCache.setValue(jsonauthMapJSON);
                this.serverCacheRepository.save((Object)serverCache);
                String resultPath = "";
                if (isProfile) {
                    appendQuery = "profileKey=" + serverCacheKey + "&almId=" + almAccountId + "&userId=" + userId + "&errorCode=" + errorCode;
                    kendisCallback = kendisCallback.contains("?") ? kendisCallback + "&" + appendQuery : kendisCallback + "?" + appendQuery;
                    resultPath = kendisCallback + appendQuery;
                } else {
                    appendQuery = "?key=" + serverCacheKey + "&errorCode=" + errorCode;
                    resultPath = kendisCallback + appendQuery + "#almaccounts";
                }
                try {
                    response.sendRedirect(resultPath);
                }
                catch (IOException e) {
                    LOGGER.error(StringUtils.getTraceString((Throwable)e));
                }
            }
        }
        catch (Exception ex) {
            String appendQuery;
            String errorMessage = ex.getMessage();
            String errorDetails = StringUtils.getTraceString((Throwable)ex);
            int errorCode = 1;
            if (ex instanceof UnknownHostException) {
                errorCode = 2;
            } else if (ex instanceof HttpResponseException) {
                errorCode = 3;
            } else if (ex instanceof ConnectException) {
                errorCode = 4;
            }
            serverCacheMap.put("errorMessage", errorMessage);
            serverCacheMap.put("errorDetails", errorDetails);
            Gson gson = new Gson();
            String jsonAuthMapJSON = gson.toJson((Object)serverCacheMap);
            serverCache.setValue(jsonAuthMapJSON);
            this.serverCacheRepository.save((Object)serverCache);
            String scheme = request.getScheme();
            String host = request.getHeader("Host");
            String contextPath = request.getContextPath();
            String resultPath = scheme + "://" + host + contextPath;
            if (isProfile) {
                appendQuery = "profileKey=" + serverCacheKey + "&almId=" + almAccountId + "&userId=" + userId + "&errorCode=" + errorCode;
                kendisCallback = kendisCallback.contains("?") ? kendisCallback + "&" + appendQuery : kendisCallback + "?" + appendQuery;
                resultPath = resultPath + kendisCallback;
            } else {
                appendQuery = "key=" + serverCacheKey + "&errorCode=" + errorCode;
                resultPath = resultPath + "/administration?" + appendQuery + "#almaccounts";
            }
            try {
                response.sendRedirect(resultPath);
            }
            catch (IOException e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
        }
    }

    @RequestMapping(value={"/resource/secure/{requestedFile:.+}"})
    public String getS3SecureUrl(HttpServletResponse response, @PathVariable(value="requestedFile") String requestedFile) {
        try {
            response.sendRedirect(S3Utils.getSecureUrl(null, (String)requestedFile, (boolean)true));
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return null;
    }

    @ResponseBody
    @RequestMapping(value={"/resources/secure/{requestedFile:.+}"})
    public String fetchS3SecureUrl(@PathVariable(value="requestedFile") String requestedFile) {
        try {
            return S3Utils.getSecureUrl(null, (String)requestedFile, (boolean)true);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/local/resource/{requestedFile:.+}"})
    public void resouce(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="requestedFile") String requestedFile, @RequestParam(value="location", required=false) String location) throws Exception {
        int DEFAULT_BUFFER_SIZE = 10240;
        boolean isLocalDeployment = this.env.getProperty("isLocalDeployment").equals("true");
        if (!isLocalDeployment) {
            return;
        }
        LOGGER.debug("User context admin value --> " + UserContextUtil.getUserContext().getLoggedInUser().getIsAdmin());
        if (UserContextUtil.getUserContext() == null || !UserContextUtil.getUserContext().getLoggedInUser().getIsAdmin().booleanValue()) {
            response.sendError(401);
            return;
        }
        if (requestedFile == null) {
            response.sendError(404);
            return;
        }
        if (location == null) {
            location = this.env.getProperty("attachment.location");
        } else {
            this.systemAuthenticaitonFilter.doFilter((ServletRequest)request, (ServletResponse)response);
            File logfile = new File(this.env.getProperty("logging.file"));
            File folder = new File(logfile.getParent());
            location = folder.getAbsolutePath();
        }
        File file = new File(location, URLDecoder.decode(requestedFile, "UTF-8"));
        if (!file.exists()) {
            response.sendError(404);
            return;
        }
        String contentType = request.getServletContext().getMimeType(file.getName());
        if (contentType == null) {
            contentType = "application/octet-stream";
        }
        response.reset();
        response.setBufferSize(10240);
        response.setContentType(contentType);
        response.setHeader("Content-Length", String.valueOf(file.length()));
        response.setHeader("Content-Disposition", "attachment; filename=\"" + file.getName() + "\"");
        BufferedInputStream input = null;
        BufferedOutputStream output = null;
        try {
            int length;
            input = new BufferedInputStream(new FileInputStream(file), 10240);
            output = new BufferedOutputStream((OutputStream)response.getOutputStream(), 10240);
            byte[] buffer = new byte[10240];
            while ((length = input.read(buffer)) > 0) {
                output.write(buffer, 0, length);
            }
        }
        catch (Throwable throwable) {
            MVCController.close(output);
            MVCController.close(input);
            throw throwable;
        }
        MVCController.close((Closeable)output);
        MVCController.close((Closeable)input);
    }

    @ResponseBody
    public ResponseEntity<Object> uploadBackup(@RequestParam(value="file") MultipartFile file, HttpServletRequest request, HttpServletResponse response) {
        boolean isLocalDeployment = this.env.getProperty("isLocalDeployment").equals("true");
        if (!isLocalDeployment) {
            return null;
        }
        try {
            this.systemAuthenticaitonFilter.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (ServletException e1) {
            e1.printStackTrace();
        }
        if (!UserContextUtil.getUserContext().getLoggedInUser().getIsAdmin().booleanValue()) {
            return null;
        }
        File folder = new File(this.env.getProperty("backup.location"));
        try {
            String backupFolderLoc = folder.getAbsolutePath();
            String fileName = "upload_" + new Date().getTime() + ".tar.gz";
            Path path = Paths.get(backupFolderLoc + "/" + fileName, new String[0]);
            Files.write(path, file.getBytes(), new OpenOption[0]);
            this.restore(fileName);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return null;
    }

    public void restore(String fileName) throws Exception {
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"/opt/restore.sh", fileName});
        }
        catch (Exception ex) {
            LOGGER.error("error while dump ", (Throwable)ex);
        }
    }

    private static void close(Closeable resource) {
        if (resource != null) {
            try {
                resource.close();
            }
            catch (IOException e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
        }
    }

    private Date normalizedDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public void exportPDF(@RequestParam(required=false, defaultValue="<html><body>No data found</body></html>") String htmlTemplate, HttpServletRequest request, HttpServletResponse response) {
        try {
            if (PropertyValidator.isValid((Object)htmlTemplate) && !"<html><body>No data found</body></html>".equals(htmlTemplate)) {
                String formatedString = htmlTemplate;
                Document doc = Jsoup.parse((String)formatedString);
                formatedString = doc.toString();
                com.itextpdf.text.Document document = new com.itextpdf.text.Document();
                ByteArrayInputStream stream = new ByteArrayInputStream(formatedString.getBytes());
                response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
                response.setHeader("Pragma", "no-cache");
                response.setHeader("Expires", "0");
                response.setHeader("Content-Disposition", "attachment; filename=\"itemspdf.pdf\"");
                response.setContentType("application/octet-stream");
                ServletOutputStream servletOutputStream = response.getOutputStream();
                PdfWriter writer = PdfWriter.getInstance((com.itextpdf.text.Document)document, (OutputStream)servletOutputStream);
                document.open();
                XMLWorkerHelper worker = XMLWorkerHelper.getInstance();
                worker.parseXHtml(writer, document, (InputStream)stream, Charset.defaultCharset());
                document.close();
                response.flushBuffer();
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }

    @RequestMapping(value={"/pdf/download"}, method={RequestMethod.POST})
    public void convertHtmlToPDF(HttpServletRequest request, HttpServletResponse response) {
        try {
            if (request.getParameter("cid") != null && request.getParameter("cid").equals(UserContextUtil.getUserContext().getCurrentCompanyId())) {
                String formatedString = request.getParameter("content");
                String filename = request.getParameter("filename");
                if (PropertyValidator.isValid((Object)formatedString)) {
                    Document doc = Jsoup.parse((String)formatedString);
                    formatedString = doc.toString();
                    com.itextpdf.text.Document document = new com.itextpdf.text.Document();
                    ByteArrayInputStream stream = new ByteArrayInputStream(formatedString.getBytes());
                    response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
                    response.setHeader("Pragma", "no-cache");
                    response.setHeader("Expires", "0");
                    response.setHeader("Content-Disposition", "attachment; filename=\"" + filename + ".pdf\"");
                    response.setContentType("application/octet-stream");
                    ServletOutputStream servletOutputStream = response.getOutputStream();
                    PdfWriter writer = PdfWriter.getInstance((com.itextpdf.text.Document)document, (OutputStream)servletOutputStream);
                    document.open();
                    XMLWorkerHelper worker = XMLWorkerHelper.getInstance();
                    worker.parseXHtml(writer, document, (InputStream)stream, Charset.defaultCharset());
                    document.close();
                    response.flushBuffer();
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }

    @RequestMapping(value={"/download/attachment"}, method={RequestMethod.POST})
    public void downloadAttachment(HttpServletRequest request, HttpServletResponse response) {
        try {
            if (request.getParameter("cid") != null && request.getParameter("cid").equals(UserContextUtil.getUserContext().getCurrentCompanyId())) {
                String formatedString = request.getParameter("content");
                String filename = request.getParameter("filename");
                if (PropertyValidator.isValid((Object)formatedString)) {
                    Document doc = Jsoup.parse((String)formatedString);
                    formatedString = doc.toString();
                    com.itextpdf.text.Document document = new com.itextpdf.text.Document();
                    ByteArrayInputStream stream = new ByteArrayInputStream(formatedString.getBytes());
                    response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
                    response.setHeader("Pragma", "no-cache");
                    response.setHeader("Expires", "0");
                    response.setHeader("Content-Disposition", "attachment; filename=\"" + filename + ".pdf\"");
                    response.setContentType("application/octet-stream");
                    ServletOutputStream servletOutputStream = response.getOutputStream();
                    PdfWriter writer = PdfWriter.getInstance((com.itextpdf.text.Document)document, (OutputStream)servletOutputStream);
                    document.open();
                    XMLWorkerHelper worker = XMLWorkerHelper.getInstance();
                    worker.parseXHtml(writer, document, (InputStream)stream, Charset.defaultCharset());
                    document.close();
                    response.flushBuffer();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void cacheJiraOauth2Token(JSONObject jsonObjResponse, ServerCache serverCache, Map<String, Object> params) throws JSONException {
        Gson gson = new Gson();
        HashMap kv = (HashMap)new Gson().fromJson(serverCache.getValue(), HashMap.class);
        kv.put("accessToken", jsonObjResponse.get("access_token"));
        kv.put("refreshToken", jsonObjResponse.get("refresh_token"));
        kv.put("expiresAt", JiraUtils.getJiraTokenExpiry((String)jsonObjResponse.getString("expires_in")));
        params.keySet().forEach(entry -> {
            if (PropertyValidator.isValid(params.get(entry))) {
                kv.put(entry, params.get(entry));
            }
        });
        String jsonAuthMapJSON = gson.toJson((Object)kv);
        serverCache.setValue(jsonAuthMapJSON);
        this.serverCacheRepository.save((Object)serverCache);
    }

    private String getRedirectQuery(Map<String, Object> params) {
        boolean isProfile = (Boolean)params.get("isProfile");
        String baseUrl = (String)params.get("baseUrl");
        String baseUrlHash = (String)params.get("baseUrlHash");
        String serverCacheKey = (String)params.get("serverCacheKey");
        String completeServerCacheKey = UserContextUtil.getUserContext().getLoggedInUser().getId() + serverCacheKey;
        String userId = (String)params.get("userId");
        String almAccountId = (String)params.get("almAccountId");
        Integer errorCode = (Integer)params.get("errorCode");
        String scheme = (String)params.get("scheme");
        String host = (String)params.get("host");
        if (isProfile) {
            String query = "profileKey=" + serverCacheKey + "&almId=" + almAccountId + "&userId=" + userId;
            if (errorCode != null) {
                query = query + "&errorCode=" + errorCode + baseUrlHash;
            }
            baseUrl = baseUrl.contains("?") ? baseUrl + "&" + query + baseUrlHash : baseUrl + "?" + query + baseUrlHash;
            return baseUrl;
        }
        baseUrl = scheme + "://" + host;
        String query = "/administration?key=" + completeServerCacheKey;
        if (errorCode != null) {
            query = query + "&errorCode=" + errorCode;
        }
        query = query + "#almaccounts";
        return baseUrl + query;
    }

    private AlmAccount createAlmAccountWithJiraAuthToken(JSONObject jiraOauthJson, Map<String, Object> parameters) {
        AlmAccount almAccount = new AlmAccount();
        almAccount.setId((String)parameters.get("almAccountId"));
        almAccount.setUrl((String)parameters.get("url"));
        almAccount.setAuthUrl((String)parameters.get("authUrl"));
        almAccount.setClientId((String)parameters.get("clientId"));
        almAccount.setSecretKey((String)parameters.get("clientSecret"));
        almAccount.setUsername(null);
        almAccount.setPassword(null);
        JiraOauthToken jiraOauthToken = new JiraOauthToken();
        jiraOauthToken.setCloud(((Boolean)parameters.getOrDefault("isCloud", false)).booleanValue());
        jiraOauthToken.setAccessToken(jiraOauthJson.getString("access_token"));
        jiraOauthToken.setRefreshToken(jiraOauthJson.getString("refresh_token"));
        jiraOauthToken.setExpiresAt(JiraUtils.getJiraTokenExpiry((String)jiraOauthJson.getString("expires_in")));
        jiraOauthToken.setServerAuthType((JiraOauthToken.ServerAuthType)parameters.get("jiraServerAuthType"));
        almAccount.setJiraOauthToken(jiraOauthToken);
        return almAccount;
    }

    @RequestMapping(value={"/links/{viewType}/{releaseTrainId}"}, method={RequestMethod.GET})
    public String collectionLinks(@PathVariable(value="viewType") String viewType, @PathVariable(value="releaseTrainId") String releaseTrainId, Model model) {
        try {
            if (UserContextUtil.getUserContext().getCurrentCompany().isEnableArt()) {
                String cid = UserContextUtil.getUserContext().getCurrentCompany().getId();
                model.addAttribute("companyId", (Object)cid);
                model.addAttribute("releaseTrainId", (Object)releaseTrainId);
                model.addAttribute("viewType", (Object)viewType);
                return "rt-links";
            }
            return "redirect:/";
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return "error";
        }
    }
}

