/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.controller;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import com.viztrend.safe.alm.jira.TFSResponse;
import com.viztrend.safe.alm.jira.TFSUtils;
import com.viztrend.safe.alm.jira.bo.JiraIssueLinkType;
import com.viztrend.safe.alm.tfs.TFSMeta;
import com.viztrend.safe.alm.tfs.TFSProject;
import com.viztrend.safe.alm.tfs.TFSTeamMapping;
import com.viztrend.safe.config.AppConfig;
import com.viztrend.safe.controller.KendisBoardController;
import com.viztrend.safe.persistence.entity.AlmAccount;
import com.viztrend.safe.persistence.entity.AlmError;
import com.viztrend.safe.persistence.entity.BoardSprints;
import com.viztrend.safe.persistence.entity.BoardTeam;
import com.viztrend.safe.persistence.entity.Container;
import com.viztrend.safe.persistence.entity.Conversation;
import com.viztrend.safe.persistence.entity.IssueType;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.ItemJiraDependency;
import com.viztrend.safe.persistence.entity.ItemLink;
import com.viztrend.safe.persistence.entity.ItemLog;
import com.viztrend.safe.persistence.entity.ItemSyncMapper;
import com.viztrend.safe.persistence.entity.Risk;
import com.viztrend.safe.persistence.entity.RiskRegister;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.State;
import com.viztrend.safe.persistence.entity.StateScheme;
import com.viztrend.safe.persistence.entity.Status;
import com.viztrend.safe.persistence.entity.TFSAlmConfigurations;
import com.viztrend.safe.persistence.entity.Team;
import com.viztrend.safe.persistence.entity.TeamContainer;
import com.viztrend.safe.persistence.entity.TeamSprintDependencyLimit;
import com.viztrend.safe.persistence.entity.TeamSprintVelocity;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.UserCompany;
import com.viztrend.safe.persistence.entity.Watcher;
import com.viztrend.safe.persistence.entity.WorkFlow;
import com.viztrend.safe.persistence.entity.WorkSpace;
import com.viztrend.safe.persistence.entity.WorkSpaceAccessRole;
import com.viztrend.safe.persistence.entity.dto.SecureUser;
import com.viztrend.safe.persistence.repository.AlmAccountRepository;
import com.viztrend.safe.persistence.repository.AlmConfigurationsRepository;
import com.viztrend.safe.persistence.repository.AlmErrorRepository;
import com.viztrend.safe.persistence.repository.AlmInfoRepository;
import com.viztrend.safe.persistence.repository.ConfigRepository;
import com.viztrend.safe.persistence.repository.ContainerRepository;
import com.viztrend.safe.persistence.repository.ConversationRepository;
import com.viztrend.safe.persistence.repository.CustomRepository;
import com.viztrend.safe.persistence.repository.CustomRepositoryImpl;
import com.viztrend.safe.persistence.repository.GroupRepository;
import com.viztrend.safe.persistence.repository.IssueTypeRepository;
import com.viztrend.safe.persistence.repository.ItemJiraDependencyRepository;
import com.viztrend.safe.persistence.repository.ItemLinkRepository;
import com.viztrend.safe.persistence.repository.ItemLogRepository;
import com.viztrend.safe.persistence.repository.ItemRepository;
import com.viztrend.safe.persistence.repository.ItemSyncMapperRepository;
import com.viztrend.safe.persistence.repository.ItemTypeRepository;
import com.viztrend.safe.persistence.repository.JiraFieldRepository;
import com.viztrend.safe.persistence.repository.JiraIssueRepository;
import com.viztrend.safe.persistence.repository.JiraProjectIssueTypesRepository;
import com.viztrend.safe.persistence.repository.KendisStatsRepository;
import com.viztrend.safe.persistence.repository.PushResponseRepository;
import com.viztrend.safe.persistence.repository.ReportRepository;
import com.viztrend.safe.persistence.repository.RiskRegisterRepository;
import com.viztrend.safe.persistence.repository.RiskRepository;
import com.viztrend.safe.persistence.repository.RoleRepository;
import com.viztrend.safe.persistence.repository.ScoreCardRepository;
import com.viztrend.safe.persistence.repository.ServerCacheRepository;
import com.viztrend.safe.persistence.repository.SessionBoardRepository;
import com.viztrend.safe.persistence.repository.SessionRepository;
import com.viztrend.safe.persistence.repository.SprintRepository;
import com.viztrend.safe.persistence.repository.StateCategoryRepository;
import com.viztrend.safe.persistence.repository.StateRepository;
import com.viztrend.safe.persistence.repository.StateSchemeRepository;
import com.viztrend.safe.persistence.repository.StatusRepository;
import com.viztrend.safe.persistence.repository.TFSAlmConfigurationsRepository;
import com.viztrend.safe.persistence.repository.TFSFilterRepository;
import com.viztrend.safe.persistence.repository.TFSProjectRepository;
import com.viztrend.safe.persistence.repository.TeamContainerRepository;
import com.viztrend.safe.persistence.repository.TeamRepository;
import com.viztrend.safe.persistence.repository.TeamSprintDependencyLimitRepository;
import com.viztrend.safe.persistence.repository.TeamSprintVelocityRepository;
import com.viztrend.safe.persistence.repository.UserRepository;
import com.viztrend.safe.persistence.repository.WatcherRepository;
import com.viztrend.safe.persistence.repository.WorkFlowItemTypeRepository;
import com.viztrend.safe.persistence.repository.WorkFlowRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceAccessRoleRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceRepository;
import com.viztrend.safe.service.ALMSyncService;
import com.viztrend.safe.service.ExportService;
import com.viztrend.safe.service.PiJourneyBoardService;
import com.viztrend.safe.service.PiJourneyService;
import com.viztrend.safe.service.PlanService;
import com.viztrend.safe.service.TFSservice;
import com.viztrend.safe.service.WebHookSyncService;
import com.viztrend.safe.utils.AlmUtils;
import com.viztrend.safe.utils.KendisUtils;
import com.viztrend.safe.utils.LocalMailSender;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.PushSender;
import com.viztrend.safe.utils.UserContextUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.bson.types.ObjectId;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/kb"})
@RestController
public class KendisBoardController {
    private static final Logger LOGGER = LoggerFactory.getLogger(KendisBoardController.class);
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private ItemRepository itemRepository;
    @Autowired
    private WorkSpaceAccessRoleRepository accessRoleRepository;
    @Autowired
    private StateCategoryRepository stateCategoryRepository;
    @Autowired
    private StateRepository stateRepository;
    @Autowired
    private StatusRepository statusRepository;
    @Autowired
    private SessionRepository sessionRepository;
    @Autowired
    private WorkFlowRepository workFlowRepository;
    @Autowired
    private StateSchemeRepository stateSchemeRepository;
    @Autowired
    private ItemTypeRepository itemTypeRepository;
    @Autowired
    private ItemLinkRepository itemLinkRepository;
    @Autowired
    private ScoreCardRepository scoreCardRepository;
    @Autowired
    private ConversationRepository conversationRepository;
    @Autowired
    private WatcherRepository watcherRepository;
    @Autowired
    private ContainerRepository containerRepository;
    @Autowired
    private KendisStatsRepository kendisStatsRepository;
    @Autowired
    private TeamRepository teamRepository;
    @Autowired
    private AppConfig.MongoConfig mongoConfig;
    @Autowired
    private JiraProjectIssueTypesRepository jiraProjectIssueTypesRepository;
    @Autowired
    private SessionBoardRepository sessionBoardRepository;
    @Autowired
    private RiskRepository riskRepository;
    @Autowired
    private TeamSprintVelocityRepository teamSprintVelocityRepository;
    @Autowired
    private WebHookSyncService webHookSyncService;
    @Autowired
    private TeamContainerRepository teamContainerRepository;
    @Autowired
    private TeamSprintDependencyLimitRepository TeamSprintDependencyLimitRepository;
    @Autowired
    private SprintRepository sprintRepository;
    @Autowired
    private PlanService planService;
    @Autowired
    private PushResponseRepository pushResponseRepository;
    @Autowired
    private ItemLogRepository itemLogRepository;
    @Autowired
    private RiskRegisterRepository riskRegisterRepository;
    @Autowired
    private ExportService exportService;
    @Autowired
    ALMSyncService aLMSyncService;
    @Autowired
    private CustomRepository<Object> customRepository;
    @Autowired
    private WorkSpaceRepository workSpaceRepository;
    @Autowired
    private WorkSpaceAccessRoleRepository workSpaceAccessRoleRepository;
    @Autowired
    RoleRepository roleRepository;
    @Autowired
    GroupRepository groupRepository;
    @Autowired
    private ALMSyncService almSyncService;
    @Autowired
    private ItemSyncMapperRepository itemSyncMapperRepository;
    @Autowired
    private LocalMailSender mailSender;
    @Autowired
    private ConfigRepository configRepository;
    @Autowired
    private AlmConfigurationsRepository almConfigurationsRepository;
    @Autowired
    private CustomRepositoryImpl<?> customRepositoryImpl;
    @Autowired
    private AlmErrorRepository almErrorRepository;
    @Autowired
    private AlmInfoRepository almInfoRepository;
    @Autowired
    private JiraFieldRepository jiraFieldRepository;
    @Autowired
    private AlmAccountRepository almAccountRepository;
    @Autowired
    private JiraIssueRepository jiraIssueRepository;
    @Autowired
    private IssueTypeRepository issueTypeRepository;
    @Autowired
    private ReportRepository reportRepository;
    @Autowired
    private ItemJiraDependencyRepository itemJiraDependencyRepository;
    @Autowired
    private TFSUtils tfsUtils;
    @Autowired
    private TFSservice tfSservice;
    @Autowired
    private TFSProjectRepository tfsProjectRepository;
    @Autowired
    private TFSFilterRepository tfsFilterRepository;
    @Autowired
    private TFSAlmConfigurationsRepository tfsAlmConfigurationsRepository;
    @Autowired
    private WorkFlowItemTypeRepository workFlowItemTypeRepository;
    @Autowired
    private ServerCacheRepository serverCacheRepository;
    @Autowired
    private Environment env;
    @Autowired
    private PiJourneyService piJourneyService;
    @Autowired
    private PiJourneyBoardService piJourneyBoardService;
    protected Item savedItem = null;
    protected Item item = null;

    private StateScheme getDefaultStateScheme() {
        StateScheme defaultStateScheme = this.stateSchemeRepository.findByIsDefaultIsTrue();
        return defaultStateScheme;
    }

    private Item createItemForReport(DBObject vo, HashMap<String, String> statusMapById, ArrayList<Object> allStatuses, HashMap<String, String> itemLinkMapById, ArrayList<String> itemLinks, HashMap<String, String> jiraLinkMapById, ArrayList<String> jiraLinks, HashMap<String, Team> teamMapById, HashMap<String, Container> containerMapById, HashMap<String, IssueType> issueTypeMapById) {
        Item parent = null;
        DBRef parentRef = (DBRef)vo.get("parent");
        if (PropertyValidator.isValid((Object)parentRef)) {
            parent = new Item(String.valueOf(parentRef.getId()));
        }
        Status status = new Status();
        DBRef statusRef = (DBRef)vo.get("status");
        if (statusRef != null && statusRef.getId() != null) {
            String statusId = String.valueOf(statusRef.getId());
            status.setId(statusId);
            if (statusMapById.get(statusId) == null) {
                statusMapById.put(statusId, statusId);
                allStatuses.add(statusRef.getId());
            }
        }
        IssueType issueType = null;
        DBRef issueTypeRef = (DBRef)vo.get("issueType");
        if (PropertyValidator.isValid((Object)issueTypeRef)) {
            String issueTypeId = String.valueOf(issueTypeRef.getId());
            issueType = issueTypeMapById.get(issueTypeId);
        }
        ArrayList _itemLinks = new ArrayList();
        List itemLinksRef = (List)vo.get("itemLinks");
        if (PropertyValidator.isValid((Collection)itemLinksRef)) {
            itemLinksRef.forEach(linkRef -> {
                String linkId = String.valueOf(linkRef.getId());
                ItemLink link = new ItemLink();
                link.setId(linkId);
                if (itemLinkMapById.get(linkId) == null) {
                    itemLinkMapById.put(linkId, linkId);
                    itemLinks.add(linkId);
                }
                _itemLinks.add(link);
            });
        }
        ArrayList _jiraLinks = new ArrayList();
        List jiraLinksRef = (List)vo.get("jiraDependencies");
        if (PropertyValidator.isValid((Collection)jiraLinksRef)) {
            jiraLinksRef.forEach(linkRef -> {
                String linkId = String.valueOf(linkRef.getId());
                ItemJiraDependency link = new ItemJiraDependency();
                link.setId(linkId);
                if (jiraLinkMapById.get(linkId) == null) {
                    jiraLinkMapById.put(linkId, linkId);
                    jiraLinks.add(linkId);
                }
                _jiraLinks.add(link);
            });
        }
        List teamContainersRef = (List)vo.get("teamContainers");
        ArrayList<TeamContainer> teamContainers = new ArrayList<TeamContainer>();
        if (PropertyValidator.isValid((Collection)teamContainersRef)) {
            for (int i = 0; i < teamContainersRef.size(); ++i) {
                DBRef tcRef = (DBRef)teamContainersRef.get(i);
                Query query = new Query();
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is(tcRef.getId()));
                DBCursor dbCursorDomain = this.customRepositoryImpl.getMongoTemplate().getCollection("teamContainer").find(query.getQueryObject());
                if (!dbCursorDomain.hasNext()) continue;
                DBObject tcObject = dbCursorDomain.next();
                DBRef teamRef = (DBRef)tcObject.get("team");
                DBRef containerRef = (DBRef)tcObject.get("container");
                Team team = teamMapById.get(String.valueOf(teamRef.getId()));
                Container container = containerMapById.get(String.valueOf(containerRef.getId()));
                TeamContainer teamContainer = new TeamContainer();
                teamContainer.setId(String.valueOf(tcObject.get("_id")));
                teamContainer.setOriginItemId((String)tcObject.get("originItemId"));
                teamContainer.setTeam(team);
                teamContainer.setContainer(container);
                if (!PropertyValidator.isValid((Object)team) || !PropertyValidator.isValid((Object)team.getId()) || !PropertyValidator.isValid((Object)container) || !PropertyValidator.isValid((Object)container.getId())) continue;
                teamContainers.add(teamContainer);
            }
        }
        ArrayList _jiraLinkTypes = new ArrayList();
        List jiraLinkTypesRef = (List)vo.get("linkTypes");
        if (PropertyValidator.isValid((Collection)jiraLinkTypesRef)) {
            jiraLinkTypesRef.forEach(linkRef -> {
                JiraIssueLinkType link = new JiraIssueLinkType(linkRef);
                _jiraLinkTypes.add(link);
            });
        }
        return new Item(vo, null, status, issueType, parent, _itemLinks, _jiraLinks, teamContainers, _jiraLinkTypes);
    }

    public HashMap<String, Object> getBoardItems1(String sessionBoardId) {
        try {
            String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
            HashMap<String, Object> responseJson = new HashMap<String, Object>();
            ArrayList<SessionBoard> sessionBoards = new ArrayList<SessionBoard>();
            SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardId));
            SessionBoard board = new SessionBoard(sessionBoardId);
            sessionBoards.add(board);
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionBoards.$id").is((Object)new ObjectId(sessionBoardId)));
            query.with(new Sort(Sort.Direction.ASC, new String[]{"sequence"}));
            DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("item").find(query.getQueryObject()).sort((DBObject)new BasicDBObject("backlogSequence", (Object)1));
            List allItems = dbCursorPrefix.toArray();
            HashMap teamMapById = new HashMap();
            HashMap containerMapById = new HashMap();
            List containers = sessionBoard.getContainers();
            List teams = sessionBoard.getTeams();
            containers.forEach(container -> containerMapById.put(container.getId(), container));
            teams.forEach(team -> teamMapById.put(team.getId(), team));
            ArrayList allStatuses = new ArrayList();
            HashMap statusMapById = new HashMap();
            List issueTypes = this.issueTypeRepository.findAll();
            HashMap issueTypeMapById = new HashMap();
            issueTypes.forEach(issueType -> issueTypeMapById.put(issueType.getId(), issueType));
            ArrayList itemLinks = new ArrayList();
            HashMap itemLinkMapById = new HashMap();
            ArrayList jiraLinks = new ArrayList();
            HashMap jiraLinkMapById = new HashMap();
            HashMap<String, ArrayList<Item>> childItemsByParentId = new HashMap<String, ArrayList<Item>>();
            ArrayList<Item> parentItems = new ArrayList<Item>();
            ArrayList<Item> _boardItems = new ArrayList<Item>();
            if (PropertyValidator.isValid((Collection)allItems)) {
                for (DBObject vo2 : allItems) {
                    ArrayList<Item> subItems;
                    Item item2 = this.createItemForReport(vo2, statusMapById, allStatuses, itemLinkMapById, itemLinks, jiraLinkMapById, jiraLinks, teamMapById, containerMapById, issueTypeMapById);
                    _boardItems.add(item2);
                    if (item2.getType().equals(Item.FEATURE)) {
                        parentItems.add(item2);
                        subItems = (ArrayList)childItemsByParentId.get(item2.getId());
                        if (subItems == null) {
                            subItems = new ArrayList();
                            childItemsByParentId.put(item2.getId(), subItems);
                        }
                        item2.setSubItems(subItems);
                        continue;
                    }
                    subItems = (ArrayList<Item>)childItemsByParentId.get(item2.getParent().getId());
                    if (subItems == null) {
                        subItems = new ArrayList<Item>();
                        childItemsByParentId.put(item2.getParent().getId(), subItems);
                    }
                    subItems.add(item2);
                }
            }
            List _itemLinks = this.itemLinkRepository.findByIdIn(itemLinks);
            List _jiraLinks = this.itemJiraDependencyRepository.findByIdIn(jiraLinks);
            query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(allStatuses));
            dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("status").find(query.getQueryObject());
            List _statusesRaw = dbCursorPrefix.toArray();
            ArrayList<Status> _statuses = new ArrayList<Status>();
            if (PropertyValidator.isValid((Collection)_statusesRaw)) {
                _statusesRaw.forEach(vo -> _statuses.add(new Status(vo)));
            }
            HashMap _itemLinksMap = new HashMap();
            HashMap _jiraLinksMap = new HashMap();
            HashMap _statusesMap = new HashMap();
            if (PropertyValidator.isValid((Collection)_itemLinks)) {
                _itemLinks.forEach(item -> _itemLinksMap.put(item.getId(), item));
            }
            if (PropertyValidator.isValid((Collection)_jiraLinks)) {
                _jiraLinks.forEach(item -> _jiraLinksMap.put(item.getId(), item));
            }
            if (PropertyValidator.isValid(_statuses)) {
                _statuses.forEach(item -> {
                    item.setWorkFlow(null);
                    item.setWorkFlowItemType(null);
                    _statusesMap.put(item.getId(), item);
                });
            }
            if (PropertyValidator.isValid(_boardItems)) {
                Iterator iterator = _boardItems.iterator();
                while (iterator.hasNext()) {
                    List orgJiraLinks;
                    Item it;
                    Item item3 = it = (Item)iterator.next();
                    item3.setStatus((Status)_statusesMap.get(item3.getStatus().getId()));
                    List orgItemLinks = item3.getItemLinks();
                    if (PropertyValidator.isValid((Collection)orgItemLinks)) {
                        ArrayList newItemLinks = new ArrayList();
                        orgItemLinks.forEach(link -> {
                            ItemLink newlink = (ItemLink)_itemLinksMap.get(link.getId());
                            if (PropertyValidator.isValid((Object)newlink)) {
                                if (PropertyValidator.isValid((Object)newlink.getWfStatus())) {
                                    newlink.getWfStatus().setWorkFlow(null);
                                    newlink.getWfStatus().setWorkFlowItemType(null);
                                }
                                newItemLinks.add(newlink);
                            }
                        });
                        item3.setItemLinks(newItemLinks);
                    }
                    if (!PropertyValidator.isValid((Collection)(orgJiraLinks = item3.getJiraDependencies()))) continue;
                    ArrayList newJiraLinks = new ArrayList();
                    orgJiraLinks.forEach(link -> {
                        if (PropertyValidator.isValid(_jiraLinksMap.get(link.getId()))) {
                            newJiraLinks.add(_jiraLinksMap.get(link.getId()));
                        }
                    });
                    item3.setJiraDependencies(newJiraLinks);
                }
            }
            responseJson.put("items", parentItems);
            return responseJson;
        }
        catch (Exception ex) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)ex));
            return null;
        }
    }

    public WorkFlow createDefaultDependencyWorkflow() {
        WorkFlow defaultScheme = new WorkFlow();
        defaultScheme.setTitle("Default Dependency Workflow");
        defaultScheme.setDefault(false);
        defaultScheme.setWorkflowType("Dependency");
        defaultScheme = (WorkFlow)this.workFlowRepository.save((Object)defaultScheme);
        ArrayList<Status> statusList = new ArrayList<Status>();
        for (int j = 0; j < 4; ++j) {
            Status status;
            int i;
            if (j == 0) {
                for (i = 0; i < 3; ++i) {
                    status = new Status();
                    status.setCategory("ToDo");
                    status.setArchive(false);
                    status.setWorkFlow(defaultScheme);
                    if (i == 0) {
                        status.setTitle("Waiting for Acceptance");
                    } else if (i == 1) {
                        status.setTitle("Accepted");
                    } else {
                        status.setTitle("Not Started");
                    }
                    statusList.add(status);
                }
                continue;
            }
            if (j == 1) {
                Status status2 = new Status();
                status2.setArchive(false);
                status2.setWorkFlow(defaultScheme);
                status2.setCategory("InProgress");
                status2.setTitle("In Progress");
                statusList.add(status2);
                continue;
            }
            if (j == 2) {
                for (i = 0; i < 2; ++i) {
                    status = new Status();
                    status.setCategory("Done");
                    status.setArchive(false);
                    status.setWorkFlow(defaultScheme);
                    if (i == 0) {
                        status.setTitle("Done");
                    } else if (i == 1) {
                        status.setTitle("Done with Acceptance");
                    }
                    statusList.add(status);
                }
                continue;
            }
            for (i = 0; i < 3; ++i) {
                status = new Status();
                status.setCategory("Misc");
                status.setArchive(false);
                status.setWorkFlow(defaultScheme);
                if (i == 0) {
                    status.setTitle("Blocked");
                } else if (i == 1) {
                    status.setTitle("Ignored ");
                } else {
                    status.setTitle("Integrated");
                }
                statusList.add(status);
            }
        }
        this.statusRepository.save(statusList);
        return defaultScheme;
    }

    private Boolean isLoggedInCompanyUser(User user) {
        String loggedinCompanyId = UserContextUtil.getUserContext().getCurrentCompany().getId();
        for (UserCompany userCompany : user.getUserCompanies()) {
            if (userCompany.getCompany() == null || !userCompany.getCompany().getId().equals(loggedinCompanyId) || !userCompany.getIsActive().booleanValue()) continue;
            return true;
        }
        return false;
    }

    @RequestMapping(value={"/getAllBoards"})
    @ResponseBody
    public ResponseEntity<Object> getAllAccessableBoards() {
        HashMap<String, AbstractCollection> responseJson = new HashMap<String, AbstractCollection>();
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        User user = (User)secureUser.getUserContextDTO().getContextMap().get("user");
        HashSet workSpaces = new HashSet();
        List<WorkSpaceAccessRole> workSpaceAccessRoles = new ArrayList();
        if (PropertyValidator.isValid((Object)user) && (user.getIsAdmin().booleanValue() || user.getIsSuperAdmin().booleanValue())) {
            workSpaces = Sets.newHashSet((Iterable)this.workSpaceRepository.findByIsModuleIsFalseOrIsModuleIsNull());
            for (WorkSpace workSpace : workSpaces) {
                WorkSpaceAccessRole accessRole = new WorkSpaceAccessRole();
                accessRole.setWorkSpace(workSpace);
                accessRole.setUser(user);
                workSpaceAccessRoles.add(accessRole);
            }
        } else {
            workSpaceAccessRoles = this.customRepository.findWorkspaceAccessRoles(user);
            for (WorkSpaceAccessRole workSpaceAccessRole : workSpaceAccessRoles) {
                if (!PropertyValidator.isValid((Object)workSpaceAccessRole.getWorkSpace())) continue;
                workSpaces.add(workSpaceAccessRole.getWorkSpace());
            }
        }
        List sessions = new ArrayList();
        List parentBoards = new ArrayList();
        if (PropertyValidator.isValid((Collection)workSpaces)) {
            sessions = this.sessionRepository.findByWorkSpaceIn(new ArrayList(workSpaces));
            parentBoards = this.sessionBoardRepository.findBySessionInAndParentBoardIsNullOrderByCreatedOnDesc(sessions);
        }
        responseJson.put("boards", (AbstractCollection)((Object)parentBoards));
        responseJson.put("workSpaces", workSpaces);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/board/{id}"})
    @ResponseBody
    public ResponseEntity<Object> getBoard(@PathVariable(value="id") String id) {
        HashMap<String, List> responseJson = new HashMap<String, List>();
        SessionBoard sessionBoard = this.sessionBoardRepository.findById(id);
        if (PropertyValidator.isValid((Object)sessionBoard)) {
            List linkedBoards = PropertyValidator.isValid((Object)sessionBoard.getParentBoard()) ? this.sessionBoardRepository.findByIdOrParentBoardOrderByCreatedOnAsc(sessionBoard.getParentBoard(), sessionBoard.getParentBoard()) : this.sessionBoardRepository.findByIdOrParentBoardOrderByCreatedOnAsc(sessionBoard.getId(), sessionBoard.getId());
            List dependencyLimit = null;
            if (PropertyValidator.isValid((Object)sessionBoard.getSession())) {
                dependencyLimit = this.TeamSprintDependencyLimitRepository.findBySessionId(sessionBoard.getSession().getId());
                if (!PropertyValidator.isValid((Collection)dependencyLimit)) {
                    for (Team team : sessionBoard.getTeams()) {
                        for (Container container : sessionBoard.getContainers()) {
                            TeamSprintDependencyLimit teamSprintLimit = new TeamSprintDependencyLimit();
                            teamSprintLimit.setSessionId(sessionBoard.getSession().getId());
                            teamSprintLimit.setSprintId(container.getId());
                            teamSprintLimit.setTeamId(team.getId());
                            dependencyLimit.add(teamSprintLimit);
                        }
                    }
                    this.TeamSprintDependencyLimitRepository.save((Iterable)dependencyLimit);
                }
                sessionBoard.getSession().setStateScheme(this.getDefaultStateScheme());
                sessionBoard.getSession().getStateScheme().setStates(this.stateRepository.findByStateScheme(sessionBoard.getSession().getStateScheme()));
                sessionBoard.getSession().getItemWorkFlow().setStatuses(this.statusRepository.findByWorkFlow(sessionBoard.getSession().getItemWorkFlow()));
                sessionBoard.getSession().getSubItemWorkFlow().setStatuses(this.statusRepository.findByWorkFlow(sessionBoard.getSession().getSubItemWorkFlow()));
            }
            sessionBoard.setTeamSprintVelocities(this.teamSprintVelocityRepository.findBySessionBoardId(sessionBoard.getId()));
            sessionBoard.setLinkedBoards(linkedBoards);
            ArrayList<SessionBoard> sessionBoards = new ArrayList<SessionBoard>();
            sessionBoards.add(new SessionBoard(id));
            sessionBoard.setItems(new ArrayList());
            sessionBoard.setServerTimeZone(AlmUtils.getServerTimeZone());
            if (PropertyValidator.isValid((Object)sessionBoard.getSession().getTfsAlmConfigurations())) {
                List tfsProjects;
                SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
                User user = this.customRepositoryImpl.findUserByAlmAccount(((User)secureUser.getUserContextDTO().getContextMap().get("user")).getId(), sessionBoard.getSession().getTfsAlmConfigurations().getAlmAccount().getId());
                if (PropertyValidator.isValid((Object)user)) {
                    sessionBoard.getSession().setLoggedUserHasAlm(Boolean.valueOf(true));
                }
                if (PropertyValidator.isValid((Collection)(tfsProjects = this.tfsProjectRepository.findBySessionId(sessionBoard.getSession().getId())))) {
                    for (int i = 0; i < tfsProjects.size(); ++i) {
                        TFSProject project = (TFSProject)tfsProjects.get(i);
                        List itemTypes = this.workFlowItemTypeRepository.findBySessionIdAndTfsProjectId(sessionBoard.getSession().getId(), project.getTfsId());
                        project.setItemTypes(itemTypes);
                        WorkFlow workflow = this.workFlowRepository.findBySessionIdAndTfsProjectId(sessionBoard.getSession().getId(), project.getTfsId());
                        project.setWorkFlow(workflow);
                        List statuses = this.statusRepository.findByWorkFlow(workflow);
                        workflow.setStatuses(statuses);
                    }
                }
                responseJson.put("tfsProject", tfsProjects);
                AlmAccount almAccount = sessionBoard.getSession().getTfsAlmConfigurations().getAlmAccount();
                HashMap linkTypesResult = this.tfSservice.retrieveJiraIssueLinkTypesList(almAccount, false);
                if (PropertyValidator.isValid(linkTypesResult.get("tfsALMErrorCode"))) {
                    responseJson.put("tfsALMErrorCode", (List)linkTypesResult.get("tfsALMErrorCode"));
                    responseJson.put("tfsALMErrorMessage", (List)linkTypesResult.get("tfsALMErrorMessage"));
                } else {
                    TFSMeta tfsMeta = new TFSMeta();
                    tfsMeta.setLinkTypes((String)linkTypesResult.get("linkTypes"));
                    if (PropertyValidator.isValid((Collection)sessionBoard.getSession().getAlmConfigurations())) {
                        tfsMeta.setAlmAccount(sessionBoard.getSession().getTfsAlmConfigurations().getAlmAccount());
                    }
                    responseJson.put("tfsMeta", (List)tfsMeta);
                }
            }
            responseJson.put("sessionBoard", (List)sessionBoard);
            responseJson.put("allBoards", (List)this.getAllAccessableBoards());
            List allIssueTypes = this.issueTypeRepository.findAllByOrderBySequenceAsc();
            responseJson.put("allIssueTypes", allIssueTypes);
            responseJson.put("companyTeams", this.teamRepository.findAll());
            StateScheme stateScheme = new StateScheme();
            stateScheme.setId(sessionBoard.getSession().getStateScheme().getId());
            responseJson.put("allStates", this.stateRepository.findByStateScheme(stateScheme));
            List itemSyncMappers = this.itemSyncMapperRepository.findBySessionBoard(sessionBoard);
            if (itemSyncMappers != null) {
                responseJson.put("itemSyncMappers", itemSyncMappers);
            }
            List teamSprintVelocity = this.teamSprintVelocityRepository.findBySessionBoardId(sessionBoard.getId());
            responseJson.put("teamSprintVelocity", teamSprintVelocity);
            responseJson.put("teamSprintDependencyLimit", dependencyLimit);
            Instant start = Instant.now();
            Duration timeElapsed = null;
            List workFlowList = this.workFlowRepository.findAllByWorkflowType("Dependency");
            if (!PropertyValidator.isValid((Object)sessionBoard.getSession().getDependencyWorkFlow())) {
                if (PropertyValidator.isValid((Collection)workFlowList)) {
                    sessionBoard.getSession().setDependencyWorkFlow((WorkFlow)workFlowList.get(0));
                } else {
                    sessionBoard.getSession().setDependencyWorkFlow(this.createDefaultDependencyWorkflow());
                }
                this.sessionRepository.save((Object)sessionBoard.getSession());
            }
            List dependencyStatuses = this.statusRepository.findByWorkFlow(sessionBoard.getSession().getDependencyWorkFlow());
            WorkFlow workFlow = sessionBoard.getSession().getDependencyWorkFlow();
            ArrayList sortedStatuses = new ArrayList();
            HashMap<String, Status> sortedStatusesMap = new HashMap<String, Status>();
            if (PropertyValidator.isValid((Object)workFlow.getStatusSequence())) {
                String[] sortedStatusIds = workFlow.getStatusSequence().split(",");
                for (Status status : dependencyStatuses) {
                    sortedStatusesMap.put(status.getId(), status);
                }
                for (String statusId : sortedStatusIds) {
                    sortedStatuses.add(sortedStatusesMap.get(statusId));
                }
                responseJson.put("dependencyStatuses", sortedStatuses);
            } else {
                responseJson.put("dependencyStatuses", dependencyStatuses);
            }
            ArrayList<User> users = new ArrayList<User>();
            List usersAll = this.userRepository.findByUserCompanies_Company_Id(UserContextUtil.getUserContext().getCurrentCompany().getId());
            for (User user : usersAll) {
                if (!this.isLoggedInCompanyUser(user).booleanValue()) continue;
                users.add(user);
            }
            responseJson.put("users", users);
            Instant end = Instant.now();
            timeElapsed = Duration.between(start, end);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/items/{id}"})
    @ResponseBody
    public ResponseEntity<Object> getBoardItemsCall(@PathVariable(value="id") String id) {
        HashMap responseJson = this.getBoardItems1(id);
        return new ResponseEntity((Object)responseJson, HttpStatus.OK);
    }

    private void transformItemLinksStatus(Item item, List<Status> statuses) {
        if (PropertyValidator.isValid(statuses) && statuses.size() == 2) {
            List itemLinks = item.getItemLinks();
            this.transformItemLinksStatus(itemLinks, statuses);
        }
    }

    private void transformItemLinksStatus(List<ItemLink> itemLinks, List<Status> statuses) {
        if (PropertyValidator.isValid(statuses) && statuses.size() == 2 && PropertyValidator.isValid(itemLinks)) {
            for (ItemLink link : itemLinks) {
                if (PropertyValidator.isValid((Object)link.getWfStatus())) continue;
                if (link.getStatus().equals("Open")) {
                    link.setWfStatus(statuses.get(0));
                    continue;
                }
                link.setWfStatus(statuses.get(1));
            }
        }
    }

    private Item transform(Item vo) {
        Item bo = new Item(vo);
        return bo;
    }

    @RequestMapping(value={"/updateItemTeamContainer"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> updateItemTeamContainer(@RequestBody HashMap<String, Object> payload) {
        HashMap responseJson = new HashMap();
        String parentChange = (String)payload.get("parentChange");
        String teamChange = (String)payload.get("teamChange");
        String itemId = (String)payload.get("itemId");
        String parentId = (String)payload.get("parentId");
        String teamContainerStr = (String)payload.get("addTC");
        boolean setSequence = false;
        double sequence = 0.0;
        String sequenceKey = "";
        if (payload.get("sequence") != null) {
            setSequence = true;
            sequence = Double.parseDouble((String)payload.get("sequence"));
            sequenceKey = (String)payload.get("sequenceKey");
        }
        boolean isChildTeamContainerUpdate = false;
        String metaMap = (String)payload.get("metaMap");
        String updateChildId = (String)payload.get("childId");
        HashMap removeTC = (HashMap)payload.get("removeTC");
        Item item = this.itemRepository.findById(itemId);
        if (item.getPhoenixSequence() == null) {
            item.setPhoenixSequence(item.maxPhoenixSequence());
        }
        SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)((SessionBoard)item.getSessionBoards().get(0)).getId()));
        String oldParentId = null;
        if (item.getParent() != null) {
            oldParentId = item.getParent().getTfsId();
        }
        item.setMetaMap(metaMap);
        List childs = null;
        boolean avoidParentLog = false;
        if (updateChildId != null && !updateChildId.equals("all") && !updateChildId.equals("teamcontainer")) {
            Item child = this.itemRepository.findById(updateChildId);
            childs = new ArrayList<Item>();
            childs.add(child);
            if (PropertyValidator.isValid((Object)teamChange) && !teamChange.equals("true")) {
                avoidParentLog = true;
            }
        }
        TeamContainer teamContainer = null;
        if (removeTC != null) {
            String removeTCId = (String)removeTC.get("id");
            List teamContainers = item.getTeamContainers();
            if (teamContainers != null) {
                for (int i = 0; i < teamContainers.size(); ++i) {
                    TeamContainer tc = (TeamContainer)teamContainers.get(i);
                    if (!tc.getId().equals(removeTCId)) continue;
                    teamContainers.remove(i);
                    break;
                }
            }
            item.setTeamContainers(teamContainers);
            Boolean removeChild = (Boolean)removeTC.get("child");
            if (childs == null) {
                ArrayList tcs = new ArrayList();
                TeamContainer tc = new TeamContainer();
                tc.setId(removeTCId);
                tcs.add(tc);
                Item parent = new Item();
                parent.setId(item.getId());
                childs = this.itemRepository.findByParentAndTeamContainersIn(parent, (List)tcs);
            }
            if (removeChild != null && removeChild.booleanValue() && childs != null) {
                for (Item child : childs) {
                    child.setTeamContainers(new ArrayList());
                }
            }
        }
        Container oldContainer = null;
        Team oldTeam = null;
        HashMap childPreviousAreaPathMap = new HashMap();
        if (teamContainerStr != null) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                teamContainer = (TeamContainer)mapper.readValue(teamContainerStr, TeamContainer.class);
            }
            catch (JsonParseException child) {
            }
            catch (JsonMappingException child) {
            }
            catch (IOException child) {
                // empty catch block
            }
            if (item.getType().equals("Feature") && PropertyValidator.isValid((Object)teamContainer.getId())) {
                isChildTeamContainerUpdate = true;
                TeamContainer old = (TeamContainer)this.teamContainerRepository.findOne((Serializable)((Object)teamContainer.getId()));
                if (old != null) {
                    oldContainer = old.getContainer();
                    oldTeam = old.getTeam();
                }
            }
            teamContainer.setContainer((Container)this.containerRepository.findOne((Serializable)((Object)teamContainer.getContainer().getId())));
            teamContainer = (TeamContainer)this.teamContainerRepository.save((Object)teamContainer);
            if (updateChildId != null && updateChildId.equals("teamcontainer")) {
                ArrayList<TeamContainer> tcs = new ArrayList<TeamContainer>();
                TeamContainer tc = new TeamContainer();
                tc.setId(teamContainer.getId());
                tcs.add(tc);
                Item parent = new Item();
                parent.setId(item.getId());
                childs = this.itemRepository.findByParentAndTeamContainersIn(parent, tcs);
            }
            ArrayList<TeamContainer> itemTeamContainers = item.getTeamContainers();
            if (item.getParent() != null) {
                List inboundItemLinks;
                if (itemTeamContainers != null) {
                    itemTeamContainers.clear();
                }
                ArrayList allItemLinks = new ArrayList();
                List outboundItemLinks = item.getItemLinks();
                if (PropertyValidator.isValid((Collection)outboundItemLinks)) {
                    for (int i = 0; i < outboundItemLinks.size(); ++i) {
                        ItemLink link = (ItemLink)outboundItemLinks.get(i);
                        link.setSourceTeamContainerId(teamContainer.getId());
                        link.setSourceFeatureId(item.getParent().getId());
                    }
                    allItemLinks.addAll(outboundItemLinks);
                }
                if (PropertyValidator.isValid((Collection)(inboundItemLinks = this.itemLinkRepository.findByTargetUserStoryId(item.getId())))) {
                    for (int i = 0; i < inboundItemLinks.size(); ++i) {
                        ItemLink link = (ItemLink)inboundItemLinks.get(i);
                        link.setTargetTeamContainerId(teamContainer.getId());
                        link.setTargetFeatureId(item.getParent().getId());
                    }
                    allItemLinks.addAll(inboundItemLinks);
                    responseJson.put("updatedLinks", inboundItemLinks);
                }
                if (PropertyValidator.isValid(allItemLinks)) {
                    this.itemLinkRepository.save(allItemLinks);
                }
            }
            if (itemTeamContainers == null) {
                itemTeamContainers = new ArrayList<TeamContainer>();
                item.setTeamContainers(itemTeamContainers);
            }
            for (int i = 0; i < itemTeamContainers.size(); ++i) {
                TeamContainer tc = (TeamContainer)itemTeamContainers.get(i);
                if (tc == null) {
                    itemTeamContainers.remove(i);
                    --i;
                    continue;
                }
                if (!tc.getId().equals(teamContainer.getId())) continue;
                itemTeamContainers.remove(i);
                break;
            }
            itemTeamContainers.add(teamContainer);
            if (childs != null) {
                ArrayList<TeamContainer> citemTeamContainers = new ArrayList<TeamContainer>();
                citemTeamContainers.add(teamContainer);
                ArrayList inboundDeps = new ArrayList();
                ArrayList outboundDeps = new ArrayList();
                for (Item child : childs) {
                    ItemLink link;
                    int i;
                    List itemLinks = child.getItemLinks();
                    if (PropertyValidator.isValid((Collection)itemLinks)) {
                        for (i = 0; i < itemLinks.size(); ++i) {
                            link = (ItemLink)itemLinks.get(i);
                            link.setSourceTeamContainerId(teamContainer.getId());
                            link.setSourceFeatureId(item.getId());
                        }
                        outboundDeps.addAll(itemLinks);
                    }
                    if (PropertyValidator.isValid((Collection)(itemLinks = this.itemLinkRepository.findByTargetUserStoryId(child.getId())))) {
                        for (i = 0; i < itemLinks.size(); ++i) {
                            link = (ItemLink)itemLinks.get(i);
                            link.setTargetTeamContainerId(teamContainer.getId());
                            link.setTargetFeatureId(item.getId());
                        }
                        inboundDeps.addAll(itemLinks);
                    }
                    child.setTeamContainers(citemTeamContainers);
                    child.putLastUpdatedValue(Item.Actions.teamContainer.name(), (Object)teamContainer);
                }
                if (PropertyValidator.isValid(outboundDeps)) {
                    this.itemLinkRepository.save(outboundDeps);
                }
                if (PropertyValidator.isValid(inboundDeps)) {
                    this.itemLinkRepository.save(inboundDeps);
                    responseJson.put("updatedLinks", inboundDeps);
                }
            }
            responseJson.put("teamContainer", teamContainer);
            if (!avoidParentLog) {
                item.putLastUpdatedValue(Item.Actions.teamContainer.name(), (Object)teamContainer);
            }
            if (oldContainer != null) {
                item.putLastUpdatedValue("oldContainer", (Object)oldContainer);
            }
            if (oldTeam != null) {
                item.putLastUpdatedValue("oldTeam", (Object)oldTeam);
            }
        }
        if (setSequence) {
            if (sequenceKey.equals("sequence")) {
                item.setSequence(Double.valueOf(sequence));
            } else {
                item.setBacklogSequence(Double.valueOf(sequence));
            }
        }
        if (parentId != null) {
            Item parent = new Item();
            parent.setId(parentId);
            item.setParent(parent);
        }
        ArrayList<Item> tfsItemsToBeUpdated = new ArrayList<Item>();
        if (PropertyValidator.isValid((Collection)item.getTeamContainers())) {
            System.out.println("teamContainerBeforeSave : " + ((TeamContainer)item.getTeamContainers().get(0)).getId());
        }
        if (PropertyValidator.isValid((Collection)(item = (Item)this.itemRepository.save((Object)item)).getTeamContainers())) {
            System.out.println("teamContainerAfterSave : " + ((TeamContainer)item.getTeamContainers().get(0)).getId());
        }
        if (!item.getType().equals("Feature")) {
            tfsItemsToBeUpdated.add(item);
        }
        if (childs != null) {
            if (childs.size() == 1) {
                Item child;
                child = (Item)childs.get(0);
                child = (Item)this.itemRepository.save((Object)child);
                responseJson.put("child", child);
                tfsItemsToBeUpdated.add(child);
            } else {
                responseJson.put("childs", childs);
                tfsItemsToBeUpdated.addAll(this.itemRepository.save(childs));
            }
        }
        responseJson.put("item", item);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    private List<ItemLink> updateDependencyStatusBasedOnItemStatus(Item item1, Item savedItem, SessionBoard sessionBoard) {
        boolean canReopen;
        String key;
        if (item1.getType().equals(Item.USER_STORY)) {
            key = sessionBoard.getSession().getSubItemLinkStatusDependentOn();
            canReopen = sessionBoard.getSession().getReOpenDependencyIfSubItemReOpen();
        } else {
            key = sessionBoard.getSession().getItemLinkStatusDependentOn();
            canReopen = sessionBoard.getSession().getReOpenDependencyIfItemReOpen();
        }
        if (PropertyValidator.isValid((Object)key) && !key.equals("-1")) {
            boolean resolveDependencies = false;
            boolean openDependencies = false;
            List statuses = this.statusRepository.findByWorkFlow(sessionBoard.getSession().getDependencyWorkFlow());
            Status openStatus = null;
            Status closeStatus = null;
            for (Status st : statuses) {
                if (openStatus == null && st.getCategory().equals("ToDo")) {
                    openStatus = st;
                }
                if (closeStatus != null || !st.getCategory().equals("Done")) continue;
                closeStatus = st;
            }
            if (PropertyValidator.isValid((Object)item1.getStatus()) && PropertyValidator.isValid((Object)item1.getStatus().getCategory()) && PropertyValidator.isValid((Object)savedItem.getStatus()) && PropertyValidator.isValid((Object)savedItem.getStatus().getCategory()) && item1.getStatus().getCategory().equals("Done") && !savedItem.getStatus().getCategory().equals(item1.getStatus().getCategory())) {
                resolveDependencies = true;
            }
            if (canReopen && PropertyValidator.isValid((Object)item1.getStatus()) && PropertyValidator.isValid((Object)item1.getStatus().getCategory()) && PropertyValidator.isValid((Object)savedItem.getStatus()) && PropertyValidator.isValid((Object)savedItem.getStatus().getCategory()) && savedItem.getStatus().getCategory().equals("Done") && !savedItem.getStatus().getCategory().equals(item1.getStatus().getCategory())) {
                openDependencies = true;
            }
            if (openDependencies || resolveDependencies) {
                List itemLinks = new ArrayList();
                if (Item.USER_STORY.equals(savedItem.getType())) {
                    if (key.equals(Session.DependencyStatusOption.SourceTarget.toString())) {
                        itemLinks = this.itemLinkRepository.findByTargetUserStoryIdOrSourceUserStoryId(savedItem.getId(), savedItem.getId());
                    } else if (key.equals(Session.DependencyStatusOption.Source.toString())) {
                        itemLinks = this.itemLinkRepository.findBySourceUserStoryId(savedItem.getId());
                    } else if (key.equals(Session.DependencyStatusOption.Target.toString())) {
                        itemLinks = this.itemLinkRepository.findByTargetUserStoryId(savedItem.getId());
                    }
                } else {
                    ArrayList tcIds = new ArrayList();
                    if (PropertyValidator.isValid((Collection)savedItem.getTeamContainers())) {
                        savedItem.getTeamContainers().forEach(tc -> {
                            if (PropertyValidator.isValid((Object)tc)) {
                                tcIds.add(tc.getId());
                            }
                        });
                    }
                    if (PropertyValidator.isValid(tcIds)) {
                        if (key.equals(Session.DependencyStatusOption.SourceTarget.toString())) {
                            itemLinks.addAll(this.itemLinkRepository.findBySourceTeamContainerIdInOrTargetTeamContainerIdIn(tcIds, tcIds));
                        } else if (key.equals(Session.DependencyStatusOption.Source.toString())) {
                            itemLinks.addAll(this.itemLinkRepository.findBySourceTeamContainerIdIn(tcIds));
                        } else if (key.equals(Session.DependencyStatusOption.Target.toString())) {
                            itemLinks.addAll(this.itemLinkRepository.findByTargetTeamContainerIdIn(tcIds));
                        }
                    }
                }
                ArrayList<ItemLink> linksToBeUpdated = new ArrayList();
                if (PropertyValidator.isValid(itemLinks)) {
                    for (ItemLink itemLink : itemLinks) {
                        boolean ignoreUpdateIfManualResolved = false;
                        if (Item.FEATURE.equals(savedItem.getType())) {
                            if (key.equals(Session.DependencyStatusOption.Source.toString()) && PropertyValidator.isValid((Object)itemLink.getSourceUserStoryId()) || key.equals(Session.DependencyStatusOption.Target.toString()) && PropertyValidator.isValid((Object)itemLink.getTargetUserStoryId())) continue;
                            ignoreUpdateIfManualResolved = sessionBoard.getSession().getIgnoreUpdateIfManualResolvedForItem() != false && itemLink.getIsManuallyResolved() != false;
                        } else {
                            boolean bl = ignoreUpdateIfManualResolved = sessionBoard.getSession().getIgnoreUpdateIfManualResolvedForSubItem() != false && itemLink.getIsManuallyResolved() != false;
                        }
                        if (ignoreUpdateIfManualResolved) continue;
                        if (resolveDependencies) {
                            itemLink.setStatus("Resolved");
                            itemLink.setWfStatus(closeStatus);
                            itemLink.setResolvedOn(new Date());
                            itemLink.setIsManuallyResolved(Boolean.valueOf(false));
                            linksToBeUpdated.add(itemLink);
                            continue;
                        }
                        itemLink.setStatus("Open");
                        itemLink.setWfStatus(openStatus);
                        itemLink.setResolvedOn(null);
                        itemLink.setIsManuallyResolved(Boolean.valueOf(false));
                        linksToBeUpdated.add(itemLink);
                    }
                    linksToBeUpdated = this.itemLinkRepository.save(linksToBeUpdated);
                    return linksToBeUpdated;
                }
            }
        }
        return null;
    }

    @RequestMapping(value={"/saveItem"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveItem(@RequestBody Item item) {
        boolean editMode = false;
        if (PropertyValidator.isValid((Object)item.getId())) {
            editMode = true;
        }
        SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)((SessionBoard)item.getSessionBoards().get(0)).getId()));
        AlmAccount almAccount = null;
        if (PropertyValidator.isValid((Object)sessionBoard.getSession().getTfsAlmConfigurations())) {
            almAccount = sessionBoard.getSession().getTfsAlmConfigurations().getAlmAccount();
        }
        ArrayList<SessionBoard> sessionBoards = new ArrayList<SessionBoard>();
        sessionBoards.add(sessionBoard);
        if (PropertyValidator.isValid((Object)almAccount) && !editMode && PropertyValidator.isValid((Object)item.getTfsProject())) {
            item.setFetchedBy(this.tfsUtils.getProfileAlmUser(almAccount));
        }
        item.setSessionBoards(sessionBoards);
        HashMap responseJson = new HashMap();
        if (PropertyValidator.isValid((Object)item.getId())) {
            Item dbItem = this.itemRepository.findById(item.getId());
            item.setSolutionSourceItemLinks(dbItem.getSolutionSourceItemLinks());
            item.setSolutionTargetItemLinks(dbItem.getSolutionTargetItemLinks());
            List updatedLinks = this.updateDependencyStatusBasedOnItemStatus(item, dbItem, sessionBoard);
            if (PropertyValidator.isValid((Collection)updatedLinks)) {
                String metaData = item.getMetaMap();
                if (PropertyValidator.isValid((Object)metaData)) {
                    ObjectMapper mapper = new ObjectMapper();
                    try {
                        String linksJson = mapper.writeValueAsString((Object)updatedLinks);
                        if (linksJson != null) {
                            String newMeta = metaData.substring(0, metaData.length() - 1) + ",\"updatedLinks\":" + linksJson + "}";
                            item.setMetaMap(newMeta);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
                    }
                }
                responseJson.put("updatedLinks", updatedLinks);
            }
        }
        this.savedItem = (Item)this.itemRepository.save((Object)item);
        this.savedItem.setSessionBoards(sessionBoards);
        if (Item.USER_STORY.equals(this.savedItem.getType())) {
            Item parentItem = null;
            if (PropertyValidator.isValid((Object)this.savedItem.getParent()) && PropertyValidator.isValid((Object)this.savedItem.getParent().getId())) {
                parentItem = (Item)this.itemRepository.findOne((Serializable)((Object)this.savedItem.getParent().getId()));
            }
            if (PropertyValidator.isValid((Object)almAccount) && PropertyValidator.isValid((Collection)this.savedItem.getTfsLinkTypes()) && PropertyValidator.isValid(parentItem) && PropertyValidator.isValid((Collection)parentItem.getTfsLinkTypes()) && parentItem.getTfsLinkTypes().indexOf(this.savedItem.getTfsLinkTypes().get(0)) == -1) {
                parentItem.getTfsLinkTypes().add(this.savedItem.getTfsLinkTypes().get(0));
                this.savedItem.setParent((Item)this.itemRepository.save((Object)parentItem));
            }
        }
        responseJson.put("item", item);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/deleteItem"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> deleteItem(@RequestBody Item itemToRemove) {
        String metaMap = itemToRemove.getMetaMap();
        if (PropertyValidator.isValid((Object)itemToRemove.getType()) && itemToRemove.getType().equals("Feature")) {
            this.customRepository.updateAlmErrorFlag(itemToRemove.getId(), false);
            this.almErrorRepository.deleteByItemId(itemToRemove.getId());
            this.customRepository.setBulkArchiveUserStoriesByParent(itemToRemove, true);
        } else {
            itemToRemove = (Item)this.itemRepository.findOne((Serializable)((Object)itemToRemove.getId()));
            itemToRemove.setErrorInAlmSync(Boolean.FALSE);
            this.almErrorRepository.deleteByItemId(itemToRemove.getId());
            AlmAccount almAccount = ((SessionBoard)itemToRemove.getSessionBoards().get(0)).getSession().getTfsAlmConfigurations().getAlmAccount();
            this.item = itemToRemove;
            this.item.setMetaMap(metaMap);
        }
        itemToRemove.setMetaMap(metaMap);
        itemToRemove.setArchive(true);
        this.itemRepository.save((Object)itemToRemove);
        if (!itemToRemove.getType().equals("Feature") && PropertyValidator.isValid((Object)itemToRemove.getParent().getId())) {
            List childItems = this.itemRepository.findByParentId(itemToRemove.getParent().getId());
            Double totalEstimate = 0.0;
            for (Item childItem : childItems) {
                totalEstimate = totalEstimate + childItem.getStoryPoints();
            }
            this.customRepository.updateItemStoryPoints(itemToRemove.getParent().getId(), totalEstimate);
        }
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        responseJson.put("success", true);
        responseJson.put("item", (Boolean)itemToRemove);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/preview-sprint"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getWiqlLDataForSprint(@RequestBody HashMap<String, Object> payload) {
        HashMap<String, String> responseJson = new HashMap<String, String>();
        String almId = (String)payload.get("almAccId");
        String qid = (String)payload.get("wiql");
        String syncId = (String)payload.get("syncId");
        Gson gson = new Gson();
        try {
            AlmAccount almAccount = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almId));
            TFSResponse tfsResponse = this.tfsUtils.getWorkItemsByTFSQueryString(qid, almAccount, false);
            responseJson.put("data", tfsResponse.getContent());
            JSONObject responseObj = new JSONObject(tfsResponse.getContent());
            ArrayList<String> itemIds = new ArrayList<String>();
            JSONArray workItemsArray = responseObj.getJSONArray("workItems");
            for (int i = 0; i < workItemsArray.length(); ++i) {
                JSONObject wiObject = workItemsArray.getJSONObject(i);
                String itemId = wiObject.getString("id");
                itemIds.add(itemId);
            }
            List subSetIds = Lists.partition(new ArrayList(itemIds), (int)100);
            for (List subItemIds : subSetIds) {
                String idsItemStr = String.join((CharSequence)",", subItemIds);
                KendisUtils.pushProgressUpdates((String)"JQL", (String)syncId, (Object)this.tfsUtils.getItems("1", idsItemStr, almAccount), (PushResponseRepository)this.pushResponseRepository, (boolean)true);
            }
        }
        catch (Exception e) {
            HashMap<String, String> exp = new HashMap<String, String>();
            exp.put("error", com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
            LOGGER.error("Exception while Wiql ::   : " + exp.get("error"));
            KendisUtils.pushProgressUpdates((String)"JQL", (String)syncId, (Object)gson.toJson(exp), (PushResponseRepository)this.pushResponseRepository, (boolean)false);
        }
        HashMap<String, Boolean> done = new HashMap<String, Boolean>();
        done.put("preview_done", true);
        KendisUtils.pushProgressUpdates((String)"JQL", (String)syncId, (Object)gson.toJson(done), (PushResponseRepository)this.pushResponseRepository, (boolean)false);
        return new ResponseEntity(null, HttpStatus.OK);
    }

    @RequestMapping(value={"/getAlmAccounts"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getAlmAccounts() {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        List alms = this.almAccountRepository.findByType("tfs");
        if (alms != null && alms.size() > 0) {
            responseJson.put("count", alms.size());
            responseJson.put("accounts", alms);
        } else {
            responseJson.put("count", 0);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/getteams"})
    @ResponseBody
    public ResponseEntity<Object> getAllTeams() {
        HashMap<String, List> responseJson = new HashMap<String, List>();
        responseJson.put("teams", this.teamRepository.findAll());
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/changeState1"})
    public SessionBoard changeState1(@RequestBody SessionBoard requestBoard) {
        Optional<Container> container;
        List mappers;
        String boardId = requestBoard.getId();
        String stateId = requestBoard.getState().getId();
        SessionBoard savedSessionBoard = null;
        ArrayList<SessionBoard> sessionBoards = new ArrayList<SessionBoard>();
        savedSessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)boardId));
        if (!PropertyValidator.isValid((Object)savedSessionBoard.getState())) {
            savedSessionBoard.setState(new State(stateId));
            this.sessionBoardRepository.save((Object)savedSessionBoard);
            return savedSessionBoard;
        }
        List newTeams = savedSessionBoard.getTeams();
        List newContainers = savedSessionBoard.getContainers();
        ArrayList<ItemLink> newItemLinks = new ArrayList<ItemLink>();
        ArrayList<Item> newItems = new ArrayList<Item>();
        ArrayList<TeamContainer> newTeamContainers = new ArrayList<TeamContainer>();
        sessionBoards.add(savedSessionBoard);
        List items = this.itemRepository.findBySessionBoardsIn(sessionBoards);
        try {
            for (Item item2 : items) {
                List itemLinks;
                TeamContainer tc22;
                List teamContainers = item2.getTeamContainers();
                if (PropertyValidator.isValid((Collection)teamContainers)) {
                    for (TeamContainer tc22 : teamContainers) {
                        Optional<TeamContainer> duplicateTc;
                        if (!PropertyValidator.isValid((Object)tc22) || (duplicateTc = newTeamContainers.stream().filter(x -> tc22.getId().equals(x.getId())).findFirst()).isPresent()) continue;
                        newTeamContainers.add(tc22);
                    }
                }
                if (!PropertyValidator.isValid((Collection)(itemLinks = item2.getItemLinks()))) continue;
                tc22 = itemLinks.iterator();
                while (tc22.hasNext()) {
                    ItemLink itemLink = (ItemLink)tc22.next();
                    newItemLinks.add(itemLink);
                }
            }
            newContainers.forEach(f -> {
                f.setDuplicateOfId(f.getId());
                if (!PropertyValidator.isValid((Object)f.getOriginItemId())) {
                    f.setOriginItemId(f.getId());
                }
                f.setId(null);
            });
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            String sStackTrace = sw.toString();
            LOGGER.debug(" :: JsonProcessingException ..  " + sStackTrace);
        }
        newContainers = this.containerRepository.save((Iterable)newContainers);
        ArrayList<TeamContainer> modTeamContainers = new ArrayList<TeamContainer>();
        for (TeamContainer tc : newTeamContainers) {
            Optional<Container> container2 = newContainers.stream().filter(x -> tc.getContainer().getId().equals(x.getDuplicateOfId())).findFirst();
            tc.setContainer(container2.get());
            modTeamContainers.add(tc);
        }
        modTeamContainers.forEach(f -> {
            f.setDuplicateOfId(f.getId());
            if (!PropertyValidator.isValid((Object)f.getOriginItemId())) {
                f.setOriginItemId(f.getId());
            }
            f.setId(null);
        });
        List subSetsModTeamContainers = Lists.partition(new ArrayList(modTeamContainers), (int)100);
        ArrayList tempModTeamContainers = new ArrayList();
        for (List subSetModTeamContainer : subSetsModTeamContainers) {
            tempModTeamContainers.addAll(this.teamContainerRepository.save((Iterable)subSetModTeamContainer));
            LOGGER.debug(" subSetModTeamContainer....  ");
        }
        modTeamContainers = tempModTeamContainers;
        HashMap<String, String> userstoryIdsMap = new HashMap<String, String>();
        HashMap<String, String> featureIdsMap = new HashMap<String, String>();
        ArrayList<ItemLink> newItemLinksNotNullList = new ArrayList<ItemLink>();
        for (ItemLink itemLink : newItemLinks) {
            String newFeatureId;
            String newUserStoryId;
            if (itemLink == null) continue;
            Optional<TeamContainer> srcTc = modTeamContainers.stream().filter(x -> itemLink.getSourceTeamContainerId().equals(x.getDuplicateOfId())).findFirst();
            Optional<TeamContainer> targetTc = modTeamContainers.stream().filter(x -> itemLink.getTargetTeamContainerId().equals(x.getDuplicateOfId())).findFirst();
            if (srcTc.isPresent()) {
                itemLink.setSourceTeamContainerId(srcTc.get().getId());
                if (PropertyValidator.isValid((Object)itemLink.getSourceUserStoryId())) {
                    if (userstoryIdsMap.containsKey(itemLink.getSourceUserStoryId())) {
                        itemLink.setSourceUserStoryId((String)userstoryIdsMap.get(itemLink.getSourceUserStoryId()));
                    } else {
                        newUserStoryId = ObjectId.get().toString();
                        userstoryIdsMap.put(itemLink.getSourceUserStoryId(), newUserStoryId);
                        itemLink.setSourceUserStoryId(newUserStoryId);
                    }
                }
                if (PropertyValidator.isValid((Object)itemLink.getSourceFeatureId())) {
                    if (featureIdsMap.containsKey(itemLink.getSourceFeatureId())) {
                        itemLink.setSourceFeatureId((String)featureIdsMap.get(itemLink.getSourceFeatureId()));
                    } else {
                        newFeatureId = ObjectId.get().toString();
                        featureIdsMap.put(itemLink.getSourceFeatureId(), newFeatureId);
                        itemLink.setSourceFeatureId(newFeatureId);
                    }
                }
            }
            if (targetTc.isPresent()) {
                itemLink.setTargetTeamContainerId(targetTc.get().getId());
                if (PropertyValidator.isValid((Object)itemLink.getTargetUserStoryId())) {
                    if (userstoryIdsMap.containsKey(itemLink.getTargetUserStoryId())) {
                        itemLink.setTargetUserStoryId((String)userstoryIdsMap.get(itemLink.getTargetUserStoryId()));
                    } else {
                        newUserStoryId = ObjectId.get().toString();
                        userstoryIdsMap.put(itemLink.getTargetUserStoryId(), newUserStoryId);
                        itemLink.setTargetUserStoryId(newUserStoryId);
                    }
                }
                if (PropertyValidator.isValid((Object)itemLink.getTargetFeatureId())) {
                    if (featureIdsMap.containsKey(itemLink.getTargetFeatureId())) {
                        itemLink.setTargetFeatureId((String)featureIdsMap.get(itemLink.getTargetFeatureId()));
                    } else {
                        newFeatureId = ObjectId.get().toString();
                        featureIdsMap.put(itemLink.getTargetFeatureId(), newFeatureId);
                        itemLink.setTargetFeatureId(newFeatureId);
                    }
                }
            }
            itemLink.setOriginItemId(itemLink.getOriginItemId() == null ? itemLink.getId() : itemLink.getOriginItemId());
            itemLink.setDuplicateOfId(itemLink.getId());
            itemLink.setId(null);
            newItemLinksNotNullList.add(itemLink);
        }
        List subSetsNewItemLinksNotNullList = Lists.partition(new ArrayList(newItemLinksNotNullList), (int)100);
        for (List subSetNewItemLinksNotNullList : subSetsNewItemLinksNotNullList) {
            this.itemLinkRepository.save((Iterable)subSetNewItemLinksNotNullList);
            LOGGER.debug(" subSetNewItemLinksNotNullList....  ");
        }
        SessionBoard sessionBoard = new SessionBoard();
        if (PropertyValidator.isValid((Object)requestBoard.getState().getIsFinal()) && requestBoard.getState().getIsFinal().booleanValue()) {
            sessionBoard.setStatus(SessionBoard.CLOSED);
        } else {
            sessionBoard.setStatus(SessionBoard.OPEN);
        }
        sessionBoard.setState(new State(stateId));
        sessionBoard.setContainers(newContainers);
        sessionBoard.setTeams(newTeams);
        sessionBoard.setTeamSequence(savedSessionBoard.getTeamSequence());
        sessionBoard.setObjectiveIds(savedSessionBoard.getObjectiveIds());
        sessionBoard.setObjectivesMap(savedSessionBoard.getObjectivesMap());
        sessionBoard.setCreationDate(new Date());
        sessionBoard.setSession(savedSessionBoard.getSession());
        SessionBoard sessionBoard2 = (SessionBoard)this.sessionBoardRepository.save((Object)sessionBoard);
        if (savedSessionBoard.getSession().getAlmEnabled().booleanValue() && PropertyValidator.isValid((Collection)(mappers = this.itemSyncMapperRepository.findBySessionBoard(savedSessionBoard)))) {
            Object itemSyncMapper22;
            for (Object itemSyncMapper22 : mappers) {
                itemSyncMapper22.setSessionBoard(sessionBoard2);
                container = newContainers.stream().filter(arg_0 -> KendisBoardController.lambda$changeState1$19((ItemSyncMapper)itemSyncMapper22, arg_0)).findFirst();
                if (!container.isPresent()) continue;
                itemSyncMapper22.setContainer(container.get());
            }
            List subSetsMappers = Lists.partition(new ArrayList(mappers), (int)100);
            itemSyncMapper22 = subSetsMappers.iterator();
            while (itemSyncMapper22.hasNext()) {
                List subSetMappers = (List)itemSyncMapper22.next();
                this.itemSyncMapperRepository.save((Iterable)subSetMappers);
                LOGGER.debug(" subSetMappers....  ");
            }
        }
        List tsvList = this.teamSprintVelocityRepository.findBySessionBoardId(savedSessionBoard.getId());
        tsvList.forEach(f -> f.setDuplicateOfId(f.getId()));
        for (Object newTsv : tsvList) {
            container = newContainers.stream().filter(arg_0 -> KendisBoardController.lambda$changeState1$21((TeamSprintVelocity)newTsv, arg_0)).findFirst();
            if (container.isPresent()) {
                newTsv.setSprintId(container.get().getId());
            }
            newTsv.setId(null);
            newTsv.setSessionBoardId(sessionBoard2.getId());
        }
        List subSetsTSVList = Lists.partition(new ArrayList(tsvList), (int)100);
        for (Object subSetTSVList : subSetsTSVList) {
            this.teamSprintVelocityRepository.save((Iterable)subSetTSVList);
            LOGGER.debug(" subSetTSVList....  ");
        }
        ArrayList<SessionBoard> newSessionBoardList = new ArrayList<SessionBoard>();
        newSessionBoardList.add(sessionBoard2);
        for (Item item3 : items) {
            if (PropertyValidator.isValid((Collection)item3.getTeamContainers())) {
                for (TeamContainer tc : item3.getTeamContainers()) {
                    for (TeamContainer xtc : modTeamContainers) {
                        if (!PropertyValidator.isValid((Object)tc) || !PropertyValidator.isValid((Object)xtc) || !tc.getId().equals(xtc.getDuplicateOfId())) continue;
                        tc.setId(xtc.getId());
                    }
                }
            }
            item3.setSessionBoards(newSessionBoardList);
            newItems.add(item3);
        }
        ArrayList itemJiraDependencies = new ArrayList();
        HashMap oldIdsMap = new HashMap();
        HashMap itemDuplicateOfMap = new HashMap();
        newItems.forEach(item -> {
            String newItemId = ObjectId.get().toString();
            oldIdsMap.put(item.getId(), newItemId);
            item.setDuplicateOfId(item.getId());
            if (!PropertyValidator.isValid((Object)item.getOriginItemId())) {
                item.setOriginItemId(item.getId());
            }
            if ("UserStory".equals(item.getType())) {
                if (userstoryIdsMap.containsKey(item.getId())) {
                    oldIdsMap.put(item.getId(), userstoryIdsMap.get(item.getId()));
                    item.setId((String)userstoryIdsMap.get(item.getId()));
                } else {
                    item.setId(newItemId);
                }
            } else if (featureIdsMap.containsKey(item.getId())) {
                oldIdsMap.put(item.getId(), featureIdsMap.get(item.getId()));
                item.setId((String)featureIdsMap.get(item.getId()));
            } else {
                item.setId(newItemId);
            }
            item.setSuspendActivity(true);
            if (PropertyValidator.isValid((Collection)item.getJiraDependencies())) {
                for (ItemJiraDependency itemJiraDependency : item.getJiraDependencies()) {
                    if (PropertyValidator.isValid((Object)itemJiraDependency.getSourceItemId()) && oldIdsMap.containsKey(itemJiraDependency.getSourceItemId())) {
                        itemJiraDependency.setId(null);
                        itemJiraDependency.setSourceItemId((String)oldIdsMap.get(itemJiraDependency.getSourceItemId()));
                    }
                    if (PropertyValidator.isValid((Object)itemJiraDependency.getTargetItemId()) && oldIdsMap.containsKey(itemJiraDependency.getTargetItemId())) {
                        itemJiraDependency.setId(null);
                        itemJiraDependency.setTargetItemId((String)oldIdsMap.get(itemJiraDependency.getTargetItemId()));
                    }
                    itemJiraDependencies.add(itemJiraDependency);
                }
            }
            itemDuplicateOfMap.put(item.getDuplicateOfId(), item.getId());
        });
        if (PropertyValidator.isValid(itemJiraDependencies)) {
            List subSetsItemJiraDependencies = Lists.partition(new ArrayList(itemJiraDependencies), (int)100);
            for (Object subSetItemJiraDependencies : subSetsItemJiraDependencies) {
                this.itemJiraDependencyRepository.save((Iterable)subSetItemJiraDependencies);
                LOGGER.debug(" subSetItemJiraDependencies....  ");
            }
        }
        List subSetsNewItems = Lists.partition(new ArrayList(newItems), (int)100);
        ArrayList tempNewItems = new ArrayList();
        for (List subSetNewItems : subSetsNewItems) {
            tempNewItems.addAll(this.itemRepository.save((Iterable)subSetNewItems));
            LOGGER.debug(" subSetNewItems....  ");
        }
        newItems = tempNewItems;
        ArrayList<Item> itemsWithParent = new ArrayList<Item>();
        int ind = 0;
        for (Item item2 : newItems) {
            if (!Item.USER_STORY.equals(item2.getType()) || !PropertyValidator.isValid((Object)item2.getParent())) continue;
            if (itemDuplicateOfMap.containsKey(item2.getParent().getId())) {
                item2.setParent(new Item((String)itemDuplicateOfMap.get(item2.getParent().getId())));
                itemsWithParent.add(item2);
            }
            LOGGER.debug(" Item.USER_STORY.equals(item.getType()) loop....  " + ind++);
        }
        List subSetsItemsWithParent = Lists.partition(new ArrayList(itemsWithParent), (int)100);
        for (List subSetItemsWithParent : subSetsItemsWithParent) {
            this.itemRepository.save((Iterable)subSetItemsWithParent);
            LOGGER.debug(" subSetItemsWithParent....  ");
        }
        sessionBoard2.copyObjectives(itemDuplicateOfMap);
        this.customRepository.setSessionBoardParent(savedSessionBoard.getId(), sessionBoard2.getId());
        this.customRepository.lockSessionBoard(savedSessionBoard.getId(), Boolean.valueOf(true));
        this.customRepository.updateSessionBoardsParent(boardId, sessionBoard2.getId());
        this.customRepository.updateActiveSessionBoard(sessionBoard2.getSession().getId(), sessionBoard2.getId());
        SessionBoard sessionBoard3 = (SessionBoard)this.sessionBoardRepository.save((Object)sessionBoard2);
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("type", (Object)"Board");
            jSONObject.put("newStateId", (Object)stateId);
            jSONObject.put("newBoardId", (Object)sessionBoard3.getId());
            jSONObject.put("metaMap", (Object)requestBoard.getMetaMap());
            PushSender.sendMsg((String)jSONObject.toString());
        }
        catch (JSONException e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
        }
        return sessionBoard3;
    }

    /*
     * WARNING - void declaration
     */
    @RequestMapping(value={"/changeState"})
    @ResponseBody
    public ResponseEntity<Object> changeState(@RequestBody SessionBoard requestBoard) {
        HashMap<String, SessionBoard> responseJson = new HashMap<String, SessionBoard>();
        String boardId = requestBoard.getId();
        String stateId = requestBoard.getState().getId();
        SessionBoard savedSessionBoard = null;
        ArrayList<SessionBoard> sessionBoards = new ArrayList<SessionBoard>();
        savedSessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)boardId));
        SessionBoard newSessionBoard = new SessionBoard();
        if (!PropertyValidator.isValid((Object)savedSessionBoard.getState())) {
            savedSessionBoard.setState(new State(stateId));
            this.sessionBoardRepository.save((Object)savedSessionBoard);
            responseJson.put("sessionBoard", savedSessionBoard);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        try {
            void var26_34;
            List list;
            ItemLink itemLink;
            List risks;
            List newTeams = savedSessionBoard.getTeams();
            List newContainers = savedSessionBoard.getContainers();
            ArrayList<ItemLink> newItemLinks = new ArrayList<ItemLink>();
            ArrayList<ItemLink> newSolutionSourceItemLinks = new ArrayList<ItemLink>();
            ArrayList<ItemLink> newSolutionTargetItemLinks = new ArrayList<ItemLink>();
            ArrayList<Item> newItems = new ArrayList<Item>();
            ArrayList<TeamContainer> newTeamContainers = new ArrayList<TeamContainer>();
            ArrayList containerIds = new ArrayList();
            HashMap containerIdsMap = new HashMap();
            sessionBoards.add(savedSessionBoard);
            List items = this.itemRepository.findBySessionBoardsIn(sessionBoards);
            for (Item item : items) {
                Iterator iterator;
                List teamContainers = item.getTeamContainers();
                if (PropertyValidator.isValid((Collection)teamContainers)) {
                    for (TeamContainer tc : teamContainers) {
                        Optional<TeamContainer> duplicateTca;
                        if (!PropertyValidator.isValid((Object)tc) || (duplicateTca = newTeamContainers.stream().filter(x -> tc.getId().equals(x.getId())).findFirst()).isPresent()) continue;
                        newTeamContainers.add(tc);
                    }
                }
                Iterator itemLinks = item.getItemLinks();
                ArrayList solutionSourceItemLinks = item.getSolutionSourceItemLinks();
                ArrayList solutionTargetItemLinks = item.getSolutionTargetItemLinks();
                if (PropertyValidator.isValid((Collection)((Object)itemLinks))) {
                    iterator = itemLinks.iterator();
                    while (iterator.hasNext()) {
                        ItemLink itemLink22 = (ItemLink)iterator.next();
                        newItemLinks.add(itemLink22);
                    }
                }
                if (PropertyValidator.isValid((Collection)solutionSourceItemLinks)) {
                    for (Object itemLink2 : solutionSourceItemLinks) {
                        newSolutionSourceItemLinks.add((ItemLink)itemLink2);
                    }
                }
                if (!PropertyValidator.isValid((Collection)solutionTargetItemLinks)) continue;
                iterator = solutionTargetItemLinks.iterator();
                while (iterator.hasNext()) {
                    Object itemLink2;
                    itemLink2 = (ItemLink)iterator.next();
                    newSolutionTargetItemLinks.add((ItemLink)itemLink2);
                }
            }
            newContainers.forEach(f -> {
                String newContainerId = ObjectId.get().toString();
                containerIds.add(f.getId());
                containerIdsMap.put(f.getId(), newContainerId);
                f.setDuplicateOfId(f.getId());
                if (!PropertyValidator.isValid((Object)f.getOriginItemId())) {
                    f.setOriginItemId(f.getId());
                }
                f.setId(newContainerId);
            });
            RiskRegister riskRegiter = savedSessionBoard.getSession().getRiskRegister();
            if (PropertyValidator.isValid((Object)riskRegiter) && PropertyValidator.isValid((Collection)(risks = this.riskRepository.findByRiskRegister(riskRegiter)))) {
                ArrayList risksToSave = new ArrayList();
                for (Risk risk : risks) {
                    if (!PropertyValidator.isValid((Collection)risk.getBoardSprints())) continue;
                    risk.getBoardSprints().forEach(bs -> {
                        String newSprintId = (String)containerIdsMap.get(bs.getSprintId());
                        if (PropertyValidator.isValid((Object)newSprintId)) {
                            bs.setSprintId(newSprintId);
                            risksToSave.add(risk);
                        }
                    });
                }
                if (PropertyValidator.isValid(risksToSave)) {
                    this.riskRepository.save(risksToSave);
                }
            }
            List solutionEpicItemsLinks = this.itemLinkRepository.findBySourceContainerIdInOrTargetContainerIdInAndSolutionIdExists(containerIds, containerIds, true);
            Object modTeamContainers = new ArrayList<TeamContainer>();
            for (TeamContainer tc : newTeamContainers) {
                if (!PropertyValidator.isValid((Object)tc) || !PropertyValidator.isValid((Object)tc.getContainer()) || !PropertyValidator.isValid((Object)tc.getContainer().getId())) continue;
                for (Container newContainer : newContainers) {
                    if (!tc.getContainer().getId().equals(newContainer.getDuplicateOfId())) continue;
                    tc.setContainer(newContainer);
                }
                modTeamContainers.add(tc);
            }
            modTeamContainers.forEach(f -> {
                f.setDuplicateOfId(f.getId());
                if (!PropertyValidator.isValid((Object)f.getOriginItemId())) {
                    f.setOriginItemId(f.getId());
                }
                f.setId(ObjectId.get().toString());
            });
            HashMap<String, String> userstoryIdsMap = new HashMap<String, String>();
            HashMap<String, String> featureIdsMap = new HashMap<String, String>();
            ArrayList<ItemLink> newItemLinksNotNullList = new ArrayList<ItemLink>();
            ArrayList<ItemLink> newSolutionItemLinksNotNullList = new ArrayList<ItemLink>();
            for (ItemLink itemLink3 : newItemLinks) {
                String newFeatureId;
                String newUserStoryId;
                if (itemLink3 == null) continue;
                Optional<TeamContainer> optional = modTeamContainers.stream().filter(x -> itemLink3.getSourceTeamContainerId().equals(x.getDuplicateOfId())).findFirst();
                Optional<TeamContainer> targetTc = modTeamContainers.stream().filter(x -> itemLink3.getTargetTeamContainerId().equals(x.getDuplicateOfId())).findFirst();
                if (optional.isPresent()) {
                    itemLink3.setSourceTeamContainerId(optional.get().getId());
                }
                if (PropertyValidator.isValid((Object)itemLink3.getSourceUserStoryId())) {
                    if (userstoryIdsMap.containsKey(itemLink3.getSourceUserStoryId())) {
                        itemLink3.setSourceUserStoryId((String)userstoryIdsMap.get(itemLink3.getSourceUserStoryId()));
                    } else {
                        newUserStoryId = ObjectId.get().toString();
                        userstoryIdsMap.put(itemLink3.getSourceUserStoryId(), newUserStoryId);
                        itemLink3.setSourceUserStoryId(newUserStoryId);
                    }
                }
                if (PropertyValidator.isValid((Object)itemLink3.getSourceFeatureId())) {
                    if (featureIdsMap.containsKey(itemLink3.getSourceFeatureId())) {
                        itemLink3.setSourceFeatureId((String)featureIdsMap.get(itemLink3.getSourceFeatureId()));
                    } else {
                        newFeatureId = ObjectId.get().toString();
                        featureIdsMap.put(itemLink3.getSourceFeatureId(), newFeatureId);
                        itemLink3.setSourceFeatureId(newFeatureId);
                    }
                }
                if (targetTc.isPresent()) {
                    itemLink3.setTargetTeamContainerId(targetTc.get().getId());
                }
                if (PropertyValidator.isValid((Object)itemLink3.getTargetUserStoryId())) {
                    if (userstoryIdsMap.containsKey(itemLink3.getTargetUserStoryId())) {
                        itemLink3.setTargetUserStoryId((String)userstoryIdsMap.get(itemLink3.getTargetUserStoryId()));
                    } else {
                        newUserStoryId = ObjectId.get().toString();
                        userstoryIdsMap.put(itemLink3.getTargetUserStoryId(), newUserStoryId);
                        itemLink3.setTargetUserStoryId(newUserStoryId);
                    }
                }
                if (PropertyValidator.isValid((Object)itemLink3.getTargetFeatureId())) {
                    if (featureIdsMap.containsKey(itemLink3.getTargetFeatureId())) {
                        itemLink3.setTargetFeatureId((String)featureIdsMap.get(itemLink3.getTargetFeatureId()));
                    } else {
                        newFeatureId = ObjectId.get().toString();
                        featureIdsMap.put(itemLink3.getTargetFeatureId(), newFeatureId);
                        itemLink3.setTargetFeatureId(newFeatureId);
                    }
                }
                itemLink3.setOriginItemId(itemLink3.getOriginItemId() == null ? itemLink3.getId() : itemLink3.getOriginItemId());
                itemLink3.setDuplicateOfId(itemLink3.getId());
                itemLink3.setId(ObjectId.get().toString());
                itemLink3.setSessionBoardId(newSessionBoard.getId());
                newItemLinksNotNullList.add(itemLink3);
            }
            HashMap<String, ItemLink> solutionLinkMap = new HashMap<String, ItemLink>();
            for (ItemLink itemLink4 : newSolutionSourceItemLinks) {
                if (itemLink4 == null) continue;
                if (PropertyValidator.isValid((Object)itemLink4.getSourceItemId())) {
                    if (featureIdsMap.containsKey(itemLink4.getSourceItemId())) {
                        itemLink4.setSourceItemId((String)featureIdsMap.get(itemLink4.getSourceItemId()));
                    } else {
                        String newItemId = ObjectId.get().toString();
                        featureIdsMap.put(itemLink4.getSourceItemId(), newItemId);
                        itemLink4.setSourceItemId(newItemId);
                    }
                    solutionLinkMap.put(itemLink4.getId(), itemLink4);
                }
                newSolutionItemLinksNotNullList.add(itemLink4);
            }
            for (ItemLink itemLink5 : newSolutionTargetItemLinks) {
                itemLink = (ItemLink)solutionLinkMap.get(itemLink5.getId());
                if (itemLink == null) {
                    itemLink = itemLink5;
                }
                if (itemLink == null) continue;
                if (PropertyValidator.isValid((Object)itemLink.getTargetItemId())) {
                    if (featureIdsMap.containsKey(itemLink.getTargetItemId())) {
                        itemLink.setTargetItemId((String)featureIdsMap.get(itemLink.getTargetItemId()));
                    } else {
                        String newItemId = ObjectId.get().toString();
                        featureIdsMap.put(itemLink.getTargetItemId(), newItemId);
                        itemLink.setTargetItemId(newItemId);
                    }
                }
                if (PropertyValidator.isValid(solutionLinkMap.get(itemLink5.getId()))) continue;
                newSolutionItemLinksNotNullList.add(itemLink);
            }
            for (ItemLink itemLink6 : solutionEpicItemsLinks) {
                itemLink = (ItemLink)solutionLinkMap.get(itemLink6.getId());
                if (itemLink == null) {
                    itemLink = itemLink6;
                }
                if (itemLink == null) continue;
                boolean linkUpdated = false;
                if (PropertyValidator.isValid((Object)itemLink.getSourceContainerId()) && containerIdsMap.containsKey(itemLink.getSourceContainerId())) {
                    itemLink.setSourceContainerId((String)containerIdsMap.get(itemLink.getSourceContainerId()));
                    linkUpdated = true;
                }
                if (PropertyValidator.isValid((Object)itemLink.getTargetContainerId()) && containerIdsMap.containsKey(itemLink.getTargetContainerId())) {
                    itemLink.setTargetContainerId((String)containerIdsMap.get(itemLink.getTargetContainerId()));
                    linkUpdated = true;
                }
                if (PropertyValidator.isValid(solutionLinkMap.get(itemLink6.getId())) || !linkUpdated) continue;
                newSolutionItemLinksNotNullList.add(itemLink);
                solutionLinkMap.put(itemLink.getId(), itemLink);
            }
            solutionLinkMap = null;
            if (PropertyValidator.isValid((Object)requestBoard.getState().getIsFinal()) && requestBoard.getState().getIsFinal().booleanValue()) {
                newSessionBoard.setStatus(SessionBoard.CLOSED);
            } else {
                newSessionBoard.setStatus(SessionBoard.OPEN);
            }
            newSessionBoard.setState(new State(stateId));
            newSessionBoard.setContainers(newContainers);
            newSessionBoard.setTeams(newTeams);
            newSessionBoard.setTeamSequence(savedSessionBoard.getTeamSequence());
            newSessionBoard.setObjectiveIds(savedSessionBoard.getObjectiveIds());
            newSessionBoard.setObjectivesMap(savedSessionBoard.getObjectivesMap());
            newSessionBoard.setCreationDate(new Date());
            newSessionBoard.setSession(savedSessionBoard.getSession());
            newSessionBoard.setCreatedOn(new Date());
            newSessionBoard.setCreatedBy(UserContextUtil.getUserContext().getLoggedInUser().getUserName());
            newSessionBoard.setId(ObjectId.get().toString());
            Object var26_32 = null;
            if (savedSessionBoard.getSession().getAlmEnabled().booleanValue() && PropertyValidator.isValid((Collection)(list = this.itemSyncMapperRepository.findBySessionBoard(savedSessionBoard)))) {
                for (ItemSyncMapper itemSyncMapper : list) {
                    itemSyncMapper.setSessionBoard(newSessionBoard);
                    Optional<Container> container = newContainers.stream().filter(x -> itemSyncMapper.getContainer().getId().equals(x.getDuplicateOfId())).findFirst();
                    if (!container.isPresent()) continue;
                    itemSyncMapper.setContainer(container.get());
                }
            }
            List list2 = this.teamSprintVelocityRepository.findBySessionBoardId(savedSessionBoard.getId());
            list2.forEach(f -> f.setDuplicateOfId(f.getId()));
            for (TeamSprintVelocity newTsv : list2) {
                Optional<Container> container = newContainers.stream().filter(x -> newTsv.getSprintId().equals(x.getDuplicateOfId())).findFirst();
                if (container.isPresent()) {
                    newTsv.setSprintId(container.get().getId());
                }
                newTsv.setId(ObjectId.get().toString());
                newTsv.setSessionBoardId(newSessionBoard.getId());
            }
            ArrayList<SessionBoard> newSessionBoardList = new ArrayList<SessionBoard>();
            newSessionBoardList.add(newSessionBoard);
            for (Object item : items) {
                if (PropertyValidator.isValid((Collection)item.getTeamContainers())) {
                    for (TeamContainer tc : item.getTeamContainers()) {
                        Iterator iterator = modTeamContainers.iterator();
                        while (iterator.hasNext()) {
                            TeamContainer xtc = (TeamContainer)iterator.next();
                            if (!PropertyValidator.isValid((Object)tc) || !PropertyValidator.isValid((Object)xtc) || !tc.getId().equals(xtc.getDuplicateOfId())) continue;
                            tc.setId(xtc.getId());
                        }
                    }
                }
                item.setSessionBoards(newSessionBoardList);
                newItems.add((Item)item);
            }
            List dependencyLimit = this.TeamSprintDependencyLimitRepository.findBySessionId(savedSessionBoard.getSession().getId());
            if (PropertyValidator.isValid((Collection)dependencyLimit)) {
                for (TeamSprintDependencyLimit teamSprintLimit : dependencyLimit) {
                    Optional<Container> container = newContainers.stream().filter(x -> teamSprintLimit.getSprintId().equals(x.getDuplicateOfId())).findFirst();
                    if (!container.isPresent()) continue;
                    teamSprintLimit.setSprintId(container.get().getId());
                }
                this.TeamSprintDependencyLimitRepository.save((Iterable)dependencyLimit);
            }
            ArrayList<Item> itemsWithParent = new ArrayList<Item>();
            ArrayList<ItemJiraDependency> itemJiraDependencies = new ArrayList<ItemJiraDependency>();
            HashMap<String, String> oldIdsMap = new HashMap<String, String>();
            HashMap<String, String> itemDuplicateOfMap = new HashMap<String, String>();
            for (Item item : newItems) {
                String newItemId = ObjectId.get().toString();
                oldIdsMap.put(item.getId(), newItemId);
                item.setDuplicateOfId(item.getId());
                if (!PropertyValidator.isValid((Object)item.getOriginItemId())) {
                    item.setOriginItemId(item.getId());
                }
                if (Item.USER_STORY.equals(item.getType())) {
                    if (userstoryIdsMap.containsKey(item.getId())) {
                        oldIdsMap.put(item.getId(), (String)userstoryIdsMap.get(item.getId()));
                        item.setId((String)userstoryIdsMap.get(item.getId()));
                    } else {
                        item.setId(newItemId);
                    }
                } else if (featureIdsMap.containsKey(item.getId())) {
                    oldIdsMap.put(item.getId(), (String)featureIdsMap.get(item.getId()));
                    item.setId((String)featureIdsMap.get(item.getId()));
                } else {
                    item.setId(newItemId);
                }
                item.setSuspendActivity(true);
                itemDuplicateOfMap.put(item.getDuplicateOfId(), item.getId());
            }
            boolean ind = false;
            for (Item item : newItems) {
                if (Item.USER_STORY.equals(item.getType()) && PropertyValidator.isValid((Object)item.getParent()) && itemDuplicateOfMap.containsKey(item.getParent().getId())) {
                    item.setParent(new Item((String)itemDuplicateOfMap.get(item.getParent().getId())));
                    itemsWithParent.add(item);
                }
                if (!PropertyValidator.isValid((Collection)item.getJiraDependencies())) continue;
                for (ItemJiraDependency itemJiraDependency : item.getJiraDependencies()) {
                    if (!PropertyValidator.isValid((Object)itemJiraDependency)) continue;
                    itemJiraDependency.setSessionBoardId(newSessionBoard.getId());
                    String depId = itemJiraDependency.getId();
                    if (depId.equals("604a0b98efca94129bd486b2") || depId.equals("")) {
                        depId = "";
                    }
                    itemJiraDependency.setOriginItemId(itemJiraDependency.getOriginItemId() == null ? itemJiraDependency.getId() : itemJiraDependency.getOriginItemId());
                    itemJiraDependency.setDuplicateOfId(itemJiraDependency.getId());
                    if (PropertyValidator.isValid((Object)itemJiraDependency.getSourceItemId()) && oldIdsMap.containsKey(itemJiraDependency.getSourceItemId())) {
                        itemJiraDependency.setId(ObjectId.get().toString());
                        itemJiraDependency.setSourceItemId((String)oldIdsMap.get(itemJiraDependency.getSourceItemId()));
                    }
                    if (PropertyValidator.isValid((Object)itemJiraDependency.getTargetItemId()) && oldIdsMap.containsKey(itemJiraDependency.getTargetItemId())) {
                        itemJiraDependency.setId(ObjectId.get().toString());
                        itemJiraDependency.setTargetItemId((String)oldIdsMap.get(itemJiraDependency.getTargetItemId()));
                    }
                    itemJiraDependencies.add(itemJiraDependency);
                }
            }
            newSessionBoard.copyObjectives(itemDuplicateOfMap);
            RiskRegister riskRegister = savedSessionBoard.getSession().getRiskRegister();
            List linkedRisks = null;
            if (PropertyValidator.isValid((Object)riskRegister) && PropertyValidator.isValid((Object)riskRegister.getId())) {
                linkedRisks = this.riskRepository.findAllByRiskRegisterId(riskRegister.getId());
                for (Risk risk : linkedRisks) {
                    List linkedItemIds = risk.getLinkedItemsIds();
                    if (!PropertyValidator.isValid((Collection)linkedItemIds)) continue;
                    for (int i = 0; i < linkedItemIds.size(); ++i) {
                        if (linkedItemIds.get(i) == null || itemDuplicateOfMap == null || itemDuplicateOfMap.get(linkedItemIds.get(i)) == null || risk.getLinkedItemsById() == null || risk.getLinkedItemsById().get(linkedItemIds.get(i)) == null) continue;
                        HashMap linkedItemById = (HashMap)risk.getLinkedItemsById().get(linkedItemIds.get(i));
                        risk.getLinkedItemsById().remove(linkedItemIds.get(i));
                        linkedItemIds.set(i, itemDuplicateOfMap.get(linkedItemIds.get(i)));
                        risk.getLinkedItemsById().put(linkedItemIds.get(i), linkedItemById);
                    }
                }
                if (PropertyValidator.isValid((Collection)linkedRisks)) {
                    List subSetsLinkedRisks = Lists.partition(new ArrayList(linkedRisks), (int)100);
                    ArrayList tempLinkedRisks = new ArrayList();
                    for (List subSetLinkedRisks : subSetsLinkedRisks) {
                        tempLinkedRisks.addAll(this.riskRepository.save((Iterable)subSetLinkedRisks));
                        LOGGER.debug(" subSetsLinkedRisks ....  ");
                    }
                }
            }
            this.piJourneyService.changeState(requestBoard, newSessionBoard, containerIdsMap);
            if (PropertyValidator.isValid((Collection)newContainers)) {
                newContainers = this.containerRepository.save((Iterable)newContainers);
            }
            if (PropertyValidator.isValid(modTeamContainers)) {
                List subSetsModTeamContainers = Lists.partition(new ArrayList(modTeamContainers), (int)100);
                Iterator tempModTeamContainers = new ArrayList();
                for (List subSetModTeamContainer : subSetsModTeamContainers) {
                    tempModTeamContainers.addAll(this.teamContainerRepository.save((Iterable)subSetModTeamContainer));
                    LOGGER.debug(" subSetModTeamContainer....  ");
                }
                modTeamContainers = tempModTeamContainers;
            }
            if (PropertyValidator.isValid(newItemLinksNotNullList)) {
                List subSetsNewItemLinksNotNullList = Lists.partition(new ArrayList(newItemLinksNotNullList), (int)100);
                for (List subSetNewItemLinksNotNullList : subSetsNewItemLinksNotNullList) {
                    this.itemLinkRepository.save((Iterable)subSetNewItemLinksNotNullList);
                    LOGGER.debug(" subSetNewItemLinksNotNullList....  ");
                }
            }
            if (PropertyValidator.isValid(newSolutionItemLinksNotNullList)) {
                List subSetsNewSolutionSourceItemLinksNotNullList = Lists.partition(new ArrayList(newSolutionItemLinksNotNullList), (int)100);
                for (List subSetNewSolutionSourceItemLinksNotNullList : subSetsNewSolutionSourceItemLinksNotNullList) {
                    this.itemLinkRepository.save((Iterable)subSetNewSolutionSourceItemLinksNotNullList);
                    LOGGER.debug(" subSetNewSolutionSourceItemLinksNotNullList....  ");
                }
            }
            newSessionBoard = (SessionBoard)this.sessionBoardRepository.save((Object)newSessionBoard);
            if (PropertyValidator.isValid((Collection)var26_34)) {
                List subSetsMappers = Lists.partition(new ArrayList(var26_34), (int)100);
                for (List subSetMappers : subSetsMappers) {
                    this.itemSyncMapperRepository.save((Iterable)subSetMappers);
                    LOGGER.debug(" subSetMappers....  ");
                }
            }
            if (PropertyValidator.isValid((Collection)list2)) {
                List subSetsTSVList = Lists.partition(new ArrayList(list2), (int)100);
                for (List subSetTSVList : subSetsTSVList) {
                    this.teamSprintVelocityRepository.save((Iterable)subSetTSVList);
                    LOGGER.debug(" subSetTSVList....  ");
                }
            }
            if (PropertyValidator.isValid(itemJiraDependencies)) {
                List subSetsItemJiraDependencies = Lists.partition(new ArrayList(itemJiraDependencies), (int)100);
                for (Object subSetItemJiraDependencies : subSetsItemJiraDependencies) {
                    this.itemJiraDependencyRepository.save((Iterable)subSetItemJiraDependencies);
                    LOGGER.debug(" subSetItemJiraDependencies....  ");
                }
            }
            if (PropertyValidator.isValid(newItems)) {
                List subSetsNewItems = Lists.partition(new ArrayList(newItems), (int)100);
                ArrayList tempNewItems = new ArrayList();
                for (List subSetNewItems : subSetsNewItems) {
                    tempNewItems.addAll(this.itemRepository.save((Iterable)subSetNewItems));
                    LOGGER.debug(" subSetNewItems....  ");
                }
            }
            if (PropertyValidator.isValid(itemsWithParent)) {
                List subSetsItemsWithParent = Lists.partition(new ArrayList(itemsWithParent), (int)100);
                for (List subSetItemsWithParent : subSetsItemsWithParent) {
                    this.itemRepository.save((Iterable)subSetItemsWithParent);
                    LOGGER.debug(" subSetItemsWithParent....  ");
                }
            }
            this.customRepository.setSessionBoardParent(savedSessionBoard.getId(), newSessionBoard.getId());
            this.customRepository.lockSessionBoard(savedSessionBoard.getId(), Boolean.valueOf(true));
            this.customRepository.updateSessionBoardsParent(boardId, newSessionBoard.getId());
            this.customRepository.updateActiveSessionBoard(newSessionBoard.getSession().getId(), newSessionBoard.getId());
            newSessionBoard = (SessionBoard)this.sessionBoardRepository.save((Object)newSessionBoard);
            JSONObject pushJson = new JSONObject();
            try {
                pushJson.put("type", (Object)"Board");
                pushJson.put("newStateId", (Object)stateId);
                pushJson.put("newBoardId", (Object)newSessionBoard.getId());
                pushJson.put("metaMap", (Object)requestBoard.getMetaMap());
                pushJson.put("push", (Object)"Self");
                PushSender.sendMsg((String)pushJson.toString());
                responseJson.put("sessionBoard", newSessionBoard);
            }
            catch (JSONException e) {
                LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
            }
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
            AlmError almerr = new AlmError();
            almerr.setAlmErrorMessage(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
            almerr.setHttpErrorCode(Integer.valueOf(400));
            return new ResponseEntity((Object)almerr, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/board/export/{id}/{type}"})
    public ResponseEntity<ByteArrayResource> exportBoard(@PathVariable(value="id") String id, @PathVariable(value="type") String type) {
        SessionBoard board = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)id));
        try {
            String extension = "xls";
            int exportType = 1;
            if (PropertyValidator.isValid((Object)type) && "csv".equalsIgnoreCase(type)) {
                extension = "csv";
                exportType = 0;
            }
            String csvHeader = "Position,Key,Summary,Story Points,Due Date,Status,Created by,Created on,Updated by,Updated on,Type,Card Type,Parent Key,Parent Title,Session Board,Sprints,Teams,Linked Items,Iteration,Area Path";
            String filePath = this.exportService.exportBoardData(id, board, exportType, csvHeader);
            String cleanedSessionTitle = AlmUtils.cleanText((String)board.getSession().getTitle());
            File responsefile = new File(filePath);
            Path path = Paths.get(filePath, new String[0]);
            ByteArrayResource resource = new ByteArrayResource(Files.readAllBytes(path));
            HttpHeaders headers = new HttpHeaders();
            headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
            headers.add("Pragma", "no-cache");
            headers.add("Expires", "0");
            headers.add("Content-Disposition", "attachment; filename=\"" + cleanedSessionTitle + "." + extension + "\"");
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).contentLength(responsefile.length()).contentType(MediaType.parseMediaType((String)"application/octet-stream")).body((Object)resource);
        }
        catch (IOException e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
            System.out.println(id);
            return null;
        }
    }

    @RequestMapping(value={"/remove/link"})
    public ResponseEntity<Object> removeLink(@RequestBody Item item) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            Gson g = new Gson();
            1 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap requestMap = (HashMap)g.fromJson(item.getMetaMap(), T.getType());
            Item savedItem = null;
            if (PropertyValidator.isValid((Object)item.getId())) {
                savedItem = (Item)this.itemRepository.findOne((Serializable)((Object)item.getId()));
            }
            if (savedItem == null) {
                ArrayList itemLinks = new ArrayList();
                itemLinks.add(item.getItemLinks().get(0));
                List items = this.itemRepository.findByItemLinksIn(itemLinks);
                if (PropertyValidator.isValid((Collection)items)) {
                    savedItem = (Item)items.get(0);
                }
            }
            ItemLink linktodel = null;
            if (!PropertyValidator.isValid(savedItem) || !PropertyValidator.isValid((Collection)savedItem.getItemLinks())) {
                this.itemLinkRepository.delete(item.getItemLinks().get(0));
                responseJson.put("success", true);
                responseJson.put("linkId", ((ItemLink)item.getItemLinks().get(0)).getId());
                return new ResponseEntity(responseJson, HttpStatus.OK);
            }
            for (ItemLink il : savedItem.getItemLinks()) {
                if (!PropertyValidator.isValid((Object)il) || !PropertyValidator.isValid((Object)il.getId()) || !il.getId().equals(((ItemLink)item.getItemLinks().get(0)).getId())) continue;
                linktodel = il;
                break;
            }
            if (linktodel != null) {
                this.itemLinkRepository.delete(linktodel);
                savedItem.setMetaMap(item.getMetaMap());
                savedItem.getItemLinks().remove(linktodel);
                savedItem.putLastUpdatedValue(Item.Actions.itemLinkRemoved.name(), linktodel);
                this.itemRepository.save((Object)savedItem);
                responseJson.put("success", true);
                responseJson.put("linkId", linktodel.getId());
                responseJson.put("item", savedItem);
                return new ResponseEntity(responseJson, HttpStatus.OK);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        responseJson.put("success", false);
        return new ResponseEntity(responseJson, HttpStatus.NO_CONTENT);
    }

    @RequestMapping(value={"/check/teamcontainer"})
    public ResponseEntity<Object> checkTeamContainer(@RequestBody String requestBody) {
        String sourceTeamContainerJson;
        Gson g = new Gson();
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        2 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap requestMap = (HashMap)g.fromJson(requestBody, T.getType());
        String targetTeamContainerJson = (String)requestMap.get("TteamContainer");
        if (targetTeamContainerJson != null) {
            String id = (String)requestMap.get("TteamContainerId");
            ObjectMapper map = new ObjectMapper();
            List teamContainer = null;
            try {
                teamContainer = (List)map.readValue(targetTeamContainerJson, (JavaType)map.getTypeFactory().constructCollectionType(List.class, TeamContainer.class));
            }
            catch (IOException e) {
                System.out.println(e);
            }
            TeamContainer oldTeamContainer = (TeamContainer)this.teamContainerRepository.findOne((Serializable)((Object)id));
            responseJson.put("targetNotPresent", true);
            if (PropertyValidator.isValid((Collection)teamContainer)) {
                teamContainer.forEach(tC -> {
                    if (tC.getContainer().getId().equals(oldTeamContainer.getContainer().getId()) && tC.getTeam().getId().equals(oldTeamContainer.getTeam().getId())) {
                        responseJson.put("targetNotPresent", false);
                    }
                });
            }
        }
        if ((sourceTeamContainerJson = (String)requestMap.get("SteamContainer")) != null) {
            String id = (String)requestMap.get("SteamContainerId");
            ObjectMapper map = new ObjectMapper();
            List teamContainer = null;
            try {
                teamContainer = (List)map.readValue(sourceTeamContainerJson, (JavaType)map.getTypeFactory().constructCollectionType(List.class, TeamContainer.class));
            }
            catch (IOException e) {
                System.out.println(e);
            }
            TeamContainer oldTeamContainer = (TeamContainer)this.teamContainerRepository.findOne((Serializable)((Object)id));
            responseJson.put("sourceNotPresent", true);
            if (PropertyValidator.isValid((Collection)teamContainer)) {
                teamContainer.forEach(tC -> {
                    if (tC.getContainer().getId().equals(oldTeamContainer.getContainer().getId()) && tC.getTeam().getId().equals(oldTeamContainer.getTeam().getId())) {
                        responseJson.put("sourceNotPresent", false);
                    }
                });
            }
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/save/links"})
    public List<ItemLink> saveLinks(@RequestBody String requestBody) {
        SessionBoard sessionBoard;
        Gson g = new Gson();
        3 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap requestMap = (HashMap)g.fromJson(requestBody, T.getType());
        String itemJson = (String)requestMap.get("item");
        String syncId = (String)requestMap.get("syncId");
        String metaMap = (String)requestMap.get("metaMap");
        String sourceItemTitle = (String)requestMap.get("sItem");
        String sourceTeamTitle = (String)requestMap.get("sTeam");
        String sourceSprintTitle = (String)requestMap.get("sSprint");
        String sKey = (String)requestMap.get("sKey");
        List targetSprintTitle = (List)requestMap.get("tSprint");
        List targetTeamTitle = (List)requestMap.get("tTeam");
        List targetItemTitle = (List)requestMap.get("tItem");
        List tKey = (List)requestMap.get("tKey");
        String boardTitle = (String)requestMap.get("board");
        String linkType = (String)requestMap.get("linkType");
        ObjectMapper mapper = new ObjectMapper();
        Item item = null;
        try {
            item = (Item)mapper.readValue(itemJson, mapper.getTypeFactory().constructType(Item.class));
        }
        catch (JsonParseException e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
        }
        catch (JsonMappingException e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
        }
        catch (IOException e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
        }
        List linkIdsBeingUpdated = (List)requestMap.get("linkIds");
        ArrayList<ItemLink> linksBeingUpdated = new ArrayList<ItemLink>();
        ArrayList<ItemLink> linksBeingCreated = new ArrayList<ItemLink>();
        ArrayList<ItemLink> linksToBeCreatedInTFS = new ArrayList<ItemLink>();
        for (int i = 0; i < item.getItemLinks().size(); ++i) {
            ItemLink link2 = (ItemLink)item.getItemLinks().get(i);
            if (link2.getId() == null) {
                if (PropertyValidator.isValid((Object)link2.getWfStatus())) {
                    if (link2.getWfStatus().getCategory().equals("Done")) {
                        link2.setIsManuallyResolved(Boolean.valueOf(true));
                        link2.setResolvedOn(new Date());
                    } else {
                        link2.setResolvedOn(null);
                    }
                }
                linksBeingCreated.add(link2);
                if (!Boolean.TRUE.equals(link2.getSyncTfs())) continue;
                linksToBeCreatedInTFS.add(link2);
                continue;
            }
            if (linkIdsBeingUpdated == null) continue;
            linkIdsBeingUpdated.forEach(id -> {
                if (id.equals(link2.getId())) {
                    linksBeingUpdated.add(link2);
                    return;
                }
            });
        }
        linksBeingUpdated.forEach(link -> {
            ItemLink savedLink = (ItemLink)this.itemLinkRepository.findOne((Serializable)((Object)link.getId()));
            String st1 = "";
            String st2 = "";
            if (PropertyValidator.isValid((Object)savedLink.getWfStatus()) && PropertyValidator.isValid((Object)link.getWfStatus())) {
                st1 = savedLink.getWfStatus().getId();
                st2 = link.getWfStatus().getId();
            } else {
                st1 = link.getWfStatus().getCategory();
                st2 = savedLink.getStatus().equals("Resolved") ? "Done" : "ToDo";
            }
            HashMap emailTemp = new HashMap();
            if (!st1.equals(st2)) {
                if (link.getWfStatus().getCategory().equals("Done")) {
                    link.setIsManuallyResolved(Boolean.valueOf(true));
                    link.setResolvedOn(new Date());
                } else {
                    link.setResolvedOn(null);
                }
            }
            link.setWatcherList(savedLink.getWatcherList());
        });
        Session session = null;
        if (PropertyValidator.isValid(linksBeingCreated) && PropertyValidator.isValid((Object)(session = (sessionBoard = this.sessionBoardRepository.findById(((ItemLink)linksBeingCreated.get(0)).getSessionBoardId())).getSession()).getDependencyPrefix())) {
            for (ItemLink link3 : linksBeingCreated) {
                link3.setCustomId(Integer.valueOf(this.customRepository.getNextSeq(session.getId(), null, null)).intValue());
            }
        }
        Item savedItem = (Item)this.itemRepository.findOne((Serializable)((Object)item.getId()));
        List itemLinks = this.itemLinkRepository.save((Iterable)item.getItemLinks());
        if (!PropertyValidator.isValid((Collection)savedItem.getItemLinks())) {
            savedItem.setItemLinks(new ArrayList());
        }
        savedItem.setItemLinks(itemLinks);
        savedItem.setMetaMap(metaMap);
        savedItem.putLastUpdatedValue(Item.Actions.itemLinks.name(), (Object)itemLinks);
        this.itemRepository.save((Object)savedItem);
        if (PropertyValidator.isValid((Object)((SessionBoard)savedItem.getSessionBoards().get(0)).getSession().getTfsAlmConfigurations())) {
            AlmAccount almAccount = ((SessionBoard)savedItem.getSessionBoards().get(0)).getSession().getTfsAlmConfigurations().getAlmAccount();
            new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        }
        return itemLinks;
    }

    public ArrayList<HashMap<String, Object>> dataJsonForEmail(ItemLink link, ItemLink savedLink, HashMap<String, Object> requestMap) {
        ArrayList<HashMap<String, Object>> emailsnusername = new ArrayList<HashMap<String, Object>>();
        HashMap<String, Object> dataJson = new HashMap<String, Object>();
        String sourceItemTitle = (String)requestMap.get("sItem");
        String sourceTeamTitle = (String)requestMap.get("sTeam");
        String sourceSprintTitle = (String)requestMap.get("sSprint");
        String sKey = (String)requestMap.get("sKey");
        List targetSprintTitle = (List)requestMap.get("tSprint");
        List targetTeamTitle = (List)requestMap.get("tTeam");
        List targetItemTitle = (List)requestMap.get("tItem");
        List tKey = (List)requestMap.get("tKey");
        String boardTitle = (String)requestMap.get("board");
        String summary = (String)requestMap.get("summary");
        String linkType = (String)requestMap.get("linkType");
        if (PropertyValidator.isValid((Object)link.getReporter())) {
            String string = (String)requestMap.get(link.getReporter().getFullName());
        }
        String dueDate = requestMap.get("dueDate") != null ? requestMap.get("dueDate").toString() : null;
        int index = 0;
        if (link.getResponsible() != null) {
            dataJson.put("email", link.getResponsible().getEmail());
            dataJson.put("firstName", link.getResponsible().getFirstName());
            dataJson.put("sourceItem", sourceItemTitle);
            dataJson.put("targetItem", targetItemTitle.get(index));
            dataJson.put("earlierstatus", savedLink.getWfStatus() != null ? savedLink.getWfStatus().getTitle() : savedLink.getStatus());
            dataJson.put("newstatus", link.getWfStatus().getTitle());
            dataJson.put("createdOn", link.getCreatedOn());
            dataJson.put("board", boardTitle);
            dataJson.put("oldResponsible", savedLink.getResponsible() != null ? savedLink.getResponsible().getFullName() : null);
            dataJson.put("newResponsible", link.getResponsible() != null ? link.getResponsible().getFullName() : null);
            dataJson.put("sourceSprintTitle", sourceSprintTitle);
            dataJson.put("targetSprintTitle", targetSprintTitle.get(index));
            dataJson.put("sourceTeamTitle", sourceTeamTitle);
            dataJson.put("targetTeamTitle", targetTeamTitle.get(index));
            dataJson.put("dueDate", dueDate);
            dataJson.put("summary", summary);
            dataJson.put("linkType", linkType);
            dataJson.put("reporter", "repoter");
            dataJson.put("sKey", sKey);
            dataJson.put("tKey", tKey.get(index));
            emailsnusername.add(dataJson);
            ++index;
        }
        for (Watcher wT : savedLink.getWatcherList()) {
            if (link.getResponsible() != null) {
                if (!link.getResponsible().getEmail().equalsIgnoreCase(wT.getUser().getEmail())) {
                    dataJson.put("email", wT.getUser().getEmail());
                    dataJson.put("firstName", wT.getUser().getEmail());
                }
            } else {
                dataJson.put("email", wT.getUser().getEmail());
                dataJson.put("firstName", wT.getUser().getEmail());
            }
            dataJson.put("sourceItem", sourceItemTitle);
            dataJson.put("targetItem", targetItemTitle.get(index));
            dataJson.put("earlierstatus", savedLink.getWfStatus() != null ? savedLink.getWfStatus() : savedLink.getStatus());
            dataJson.put("newstatus", link.getWfStatus());
            dataJson.put("createdOn", link.getCreatedOn());
            dataJson.put("board", boardTitle);
            dataJson.put("sourceSprintTitle", sourceSprintTitle);
            dataJson.put("targetSprintTitle", targetSprintTitle.get(index));
            dataJson.put("sourceTeamTitle", sourceTeamTitle);
            dataJson.put("targetTeamTitle", targetTeamTitle.get(index));
            dataJson.put("oldResponsible", savedLink.getResponsible().getFullName());
            dataJson.put("newResponsible", link.getResponsible().getFullName());
            dataJson.put("dueDate", dueDate);
            dataJson.put("summary", summary);
            dataJson.put("reporter", "repoter");
            dataJson.put("linkType", linkType);
            dataJson.put("sKey", sKey);
            dataJson.put("tKey", tKey.get(index));
            emailsnusername.add(dataJson);
            ++index;
        }
        return emailsnusername;
    }

    @RequestMapping(value={"/search/activities"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getActvities(HttpServletRequest request, @RequestBody String requestPayload) {
        Gson g = new Gson();
        5 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap reqbody = (HashMap)g.fromJson(requestPayload, T.getType());
        if (request.getParameter("page") != null) {
            reqbody.put("page", request.getParameter("page"));
        } else {
            reqbody.put("page", 0);
        }
        reqbody.put("activies", this.planService.getActivitiesByTeamAndSprint((String)reqbody.get("searchString"), (String)reqbody.get("boardId"), (String)reqbody.get("teamId"), (String)reqbody.get("sprintId"), (Boolean)reqbody.get("isWebhook"), request.getParameter("page")));
        return new ResponseEntity((Object)reqbody, HttpStatus.OK);
    }

    @RequestMapping(value={"/get-itemlink-history/{itemlinkId}/{zoneOffset}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getItemLinkHistory(@PathVariable(value="itemlinkId") String itemlinkId, @PathVariable String zoneOffset) {
        List historyList = this.getItemLinkHistoryList(itemlinkId, zoneOffset, Boolean.valueOf(false));
        return new ResponseEntity((Object)historyList, HttpStatus.OK);
    }

    public List<String> getItemLinkHistoryList(String itemlinkId, String zoneOffset, Boolean forEmail) {
        ArrayList<String> historyList = new ArrayList<String>();
        ObjectMapper mapper = new ObjectMapper();
        List itemList = this.itemLogRepository.findByItemIdAndItemTypeOrderByCreatedOnAsc(itemlinkId, "ItemLink");
        HashMap<String, Boolean> validFieldsMap = new HashMap<String, Boolean>();
        validFieldsMap.put("type", true);
        validFieldsMap.put("title", true);
        validFieldsMap.put("status", true);
        validFieldsMap.put("wfStatus", true);
        validFieldsMap.put("responsible", true);
        validFieldsMap.put("dueDate", true);
        validFieldsMap.put("raisedOn", true);
        validFieldsMap.put("reporter", true);
        validFieldsMap.put("description", true);
        HashMap<String, String> nameForFeilds = new HashMap<String, String>();
        nameForFeilds.put("type", "Type");
        nameForFeilds.put("title", "Title");
        nameForFeilds.put("status", "Status");
        nameForFeilds.put("wfStatus", "Statue");
        nameForFeilds.put("responsible", "Responsible");
        nameForFeilds.put("dueDate", "Target Resolution Date");
        nameForFeilds.put("raisedOn", "Raised On");
        nameForFeilds.put("reporter", "Reporter");
        nameForFeilds.put("description", "Description");
        HashMap previousValueMap = new HashMap();
        for (ItemLog item : itemList) {
            boolean anyActivity = false;
            String historyString = "";
            String jsonChanges = item.getChanges();
            if (jsonChanges == null || jsonChanges.equals("{}")) continue;
            Calendar cal = Calendar.getInstance();
            cal.setTime(item.getCreatedOn());
            cal.add(12, Integer.parseInt(zoneOffset));
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm a");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            String strDate = dateFormat.format(cal.getTime());
            String eventType = item.getEventType().substring(0, 1).toUpperCase() + item.getEventType().substring(1).toLowerCase();
            if (!forEmail.booleanValue()) {
                historyString = historyString + "<div class='nm-dt'> " + eventType + " by <span class='by'>" + StringUtils.capitalize((String)item.getActivityBy()) + "</span> on " + strDate + "</div>";
            }
            ArrayList<String> historyLogs = new ArrayList<String>();
            try {
                Map map = (Map)mapper.readValue(jsonChanges, Map.class);
                System.err.println(map);
                Iterator iterator = map.entrySet().iterator();
                boolean isFirstMapIter = true;
                ArrayList statusLogIndex = new ArrayList();
                while (iterator.hasNext()) {
                    Map.Entry pair = iterator.next();
                    if (validFieldsMap.get(pair.getKey()) == null) continue;
                    anyActivity = true;
                    String historyChange = " <div class='line prow '> ";
                    if (forEmail.booleanValue()) {
                        historyChange = historyChange + "&#8226;    ";
                    }
                    historyChange = historyChange + (String)nameForFeilds.get(pair.getKey());
                    if (pair.getKey().equals("status") || pair.getKey().equals("wfStatus") || pair.getKey().equals("responsible") || pair.getKey().equals("reporter")) {
                        String result = this.getLastHistory1(historyChange, pair, historyLogs, eventType, previousValueMap, statusLogIndex);
                        if (result == null) continue;
                        historyChange = result;
                    } else {
                        Date parsedDate;
                        SimpleDateFormat formatter;
                        String value = (String)pair.getValue();
                        if (pair.getKey().equals("dueDate")) {
                            formatter = new SimpleDateFormat("MMM d, yyyy H:mm:ss a");
                            parsedDate = null;
                            try {
                                parsedDate = formatter.parse(value);
                            }
                            catch (ParseException parseException) {
                                // empty catch block
                            }
                            formatter = new SimpleDateFormat("d MMM yyyy");
                            value = formatter.format(parsedDate);
                        } else if (pair.getKey().equals("raisedOn")) {
                            formatter = new SimpleDateFormat("MMM d, yyyy H:mm:ss a");
                            parsedDate = null;
                            try {
                                parsedDate = formatter.parse(value);
                            }
                            catch (ParseException parseException) {
                                // empty catch block
                            }
                            formatter = new SimpleDateFormat("d MMM yyyy");
                            value = formatter.format(parsedDate);
                        }
                        historyChange = historyChange + "<span class='b'> changed to \"" + value + "\"</span>";
                    }
                    historyChange = historyChange + " </div> ";
                    historyLogs.add(historyChange);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            for (String log : historyLogs) {
                historyString = historyString + log;
            }
            if (anyActivity) {
                historyList.add(historyString);
            }
            if (!forEmail.booleanValue()) continue;
            break;
        }
        return historyList;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private String getLastHistory1(String historyChange, Map.Entry pair, ArrayList<String> historyLogs, String eventType, HashMap<String, ArrayList<String>> previousValueMap, ArrayList<Integer> statusLogIndex) {
        String key = (String)pair.getKey();
        String value = "";
        if (key.equals("status")) {
            value = (String)pair.getValue();
        } else {
            Map objectMap = (Map)pair.getValue();
            value = this.getObjectTitle(key, objectMap);
        }
        String finalString = " changed ";
        if (eventType.equals("Created")) {
            void var10_12;
            finalString = finalString + "to \"" + value + "\"";
            ArrayList<String> arrayList = previousValueMap.get(key);
            if (arrayList == null) {
                ArrayList arrayList2 = new ArrayList();
                previousValueMap.put(key, arrayList2);
            }
            var10_12.add(value);
            if (!key.equals("status") && !key.equals("wfStatus")) {
                return historyChange + finalString;
            }
            if (statusLogIndex.size() == 0) {
                historyChange = historyChange + finalString;
                statusLogIndex.add(historyLogs.size());
                return historyChange;
            }
            if (!key.equals("wfStatus")) return historyChange;
            historyChange = historyChange + finalString;
            historyChange = historyChange + " </div> ";
            historyLogs.set(statusLogIndex.get(statusLogIndex.size()), historyChange);
            return null;
        }
        if (key.equals("wfStatus")) {
            void var10_15;
            ArrayList<String> arrayList = previousValueMap.get(key);
            if (arrayList == null) {
                ArrayList arrayList3 = new ArrayList();
                previousValueMap.put(key, arrayList3);
            }
            if (var10_15.size() > 0) {
                finalString = finalString + "from \"" + (String)var10_15.get(var10_15.size() - 1) + "\"";
                finalString = finalString + " to \"" + value + "\"";
            } else {
                ArrayList<String> previousValuesStatus = previousValueMap.get("status");
                if (previousValuesStatus.size() > 0) {
                    finalString = finalString + "from \"" + previousValuesStatus.get(previousValuesStatus.size() - 1) + "\"";
                    finalString = finalString + " to \"" + value + "\"";
                } else {
                    finalString = finalString + "to \"" + value + "\"";
                }
            }
            var10_15.add(value);
        } else {
            void var10_18;
            ArrayList<String> arrayList = previousValueMap.get(key);
            if (arrayList == null) {
                ArrayList arrayList4 = new ArrayList();
                previousValueMap.put(key, arrayList4);
            }
            if (var10_18.size() > 0) {
                finalString = finalString + "from \"" + (String)var10_18.get(var10_18.size() - 1) + "\"";
                finalString = finalString + " to \"" + value + "\"";
            } else {
                finalString = finalString + "to \"" + value + "\"";
            }
        }
        if (!key.equals("status") && !key.equals("wfStatus")) {
            return historyChange + finalString;
        }
        if (statusLogIndex.size() != 0) return null;
        historyChange = historyChange + finalString;
        statusLogIndex.add(historyLogs.size());
        return historyChange;
    }

    private String getLastHistory(Map.Entry mapPair, List<ItemLog> itemList, ItemLog item) {
        String oldId = "";
        String oldTitle = "";
        String history = " changed ";
        String lastStatus = "";
        String type = (String)mapPair.getKey();
        ObjectMapper mapper = new ObjectMapper();
        boolean startCheck = false;
        boolean breakLoop = false;
        for (ItemLog itemLog : itemList) {
            String jsonChanges;
            if (breakLoop) break;
            if (itemLog.getId().equals(item.getId())) {
                startCheck = true;
                continue;
            }
            if (!startCheck || (jsonChanges = itemLog.getChanges()) == null) continue;
            try {
                Map map = (Map)mapper.readValue(jsonChanges, Map.class);
                for (Map.Entry pair : map.entrySet()) {
                    if (!pair.getKey().equals(type)) continue;
                    if (type.equals("responsible") || type.equals("reporter")) {
                        Map map2 = (Map)pair.getValue();
                        history = history + "from \"" + this.getObjectTitle(type, map2) + "\"";
                    } else {
                        String value = (String)pair.getValue();
                        history = history + "from \"" + value + "\"";
                    }
                    breakLoop = true;
                }
            }
            catch (IOException e) {
                LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
            }
        }
        if (type.equals("responsible") || type.equals("reporter") || type.equals("wfStatus")) {
            Map map2 = (Map)mapPair.getValue();
            history = history + " to \"" + this.getObjectTitle(type, map2) + "\"";
        } else {
            String value = (String)mapPair.getValue();
            history = history + " to \"" + value + "\"";
        }
        return history;
    }

    private String getObjectTitle(String type, Map<Object, Object> map) {
        Status status;
        String id;
        User responsible;
        if ((type.equals("responsible") || type.equals("reporter")) && (responsible = (User)this.userRepository.findOne((Serializable)((Object)(id = (String)map.get("id"))))) != null) {
            return responsible.getFullName();
        }
        if (type.equals("wfStatus") && (status = (Status)this.statusRepository.findOne((Serializable)((Object)(id = (String)map.get("id"))))) != null) {
            return status.getTitle();
        }
        return null;
    }

    @RequestMapping(value={"/team/add"})
    public ResponseEntity<Object> addTeam(@RequestBody HashMap<String, Object> payload) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        responseJson.put("success", false);
        String teamStr = (String)payload.get("team");
        String metaMap = (String)payload.get("metaMap");
        String sessionBoardId = (String)payload.get("sessionBoardId");
        try {
            ObjectMapper mapper = new ObjectMapper();
            Team team = (Team)mapper.readValue(teamStr, Team.class);
            Team savedTeam = null;
            if (PropertyValidator.isValid((Object)team.getId())) {
                savedTeam = (Team)this.teamRepository.findOne((Serializable)((Object)team.getId()));
                responseJson.put("newTeam", false);
            } else {
                savedTeam = (Team)this.teamRepository.save((Object)team);
                responseJson.put("newTeam", true);
            }
            if (PropertyValidator.isValid((Object)sessionBoardId)) {
                SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardId));
                ArrayList<Team> teams = sessionBoard.getTeams();
                if (!PropertyValidator.isValid((Collection)teams)) {
                    teams = new ArrayList<Team>();
                }
                for (Team t : sessionBoard.getTeams()) {
                    if (!t.getId().equals(savedTeam.getId())) continue;
                    responseJson.put("success", false);
                    responseJson.put("reason", "AlreadyExist");
                    return new ResponseEntity(responseJson, HttpStatus.OK);
                }
                teams.add(savedTeam);
                sessionBoard.setTeams(teams);
                if (PropertyValidator.isValid((String[])sessionBoard.getTeamSequence())) {
                    sessionBoard.setTeamSequence((String[])ArrayUtils.add((Object[])sessionBoard.getTeamSequence(), (int)sessionBoard.getTeamSequence().length, (Object)savedTeam.getId()));
                } else {
                    String[] teamSequence = new String[]{savedTeam.getId()};
                    sessionBoard.setTeamSequence(teamSequence);
                }
                ArrayList<TeamSprintDependencyLimit> dependencyLimit = new ArrayList<TeamSprintDependencyLimit>();
                TeamSprintDependencyLimit oldDependencyLimit = this.TeamSprintDependencyLimitRepository.findOneBySessionId(sessionBoard.getSession().getId());
                for (Container container : sessionBoard.getContainers()) {
                    TeamSprintDependencyLimit teamSprintLimit = new TeamSprintDependencyLimit();
                    teamSprintLimit.setSprintId(container.getId());
                    teamSprintLimit.setSessionId(sessionBoard.getSession().getId());
                    teamSprintLimit.setTeamId(savedTeam.getId());
                    if (oldDependencyLimit != null) {
                        teamSprintLimit.setLimit(oldDependencyLimit.getLimit());
                    }
                    dependencyLimit.add(teamSprintLimit);
                }
                this.TeamSprintDependencyLimitRepository.save(dependencyLimit);
                this.sessionBoardRepository.save((Object)sessionBoard);
                responseJson.put("teamSequence", sessionBoard.getTeamSequence());
            }
            if (PropertyValidator.isValid((Object)savedTeam)) {
                responseJson.put("success", true);
                responseJson.put("data", savedTeam);
                JSONObject pushJson = new JSONObject();
                try {
                    pushJson.put("isTFS", true);
                    pushJson.put("metaMap", (Object)metaMap);
                    PushSender.sendMsg((String)pushJson.toString());
                }
                catch (JSONException e) {
                    LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/livestream"})
    public ResponseEntity<Object> liveStream(@RequestBody String payload) {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        PushSender.sendMsg((String)payload);
        responseJson.put("success", true);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/team/save"})
    public ResponseEntity<Object> saveTeam(@RequestBody HashMap<String, Object> payload) {
        HashMap<String, Boolean> responseJson;
        block11: {
            responseJson = new HashMap<String, Boolean>();
            responseJson.put("success", false);
            String teamStr = (String)payload.get("team");
            String metaMap = (String)payload.get("metaMap");
            try {
                ObjectMapper mapper = new ObjectMapper();
                Team team = (Team)mapper.readValue(teamStr, Team.class);
                Team savedTeam = null;
                if (PropertyValidator.isValid((Object)team) && PropertyValidator.isValid((Object)team.getId())) {
                    savedTeam = (Team)this.teamRepository.findOne((Serializable)((Object)team.getId()));
                    if (PropertyValidator.isValid((Object)team.getTitle())) {
                        savedTeam.setTitle(team.getTitle());
                    }
                    if (PropertyValidator.isValid((Object)team.getLabel())) {
                        savedTeam.setLabel(team.getLabel());
                    }
                    if (PropertyValidator.isValid((Object)team.getColor())) {
                        savedTeam.setColor(team.getColor());
                    }
                    if (PropertyValidator.isValid((Object)team.getSequence())) {
                        savedTeam.setSequence(team.getSequence());
                    }
                    savedTeam = (Team)this.teamRepository.save((Object)savedTeam);
                    List riskLinkToBeUpdated = this.riskRepository.findAll();
                    for (Risk risk : riskLinkToBeUpdated) {
                        boolean found = false;
                        List boardTeams = risk.getBoardTeams();
                        if (boardTeams == null) continue;
                        for (BoardTeam bT : boardTeams) {
                            if (!bT.getTeamId().equalsIgnoreCase(team.getId())) continue;
                            found = true;
                            bT.setTeamTitle(team.getTitle());
                        }
                        if (!found) continue;
                        this.riskRepository.save((Object)risk);
                    }
                }
                if (!PropertyValidator.isValid(savedTeam)) break block11;
                JSONObject pushJson = new JSONObject();
                try {
                    pushJson.put("isTFS", true);
                    pushJson.put("metaMap", (Object)metaMap);
                    PushSender.sendMsg((String)pushJson.toString());
                }
                catch (JSONException e) {
                    LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
                }
                responseJson.put("success", true);
                responseJson.put("data", (Boolean)savedTeam);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/team/delete"})
    public ResponseEntity<Object> deleteTeam(@RequestBody HashMap<String, Object> payload) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        responseJson.put("success", false);
        String metaMap = (String)payload.get("metaMap");
        String teamId = (String)payload.get("teamId");
        String sessionBoardId = (String)payload.get("sessionBoardId");
        if (PropertyValidator.isValid((Object)sessionBoardId)) {
            List teamMappings;
            SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardId));
            TFSAlmConfigurations configurations = null;
            if (PropertyValidator.isValid((Object)sessionBoard.getSession().getTfsAlmConfigurations()) && PropertyValidator.isValid((Collection)(teamMappings = (configurations = sessionBoard.getSession().getTfsAlmConfigurations()).getTeamMappings()))) {
                int teamMappingsLength = teamMappings.size();
                for (int i = 0; i < teamMappingsLength; ++i) {
                    if (!((TFSTeamMapping)teamMappings.get(i)).getKendisTeamId().equals(teamId)) continue;
                    teamMappings.remove(i);
                    break;
                }
                if (teamMappings.size() == 0) {
                    configurations.setTeamMappings(null);
                } else {
                    configurations.setTeamMappings(teamMappings);
                }
            }
            this.TeamSprintDependencyLimitRepository.deleteBySessionIdAndTeamId(sessionBoard.getSession().getId(), teamId);
            List teamContainersToBeDeleted = this.teamContainerRepository.findByTeamAndContainerIn(new Team(teamId), sessionBoard.getContainers());
            if (PropertyValidator.isValid((Collection)teamContainersToBeDeleted)) {
                List items = this.itemRepository.findByTeamContainersIn(teamContainersToBeDeleted);
                if (PropertyValidator.isValid((Collection)items)) {
                    for (Item item : items) {
                        ArrayList<TeamContainer> deletedTCs = new ArrayList<TeamContainer>();
                        for (TeamContainer tc : item.getTeamContainers()) {
                            TeamContainer deletedTC = teamContainersToBeDeleted.stream().filter(lt -> lt.getId().equals(tc.getId())).findAny().orElse(null);
                            if (!PropertyValidator.isValid((Object)deletedTC)) continue;
                            deletedTCs.add(deletedTC);
                        }
                        item.getTeamContainers().removeAll(deletedTCs);
                    }
                    this.itemRepository.save((Iterable)items);
                }
                this.teamContainerRepository.delete((Iterable)teamContainersToBeDeleted);
                ArrayList teamContainerIds = new ArrayList();
                teamContainersToBeDeleted.forEach(teamContainer -> teamContainerIds.add(teamContainer.getId()));
                List itemLinks = this.itemLinkRepository.findBySourceTeamContainerIdInOrTargetTeamContainerIdIn(teamContainerIds, teamContainerIds);
                if (PropertyValidator.isValid((Collection)itemLinks)) {
                    items = this.itemRepository.findByItemLinksIn(itemLinks);
                    if (PropertyValidator.isValid((Collection)items)) {
                        for (int i = 0; i < items.size(); ++i) {
                            List savedItemLinks;
                            List deletedItemLinks = savedItemLinks = ((Item)items.get(i)).getItemLinks();
                            for (int j = 0; j < savedItemLinks.size(); ++j) {
                                int tcIndex = j;
                                ItemLink it = itemLinks.stream().filter(lt -> lt.getId().equals(((ItemLink)savedItemLinks.get(tcIndex)).getId())).findAny().orElse(null);
                                if (!PropertyValidator.isValid((Object)it)) continue;
                                deletedItemLinks.remove(j);
                            }
                            ((Item)items.get(i)).setItemLinks(deletedItemLinks);
                        }
                        this.itemRepository.save((Iterable)items);
                    }
                    KendisUtils.archiveItemLinks((ItemLinkRepository)this.itemLinkRepository, (List)itemLinks);
                }
            }
            this.itemSyncMapperRepository.deleteBySessionBoardAndTeam(sessionBoard, new Team(teamId));
            sessionBoard.getTeams().remove(new Team(teamId));
            if (PropertyValidator.isValid((String[])sessionBoard.getTeamSequence()) && ArrayUtils.indexOf((Object[])sessionBoard.getTeamSequence(), (Object)teamId) > -1) {
                sessionBoard.setTeamSequence((String[])ArrayUtils.remove((Object[])sessionBoard.getTeamSequence(), (int)ArrayUtils.indexOf((Object[])sessionBoard.getTeamSequence(), (Object)teamId)));
            }
            this.tfsAlmConfigurationsRepository.save((Object)configurations);
            List riskLinkToBeDeleted = this.riskRepository.findAll();
            for (Risk risk : riskLinkToBeDeleted) {
                boolean found = false;
                List boardTeams = risk.getBoardTeams();
                if (boardTeams == null) continue;
                Iterator itr = boardTeams.iterator();
                while (itr.hasNext()) {
                    BoardTeam bT = (BoardTeam)itr.next();
                    if (!bT.getSessionId().equalsIgnoreCase(sessionBoard.getSession().getId()) || !bT.getTeamId().equalsIgnoreCase(teamId)) continue;
                    itr.remove();
                    found = true;
                }
                if (!found) continue;
                this.riskRepository.save((Object)risk);
            }
            this.sessionBoardRepository.save((Object)sessionBoard);
            responseJson.put("teamSequence", sessionBoard.getTeamSequence());
            this.piJourneyBoardService.updateTeamBreakoutOnTeamRemove(sessionBoard.getSession().getId(), teamId);
        }
        responseJson.put("teamId", teamId);
        responseJson.put("success", true);
        JSONObject pushJson = new JSONObject();
        try {
            pushJson.put("isTFS", true);
            pushJson.put("metaMap", (Object)metaMap);
            PushSender.sendMsg((String)pushJson.toString());
        }
        catch (JSONException e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/ipsprint/{boardId}/{sprintId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> markIPSprint(@PathVariable(value="boardId") String boardId, @PathVariable(value="sprintId") String sprintId) {
        HashMap responseJson = new HashMap();
        if (PropertyValidator.isValid((Object)boardId)) {
            Container container2;
            SessionBoard board = this.customRepository.getSessionBoardbyId(boardId);
            board.getContainers().forEach(container -> container.setIsIPSprint(Boolean.valueOf(false)));
            this.containerRepository.save((Iterable)board.getContainers());
            if (PropertyValidator.isValid((Object)sprintId) && !sprintId.equals("undefined") && PropertyValidator.isValid((Object)(container2 = (Container)board.getContainers().stream().filter(sprint -> sprint.getId().equals(sprintId)).findAny().orElse(null)))) {
                container2.setIsIPSprint(Boolean.valueOf(true));
                this.containerRepository.save((Object)container2);
            }
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/container/save"})
    public ResponseEntity<Object> saveContainer(@RequestBody HashMap<String, Object> payload) {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        responseJson.put("success", false);
        String containerStr = (String)payload.get("container");
        String metaMap = (String)payload.get("metaMap");
        String sessionBoardId = (String)payload.get("sessionBoardId");
        try {
            if (PropertyValidator.isValid(payload)) {
                ObjectMapper mapper = new ObjectMapper();
                Container container = (Container)mapper.readValue(containerStr, Container.class);
                Container savedContainer = null;
                if (PropertyValidator.isValid((Object)container.getId())) {
                    savedContainer = (Container)this.containerRepository.findOne((Serializable)((Object)container.getId()));
                    if (PropertyValidator.isValid((Object)container.getTitle())) {
                        savedContainer.setTitle(container.getTitle());
                    }
                    if (PropertyValidator.isValid((Object)container.getLabel())) {
                        savedContainer.setLabel(container.getLabel());
                    }
                    if (PropertyValidator.isValid((Object)container.getSequence())) {
                        savedContainer.setSequence(container.getSequence());
                    }
                    savedContainer.setStartDate(container.getStartDate());
                    savedContainer.setEndDate(container.getEndDate());
                    savedContainer = (Container)this.containerRepository.save((Object)savedContainer);
                    List riskLinkToBeUpdated = this.riskRepository.findAll();
                    SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardId));
                    for (Risk risk : riskLinkToBeUpdated) {
                        boolean found = false;
                        List boardSprint = risk.getBoardSprints();
                        if (boardSprint == null) continue;
                        for (BoardSprints bS : boardSprint) {
                            if (!bS.getSessionId().equalsIgnoreCase(sessionBoard.getSession().getId()) || !bS.getSprintId().equalsIgnoreCase(container.getId())) continue;
                            bS.setSprintTitle(container.getTitle());
                            found = true;
                        }
                        if (!found) continue;
                        this.riskRepository.save((Object)risk);
                    }
                } else {
                    savedContainer = (Container)this.containerRepository.save((Object)container);
                    if (PropertyValidator.isValid((Object)sessionBoardId)) {
                        SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardId));
                        ArrayList<Container> containers = sessionBoard.getContainers();
                        if (!PropertyValidator.isValid((Collection)containers)) {
                            containers = new ArrayList<Container>();
                        }
                        containers.add(savedContainer);
                        sessionBoard.setContainers(containers);
                        this.sessionBoardRepository.save((Object)sessionBoard);
                        Session session = sessionBoard.getSession();
                        ArrayList<TeamSprintDependencyLimit> dependencyLimit = new ArrayList<TeamSprintDependencyLimit>();
                        TeamSprintDependencyLimit oldDependencyLimit = this.TeamSprintDependencyLimitRepository.findOneBySessionId(sessionBoard.getSession().getId());
                        for (Team team : sessionBoard.getTeams()) {
                            TeamSprintDependencyLimit teamSprintLimit = new TeamSprintDependencyLimit();
                            teamSprintLimit.setSprintId(savedContainer.getId());
                            teamSprintLimit.setSessionId(sessionBoard.getSession().getId());
                            teamSprintLimit.setTeamId(team.getId());
                            if (oldDependencyLimit != null) {
                                teamSprintLimit.setLimit(oldDependencyLimit.getLimit());
                            }
                            dependencyLimit.add(teamSprintLimit);
                        }
                        this.TeamSprintDependencyLimitRepository.save(dependencyLimit);
                        TFSAlmConfigurations almConfiguration = session.getTfsAlmConfigurations();
                        ArrayList<ItemSyncMapper> itemSyncMappers = new ArrayList<ItemSyncMapper>();
                        if (PropertyValidator.isValid((Object)almConfiguration) && PropertyValidator.isValid((Collection)almConfiguration.getTeamMappings())) {
                            for (TFSTeamMapping teamMap : almConfiguration.getTeamMappings()) {
                                ItemSyncMapper itemSyncMapper = new ItemSyncMapper();
                                itemSyncMapper.setCreateNewInJira(Boolean.valueOf(true));
                                SessionBoard sb = new SessionBoard();
                                sb.setId(sessionBoard.getId());
                                itemSyncMapper.setSessionBoard(sb);
                                Container cont = new Container();
                                Team team = new Team();
                                team.setId(teamMap.getKendisTeamId());
                                cont.setId(savedContainer.getId());
                                itemSyncMapper.setContainer(cont);
                                itemSyncMapper.setTeam(team);
                                itemSyncMapper.setTfsProjectId(teamMap.getTfsProjectTfsId());
                                itemSyncMappers.add(itemSyncMapper);
                            }
                        }
                        if (PropertyValidator.isValid(itemSyncMappers)) {
                            this.itemSyncMapperRepository.save(itemSyncMappers);
                        }
                        this.piJourneyBoardService.updateTeamCapacityOnAddSprint(sessionBoard, savedContainer);
                    }
                    responseJson.put("newContainer", true);
                }
                if (PropertyValidator.isValid((Object)savedContainer)) {
                    responseJson.put("success", true);
                    responseJson.put("data", (Boolean)savedContainer);
                    JSONObject pushJson = new JSONObject();
                    try {
                        pushJson.put("isTFS", true);
                        pushJson.put("metaMap", (Object)metaMap);
                        PushSender.sendMsg((String)pushJson.toString());
                    }
                    catch (JSONException e) {
                        LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/container/delete"})
    public ResponseEntity<Object> deleteContainer(@RequestBody HashMap<String, Object> payload) {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        responseJson.put("success", false);
        try {
            if (PropertyValidator.isValid(payload)) {
                SessionBoard sessionBoard;
                List containers;
                String containerStr = (String)payload.get("container");
                String metaMap = (String)payload.get("metaMap");
                String sessionBoardId = (String)payload.get("sessionBoardId");
                ObjectMapper mapper = new ObjectMapper();
                Container container = (Container)mapper.readValue(containerStr, Container.class);
                if (PropertyValidator.isValid((Object)container.getId()) && PropertyValidator.isValid((Object)sessionBoardId) && PropertyValidator.isValid((Collection)(containers = (sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardId))).getContainers()))) {
                    for (int i = 0; i < containers.size(); ++i) {
                        if (!((Container)containers.get(i)).getId().equals(container.getId())) continue;
                        containers.remove(i);
                    }
                    sessionBoard.setContainers(containers);
                    this.sessionBoardRepository.save((Object)sessionBoard);
                    List riskLinkToBeDeleted = this.riskRepository.findAll();
                    for (Risk risk : riskLinkToBeDeleted) {
                        boolean found = false;
                        List boardSprint = risk.getBoardSprints();
                        if (boardSprint == null) continue;
                        Iterator itr = boardSprint.iterator();
                        while (itr.hasNext()) {
                            BoardSprints bT = (BoardSprints)itr.next();
                            if (!bT.getSessionId().equalsIgnoreCase(sessionBoard.getSession().getId()) || !bT.getSprintId().equalsIgnoreCase(container.getId())) continue;
                            itr.remove();
                            found = true;
                        }
                        if (!found) continue;
                        this.riskRepository.save((Object)risk);
                    }
                    List teamContainers = this.teamContainerRepository.findByContainer_Id(container.getId());
                    if (PropertyValidator.isValid((Collection)teamContainers)) {
                        List items = this.itemRepository.findByTeamContainersIn(teamContainers);
                        if (PropertyValidator.isValid((Collection)items)) {
                            for (int i = 0; i < items.size(); ++i) {
                                List itemTeamContainers;
                                List newItemTeamContainers = itemTeamContainers = ((Item)items.get(i)).getTeamContainers();
                                for (int j = 0; j < itemTeamContainers.size(); ++j) {
                                    int tcIndex = j;
                                    TeamContainer tc = teamContainers.stream().filter(lt -> lt.getId().equals(((TeamContainer)itemTeamContainers.get(tcIndex)).getId())).findAny().orElse(null);
                                    if (!PropertyValidator.isValid((Object)tc)) continue;
                                    newItemTeamContainers.remove(j);
                                }
                                ((Item)items.get(i)).setTeamContainers(newItemTeamContainers);
                            }
                            this.itemRepository.save((Iterable)items);
                        }
                        ArrayList teamContainerIds = new ArrayList();
                        teamContainers.forEach(teamContainer -> teamContainerIds.add(teamContainer.getId()));
                        List itemLinks = this.itemLinkRepository.findBySourceTeamContainerIdInOrTargetTeamContainerIdIn(teamContainerIds, teamContainerIds);
                        if (PropertyValidator.isValid((Collection)itemLinks)) {
                            items = this.itemRepository.findByItemLinksIn(itemLinks);
                            if (PropertyValidator.isValid((Collection)items)) {
                                for (int i = 0; i < items.size(); ++i) {
                                    List savedItemLinks;
                                    List deletedItemLinks = savedItemLinks = ((Item)items.get(i)).getItemLinks();
                                    for (int j = 0; j < savedItemLinks.size(); ++j) {
                                        int tcIndex = j;
                                        ItemLink it = itemLinks.stream().filter(lt -> lt.getId().equals(((ItemLink)savedItemLinks.get(tcIndex)).getId())).findAny().orElse(null);
                                        if (!PropertyValidator.isValid((Object)it)) continue;
                                        deletedItemLinks.remove(j);
                                    }
                                    ((Item)items.get(i)).setItemLinks(deletedItemLinks);
                                }
                                this.itemRepository.save((Iterable)items);
                            }
                            KendisUtils.archiveItemLinks((ItemLinkRepository)this.itemLinkRepository, (List)itemLinks);
                        }
                        this.teamContainerRepository.delete((Iterable)teamContainers);
                    }
                    this.containerRepository.delete((Serializable)((Object)container.getId()));
                    this.itemSyncMapperRepository.deleteBySessionBoardAndContainer(sessionBoard, container);
                    this.TeamSprintDependencyLimitRepository.deleteBySessionIdAndSprintId(sessionBoard.getSession().getId(), container.getId());
                    responseJson.put("success", true);
                    responseJson.put("data", (Boolean)container);
                    JSONObject pushJson = new JSONObject();
                    try {
                        pushJson.put("isTFS", true);
                        pushJson.put("metaMap", (Object)metaMap);
                        PushSender.sendMsg((String)pushJson.toString());
                    }
                    catch (JSONException e) {
                        LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/session/status"}, method={RequestMethod.POST})
    public void changeSessionStatus(@RequestBody SessionBoard sessionBoard) {
        SessionBoard board = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoard.getId()));
        board.setStatus(sessionBoard.getStatus());
        this.sessionBoardRepository.save((Object)board);
        JSONObject pushJson = new JSONObject();
        try {
            pushJson.put("type", (Object)"Board");
            pushJson.put("boardId", (Object)sessionBoard.getId());
            pushJson.put("status", (Object)sessionBoard.getStatus());
            pushJson.put("metaMap", (Object)sessionBoard.getMetaMap());
            PushSender.sendMsg((String)pushJson.toString());
        }
        catch (JSONException e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
        }
    }

    @RequestMapping(value={"/save/velocity"})
    @ResponseBody
    public ResponseEntity<Object> saveVelocity(@RequestBody TeamSprintVelocity teamSprintVelocity) {
        teamSprintVelocity.setManualUpdate(Boolean.valueOf(true));
        TeamSprintVelocity tsv = (TeamSprintVelocity)this.teamSprintVelocityRepository.save((Object)teamSprintVelocity);
        JSONObject pushJson = new JSONObject();
        try {
            pushJson.put("type", (Object)"Board");
            pushJson.put("teamSprintVelocityId", (Object)tsv.getId());
            pushJson.put("metaMap", (Object)teamSprintVelocity.getMetaMap());
            PushSender.sendMsg((String)pushJson.toString());
        }
        catch (JSONException e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
        }
        return new ResponseEntity((Object)tsv, HttpStatus.OK);
    }

    @RequestMapping(value={"/get-conversations/{parentId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getConversationByItemLink(@PathVariable String parentId) {
        ItemLink itemLink = (ItemLink)this.itemLinkRepository.findOne((Serializable)((Object)parentId));
        if (PropertyValidator.isValid((Collection)itemLink.getConversations())) {
            ArrayList ids = new ArrayList();
            itemLink.getConversations().forEach(con -> ids.add(con.getId()));
            List conversations = this.conversationRepository.findAllByIdIn(ids);
            return new ResponseEntity((Object)conversations, HttpStatus.OK);
        }
        ArrayList conversations = new ArrayList();
        return new ResponseEntity(conversations, HttpStatus.OK);
    }

    @RequestMapping(value={"/save-conversations/{parentId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveConversationByItemLink(@PathVariable String parentId, @RequestBody List<Conversation> conversations) {
        ItemLink itemLink = (ItemLink)this.itemLinkRepository.findOne((Serializable)((Object)parentId));
        if (PropertyValidator.isValid(conversations)) {
            for (Conversation conv : conversations) {
                if (PropertyValidator.isValid((Object)conv.getId())) continue;
                Pattern p = Pattern.compile("\\[-(.*?)\\]");
                Matcher m = p.matcher(conv.getText());
                while (m.find()) {
                    ArrayList<String> emails = new ArrayList<String>();
                    emails.add(m.group(1));
                }
            }
        }
        conversations = this.conversationRepository.save(conversations);
        itemLink.setConversations(conversations);
        this.itemLinkRepository.save((Object)itemLink);
        itemLink.setConversations(conversations);
        conversations.forEach(con -> con.getUser());
        return new ResponseEntity((Object)itemLink, HttpStatus.OK);
    }

    public String formatedEmailText(String summary, String sTeam, String sSprint, String sTitle, String tTitle, String tSprint, String tTeam, String LinkType, String newStatus, String Reporter, String dueDate, String boardName, String userType, String prevStatus, String oldResponsible, String newResponsible, String sKey, String tKey) {
        sKey = sKey != null ? sKey : "";
        tKey = tKey != null ? tKey : "";
        String template = "<ul>";
        template = template + (summary != null ? "<li>Summary:" + summary + "</li>" : "");
        template = template + "<li>Creator:" + sTeam + "," + sSprint + "," + sKey + " " + sTitle + "</li>";
        template = template + "<li>Reciever :" + tTeam + "," + tSprint + "," + tKey + " " + tTitle + "</li>";
        template = template + "<li>Link Type : " + LinkType + "</li>";
        template = template + (prevStatus != null ? "<li>Status :" + prevStatus + " To " + newStatus + "</li>" : "<li>Status :" + newStatus + "</li>");
        template = template + (Reporter != null && userType.equals("Responsible") ? "<li>Responsible : " + Reporter + "</li>" : (userType.equals("Reporter") ? "<li> Reporter: " + UserContextUtil.getUserContext().getLoggedInUser().getFullName() + "</li>" : ""));
        template = template + (oldResponsible != null && newResponsible != null ? "<li>Responsible :" + oldResponsible + " To " + newResponsible + "</li>" : "");
        template = template + (dueDate != null ? "<li>Target Resoulation Date :" + dueDate + "</li>" : "");
        template = template + "<li>Board Name :" + boardName + "</li>";
        template = template + "</ul>";
        return template;
    }

    public String emailText(String action, HashMap<String, Object> mailParam, String UserType2) {
        String firstName = (String)mailParam.get("firstName");
        String sourceItem = (String)mailParam.get("sourceItem");
        String targetItem = (String)mailParam.get("targetItem");
        String board = (String)mailParam.get("board");
        String sourceSprintTitle = (String)mailParam.get("sourceSprintTitle");
        String targetSprintTitle = (String)mailParam.get("targetSprintTitle");
        String sourceTeamTitle = (String)mailParam.get("sourceTeamTitle");
        String targetTeamTitle = (String)mailParam.get("targetTeamTitle");
        String newStatus = (String)mailParam.get("newstatus");
        String earlierStatus = (String)mailParam.get("earlierstatus");
        String summary = (String)mailParam.get("summary");
        String linkType = (String)mailParam.get("linkType");
        String dueDate = mailParam.get("dueDate") != null ? mailParam.get("dueDate").toString() : null;
        String reporter = (String)mailParam.get("repoter");
        String oldResponsible = (String)mailParam.get("oldResponsible");
        String newResponsible = (String)mailParam.get("newResponsible");
        String sKey = (String)mailParam.get("sKey");
        String tKey = (String)mailParam.get("tKey");
        String text = "";
        String template = "";
        if (action.equals("created")) {
            template = "Hi " + firstName + ",<br/> A new dependency has been reported with the following details, on. <br/>";
            text = this.formatedEmailText(summary, sourceTeamTitle, sourceSprintTitle, sourceItem, targetItem, targetSprintTitle, targetTeamTitle, linkType, newStatus, reporter, dueDate, board, UserType2, null, null, null, sKey, tKey);
        } else if (action.equals("statuschange")) {
            template = "Hi " + firstName + "<br/> The status of the following dependency has been changed";
            text = this.formatedEmailText(summary, sourceTeamTitle, sourceSprintTitle, sourceItem, targetItem, targetSprintTitle, targetTeamTitle, linkType, newStatus, reporter, dueDate, board, "Reporter", earlierStatus, null, null, sKey, tKey);
        } else if (action.equals("removedependency")) {
            template = "Hi " + firstName + "<br/> The dependency has been deleted by your Kendis board user" + UserContextUtil.getUserContext().getLoggedInUser().getFullName();
            text = this.formatedEmailText(summary, sourceTeamTitle, sourceSprintTitle, sourceItem, targetItem, targetSprintTitle, targetTeamTitle, linkType, newStatus, reporter, dueDate, board, UserType2, null, null, null, sKey, tKey);
        } else if (action.equals("changeresponsible")) {
            template = "Hi " + firstName + "<br/> You\u2019ve been set responsible for the following dependency by the user" + UserContextUtil.getUserContext().getLoggedInUser().getFullName();
            text = this.formatedEmailText(summary, sourceTeamTitle, sourceSprintTitle, sourceItem, targetItem, targetSprintTitle, targetTeamTitle, linkType, newStatus, reporter, dueDate, board, UserType2, null, oldResponsible, newResponsible, sKey, tKey);
        }
        template = template + text;
        template = template + "<br/>Sincerely,<br/>Kendis Support";
        return template;
    }

    private void sendItemLinkNotificationEmail(ItemLink itemLink, String action, ArrayList<String> emails) {
        if (emails == null) {
            emails = new ArrayList();
            SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            User contextUser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
            emails.add(contextUser.getEmail());
        }
        HashMap mailParam = new HashMap();
        String mailTitle = "";
        String mailTemplate = "item_link_template";
        if (action.equals("created")) {
            mailTitle = "Depedency created";
            mailTemplate = "item_link_created_template";
        } else if (action.equals("status")) {
            mailTitle = "Depedency status changed";
        } else if (action.equals("responsible")) {
            mailTitle = "Depedency owner changed";
        } else if (action.equals("comment")) {
            mailTitle = "New comment added to Depedency";
        } else if (action.equals("tag")) {
            mailTitle = "You are tagged in comment on Depedency";
        } else if (action.equals("resolved")) {
            mailTitle = "Dependency resolved";
        }
        for (String email : emails) {
            this.mailSender.sendMail(email, mailTitle, mailTemplate, mailParam, true);
        }
    }

    private String tfsToKendisStatusCategory(String tfs) {
        if (tfs.equals("Proposed")) {
            return "ToDo";
        }
        if (tfs.equals("In Progress") || tfs.equals("InProgress")) {
            return "InProgress";
        }
        if (tfs.equals("Resolved")) {
            return "Done";
        }
        if (tfs.equals("Completed")) {
            return "Done";
        }
        return "Misc";
    }

    private static /* synthetic */ boolean lambda$changeState1$21(TeamSprintVelocity newTsv, Container x) {
        return newTsv.getSprintId().equals(x.getDuplicateOfId());
    }

    private static /* synthetic */ boolean lambda$changeState1$19(ItemSyncMapper itemSyncMapper, Container x) {
        return itemSyncMapper.getContainer().getId().equals(x.getDuplicateOfId());
    }

    static /* synthetic */ ItemRepository access$000(KendisBoardController x0) {
        return x0.itemRepository;
    }

    static /* synthetic */ TFSservice access$100(KendisBoardController x0) {
        return x0.tfSservice;
    }

    static /* synthetic */ Logger access$200() {
        return LOGGER;
    }
}

