/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.controller;

import com.google.gson.Gson;
import com.viztrend.safe.alm.jira.JiraUtils;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/jira"})
@RestController
public class JiraTestController {
    private static final Logger LOGGER = LoggerFactory.getLogger(JiraTestController.class);
    @Autowired
    private Environment ENV;

    @RequestMapping(value={"/post"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> postData(@RequestBody HashMap<String, Object> requestPayload) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        Gson g = new Gson();
        HashMap jiraCredentials = (HashMap)requestPayload.get("jiraCredentials");
        String baseURL = jiraCredentials.get("baseurl").toString();
        String jiraUsername = jiraCredentials.get("username").toString();
        String jiraPassword = jiraCredentials.get("password").toString();
        String requestURL = baseURL + "/" + requestPayload.get("url").toString();
        String payload = g.toJson(requestPayload.get("payload"));
        String response = JiraUtils.executeJiraPostRequest((String)requestURL, (String)jiraUsername, (String)jiraPassword, null, (String)payload, null, (Environment)this.ENV);
        responseJson.put("requestBody", requestPayload.get("payload"));
        responseJson.put("response", response);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/get"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getData(@RequestBody HashMap<String, Object> requestPayload) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        HashMap jiraCredentials = (HashMap)requestPayload.get("jiraCredentials");
        String baseURL = jiraCredentials.get("baseurl").toString();
        String jiraUsername = jiraCredentials.get("username").toString();
        String jiraPassword = jiraCredentials.get("password").toString();
        String requestURL = baseURL + "/" + requestPayload.get("url").toString();
        String response = JiraUtils.executeJiraGetRequest((String)requestURL, (String)jiraUsername, (String)jiraPassword, null, null, (Environment)this.ENV);
        responseJson.put("requestBody", requestPayload.get("payload"));
        responseJson.put("response", response);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> deleteData(@RequestBody HashMap<String, Object> requestPayload) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        HashMap jiraCredentials = (HashMap)requestPayload.get("jiraCredentials");
        String baseURL = jiraCredentials.get("baseurl").toString();
        String jiraUsername = jiraCredentials.get("username").toString();
        String jiraPassword = jiraCredentials.get("password").toString();
        String requestURL = baseURL + "/" + requestPayload.get("url").toString();
        String response = JiraUtils.executeJiraDeleteRequest((String)requestURL, (String)jiraUsername, (String)jiraPassword, null, null, (Environment)this.ENV);
        responseJson.put("requestBody", requestPayload.get("payload"));
        responseJson.put("response", response);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }
}

