/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.controller;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoCredential;
import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import com.viztrend.safe.Application;
import com.viztrend.safe.config.filter.SystemAuthenticaitonFilter;
import com.viztrend.safe.persistence.entity.AppInitConfig;
import com.viztrend.safe.persistence.repository.AppInitConfigRepository;
import com.viztrend.safe.persistence.repository.CustomRepository;
import com.viztrend.safe.persistence.repository.PushResponseRepository;
import com.viztrend.safe.utils.DateUtils;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.SSLUtil;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.SystemUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.net.ssl.SSLContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
@RequestMapping(value={"/system/monitor"})
@RestController
@ConditionalOnExpression(value="${isLocalDeployment:'true'}")
public class HealthController
implements ApplicationListener<ApplicationPreparedEvent> {
    static String health = "health";
    static String metrics = "metrics";
    @Autowired
    private MongoTemplate mongoTemplate;
    private SpringApplication application;
    @Autowired
    private Environment env;
    private ApplicationPreparedEvent event;
    private String[] args;
    private String dbConsoleOutput;
    @Autowired
    private ApplicationContext appContext;
    private ConfigurableApplicationContext context;
    private static Long debugTime;
    @Autowired
    private AppInitConfigRepository appInitConfigRepository;
    @Autowired
    private CustomRepository<Object> customRepository;
    @Autowired
    private SystemAuthenticaitonFilter systemAuthenticaitonFilter;
    @Autowired
    private PushResponseRepository pushResponseRepository;
    private static final org.slf4j.Logger LOGGER;

    @RequestMapping(value={"/health"})
    public Object monitor(HttpServletRequest request, HttpServletResponse response) throws Exception {
        RestTemplate restTemplate = new RestTemplate();
        Map kv = (Map)restTemplate.getForObject(this.getCmdUrl(request, health), Map.class, new Object[0]);
        return kv;
    }

    public void restartCmd() throws Exception {
        Thread restartThread = new Thread(() -> this.restart());
        restartThread.setDaemon(false);
        restartThread.start();
    }

    public void restart() {
        try {
            this.application.setEnvironment(this.context.getEnvironment());
            this.context.close();
            ClassUtils.overrideThreadContextClassLoader((ClassLoader)this.application.getClass().getClassLoader());
            this.application.setDefaultProperties(SystemUtil.getDefaultProperties());
            this.context = this.application.run(this.args);
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
    }

    @RequestMapping(value={"/logfiles"})
    public SortedMap logfiles(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.systemAuthenticaitonFilter.doFilter((ServletRequest)request, (ServletResponse)response);
        File logfile = new File(this.env.getProperty("logging.file"));
        File folder = new File(logfile.getParent());
        File[] listOfFiles = folder.listFiles();
        TreeMap<String, String> kv = new TreeMap<String, String>();
        String encodedFoderPath = URLEncoder.encode(folder.getAbsolutePath(), "UTF-8");
        for (File file : listOfFiles) {
            String encodedFileName = URLEncoder.encode(file.getName(), "UTF-8");
            kv.put(file.getName(), "/local/resource/" + encodedFileName);
        }
        return kv;
    }

    @RequestMapping(value={"/login"})
    public void login(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.systemAuthenticaitonFilter.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    @RequestMapping(value={"/backupfiles"})
    public SortedMap backupFilesCmd(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.systemAuthenticaitonFilter.doFilter((ServletRequest)request, (ServletResponse)response);
        return this.backupFiles();
    }

    public SortedMap backupFiles() throws Exception {
        File folder = new File(this.env.getProperty("backup.location"));
        Object[] listOfFiles = folder.listFiles();
        TreeMap kv = new TreeMap(Collections.reverseOrder());
        if (PropertyValidator.isValid((Object[])listOfFiles)) {
            Arrays.sort(listOfFiles, Comparator.comparingLong(File::lastModified));
            for (Object file : listOfFiles) {
                if (!((File)file).isFile() || ((File)file).getName().startsWith("upload_") || ((File)file).getName().equals("kendispass")) continue;
                HashMap<String, Object> fileObj = new HashMap<String, Object>();
                fileObj.put("length", ((File)file).length());
                fileObj.put("fileName", ((File)file).getAbsolutePath());
                kv.put(new java.sql.Date(((File)file).lastModified()), fileObj);
            }
        }
        return kv;
    }

    @RequestMapping(value={"/dump"})
    public void dumpCmd(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.systemAuthenticaitonFilter.doFilter((ServletRequest)request, (ServletResponse)response);
        this.dump();
    }

    @RequestMapping(value={"/dbconsoleoutput"})
    public String getDBOutput(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String s = this.dbConsoleOutput;
        this.dbConsoleOutput = "";
        return s;
    }

    @RequestMapping(value={"/startmongo"})
    public Map startMongo(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.systemAuthenticaitonFilter.doFilter((ServletRequest)request, (ServletResponse)response);
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            String s;
            StringBuffer sb = new StringBuffer();
            Process p = Runtime.getRuntime().exec(new String[]{"/opt/startdb.sh"});
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((s = br.readLine()) != null) {
                sb.append(s);
                this.dbConsoleOutput = this.dbConsoleOutput + s;
            }
            p.waitFor();
            System.out.println("exit: " + p.exitValue());
            p.destroy();
            map.put("msg", sb.toString());
        }
        catch (Exception ex) {
            this.dbConsoleOutput = this.dbConsoleOutput + ex.getMessage();
            map.put("msg", ex.getMessage());
        }
        return map;
    }

    @RequestMapping(value={"/checkmongo"})
    public boolean checkMongo(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            this.mongoTemplate.getDb().getStats();
        }
        catch (MongoException e) {
            return false;
        }
        return true;
    }

    @Bean
    public String getCronValue() {
        try {
            List appInitList = this.appInitConfigRepository.findAll();
            if (PropertyValidator.isValid((Collection)appInitList)) {
                return ((AppInitConfig)appInitList.get(0)).getBackupJobCron();
            }
            return new AppInitConfig().getBackupJobCron();
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            return new AppInitConfig().getBackupJobCron();
        }
    }

    @Scheduled(cron="#{@getCronValue}")
    public void dump() throws Exception {
        try {
            String backupScript = "/opt/backup.sh";
            File f = new File(backupScript);
            if (f.exists() && !f.isDirectory()) {
                SortedMap kv = this.backupFiles();
                if (kv.size() > 14) {
                    String filePath = ((Map)kv.get(kv.lastKey())).get("fileName").toString();
                    new File(filePath).delete();
                }
                Process p = Runtime.getRuntime().exec(new String[]{backupScript});
                p.waitFor();
            }
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
    }

    @RequestMapping(value={"/stats"})
    public Map stats(HttpServletRequest request, HttpServletResponse response) throws Exception {
        RestTemplate restTemplate = new RestTemplate();
        Map kv = (Map)restTemplate.getForObject(this.getCmdUrl(request, metrics), Map.class, new Object[0]);
        return kv;
    }

    @RequestMapping(value={"/testdbconnection"})
    public ResponseEntity<Object> testDBConnection(@RequestPart(value="caCertFile") Optional<MultipartFile> caCertFile, @RequestPart(value="certFile") Optional<MultipartFile> certFile, @RequestPart(value="keyFile") Optional<MultipartFile> keyFile, @RequestPart(value="dbParams") Map<String, String> dbParams, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean isSaveAction;
        String keyFilePath;
        String certPath;
        String caCertPath;
        HashMap<String, Object> responseResult;
        block11: {
            this.systemAuthenticaitonFilter.doFilter((ServletRequest)request, (ServletResponse)response);
            responseResult = new HashMap<String, Object>();
            MongoClient mongoClient = null;
            caCertPath = null;
            certPath = null;
            keyFilePath = null;
            isSaveAction = Boolean.parseBoolean(dbParams.get("isSave"));
            try {
                MongoClientOptions mongoClientOptions;
                String dbHost = dbParams.get("host");
                String dbPort = dbParams.get("port");
                String dbUser = dbParams.get("user");
                String dbPassword = dbParams.get("password");
                String dbName = dbParams.get("name");
                String sslPassword = dbParams.get("sslPassword");
                MultipartFile caCert = caCertFile.orElse(null);
                MultipartFile cert = certFile.orElse(null);
                MultipartFile pemKey = keyFile.orElse(null);
                SSLContext sslContext = null;
                if (PropertyValidator.isValid((Object)caCert) && PropertyValidator.isValid((Object)cert) && PropertyValidator.isValid((Object)pemKey)) {
                    caCertPath = SystemUtil.uploadFileToServer((MultipartFile)caCert);
                    certPath = SystemUtil.uploadFileToServer((MultipartFile)cert);
                    keyFilePath = SystemUtil.uploadFileToServer((MultipartFile)pemKey);
                    sslContext = SSLUtil.getSSLContext((String)caCertPath, (String)certPath, (String)keyFilePath, (String)sslPassword);
                    MongoClientOptions.Builder builder = MongoClientOptions.builder();
                    mongoClientOptions = builder.sslEnabled(true).sslInvalidHostNameAllowed(true).sslContext(sslContext).serverSelectionTimeout(2000).build();
                } else {
                    mongoClientOptions = MongoClientOptions.builder().serverSelectionTimeout(2000).build();
                }
                if (PropertyValidator.isValid((Object)dbUser) && PropertyValidator.isValid((Object)dbPassword) && dbHost.contains("://")) {
                    MongoClientURI uri;
                    String str = dbHost.toString();
                    str = str.replace("<user>", dbUser);
                    str = str.replace("<password>", dbPassword);
                    str = str.replace("<db>", dbName);
                    if (PropertyValidator.isValid((Object)sslContext)) {
                        MongoClientOptions.Builder builder = MongoClientOptions.builder();
                        builder.sslEnabled(true).sslInvalidHostNameAllowed(true).sslContext(sslContext).serverSelectionTimeout(2000);
                        uri = new MongoClientURI(str, builder);
                    } else {
                        uri = new MongoClientURI(str);
                    }
                    mongoClient = new MongoClient(uri);
                } else if (PropertyValidator.isValid((Object)dbUser) && PropertyValidator.isValid((Object)dbPassword) && PropertyValidator.isValid((Object)dbName) && !dbHost.contains("://")) {
                    MongoCredential credential = MongoCredential.createCredential((String)dbUser.toString(), (String)dbName.toString(), (char[])dbPassword.toString().toCharArray());
                    mongoClient = new MongoClient(Arrays.asList(new ServerAddress(dbHost.toString(), Integer.parseInt(dbPort.toString())), new ServerAddress(dbHost.toString(), Integer.parseInt(dbPort.toString()))), Arrays.asList(credential), mongoClientOptions);
                } else {
                    mongoClient = new MongoClient(Arrays.asList(new ServerAddress(dbHost.toString(), Integer.parseInt(dbPort.toString())), new ServerAddress(dbHost.toString(), Integer.parseInt(dbPort.toString()))), mongoClientOptions);
                }
                mongoClient.getDatabase(dbName).createCollection("contest");
                mongoClient.getDatabase(dbName).getCollection("contest").drop();
            }
            catch (Exception ex) {
                LOGGER.error(StringUtils.getTraceString((Throwable)ex));
                responseResult.put("error", StringUtils.getTraceString((Throwable)ex));
                if (ex.getMessage().contains("NamespaceExists")) break block11;
                responseResult.put("result", false);
                return new ResponseEntity(responseResult, HttpStatus.OK);
            }
        }
        responseResult.put("result", true);
        if (isSaveAction) {
            responseResult.put("caCertPath", caCertPath);
            responseResult.put("certPath", certPath);
            responseResult.put("keyFilePath", keyFilePath);
        }
        return new ResponseEntity(responseResult, HttpStatus.OK);
    }

    @RequestMapping(value={"/savedbconnection"}, method={RequestMethod.POST})
    public ResponseEntity<Object> saveDBConnection(@RequestPart(value="caCertFile") Optional<MultipartFile> caCertFile, @RequestPart(value="certFile") Optional<MultipartFile> certFile, @RequestPart(value="keyFile") Optional<MultipartFile> keyFile, @RequestPart(value="dbParams") Map<String, String> dbParams, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.systemAuthenticaitonFilter.doFilter((ServletRequest)request, (ServletResponse)response);
        dbParams.put("isSave", "true");
        ResponseEntity responseResult = this.testDBConnection(caCertFile, certFile, keyFile, dbParams, request, response);
        HashMap respons = (HashMap)responseResult.getBody();
        if (respons.get("result") != null && respons.get("result").equals(false)) {
            return new ResponseEntity((Object)respons, HttpStatus.OK);
        }
        try {
            String dbHost = dbParams.get("host");
            String dbPort = dbParams.get("port");
            String dbUser = dbParams.get("user");
            String dbPassword = dbParams.get("password");
            String dbName = dbParams.get("name");
            String sslPassword = dbParams.get("sslPassword");
            String caCert = (String)respons.get("caCertPath");
            String cert = (String)respons.get("certPath");
            String pemKey = (String)respons.get("keyFilePath");
            HashMap responseData = SystemUtil.updateDBSettings((String)dbHost, (String)dbPort, (String)dbUser, (String)dbPassword, (String)dbName, (String)sslPassword, (String)caCert, (String)cert, (String)pemKey);
            if (PropertyValidator.isValid(responseData.get("success"))) {
                Boolean isSucceeded = (Boolean)responseData.get("success");
                if (isSucceeded.booleanValue()) {
                    this.restartCmd();
                } else if (PropertyValidator.isValid(responseData.get("error"))) {
                    responseData.put("result", false);
                    return new ResponseEntity((Object)responseData, HttpStatus.OK);
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
        return new ResponseEntity((Object)respons, HttpStatus.OK);
    }

    @RequestMapping(value={"/updateappconfig/{enable}"})
    public HashMap<String, Object> updateAppInitConfig(@PathVariable(value="enable") Boolean enableMultiNode) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            AppInitConfig appInitConfig = (AppInitConfig)this.appInitConfigRepository.findAll().get(0);
            appInitConfig.setEnableMultiNode(enableMultiNode.booleanValue());
            this.appInitConfigRepository.save((Object)appInitConfig);
            response.put("appInit", appInitConfig);
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
        return response;
    }

    @RequestMapping(value={"/dbhost"})
    public HashMap<String, Object> getDbUrl() {
        HashMap<String, Object> response = new HashMap<String, Object>();
        String[] configDetails = new String[4];
        String dbHost = this.env.getProperty("mongo.url1");
        String dbPort = this.env.getProperty("mongo.port");
        String dbName = this.env.getProperty("mongo.db");
        String dbUser = this.env.getProperty("mongo.user");
        String dbPassword = this.env.getProperty("mongo.pass");
        configDetails[0] = dbHost;
        configDetails[1] = PropertyValidator.isValid((Object)dbPort) ? dbPort : "";
        configDetails[2] = dbName;
        configDetails[3] = dbUser != null && dbPassword != null ? "auth" : "anonymous";
        response.put("dbdata", configDetails);
        try {
            List appInitConfigList;
            if (this.appInitConfigRepository != null && PropertyValidator.isValid((Collection)(appInitConfigList = this.appInitConfigRepository.findAll()))) {
                response.put("appConfig", appInitConfigList.get(0));
            }
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
        return response;
    }

    @RequestMapping(value={"/resetpass"})
    public void resetPass(@RequestBody String password) {
        try {
            SystemUtil.setSysPass((String)password);
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
    }

    @RequestMapping(value={"/logout"})
    public String logoutMonitor(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.env.getProperty("isLocalDeployment").equals("true")) {
            request.getSession().invalidate();
            response.sendError(401, "logged out");
            response.sendRedirect("/signout");
            return null;
        }
        return null;
    }

    public static void changeLoggerDebug(boolean enabled) {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        List loggerList = loggerContext.getLoggerList();
        Level lvl = Level.ERROR;
        if (enabled) {
            Calendar date = Calendar.getInstance();
            long t = date.getTimeInMillis();
            java.sql.Date afterAddingTenMins = new java.sql.Date(t + 600000L);
            debugTime = afterAddingTenMins.getTime();
            lvl = Level.DEBUG;
        } else {
            debugTime = null;
        }
        for (Logger logger : loggerList) {
            if (!logger.getName().contains("com.viztrend") && !logger.getName().contains("com.google.api.client.auth.oauth") && !logger.getName().contains("onsite")) continue;
            logger.setLevel(lvl);
        }
    }

    public static boolean isDebug() {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        List loggerList = loggerContext.getLoggerList();
        boolean isDebug = false;
        for (Logger logger : loggerList) {
            if (!logger.getName().contains("com.viztrend") && !logger.getName().contains("com.google.api.client.auth.oauth") && !logger.getName().contains("onsite")) continue;
            if (Level.DEBUG.equals(logger.getLevel())) {
                isDebug = true;
                continue;
            }
            isDebug = false;
        }
        return isDebug;
    }

    @Scheduled(fixedDelay=120000L)
    public void checkDebug() {
        if (debugTime != null && debugTime < new Date().getTime()) {
            HealthController.changeLoggerDebug((boolean)false);
            this.customRepository.enableAlmAccountsDebugMode(false);
        }
    }

    @RequestMapping(value={"/mongo"})
    public Map<String, Object> mongo(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String dbUser = this.env.getProperty("mongo.user");
        String dbPassword = this.env.getProperty("mongo.pass");
        String dbName = this.env.getProperty("mongo.db");
        String dbHost = this.env.getProperty("mongo.url1");
        String dbPort = this.env.getProperty("mongo.port");
        HashMap<String, Object> kv = new HashMap<String, Object>();
        kv.put("dbUser", dbUser);
        kv.put("dbPassword", dbPassword);
        kv.put("dbName", dbName);
        kv.put("dbHost", dbHost);
        kv.put("dbPort", dbPort);
        CommandResult cr = null;
        try {
            cr = this.mongoTemplate.getDb().getStats();
            kv.putAll((Map<String, Object>)cr);
        }
        catch (Exception ex) {
            kv.put("status", "failed");
            LOGGER.error("error while connecting to mongo ", (Throwable)ex);
        }
        return kv;
    }

    public String getCmdUrl(HttpServletRequest request, String cmd) {
        String url = request.getScheme() + "://127.0.0.1:" + request.getServerPort() + "/system/" + cmd;
        return url;
    }

    @RequestMapping(value={"/cachesize"})
    public Map<String, Object> getCacheSize(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.systemAuthenticaitonFilter.doFilter((ServletRequest)request, (ServletResponse)response);
        HashMap<String, Object> kv = new HashMap<String, Object>();
        long whsize = this.mongoTemplate.getDb().getCollection("jiraWebhookMappedData").getCount();
        long others = this.mongoTemplate.getDb().getCollection("jiraIssue").getCount();
        kv.put("webhook", whsize += this.mongoTemplate.getDb().getCollection("tFSWebhookMappedData").getCount());
        kv.put("others", others);
        return kv;
    }

    @RequestMapping(value={"/clearcache"})
    public void clearCache(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.systemAuthenticaitonFilter.doFilter((ServletRequest)request, (ServletResponse)response);
        this.mongoTemplate.getDb().getCollection("jiraWebhookMappedData").drop();
        this.mongoTemplate.getDb().getCollection("tFSWebhookMappedData").drop();
        this.mongoTemplate.getDb().getCollection("jiraIssue").drop();
    }

    @RequestMapping(value={"/indexes"})
    public void createIndexes(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            this.systemAuthenticaitonFilter.doFilter((ServletRequest)request, (ServletResponse)response);
            List indexList = this.readIndexFile();
            for (Map indexMap : indexList) {
                try {
                    this.mongoTemplate.getDb().getCollection(indexMap.get("collection").toString()).createIndex((DBObject)((BasicDBObject)indexMap.get("index_attrib")));
                }
                catch (Exception ex) {
                    LOGGER.error(ex.getMessage());
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
    }

    private List<Map> readIndexFile() throws JsonSyntaxException, IOException {
        String line;
        InputStream inputStream = HealthController.class.getResourceAsStream("/db_index/index.json");
        InputStreamReader streamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        BufferedReader reader = new BufferedReader(streamReader);
        ArrayList<Map> indexList = new ArrayList<Map>();
        while ((line = reader.readLine()) != null) {
            Gson gson = new Gson();
            Map map = (Map)gson.fromJson(line, Map.class);
            Map map2 = (Map)map.get("key");
            BasicDBObject indexOptions = new BasicDBObject();
            for (String key : map2.keySet()) {
                indexOptions.put(key, (Object)1);
            }
            HashMap indexFileMap = new HashMap();
            indexFileMap.put("collection", map.get("collection"));
            indexFileMap.put("index_attrib", indexOptions);
            indexList.add(indexFileMap);
        }
        return indexList;
    }

    public void onApplicationEvent(ApplicationPreparedEvent input) {
        this.event = input;
        if (this.context == null) {
            this.context = this.event.getApplicationContext();
            this.args = this.event.getArgs();
            this.application = this.event.getSpringApplication();
        }
    }

    @ResponseBody
    public ResponseEntity<Object> uploadJarFile(@RequestParam(value="file") MultipartFile file, HttpServletRequest request, HttpServletResponse response) {
        try {
            this.systemAuthenticaitonFilter.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (ServletException e1) {
            e1.printStackTrace();
        }
        File folder = new File("./target");
        try {
            String backupFolderLoc = folder.getAbsolutePath();
            String fileName = "kendis-1.0.jar";
            Path path = Paths.get(backupFolderLoc + "/" + fileName, new String[0]);
            Files.write(path, file.getBytes(), new OpenOption[0]);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return null;
    }

    public void restartServer(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.systemAuthenticaitonFilter.doFilter((ServletRequest)request, (ServletResponse)response);
        Thread restartThread = new Thread(() -> Application.restart());
        restartThread.setDaemon(false);
        restartThread.start();
    }

    @RequestMapping(value={"/save-scheduler-time"})
    public ResponseEntity<Object> saveSchedulerTime(@RequestBody HashMap<String, Object> reqBody) {
        HashMap<String, String> responseJson = new HashMap<String, String>();
        try {
            String requesttype;
            AppInitConfig appInitConfig = (AppInitConfig)this.appInitConfigRepository.findAll().get(0);
            String backupJobCron = PropertyValidator.isValid((Object)reqBody.get("backupJobCron")) ? reqBody.get("backupJobCron").toString() : "";
            String string = requesttype = PropertyValidator.isValid((Object)reqBody.get("requesttype")) ? reqBody.get("requesttype").toString() : "";
            if (PropertyValidator.isValid((Object)DateUtils.getCurrentTimezoneOffset())) {
                responseJson.put("gmtTimeZoneToNotify", DateUtils.getCurrentTimezoneOffset());
            }
            if (requesttype.equals("setjobcron")) {
                String backupJobCronTimer = "";
                String oldBackUpJobCron = "";
                if (PropertyValidator.isValid((Object)appInitConfig)) {
                    oldBackUpJobCron = appInitConfig.getBackupJobCron();
                    backupJobCronTimer = PropertyValidator.isValid((Object)backupJobCron) ? backupJobCron : oldBackUpJobCron;
                    appInitConfig.setBackupJobCron(backupJobCronTimer);
                    appInitConfig = (AppInitConfig)this.appInitConfigRepository.save((Object)appInitConfig);
                }
                responseJson.put("oldCron", oldBackUpJobCron);
                responseJson.put("newCron", backupJobCronTimer);
                responseJson.put("messageStatus", "Scheduler Saved");
                responseJson.put("serverStatus", (String)HttpStatus.OK);
                return new ResponseEntity(responseJson, HttpStatus.OK);
            }
            if (requesttype.equals("getjobcron") && PropertyValidator.isValid((Object)appInitConfig)) {
                responseJson.put("oldCron", appInitConfig.getBackupJobCron());
                return new ResponseEntity(responseJson, HttpStatus.OK);
            }
        }
        catch (Exception e) {
            responseJson.put("messageStatus", "An Error occured while saving");
            responseJson.put("serverStatus", (String)HttpStatus.INTERNAL_SERVER_ERROR);
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return null;
    }

    static {
        LOGGER = LoggerFactory.getLogger(HealthController.class);
    }
}

