/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.controller;

import com.google.api.client.repackaged.com.google.common.base.Splitter;
import com.google.gson.Gson;
import com.mongodb.DBObject;
import com.mongodb.gridfs.GridFSDBFile;
import com.pusher.rest.Pusher;
import com.viztrend.safe.config.AppConfig;
import com.viztrend.safe.enums.EnumShareBoard;
import com.viztrend.safe.persistence.entity.AppInitConfig;
import com.viztrend.safe.persistence.entity.CanvasBoard;
import com.viztrend.safe.persistence.entity.CanvasFolder;
import com.viztrend.safe.persistence.entity.CanvasNote;
import com.viztrend.safe.persistence.entity.ServerCache;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.SolutionBoard;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.WorkSpace;
import com.viztrend.safe.persistence.repository.AppInitConfigRepository;
import com.viztrend.safe.persistence.repository.CanvasBoardRepository;
import com.viztrend.safe.persistence.repository.CustomRepository;
import com.viztrend.safe.persistence.repository.CustomRepositoryImpl;
import com.viztrend.safe.persistence.repository.ServerCacheRepository;
import com.viztrend.safe.persistence.repository.SessionRepository;
import com.viztrend.safe.persistence.repository.SolutionBoardRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceRepository;
import com.viztrend.safe.service.ALMSyncService;
import com.viztrend.safe.service.AttachmentService;
import com.viztrend.safe.service.GraphAuditLogService;
import com.viztrend.safe.service.GraphServiceImpl;
import com.viztrend.safe.utils.EncDecUtility;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.UserContextUtil;
import java.io.InputStream;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.compress.utils.IOUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.gridfs.GridFsResource;
import org.springframework.data.mongodb.gridfs.GridFsTemplate;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RequestMapping(value={"/graphx"})
@RestController
public class GraphController {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphController.class);
    @Autowired
    private GraphServiceImpl graphServiceImpl;
    @Autowired
    private ServerCacheRepository serverCacheRepository;
    @Autowired
    private GraphAuditLogService graphAuditLogService;
    @Autowired
    private CanvasBoardRepository canvasBoardRepository;
    @Autowired
    private Environment env;
    @Autowired
    private AppInitConfigRepository appInitConfigRepository;
    @Autowired
    private CustomRepositoryImpl<?> customRepositoryImpl;
    @Autowired
    private CustomRepository<Object> customRepository;
    @Autowired
    ALMSyncService aLMSyncService;
    @Autowired
    private AttachmentService attachmentService;
    @Autowired
    private AppConfig.MongoConfig mongoConfig;
    @Autowired
    private GridFsTemplate gridFsTemplate;
    @Autowired
    private WorkSpaceRepository workSpaceRepository;
    @Autowired
    private SolutionBoardRepository solutionBoardRepository;
    @Autowired
    private SessionRepository sessionRepository;
    private Pusher pusher = null;
    private String channelPrefix = "private-";

    @PostConstruct
    public void init() {
        try {
            List appInitConfigList = this.appInitConfigRepository.findAll();
            if (PropertyValidator.isValid((Collection)appInitConfigList) && PropertyValidator.isValid((Object)((AppInitConfig)appInitConfigList.get(0)).getPusherEncKey())) {
                String pusherEncKey = ((AppInitConfig)appInitConfigList.get(0)).getPusherEncKey();
                if (EncDecUtility.isKMSEncryption((String)pusherEncKey)) {
                    pusherEncKey = EncDecUtility.decryptKMS((String)pusherEncKey);
                }
                this.pusher = new Pusher(this.env.getProperty("pusher.app_id"), this.env.getProperty("pusher.key"), this.env.getProperty("pusher.secret"), pusherEncKey);
            } else {
                this.pusher = new Pusher(this.env.getProperty("pusher.app_id"), this.env.getProperty("pusher.key"), this.env.getProperty("pusher.secret"));
            }
            this.pusher.setCluster(this.env.getProperty("pusher.cluster"));
            this.pusher.setEncrypted(true);
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
    }

    @GetMapping(value={"/"})
    @ResponseBody
    public ResponseEntity getAllBoards() {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        responseJson.put("success", true);
        responseJson.put("board", this.graphServiceImpl.findAllBoards());
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @GetMapping(value={"/status"})
    @ResponseBody
    public ResponseEntity checkStatus() {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        responseJson.put("success", true);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @GetMapping(value={"/public_share/status"})
    @ResponseBody
    public ResponseEntity checkStatusPublic() {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        responseJson.put("success", true);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/pusher/auth"}, method={RequestMethod.POST})
    public String pusherAuth(HttpServletRequest request, HttpServletResponse response) {
        if (this.pusher != null && (this.channelPrefix + UserContextUtil.getUserContext().getCurrentCompanyId()).equals(request.getParameter("channel_name"))) {
            String authBody = this.pusher.authenticate(request.getParameter("socket_id"), request.getParameter("channel_name"));
            return authBody;
        }
        return null;
    }

    @RequestMapping(value={"/public_share/pusher/auth/{companyId}"}, method={RequestMethod.POST})
    public String pusherAuthPublic(HttpServletRequest request, HttpServletResponse response, @PathVariable String companyId) {
        if (this.pusher != null && (this.channelPrefix + companyId).equals(request.getParameter("channel_name"))) {
            String authBody = this.pusher.authenticate(request.getParameter("socket_id"), request.getParameter("channel_name"));
            return authBody;
        }
        return null;
    }

    @GetMapping(value={"/board/list/{userId}"})
    @ResponseBody
    public ResponseEntity getBoardListByUserId(@PathVariable String userId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        responseJson.put("success", true);
        responseJson.put("boards", this.graphServiceImpl.findBoardByUserId(userId));
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @GetMapping(value={"/shared-board/list/{userId}"})
    @ResponseBody
    public ResponseEntity getSharedBoardListByUserId(@PathVariable String userId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        responseJson.put("boards", this.graphServiceImpl.findSharedBoardByUserId(userId));
        responseJson.put("success", true);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @GetMapping(value={"/folder/list/{userId}"})
    @ResponseBody
    public ResponseEntity getFolderListByUserId(@PathVariable String userId) {
        try {
            HashMap<String, Object> responseJson = new HashMap<String, Object>();
            responseJson.put("success", true);
            responseJson.put("folders", this.graphServiceImpl.findFolderByUserId(userId));
            responseJson.put("sharedBoards", this.graphServiceImpl.findSharedBoardByUserId(userId));
            responseJson.put("starredBoards", this.graphServiceImpl.findBoardPreferencesByUserId(userId));
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    @GetMapping(value={"/board/{id}/{uid}"})
    @ResponseBody
    public ResponseEntity getBoard(@PathVariable String id, @PathVariable String uid) {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        responseJson.put("success", true);
        responseJson.put("board", (Boolean)this.graphServiceImpl.findBoardById(id, null));
        responseJson.put("starred", this.graphServiceImpl.findStarredBoardById(id, uid));
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @PostMapping(value={"/get/clickedContext"})
    @ResponseBody
    public ResponseEntity getClickedContext(@RequestBody Map board) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        String context = (String)board.get("context");
        String key = (String)board.get("id");
        if (PropertyValidator.isValid((Object)context)) {
            if ("workspace".equals(context)) {
                WorkSpace workSpace = this.workSpaceRepository.findByKey(key);
                responseJson.put("context", workSpace);
            } else if ("session".equals(context)) {
                Session session = this.sessionRepository.findById(key);
                responseJson.put("context", session);
            } else if ("solution".equals(context)) {
                SolutionBoard solutionBoard = this.solutionBoardRepository.findById(key);
                responseJson.put("context", solutionBoard);
            }
        }
        responseJson.put("success", true);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @GetMapping(value={"/boardData/{id}/{uid}"})
    @ResponseBody
    public ResponseEntity getBoardData(@PathVariable String id, @PathVariable String uid) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            responseJson.put("success", true);
            responseJson.put("nodes", this.graphServiceImpl.findNodesByBoradId(id, null));
            responseJson.put("links", this.graphServiceImpl.findLinksByBoradId(id, null));
            responseJson.put("shareBoardMeta", EnumShareBoard.getAllValuesList());
            CanvasBoard board = this.canvasBoardRepository.findVersionById(id);
            if (PropertyValidator.isValid((Object)board)) {
                responseJson.put("version", board.getVersion());
            }
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            return null;
        }
    }

    @GetMapping(value={"/public_share/board/{tenant}/{id}"})
    @ResponseBody
    public ResponseEntity getBoardPublicShare(@PathVariable String tenant, @PathVariable String id) {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        responseJson.put("success", true);
        responseJson.put("board", (Boolean)this.graphServiceImpl.findBoardById(id, tenant));
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @GetMapping(value={"/public_share/boardData/{tenant}/{id}"})
    @ResponseBody
    public ResponseEntity getBoardDataPublicShare(@PathVariable String tenant, @PathVariable String id) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            responseJson.put("success", true);
            responseJson.put("nodes", this.graphServiceImpl.findNodesByBoradId(id, tenant));
            responseJson.put("links", this.graphServiceImpl.findLinksByBoradId(id, tenant));
            responseJson.put("shareBoardMeta", EnumShareBoard.getAllValuesList());
            CanvasBoard board = this.canvasBoardRepository.findVersionById(id);
            responseJson.put("version", board.getVersion());
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/folder/{id}"})
    @ResponseBody
    public ResponseEntity getFolder(@PathVariable String id) {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        responseJson.put("success", true);
        responseJson.put("folder", (Boolean)this.graphServiceImpl.findFolderById(id));
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @PostMapping(value={"/board/create"})
    @ResponseBody
    public ResponseEntity saveBoard(@RequestBody Map board) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        if (PropertyValidator.isValid(board.get("flag"))) {
            if (board.get("flag").equals("collaboration-link")) {
                ResponseEntity response = this.graphServiceImpl.saveBoard(board);
                CanvasBoard savedBoard = null;
                if (PropertyValidator.isValid((Object)response)) {
                    savedBoard = (CanvasBoard)((HashMap)response.getBody()).get("board");
                }
                responseJson.put("board", savedBoard);
            }
        } else {
            ResponseEntity reponse = this.graphServiceImpl.saveBoard(board);
            CanvasFolder folder = null;
            CanvasBoard board2 = null;
            if (PropertyValidator.isValid((Object)reponse)) {
                folder = (CanvasFolder)((HashMap)reponse.getBody()).get("parentFolder");
                board2 = (CanvasBoard)((HashMap)reponse.getBody()).get("board");
            }
            responseJson.put("success", true);
            responseJson.put("folder", folder);
            responseJson.put("board", board2);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @PostMapping(value={"/board/create/using_template"})
    @ResponseBody
    public ResponseEntity saveBoardUsingTemplate(@RequestBody Map board) {
        HashMap responseJson = new HashMap();
        if (PropertyValidator.isValid(board.get("flag"))) {
            if (board.get("flag").equals("collaboration-link")) {
                ResponseEntity response = this.graphServiceImpl.createBoardUsingCollaborationLink(board);
                Object savedBoard = null;
                if (PropertyValidator.isValid((Object)response)) {
                    responseJson.put("board", ((HashMap)response.getBody()).get("board"));
                    responseJson.put("nodes", ((HashMap)response.getBody()).get("nodes"));
                    responseJson.put("links", ((HashMap)response.getBody()).get("links"));
                }
            }
        } else {
            ResponseEntity response = this.graphServiceImpl.saveBoardUsingTemplate(board);
            CanvasFolder folder = null;
            CanvasBoard savedBoard = null;
            if (PropertyValidator.isValid((Object)response)) {
                folder = (CanvasFolder)((HashMap)response.getBody()).get("parentFolder");
                savedBoard = (CanvasBoard)((HashMap)response.getBody()).get("board");
            }
            responseJson.put("success", true);
            responseJson.put("folder", folder);
            responseJson.put("board", savedBoard);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @PostMapping(value={"/session-collaboration-boards/{id}"})
    @ResponseBody
    public ResponseEntity getSessionCollabBoards(@PathVariable String id, @RequestBody Map board) {
        try {
            List collabBoards = this.graphServiceImpl.findCollabBoardsById(id, board);
            Map paginationInfo = (Map)board.get("paginationInfo");
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            if (paginationInfo != null) {
                HashMap<String, List<Object>> paginatedResult = new HashMap<String, List<Object>>();
                paginatedResult.put("items", collabBoards);
                paginatedResult.put("teamsMeta", (List<Object>)paginationInfo.get("teamsMeta"));
                paginatedResult.put("totalItems", (List<Object>)paginationInfo.get("totalItems"));
                paginatedResult.put("currentPage", (List<Object>)paginationInfo.get("currentPage"));
                paginatedResult.put("pageSize", (List<Object>)paginationInfo.get("pageSize"));
                paginatedResult.put("totalPages", (List<Object>)paginationInfo.get("totalPages"));
                response.put("paginatedResult", paginatedResult);
            } else {
                response.put("collabBoards", collabBoards);
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(response);
        }
        catch (Exception e) {
            LOGGER.error("Error getting collaboration boards", (Object)StringUtils.getTraceString((Throwable)e));
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Failed to get collaboration boards");
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(errorResponse);
        }
    }

    @PostMapping(value={"/getBoardCount/{id}"})
    @ResponseBody
    public ResponseEntity getBoardCount(@PathVariable String id, @RequestBody Map payload) {
        try {
            Map boardCounts = this.graphServiceImpl.getBoardCountByContext(id, payload);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("boardCounts", boardCounts);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(response);
        }
        catch (Exception e) {
            LOGGER.error("Error getting board counts", (Throwable)e);
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Failed to get board counts");
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(errorResponse);
        }
    }

    @PostMapping(value={"/board/history"})
    @ResponseBody
    public ResponseEntity getHistory(@RequestBody HashMap<String, Object> payload) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        List auditLogs = this.graphAuditLogService.getAuditLog(payload);
        if (auditLogs != null) {
            responseJson.put("success", true);
            responseJson.put("logs", auditLogs);
            Number offset = (Number)payload.get("offset");
            responseJson.put("page", offset);
        } else {
            responseJson.put("success", false);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @GetMapping(value={"/users"})
    @ResponseBody
    public ResponseEntity getCompanyUsers() {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        List users = this.graphServiceImpl.getCompanyUsers();
        if (users == null) {
            responseJson.put("success", false);
        } else {
            responseJson.put("success", true);
            responseJson.put("users", users);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @PostMapping(value={"/apply_template"})
    @ResponseBody
    public ResponseEntity applyTemplate(@RequestBody Map template) {
        HashMap responseJson = new HashMap();
        ResponseEntity response = this.graphServiceImpl.applyTemplate(template);
        responseJson.put("nodes", ((HashMap)response.getBody()).get("nodes"));
        responseJson.put("links", ((HashMap)response.getBody()).get("links"));
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @PostMapping(value={"/folder/create"})
    @ResponseBody
    public ResponseEntity saveFolder(@RequestBody Map folder) {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        CanvasFolder canvasFolder = this.graphServiceImpl.saveFolder(folder);
        responseJson.put("success", true);
        responseJson.put("folder", (Boolean)canvasFolder);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @PostMapping(value={"/board/permission"})
    @ResponseBody
    public ResponseEntity addBoardPermission(@RequestBody Map permission) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        CanvasBoard canvasBoard = this.graphServiceImpl.addBoardPermission(permission);
        if (PropertyValidator.isValid((Object)canvasBoard.getId())) {
            responseJson.put("board", canvasBoard);
        } else {
            responseJson.put("board", false);
        }
        responseJson.put("success", true);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @DeleteMapping(value={"/collaborator/delete/{boardId}/{userId}"})
    @ResponseBody
    public ResponseEntity removeCollaborator(@PathVariable(value="boardId") String boardId, @PathVariable(value="userId") String userId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        responseJson.put("boardId", this.graphServiceImpl.removeCollaborator(boardId, userId));
        responseJson.put("success", true);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @PostMapping(value={"/node/create/{boardId}"})
    @ResponseBody
    public ResponseEntity saveNode(@RequestBody List<Map> nodeList, @PathVariable String boardId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("boardId", boardId);
            params.put("items", nodeList);
            responseJson.put("nodeIdsList", this.graphServiceImpl.saveNode(params));
            responseJson.put("success", true);
            Long boardVersion = this.graphServiceImpl.incrementBoardVersion(boardId, null);
            if (boardVersion != null) {
                responseJson.put("boardVersion", boardVersion);
            }
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            responseJson.put("error", e);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
    }

    @PostMapping(value={"/item/restore/{boardId}"})
    @ResponseBody
    public ResponseEntity restoreItem(@RequestBody HashMap<String, Object> requestData, @PathVariable String boardId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            requestData.put("boardId", boardId);
            responseJson.put("items", this.graphServiceImpl.restoreItem(requestData));
            responseJson.put("success", true);
            Long boardVersion = this.graphServiceImpl.incrementBoardVersion(boardId, null);
            if (boardVersion != null) {
                responseJson.put("boardVersion", boardVersion);
            }
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            responseJson.put("error", e);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
    }

    @PostMapping(value={"public_share/node/create/{tenant}/{boardId}/{extUserName}"})
    @ResponseBody
    public ResponseEntity saveNodePublicShare(@RequestBody List<Map> nodeList, @PathVariable String tenant, @PathVariable String boardId, @PathVariable String extUserName) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("boardId", boardId);
            params.put("items", nodeList);
            params.put("externalUserName", extUserName);
            params.put("tenant", tenant);
            responseJson.put("nodeIdsList", this.graphServiceImpl.saveNode(params));
            responseJson.put("success", true);
            Long boardVersion = this.graphServiceImpl.incrementBoardVersion(boardId, tenant);
            if (boardVersion != null) {
                responseJson.put("boardVersion", boardVersion);
            }
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            responseJson.put("error", e);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
    }

    @PostMapping(value={"/link/create/{boardId}"})
    @ResponseBody
    public ResponseEntity saveLink(@RequestBody List<Map> linksList, @PathVariable String boardId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("boardId", boardId);
        params.put("items", linksList);
        responseJson.put("linkIdsList", this.graphServiceImpl.saveLink(params));
        responseJson.put("success", true);
        Long boardVersion = this.graphServiceImpl.incrementBoardVersion(boardId, null);
        if (boardVersion != null) {
            responseJson.put("boardVersion", boardVersion);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @PostMapping(value={"/public_share/link/create/{tenant}/{boardId}/{extUserName}"})
    @ResponseBody
    public ResponseEntity saveLinkPublicShare(@RequestBody List<Map> linksList, @PathVariable String tenant, @PathVariable String boardId, @PathVariable String extUserName) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("boardId", boardId);
        params.put("items", linksList);
        params.put("externalUserName", extUserName);
        params.put("tenant", tenant);
        responseJson.put("linkIdsList", this.graphServiceImpl.saveLink(params));
        responseJson.put("success", true);
        Long boardVersion = this.graphServiceImpl.incrementBoardVersion(boardId, tenant);
        if (boardVersion != null) {
            responseJson.put("boardVersion", boardVersion);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @GetMapping(value={"/template/all/{userId}"})
    @ResponseBody
    public ResponseEntity getAllTemplatesByUserId(@PathVariable String userId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        responseJson.put("success", true);
        responseJson.put("templates", this.graphServiceImpl.findTemplatesByUserId(userId));
        responseJson.put("systemTemplates", this.graphServiceImpl.getSystemTemplates());
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @PostMapping(value={"/template/save"})
    @ResponseBody
    public ResponseEntity saveTemplate(@RequestBody Map template) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        responseJson.put("template", this.graphServiceImpl.saveTemplate(template));
        responseJson.put("success", true);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @PostMapping(value={"/template/update"})
    @ResponseBody
    public ResponseEntity updateTemplate(@RequestBody Map template) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        responseJson.put("template", this.graphServiceImpl.updateTemplate(template));
        responseJson.put("success", true);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @PostMapping(value={"/createShareUrl/{id}"})
    @ResponseBody
    public ResponseEntity createShareUrl(@PathVariable String id, @RequestBody HashMap<String, String> body) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        CanvasBoard board = this.graphServiceImpl.findBoardById(id, null);
        if (board.getUrl() != null) {
            responseJson.put("success", false);
            responseJson.put("reason", "AlreadyExist");
        } else {
            String accessToken = UUID.randomUUID().toString();
            ServerCache serverCache = new ServerCache();
            serverCache.setKey(accessToken);
            serverCache.setValue(body.get("params"));
            serverCache.setTime(new Date());
            this.serverCacheRepository.save((Object)serverCache);
            String url = "/graphx/board/public_share/root?token=" + accessToken;
            board.setUrl(url);
            String boardId = this.graphServiceImpl.updateBoardUrl(id, url);
            responseJson.put("success", true);
            responseJson.put("url", url);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @PostMapping(value={"/getBoardPublicLinks/{id}"})
    @ResponseBody
    public ResponseEntity getBoardPublicLinks(@PathVariable String id) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        CanvasBoard board = this.graphServiceImpl.findBoardById(id, null);
        if (PropertyValidator.isValid((Object)board) && PropertyValidator.isValid((Object)board.getUrl())) {
            responseJson.put("boardPublicLinks", board.getUrl());
        }
        responseJson.put("success", true);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/board/saveAnonymousUser"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity saveAnonymousUser(@RequestBody HashMap<String, String> body) {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        try {
            String user = this.graphServiceImpl.saveAnonymousUser(body);
            responseJson.put("success", true);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/stopExternalShareUrl"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity stopExternalShareUrl(@RequestBody HashMap<String, String> data) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        String token = data.get("token").toString();
        String boardId = data.get("boardId").toString();
        ServerCache serverCache = this.serverCacheRepository.findByKey(token);
        if (PropertyValidator.isValid((Object)serverCache)) {
            this.serverCacheRepository.deleteByKey(token);
        }
        String accessToken = this.graphServiceImpl.removeExternalCollaborator(boardId, token);
        responseJson.put("accessToken", accessToken);
        responseJson.put("success", true);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/setShareBoardToken"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity setShareBoardToken(@RequestBody HashMap<String, Object> data) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        int code = Integer.parseInt(data.get("code").toString());
        String boardId = data.get("boardId").toString();
        String value = data.get("value").toString();
        HashMap params = (HashMap)data.get("params");
        params.put("tenant", UserContextUtil.getUserContext().getCurrentCompany().getTenant());
        Gson gson = new Gson();
        String jsonParams = gson.toJson((Object)params);
        responseJson.put("publicLinks", this.graphServiceImpl.generateShareBoardToken(boardId, code, value, jsonParams));
        responseJson.put("success", true);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @GetMapping(value={"/stopShareUrl/{id}"})
    @ResponseBody
    public ResponseEntity stopShareUrl(@PathVariable String id) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        CanvasBoard board = this.graphServiceImpl.findBoardById(id, null);
        if (board.getUrl() == null) {
            responseJson.put("success", false);
            responseJson.put("reason", "NotExist");
        } else {
            String url = board.getUrl();
            String accessToken = this.getParam(url, "token");
            this.serverCacheRepository.deleteByKey(accessToken);
            this.graphServiceImpl.updateBoardUrl(id, null);
            responseJson.put("success", true);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/public_share/decryptShareUrl"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> decryptShareUrl(@RequestBody HashMap<String, String> body, HttpServletRequest request) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        String token = body.get("token");
        ServerCache serverCache = this.serverCacheRepository.findByKey(token);
        if (PropertyValidator.isValid((Object)serverCache)) {
            try {
                JSONObject obj = new JSONObject(serverCache.getValue());
                String boardId = (String)obj.get("boardId");
                CanvasBoard board = this.graphServiceImpl.findBoardById(boardId, null);
                responseJson.put("companyId", (String)obj.get("companyId"));
                responseJson.put("tenant", (String)obj.get("tenant"));
                responseJson.put("success", true);
                responseJson.put("board", board);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @PostMapping(value={"/node/all/{boardId}"})
    @ResponseBody
    public ResponseEntity saveAllNode(@RequestBody String nodes, @PathVariable String boardId) {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("boardId", boardId);
        params.put("items", nodes);
        this.graphServiceImpl.saveAllNodes(params);
        responseJson.put("success", true);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @PostMapping(value={"/link/all/{boardId}"})
    @ResponseBody
    public ResponseEntity saveAllLink(@RequestBody String links, @PathVariable String boardId) {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("boardId", boardId);
        params.put("items", links);
        this.graphServiceImpl.saveAllLinks(params);
        responseJson.put("success", true);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @PostMapping(value={"/board/update"})
    @ResponseBody
    public ResponseEntity updateBoard(@RequestBody Map board) {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        CanvasBoard cv = this.graphServiceImpl.updateBoard(board);
        responseJson.put("success", true);
        responseJson.put("board", (Boolean)cv);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @PostMapping(value={"folder/update"})
    @ResponseBody
    public ResponseEntity updateFolder(@RequestBody Map folder) {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        CanvasFolder canvasFolder = this.graphServiceImpl.updateFolder(folder);
        responseJson.put("success", true);
        responseJson.put("folder", (Boolean)canvasFolder);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @PostMapping(value={"/node/update/{boardId}"})
    @ResponseBody
    public ResponseEntity updateNode(@RequestBody List<Map> nodeList, @PathVariable String boardId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("boardId", boardId);
            params.put("items", nodeList);
            List nodeId = this.graphServiceImpl.updateNode(params);
            responseJson.put("success", true);
            responseJson.put("nodeId", nodeId);
            Long boardVersion = this.graphServiceImpl.incrementBoardVersion(boardId, null);
            if (boardVersion != null) {
                responseJson.put("boardVersion", boardVersion);
            }
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            responseJson.put("error", e);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
    }

    @PostMapping(value={"/public_share/node/update/{tenant}/{boardId}/{extUserName}"})
    @ResponseBody
    public ResponseEntity updateNodePublicShare(@RequestBody List<Map> nodeList, @PathVariable String tenant, @PathVariable String boardId, @PathVariable String extUserName) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("boardId", boardId);
            params.put("items", nodeList);
            params.put("externalUserName", extUserName);
            params.put("tenant", tenant);
            List nodeId = this.graphServiceImpl.updateNode(params);
            responseJson.put("success", true);
            responseJson.put("nodeId", nodeId);
            Long boardVersion = this.graphServiceImpl.incrementBoardVersion(boardId, tenant);
            if (boardVersion != null) {
                responseJson.put("boardVersion", boardVersion);
            }
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            responseJson.put("error", e);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
    }

    @PostMapping(value={"/node/update_template/{boardId}"})
    @ResponseBody
    public ResponseEntity updateExistingNodes(@RequestBody List<Map> nodes, @PathVariable String boardId) {
        HashMap<String, String> responseJson = new HashMap<String, String>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("boardId", boardId);
        params.put("items", nodes);
        String success = this.graphServiceImpl.updateExistingNodes(params);
        responseJson.put("success", success);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @PostMapping(value={"/link/update/{boardId}"})
    @ResponseBody
    public ResponseEntity updateLink(@RequestBody List<Map> linksList, @PathVariable String boardId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        boolean isAnyLocked = false;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("boardId", boardId);
        params.put("items", linksList);
        List linkId = this.graphServiceImpl.updateLink(params);
        responseJson.put("success", true);
        responseJson.put("linkId", linkId);
        Long boardVersion = this.graphServiceImpl.incrementBoardVersion(boardId, null);
        if (boardVersion != null) {
            responseJson.put("boardVersion", boardVersion);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @PostMapping(value={"/public_share/link/update/{tenant}/{boardId}/{extUserName}"})
    @ResponseBody
    public ResponseEntity updateLinkPublicShare(@RequestBody List<Map> linksList, @PathVariable String tenant, @PathVariable String boardId, @PathVariable String extUserName) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("boardId", boardId);
        params.put("items", linksList);
        params.put("externalUserName", extUserName);
        params.put("tenant", tenant);
        List linkId = this.graphServiceImpl.updateLink(params);
        responseJson.put("success", true);
        responseJson.put("linkId", linkId);
        Long boardVersion = this.graphServiceImpl.incrementBoardVersion(boardId, tenant);
        if (boardVersion != null) {
            responseJson.put("boardVersion", boardVersion);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @PostMapping(value={"/link/update_template/{boardId}"})
    @ResponseBody
    public ResponseEntity updateExistingLinks(@RequestBody ArrayList<Object> links, @PathVariable String boardId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("boardId", boardId);
        params.put("items", links);
        String linkId = this.graphServiceImpl.updateExistingLinks(params);
        responseJson.put("success", true);
        responseJson.put("linkId", linkId);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @DeleteMapping(value={"/delete/folder/{id}/{parentFolderId}"})
    @ResponseBody
    public ResponseEntity removeFolder(@PathVariable String id, @PathVariable String parentFolderId) {
        HashMap<String, Integer> responseJson = new HashMap<String, Integer>();
        responseJson.put("itemRemoved", this.graphServiceImpl.removeFolder(id, parentFolderId));
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @DeleteMapping(value={"/delete/board/{id}/{parentFolderId}"})
    @ResponseBody
    public ResponseEntity removeBoard(@PathVariable String id, @PathVariable String parentFolderId) {
        HashMap<String, Integer> responseJson = new HashMap<String, Integer>();
        responseJson.put("itemRemoved", this.graphServiceImpl.removeBoard(id, parentFolderId));
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @DeleteMapping(value={"/delete/session-collab-board/{id}"})
    @ResponseBody
    public ResponseEntity deleteSessionCollaborationBoard(@PathVariable String id) {
        HashMap<String, Integer> responseJson = new HashMap<String, Integer>();
        responseJson.put("itemRemoved", this.graphServiceImpl.deleteSessionCollaborationBoard(id));
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @DeleteMapping(value={"/delete/node/{boardId}"})
    @ResponseBody
    public ResponseEntity removeNode(@RequestBody List<Map> nodeList, @PathVariable String boardId) {
        HashMap<String, Constable> responseJson = new HashMap<String, Constable>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("boardId", boardId);
        params.put("items", nodeList);
        responseJson.put("itemRemoved", Integer.valueOf(this.graphServiceImpl.removeNode(params)));
        responseJson.put("success", Boolean.valueOf(true));
        Long boardVersion = this.graphServiceImpl.incrementBoardVersion(boardId, null);
        if (boardVersion != null) {
            responseJson.put("boardVersion", boardVersion);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @DeleteMapping(value={"/public_share/delete/node/{tenant}/{boardId}/{extUserName}"})
    @ResponseBody
    public ResponseEntity removeNodePublicShare(@RequestBody List<Map> nodeList, @PathVariable String tenant, @PathVariable String boardId, @PathVariable String extUserName) {
        HashMap<String, Constable> responseJson = new HashMap<String, Constable>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("boardId", boardId);
        params.put("items", nodeList);
        params.put("externalUserName", extUserName);
        params.put("tenant", tenant);
        responseJson.put("itemRemoved", Integer.valueOf(this.graphServiceImpl.removeNode(params)));
        responseJson.put("success", Boolean.valueOf(true));
        Long boardVersion = this.graphServiceImpl.incrementBoardVersion(boardId, tenant);
        if (boardVersion != null) {
            responseJson.put("boardVersion", boardVersion);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @DeleteMapping(value={"/delete/link/{boardId}"})
    @ResponseBody
    public ResponseEntity removeLink(@RequestBody List<Map> links, @PathVariable String boardId) {
        HashMap<String, Constable> responseJson = new HashMap<String, Constable>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("boardId", boardId);
        params.put("items", links);
        responseJson.put("itemRemoved", Integer.valueOf(this.graphServiceImpl.removeLink(params)));
        responseJson.put("success", Boolean.valueOf(true));
        Long boardVersion = this.graphServiceImpl.incrementBoardVersion(boardId, null);
        if (boardVersion != null) {
            responseJson.put("boardVersion", boardVersion);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @DeleteMapping(value={"/public_share/delete/link/{tenant}/{boardId}/{extUserName}"})
    @ResponseBody
    public ResponseEntity removeLinkPublicShare(@RequestBody List<Map> links, @PathVariable String tenant, @PathVariable String boardId, @PathVariable String extUserName) {
        HashMap<String, Constable> responseJson = new HashMap<String, Constable>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("boardId", boardId);
        params.put("items", links);
        params.put("externalUserName", extUserName);
        params.put("tenant", tenant);
        responseJson.put("itemRemoved", Integer.valueOf(this.graphServiceImpl.removeLink(params)));
        responseJson.put("success", Boolean.valueOf(true));
        Long boardVersion = this.graphServiceImpl.incrementBoardVersion(boardId, tenant);
        if (boardVersion != null) {
            responseJson.put("boardVersion", boardVersion);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @DeleteMapping(value={"/delete/template/{id}"})
    @ResponseBody
    public ResponseEntity removeTemplate(@PathVariable String id) {
        HashMap<String, Integer> responseJson = new HashMap<String, Integer>();
        responseJson.put("itemRemoved", this.graphServiceImpl.removeTemplate(id));
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @PostMapping(value={"/board/thumbnail/{id}"})
    @ResponseBody
    public ResponseEntity uploadBoardthumbnail(@RequestBody String thumbnailData, @PathVariable String id) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        String boardId = this.graphServiceImpl.addThumbnailPath(thumbnailData, id);
        responseJson.put("success", true);
        responseJson.put("boardId", boardId);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @PostMapping(value={"/board/uploadImage"})
    @ResponseBody
    public ResponseEntity uploadImageToS3(@RequestBody String data) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        String path = this.graphServiceImpl.uploadImageToS3(data);
        responseJson.put("success", true);
        responseJson.put("path", path);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    private String getParam(String url, String name) {
        String params = url.substring(url.indexOf("?") + 1, url.length());
        Map split = Splitter.on((String)"&").withKeyValueSeparator("=").split((CharSequence)params);
        return (String)split.get(name);
    }

    @RequestMapping(value={"/mark-favorite"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity markFavorite(@RequestBody Map data) {
        HashMap<String, CanvasBoard> responseJson = new HashMap<String, CanvasBoard>();
        responseJson.put("board", this.graphServiceImpl.markBoardFavorite(data));
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/lock-board/{boardId}"}, method={RequestMethod.POST})
    public ResponseEntity<Object> lockUnLockBoard(@PathVariable String boardId) {
        HashMap<String, CanvasBoard> responseJson = new HashMap<String, CanvasBoard>();
        responseJson.put("board", this.graphServiceImpl.lockUnlockBoard(boardId));
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/archive-board/{boardId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity archiveUnarchiveBoard(@PathVariable String boardId) {
        HashMap<String, CanvasBoard> responseJson = new HashMap<String, CanvasBoard>();
        responseJson.put("board", this.graphServiceImpl.archiveUnarchiveBoard(boardId));
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/board/duplicate"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity duplicateBoard(@RequestBody Map board) {
        HashMap<String, CanvasBoard> responseJson = new HashMap<String, CanvasBoard>();
        responseJson.put("board", this.graphServiceImpl.duplicateBoard(board));
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/template/duplicate"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity duplicateTemplate(@RequestBody Map template) {
        try {
            HashMap<String, CanvasBoard> responseJson = new HashMap<String, CanvasBoard>();
            responseJson.put("template", this.graphServiceImpl.duplicateTemplate(template));
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    @RequestMapping(value={"/profile/"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity getUser() {
        HashMap<String, User> responseJson = new HashMap<String, User>();
        responseJson.put("user", this.graphServiceImpl.getLoggedInUser());
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/public_share/profile"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity getUserInfo() {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        responseJson.put("user", this.graphServiceImpl.getLoggedInUser());
        responseJson.put("userAccessRoles", this.graphServiceImpl.getLoggedInUserAccessRoles());
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/note/save"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity saveNote(@RequestBody Map data) {
        HashMap<String, CanvasNote> responseJson = new HashMap<String, CanvasNote>();
        responseJson.put("note", this.graphServiceImpl.saveNote(data));
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/note/{boardId}"}, method={RequestMethod.POST})
    public ResponseEntity<Object> getNote(@PathVariable String boardId) {
        HashMap<String, CanvasNote> responseJson = new HashMap<String, CanvasNote>();
        responseJson.put("note", this.graphServiceImpl.getNote(boardId));
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @PostMapping(value={"/public_share/upload-image"})
    public ResponseEntity<String> uploadImage(@RequestParam(value="file") MultipartFile file) {
        try {
            String fileId = this.attachmentService.uploadImage(file);
            LOGGER.debug("Upload image file: {}", (Object)fileId);
            return ResponseEntity.ok((Object)fileId);
        }
        catch (Exception e) {
            LOGGER.debug(StringUtils.getTraceString((Throwable)e));
            return ResponseEntity.status((int)500).body((Object)("Upload failed: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/public_share/retrieve-image/{id}"}, produces={"image/jpeg"})
    public ResponseEntity<byte[]> retrieveImage(@PathVariable String id) {
        try {
            GridFSDBFile file = this.mongoConfig.gridFsTemplate().findOne(new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)id)));
            if (file == null) {
                return ResponseEntity.notFound().build();
            }
            GridFsResource resource = this.gridFsTemplate.getResource(file.getFilename());
            DBObject metadata = file.getMetaData();
            String contentType = "image/png";
            if (metadata != null && metadata.get("_contentType") != null) {
                contentType = metadata.get("_contentType").toString();
            }
            return ResponseEntity.ok().contentType(MediaType.parseMediaType((String)contentType)).body((Object)IOUtils.toByteArray((InputStream)resource.getInputStream()));
        }
        catch (Exception e) {
            LOGGER.debug(StringUtils.getTraceString((Throwable)e));
            ResponseEntity.status((int)500).body((Object)("Retreival failed: " + e.getMessage()));
            return ResponseEntity.notFound().build();
        }
    }
}

