/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.viztrend.safe.controller.ExternalEntitiesController;
import com.viztrend.safe.controller.SosController;
import com.viztrend.safe.enums.EnumBaseItemTypes;
import com.viztrend.safe.enums.EnumKendis;
import com.viztrend.safe.persistence.entity.ActionPoint;
import com.viztrend.safe.persistence.entity.BaseItem;
import com.viztrend.safe.persistence.entity.BaseItemLink;
import com.viztrend.safe.persistence.entity.Company;
import com.viztrend.safe.persistence.entity.Conversation;
import com.viztrend.safe.persistence.entity.FieldTemplate;
import com.viztrend.safe.persistence.entity.Fields;
import com.viztrend.safe.persistence.entity.ItemTypeScheme;
import com.viztrend.safe.persistence.entity.Scrum;
import com.viztrend.safe.persistence.entity.ScrumOfScrums;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.Status;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.Watcher;
import com.viztrend.safe.persistence.entity.WorkFlow;
import com.viztrend.safe.persistence.repository.BaseItemLinkRepository;
import com.viztrend.safe.persistence.repository.BaseItemRepository;
import com.viztrend.safe.persistence.repository.CompanyRepository;
import com.viztrend.safe.persistence.repository.CustomRepository;
import com.viztrend.safe.persistence.repository.FieldTemplateRepository;
import com.viztrend.safe.persistence.repository.FieldsRepository;
import com.viztrend.safe.persistence.repository.ItemTypeRepository;
import com.viztrend.safe.persistence.repository.ItemTypeSchemeRepository;
import com.viztrend.safe.persistence.repository.ScrumOfScrumsRepository;
import com.viztrend.safe.persistence.repository.ScrumRepository;
import com.viztrend.safe.persistence.repository.SessionRepository;
import com.viztrend.safe.persistence.repository.SeverityRepository;
import com.viztrend.safe.persistence.repository.StatusRepository;
import com.viztrend.safe.persistence.repository.UserRepository;
import com.viztrend.safe.persistence.repository.WorkFlowRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceAccessRoleRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceRepository;
import com.viztrend.safe.service.CustomFieldService;
import com.viztrend.safe.service.ExternalEntitiesService;
import com.viztrend.safe.service.NotificationService;
import com.viztrend.safe.strategy.PushInclusionStrategy;
import com.viztrend.safe.utils.AlmUtils;
import com.viztrend.safe.utils.KendisUtils;
import com.viztrend.safe.utils.LocalMailSender;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.PushSender;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.UserContextUtil;
import java.io.File;
import java.io.Serializable;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@RequestMapping(value={"/external-entitites"})
@Controller
public class ExternalEntitiesController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalEntitiesController.class);
    @Autowired
    private ExternalEntitiesService externalEntitiesService;
    @Autowired
    private FieldTemplateRepository fieldTemplateRepository;
    @Autowired
    private CustomRepository<Object> customRepository;
    @Autowired
    private CompanyRepository companyRepository;
    @Autowired
    private BaseItemRepository baseItemRepository;
    @Autowired
    private FieldsRepository fieldsRepository;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private ScrumOfScrumsRepository sosRepository;
    @Autowired
    private SeverityRepository severityRepository;
    @Autowired
    private StatusRepository statusRepository;
    @Autowired
    private WorkFlowRepository workFlowRepository;
    @Autowired
    private WorkSpaceAccessRoleRepository accessRoleRepository;
    @Autowired
    private WorkSpaceRepository workSpaceRepository;
    @Autowired
    private BaseItemLinkRepository baseItemLinkRepository;
    @Autowired
    private SessionRepository sessionRepository;
    @Autowired
    private LocalMailSender mailSender;
    @Autowired
    private ItemTypeSchemeRepository itemTypeSchemeRepository;
    @Autowired
    private ItemTypeRepository itemTypeRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private NotificationService notificationService;
    @Autowired
    private CustomFieldService customFieldService;
    @Autowired
    private ScrumRepository scrumRepository;

    @RequestMapping(value={"/kendis-fields"}, method={RequestMethod.POST})
    public ResponseEntity<Object> loadKendisFields(@RequestBody Map<String, String> param) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            String type = param.get("type");
            responseJson.put(type, this.customFieldService.getKendisCustomFieldsFromDefaultLayout(type));
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"conversation/save"}, method={RequestMethod.POST})
    public ResponseEntity<Object> saveConversation(@RequestBody Conversation inputConversation) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        if (!PropertyValidator.isValid((Object)inputConversation.getEntityId()) && !PropertyValidator.isValid((Object)inputConversation.getEntityType())) {
            responseJson.put("success", false);
            responseJson.put("reason", "Invalid Input");
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        try {
            Conversation savedConversation = this.externalEntitiesService.saveConversation(inputConversation);
            responseJson.put("conversation", savedConversation);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"conversation/save/emoji"}, method={RequestMethod.POST})
    public ResponseEntity<Object> saveEmojiConversation(@RequestBody Conversation inputConversation) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        if (!PropertyValidator.isValid((Object)inputConversation.getEntityId()) && !PropertyValidator.isValid((Object)inputConversation.getEntityType())) {
            responseJson.put("success", false);
            responseJson.put("reason", "Invalid Input");
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        try {
            Conversation savedConversation = this.externalEntitiesService.saveEmojiConversation(inputConversation);
            responseJson.put("conversation", savedConversation);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"conversation/fetch"}, method={RequestMethod.POST})
    public ResponseEntity<Object> fetchConversation(@RequestBody HashMap<String, Object> requestBody) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        if (!PropertyValidator.isValid((Object)requestBody.get("entityId")) && !PropertyValidator.isValid((Object)requestBody.get("entityType"))) {
            responseJson.put("success", false);
            responseJson.put("reason", "Invalid Input");
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        try {
            List savedConversation = this.externalEntitiesService.fetchConversation(requestBody);
            responseJson.put("conversation", savedConversation);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"conversation/fetch/count"}, method={RequestMethod.POST})
    public ResponseEntity<Object> fetchConversationCount(@RequestBody HashMap<String, Object> requestBody) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        if (!PropertyValidator.isValid((Object)requestBody.get("entityId")) && !PropertyValidator.isValid((Object)requestBody.get("entityType"))) {
            responseJson.put("success", false);
            responseJson.put("reason", "Invalid Input");
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        try {
            Long savedConversationCount = this.externalEntitiesService.fetchConversationCount(requestBody);
            responseJson.put("count", savedConversationCount);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"conversation/delete/{conversationId}"}, method={RequestMethod.DELETE})
    public ResponseEntity<Object> deleteConversation(@PathVariable(value="conversationId") String conversationId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        if (!PropertyValidator.isValid((Object)conversationId)) {
            responseJson.put("success", false);
            responseJson.put("reason", "Invalid Input");
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        try {
            this.externalEntitiesService.deleteConversation(conversationId);
            responseJson.put("success", true);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"watchers/get-watchers"}, method={RequestMethod.POST})
    public ResponseEntity<Object> getWatchers(@RequestBody HashMap<String, String> requestBody) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        if (!PropertyValidator.isValid((Object)requestBody.get("entityId")) && !PropertyValidator.isValid((Object)requestBody.get("entityType"))) {
            responseJson.put("success", false);
            responseJson.put("reason", "Invalid Input");
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        try {
            List savedWatchers = this.externalEntitiesService.fetchWatchers(requestBody);
            responseJson.put("watchers", savedWatchers);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"watchers/search-watchers/{title}"}, method={RequestMethod.GET})
    public ResponseEntity<Object> getWatchersByTitleSearch(@PathVariable String title) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        if (!PropertyValidator.isValid((Object)title)) {
            responseJson.put("success", false);
            responseJson.put("reason", "Invalid Input");
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        try {
            List savedWatchers = this.externalEntitiesService.getWatchersByTitleSearch(title);
            responseJson.put("watchers", savedWatchers);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"watchers/save-watcher"}, method={RequestMethod.POST})
    public ResponseEntity<Object> saveWatcher(@RequestBody Watcher inputWatcher) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        if (!PropertyValidator.isValid((Object)inputWatcher)) {
            responseJson.put("success", false);
            responseJson.put("reason", "Invalid Input");
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        try {
            Watcher savedWatcher = this.externalEntitiesService.saveWatcher(inputWatcher);
            responseJson.put("watchers", savedWatcher);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"watchers/save-watchers/{entityId}/{entityType}"}, method={RequestMethod.POST})
    public ResponseEntity<Object> saveWatchers(@RequestBody List<String> inputWatchers, @PathVariable(value="entityType") String entityType, @PathVariable(value="entityId") String entityId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            if (!PropertyValidator.isValid(inputWatchers)) {
                responseJson.put("success", false);
                responseJson.put("reason", "Invalid Input");
                return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
            }
            List savedWatchers = this.externalEntitiesService.saveWatchers(inputWatchers, entityId, entityType);
            responseJson.put("watchers", savedWatchers);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"watchers/delete-watcher/{watcherId}"}, method={RequestMethod.POST})
    public ResponseEntity<Object> deleteWatcher(@PathVariable String watcherId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        if (!PropertyValidator.isValid((Object)watcherId)) {
            responseJson.put("success", false);
            responseJson.put("reason", "Invalid Input");
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        try {
            this.externalEntitiesService.deleteWatcher(watcherId);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity(HttpStatus.OK);
    }

    @RequestMapping(value={"history/fetch-history"}, method={RequestMethod.POST})
    public ResponseEntity<Object> fetchHistory(@RequestBody HashMap<String, String> requestBody) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        if (!PropertyValidator.isValid((Object)requestBody.get("entityId")) && !PropertyValidator.isValid((Object)requestBody.get("entityType"))) {
            responseJson.put("success", false);
            responseJson.put("reason", "Invalid Input");
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        try {
            if (requestBody.get("entityType").equals("BacklogItem")) {
                List backlogItemHistory = this.externalEntitiesService.fetchBacklogItemHistory(requestBody);
                responseJson.put("history", backlogItemHistory);
            } else {
                List entityHistory = this.externalEntitiesService.fetchHistory(requestBody);
                responseJson.put("history", entityHistory);
            }
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/export-description"}, method={RequestMethod.POST})
    public ResponseEntity<Object> exportSOS(@RequestBody HashMap<String, Object> requestBody) {
        String downloadName = "";
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            if (PropertyValidator.isValid((Object)requestBody.get("descriptionHTML"))) {
                String html = (String)requestBody.get("descriptionHTML");
                String filePath = this.mailSender.generateDescriptionPDF(html);
                File responsefile = new File(filePath);
                HttpHeaders headers = new HttpHeaders();
                headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
                headers.add("Pragma", "no-cache");
                headers.add("Expires", "0");
                headers.add("Content-Disposition", "attachment; filename=" + responsefile.getName());
                LOGGER.debug("download invoice step 4");
                if (PropertyValidator.isValid((Object)filePath)) {
                    SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy");
                    downloadName = AlmUtils.cleanText((String)("SOS" + formatter.format(new Date()))) + ".pdf";
                    if (PropertyValidator.isValid((Object)downloadName)) {
                        response.put("srcPath", URLEncoder.encode(filePath, "UTF-8"));
                        response.put("name", downloadName);
                        return new ResponseEntity(response, HttpStatus.OK);
                    }
                    response.put("message", "Something went wrong");
                    return new ResponseEntity(response, HttpStatus.BAD_REQUEST);
                }
            }
        }
        catch (Exception ex) {
            response.put("kendisError", ex);
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
        return new ResponseEntity(response, HttpStatus.BAD_REQUEST);
    }

    @RequestMapping(value={"send-email-notification"}, method={RequestMethod.POST})
    public ResponseEntity<Object> sendEmailNotification(@RequestBody HashMap<String, Object> requestBody) {
        this.externalEntitiesService.sendEmailNotitication(requestBody);
        return null;
    }

    @RequestMapping(value={"/base-items"}, method={RequestMethod.POST})
    public ResponseEntity<Object> getDynamicItemByType(@RequestBody HashMap<String, Object> requestBody) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        Query query = new Query();
        try {
            List types = (List)requestBody.get("types");
            String fieldId = (String)requestBody.get("fieldId");
            String sosId = (String)requestBody.get("sosId");
            String sessionId = (String)requestBody.get("sessionId");
            String type = (String)requestBody.get("type");
            String getType = (String)requestBody.get("getType");
            ArrayList<ObjectId> impContainerIds = new ArrayList<ObjectId>();
            List impedimentContainers = new ArrayList();
            impedimentContainers = PropertyValidator.isValid((Object)getType) ? this.baseItemLinkRepository.findBySessionId(sessionId) : this.baseItemLinkRepository.findByScrumOfScrumId(sosId);
            for (BaseItemLink ic : impedimentContainers) {
                impContainerIds.add(new ObjectId(ic.getId()));
            }
            if (PropertyValidator.isValid((Collection)types)) {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"baseItemLinks.$id").in(impContainerIds));
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").in((Collection)types));
            } else if (PropertyValidator.isValid((Object)type)) {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)type));
            } else {
                return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
            }
            if (fieldId != null) {
                boolean ascOrder = (Boolean)requestBody.get("ASC");
                query.with(new Sort(ascOrder ? Sort.Direction.ASC : Sort.Direction.DESC, new String[]{"fields." + fieldId}));
            }
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"parent").exists(false));
            List baseItemList = this.mongoTemplate.find(query, BaseItem.class);
            responseJson.put("items", baseItemList);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return new ResponseEntity(responseJson, HttpStatus.ACCEPTED);
    }

    private String getDefaultStatusByCategory(String category, String wfId) throws Exception {
        WorkFlow workFlow = (WorkFlow)this.workFlowRepository.findOne((Serializable)((Object)wfId));
        String statusId = null;
        if (PropertyValidator.isValid((Object)workFlow)) {
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"workFlow.$id").is((Object)new ObjectId(workFlow.getId())));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"category").is((Object)category));
            List statuses = this.mongoTemplate.find(query, Status.class);
            if (PropertyValidator.isValid((Collection)statuses)) {
                if (PropertyValidator.isValid((Object)workFlow.getStatusSequence())) {
                    String[] ordered;
                    HashMap<String, Boolean> statusMap = new HashMap<String, Boolean>();
                    for (Status status : statuses) {
                        statusMap.put(status.getId(), true);
                    }
                    for (String st : ordered = workFlow.getStatusSequence().split(",")) {
                        if (!statusMap.containsKey(st)) continue;
                        statusId = st;
                        break;
                    }
                    ordered = null;
                    statusMap.clear();
                } else {
                    statusId = ((Status)statuses.get(0)).getId();
                }
                statuses.clear();
            }
        }
        if (statusId == null) {
            throw new Exception("Invalid Status found");
        }
        return statusId;
    }

    @RequestMapping(value={"/save-base-item/{action}"}, method={RequestMethod.POST})
    public ResponseEntity<Object> saveImpediment(@RequestBody BaseItem inputItem, @PathVariable(value="action") String action) {
        HashMap<String, Object> responseJson;
        block125: {
            responseJson = new HashMap<String, Object>();
            HashMap<String, Object> pushJson = new HashMap<String, Object>();
            HashMap pushMeta = new HashMap();
            Gson gson = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).addDeserializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).create();
            ObjectMapper mapper = new ObjectMapper();
            1 T = new /* Unavailable Anonymous Inner Class!! */;
            if (PropertyValidator.isValid((Object)inputItem.getMetaMap())) {
                pushMeta = (HashMap)gson.fromJson(inputItem.getMetaMap(), T.getType());
            }
            String sosId = null;
            String scrumId = null;
            if (PropertyValidator.isValid(pushMeta) && pushMeta.containsKey("sosId")) {
                sosId = (String)pushMeta.get("sosId");
                scrumId = (String)pushMeta.get("scrumId");
            }
            String responsibleFieldId = "";
            HashMap<String, Object> pushData = new HashMap<String, Object>();
            HashMap<String, Object> emailContent = new HashMap<String, Object>();
            HashMap<String, Object> objEmailContent = new HashMap<String, Object>();
            ScrumOfScrums sctumOfscrum = null;
            String workSpaceId = null;
            try {
                if (PropertyValidator.isValid((Object)sosId) && !sosId.equals("0")) {
                    sctumOfscrum = (ScrumOfScrums)this.sosRepository.findOne((Serializable)((Object)sosId));
                    ArrayList<String> sids = new ArrayList<String>();
                    sids.add(sctumOfscrum.getSessionId());
                    List sessions = this.sessionRepository.findSessionByIdIn(sids);
                    if (PropertyValidator.isValid((Collection)sessions)) {
                        workSpaceId = ((Session)sessions.get(0)).getWorkSpace().getId();
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
            List restrictions = KendisUtils.getRestrictions((WorkSpaceRepository)this.workSpaceRepository, (WorkSpaceAccessRoleRepository)this.accessRoleRepository, workSpaceId);
            String type = "";
            try {
                if ((EnumBaseItemTypes.BATCH.getName().equals(inputItem.getType()) || EnumBaseItemTypes.BATCH_GROUP.getName().equals(inputItem.getType())) && PropertyValidator.isValid((Object)inputItem.getId())) {
                    BaseItem savedbaseItem = this.baseItemRepository.findById(inputItem.getId());
                    inputItem.setBaseItemList(savedbaseItem.getBaseItemList());
                    inputItem.setLinkedItems(savedbaseItem.getLinkedItems());
                }
                if (inputItem.getStatus() != null && inputItem.getStatus().getId() == null && PropertyValidator.isValid((Object)inputItem.getStatus().getWorkFlow())) {
                    inputItem.getStatus().setId(this.getDefaultStatusByCategory(inputItem.getStatus().getCategory(), inputItem.getStatus().getWorkFlow().getId()));
                }
                if (!PropertyValidator.isValid((Object)inputItem.getId())) {
                    if (WorkFlow.WorkFlowType.Impediment.name().equals(inputItem.getType())) {
                        type = "impediments";
                    } else if (WorkFlow.WorkFlowType.ActionPoint.name().equals(inputItem.getType())) {
                        type = "action-points";
                    } else if (EnumKendis.MILESTONE.getCode().equals(inputItem.getType()) || EnumKendis.PHASES.getCode().equals(inputItem.getType())) {
                        type = EnumKendis.MILESTONE.getCode();
                        type = type.toLowerCase();
                    } else if (EnumKendis.OBJECTIVE.getCode().contains(inputItem.getType())) {
                        type = EnumKendis.OBJECTIVE.getCode();
                    } else if (EnumKendis.OBJECTIVE_KEY_RESULT.getCode().contains(inputItem.getType())) {
                        type = EnumKendis.OBJECTIVE_KEY_RESULT.getCode();
                    }
                    if (KendisUtils.isActionAllowed((String)("add-" + type), (List)restrictions)) {
                        HashMap itemValidation;
                        FieldTemplate itemFieldTemplate;
                        if (!"custom-objective-save".equalsIgnoreCase(action) && !PropertyValidator.isValid((Collection)inputItem.getBaseItemLinks())) {
                            responseJson.put("success", false);
                            responseJson.put("reason", "Impediment Containers not found");
                            return new ResponseEntity(responseJson, HttpStatus.OK);
                        }
                        if (type.equals("impediments") || type.equals("action-points")) {
                            BaseItemLink systemLink = new BaseItemLink((BaseItemLink)inputItem.getBaseItemLinks().get(0));
                            systemLink.setIsSystemLink(Boolean.valueOf(true));
                            inputItem.getBaseItemLinks().add(systemLink);
                        } else if (EnumKendis.OBJECTIVE.getCode().equals(type) || EnumKendis.OBJECTIVE_KEY_RESULT.getCode().equals(type)) {
                            for (BaseItemLink baseItemLink : inputItem.getBaseItemLinks()) {
                                if (!PropertyValidator.isValid((Object)baseItemLink) || PropertyValidator.isValid((Object)baseItemLink.getLinkType())) continue;
                                baseItemLink.setLinkType(EnumKendis.SESSION_LINK_OBJECTIVE.getCode());
                            }
                        }
                        if (PropertyValidator.isValid((Object)inputItem.getFieldsTemplate()) && PropertyValidator.isValid((Object)(itemFieldTemplate = (FieldTemplate)this.fieldTemplateRepository.findOne((Serializable)((Object)inputItem.getFieldsTemplate().getId()))))) {
                            inputItem.putValues(inputItem.getFields(), itemFieldTemplate);
                        }
                        if (PropertyValidator.isValid((Object)(itemValidation = this.externalEntitiesService.validateBaseItem(inputItem))) && !itemValidation.isEmpty()) {
                            Set invalidValuesKeys = itemValidation.keySet();
                            responseJson.put("invalidFields", invalidValuesKeys);
                            responseJson.put("error", true);
                            responseJson.put("reason", "Invalid field values passed");
                            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
                        }
                        if (PropertyValidator.isValid((Collection)inputItem.getBaseItemLinks())) {
                            List newImpedimentContainers = this.baseItemLinkRepository.save((Iterable)inputItem.getBaseItemLinks());
                            inputItem.setBaseItemLinks(newImpedimentContainers);
                        }
                        if (inputItem.getType().toLowerCase().contains(EnumKendis.OBJECTIVE.name().toLowerCase())) {
                            inputItem.setKey(this.customRepository.generateKey(EnumKendis.OBJECTIVE.getCode()));
                        } else if (inputItem.getType().toLowerCase().contains(EnumKendis.OBJECTIVE_KEY_RESULT.getCode().toLowerCase())) {
                            inputItem.setKey(this.customRepository.generateKey(EnumKendis.OBJECTIVE_KEY_RESULT.getCode()));
                        } else {
                            inputItem.setKey(this.customRepository.generateKey(inputItem.getType()));
                        }
                        BaseItem savedImpediment = (BaseItem)this.baseItemRepository.save((Object)inputItem);
                        if (PropertyValidator.isValid((Collection)inputItem.getMentionUsers()) && inputItem.getMentionUsers().size() > 0) {
                            emailContent.put("key", savedImpediment.getKey());
                            emailContent.put("Item-type", type == "action-points" ? "Action Point" : "Impediment");
                            emailContent.put("Item-detail", savedImpediment.getTitle());
                            emailContent.put("emailList", inputItem.getMentionUsers());
                            emailContent.put("emailType", "mention-user");
                            this.externalEntitiesService.sendEmailNotitication(emailContent);
                        }
                        pushJson.put("action", "impedimentAndActionPointCreate");
                        pushData.put("savedImpediment", savedImpediment);
                        pushJson.put("data", pushData);
                        responseJson.put("impediment", savedImpediment);
                    }
                } else {
                    BaseItem oldImpediment = (BaseItem)this.baseItemRepository.findOne((Serializable)((Object)inputItem.getId()));
                    ArrayList<String> changedProperties = new ArrayList<String>();
                    if (!PropertyValidator.isValid((Object)oldImpediment)) {
                        HashMap<String, String> e = new HashMap<String, String>();
                        e.put("message", "Item not found. This may be because the item has been deleted from another location");
                        responseJson.put("kendisError", e);
                        return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
                    }
                    if (oldImpediment.getType().equals(WorkFlow.WorkFlowType.Impediment.name())) {
                        type = "impediments";
                    } else if (oldImpediment.getType().equals(WorkFlow.WorkFlowType.ActionPoint.name())) {
                        type = "action-points";
                    } else if (oldImpediment.getType().contains(WorkFlow.WorkFlowType.Objective.name())) {
                        type = "Objective";
                    } else if (oldImpediment.getType().equals(EnumKendis.MILESTONE.getCode()) || oldImpediment.getType().equals(EnumKendis.PHASES.getCode())) {
                        type = EnumKendis.MILESTONE.getCode();
                        type = type.toLowerCase();
                    }
                    if (KendisUtils.isActionAllowed((String)("edit-" + type), (List)restrictions)) {
                        HashMap itemValidation;
                        FieldTemplate itemFieldTemplate;
                        if (PropertyValidator.isValid((Object)inputItem.getTitle())) {
                            if (!oldImpediment.getTitle().trim().equals(inputItem.getTitle().trim())) {
                                changedProperties.add("Title");
                                objEmailContent.put("title", inputItem.getTitle());
                            }
                            oldImpediment.setTitle(inputItem.getTitle());
                        }
                        if (PropertyValidator.isValid((Object)inputItem.getDescription()) || "".equals(inputItem.getDescription())) {
                            String newDesc;
                            String oldDesc = oldImpediment.getDescription();
                            if (!Objects.equals(oldDesc, newDesc = inputItem.getDescription())) {
                                changedProperties.add("Description");
                                objEmailContent.put("description", inputItem.getDescription());
                            }
                            oldImpediment.setDescription(inputItem.getDescription());
                        }
                        if (PropertyValidator.isValid((Object)inputItem.getBvActual())) {
                            Double newBvActual;
                            Double oldBvActual = oldImpediment.getBvActual();
                            if (!Objects.equals(oldBvActual, newBvActual = inputItem.getBvActual())) {
                                changedProperties.add("BV Actual");
                                objEmailContent.put("bvActual", inputItem.getBvActual());
                            }
                            oldImpediment.setBvActual(inputItem.getBvActual());
                        }
                        if (PropertyValidator.isValid((Object)inputItem.getBvPlan())) {
                            Double newBvPlan;
                            Double oldBvPlan = oldImpediment.getBvPlan();
                            if (!Objects.equals(oldBvPlan, newBvPlan = inputItem.getBvPlan())) {
                                changedProperties.add("BV Plan");
                                objEmailContent.put("bvPlan", inputItem.getBvPlan());
                            }
                            oldImpediment.setBvPlan(inputItem.getBvPlan());
                        }
                        if (PropertyValidator.isValid((Object)inputItem.getSequence())) {
                            Double newSequence;
                            Double oldSequence = oldImpediment.getSequence();
                            if (!Objects.equals(oldSequence, newSequence = inputItem.getSequence())) {
                                changedProperties.add("Sequence");
                            }
                            oldImpediment.setSequence(inputItem.getSequence());
                        }
                        if (PropertyValidator.isValid((Object)inputItem.getType()) || "".equals(inputItem.getType())) {
                            String newType;
                            String oldType = oldImpediment.getType();
                            if (!Objects.equals(oldType, newType = inputItem.getType())) {
                                changedProperties.add("Type");
                                if (inputItem.getType().equals(EnumKendis.OBJECTIVE.getCode() + "-Committed")) {
                                    objEmailContent.put("type", "Committed");
                                } else if (inputItem.getType().equals(EnumKendis.OBJECTIVE.getCode() + "-Uncommitted")) {
                                    objEmailContent.put("type", "Uncommitted");
                                }
                            }
                            oldImpediment.setType(inputItem.getType());
                        }
                        if (PropertyValidator.isValid((Object)inputItem.getCompletionCriteria()) || "".equals(inputItem.getCompletionCriteria())) {
                            String oldCompletionCriteria = oldImpediment.getCompletionCriteria();
                            String enumCompletionCriteria = EnumKendis.valueOf((String)inputItem.getCompletionCriteria()).name();
                            if (enumCompletionCriteria != null && !enumCompletionCriteria.isEmpty()) {
                                if (!Objects.equals(oldCompletionCriteria, enumCompletionCriteria)) {
                                    changedProperties.add("Completion Criteria");
                                    objEmailContent.put("completionCriteria", inputItem.getCompletionCriteria());
                                }
                                oldImpediment.setCompletionCriteria(enumCompletionCriteria);
                            } else {
                                responseJson.put("error", true);
                                responseJson.put("reason", "Invalid completion criteria.");
                                return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
                            }
                        }
                        if (PropertyValidator.isValid((Object)inputItem.getStatus())) {
                            if (PropertyValidator.isValid((Object)oldImpediment.getStatus()) && PropertyValidator.isValid((Object)oldImpediment.getStatus().getId())) {
                                String newStatusId;
                                String oldStatusId = oldImpediment.getStatus().getId();
                                if (!oldStatusId.equals(newStatusId = inputItem.getStatus().getId())) {
                                    changedProperties.add("Status");
                                    objEmailContent.put("status", inputItem.getStatus().getTitle());
                                }
                            } else {
                                changedProperties.add("Status");
                            }
                            oldImpediment.setStatus(inputItem.getStatus());
                        }
                        if (!PropertyValidator.isValid((Object)oldImpediment.getItemType()) && !PropertyValidator.isValid((Object)oldImpediment.getFieldsTemplate())) {
                            oldImpediment.setFieldsTemplate(new FieldTemplate("0", WorkFlow.WorkFlowType.Impediment.name()));
                        }
                        if (PropertyValidator.isValid((Object)inputItem.getStarred())) {
                            if (!oldImpediment.getStarred().equals(inputItem.getStarred())) {
                                changedProperties.add("Starred");
                            }
                            oldImpediment.setStarred(inputItem.getStarred());
                        }
                        if (PropertyValidator.isValid((Object)inputItem.getFieldsTemplate()) && PropertyValidator.isValid((Object)(itemFieldTemplate = (FieldTemplate)this.fieldTemplateRepository.findOne((Serializable)((Object)inputItem.getFieldsTemplate().getId()))))) {
                            oldImpediment.putValues(inputItem.getFields(), itemFieldTemplate);
                        }
                        if (PropertyValidator.isValid((Object)inputItem.getNotifyWatchers())) {
                            oldImpediment.setNotifyWatchers(inputItem.getNotifyWatchers());
                        }
                        if ((EnumBaseItemTypes.BATCH_GROUP.getName().equals(inputItem.getType()) || EnumBaseItemTypes.OBJECTIVE_GROUP.getName().equals(inputItem.getType())) && PropertyValidator.isValid((Object)inputItem.getId()) && PropertyValidator.isValid((Object)inputItem.getHeaderColor())) {
                            String newHeaderColor;
                            String oldHeaderColor = oldImpediment.getHeaderColor();
                            if (!Objects.equals(oldHeaderColor, newHeaderColor = inputItem.getHeaderColor())) {
                                changedProperties.add("Header Color");
                            }
                            oldImpediment.setHeaderColor(inputItem.getHeaderColor());
                        }
                        if (EnumBaseItemTypes.BATCH_GROUP.getName().equals(inputItem.getType()) && PropertyValidator.isValid((Object)inputItem.getImageIcon())) {
                            oldImpediment.setImageIcon(inputItem.getImageIcon());
                        }
                        if (PropertyValidator.isValid((Object)inputItem.getFields())) {
                            Map oldImpdtFields;
                            Map inputImpdtFields = inputItem.getFields();
                            if (!inputImpdtFields.equals(oldImpdtFields = oldImpediment.getFields())) {
                                List oldConfiguredFields = null;
                                if (PropertyValidator.isValid((Object)oldImpediment.getFieldsTemplate())) {
                                    oldConfiguredFields = oldImpediment.getFieldsTemplate().getConfiguredFields();
                                } else {
                                    ItemTypeScheme itemTypeScheme = this.itemTypeSchemeRepository.findByItemType(oldImpediment.getItemType());
                                    if (PropertyValidator.isValid((Object)itemTypeScheme)) {
                                        oldConfiguredFields = itemTypeScheme.getFieldsTemplate().getConfiguredFields();
                                    }
                                }
                                HashMap<String, Fields> oldFieldsMap = new HashMap<String, Fields>();
                                if (PropertyValidator.isValid((Collection)oldConfiguredFields)) {
                                    for (Fields fields : oldConfiguredFields) {
                                        if (!(PropertyValidator.isValid((Collection)fields.getGroupFields()) || PropertyValidator.isValid((Object)fields.getIsGroup()) && fields.getIsGroup().booleanValue())) {
                                            oldFieldsMap.put(fields.getId(), fields);
                                            continue;
                                        }
                                        for (Fields groupField : fields.getGroupFields()) {
                                            oldFieldsMap.put(groupField.getId(), groupField);
                                            if (!groupField.getTitle().equals("Responsible")) continue;
                                            responsibleFieldId = groupField.getId();
                                        }
                                    }
                                }
                                for (Map.Entry entry : inputImpdtFields.entrySet()) {
                                    boolean fieldExists = false;
                                    if (PropertyValidator.isValid((Object)oldImpdtFields)) {
                                        fieldExists = oldImpdtFields.containsKey(entry.getKey());
                                    }
                                    if (fieldExists) {
                                        Fields changedField;
                                        Object oldFieldValue = oldImpdtFields.get(entry.getKey());
                                        Object newFieldValue = entry.getValue();
                                        boolean isEqual = true;
                                        isEqual = !PropertyValidator.isValid(oldFieldValue) ? false : oldFieldValue.equals(newFieldValue);
                                        if (isEqual || !PropertyValidator.isValid((Object)(changedField = (Fields)oldFieldsMap.get(entry.getKey())))) continue;
                                        changedProperties.add(changedField.getTitle());
                                        continue;
                                    }
                                    Fields changedField = (Fields)oldFieldsMap.get(entry.getKey());
                                    if (!PropertyValidator.isValid((Object)changedField)) continue;
                                    changedProperties.add(changedField.getTitle());
                                }
                            }
                            oldImpediment.setFields(inputItem.getFields());
                        }
                        if (PropertyValidator.isValid((Object)oldImpediment.getItemType())) {
                            inputItem.setItemType(oldImpediment.getItemType());
                        }
                        if (PropertyValidator.isValid((Object)(itemValidation = this.externalEntitiesService.validateBaseItem(oldImpediment))) && !itemValidation.isEmpty()) {
                            Set invalidValuesKeys = itemValidation.keySet();
                            responseJson.put("invalidFields", invalidValuesKeys);
                            responseJson.put("error", true);
                            responseJson.put("reason", "Invalid field values passed");
                            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
                        }
                        if (PropertyValidator.isValid((Collection)inputItem.getMentionUsers()) && inputItem.getMentionUsers().size() > 0) {
                            emailContent.put("key", oldImpediment.getKey());
                            emailContent.put("Item-type", type == "action-points" ? "Action Point" : "Impediment");
                            emailContent.put("Item-detail", oldImpediment.getTitle());
                            emailContent.put("emailList", inputItem.getMentionUsers());
                            emailContent.put("emailType", "mention-user");
                        }
                        if ((type.equals(EnumKendis.OBJECTIVE.getCode()) || type.equals(EnumKendis.OBJECTIVE_KEY_RESULT.getCode())) && PropertyValidator.isValid((Collection)inputItem.getBaseItemLinks())) {
                            for (BaseItemLink baseItemLink : inputItem.getBaseItemLinks()) {
                                if (!PropertyValidator.isValid((Object)baseItemLink) || PropertyValidator.isValid((Object)baseItemLink.getLinkType())) continue;
                                baseItemLink.setLinkType(EnumKendis.SESSION_LINK_OBJECTIVE.getCode());
                            }
                        }
                        if (PropertyValidator.isValid((Collection)inputItem.getBaseItemLinks())) {
                            ArrayList<String> impedimentContainerIdsToDelete = new ArrayList<String>();
                            List inputImpedimentContainers = inputItem.getBaseItemLinks();
                            List oldImpedimentContainers = oldImpediment.getBaseItemLinks();
                            List newImpedimentContainers = new ArrayList<BaseItemLink>();
                            for (BaseItemLink oldIc2 : oldImpedimentContainers) {
                                String oldSessionId = oldIc2.getSessionId();
                                String oldTeamId = oldIc2.getTeamId();
                                String oldSprintId = oldIc2.getSprintId();
                                String oldBaseItemId = oldIc2.getBaseItemId();
                                for (BaseItemLink inIc : inputImpedimentContainers) {
                                    boolean containerExists;
                                    String inSessionId = inIc.getSessionId();
                                    String inTeamId = inIc.getTeamId();
                                    String inSprintId = inIc.getSprintId();
                                    String inBaseItemId = inIc.getBaseItemId();
                                    Boolean isSave = false;
                                    if (PropertyValidator.isValid((Object)oldIc2.getType()) && oldIc2.getType().equalsIgnoreCase(inIc.getType())) {
                                        if (PropertyValidator.isValid((Object)oldIc2.getLayout())) {
                                            if (!oldIc2.getLayout().equals((Object)inIc.getLayout())) {
                                                oldIc2.setLayout(inIc.getLayout());
                                                isSave = true;
                                            }
                                        } else if (PropertyValidator.isValid((Object)inIc.getLayout())) {
                                            oldIc2.setLayout(inIc.getLayout());
                                            isSave = true;
                                        }
                                        if (PropertyValidator.isValid((Object)oldIc2.getChildLayout())) {
                                            if (!oldIc2.getChildLayout().equals((Object)inIc.getChildLayout())) {
                                                oldIc2.setChildLayout(inIc.getChildLayout());
                                                isSave = true;
                                            }
                                        } else if (PropertyValidator.isValid((Object)inIc.getChildLayout())) {
                                            oldIc2.setChildLayout(inIc.getChildLayout());
                                            isSave = true;
                                        }
                                        if (!isSave.booleanValue()) continue;
                                        this.baseItemLinkRepository.save((Object)oldIc2);
                                        continue;
                                    }
                                    boolean bl = containerExists = Objects.equals(oldSessionId, inSessionId) && Objects.equals(oldTeamId, inTeamId) && Objects.equals(oldSprintId, inSprintId) && Objects.equals(oldBaseItemId, inBaseItemId);
                                    if (containerExists && inIc.getDeleted() && !PropertyValidator.isValid((Object)inIc.getIsSystemLink())) {
                                        if (!PropertyValidator.isValid((Object)oldIc2.getIsSystemLink()) || PropertyValidator.isValid((Object)oldIc2.getIsSystemLink()) && !oldIc2.getIsSystemLink().booleanValue()) {
                                            impedimentContainerIdsToDelete.add(oldIc2.getId());
                                        }
                                        inIc.setId(oldIc2.getId());
                                    }
                                    if (!containerExists) continue;
                                    inIc.setId(oldIc2.getId());
                                }
                            }
                            if (PropertyValidator.isValid(impedimentContainerIdsToDelete)) {
                                this.baseItemLinkRepository.deleteByIdIn(impedimentContainerIdsToDelete);
                            }
                            oldImpedimentContainers = oldImpedimentContainers.stream().filter(oldIc -> !impedimentContainerIdsToDelete.contains(oldIc.getId())).collect(Collectors.toList());
                            HashSet<String> hashSet = new HashSet<String>();
                            for (BaseItemLink inIc : inputImpedimentContainers) {
                                if (PropertyValidator.isValid((Object)inIc.getId())) continue;
                                newImpedimentContainers.add(inIc);
                                hashSet.add(inIc.getSessionId());
                            }
                            List savedSos = new ArrayList();
                            ArrayList sessionIdsForNewIc = new ArrayList(hashSet);
                            savedSos = this.sosRepository.findBySessionIdInAndEndedOn(sessionIdsForNewIc, null);
                            if (PropertyValidator.isValid(newImpedimentContainers) && PropertyValidator.isValid(savedSos)) {
                                for (ScrumOfScrums sos : savedSos) {
                                    for (BaseItemLink baseItemLink : newImpedimentContainers) {
                                        if (!sos.getSessionId().equals(baseItemLink.getSessionId())) continue;
                                        baseItemLink.setScrumOfScrumId(sos.getId());
                                    }
                                }
                            }
                            newImpedimentContainers = this.baseItemLinkRepository.save(newImpedimentContainers);
                            oldImpedimentContainers.addAll(newImpedimentContainers);
                            oldImpediment.setBaseItemLinks(oldImpedimentContainers);
                        }
                        inputItem = oldImpediment;
                        BaseItem savedImpediment = (BaseItem)this.baseItemRepository.save((Object)inputItem);
                        if (EnumKendis.ART_LINK_OBJECTIVE.getCode().equals(((BaseItemLink)savedImpediment.getBaseItemLinks().get(0)).getLinkType()) && "-1".equals(((BaseItemLink)savedImpediment.getBaseItemLinks().get(0)).getSessionId())) {
                            List users;
                            ArrayList<String> userEmails = new ArrayList<String>();
                            if (PropertyValidator.isValid((Object)savedImpediment.getCreatedBy())) {
                                userEmails.add(savedImpediment.getCreatedBy());
                            }
                            if (PropertyValidator.isValid((Object)savedImpediment.getUpdatedBy()) && !userEmails.contains(savedImpediment.getUpdatedBy())) {
                                userEmails.add(savedImpediment.getUpdatedBy());
                            }
                            if (PropertyValidator.isValid(userEmails) && PropertyValidator.isValid((Collection)(users = this.userRepository.findByUserNameIgnoreCaseIn(userEmails)))) {
                                for (User user : users) {
                                    if (!PropertyValidator.isValid((Object)user.getUserName()) || !PropertyValidator.isValid((Object)user.getFullName())) continue;
                                    if (user.getUserName().equals(savedImpediment.getCreatedBy()) && user.getUserName().equals(savedImpediment.getUpdatedBy())) {
                                        savedImpediment.setCreatedBy(user.getFullName());
                                        savedImpediment.setUpdatedBy(user.getFullName());
                                        continue;
                                    }
                                    if (user.getUserName().equals(savedImpediment.getCreatedBy())) {
                                        savedImpediment.setCreatedBy(user.getFullName());
                                        continue;
                                    }
                                    savedImpediment.setUpdatedBy(user.getFullName());
                                }
                            }
                        }
                        if (!emailContent.isEmpty()) {
                            this.externalEntitiesService.sendEmailNotitication(emailContent);
                        }
                        responseJson.put("impediment", savedImpediment);
                        pushJson.put("action", "impedimentAndActionPointUpdate");
                        pushData.put("savedImpediment", savedImpediment);
                        pushData.put("changedFields", changedProperties);
                        pushJson.put("data", pushData);
                    }
                }
                if (inputItem.getType().contains("Objective") || inputItem.getType().equals("KR")) {
                    pushMeta.put("event", EnumKendis.NEW_OBJECTIVES.getCode());
                } else {
                    pushMeta.put("event", SosController.sosEnums.ScrumOfScrums.name());
                }
                pushJson.put("metaMap", gson.toJson((Object)pushMeta));
                pushJson.put("push", "Self");
                PushSender.sendMsg((String)mapper.writeValueAsString(pushJson));
                if (!PropertyValidator.isValid((Object)sosId) || sosId.equals("0")) break block125;
                ScrumOfScrums sos = sctumOfscrum;
                if (PropertyValidator.isValid((Collection)sos.getRemainderList()) && sos.getRemainderList().size() > 0) {
                    String reminderType;
                    String string = reminderType = "action-points".equals(type) ? WorkFlow.WorkFlowType.ActionPoint.name() : WorkFlow.WorkFlowType.Impediment.name();
                    if (sos.getRemainderList().contains(reminderType)) {
                        sos.getRemainderList().remove(reminderType);
                        sos.setRemainderList(sos.getRemainderList());
                        sos.setUpdated(true);
                        this.sosRepository.save((Object)sos);
                    }
                }
                if (!PropertyValidator.isValid((Object)scrumId) || !PropertyValidator.isValid((Collection)sos.getScrums())) break block125;
                for (Scrum scrum : sos.getScrums()) {
                    String reminderType;
                    if (!scrum.getId().equals(scrumId)) continue;
                    String string = reminderType = "action-points".equals(type) ? WorkFlow.WorkFlowType.ActionPoint.name() : WorkFlow.WorkFlowType.Impediment.name();
                    if (scrum.getRemainderList().contains(reminderType)) {
                        scrum.getRemainderList().remove(reminderType);
                        scrum.setRemainderList(scrum.getRemainderList());
                    }
                    this.scrumRepository.save((Object)scrum);
                    break;
                }
            }
            catch (Exception e) {
                responseJson.put("kendisError", e);
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
                return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
            }
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"fields-template/all"}, method={RequestMethod.GET})
    public ResponseEntity<Object> getDynamicTemplate() {
        Query query = new Query();
        try {
            List allTemplates = this.mongoTemplate.find(query, FieldTemplate.class);
            return new ResponseEntity((Object)allTemplates, HttpStatus.ACCEPTED);
        }
        catch (Exception ex) {
            String err = StringUtils.getTraceString((Throwable)ex);
            LOGGER.error(err);
            return null;
        }
    }

    @RequestMapping(value={"fields-template/{type}"}, method={RequestMethod.GET})
    public ResponseEntity<Object> getTemplate(@PathVariable(value="type") String type) {
        try {
            FieldTemplate template = this.fieldTemplateRepository.findByType(type);
            return new ResponseEntity((Object)template, HttpStatus.ACCEPTED);
        }
        catch (Exception ex) {
            String err = StringUtils.getTraceString((Throwable)ex);
            LOGGER.error(err);
            return null;
        }
    }

    @RequestMapping(value={"fields-template/save"}, method={RequestMethod.POST})
    public ResponseEntity<Object> saveDynamicTemplate(@RequestBody FieldTemplate baseitem) {
        try {
            if (baseitem.getConfiguredFields().size() > 0) {
                this.fieldsRepository.save((Iterable)baseitem.getConfiguredFields());
                this.fieldTemplateRepository.save((Object)baseitem);
                return new ResponseEntity((Object)true, HttpStatus.ACCEPTED);
            }
        }
        catch (Exception ex) {
            String err = StringUtils.getTraceString((Throwable)ex);
            LOGGER.error(err);
        }
        return null;
    }

    @RequestMapping(value={"fields-template/delete/{itemId}"}, method={RequestMethod.POST})
    public ResponseEntity<Object> deleteDynamicTemplate(@PathVariable(value="itemId") String itemId) {
        return null;
    }

    @RequestMapping(value={"item-type/all"}, method={RequestMethod.GET})
    public ResponseEntity<Object> getItemTypes() {
        try {
            Company company = this.companyRepository.findById(UserContextUtil.getUserContext().getCurrentCompanyId());
            List itemTypes = company.getItemTypes() != null ? company.getItemTypes() : new ArrayList();
            return new ResponseEntity((Object)itemTypes, HttpStatus.ACCEPTED);
        }
        catch (Exception ex) {
            String err = StringUtils.getTraceString((Throwable)ex);
            LOGGER.error(err);
            return null;
        }
    }

    @RequestMapping(value={"item-type/save/{type}"}, method={RequestMethod.POST})
    public ResponseEntity<Object> saveItemTypes(@PathVariable(value="type") String type) {
        try {
            Company company = this.companyRepository.findById(UserContextUtil.getUserContext().getCurrentCompanyId());
            if (company.getItemTypes() != null) {
                company.getItemTypes().add(type);
            } else {
                ArrayList<String> temp = new ArrayList<String>();
                temp.add(type);
                company.setItemTypes(temp);
            }
            this.companyRepository.save((Object)company);
        }
        catch (Exception ex) {
            String err = StringUtils.getTraceString((Throwable)ex);
            LOGGER.error(err);
        }
        return null;
    }

    @RequestMapping(value={"load-base-item/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<Object> getDynamicItem(@PathVariable(value="id") String id) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            BaseItem baseItem = (BaseItem)this.baseItemRepository.findOne((Serializable)((Object)id));
            if (!PropertyValidator.isValid((Object)baseItem)) {
                responseJson.put("success", false);
                responseJson.put("reason", "Invalid Input");
                return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
            }
            if (!PropertyValidator.isValid((Object)baseItem.getItemType())) {
                if (baseItem.getFieldsTemplate() == null || baseItem.getFieldsTemplate().getId() == null || "0".equals(baseItem.getFieldsTemplate().getId())) {
                    FieldTemplate template = this.fieldTemplateRepository.findByType(baseItem.getType());
                    if (template == null) {
                        template = new FieldTemplate();
                        List<Object> fields = new ArrayList<Fields>();
                        fields.add(new Fields("1", "Title", "simpleEditor", null, Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), null, null, null));
                        fields.add(new Fields("2", "Description", "textarea", null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, null));
                        fields.add(new Fields("3", "Status", "status", new ArrayList(), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, null));
                        fields.add(new Fields("4", "Severity", "severity", new ArrayList(), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, null));
                        fields.add(new Fields("5", "Responsible", "userpicker", null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, null));
                        fields.add(new Fields("6", "Resolution Date", "datepicker", null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, null));
                        fields = this.fieldsRepository.save(fields);
                        template.setConfiguredFields(fields);
                        template.setType(baseItem.getType());
                        template = (FieldTemplate)this.fieldTemplateRepository.save((Object)template);
                        baseItem.setFieldsTemplate(template);
                    } else {
                        baseItem.setFieldsTemplate(template);
                    }
                    this.baseItemRepository.save((Object)baseItem);
                }
            } else {
                ItemTypeScheme itemTypeScheme = this.itemTypeSchemeRepository.findByItemType(baseItem.getItemType());
                if (PropertyValidator.isValid((Object)itemTypeScheme)) {
                    responseJson.put("fieldTemplate", itemTypeScheme.getFieldsTemplate());
                    ArrayList<String> itemTypeStr = new ArrayList<String>();
                    if (itemTypeScheme.getItemType().getTitle().equals(EnumKendis.MILESTONE.getCode()) || itemTypeScheme.getItemType().getTitle().equals(EnumKendis.PHASES.getCode())) {
                        itemTypeStr.add(EnumKendis.MILESTONE.getCode());
                        itemTypeStr.add(EnumKendis.PHASES.getCode());
                        List itemTypeList = this.itemTypeRepository.findByTitleIn(itemTypeStr);
                        if (PropertyValidator.isValid((Collection)itemTypeList)) {
                            responseJson.put("itemTypeList", itemTypeList);
                        }
                    }
                }
                this.baseItemRepository.save((Object)baseItem);
            }
            responseJson.put("item", baseItem);
            HashMap<String, Object> statuesMap = new HashMap<String, Object>();
            statuesMap.put(baseItem.getType() + "StatusList", this.statusRepository.findByWorkFlow(baseItem.getStatus().getWorkFlow()));
            statuesMap.put(baseItem.getType() + "StatusSequence", baseItem.getStatus().getWorkFlow().getStatusSequence());
            if (baseItem.getType().equals(WorkFlow.WorkFlowType.Impediment.name())) {
                String sosIdForSeverity = "";
                for (BaseItemLink baseItemLink : baseItem.getBaseItemLinks()) {
                    if (!PropertyValidator.isValid((Object)baseItemLink) || !PropertyValidator.isValid((Object)baseItemLink.getIsSystemLink()) || !baseItemLink.getIsSystemLink().booleanValue()) continue;
                    sosIdForSeverity = baseItemLink.getScrumOfScrumId();
                }
                ScrumOfScrums sos = (ScrumOfScrums)this.sosRepository.findOne((Serializable)((Object)sosIdForSeverity));
                if (PropertyValidator.isValid((Object)sos)) {
                    statuesMap.put(WorkFlow.WorkFlowType.Severity.name() + "List", this.severityRepository.findByWorkFlow(sos.getSeverityWorkFlow()));
                    statuesMap.put(WorkFlow.WorkFlowType.Severity.name() + "Sequence", sos.getSeverityWorkFlow().getSeveritySequence());
                }
            }
            responseJson.put("statusMap", statuesMap);
            responseJson.put("item", baseItem);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            responseJson.put("success", false);
            responseJson.put("reason", "Invalid Input");
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"fetch-linked-items/{itemId}"}, method={RequestMethod.GET})
    public ResponseEntity<Object> fetchLinkedItems(@PathVariable(value="itemId") String itemId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        BaseItem baseItem = (BaseItem)this.baseItemRepository.findOne((Serializable)((Object)itemId));
        if (PropertyValidator.isValid((Object)baseItem)) {
            ArrayList<String> sessionIds = new ArrayList<String>();
            List baseItemLinks = baseItem.getBaseItemLinks();
            if (PropertyValidator.isValid((Collection)baseItemLinks)) {
                for (BaseItemLink itemLink : baseItemLinks) {
                    if (!PropertyValidator.isValid((Object)itemLink.getSessionId())) continue;
                    sessionIds.add(itemLink.getSessionId());
                }
            }
            List sessions = this.sessionRepository.findByIdIn(sessionIds);
            HashMap activeBoardItemsMap = this.externalEntitiesService.setActiveBoardItems(baseItem, sessions, null, new HashMap(), null, null);
            List linkedItems = (List)activeBoardItemsMap.get("linkedItems");
            List linkedItemsIds = (List)activeBoardItemsMap.get("linkedItemsIds");
            HashMap linkedItemsById = (HashMap)activeBoardItemsMap.get("linkedItemsById");
            responseJson.put("linkedItems", linkedItems);
            responseJson.put("linkedItemsIds", linkedItemsIds);
            responseJson.put("linkedItemsById", linkedItemsById);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"dynamicitem/save"}, method={RequestMethod.POST})
    public ResponseEntity<Object> saveItem(@RequestBody BaseItem inputImpediment) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            if (!PropertyValidator.isValid((Object)inputImpediment.getId())) {
                FieldTemplate itemFieldTemplate;
                String companyId = UserContextUtil.getUserContext().getCurrentCompanyId();
                int key = Integer.valueOf(this.customRepository.getNextSeq(companyId, null, null));
                inputImpediment.setKey("DF-" + key);
                if (PropertyValidator.isValid((Object)inputImpediment.getFieldsTemplate()) && PropertyValidator.isValid((Object)(itemFieldTemplate = (FieldTemplate)this.fieldTemplateRepository.findOne((Serializable)((Object)inputImpediment.getFieldsTemplate().getId()))))) {
                    inputImpediment.putValues(inputImpediment.getFields(), itemFieldTemplate);
                }
            } else {
                FieldTemplate itemFieldTemplate;
                BaseItem oldImpediment = (BaseItem)this.baseItemRepository.findOne((Serializable)((Object)inputImpediment.getId()));
                if (PropertyValidator.isValid((Object)inputImpediment.getTitle())) {
                    oldImpediment.setTitle(inputImpediment.getTitle());
                }
                if (PropertyValidator.isValid((Object)inputImpediment.getDescription()) || "".equals(inputImpediment.getDescription())) {
                    oldImpediment.setDescription(inputImpediment.getDescription());
                }
                if (PropertyValidator.isValid((Object)inputImpediment.getStatus())) {
                    oldImpediment.setStatus(inputImpediment.getStatus());
                }
                if (!PropertyValidator.isValid((Object)oldImpediment.getFieldsTemplate())) {
                    oldImpediment.setFieldsTemplate(new FieldTemplate("0", WorkFlow.WorkFlowType.Impediment.name()));
                }
                if (PropertyValidator.isValid((Object)inputImpediment.getStarred())) {
                    oldImpediment.setStarred(inputImpediment.getStarred());
                }
                if (PropertyValidator.isValid((Object)inputImpediment.getFieldsTemplate()) && PropertyValidator.isValid((Object)(itemFieldTemplate = (FieldTemplate)this.fieldTemplateRepository.findOne((Serializable)((Object)inputImpediment.getFieldsTemplate().getId()))))) {
                    oldImpediment.putValues(inputImpediment.getFields(), itemFieldTemplate);
                }
                if (PropertyValidator.isValid((Object)inputImpediment.getFields())) {
                    oldImpediment.setFields(inputImpediment.getFields());
                }
                if (PropertyValidator.isValid((Object)inputImpediment.getFields())) {
                    Map oldFields = oldImpediment.getFields();
                    HashMap sequenceField = (HashMap)oldImpediment.getFields().get("sequence");
                    HashMap inputSequence = (HashMap)inputImpediment.getFields();
                    sequenceField.putAll(inputSequence);
                    oldFields.put("sequence", sequenceField);
                    oldImpediment.setFields(oldFields);
                } else {
                    oldImpediment.setSequence(inputImpediment.getSequence());
                }
                inputImpediment = oldImpediment;
            }
            BaseItem savedImpediment = (BaseItem)this.baseItemRepository.save((Object)inputImpediment);
            responseJson.put("impediment", savedImpediment);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/get-popup-info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getPopupInfo(@RequestBody Map<String, Object> requestBody) {
        ScrumOfScrums sos;
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        String workflowId = (String)requestBody.get("workflowId");
        String itemType = (String)requestBody.get("itemType");
        String sosId = (String)requestBody.get("sosId");
        if (!(PropertyValidator.isValid((Object)workflowId) || PropertyValidator.isValid((Object)itemType) || PropertyValidator.isValid((Object)sosId))) {
            responseJson.put("kendisError", "Invalid Input");
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        WorkFlow workflow = (WorkFlow)this.workFlowRepository.findOne((Serializable)((Object)workflowId));
        List statuses = this.statusRepository.findByWorkFlow(workflow);
        FieldTemplate fieldTemplate = this.fieldTemplateRepository.findByType(itemType);
        if (!PropertyValidator.isValid((Object)fieldTemplate)) {
            fieldTemplate = new FieldTemplate();
            List<Object> fields = new ArrayList<Fields>();
            fields.add(new Fields("1", "Title", "simpleEditor", null, Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), null, null, null));
            fields.add(new Fields("2", "Description", "textarea", null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, null));
            fields.add(new Fields("3", "Status", "status", new ArrayList(), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, null));
            fields.add(new Fields("4", "Severity", "severity", new ArrayList(), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, null));
            fields.add(new Fields("5", "Responsible", "userpicker", null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, null));
            fields.add(new Fields("6", "Resolution Date", "datepicker", null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, null));
            fields = this.fieldsRepository.save(fields);
            fieldTemplate.setConfiguredFields(fields);
            fieldTemplate.setType(itemType);
            fieldTemplate = (FieldTemplate)this.fieldTemplateRepository.save((Object)fieldTemplate);
        }
        HashMap<String, Object> statuesMap = new HashMap<String, Object>();
        statuesMap.put(itemType + "StatusList", statuses);
        statuesMap.put(itemType + "StatusSequence", workflow.getStatusSequence());
        if (itemType.equals(WorkFlow.WorkFlowType.Impediment.name()) && PropertyValidator.isValid((Object)(sos = (ScrumOfScrums)this.sosRepository.findOne((Serializable)((Object)sosId))))) {
            statuesMap.put(WorkFlow.WorkFlowType.Severity.name() + "List", this.severityRepository.findByWorkFlow(sos.getSeverityWorkFlow()));
            statuesMap.put(WorkFlow.WorkFlowType.Severity.name() + "Sequence", sos.getSeverityWorkFlow().getSeveritySequence());
        }
        responseJson.put("statusMap", statuesMap);
        responseJson.put("fieldTemplate", fieldTemplate);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"get-item-scheme/{schemeId}"}, method={RequestMethod.POST})
    public ResponseEntity<Object> getItemTypeScheme(@PathVariable String schemeId) {
        HashMap responseJson = new HashMap();
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"get-sub-items/{itemId}"}, method={RequestMethod.GET})
    public ResponseEntity<Object> getSubItems(@PathVariable String itemId) {
        HashMap<String, List> responseJson = new HashMap<String, List>();
        responseJson.put("subItems", this.externalEntitiesService.getSubItemsList(itemId));
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/check-in/save"}, method={RequestMethod.POST})
    public ResponseEntity<Object> saveCheckIn(@RequestBody String payload) {
        HashMap responseJson = new HashMap();
        try {
            Gson g = new Gson();
            2 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap requestBody = (HashMap)g.fromJson(payload, T.getType());
            responseJson = this.externalEntitiesService.saveCheckIn(requestBody);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity((Object)responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/check-in/get"}, method={RequestMethod.POST})
    public ResponseEntity<Object> fetchCheckIns(@RequestBody Map<String, Object> requestBody) {
        HashMap responseJson = new HashMap();
        try {
            responseJson = this.externalEntitiesService.fetchCheckIns(requestBody);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)responseJson, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/check-in/{checkInId}"}, method={RequestMethod.GET})
    public ResponseEntity<Object> fetchCheckIn(@PathVariable(value="checkInId") String checkInId) {
        HashMap responseJson = new HashMap();
        try {
            responseJson = this.externalEntitiesService.fetchCheckIn(checkInId);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)responseJson, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"check-in/delete/{id}"}, method={RequestMethod.DELETE})
    public ResponseEntity<Object> deleteCheckIns(@PathVariable(value="id") String id) {
        HashMap responseJson = new HashMap();
        try {
            responseJson = this.externalEntitiesService.deleteCheckIn(id);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)responseJson, HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity((Object)responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"action-point/fetch"}, method={RequestMethod.POST})
    public ResponseEntity<Object> getActionPoints(@RequestBody HashMap<String, Object> requestBody) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        if (!PropertyValidator.isValid((Object)requestBody.get("entityId")) && !PropertyValidator.isValid((Object)requestBody.get("entityType"))) {
            responseJson.put("success", false);
            responseJson.put("reason", "Invalid Input");
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        try {
            List actionPoints = this.externalEntitiesService.fetchActionPoints(requestBody);
            responseJson.put("actionPoints", actionPoints);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"action-point/save"}, method={RequestMethod.POST})
    public ResponseEntity<Object> saveActionPoint(@RequestBody ActionPoint actionPoint) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        if (!PropertyValidator.isValid((Object)actionPoint.getEntityId()) && !PropertyValidator.isValid((Object)actionPoint.getEntityType())) {
            responseJson.put("success", false);
            responseJson.put("reason", "Invalid Input");
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        try {
            ActionPoint savedActionPoint = this.externalEntitiesService.saveActionPoint(actionPoint);
            responseJson.put("actionPoint", savedActionPoint);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"action-point/delete/{id}"}, method={RequestMethod.DELETE})
    public ResponseEntity<Object> deleteActionPoint(@PathVariable(value="id") String id) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        if (!PropertyValidator.isValid((Object)id)) {
            responseJson.put("success", false);
            responseJson.put("reason", "Invalid Input");
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        try {
            this.externalEntitiesService.deleteActionPoint(id);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }
}

