/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.controller;

import com.viztrend.safe.persistence.entity.Fields;
import com.viztrend.safe.persistence.entity.FieldsLayout;
import com.viztrend.safe.service.CustomFieldService;
import com.viztrend.safe.utils.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@RequestMapping(value={"/customfield"})
@Controller
public class CustomFieldController {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomFieldController.class);
    @Autowired
    private CustomFieldService customFieldService;

    @RequestMapping(value={"/fetch-list"}, method={RequestMethod.GET})
    public ResponseEntity<Object> getCustomFieldList() {
        try {
            HashMap<String, List> responseJson = new HashMap<String, List>();
            this.customFieldService.scriptToCreateItemTypes();
            responseJson.put("list", this.customFieldService.fetchAllCustomFields());
            responseJson.put("modules", this.customFieldService.getItemTypeList());
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/fetch-modules"}, method={RequestMethod.GET})
    public ResponseEntity<Object> getModulesList() {
        try {
            return new ResponseEntity((Object)this.customFieldService.getItemTypeList(), HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    public ResponseEntity<Object> saveCustomField(@RequestBody Fields field) {
        try {
            Map responseJson = this.customFieldService.saveCustomField(field);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/archive/{archiveFlag}/{fieldId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> archiveWorspace(@PathVariable(value="archiveFlag") Boolean archive, @PathVariable(value="fieldId") String fieldId) {
        try {
            Map responseJson = this.customFieldService.archiveCustomField(fieldId, archive);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/fetch-fields/{itemType}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getItemTypeFields(@PathVariable(value="itemType") String itemType) {
        try {
            Map responseJson = this.customFieldService.getKendisCustomFields(itemType);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/save-layout"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveLayout(@RequestBody FieldsLayout fieldsLayout) {
        try {
            Map responseJson = this.customFieldService.saveFieldsLayout(fieldsLayout);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/fetch-layouts"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getFieldLayouts() {
        try {
            HashMap<String, List> responseJson = new HashMap<String, List>();
            responseJson.put("layouts", this.customFieldService.fetchAllCustomFieldLayout());
            responseJson.put("modules", this.customFieldService.getItemTypeList());
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/layout-default/{id}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> markLayoutDefault(@PathVariable(value="id") String id) {
        try {
            Map responseJson = this.customFieldService.markLayoutAsDefault(id);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/get/layout/{type}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getLayoutByItemType(@PathVariable(value="type") String type) {
        try {
            return new ResponseEntity((Object)this.customFieldService.getAllLayoutsByItemType(type), HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/layout-archive/{archiveFlag}/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> archiveLayout(@PathVariable(value="archiveFlag") Boolean archive, @PathVariable(value="id") String id) {
        try {
            Map responseJson = this.customFieldService.archiveLayout(id, archive);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/layout-delete/{id}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> deleteLayout(@PathVariable(value="id") String id) {
        try {
            Map responseJson = this.customFieldService.deleteLayout(id);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/get/default-layout/{type}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getDefaultLayout(@PathVariable(value="type") String type) {
        try {
            return new ResponseEntity((Object)this.customFieldService.getDefaultLayoutFromItemType(type), HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/create-default-layout"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> createDefaultLayouts() {
        try {
            return new ResponseEntity((Object)this.customFieldService.createDefaultLayouts(), HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }
}

