/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.viztrend.safe.persistence.entity.ConfigAndMapping;
import com.viztrend.safe.persistence.entity.PushResponse;
import com.viztrend.safe.persistence.repository.PushResponseRepository;
import com.viztrend.safe.service.ConfigAndMappingService;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.PushSender;
import com.viztrend.safe.utils.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/configAndMapping"})
@RestController
public class ConfigAndMappingController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigAndMappingController.class);
    @Autowired
    private ConfigAndMappingService configAndMappingService;
    @Autowired
    private PushResponseRepository pushResponseRepository;

    @RequestMapping(value={"/loadConfigs"}, method={RequestMethod.GET})
    public ResponseEntity<Object> createDashboard() {
        HashMap result = new HashMap();
        try {
            result = this.configAndMappingService.loadConfigs();
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @RequestMapping(value={"/configMetaGeneral"}, method={RequestMethod.GET})
    public ResponseEntity<Object> configMetaGeneral() {
        HashMap result = new HashMap();
        try {
            result = this.configAndMappingService.configMetaGeneral();
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @RequestMapping(value={"/saveConfig"}, method={RequestMethod.POST})
    public ResponseEntity<Object> saveConfig(@RequestBody ConfigAndMapping config) {
        HashMap result = new HashMap();
        try {
            result = this.configAndMappingService.saveConfig(config);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @RequestMapping(value={"/configMetaTfsProjects/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<Object> configMetaTfsProjects(@PathVariable(value="id") String configId) {
        HashMap result = new HashMap();
        try {
            result = this.configAndMappingService.configMetaTfsProjects(configId);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @RequestMapping(value={"/configMetaRiskMapping/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<Object> configMetaRiskMapping(@PathVariable(value="id") String configId) {
        HashMap result = new HashMap();
        try {
            result = this.configAndMappingService.configMetaRiskMapping(configId);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @RequestMapping(value={"/configRiskRegisterMeta/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<Object> configRiskRegisterMeta(@PathVariable(value="id") String riskRegisterId) {
        HashMap result = new HashMap();
        try {
            result = this.configAndMappingService.configRiskRegisterMeta(riskRegisterId);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @RequestMapping(value={"/getTfsProjectDetails/{projectId}/{almId}"}, method={RequestMethod.GET})
    public ResponseEntity<Object> getTfsProjectDetails(@PathVariable(value="projectId") String projectId, @PathVariable(value="almId") String almId) {
        HashMap result = new HashMap();
        try {
            result = this.configAndMappingService.getTfsProjectDetails(projectId, almId);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @RequestMapping(value={"/linkTfsProject"}, method={RequestMethod.POST})
    public ResponseEntity<Object> linkTfsProject(@RequestBody HashMap<String, Object> request) {
        HashMap result = new HashMap();
        try {
            new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(result, HttpStatus.OK);
    }

    private void onBackgroundTaskCompleted(Map<String, Object> result, String syncId, String event) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            String content = mapper.writeValueAsString(result);
            String requestId = null;
            if (PropertyValidator.isValid((Object)syncId) && syncId.contains("#")) {
                String[] syncIdArray = syncId.split("#");
                syncId = syncIdArray[0];
                requestId = syncIdArray[1];
            }
            JSONObject pushJson = new JSONObject();
            pushJson = new JSONObject();
            pushJson.put("type", (Object)"Auto");
            pushJson.put("push", (Object)"Self");
            pushJson.put("done", true);
            pushJson.put("requestParam", (Object)content);
            pushJson.put("metaMap", (Object)("{\"event\":\"" + event + "\", \"syncId\":\"" + syncId + "\"}"));
            String pushJsonStr = pushJson.toString();
            if (!PropertyValidator.isValid((Object)requestId)) {
                PushSender.sendMsg((String)pushJsonStr);
            } else {
                this.pushResponseRepository.save((Object)new PushResponse(requestId, pushJsonStr, Boolean.valueOf(true)));
            }
        }
        catch (JSONException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        catch (JsonProcessingException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }

    static /* synthetic */ ConfigAndMappingService access$000(ConfigAndMappingController x0) {
        return x0.configAndMappingService;
    }

    static /* synthetic */ void access$100(ConfigAndMappingController x0, Map x1, String x2, String x3) {
        x0.onBackgroundTaskCompleted(x1, x2, x3);
    }

    static /* synthetic */ Logger access$200() {
        return LOGGER;
    }
}

