/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.controller;

import com.viztrend.safe.persistence.entity.CollaborationType;
import com.viztrend.safe.persistence.repository.CollaborationTypeRepository;
import com.viztrend.safe.service.CollaborationTypeServiceImpl;
import com.viztrend.safe.utils.PropertyValidator;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/collaboration-type"})
@RestController
public class CollaborationTypeController {
    private static final Logger LOGGER = LoggerFactory.getLogger(CollaborationTypeController.class);
    @Autowired
    private CollaborationTypeRepository collaborationTypeRepository;
    @Autowired
    private CollaborationTypeServiceImpl collaborationTypeService;

    @GetMapping(value={"/all"})
    public ResponseEntity<Map<String, Object>> getAllTypes() {
        try {
            List types = this.collaborationTypeService.getAllTypes();
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("types", types);
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            LOGGER.error("Error fetching collaboration types", (Throwable)e);
            return ResponseEntity.status((int)500).body(Collections.singletonMap("success", false));
        }
    }

    @PostMapping(value={"/context/{id}"})
    public ResponseEntity<Map<String, Object>> getTypesRelatedToContext(@PathVariable String id, @RequestBody Map payload) {
        try {
            List collaborationTypes = this.collaborationTypeService.getTypesRelatedToContext(id, payload);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("type", collaborationTypes);
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            LOGGER.error("Error fetching collaboration types", (Throwable)e);
            return ResponseEntity.status((int)500).body(Collections.singletonMap("success", false));
        }
    }

    @PostMapping(value={"/create"})
    public ResponseEntity<Map<String, Object>> createType(@RequestBody Map payload) {
        try {
            String context = (String)payload.get("context");
            CollaborationType collaborationType = new CollaborationType();
            if (PropertyValidator.isValid((Object)context)) {
                collaborationType = this.collaborationTypeService.createType(payload);
            } else {
                String title = (String)payload.get("title");
                collaborationType.setTitle(title);
                collaborationType = (CollaborationType)this.collaborationTypeRepository.save((Object)collaborationType);
            }
            HashMap<String, Boolean> response = new HashMap<String, Boolean>();
            response.put("success", true);
            response.put("type", (Boolean)collaborationType);
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            LOGGER.error("Error creating collaboration type", (Throwable)e);
            return ResponseEntity.status((int)500).body(Collections.singletonMap("success", false));
        }
    }

    @PostMapping(value={"/link/{id}"})
    public ResponseEntity<Map<String, Object>> linkCollaborationType(@PathVariable String id, @RequestBody Map payload) {
        try {
            List collaborationTypes = this.collaborationTypeService.linkType(id, payload);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("type", collaborationTypes);
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            LOGGER.error("Error creating collaboration type", (Throwable)e);
            return ResponseEntity.status((int)500).body(Collections.singletonMap("success", false));
        }
    }

    @PostMapping(value={"/unlink/{id}"})
    public ResponseEntity<Map<String, Object>> unlinkCollaborationType(@PathVariable String id, @RequestBody Map payload) {
        try {
            List collaborationTypes = this.collaborationTypeService.unlinkType(id, payload);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("type", collaborationTypes);
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            LOGGER.error("Error unlinking collaboration type", (Throwable)e);
            return ResponseEntity.status((int)500).body(Collections.singletonMap("success", false));
        }
    }

    @PutMapping(value={"/update/{id}"})
    public ResponseEntity<Map<String, Object>> updateType(@PathVariable String id, @RequestBody CollaborationType type) {
        try {
            Optional existingTypeOpt = this.collaborationTypeRepository.findById(id);
            if (!existingTypeOpt.isPresent()) {
                return ResponseEntity.status((int)404).body(Collections.singletonMap("success", false));
            }
            CollaborationType existingType = (CollaborationType)existingTypeOpt.get();
            existingType.setTitle(type.getTitle());
            CollaborationType collabType = (CollaborationType)this.collaborationTypeRepository.save((Object)existingType);
            HashMap<String, Boolean> response = new HashMap<String, Boolean>();
            response.put("success", true);
            response.put("type", (Boolean)collabType);
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            LOGGER.error("Error updating collaboration type", (Throwable)e);
            return ResponseEntity.status((int)500).body(Collections.singletonMap("success", false));
        }
    }

    @DeleteMapping(value={"/delete/{id}"})
    public ResponseEntity<Map<String, Object>> deleteTypeById(@PathVariable String id) {
        try {
            CollaborationType deletedType = this.collaborationTypeService.deleteTypeById(id);
            HashMap<String, Boolean> response = new HashMap<String, Boolean>();
            response.put("success", true);
            response.put("type", (Boolean)deletedType);
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            LOGGER.error("Error deleting collaboration type", (Throwable)e);
            return ResponseEntity.status((int)500).body(Collections.singletonMap("success", false));
        }
    }
}

