/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.controller;

import com.google.gson.Gson;
import com.viztrend.safe.api.dto.BaseItemBulkItemsDTO;
import com.viztrend.safe.enums.EnumBaseItemTypes;
import com.viztrend.safe.exception.KendisException;
import com.viztrend.safe.persistence.entity.AlmConfigurations;
import com.viztrend.safe.persistence.entity.BaseEntity;
import com.viztrend.safe.persistence.entity.BaseItem;
import com.viztrend.safe.persistence.entity.BaseItemLink;
import com.viztrend.safe.persistence.entity.FieldTemplate;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.ItemType;
import com.viztrend.safe.persistence.entity.ItemTypeScheme;
import com.viztrend.safe.persistence.entity.ObjectiveCustomView;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.WorkFlow;
import com.viztrend.safe.persistence.entity.WorkSpace;
import com.viztrend.safe.persistence.repository.AttachmentRepository;
import com.viztrend.safe.persistence.repository.BacklogItemRepository;
import com.viztrend.safe.persistence.repository.BaseItemLinkRepository;
import com.viztrend.safe.persistence.repository.BaseItemRepository;
import com.viztrend.safe.persistence.repository.FieldTemplateRepository;
import com.viztrend.safe.persistence.repository.FieldsRepository;
import com.viztrend.safe.persistence.repository.ItemRepository;
import com.viztrend.safe.persistence.repository.ItemTypeRepository;
import com.viztrend.safe.persistence.repository.ItemTypeSchemeRepository;
import com.viztrend.safe.persistence.repository.ObjectiveCustomViewRepository;
import com.viztrend.safe.persistence.repository.SessionBoardRepository;
import com.viztrend.safe.persistence.repository.SessionRepository;
import com.viztrend.safe.persistence.repository.StatusRepository;
import com.viztrend.safe.persistence.repository.WorkFlowRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceRepository;
import com.viztrend.safe.service.AttachmentService;
import com.viztrend.safe.service.BatchService;
import com.viztrend.safe.service.ReleaseTrainService;
import com.viztrend.safe.utils.KendisUtils;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.vos.Attachment;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RequestMapping(value={"/batch"})
@RestController
public class BatchController {
    private static final Logger LOGGER = LoggerFactory.getLogger(BatchController.class);
    @Autowired
    private ItemTypeRepository itemTypeRepository;
    @Autowired
    private ItemTypeSchemeRepository itemTypeSchemeRepository;
    @Autowired
    private BacklogItemRepository backlogItemRepository;
    @Autowired
    private WorkFlowRepository workFlowRepository;
    @Autowired
    private WorkSpaceRepository workSpaceRepository;
    @Autowired
    private FieldTemplateRepository fieldTemplateRepository;
    @Autowired
    private FieldsRepository fieldsRepository;
    @Autowired
    private StatusRepository statusRepository;
    @Autowired
    private BatchService batchService;
    @Autowired
    private SessionBoardRepository sessionBoardRepository;
    @Autowired
    private SessionRepository sessionRepository;
    @Autowired
    private BaseItemRepository baseItemRepository;
    @Autowired
    private BaseItemLinkRepository baseItemLinkRepository;
    @Autowired
    private ItemRepository itemRepository;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private AttachmentService attachmentService;
    @Autowired
    private AttachmentRepository attachmentRepository;
    @Autowired
    private ReleaseTrainService releaseTrainService;
    @Autowired
    private ObjectiveCustomViewRepository objectiveCustomViewRepository;

    @RequestMapping(value={"/copy-backlog-items-batches/{syncId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> copyItemLinks(@RequestBody Map<String, Object> requestMap, @PathVariable(value="syncId") String syncId) {
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        try {
            Gson gson = new Gson();
            String json = gson.toJson(requestMap.get("selectedItemsMap"));
            Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
            Map selectedItemsMap = (Map)gson.fromJson(json, type);
            ArrayList<String> failedBatchesIds = new ArrayList<String>();
            List selectedBatchesIds = (List)requestMap.get("selectedBatchesIds");
            for (Map.Entry entry : selectedItemsMap.entrySet()) {
                List links = (List)entry.getValue();
                for (String batchId : selectedBatchesIds) {
                    try {
                        this.batchService.linkBackLogItemToBatch(links, batchId);
                    }
                    catch (Exception e) {
                        LOGGER.error("Error while copying backlog items batchID " + batchId, (Object)StringUtils.getTraceString((Throwable)e));
                        failedBatchesIds.add(batchId);
                    }
                }
            }
            response.put("failedBatches", failedBatchesIds);
            return new ResponseEntity(response, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error("Error while unlinking backlog item and batch", (Object)StringUtils.getTraceString((Throwable)e));
            response.put("error", e);
            return new ResponseEntity(response, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/unlink-backlog-items-batches/{syncId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> unlinkBackLogItemsMultiBatches(@RequestBody Map<String, List<BaseItemLink>> requestMap, @PathVariable(value="syncId") String syncId) {
        HashMap<String, Exception> response = new HashMap<String, Exception>();
        try {
            for (Map.Entry<String, List<BaseItemLink>> entry : requestMap.entrySet()) {
                String batchId = entry.getKey();
                List<BaseItemLink> links = entry.getValue();
                for (BaseItemLink link : links) {
                    String backlogItemId = link.getBaseItemId();
                    this.batchService.unlinkBackLogItemFromBatch(backlogItemId, batchId);
                }
            }
            return new ResponseEntity(response, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error("Error while unlinking backlog item and batch", (Object)StringUtils.getTraceString((Throwable)e));
            response.put("error", e);
            return new ResponseEntity(response, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/update-linked-child-batches-sequence/{syncId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> updateLinkedChildBatchesSequence(@RequestBody Map<String, Object> requestMap, @PathVariable(value="syncId") String syncId) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            String linkedBatchId = (String)requestMap.get("linkedBatchId");
            String sequence = (String)requestMap.get("sequence");
            String batchId = (String)requestMap.get("batchId");
            this.batchService.updateLinkedBatchSequence(linkedBatchId, batchId, sequence);
            response.put("sequence", sequence);
            return new ResponseEntity(response, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error("Error while updating link sequence", (Object)StringUtils.getTraceString((Throwable)e));
            response.put("error", e);
            return new ResponseEntity(response, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/update-batch-sequence/{syncId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> updateBatchSequence(@RequestBody Map<String, Object> requestMap, @PathVariable(value="syncId") String syncId) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            String batchId = (String)requestMap.get("batchId");
            String sequence = (String)requestMap.get("sequence");
            this.batchService.updateBatchSequence(batchId, sequence);
            response.put("sequence", sequence);
            return new ResponseEntity(response, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error("Error while updating link sequence", (Object)StringUtils.getTraceString((Throwable)e));
            response.put("error", e);
            return new ResponseEntity(response, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/get-all-batches"}, method={RequestMethod.POST})
    public ResponseEntity<Object> loadAllBatches(@RequestBody Map<String, Object> requestJson) {
        HashMap responseJson = new HashMap();
        boolean istreeView = requestJson.get("isTreeView") != null ? (Boolean)requestJson.get("isTreeView") : true;
        boolean islistView = requestJson.get("isListView") != null ? (Boolean)requestJson.get("isListView") : true;
        boolean isfields = requestJson.get("isFields") != null ? (Boolean)requestJson.get("isFields") : false;
        boolean isObjectiveRelationView = requestJson.get("isObjectiveRelationView") != null;
        String releaseTrainId = requestJson.get("releaseTrainId") != null ? (String)requestJson.get("releaseTrainId") : "";
        try {
            responseJson = this.batchService.getAllBatches(releaseTrainId, istreeView, islistView, isfields, isObjectiveRelationView);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/get-batch-groups-list-by-session-id/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<Object> loadBatchGroupsBySessionId(@PathVariable(value="id") String sessionId) {
        HashMap responseJson = new HashMap();
        try {
            responseJson = this.batchService.loadBatchesListBySessionId(sessionId);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error("*****loadObjectiveGroupsBySessionId**** -----> Exception Occurred. ---------------");
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/get-batch-by-id/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<Object> loadBatchById(@PathVariable(value="id") String id) {
        HashMap responseJson = new HashMap();
        try {
            responseJson = this.batchService.loadBatchId(id);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/get-batch-by-key/{key}"}, method={RequestMethod.GET})
    public ResponseEntity<Object> loadBatchByKey(@PathVariable(value="key") String key) {
        Map<String, Exception> responseJson = new HashMap<String, Exception>();
        try {
            responseJson = this.batchService.loadBatchByKey(key);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/get-bread-crums/{key}"}, method={RequestMethod.GET})
    public ResponseEntity<Object> loadBatchBreadCrumbs(@PathVariable(value="key") String key) {
        Map<String, Exception> responseJson = new HashMap<String, Exception>();
        try {
            responseJson = this.batchService.loadBatchBreadCrumbs(key);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/get-batch-modal-template"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getBatchEditModalTemplate() {
        try {
            List fields;
            List batchGroupWorkFlowList;
            ArrayList<String> whereInClause = new ArrayList<String>();
            whereInClause.add("batch_group");
            whereInClause.add("Batch");
            List itemTypes = this.itemTypeRepository.findByTitleIn(whereInClause);
            ItemType batchGroupItemType = new ItemType();
            ItemType batchItemType = new ItemType();
            if (itemTypes.size() > 0) {
                for (ItemType it : itemTypes) {
                    if (it.getTitle().equals("batch_group")) {
                        batchGroupItemType = it;
                        continue;
                    }
                    if (!it.getTitle().equals("Batch")) continue;
                    batchItemType = it;
                }
            }
            if (!PropertyValidator.isValid((Object)batchGroupItemType.getId())) {
                batchGroupItemType.setTitle("batch_group");
                batchGroupItemType.setNested(false);
                batchGroupItemType = (ItemType)this.itemTypeRepository.save((Object)batchGroupItemType);
            }
            if (!PropertyValidator.isValid((Object)batchItemType.getId())) {
                batchItemType.setTitle("Batch");
                batchItemType.setNested(false);
                batchItemType = (ItemType)this.itemTypeRepository.save((Object)batchItemType);
            }
            if (!PropertyValidator.isValid((Collection)(batchGroupWorkFlowList = this.workFlowRepository.findAllByWorkflowType("batch_group")))) {
                batchGroupWorkFlowList.add(this.batchService.createDefaultBatchGroupWorkflow());
            }
            List batchGroupStatuses = this.statusRepository.findByWorkFlow((WorkFlow)batchGroupWorkFlowList.get(0));
            List batchWorkFlowList = this.workFlowRepository.findAllByWorkflowType("Batch");
            List batchStatuses = new ArrayList();
            if (!PropertyValidator.isValid((Collection)batchWorkFlowList)) {
                batchWorkFlowList.add(this.batchService.createDefaultBatchWorkflow());
            }
            batchStatuses = this.statusRepository.findByWorkFlow((WorkFlow)batchWorkFlowList.get(0));
            List fieldTemplates = this.fieldTemplateRepository.findByTypeIn(whereInClause);
            FieldTemplate batchGroupFT = new FieldTemplate();
            FieldTemplate batchFT = new FieldTemplate();
            if (fieldTemplates.size() > 0) {
                for (FieldTemplate ft : fieldTemplates) {
                    if (ft.getType().equals("batch_group")) {
                        batchGroupFT = ft;
                        continue;
                    }
                    if (!ft.getType().equals("Batch")) continue;
                    batchFT = ft;
                }
            }
            if (this.batchService.isConfiguredFieldEmptyForFieldTemplate("batch_group")) {
                fields = this.fieldsRepository.save((Iterable)this.batchService.fetchFieldsForBatchGroup());
                batchGroupFT.setConfiguredFields(fields);
                batchGroupFT = (FieldTemplate)this.fieldTemplateRepository.save((Object)batchGroupFT);
            }
            if (this.batchService.isConfiguredFieldEmptyForFieldTemplate("Batch")) {
                fields = this.fieldsRepository.save((Iterable)this.batchService.fetchFieldsForBatch());
                batchFT.setConfiguredFields(fields);
                batchFT = (FieldTemplate)this.fieldTemplateRepository.save((Object)batchFT);
            }
            if (!PropertyValidator.isValid((Object)batchGroupFT.getId())) {
                fields = this.fieldsRepository.save((Iterable)this.batchService.fetchFieldsForBatchGroup());
                batchGroupFT.setConfiguredFields(fields);
                batchGroupFT.setType("batch_group");
                batchGroupFT = (FieldTemplate)this.fieldTemplateRepository.save((Object)batchGroupFT);
            }
            if (!PropertyValidator.isValid((Object)batchFT.getId())) {
                fields = this.fieldsRepository.save((Iterable)this.batchService.fetchFieldsForBatch());
                batchFT.setConfiguredFields(fields);
                batchFT.setType("Batch");
                batchFT = (FieldTemplate)this.fieldTemplateRepository.save((Object)batchFT);
            }
            ArrayList<ItemType> itemTypeList = new ArrayList<ItemType>();
            itemTypeList.add(batchGroupItemType);
            itemTypeList.add(batchItemType);
            List itemTypeSchemeList = this.itemTypeSchemeRepository.findByItemTypeIn(itemTypeList);
            ItemTypeScheme batchGroupItemTypeScheme = new ItemTypeScheme();
            ItemTypeScheme batchItemTypeScheme = new ItemTypeScheme();
            if (itemTypeSchemeList.size() > 0) {
                for (ItemTypeScheme itemTypeScheme : itemTypeSchemeList) {
                    if (itemTypeScheme.getItemType().equals((Object)batchGroupItemType)) {
                        batchGroupItemTypeScheme = itemTypeScheme;
                        continue;
                    }
                    if (!itemTypeScheme.getItemType().equals((Object)batchItemType)) continue;
                    batchItemTypeScheme = itemTypeScheme;
                }
            }
            if (!PropertyValidator.isValid((Object)batchGroupItemTypeScheme.getId())) {
                batchGroupItemTypeScheme.setItemType(batchGroupItemType);
                if (batchGroupWorkFlowList.size() > 0) {
                    batchGroupItemTypeScheme.setWorkflow((WorkFlow)batchWorkFlowList.get(0));
                }
                batchGroupItemTypeScheme.setFieldsTemplate(batchGroupFT);
                batchGroupItemTypeScheme = (ItemTypeScheme)this.itemTypeSchemeRepository.save((Object)batchGroupItemTypeScheme);
            }
            if (!PropertyValidator.isValid((Object)batchItemTypeScheme.getId())) {
                batchItemTypeScheme.setItemType(batchItemType);
                if (batchWorkFlowList.size() > 0) {
                    batchItemTypeScheme.setWorkflow((WorkFlow)batchWorkFlowList.get(0));
                }
                batchItemTypeScheme.setFieldsTemplate(batchFT);
                batchItemTypeScheme = (ItemTypeScheme)this.itemTypeSchemeRepository.save((Object)batchItemTypeScheme);
            }
            HashMap jsonResponse = new HashMap();
            HashMap batchGroupResponse = new HashMap();
            HashMap batchResponse = new HashMap();
            batchGroupResponse.put("statuses", batchGroupStatuses);
            batchGroupResponse.put("scheme", batchGroupItemTypeScheme);
            batchResponse.put("statuses", batchStatuses);
            batchResponse.put("scheme", batchItemTypeScheme);
            jsonResponse.put("batchGroupTemplate", batchGroupResponse);
            jsonResponse.put("batchTemplate", batchResponse);
            return new ResponseEntity(jsonResponse, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error("*****getObjectiveEditModalTemplate**** -----> Exception Occurred. ---------------");
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"fetch-boards"}, method={RequestMethod.GET})
    public ResponseEntity<Object> fetchBoardsTeamsAndSprints() {
        HashMap<String, List> response = new HashMap<String, List>();
        try {
            List allSessions = this.sessionRepository.findTitleByRowStatus(Integer.valueOf(0));
            response.put("sessionList", allSessions);
            ArrayList<String> sessionBoardIds = new ArrayList<String>();
            for (Session session : allSessions) {
                sessionBoardIds.add(session.getActiveSessionBoard());
            }
            List sessionBoards = this.sessionBoardRepository.findSessionBoardByIdIn(sessionBoardIds);
            response.put("sessionBoards", sessionBoards);
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
        return new ResponseEntity(response, HttpStatus.OK);
    }

    @ResponseBody
    public ResponseEntity<Object> updateBaseItemLink(@RequestBody BaseItem inputItem, @PathVariable(value="syncId") String syncId, @PathVariable(value="sessionId") String sessionId) {
        BaseItem savedItem = (BaseItem)this.baseItemRepository.findOne((Serializable)((Object)inputItem.getId()));
        if (!PropertyValidator.isValid((Object)savedItem)) {
            HashMap<String, Object> responseJson = new HashMap<String, Object>();
            responseJson.put("success", false);
            responseJson.put("reason", "Invalid Input");
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        List savedItemLinks = savedItem.getBaseItemLinks();
        List newItemLinks = new ArrayList<BaseItemLink>();
        ArrayList<BaseItemLink> updatedBaseItemLinks = new ArrayList<BaseItemLink>();
        ArrayList<String> savedBaseItemLinkIdsFromInputItem = new ArrayList<String>();
        ArrayList<String> savedBaseItemLinkIds = new ArrayList<String>();
        ArrayList<BaseItemLink> savedBaseItemLinks = new ArrayList<BaseItemLink>();
        for (Object itemLink : inputItem.getBaseItemLinks()) {
            if (!PropertyValidator.isValid((Object)itemLink.getId())) {
                newItemLinks.add(itemLink);
                continue;
            }
            savedBaseItemLinkIdsFromInputItem.add(itemLink.getId());
        }
        for (Object itemLink : savedItemLinks) {
            if (!PropertyValidator.isValid((Object)itemLink.getItemId())) continue;
            savedBaseItemLinkIds.add(itemLink.getId());
            savedBaseItemLinks.add((BaseItemLink)itemLink);
        }
        ArrayList baseItemLinkIdsToDelete = new ArrayList(savedBaseItemLinkIds);
        baseItemLinkIdsToDelete.removeAll(savedBaseItemLinkIdsFromInputItem);
        this.baseItemLinkRepository.deleteByIdIn(baseItemLinkIdsToDelete);
        for (Object itemLink : savedItemLinks) {
            if (PropertyValidator.isValid((Object)itemLink.getItemId())) {
                String itemId = itemLink.getId();
                if (baseItemLinkIdsToDelete.contains(itemId)) continue;
                updatedBaseItemLinks.add((BaseItemLink)itemLink);
                continue;
            }
            updatedBaseItemLinks.add((BaseItemLink)itemLink);
        }
        if (PropertyValidator.isValid(newItemLinks)) {
            newItemLinks = this.baseItemLinkRepository.save(newItemLinks);
        }
        updatedBaseItemLinks.addAll(newItemLinks);
        savedItem.setBaseItemLinks(updatedBaseItemLinks);
        savedItem = (BaseItem)this.baseItemRepository.save((Object)savedItem);
        List newAttachedItemList = new ArrayList();
        if (PropertyValidator.isValid(newItemLinks)) {
            newAttachedItemList = this.itemRepository.findByIdIn((Collection)newItemLinks.stream().map(BaseItemLink::getItemId).collect(Collectors.toList()));
            for (Item newAttachedItem : newAttachedItemList) {
                if (!PropertyValidator.isValid((Collection)newAttachedItem.getBatches())) {
                    newAttachedItem.setBatches(new ArrayList());
                }
                newAttachedItem.getBatches().add(savedItem);
            }
        }
        if (PropertyValidator.isValid(savedBaseItemLinks)) {
            List detachedItemFromBatchList = this.itemRepository.findByIdIn((Collection)savedBaseItemLinks.stream().map(BaseItemLink::getItemId).collect(Collectors.toList()));
            block4: for (Item detachedItem : detachedItemFromBatchList) {
                if (!PropertyValidator.isValid((Collection)detachedItem.getBatches())) {
                    detachedItem.setBatches(new ArrayList());
                    continue;
                }
                for (BaseItem obj : detachedItem.getBatches()) {
                    if (obj == null || !Objects.equals(obj.getId(), savedItem.getId())) continue;
                    detachedItem.getBatches().remove(obj);
                    continue block4;
                }
            }
            newAttachedItemList.addAll(detachedItemFromBatchList);
        }
        if (PropertyValidator.isValid(newAttachedItemList)) {
            this.itemRepository.save(newAttachedItemList);
        }
        HashMap linkedItemsAndUpdatedItem = this.filterExternalItems(savedItem, inputItem);
        return new ResponseEntity((Object)linkedItemsAndUpdatedItem, HttpStatus.OK);
    }

    @ResponseBody
    public ResponseEntity<Object> linkBatchesWithItem(@RequestBody @NotNull List<BaseItem> inputItemList, @PathVariable(value="syncId") String syncId, @PathVariable(value="type") String type, @NotNull @PathVariable(value="itemId") String itemId) {
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        try {
            Item savedItem = this.itemRepository.findById(itemId);
            ArrayList<String> linkIdsToBeRemoved = new ArrayList<String>();
            ArrayList<BaseItem> newBaseItems = new ArrayList<BaseItem>();
            List attachedBatches = savedItem.getBatches();
            if (PropertyValidator.isValid((Object)savedItem)) {
                if (PropertyValidator.isValid((Collection)attachedBatches)) {
                    for (BaseItem baseItem : attachedBatches) {
                        if (!inputItemList.stream().noneMatch(itm -> Objects.equals(itm.getId(), baseItem.getId()))) continue;
                        linkIdsToBeRemoved.add(baseItem.getId());
                    }
                }
                for (BaseItem baseItem : inputItemList) {
                    if (PropertyValidator.isValid((Collection)attachedBatches) && !attachedBatches.stream().noneMatch(batch -> Objects.equals(batch.getId(), baseItem.getId()))) continue;
                    newBaseItems.add(baseItem);
                }
            }
            savedItem = this.detachItemAndBatches(linkIdsToBeRemoved, savedItem);
            response.put("success", Boolean.valueOf(true));
            response.put("savedBatches", this.attachNewBatchesWithItems(newBaseItems, type, savedItem));
            response.put("savedItem", (Serializable)savedItem);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            response.put("success", Boolean.valueOf(false));
        }
        return new ResponseEntity(response, HttpStatus.OK);
    }

    private Item detachItemAndBatches(List<String> baseItemIdsTobeRemoved, Item detachedItem) {
        if (PropertyValidator.isValid(baseItemIdsTobeRemoved)) {
            block0: for (String baseItemId : baseItemIdsTobeRemoved) {
                if (!PropertyValidator.isValid((Collection)detachedItem.getBatches())) {
                    detachedItem.setBatches(new ArrayList());
                }
                for (BaseItem batch : detachedItem.getBatches()) {
                    if (batch == null || !Objects.equals(batch.getId(), baseItemId)) continue;
                    detachedItem.getBatches().remove(batch);
                    continue block0;
                }
            }
            if (PropertyValidator.isValid((Object)detachedItem)) {
                this.itemRepository.save((Object)detachedItem);
            }
        }
        List updatedItems = this.baseItemRepository.findByIdIn(baseItemIdsTobeRemoved);
        ArrayList<BaseItemLink> linksToBeRemoved = new ArrayList<BaseItemLink>();
        for (BaseItem baseItem : updatedItems) {
            for (BaseItemLink link : baseItem.getBaseItemLinks()) {
                if (!detachedItem.getId().equals(link.getItemId())) continue;
                link.setArchive(true);
                linksToBeRemoved.add(link);
            }
        }
        this.baseItemLinkRepository.save(linksToBeRemoved);
        return detachedItem;
    }

    private ArrayList<BaseItem> attachNewBatchesWithItems(List<BaseItem> newBaseItems, String type, Item savedItem) {
        ArrayList<BaseItem> savedBaseItems = new ArrayList<BaseItem>();
        for (BaseItem inputItem : newBaseItems) {
            String itemId;
            BaseItem savedBatch = (BaseItem)this.baseItemRepository.findOne((Serializable)((Object)inputItem.getId()));
            if (!PropertyValidator.isValid((Object)savedBatch)) {
                HashMap<String, Object> responseJson = new HashMap<String, Object>();
                responseJson.put("success", false);
                responseJson.put("reason", "Invalid Input");
                return savedBaseItems;
            }
            List savedItemLinks = savedBatch.getBaseItemLinks();
            List<Object> newItemLinks = new ArrayList<BaseItemLink>();
            ArrayList<BaseItemLink> updatedBaseItemLinks = new ArrayList<BaseItemLink>();
            ArrayList savedBaseItemLinks = new ArrayList();
            for (BaseItemLink itemLink : inputItem.getBaseItemLinks()) {
                if (PropertyValidator.isValid((Object)itemLink.getId())) continue;
                newItemLinks.add(itemLink);
            }
            if ("item".equals(type)) {
                for (BaseItemLink itemLink : savedItemLinks) {
                    if (PropertyValidator.isValid((Object)itemLink.getItemId())) {
                        itemId = itemLink.getId();
                        updatedBaseItemLinks.add(itemLink);
                        continue;
                    }
                    updatedBaseItemLinks.add(itemLink);
                }
            } else {
                for (BaseItemLink itemLink : savedItemLinks) {
                    itemId = itemLink.getId();
                    updatedBaseItemLinks.add(itemLink);
                }
            }
            if (PropertyValidator.isValid(newItemLinks)) {
                newItemLinks = this.baseItemLinkRepository.save(newItemLinks);
            }
            updatedBaseItemLinks.addAll(newItemLinks);
            savedBatch.setBaseItemLinks(updatedBaseItemLinks);
            BaseItem savedBaseItem = this.filterExternalItemsPiBoard(savedBatch, inputItem);
            savedBaseItems.add(savedBaseItem);
        }
        savedItem.getBatches().addAll(savedBaseItems);
        this.itemRepository.save((Object)savedItem);
        this.baseItemRepository.save(savedBaseItems);
        return savedBaseItems;
    }

    @ResponseBody
    public ResponseEntity<Object> updateBaseItemLinkObjective(@RequestBody BaseItem inputItem, @PathVariable(value="syncId") String syncId, @PathVariable(value="type") String type) {
        String itemId;
        BaseItem savedBatch = (BaseItem)this.baseItemRepository.findOne((Serializable)((Object)inputItem.getId()));
        if (!PropertyValidator.isValid((Object)savedBatch)) {
            HashMap<String, Object> responseJson = new HashMap<String, Object>();
            responseJson.put("success", false);
            responseJson.put("reason", "Invalid Input");
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        List savedItemLinks = savedBatch.getBaseItemLinks();
        List newItemLinks = new ArrayList<BaseItemLink>();
        ArrayList<BaseItemLink> updatedBaseItemLinks = new ArrayList<BaseItemLink>();
        ArrayList<String> savedBaseItemLinkIdsFromInputItem = new ArrayList<String>();
        ArrayList<BaseItemLink> savedBaseItemLinksFromInputItem = new ArrayList<BaseItemLink>();
        ArrayList<String> savedBaseItemLinkIds = new ArrayList<String>();
        ArrayList<BaseItemLink> savedBaseItemLinks = new ArrayList<BaseItemLink>();
        for (BaseItemLink itemLink : inputItem.getBaseItemLinks()) {
            if (!PropertyValidator.isValid((Object)itemLink.getId())) {
                newItemLinks.add(itemLink);
                continue;
            }
            savedBaseItemLinkIdsFromInputItem.add(itemLink.getId());
            savedBaseItemLinksFromInputItem.add(itemLink);
        }
        if (!"item".equals(type)) {
            for (BaseItemLink itemLink : savedItemLinks) {
                if (!type.equals(itemLink.getType())) continue;
                savedBaseItemLinkIds.add(itemLink.getId());
                savedBaseItemLinks.add(itemLink);
            }
        } else {
            for (BaseItemLink itemLink : savedItemLinks) {
                if (!PropertyValidator.isValid((Object)itemLink.getItemId())) continue;
                savedBaseItemLinkIds.add(itemLink.getId());
                savedBaseItemLinks.add(itemLink);
            }
        }
        ArrayList baseItemLinksToDelete = new ArrayList(savedBaseItemLinks);
        ArrayList baseItemLinkIdsToDelete = new ArrayList(savedBaseItemLinkIds);
        for (BaseItemLink lk : savedBaseItemLinksFromInputItem) {
            baseItemLinksToDelete.remove(lk);
            baseItemLinkIdsToDelete.remove(lk.getId());
        }
        this.baseItemLinkRepository.deleteByIdIn(baseItemLinkIdsToDelete);
        if ("item".equals(type)) {
            for (Object itemLink : savedItemLinks) {
                if (PropertyValidator.isValid((Object)itemLink.getItemId())) {
                    itemId = itemLink.getId();
                    if (baseItemLinkIdsToDelete.contains(itemId)) continue;
                    updatedBaseItemLinks.add((BaseItemLink)itemLink);
                    continue;
                }
                updatedBaseItemLinks.add((BaseItemLink)itemLink);
            }
        } else {
            for (Object itemLink : savedItemLinks) {
                itemId = itemLink.getId();
                if (baseItemLinkIdsToDelete.contains(itemId)) continue;
                updatedBaseItemLinks.add((BaseItemLink)itemLink);
            }
        }
        if (PropertyValidator.isValid(newItemLinks)) {
            newItemLinks = this.baseItemLinkRepository.save(newItemLinks);
        }
        updatedBaseItemLinks.addAll(newItemLinks);
        savedBatch.setBaseItemLinks(updatedBaseItemLinks);
        savedBatch = (BaseItem)this.baseItemRepository.save((Object)savedBatch);
        List newAttachedItemList = new ArrayList();
        if ("item".equals(type)) {
            if (PropertyValidator.isValid(newItemLinks)) {
                newAttachedItemList = this.itemRepository.findByIdIn((Collection)newItemLinks.stream().map(BaseItemLink::getItemId).collect(Collectors.toList()));
                for (Item newAttachedItem : newAttachedItemList) {
                    if (!PropertyValidator.isValid((Collection)newAttachedItem.getBatches())) {
                        newAttachedItem.setBatches(new ArrayList());
                    }
                    newAttachedItem.getBatches().add(savedBatch);
                }
            }
            if (PropertyValidator.isValid(baseItemLinksToDelete)) {
                List detachedItemFromBatchList = this.itemRepository.findByIdIn((Collection)baseItemLinksToDelete.stream().map(BaseItemLink::getItemId).collect(Collectors.toList()));
                block7: for (Item detachedItem : detachedItemFromBatchList) {
                    if (!PropertyValidator.isValid((Collection)detachedItem.getBatches())) {
                        detachedItem.setBatches(new ArrayList());
                        continue;
                    }
                    for (BaseItem obj : detachedItem.getBatches()) {
                        if (obj == null || !Objects.equals(obj.getId(), savedBatch.getId())) continue;
                        detachedItem.getBatches().remove(obj);
                        continue block7;
                    }
                }
                newAttachedItemList.addAll(detachedItemFromBatchList);
            }
            if (PropertyValidator.isValid(newAttachedItemList)) {
                this.itemRepository.save(newAttachedItemList);
            }
        }
        HashMap linkedItemsAndUpdatedItem = this.filterExternalItems(savedBatch, inputItem);
        return new ResponseEntity((Object)linkedItemsAndUpdatedItem, HttpStatus.OK);
    }

    @RequestMapping(value={"/unlink-backlog-item-batch/{syncId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> editBackLogItems(@RequestBody Map<String, Object> requestMap, @PathVariable(value="syncId") String syncId) {
        HashMap<String, Exception> response = new HashMap<String, Exception>();
        try {
            String backlogItemId = (String)requestMap.get("backlogItemId");
            String batchId = (String)requestMap.get("batchId");
            this.batchService.unlinkBackLogItemFromBatch(backlogItemId, batchId);
            return new ResponseEntity(response, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error("Error while unlinking backlog item and batch", (Object)StringUtils.getTraceString((Throwable)e));
            response.put("error", e);
            return new ResponseEntity(response, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/update-link-sequence/{syncId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> updateLinkSequence(@RequestBody Map<String, Object> requestMap, @PathVariable(value="syncId") String syncId) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            String backlogItemId = (String)requestMap.get("baseItemId");
            String sequence = (String)requestMap.get("sequence");
            String batchId = (String)requestMap.get("batchId");
            this.batchService.updateLinkSequence(backlogItemId, batchId, sequence);
            response.put("sequence", sequence);
            return new ResponseEntity(response, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error("Error while updating link sequence", (Object)StringUtils.getTraceString((Throwable)e));
            response.put("error", e);
            return new ResponseEntity(response, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/link-backLogItems-with-batch/{syncId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> editBackLogItems(@RequestBody BaseItem inputItem, @PathVariable(value="syncId") String syncId) {
        try {
            if (!PropertyValidator.isValid((Object)inputItem)) {
                HashMap<String, Object> responseJson = new HashMap<String, Object>();
                responseJson.put("success", false);
                responseJson.put("reason", "Invalid Input");
                return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
            }
            HashMap response = this.batchService.linkBackLogItemToBatch(inputItem.getBaseItemLinks(), inputItem.getId());
            return new ResponseEntity((Object)response, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            HashMap<String, Exception> response = new HashMap<String, Exception>();
            response.put("error", e);
            return new ResponseEntity(response, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/link-baseitem/{syncId}/{type}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> linkBaseItem(@RequestBody BaseItem inputItem, @PathVariable(value="syncId") String syncId, @PathVariable(value="type") String type) {
        try {
            BaseItem savedBatch = (BaseItem)this.baseItemRepository.findOne((Serializable)((Object)inputItem.getId()));
            if (!PropertyValidator.isValid((Object)savedBatch)) {
                HashMap<String, Object> responseJson = new HashMap<String, Object>();
                responseJson.put("success", false);
                responseJson.put("reason", "Invalid Input");
                return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
            }
            List savedItemLinks = savedBatch.getBaseItemLinks();
            List<Object> newItemLinks = new ArrayList<BaseItemLink>();
            ArrayList<BaseItemLink> updatedBaseItemLinks = new ArrayList<BaseItemLink>();
            ArrayList<String> savedBaseItemLinkIdsFromInputItem = new ArrayList<String>();
            ArrayList<String> savedBaseItemLinkIds = new ArrayList<String>();
            for (BaseItemLink itemLink : inputItem.getBaseItemLinks()) {
                if (!PropertyValidator.isValid((Object)itemLink.getId())) {
                    newItemLinks.add(itemLink);
                    continue;
                }
                savedBaseItemLinkIdsFromInputItem.add(itemLink.getId());
            }
            for (BaseItemLink itemLink : savedItemLinks) {
                if (!type.equals(itemLink.getType())) continue;
                savedBaseItemLinkIds.add(itemLink.getId());
            }
            ArrayList baseItemLinkIdsToDelete = new ArrayList(savedBaseItemLinkIds);
            baseItemLinkIdsToDelete.removeAll(savedBaseItemLinkIdsFromInputItem);
            this.baseItemLinkRepository.deleteByIdIn(baseItemLinkIdsToDelete);
            for (BaseItemLink itemLink : savedItemLinks) {
                String itemId = itemLink.getId();
                if (baseItemLinkIdsToDelete.contains(itemId)) continue;
                updatedBaseItemLinks.add(itemLink);
            }
            if (PropertyValidator.isValid(newItemLinks)) {
                newItemLinks = this.baseItemLinkRepository.save(newItemLinks);
            }
            updatedBaseItemLinks.addAll(newItemLinks);
            savedBatch.setBaseItemLinks(updatedBaseItemLinks);
            savedBatch = (BaseItem)this.baseItemRepository.save((Object)savedBatch);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("updatedBatch", savedBatch);
            response.put("attachedObjectivesList", this.fetchAttachedObjectives(updatedBaseItemLinks));
            return new ResponseEntity(response, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            HashMap<String, Exception> response = new HashMap<String, Exception>();
            response.put("error", e);
            return new ResponseEntity(response, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private List<BaseItem> fetchAttachedObjectives(List<BaseItemLink> updatedBaseItemLinks) {
        ArrayList<BaseItem> attachedObjectiveBaseItems = new ArrayList();
        ArrayList<String> attachedObjectiveBaseItemIds = new ArrayList<String>();
        for (BaseItemLink link : updatedBaseItemLinks) {
            if (!EnumBaseItemTypes.OBJECTIVE.getName().equals(link.getType()) || !PropertyValidator.isValid((Object)link.getBaseItemId())) continue;
            attachedObjectiveBaseItemIds.add(link.getBaseItemId());
        }
        attachedObjectiveBaseItems = this.baseItemRepository.findByIdIn(attachedObjectiveBaseItemIds);
        return attachedObjectiveBaseItems;
    }

    private HashMap<String, Object> filterExternalItems(BaseItem savedImpediment, BaseItem impediment) {
        HashMap externalItemIds = new HashMap();
        List savedImpedimentContainers = savedImpediment.getBaseItemLinks();
        List impedimentContainers = impediment.getBaseItemLinks();
        List<Object> impedimentSessionIds = new ArrayList();
        for (BaseItemLink impdtContainer : savedImpedimentContainers) {
            if (!PropertyValidator.isValid((Object)impdtContainer.getSessionId())) continue;
            impedimentSessionIds.add(impdtContainer.getSessionId());
        }
        impedimentSessionIds = impedimentSessionIds.stream().distinct().collect(Collectors.toList());
        List sessions = this.sessionRepository.findByIdIn(impedimentSessionIds);
        ArrayList<String> savedLinkedItemsIds = new ArrayList<String>();
        HashMap savedLinkedItemsById = new HashMap();
        ArrayList<Item> savedLinkedItems = new ArrayList<Item>();
        ArrayList<String> linkedItemsIds = new ArrayList<String>();
        HashMap linkedItemsById = new HashMap();
        ArrayList<Item> linkedItems = new ArrayList<Item>();
        for (BaseItemLink itemLink : savedImpedimentContainers) {
            if (!PropertyValidator.isValid((Object)itemLink.getItemId())) continue;
            savedLinkedItemsIds.add(itemLink.getItemId());
            if (PropertyValidator.isValid((Object)itemLink.getLinkedItemById())) {
                savedLinkedItemsById.putAll(itemLink.getLinkedItemById());
            }
            if (!PropertyValidator.isValid(linkedItems)) continue;
            savedLinkedItems.add(itemLink.getLinkedItem());
        }
        for (BaseItemLink itemLink : impedimentContainers) {
            if (!PropertyValidator.isValid((Object)itemLink.getItemId())) continue;
            linkedItemsIds.add(itemLink.getItemId());
            if (PropertyValidator.isValid((Object)itemLink.getLinkedItemById())) {
                linkedItemsById.putAll(itemLink.getLinkedItemById());
            }
            if (!PropertyValidator.isValid((Object)itemLink.getLinkedItemById())) continue;
            linkedItems.add(itemLink.getLinkedItem());
        }
        List itemsList = this.setActiveBoardItems(savedImpediment, sessions, externalItemIds, new HashMap());
        if (PropertyValidator.isValid((Collection)itemsList)) {
            this.setFeatureStoryPoints(savedLinkedItems);
            HashMap filteredKeys = savedLinkedItemsById;
            if (PropertyValidator.isValid(filteredKeys)) {
                externalItemIds.putAll(filteredKeys);
            }
            if (PropertyValidator.isValid(linkedItemsById)) {
                externalItemIds.putAll(linkedItemsById);
            }
            for (BaseItemLink itemLink : savedImpedimentContainers) {
                if (!PropertyValidator.isValid((Object)itemLink.getItemId())) continue;
                HashMap newLinkedItemById = new HashMap();
                newLinkedItemById.put(itemLink.getItemId(), externalItemIds.get(itemLink.getItemId()));
                itemLink.setLinkedItemById(newLinkedItemById);
            }
            savedImpedimentContainers = this.baseItemLinkRepository.save((Iterable)savedImpedimentContainers);
            savedImpediment.setBaseItemLinks(savedImpedimentContainers);
            savedImpediment = (BaseItem)this.baseItemRepository.save((Object)savedImpediment);
            for (BaseItemLink itemLink : savedImpediment.getBaseItemLinks()) {
                itemLink.adjustLinkedItemIds();
            }
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        this.setFeatureStoryPoints(itemsList);
        for (Item item : itemsList) {
            item.setSubItems(this.batchService.fetchChildItemsOrUserStories(item.getId()));
        }
        response.put("savedImpediment", savedImpediment);
        response.put("linkedItems", itemsList);
        return response;
    }

    private BaseItem filterExternalItemsPiBoard(BaseItem savedImpediment, BaseItem impediment) {
        HashMap externalItemIds = new HashMap();
        List savedImpedimentContainers = savedImpediment.getBaseItemLinks();
        List impedimentContainers = impediment.getBaseItemLinks();
        List<Object> impedimentSessionIds = new ArrayList();
        for (BaseItemLink impdtContainer : savedImpedimentContainers) {
            if (!PropertyValidator.isValid((Object)impdtContainer.getSessionId())) continue;
            impedimentSessionIds.add(impdtContainer.getSessionId());
        }
        impedimentSessionIds = impedimentSessionIds.stream().distinct().collect(Collectors.toList());
        List sessions = this.sessionRepository.findByIdIn(impedimentSessionIds);
        ArrayList<String> savedLinkedItemsIds = new ArrayList<String>();
        HashMap savedLinkedItemsById = new HashMap();
        ArrayList<Item> savedLinkedItems = new ArrayList<Item>();
        ArrayList<String> linkedItemsIds = new ArrayList<String>();
        HashMap linkedItemsById = new HashMap();
        ArrayList<Item> linkedItems = new ArrayList<Item>();
        for (BaseItemLink itemLink : savedImpedimentContainers) {
            if (!PropertyValidator.isValid((Object)itemLink.getItemId())) continue;
            savedLinkedItemsIds.add(itemLink.getItemId());
            if (PropertyValidator.isValid((Object)itemLink.getLinkedItemById())) {
                savedLinkedItemsById.putAll(itemLink.getLinkedItemById());
            }
            if (!PropertyValidator.isValid(linkedItems)) continue;
            savedLinkedItems.add(itemLink.getLinkedItem());
        }
        for (BaseItemLink itemLink : impedimentContainers) {
            if (!PropertyValidator.isValid((Object)itemLink.getItemId())) continue;
            linkedItemsIds.add(itemLink.getItemId());
            if (PropertyValidator.isValid((Object)itemLink.getLinkedItemById())) {
                linkedItemsById.putAll(itemLink.getLinkedItemById());
            }
            if (!PropertyValidator.isValid((Object)itemLink.getLinkedItemById())) continue;
            linkedItems.add(itemLink.getLinkedItem());
        }
        List itemsList = this.setActiveBoardItems(savedImpediment, sessions, externalItemIds, new HashMap());
        if (PropertyValidator.isValid((Collection)itemsList)) {
            this.setFeatureStoryPoints(savedLinkedItems);
            HashMap filteredKeys = savedLinkedItemsById;
            if (PropertyValidator.isValid(filteredKeys)) {
                externalItemIds.putAll(filteredKeys);
            }
            if (PropertyValidator.isValid(linkedItemsById)) {
                externalItemIds.putAll(linkedItemsById);
            }
            for (BaseItemLink itemLink : savedImpedimentContainers) {
                if (!PropertyValidator.isValid((Object)itemLink.getItemId())) continue;
                HashMap newLinkedItemById = new HashMap();
                newLinkedItemById.put(itemLink.getItemId(), externalItemIds.get(itemLink.getItemId()));
                itemLink.setLinkedItemById(newLinkedItemById);
            }
            savedImpedimentContainers = this.baseItemLinkRepository.save((Iterable)savedImpedimentContainers);
            savedImpediment.setBaseItemLinks(savedImpedimentContainers);
            savedImpediment = (BaseItem)this.baseItemRepository.save((Object)savedImpediment);
            for (BaseItemLink itemLink : savedImpediment.getBaseItemLinks()) {
                itemLink.adjustLinkedItemIds();
            }
        }
        HashMap response = new HashMap();
        this.setFeatureStoryPoints(itemsList);
        return savedImpediment;
    }

    private void setFeatureStoryPoints(List<Item> items) {
        if (!PropertyValidator.isValid(items)) {
            throw new KendisException("Invalid Items");
        }
        for (Item item : items) {
            if (!PropertyValidator.isValid((Object)item) || !item.getType().equals("Feature")) continue;
            Double storyPoints = 0.0;
            List childList = this.itemRepository.findByParentId(item.getId());
            for (Item childItem : childList) {
                if (!PropertyValidator.isValid((Object)childItem)) continue;
                storyPoints = storyPoints + childItem.getStoryPoints();
            }
            item.setStoryPoints(storyPoints);
        }
    }

    private List<Item> setActiveBoardItems(BaseItem impediment, List<Session> sessions, Map<String, Object> externalIds, Map<String, Item> externalItemsMap) {
        ArrayList<ObjectId> activeSessionBoardIds = new ArrayList<ObjectId>();
        if (PropertyValidator.isValid(sessions)) {
            for (Session s : sessions) {
                activeSessionBoardIds.add(new ObjectId(s.getActiveSessionBoard()));
            }
        }
        List impedimentContainers = impediment.getBaseItemLinks();
        List<Object> linkedItemsIds = new ArrayList<String>();
        HashMap linkedItemsById = new HashMap();
        List<Object> linkedItems = new ArrayList<Item>();
        for (BaseItemLink itemLink : impedimentContainers) {
            if (!PropertyValidator.isValid((Object)itemLink.getItemId())) continue;
            linkedItemsIds.add(itemLink.getItemId());
            if (PropertyValidator.isValid((Object)itemLink.getLinkedItemById())) {
                linkedItemsById.putAll(itemLink.getLinkedItemById());
            }
            if (!PropertyValidator.isValid(linkedItems)) continue;
            linkedItems.add(itemLink.getLinkedItem());
        }
        List objectIds = KendisUtils.getListAsObjectIds(linkedItemsIds);
        if (externalIds == null) {
            externalIds = new HashMap<String, Object>();
        }
        if (PropertyValidator.isValid(activeSessionBoardIds) && PropertyValidator.isValid(linkedItemsIds)) {
            Query query = new Query();
            Criteria criteria1 = new Criteria();
            criteria1.orOperator(new Criteria[]{Criteria.where((String)"_id").in((Collection)objectIds), Criteria.where((String)"originItemId").in(linkedItemsIds)});
            Criteria criteria2 = Criteria.where((String)"sessionBoards.$id").in(activeSessionBoardIds);
            Criteria criteria3 = new Criteria();
            criteria3.andOperator(new Criteria[]{criteria1, criteria2});
            query.addCriteria((CriteriaDefinition)criteria3);
            List itemList = this.mongoTemplate.find(query, Item.class);
            if (PropertyValidator.isValid((Collection)itemList)) {
                List itemIds = itemList.stream().map(BaseEntity::getId).collect(Collectors.toList());
                linkedItemsIds = itemIds;
                linkedItems = itemList;
                for (Item item : itemList) {
                    itemIds.add(item.getId());
                    if (PropertyValidator.isValid((Object)item.getJiraId())) {
                        String externalLink = this.getItemLink(item);
                        item.setExternalReferenceURL(externalLink);
                    }
                    if (externalIds != null) {
                        externalIds.put(item.getId(), this.toSimpleObject(item));
                    }
                    if (externalItemsMap == null || linkedItemsById == null) continue;
                    linkedItemsById.remove(item.getId());
                    if (PropertyValidator.isValid((Object)item.getJiraId())) {
                        externalItemsMap.put(item.getJiraKey(), item);
                        continue;
                    }
                    if (!PropertyValidator.isValid((Object)item.getTfsId())) continue;
                    externalItemsMap.put(item.getTfsId(), item);
                }
            } else {
                linkedItemsIds = new ArrayList();
            }
        }
        if (externalItemsMap != null && linkedItemsById != null) {
            Set ids = linkedItemsById.keySet();
            ArrayList<String> keys = new ArrayList<String>();
            HashMap<String, String> idByKey = new HashMap<String, String>();
            for (String id : ids) {
                Map obj = (Map)linkedItemsById.get(id);
                String localId = (String)obj.get("localId");
                if (PropertyValidator.isValid((Object)localId)) continue;
                String key = (String)obj.get("key");
                idByKey.put(key + "_" + (String)obj.get("session_id"), id);
                keys.add(key);
            }
            Query query = new Query();
            Criteria criteria1 = new Criteria();
            criteria1.orOperator(new Criteria[]{Criteria.where((String)"jiraKey").in(keys), Criteria.where((String)"tfsId").in(keys)});
            Criteria criteria2 = Criteria.where((String)"sessionBoards.$id").in(activeSessionBoardIds);
            Criteria idNotIn = Criteria.where((String)"_id").nin((Collection)objectIds);
            Criteria criteria3 = new Criteria();
            criteria3.andOperator(new Criteria[]{criteria1, criteria2, idNotIn});
            query.addCriteria((CriteriaDefinition)criteria3);
            List itemList = this.mongoTemplate.find(query, Item.class);
            if (PropertyValidator.isValid((Collection)itemList)) {
                for (Item item : itemList) {
                    String externalLink = this.getItemLink(item);
                    item.setExternalReferenceURL(externalLink);
                    if (!PropertyValidator.isValid((Collection)item.getSessionBoards())) continue;
                    String sId = ((SessionBoard)item.getSessionBoards().get(0)).getSession().getId();
                    if (PropertyValidator.isValid((Object)item.getJiraId())) {
                        if (idByKey.containsKey(item.getJiraKey() + "_" + sId)) {
                            linkedItemsById.remove(idByKey.get(item.getJiraKey() + "_" + sId));
                        }
                    } else if (PropertyValidator.isValid((Object)item.getTfsId()) && idByKey.containsKey(item.getTfsId() + "_" + sId)) {
                        linkedItemsById.remove(idByKey.get(item.getTfsId() + "_" + sId));
                    }
                    if (externalIds.containsKey(item.getId())) continue;
                    linkedItems.add(item);
                    linkedItemsIds.add(item.getId());
                }
            }
            if (PropertyValidator.isValid(ids = linkedItemsById.keySet())) {
                linkedItemsIds.addAll(ids);
            }
        }
        return linkedItems;
    }

    private String getItemLink(Item item) {
        String externalLink = "";
        if (!PropertyValidator.isValid((Collection)item.getSessionBoards())) {
            return null;
        }
        SessionBoard sessionBoard = (SessionBoard)item.getSessionBoards().get(0);
        Session session = sessionBoard.getSession();
        String referenceBaseUrl = null;
        if (session.getAlmEnabled().booleanValue()) {
            if (PropertyValidator.isValid((Collection)session.getAlmConfigurations())) {
                referenceBaseUrl = PropertyValidator.isValid((Object)((AlmConfigurations)session.getAlmConfigurations().get(0)).getAlmAccount().getJiraAuthRedirectURL()) ? ((AlmConfigurations)session.getAlmConfigurations().get(0)).getAlmAccount().getJiraAuthRedirectURL() + "/browse" : ((AlmConfigurations)session.getAlmConfigurations().get(0)).getAlmAccount().getUrl() + "/browse";
            } else if (PropertyValidator.isValid((Object)session.getTfsAlmConfigurations())) {
                referenceBaseUrl = item.getTfsURL();
            }
        } else {
            referenceBaseUrl = session.getJiraBaseURL() != null ? session.getJiraBaseURL() : "";
        }
        if (item.getJiraKey() != null && item.getJiraId() != null) {
            externalLink = referenceBaseUrl.equals("") ? "javascript:void(0);" : referenceBaseUrl + "/" + item.getJiraKey();
        } else if (item.getJiraKey() != null && item.getExternalReferenceURL() != null) {
            externalLink = item.getExternalReferenceURL();
        } else if (item.getJiraKey() != null) {
            externalLink = referenceBaseUrl.equals("") ? "javascript:void(0);" : referenceBaseUrl + "/" + item.getJiraKey();
        }
        return externalLink;
    }

    public HashMap<String, ? super Object> toSimpleObject(Item item) {
        HashMap<String, String> rowData = new HashMap<String, String>();
        if (PropertyValidator.isValid((Object)item.getJiraId())) {
            rowData.put("jiraId", item.getJiraId());
            rowData.put("jiraKey", item.getJiraKey());
            rowData.put("key", item.getJiraKey());
        }
        if (PropertyValidator.isValid((Object)item.getTfsId())) {
            rowData.put("tfsId", item.getTfsId());
            rowData.put("key", item.getTfsId());
            rowData.put("tfsURL", item.getTfsURL());
        }
        if (!PropertyValidator.isValid((Object)item.getTfsId()) && !PropertyValidator.isValid((Object)item.getJiraId())) {
            if (PropertyValidator.isValid((Object)item.getJiraKey())) {
                rowData.put("key", item.getJiraKey());
            } else if (PropertyValidator.isValid((Object)item.getKendisKey())) {
                rowData.put("key", item.getKendisKey());
            } else {
                rowData.put("key", "");
            }
            rowData.put("localId", item.getId());
        } else if (PropertyValidator.isValid((Object)item.getExternalReferenceURL())) {
            rowData.put("externalReferenceURL", this.getItemLink(item));
        } else {
            rowData.put("externalReferenceURL", item.getExternalReferenceURL());
        }
        if (PropertyValidator.isValid((Collection)item.getSessionBoards()) && PropertyValidator.isValid(item.getSessionBoards().get(0)) && PropertyValidator.isValid((Object)((SessionBoard)item.getSessionBoards().get(0)).getSession())) {
            rowData.put("sessionBoard_id", ((SessionBoard)item.getSessionBoards().get(0)).getId());
            rowData.put("session_id", ((SessionBoard)item.getSessionBoards().get(0)).getSession().getId());
            rowData.put("session_title", ((SessionBoard)item.getSessionBoards().get(0)).getSession().getTitle());
        }
        return rowData;
    }

    @ResponseBody
    public ResponseEntity<Object> deleteBaseItemLink(@RequestBody HashMap<String, Object> requestBody) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        String itemId = (String)requestBody.get("itemId");
        String baseItemId = (String)requestBody.get("id");
        String itemType = (String)requestBody.get("itemType");
        BaseItem savedItem = (BaseItem)this.baseItemRepository.findOne((Serializable)((Object)baseItemId));
        if (!PropertyValidator.isValid((Object)savedItem)) {
            responseJson = new HashMap();
            responseJson.put("success", false);
            responseJson.put("reason", "Invalid Input");
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        List linkedItems = savedItem.getBaseItemLinks();
        HashMap<String, BaseItemLink> linkedItemMap = new HashMap<String, BaseItemLink>();
        for (BaseItemLink itemLink : linkedItems) {
            if (!PropertyValidator.isValid((Object)itemType)) {
                if (!PropertyValidator.isValid((Object)itemLink.getItemId())) continue;
                linkedItemMap.put(itemLink.getItemId(), itemLink);
                continue;
            }
            if (!itemType.equals("BaseItem") || !PropertyValidator.isValid((Object)itemLink.getBaseItemId())) continue;
            linkedItemMap.put(itemLink.getBaseItemId(), itemLink);
        }
        BaseItemLink linkedItemToRemove = (BaseItemLink)linkedItemMap.get(itemId);
        if (PropertyValidator.isValid((Object)linkedItemToRemove)) {
            linkedItemToRemove.setArchive(true);
            this.baseItemLinkRepository.save((Object)linkedItemToRemove);
            Item detachedItem = this.itemRepository.findById(itemId);
            if (!PropertyValidator.isValid((Collection)detachedItem.getBatches())) {
                detachedItem.setBatches(new ArrayList());
            }
            for (BaseItem obj : detachedItem.getBatches()) {
                if (obj == null || !Objects.equals(obj.getId(), savedItem.getId())) continue;
                detachedItem.getBatches().remove(obj);
                break;
            }
            if (PropertyValidator.isValid((Object)detachedItem)) {
                this.itemRepository.save((Object)detachedItem);
            }
            responseJson.put("savedImpediment", savedItem);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/delete-batch"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> deleteBatch(@RequestBody HashMap<String, String> requestBody) {
        HashMap responseJson = new HashMap();
        try {
            responseJson = this.batchService.deleteBatchById(requestBody);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/upload-file"})
    public ResponseEntity<Object> uploadImage(@RequestParam(value="file") MultipartFile file) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            Attachment attachment = this.attachmentService.uploadAttachmentForItem(file);
            if (!PropertyValidator.isValid((Object)attachment)) {
                responseJson.put("success", false);
                responseJson.put("reason", "problem while uploading file");
                return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
            }
            List retrievedImages = new ArrayList<Attachment>();
            retrievedImages.add(attachment);
            retrievedImages = this.attachmentService.fetchAttachmentData(retrievedImages);
            if (!PropertyValidator.isValid(retrievedImages)) {
                responseJson.put("success", false);
                responseJson.put("reason", "Internal error");
                return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
            }
            if (PropertyValidator.isValid(retrievedImages)) {
                responseJson.put("fileData", retrievedImages.get(0));
            }
            responseJson.put("uploadedFile", attachment);
            responseJson.put("success", true);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            responseJson.put("success", false);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/get-batch-icon"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getAttachmentData(@RequestBody HashMap<String, String> requestBody) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            String attachmentId = requestBody.get("attachmentId");
            Attachment attachment = (Attachment)this.attachmentRepository.findOne((Serializable)((Object)attachmentId));
            if (!PropertyValidator.isValid((Object)attachment)) {
                responseJson.put("success", false);
                responseJson.put("reason", "Invalid Input");
                return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
            }
            List retrievedImages = new ArrayList<Attachment>();
            retrievedImages.add(attachment);
            retrievedImages = this.attachmentService.fetchAttachmentData(retrievedImages);
            if (!PropertyValidator.isValid(retrievedImages)) {
                responseJson.put("success", false);
                responseJson.put("reason", "Internal error");
                return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
            }
            if (PropertyValidator.isValid(retrievedImages)) {
                responseJson.put("attachment-populated", retrievedImages.get(0));
            }
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            responseJson.put("success", false);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/remove-batch-icon"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> removeAttachment(@RequestBody HashMap<String, String> requestBody) {
        HashMap<String, Serializable> responseJson = new HashMap<String, Serializable>();
        try {
            String attachmentId = requestBody.get("attachmentId");
            String baseItemId = requestBody.get("baseItemId");
            String itemType = requestBody.getOrDefault("itemType", "baseItem");
            if (!PropertyValidator.isValid((Object)attachmentId) || !PropertyValidator.isValid((Object)baseItemId)) {
                responseJson.put("success", Boolean.valueOf(false));
                return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
            }
            Attachment attachment = (Attachment)this.attachmentRepository.findOne((Serializable)((Object)attachmentId));
            if (!PropertyValidator.isValid((Object)attachment)) {
                responseJson.put("success", Boolean.valueOf(false));
                LOGGER.error("*****getAttachmentData**** -----> Attachment not found for deletion. ---------------");
                return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
            }
            if (!this.attachmentService.removeAttachmentData(attachment.getReferenceKey())) {
                responseJson.put("success", Boolean.valueOf(false));
                LOGGER.error("*****getAttachmentData**** -----> Unable to remove attachment from storage ---------------");
                return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
            }
            if (itemType.equals("customView")) {
                ObjectiveCustomView customView = (ObjectiveCustomView)this.objectiveCustomViewRepository.findOne((Serializable)((Object)baseItemId));
                if (PropertyValidator.isValid((Object)customView)) {
                    customView.setImageIcon(null);
                    this.objectiveCustomViewRepository.save((Object)customView);
                }
            } else {
                BaseItem baseItem = this.baseItemRepository.findById(baseItemId);
                baseItem.setImageIcon(null);
                this.baseItemRepository.save((Object)baseItem);
            }
            this.attachmentRepository.deleteById(attachmentId);
            responseJson.put("success", Boolean.valueOf(true));
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            responseJson.put("success", Boolean.valueOf(false));
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/get-attached-release-trains"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getAttachedReleaseTrains(@RequestBody HashMap<String, String> requestBody) {
        HashMap<String, Serializable> responseJson = new HashMap<String, Serializable>();
        List<Object> releaseTrains = new ArrayList();
        try {
            HashSet<String> releaseTrainIds = new HashSet<String>();
            String batchId = requestBody.get("batchId");
            if (!PropertyValidator.isValid((Object)batchId)) {
                responseJson.put("success", Boolean.valueOf(false));
                LOGGER.error("*****getAttachedReleaseTrains**** -----> Invalid batchId ---------------");
                return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
            }
            BaseItem batch = (BaseItem)this.baseItemRepository.findOne((Serializable)((Object)batchId));
            if (!PropertyValidator.isValid((Object)batch)) {
                responseJson.put("success", Boolean.valueOf(false));
                LOGGER.error(String.format("*****getAttachedReleaseTrains**** -----> Batch does not exists for id :%s---------------", batchId));
                return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
            }
            for (BaseItemLink link : batch.getBaseItemLinks()) {
                if (!PropertyValidator.isValid((Object)link) || link.isArchive() || !"backLogItem".equals(link.getLinkType()) || !PropertyValidator.isValid((Object)link.getReleaseTrainId())) continue;
                releaseTrainIds.add(link.getReleaseTrainId());
            }
            releaseTrains = this.workSpaceRepository.findByIdIn(new ArrayList(releaseTrainIds));
            HashMap<String, List> backlogHierarchyLevels = new HashMap<String, List>();
            for (WorkSpace releaseTrain : releaseTrains) {
                List hierarchyLevels = this.releaseTrainService.getHierarchyLevels(releaseTrain);
                backlogHierarchyLevels.put(releaseTrain.getId(), hierarchyLevels);
            }
            releaseTrains = releaseTrains.stream().distinct().collect(Collectors.toList());
            responseJson.put("attachedReleaseTrains", (Serializable)((Object)releaseTrains));
            responseJson.put("backlogHierarchyLevels", backlogHierarchyLevels);
            responseJson.put("success", Boolean.valueOf(true));
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            responseJson.put("success", Boolean.valueOf(false));
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/save-relationships"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveRelationships(@RequestBody Map<String, Object> request) {
        HashMap responseJson = new HashMap();
        try {
            responseJson = this.batchService.saveRelationships(request);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/unlink-art-relation"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> unlinkArtRelation(@RequestBody Map<String, String> request) {
        HashMap<String, Exception> responseJson = new HashMap<String, Exception>();
        try {
            this.batchService.unlinkArtRelation(request);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/unlink-relative-batch-relation"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> unlinkRelativeBatch(@RequestBody Map<String, String> request) {
        HashMap<String, Exception> responseJson = new HashMap<String, Exception>();
        try {
            this.batchService.unlinkRelativeBatch(request);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/get-batch-relation-details/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getObjectiveRelationDetails(@PathVariable(value="id") String objId) {
        HashMap responseJson = new HashMap();
        try {
            responseJson = this.batchService.loadBatchRelationDetails(objId);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/get-fields-list-for-batch/{batchId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getFieldsListForBatch(@PathVariable(value="batchId") String batchId) {
        HashMap responseJson = new HashMap();
        try {
            responseJson = this.batchService.getFieldsForBatch(batchId);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)responseJson, HttpStatus.OK);
    }

    @PutMapping(value={"/update-batch-dates"})
    public ResponseEntity<Object> updateBatchDates(@RequestBody Map<String, Object> request) {
        HashMap<String, Serializable> responseJson = new HashMap<String, Serializable>();
        try {
            String batchId = (String)request.get("batchId");
            String startDate = (String)request.get("startDate");
            String endDate = (String)request.get("endDate");
            BaseItem updatedBatch = this.batchService.updateBatchDates(batchId, startDate, endDate);
            if (updatedBatch == null) {
                responseJson.put("success", Boolean.valueOf(false));
                return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
            }
            responseJson.put("updatedBatch", (Serializable)updatedBatch);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/move-backlog-items-batches/{syncId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> moveItemLinks(@RequestBody BaseItemBulkItemsDTO baseItemBulkItemsDTO, @PathVariable(value="syncId") String syncId) {
        Map<String, Exception> response = new HashMap();
        try {
            response = this.batchService.moveBulkItems(baseItemBulkItemsDTO);
            return new ResponseEntity(response, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error("Error while moving backlog items", (Object)StringUtils.getTraceString((Throwable)e));
            response.put("error", e);
            return new ResponseEntity(response, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @PostMapping(value={"/create-timeseries-data-batches"})
    @ResponseBody
    public ResponseEntity<Object> calculateTimeSeriesDataBatches(@RequestBody Map<String, Object> requestBody) {
        Map<String, Exception> response = new HashMap();
        try {
            response = this.batchService.createDataForBatchesProgress(requestBody);
            return new ResponseEntity(response, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            response.put("error", e);
            return new ResponseEntity(response, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/save-batch-completion-criteria/{id}"})
    @ResponseBody
    public ResponseEntity<Object> saveBatchCompletionCriteria(@PathVariable String id, @RequestBody Map<String, Object> payload) {
        HashMap responseJson = new HashMap();
        try {
            String criteria = payload.getOrDefault("selectedCriteria", null);
            responseJson = this.batchService.saveBatchCompletionCriteria(id, criteria);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)responseJson, HttpStatus.OK);
    }
}

