/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.controller;

import com.viztrend.safe.persistence.entity.Conversation;
import com.viztrend.safe.service.AzureDevOpsExtensionService;
import com.viztrend.safe.utils.StringUtils;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/{companyPrefix}/extension"})
@RestController
public class AzureDevOpsExtensionController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AzureDevOpsExtensionController.class);
    @Autowired
    private AzureDevOpsExtensionService azureDevOpsExtensionService;

    @PostMapping(value={"/fetch-dependencies"}, produces={"application/json"})
    public ResponseEntity<Object> fetchDependencies(@PathVariable String companyPrefix, @RequestBody Map<String, Object> requestBody) {
        LOGGER.info("Fetching dependencies for Azure DevOps Extension");
        try {
            if (!requestBody.containsKey("workItemData")) {
                return ResponseEntity.badRequest().body((Object)"Work item data is required");
            }
            if (requestBody.get("workItemData") instanceof Map) {
                Map workItemData = (Map)requestBody.get("workItemData");
                if (workItemData.isEmpty()) {
                    return ResponseEntity.badRequest().body((Object)"Work item data is required");
                }
                Map response = this.azureDevOpsExtensionService.fetchDependencies(companyPrefix, workItemData);
                return ResponseEntity.ok((Object)response);
            }
        }
        catch (Exception e) {
            LOGGER.debug(StringUtils.getTraceString((Throwable)e));
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Error fetching dependencies");
        }
        return ResponseEntity.badRequest().body((Object)"Illegal request format");
    }

    @PostMapping(value={"/fetch-jira-dependencies"}, produces={"application/json"})
    public ResponseEntity<Object> fetchJiraDependencies(@PathVariable String companyPrefix, @RequestBody Map<String, Object> requestBody) {
        LOGGER.info("Fetching dependencies for Jira App");
        try {
            Object workItemDataObj = requestBody.get("workItemData");
            if (!(workItemDataObj instanceof Map) || ((Map)workItemDataObj).isEmpty()) {
                return ResponseEntity.badRequest().body((Object)"Work item data is required and must not be empty.");
            }
            Map workItemData = (Map)workItemDataObj;
            Map response = this.azureDevOpsExtensionService.fetchJiraDependencies(companyPrefix, workItemData);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Error fetching dependencies");
        }
    }

    @PostMapping(value={"/fetch-images"}, produces={"application/json"})
    public ResponseEntity<Object> fetchImages(@RequestBody Map<String, Object> requestBody) {
        LOGGER.info("Fetching images for Azure DevOps Extension");
        try {
            Map response = this.azureDevOpsExtensionService.fetchImages(requestBody);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            LOGGER.debug(StringUtils.getTraceString((Throwable)e));
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Error fetching images");
        }
    }

    @PostMapping(value={"/search-users"}, produces={"application/json"})
    public ResponseEntity<Object> searchUsers(@RequestBody Map<String, Object> requestBody) {
        try {
            Map response = this.azureDevOpsExtensionService.searchUsers(requestBody);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            LOGGER.debug(StringUtils.getTraceString((Throwable)e));
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Error searching for users");
        }
    }

    @PostMapping(value={"/edit-ado-dependency"}, produces={"application/json"})
    public ResponseEntity<Object> editADODependency(@RequestBody Map<String, Object> requestBody) {
        try {
            return this.azureDevOpsExtensionService.editADODependency(requestBody);
        }
        catch (Exception e) {
            LOGGER.debug(StringUtils.getTraceString((Throwable)e));
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Error editing ADO dependency");
        }
    }

    @GetMapping(value={"/fetch-statuses"}, produces={"application/json"})
    public ResponseEntity<Object> fetchStatuses(@RequestParam String sessionId) {
        try {
            return ResponseEntity.ok((Object)this.azureDevOpsExtensionService.fetchStatusList(sessionId));
        }
        catch (Exception e) {
            LOGGER.debug(StringUtils.getTraceString((Throwable)e));
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Error fetching statuses");
        }
    }

    @GetMapping(value={"/fetch-comments"}, produces={"application/json"})
    public ResponseEntity<Object> fetchComments(@RequestParam String dependencyId, @RequestParam String linkOrigin) {
        try {
            Map response = this.azureDevOpsExtensionService.fetchComments(dependencyId, linkOrigin);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            LOGGER.debug(StringUtils.getTraceString((Throwable)e));
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Error fetching comments");
        }
    }

    @PostMapping(value={"/save-comments/{dependencyId}"}, produces={"application/json"})
    public ResponseEntity<Object> saveComments(@PathVariable String dependencyId, @RequestBody List<Conversation> comments) {
        try {
            return this.azureDevOpsExtensionService.saveComments(dependencyId, comments);
        }
        catch (Exception e) {
            LOGGER.debug(StringUtils.getTraceString((Throwable)e));
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Error saving comments");
        }
    }
}

