/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.controller;

import com.amazonaws.util.IOUtils;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import com.stripe.Stripe;
import com.stripe.model.Customer;
import com.stripe.model.PaymentMethod;
import com.stripe.model.StripeObject;
import com.viztrend.exception.ViztrendJiraException;
import com.viztrend.safe.alm.jira.TFSResponse;
import com.viztrend.safe.alm.jira.TFSUtils;
import com.viztrend.safe.config.AppConfig;
import com.viztrend.safe.controller.AdminController;
import com.viztrend.safe.controller.KhufiaKari;
import com.viztrend.safe.enums.EnumEmailConfig;
import com.viztrend.safe.enums.EnumFeature;
import com.viztrend.safe.enums.EnumPermission;
import com.viztrend.safe.enums.EnumWorkSpaceType;
import com.viztrend.safe.persistence.entity.AlmAccUser;
import com.viztrend.safe.persistence.entity.AlmAccount;
import com.viztrend.safe.persistence.entity.ApiToken;
import com.viztrend.safe.persistence.entity.AzureOAuthToken;
import com.viztrend.safe.persistence.entity.BaseItem;
import com.viztrend.safe.persistence.entity.Company;
import com.viztrend.safe.persistence.entity.Config;
import com.viztrend.safe.persistence.entity.Customize;
import com.viztrend.safe.persistence.entity.Fields;
import com.viztrend.safe.persistence.entity.Group;
import com.viztrend.safe.persistence.entity.Invitation;
import com.viztrend.safe.persistence.entity.IssueType;
import com.viztrend.safe.persistence.entity.JiraOauthToken;
import com.viztrend.safe.persistence.entity.MailConfig;
import com.viztrend.safe.persistence.entity.Oauth2Config;
import com.viztrend.safe.persistence.entity.PaymentDetails;
import com.viztrend.safe.persistence.entity.PaymentPackageConfig;
import com.viztrend.safe.persistence.entity.PaymentTransactions;
import com.viztrend.safe.persistence.entity.Preferences;
import com.viztrend.safe.persistence.entity.Role;
import com.viztrend.safe.persistence.entity.SAMLConfig;
import com.viztrend.safe.persistence.entity.ScrumOfScrums;
import com.viztrend.safe.persistence.entity.SecurityPolicy;
import com.viztrend.safe.persistence.entity.Severity;
import com.viztrend.safe.persistence.entity.Status;
import com.viztrend.safe.persistence.entity.Team;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.UserApiKey;
import com.viztrend.safe.persistence.entity.UserCompany;
import com.viztrend.safe.persistence.entity.UserPreferences;
import com.viztrend.safe.persistence.entity.VatCountry;
import com.viztrend.safe.persistence.entity.WorkFlow;
import com.viztrend.safe.persistence.entity.WorkSpace;
import com.viztrend.safe.persistence.entity.WorkSpaceAccessRole;
import com.viztrend.safe.persistence.entity.WorkSpaceType;
import com.viztrend.safe.persistence.entity.dto.LdapUser;
import com.viztrend.safe.persistence.entity.dto.SecureUser;
import com.viztrend.safe.persistence.repository.AlmAccountRepository;
import com.viztrend.safe.persistence.repository.AlmConfigurationsRepository;
import com.viztrend.safe.persistence.repository.ApiTokenRepository;
import com.viztrend.safe.persistence.repository.BlackListUserDomainRepository;
import com.viztrend.safe.persistence.repository.CompanyRepository;
import com.viztrend.safe.persistence.repository.ConfigRepository;
import com.viztrend.safe.persistence.repository.CustomRepository;
import com.viztrend.safe.persistence.repository.GroupRepository;
import com.viztrend.safe.persistence.repository.InvitationRepository;
import com.viztrend.safe.persistence.repository.IssueTypeRepository;
import com.viztrend.safe.persistence.repository.ItemRepository;
import com.viztrend.safe.persistence.repository.Oauth2ConfigRepository;
import com.viztrend.safe.persistence.repository.ObjectiveCustomViewRepository;
import com.viztrend.safe.persistence.repository.PaymentDetailsRepository;
import com.viztrend.safe.persistence.repository.PaymentTransactionsRepository;
import com.viztrend.safe.persistence.repository.RiskRegisterRepository;
import com.viztrend.safe.persistence.repository.RoleRepository;
import com.viztrend.safe.persistence.repository.SAMLConfigRepository;
import com.viztrend.safe.persistence.repository.ScrumOfScrumsRepository;
import com.viztrend.safe.persistence.repository.ServerCacheRepository;
import com.viztrend.safe.persistence.repository.SessionRepository;
import com.viztrend.safe.persistence.repository.SeverityRepository;
import com.viztrend.safe.persistence.repository.SolutionAreaRepository;
import com.viztrend.safe.persistence.repository.SolutionBoardRepository;
import com.viztrend.safe.persistence.repository.StatusRepository;
import com.viztrend.safe.persistence.repository.TFSAlmConfigurationsRepository;
import com.viztrend.safe.persistence.repository.TeamRepository;
import com.viztrend.safe.persistence.repository.TokenRepository;
import com.viztrend.safe.persistence.repository.UserApiKeyRepository;
import com.viztrend.safe.persistence.repository.UserRepository;
import com.viztrend.safe.persistence.repository.VatCountryRepository;
import com.viztrend.safe.persistence.repository.WorkFlowRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceAccessRoleRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceRepository;
import com.viztrend.safe.service.ALMSyncService;
import com.viztrend.safe.service.APIService;
import com.viztrend.safe.service.LDAPService;
import com.viztrend.safe.service.PaymentService;
import com.viztrend.safe.service.ReleaseTrainService;
import com.viztrend.safe.service.UserService;
import com.viztrend.safe.service.WebHookSyncService;
import com.viztrend.safe.service.WorkSpaceTypeService;
import com.viztrend.safe.utils.AlmUtils;
import com.viztrend.safe.utils.EncDecUtility;
import com.viztrend.safe.utils.KendisUtils;
import com.viztrend.safe.utils.LocalMailSender;
import com.viztrend.safe.utils.MongoSyncUtils;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.TwoFactorAuthUtil;
import com.viztrend.safe.utils.UserContextUtil;
import com.viztrend.safe.vos.JiraConnectVO;
import com.viztrend.safe.vos.WebhookResponseVO;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.bson.types.ObjectId;
import org.codehaus.jackson.map.ObjectMapper;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.ldap.filter.AndFilter;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.ldap.filter.Filter;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.w3c.dom.Document;

@RequestMapping(value={"/admin"})
@RestController
public class AdminController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdminController.class);
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private GroupRepository groupRepository;
    @Autowired
    private WorkSpaceRepository workSpaceRepository;
    @Autowired
    private TeamRepository teamRepository;
    @Autowired
    private WorkSpaceAccessRoleRepository workSpaceAccessRoleRepository;
    @Autowired
    private SessionRepository sessionRepository;
    @Autowired
    private RoleRepository roleRepository;
    @Autowired
    private AlmAccountRepository almAccountRepository;
    @Autowired
    private WorkFlowRepository workFlowRepository;
    @Autowired
    private StatusRepository statusRepository;
    @Autowired
    private SeverityRepository severityRepository;
    @Autowired
    @Qualifier(value="LDAPServiceImpl")
    private LDAPService ldapService;
    @Autowired
    private ConfigRepository configRepository;
    @Autowired
    private ReleaseTrainService releasetrainService;
    @Autowired
    private CustomRepository customRepository;
    @Autowired
    private LocalMailSender localMailSender;
    @Autowired
    private Oauth2ConfigRepository oauth2ConfigRepository;
    @Autowired
    private PaymentTransactionsRepository paymentTransactionsRepository;
    @Autowired
    private PaymentDetailsRepository paymentDetailsRepository;
    @Autowired
    private VatCountryRepository vatCountryRepository;
    @Autowired
    private ALMSyncService aLMSyncService;
    @Autowired
    private IssueTypeRepository issueTypeRepository;
    @Autowired
    private ItemRepository itemRepository;
    @Autowired
    private LocalMailSender mailSender;
    @Autowired
    private AlmConfigurationsRepository almConfigurationsRepository;
    @Autowired
    private UserService userService;
    @Autowired
    private TFSAlmConfigurationsRepository tfsAlmConfigurationsRepository;
    @Autowired
    private CompanyRepository companyRepository;
    @Autowired
    private TokenRepository tokenRepository;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private InvitationRepository invitationRepository;
    @Autowired
    private SAMLConfigRepository samlConfigRepository;
    @Autowired
    private ApiTokenRepository apiTokenRepository;
    @Autowired
    private SolutionBoardRepository solutionBoardRepository;
    @Autowired
    private RiskRegisterRepository riskRegisterRepository;
    @Autowired
    private ScrumOfScrumsRepository scrumOfScrumsRepository;
    @Autowired
    private WebHookSyncService webHookSyncService;
    @Autowired
    private PaymentService paymentService;
    @Autowired
    BlackListUserDomainRepository blackListUserDomainRepository;
    @Autowired
    private Environment env;
    @Autowired
    private TFSUtils tfsUtils;
    @Autowired
    private AppConfig.MongoConfig mongoConfig;
    @Autowired
    private WorkSpaceTypeService workSpaceTypeService;
    @Autowired
    private ServerCacheRepository serverCacheRepository;
    @Autowired
    private UserApiKeyRepository userApiKeyRepository;
    @Autowired
    private APIService apiService;
    @Autowired
    private ObjectiveCustomViewRepository objectiveCustomViewRepository;
    @Autowired
    private SolutionAreaRepository solutionAreaRepository;

    @RequestMapping(value={"/billing"})
    @ResponseBody
    public ResponseEntity<Object> getGetBillingInfo() {
        long diff;
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        User user = (User)secureUser.getUserContextDTO().getContextMap().get("user");
        User userObject = (User)this.userRepository.findOne((Serializable)((Object)user.getId()));
        UserCompany userCompany = userObject.getUserCompanies().stream().filter(uCompany -> uCompany.getCompany().getId().equals(UserContextUtil.getUserContext().getCurrentCompany().getId())).findFirst().orElse(null);
        long daysLeft = 0L;
        daysLeft = PropertyValidator.isValid((Object)userCompany.getCompany().getExpiryDate()) ? ((diff = userCompany.getCompany().getExpiryDate().getTime() - new Date().getTime()) > 0L ? TimeUnit.DAYS.convert(diff, TimeUnit.MILLISECONDS) : -1L) : -2L;
        userObject.setTrialDaysLeft(daysLeft);
        HashMap<String, Long> responseJson = new HashMap<String, Long>();
        responseJson.put("daysLeft", daysLeft);
        responseJson.put("expiryDate", userCompany.getCompany().getExpiryDate().getTime());
        responseJson.put("nextPaymentDate", userCompany.getCompany().getNextPaymentDate().getTime());
        responseJson.put("userCount", userCompany.getCompany().getUserCount());
        responseJson.put("duration", userCompany.getCompany().getDuration());
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/tfsAuth"}, method={RequestMethod.POST})
    public TFSResponse tfsAuthentication(@RequestBody HashMap<String, Object> requestBody) {
        TFSResponse response;
        boolean isProfile;
        String url = (String)requestBody.get("url");
        String userName = (String)requestBody.get("userName");
        String password = (String)requestBody.get("password");
        String almId = (String)requestBody.get("almAccountId");
        String isProfileStr = (String)requestBody.get("isProfile");
        HashMap oAuth = (HashMap)requestBody.get("oauthToken");
        AzureOAuthToken oAuthToken = null;
        if (PropertyValidator.isValid((Object)oAuth)) {
            oAuthToken = new AzureOAuthToken(oAuth);
        }
        boolean bl = isProfile = PropertyValidator.isValid((Object)isProfileStr) && isProfileStr.equals("true");
        if (isProfile) {
            SecureUser secureUser;
            User user;
            User userObject;
            List almCredentials;
            if (!PropertyValidator.isValid((Object)password) && !PropertyValidator.isValid((Object)oAuthToken) && PropertyValidator.isValid((Object)almId) && PropertyValidator.isValid((Collection)(almCredentials = (userObject = (User)this.userRepository.findOne((Serializable)((Object)(user = (User)(secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUserContextDTO().getContextMap().get("user")).getId()))).getAlmCredentials()))) {
                for (AlmAccUser cred : almCredentials) {
                    if (!cred.getAlmAccId().equals(almId)) continue;
                    if (PropertyValidator.isValid((Object)cred.getAzureOAuthToken())) {
                        oAuthToken = cred.getAzureOAuthToken();
                    } else {
                        password = cred.getAlmPassword();
                    }
                    break;
                }
            }
        } else if (PropertyValidator.isValid((Object)almId)) {
            AlmAccount almAccount = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almId));
            if (!PropertyValidator.isValid((Object)password)) {
                password = almAccount.getPassword();
            }
        }
        boolean isTokenRefreshed = false;
        try {
            if (PropertyValidator.isValid((Object)oAuthToken) && this.tfsUtils.isInValidToken(oAuthToken)) {
                oAuthToken = this.tfsUtils.refreshAlmToken(oAuthToken, almId);
                if (isProfile) {
                    this.tfsUtils.updateAlmAccUserAuthToken(oAuthToken, almId, null);
                } else {
                    this.tfsUtils.updateAlmAccount(oAuthToken, almId);
                }
                isTokenRefreshed = true;
            }
        }
        catch (ViztrendJiraException exception) {
            LOGGER.error(exception.getMessage());
        }
        TFSResponse tFSResponse = response = PropertyValidator.isValid((Object)oAuthToken) ? this.tfsUtils.authenticateOAuthToken(oAuthToken) : this.tfsUtils.authenticate(url, userName, password, null);
        if (isTokenRefreshed) {
            Gson gson = new Gson();
            Map responseMap = (Map)gson.fromJson(response.getContent(), new /* Unavailable Anonymous Inner Class!! */.getType());
            responseMap.put("isTokenRefreshed", true);
            responseMap.put("oauthToken", oAuthToken);
            response.setContent(gson.toJson((Object)responseMap));
        }
        return response;
    }

    @RequestMapping(value={"/tfsAuth"})
    public TFSResponse tfsAuthenticationNew(@RequestBody String payload) {
        boolean isProfile;
        Gson g = new Gson();
        2 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap reqbody = (HashMap)g.fromJson(payload, T.getType());
        String tfsURL = (String)reqbody.get("url");
        String userName = (String)reqbody.get("userName");
        String password = (String)reqbody.get("password");
        String almId = (String)reqbody.get("almAccountId");
        String isProfileStr = (String)reqbody.get("isProfile");
        HashMap oAuth = (HashMap)reqbody.get("oAuthToken");
        AzureOAuthToken oAuthToken = null;
        if (PropertyValidator.isValid((Object)oAuth)) {
            oAuthToken = new AzureOAuthToken(oAuth);
        }
        boolean bl = isProfile = PropertyValidator.isValid((Object)isProfileStr) && isProfileStr.equals("true");
        if (isProfile) {
            SecureUser secureUser;
            User user;
            User userObject;
            List almCredentials;
            if (!PropertyValidator.isValid((Object)password) && PropertyValidator.isValid((Object)almId) && PropertyValidator.isValid((Collection)(almCredentials = (userObject = (User)this.userRepository.findOne((Serializable)((Object)(user = (User)(secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUserContextDTO().getContextMap().get("user")).getId()))).getAlmCredentials()))) {
                for (AlmAccUser cred : almCredentials) {
                    if (!cred.getAlmAccId().equals(almId)) continue;
                    password = cred.getAlmPassword();
                    break;
                }
            }
        } else if (PropertyValidator.isValid((Object)almId)) {
            AlmAccount almAccount = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almId));
            password = almAccount.getPassword();
        }
        return this.tfsUtils.authenticate(tfsURL, userName, password, oAuthToken);
    }

    @RequestMapping(value={"/updateRiskEnableFlag/{riskEnabled}"})
    public Boolean updateRiskEnableFlag(@PathVariable(value="riskEnabled") Boolean riskEnabled) {
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        User user = (User)secureUser.getUserContextDTO().getContextMap().get("user");
        User userObject = (User)this.userRepository.findOne((Serializable)((Object)user.getId()));
        UserCompany userCompany = userObject.getUserCompanies().stream().filter(uCompany -> uCompany.getCompany().getId().equals(UserContextUtil.getUserContext().getCurrentCompany().getId())).findFirst().orElse(null);
        userCompany.getCompany().setRiskEnabled(riskEnabled.booleanValue());
        this.companyRepository.save((Object)userCompany.getCompany());
        return userCompany.getCompany().isRiskEnabled();
    }

    @RequestMapping(value={"/ldapGroups"})
    public List<LdapUser> getLdapGroups() {
        return this.ldapService.listGroups();
    }

    @RequestMapping(value={"/ldapUsers"})
    public List<LdapUser> getLdapUsers(@RequestBody String groupDn) {
        return this.ldapService.listUsers(groupDn);
    }

    @RequestMapping(value={"/groups"})
    public Object[] getGroups() {
        Object[] objects = new Object[2];
        String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
        List groups = this.groupRepository.findAll();
        List accessRoles = this.workSpaceAccessRoleRepository.findByGroupIn(groups);
        for (int i = 0; i < groups.size(); ++i) {
            for (WorkSpaceAccessRole accessRole : accessRoles) {
                Group group = (Group)groups.get(i);
                if (!PropertyValidator.isValid((Object)accessRole.getGroup()) || !group.getId().equals(accessRole.getGroup().getId())) continue;
                if (!PropertyValidator.isValid((Collection)group.getAccessRoles())) {
                    group.setAccessRoles(new ArrayList());
                }
                if (group.getAccessRoles().contains(accessRole)) continue;
                group.getAccessRoles().add(accessRole);
            }
        }
        List users = this.customRepository.findUnarchviedUsersByCompany(cid);
        for (int i = 0; i < users.size(); ++i) {
            User user = (User)users.get(i);
            for (int j = 0; j < user.getUserCompanies().size(); ++j) {
                if (!((UserCompany)user.getUserCompanies().get(j)).getCompany().getId().equals(cid)) continue;
                user.setIsSuperAdmin(((UserCompany)user.getUserCompanies().get(j)).getIsAdmin());
                user.setIsAdmin(((UserCompany)user.getUserCompanies().get(j)).getIsAdmin());
                user.setIsActive(((UserCompany)user.getUserCompanies().get(j)).getIsActive());
                user.setIsGuest(((UserCompany)user.getUserCompanies().get(j)).getIsGuest());
            }
        }
        objects[0] = groups;
        objects[1] = users;
        return objects;
    }

    @RequestMapping(value={"/groupstolink"})
    public List<Group> getGroupsToLink() {
        PageRequest pageable = new PageRequest(0, 10000);
        Page page = this.groupRepository.findAll((Pageable)pageable);
        List groups = page.getContent();
        return groups;
    }

    @RequestMapping(value={"/userstolink"})
    public List<User> getUsersToLink() {
        List users = this.customRepository.findUnarchviedUsersByCompany(UserContextUtil.getUserContext().getCurrentCompanyId());
        return users;
    }

    @RequestMapping(value={"/markadmin/{uid}"})
    public User markSuperAdmins(@PathVariable(value="uid") String id) {
        User user = this.userRepository.findById(id);
        if (PropertyValidator.isValid((Object)user)) {
            if (PropertyValidator.isValid((Collection)user.getUserCompanies())) {
                String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
                if (PropertyValidator.isValid((Collection)user.getUserCompanies())) {
                    for (int i = 0; i < user.getUserCompanies().size(); ++i) {
                        if (!cid.equals(((UserCompany)user.getUserCompanies().get(i)).getCompany().getId())) continue;
                        ((UserCompany)user.getUserCompanies().get(i)).setIsAdmin(Boolean.valueOf(true));
                        break;
                    }
                }
            }
            return (User)this.userRepository.save((Object)user);
        }
        return null;
    }

    @RequestMapping(value={"/unmarkadmin/{uid}"})
    public User unmarkSuperAdmins(@PathVariable(value="uid") String id) {
        List superAdmins = this.userRepository.findByUserCompanies_Company_IdAndUserCompanies_isAdmin(UserContextUtil.getUserContext().getCurrentCompanyId(), Boolean.valueOf(true));
        if (PropertyValidator.isValid((Collection)superAdmins) && superAdmins.size() <= 1) {
            return null;
        }
        User user = this.userRepository.findById(id);
        if (PropertyValidator.isValid((Object)user)) {
            if (PropertyValidator.isValid((Collection)user.getUserCompanies())) {
                String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
                if (PropertyValidator.isValid((Collection)user.getUserCompanies())) {
                    for (int i = 0; i < user.getUserCompanies().size(); ++i) {
                        if (!cid.equals(((UserCompany)user.getUserCompanies().get(i)).getCompany().getId())) continue;
                        ((UserCompany)user.getUserCompanies().get(i)).setIsAdmin(Boolean.valueOf(false));
                        break;
                    }
                }
            }
            return (User)this.userRepository.save((Object)user);
        }
        return null;
    }

    @RequestMapping(value={"/authorizationMode"})
    public ResponseEntity<Object> checkAutherizationMode() {
        ApiToken apiToken;
        HashMap<String, Boolean> response = new HashMap<String, Boolean>();
        Config config = this.retrieveConfiguration();
        response.put("ldap", false);
        response.put("login", false);
        if (PropertyValidator.isValid((Object)config) && PropertyValidator.isValid((Object)config.getLdapConfig())) {
            response.put("ldap", config.getLdapConfig().isAuthorization());
            response.put("login", config.getLdapConfig().isLogin());
        }
        if ((apiToken = this.apiTokenRepository.findByProvider("Okta")) != null && apiToken.getToken() != null && !apiToken.getToken().replaceAll("\\s+", "").isEmpty()) {
            response.put("okta", true);
        } else {
            response.put("okta", false);
        }
        return new ResponseEntity(response, HttpStatus.OK);
    }

    @RequestMapping(value={"/superadmins"})
    public ResponseEntity<Object> getSuperAdmins() {
        HashMap response = new HashMap();
        Config config = this.retrieveConfiguration();
        if (PropertyValidator.isValid((Object)config) && PropertyValidator.isValid((Object)config.getLdapConfig()) && !config.getLdapConfig().isAuthorization()) {
            List users = this.userRepository.findByUserCompanies_Company_IdAndUserCompanies_IsArchiveFalseAndUserCompanies_isAdminAndUserCompanies_isGuest(UserContextUtil.getUserContext().getCurrentCompanyId(), Boolean.valueOf(false), Boolean.valueOf(false));
            response.put("users", users);
        }
        List superAdmins = this.userRepository.findByUserCompanies_Company_IdAndUserCompanies_IsArchiveFalseAndUserCompanies_isAdmin(UserContextUtil.getUserContext().getCurrentCompanyId(), Boolean.valueOf(true));
        List superAdminsForCurrentCompany = superAdmins.stream().filter(superAdmin -> superAdmin.getUserCompanies().stream().anyMatch(userCompany -> userCompany.getIsAdmin() != false && PropertyValidator.isValid((Object)userCompany.getCompany()) && userCompany.getCompany().getId().equals(UserContextUtil.getUserContext().getCurrentCompanyId()))).collect(Collectors.toList());
        response.put("superAdmins", superAdminsForCurrentCompany);
        return new ResponseEntity(response, HttpStatus.OK);
    }

    @RequestMapping(value={"/get/userpreference/{id}"})
    @ResponseBody
    public ResponseEntity<Object> getUserPreference(@PathVariable(value="id") String id) {
        User user = this.userRepository.findById(id);
        HashMap<String, Object> response = new HashMap<String, Object>();
        HashMap<String, String> enumNarrativeByCode = new HashMap<String, String>();
        if (PropertyValidator.isValid((Object)user)) {
            if (PropertyValidator.isValid((Object)user.getUserPreferences()) && PropertyValidator.isValid((Object)user.getUserPreferences().getEmailConfig())) {
                HashMap emailConfig = user.getUserPreferences().getEmailConfig();
                if (!PropertyValidator.isValid(emailConfig.get("Objective"))) {
                    EnumEmailConfig[] preferencesMap = new HashMap();
                    Preferences preferences = new Preferences(false);
                    preferences.getDefaultActionTypes();
                    for (EnumEmailConfig enumItem : EnumEmailConfig.values()) {
                        preferencesMap.put(enumItem.getCode(), preferences);
                        enumNarrativeByCode.put(enumItem.getCode(), enumItem.getNarrative());
                    }
                    emailConfig.put("Objective", preferencesMap);
                    user.getUserPreferences().setEmailConfig(emailConfig);
                    user = (User)this.userRepository.save((Object)user);
                }
                response.put("userPreferences", user.getUserPreferences());
                for (EnumEmailConfig enumItem : EnumEmailConfig.values()) {
                    enumNarrativeByCode.put(enumItem.getCode(), enumItem.getNarrative());
                }
            } else {
                UserPreferences userPreferences = new UserPreferences();
                if (PropertyValidator.isValid((Object)user.getUserPreferences()) && PropertyValidator.isValid((Object)user.getUserPreferences().isEnableForDependency())) {
                    userPreferences.setEnableForDependency(user.getUserPreferences().isEnableForDependency());
                } else {
                    userPreferences.setEnableForDependency(true);
                }
                if (PropertyValidator.isValid((Object)user.getUserPreferences()) && PropertyValidator.isValid((Object)user.getUserPreferences().isEnableForObjective())) {
                    userPreferences.setEnableForObjective(user.getUserPreferences().isEnableForObjective());
                } else {
                    userPreferences.setEnableForObjective(true);
                }
                HashMap<String, Preferences> preferencesMap = new HashMap<String, Preferences>();
                Preferences preferences = new Preferences(false);
                preferences.getDefaultActionTypes();
                for (EnumEmailConfig enumItem : EnumEmailConfig.values()) {
                    preferencesMap.put(enumItem.getCode(), preferences);
                    enumNarrativeByCode.put(enumItem.getCode(), enumItem.getNarrative());
                }
                HashMap<String, HashMap<String, Preferences>> emailConfig = new HashMap<String, HashMap<String, Preferences>>();
                emailConfig.put("Dependency", preferencesMap);
                emailConfig.put("SOS", preferencesMap);
                emailConfig.put("Risk", preferencesMap);
                emailConfig.put("Objective", preferencesMap);
                userPreferences.setEmailConfig(emailConfig);
                user.setUserPreferences(userPreferences);
                this.userRepository.save((Object)user);
                response.put("userPreferences", userPreferences);
            }
        }
        response.put("narrativeByCode", enumNarrativeByCode);
        return new ResponseEntity(response, HttpStatus.OK);
    }

    @RequestMapping(value={"/save/scheduler/userpreference"})
    public ResponseEntity saveSchedulerPreference(@RequestBody HashMap requestBody) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        String type = (String)requestBody.get("type");
        String userId = (String)requestBody.get("userId");
        Map preferences = (Map)requestBody.get("preferences");
        User user = this.userRepository.findById(userId);
        HashMap emailConfig = new HashMap();
        if (PropertyValidator.isValid((Object)user) && PropertyValidator.isValid((Object)preferences)) {
            if (PropertyValidator.isValid((Object)user.getUserPreferences())) {
                if (PropertyValidator.isValid((Object)user.getUserPreferences().getEmailConfig())) {
                    emailConfig = user.getUserPreferences().getEmailConfig();
                }
                emailConfig.put(type, preferences);
                user.getUserPreferences().setEmailConfig(emailConfig);
            } else {
                UserPreferences userPreferences = new UserPreferences();
                emailConfig.put(type, preferences);
                userPreferences.setEmailConfig(emailConfig);
                user.setUserPreferences(userPreferences);
            }
        } else {
            responseJson.put("message", "Request must contain preferences");
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        this.userRepository.save((Object)user);
        responseJson.put("preferences", user.getUserPreferences());
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/save/userpreference"})
    public UserPreferences saveUserPreference(@RequestBody String requestBody) {
        try {
            Gson gson = new Gson();
            3 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap requestMap = (HashMap)gson.fromJson(requestBody, T.getType());
            String type = (String)requestMap.get("type");
            String userId = (String)requestMap.get("userId");
            Map preferencesMap = null;
            if (PropertyValidator.isValid(requestMap.get("preferences"))) {
                preferencesMap = (Map)requestMap.get("preferences");
            }
            Boolean enableAllPreferences = null;
            Boolean enableAllObjPreferences = null;
            if (PropertyValidator.isValid(requestMap.get("enableAll"))) {
                enableAllPreferences = (boolean)((Boolean)requestMap.get("enableAll"));
            }
            if (PropertyValidator.isValid(requestMap.get("enableAllObj"))) {
                enableAllObjPreferences = (boolean)((Boolean)requestMap.get("enableAllObj"));
            }
            User user = this.userRepository.findById(userId);
            HashMap emailConfig = new HashMap();
            if (PropertyValidator.isValid((Object)user)) {
                if (PropertyValidator.isValid((Object)user.getUserPreferences())) {
                    if (PropertyValidator.isValid((Object)preferencesMap)) {
                        if (PropertyValidator.isValid((Object)user.getUserPreferences().getEmailConfig())) {
                            emailConfig = user.getUserPreferences().getEmailConfig();
                        }
                        emailConfig.put(type, preferencesMap);
                        user.getUserPreferences().setEmailConfig(emailConfig);
                    } else if (PropertyValidator.isValid((Object)enableAllPreferences)) {
                        user.getUserPreferences().setEnableForDependency(enableAllPreferences.booleanValue());
                    } else if (PropertyValidator.isValid((Object)enableAllObjPreferences)) {
                        user.getUserPreferences().setEnableForObjective(enableAllObjPreferences.booleanValue());
                    }
                } else {
                    UserPreferences userPreferences = new UserPreferences();
                    if (PropertyValidator.isValid((Object)preferencesMap)) {
                        emailConfig.put(type, preferencesMap);
                        userPreferences.setEmailConfig(emailConfig);
                    } else if (PropertyValidator.isValid((Object)enableAllPreferences)) {
                        userPreferences.setEnableForDependency(enableAllPreferences.booleanValue());
                    } else if (PropertyValidator.isValid((Object)enableAllObjPreferences)) {
                        userPreferences.setEnableForObjective(enableAllObjPreferences.booleanValue());
                    }
                    user.setUserPreferences(userPreferences);
                }
                this.userRepository.save((Object)user);
                return user.getUserPreferences();
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return null;
    }

    @RequestMapping(value={"/save/group"})
    public ResponseEntity<Object> saveGroup(@RequestBody Group group) {
        Group groupr = null;
        HashMap<String, Group> response = new HashMap<String, Group>();
        if (PropertyValidator.isValid((Object)group.getId())) {
            List accessRoles;
            Sets.SetView deletedUserIds;
            List savedDeletedUsers;
            Group savedGroup = (Group)this.groupRepository.findOne((Serializable)((Object)group.getId()));
            HashSet savedUsers = savedGroup.getUsers();
            HashSet inComingUsers = group.getUsers();
            if (!PropertyValidator.isValid((Collection)savedUsers)) {
                savedUsers = new HashSet();
            }
            if (!PropertyValidator.isValid((Collection)inComingUsers)) {
                inComingUsers = new HashSet();
            }
            if (PropertyValidator.isValid((Collection)(savedDeletedUsers = this.userRepository.findByIdIn((Set)(deletedUserIds = Sets.difference(savedUsers, (Set)inComingUsers)))))) {
                for (User user : savedDeletedUsers) {
                    if (!PropertyValidator.isValid((Collection)user.getGroups())) continue;
                    user.getGroups().remove(group.getId());
                }
                this.userRepository.save((Iterable)savedDeletedUsers);
            }
            Sets.SetView newUserIds = Sets.difference(inComingUsers, savedUsers);
            List savedNewUsers = this.userRepository.findByIdIn((Set)newUserIds);
            HashSet<String> gps = new HashSet<String>();
            gps.add(group.getId());
            if (PropertyValidator.isValid((Collection)savedNewUsers)) {
                for (User user : savedNewUsers) {
                    HashSet<String> userGroups = user.getGroups();
                    if (userGroups == null) {
                        userGroups = new HashSet<String>();
                    }
                    userGroups.add(group.getId());
                    user.setGroups(userGroups);
                }
                this.userRepository.save((Iterable)savedNewUsers);
            }
            if (PropertyValidator.isValid((Collection)newUserIds) && PropertyValidator.isValid((Object)group.getUsersUnsaved())) {
                this.convertLdapUserToKendisGroupUser(group, response);
            }
            if (PropertyValidator.isValid((Collection)(accessRoles = this.workSpaceAccessRoleRepository.findByGroup(groupr = (Group)this.groupRepository.save((Object)group))))) {
                for (WorkSpaceAccessRole accessRole : accessRoles) {
                    if (!PropertyValidator.isValid((Collection)groupr.getAccessRoles())) {
                        groupr.setAccessRoles(new ArrayList());
                    }
                    if (groupr.getAccessRoles().contains(accessRole)) continue;
                    groupr.getAccessRoles().add(accessRole);
                }
            }
        } else {
            Sets.SetView newUserIds;
            List savedNewUsers;
            groupr = (Group)this.groupRepository.save((Object)group);
            HashSet savedUsers = null;
            HashSet inComingUsers = group.getUsers();
            if (!PropertyValidator.isValid(savedUsers)) {
                savedUsers = new HashSet();
            }
            if (!PropertyValidator.isValid((Collection)inComingUsers)) {
                inComingUsers = new HashSet();
            }
            if (PropertyValidator.isValid((Collection)(savedNewUsers = this.userRepository.findByIdIn((Set)(newUserIds = Sets.difference((Set)inComingUsers, savedUsers)))))) {
                for (User user : savedNewUsers) {
                    if (!PropertyValidator.isValid((Collection)user.getGroups())) {
                        user.setGroups(new HashSet());
                    }
                    user.getGroups().add(group.getId());
                }
                this.userRepository.save((Iterable)savedNewUsers);
            }
            if (PropertyValidator.isValid((Object)group.getUsersUnsaved())) {
                this.convertLdapUserToKendisGroupUser(groupr, response);
                groupr = (Group)this.groupRepository.save((Object)groupr);
            }
        }
        response.put("group", groupr);
        return new ResponseEntity(response, HttpStatus.OK);
    }

    @RequestMapping(value={"/group/{id}"})
    public Group getGroup(@PathVariable(value="id") String id) {
        Group group = (Group)this.groupRepository.findOne((Serializable)((Object)id));
        return group;
    }

    @RequestMapping(value={"/remove/group"})
    public void removeGroup(@RequestBody Group group) {
        this.groupRepository.delete((Object)group);
    }

    @RequestMapping(value={"/issuetypes"})
    @ResponseBody
    public ResponseEntity<Object> getIssueTypes(HttpServletRequest request) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            this.customRepository.createDefaulBuckets();
            response.put("issueTypes", this.issueTypeRepository.findAllByOrderBySequenceAsc());
            response.put("almAcounts", this.almAccountRepository.findAll());
            if (PropertyValidator.isValid((Object)request.getParameter("css"))) {
                InputStream is = null;
                is = this.getClass().getResourceAsStream("/static/assets/css/admin.css");
                response.put("css", IOUtils.toString((InputStream)is));
            }
        }
        catch (Exception e) {
            LOGGER.debug("issuetypes exp  : " + StringUtils.getTraceString((Throwable)e));
        }
        return new ResponseEntity(response, HttpStatus.OK);
    }

    @RequestMapping(value={"/save/issuetype"})
    public IssueType saveIssueType(@RequestBody IssueType issueType) {
        issueType.setColorUpdated(Boolean.valueOf(true));
        return (IssueType)this.issueTypeRepository.save((Object)issueType);
    }

    @RequestMapping(value={"/issuetype/sequence"})
    public IssueType saveIssueTypeSequence(@RequestBody IssueType issueType) {
        try {
            IssueType type = (IssueType)this.issueTypeRepository.findOne((Serializable)((Object)issueType.getId()));
            type.setSequence(issueType.getSequence());
            this.issueTypeRepository.save((Object)type);
            return type;
        }
        catch (Exception e) {
            LOGGER.debug("saveIssueTypeSequence exp  : " + StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    @RequestMapping(value={"/issuetype/{id}"})
    public IssueType getIssueType(@PathVariable(value="id") String id) {
        IssueType issueType = (IssueType)this.issueTypeRepository.findOne((Serializable)((Object)id));
        return issueType;
    }

    @RequestMapping(value={"/remove/issuetype"})
    public void removeTeam(@RequestBody IssueType issueType) {
        this.issueTypeRepository.delete((Object)issueType);
    }

    @RequestMapping(value={"/workspacestype"})
    public List<WorkSpaceType> getAllWorkSpacesTypes() {
        try {
            return this.workSpaceTypeService.getListOfAllWorkSpacesTypes();
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            return null;
        }
    }

    @RequestMapping(value={"/save/workspacestype/sequence"}, method={RequestMethod.POST})
    public ResponseEntity<Object> updateWorkSpaceSequence(@RequestBody String payload) {
        try {
            Gson g = new Gson();
            4 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap requestBody = (HashMap)g.fromJson(payload, T.getType());
            Object responseJson = null;
            return this.workSpaceTypeService.updateWorkSpaceSequence(requestBody);
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            return null;
        }
    }

    @RequestMapping(value={"/save/workspacestype"}, method={RequestMethod.POST})
    public ResponseEntity<Object> saveWorkSpacesTypes(@RequestBody WorkSpaceType workSpaceType) {
        try {
            return this.workSpaceTypeService.saveNewWorkSpaceType(workSpaceType);
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            return null;
        }
    }

    @RequestMapping(value={"/edit/workspacestype"}, method={RequestMethod.POST})
    public ResponseEntity<Object> editWorkSpacesTypes(@RequestBody WorkSpaceType workSpaceType) {
        try {
            return this.workSpaceTypeService.saveNewWorkSpaceType(workSpaceType);
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            return null;
        }
    }

    @RequestMapping(value={"/remove/workspacestype"}, method={RequestMethod.POST})
    public ResponseEntity<Object> removeWorkSpacesTypes(@RequestBody WorkSpaceType workSpaceType) {
        try {
            return this.workSpaceTypeService.removeWorkSpaceType(workSpaceType.getId());
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            return null;
        }
    }

    @RequestMapping(value={"/teams"})
    public Object[] getTeams() {
        Object[] objects = new Object[2];
        List teams = this.teamRepository.findAll();
        objects[0] = teams;
        List workSpaces = this.workSpaceRepository.findByIsModuleIsFalseOrIsModuleIsNull();
        objects[1] = workSpaces;
        return objects;
    }

    @RequestMapping(value={"/save/team"})
    public Team saveTeam(@RequestBody Team team) {
        Team savedTeam = (Team)this.teamRepository.save((Object)team);
        Team dbTeam = (Team)this.teamRepository.findOne((Serializable)((Object)savedTeam.getId()));
        return dbTeam;
    }

    @RequestMapping(value={"/team/{id}"})
    public Team getTeam(@PathVariable(value="id") String id) {
        Team team = (Team)this.teamRepository.findOne((Serializable)((Object)id));
        return team;
    }

    @RequestMapping(value={"/remove/team"})
    public void removeTeam(@RequestBody Team team) {
        this.teamRepository.delete((Object)team);
    }

    @RequestMapping(value={"/workspaces/{level}"})
    public ResponseEntity<Object> getWorkSpaces(@PathVariable(required=false) String level) {
        HashMap<String, List> response = new HashMap<String, List>();
        String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
        try {
            List<WorkSpace> workSpaces = new ArrayList();
            List allWorkSpaces = new ArrayList();
            if (PropertyValidator.isValid((Object)level) && !level.equals("-1")) {
                workSpaces = this.workSpaceRepository.findByLevel(Integer.valueOf(Integer.parseInt(level)));
            } else {
                allWorkSpaces = this.workSpaceRepository.findByIsModuleIsFalseOrIsModuleIsNull();
                if (PropertyValidator.isValid(allWorkSpaces)) {
                    for (WorkSpace workspace : allWorkSpaces) {
                        if (PropertyValidator.isValid((Object)workspace.getType())) continue;
                        workSpaces.add(workspace);
                    }
                }
            }
            List groups = this.getGroupsToLink();
            List users = this.customRepository.findUnarchviedUsersByCompany(cid);
            for (int i = 0; i < users.size(); ++i) {
                User user = (User)users.get(i);
                for (int j = 0; j < user.getUserCompanies().size(); ++j) {
                    if (!((UserCompany)user.getUserCompanies().get(j)).getCompany().getId().equals(cid)) continue;
                    user.setIsSuperAdmin(((UserCompany)user.getUserCompanies().get(j)).getIsAdmin());
                    user.setIsAdmin(((UserCompany)user.getUserCompanies().get(j)).getIsAdmin());
                    user.setIsActive(((UserCompany)user.getUserCompanies().get(j)).getIsActive());
                    user.setIsGuest(((UserCompany)user.getUserCompanies().get(j)).getIsGuest());
                }
            }
            List workSpacesForLinking = this.workSpaceRepository.findByIsModuleIsFalseOrIsModuleIsNull();
            List roles = this.getRoles();
            response.put("workSpaces", workSpaces);
            response.put("groups", groups);
            response.put("users", users);
            response.put("roles", roles);
            response.put("levels", EnumWorkSpaceType.getAllValuesList());
            response.put("linkableWorkSpaces", workSpacesForLinking);
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
        return new ResponseEntity(response, HttpStatus.OK);
    }

    @RequestMapping(value={"/save/workspace"}, method={RequestMethod.POST})
    public ResponseEntity<Object> saveWorkSpace(@RequestBody WorkSpace workspace) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        if (PropertyValidator.isValid((Object)workspace.getId())) {
            this.workSpaceAccessRoleRepository.delete((Iterable)this.workSpaceAccessRoleRepository.findByWorkSpace(workspace));
        } else if (PropertyValidator.isValid((Object)workspace.getType())) {
            workspace.setKey(this.customRepository.generateKey(workspace.getType().getPrefix()));
        }
        WorkSpace savedWorkSpace = (WorkSpace)this.workSpaceRepository.save((Object)workspace);
        if (PropertyValidator.isValid((Collection)workspace.getAccessRoles())) {
            for (WorkSpaceAccessRole accessRole : workspace.getAccessRoles()) {
                if (PropertyValidator.isValid((Object)accessRole.getUser())) {
                    if (accessRole.getUser().isLdap()) {
                        accessRole.getUser().setId(null);
                        User ldapUser = this.userRepository.findByUserCompanies_Company_IdAndUserNameIgnoreCase(UserContextUtil.getUserContext().getCurrentCompany().getId(), accessRole.getUser().getUserName().toLowerCase());
                        if (PropertyValidator.isValid((Object)ldapUser)) {
                            accessRole.setUser(ldapUser);
                        } else {
                            String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
                            accessRole.getUser().setUserCompanies(new ArrayList());
                            UserCompany userCompany = new UserCompany();
                            userCompany.setCompany(new Company(cid));
                            userCompany.setIsGuest(accessRole.getUser().getIsGuest());
                            accessRole.getUser().getUserCompanies().add(userCompany);
                            accessRole.getUser().setUserName(accessRole.getUser().getUserName().toLowerCase());
                            accessRole.setUser((User)this.userRepository.save((Object)accessRole.getUser()));
                        }
                    }
                } else if (PropertyValidator.isValid((Object)accessRole.getGroup()) && accessRole.getGroup().isLdap()) {
                    accessRole.getGroup().setId(null);
                    Group ldapGroup = this.groupRepository.findByTitle(accessRole.getGroup().getTitle());
                    if (PropertyValidator.isValid((Object)ldapGroup)) {
                        accessRole.setGroup(ldapGroup);
                    } else {
                        accessRole.setGroup((Group)this.groupRepository.save((Object)accessRole.getGroup()));
                    }
                }
                accessRole.setWorkSpace(new WorkSpace(savedWorkSpace.getId()));
            }
            this.workSpaceAccessRoleRepository.save((Iterable)workspace.getAccessRoles());
        }
        if (this.env.getProperty("isLocalDeployment").equals("true")) {
            LOGGER.debug(savedWorkSpace.log());
        }
        if (PropertyValidator.isValid((Object)workspace.getDescription())) {
            Map map = this.releasetrainService.saveAboutReleaseTrainDescription(workspace.getId(), workspace.getDescription());
        }
        List groups = this.getGroupsToLink();
        List users = this.customRepository.findUnarchviedUsersByCompany(UserContextUtil.getUserContext().getCurrentCompanyId());
        response.put("workSpace", savedWorkSpace);
        response.put("groups", groups);
        response.put("users", users);
        return new ResponseEntity(response, HttpStatus.OK);
    }

    @RequestMapping(value={"/update/workspace-order"})
    public ResponseEntity<Object> updateWorkSpaceOrder(@RequestBody String payload) {
        HashMap<String, Boolean> response = new HashMap<String, Boolean>();
        try {
            Gson g = new Gson();
            5 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap requestBody = (HashMap)g.fromJson(payload, T.getType());
            String id = (String)requestBody.get("workspaceId");
            Double sequence = (Double)requestBody.get("sequence");
            WorkSpace workSpace = (WorkSpace)this.workSpaceRepository.findOne((Serializable)((Object)id));
            if (PropertyValidator.isValid((Object)workSpace)) {
                workSpace.setSequence(sequence);
                this.workSpaceRepository.save((Object)workSpace);
                response.put("success", true);
            }
            return new ResponseEntity(response, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/save/useradmin"})
    public User saveAdmin(@RequestBody User user) {
        User usr = null;
        ArrayList<String> emails = new ArrayList<String>();
        emails.add(user.getEmail());
        ArrayList<String> unames = new ArrayList<String>();
        unames.add(user.getUserName().toLowerCase());
        User duplicateUserByName = this.userRepository.findByUserNameIgnoreCase(user.getUserName());
        if (PropertyValidator.isValid((Object)duplicateUserByName)) {
            user = duplicateUserByName;
            user.setIsAdmin(Boolean.valueOf(true));
            user.setIsSuperAdmin(Boolean.valueOf(true));
            if (PropertyValidator.isValid((Collection)user.getUserCompanies())) {
                user.setUserCompanies(user.getUserCompanies());
                String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
                if (PropertyValidator.isValid((Collection)user.getUserCompanies())) {
                    for (int i = 0; i < user.getUserCompanies().size(); ++i) {
                        if (!cid.equals(((UserCompany)user.getUserCompanies().get(i)).getCompany().getId())) continue;
                        ((UserCompany)user.getUserCompanies().get(i)).setIsAdmin(user.getIsSuperAdmin());
                        break;
                    }
                }
            } else {
                String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
                UserCompany userCompany = new UserCompany();
                userCompany.setCompany(new Company(cid));
                userCompany.setIsActive(Boolean.valueOf(true));
                userCompany.setIsAdmin(Boolean.valueOf(true));
                user.setUserCompanies(new ArrayList());
                user.getUserCompanies().add(userCompany);
            }
            usr = (User)this.userRepository.save((Object)user);
        } else {
            String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
            UserCompany userCompany = new UserCompany();
            userCompany.setCompany(new Company(cid));
            userCompany.setIsActive(Boolean.valueOf(true));
            userCompany.setIsAdmin(Boolean.valueOf(true));
            user.setUserCompanies(new ArrayList());
            user.getUserCompanies().add(userCompany);
            usr = (User)this.userRepository.save((Object)user);
        }
        return usr;
    }

    @RequestMapping(value={"/workspace/{id}"})
    public WorkSpace getWorkSpace(@PathVariable(value="id") String id) {
        WorkSpace workSpace = (WorkSpace)this.workSpaceRepository.findOne((Serializable)((Object)id));
        List accessRoles = new ArrayList();
        accessRoles = this.workSpaceAccessRoleRepository.findByWorkSpace(workSpace);
        String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
        for (WorkSpaceAccessRole accessRole : accessRoles) {
            User user = accessRole.getUser();
            if (!PropertyValidator.isValid((Object)user) || !PropertyValidator.isValid((Collection)user.getUserCompanies())) continue;
            for (int j = 0; j < user.getUserCompanies().size(); ++j) {
                if (!((UserCompany)user.getUserCompanies().get(j)).getCompany().getId().equals(cid)) continue;
                user.setIsSuperAdmin(((UserCompany)user.getUserCompanies().get(j)).getIsAdmin());
                user.setIsAdmin(((UserCompany)user.getUserCompanies().get(j)).getIsAdmin());
                user.setIsActive(((UserCompany)user.getUserCompanies().get(j)).getIsActive());
                user.setIsGuest(((UserCompany)user.getUserCompanies().get(j)).getIsGuest());
            }
        }
        workSpace.setAccessRoles(accessRoles);
        return workSpace;
    }

    @RequestMapping(value={"/remove/workspace"})
    public void removeWorkSpace(@RequestBody WorkSpace workspace) {
        this.workSpaceRepository.delete((Object)workspace);
    }

    @RequestMapping(value={"/roles"})
    public List<Role> getRoles() {
        return this.roleRepository.findAll();
    }

    @RequestMapping(value={"/rnp"})
    public Object[] getRolesAndPermissions() {
        Object[] objects = new Object[]{this.roleRepository.findAll(), EnumPermission.getAllValuesList()};
        return objects;
    }

    @RequestMapping(value={"/save/role"})
    public Role saveRole(@RequestBody Role role) {
        return (Role)this.roleRepository.save((Object)role);
    }

    @RequestMapping(value={"/role/{id}"})
    public Role getRole(@PathVariable(value="id") String id) {
        Role role = (Role)this.roleRepository.findOne((Serializable)((Object)id));
        return role;
    }

    @RequestMapping(value={"/remove/role"})
    public void removeRole(@RequestBody Role role) {
        this.roleRepository.delete((Object)role);
    }

    @RequestMapping(value={"/almaccounts"})
    public List<AlmAccount> getAlmAccounts() {
        return this.almAccountRepository.findAll();
    }

    @RequestMapping(value={"/connect/accounts"})
    public List<JiraConnectVO> getConnectAccounts() {
        return this.aLMSyncService.getConnectAccounts();
    }

    @RequestMapping(value={"/connect/accounts/{accountId}"})
    public JiraConnectVO getConnectAccountUser(@PathVariable(value="accountId") String accountId) {
        return this.aLMSyncService.getConnectAccountUser(accountId);
    }

    @RequestMapping(value={"/connect/useforuser"}, method={RequestMethod.POST})
    public ResponseEntity<Object> getCanUseConnectForUser(@RequestBody HashMap<String, String> requestPayload) {
        String domainId = requestPayload.get("domainId");
        String userId = requestPayload.get("userId");
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"kendisUserId").is((Object)userId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"atlassianHostDomain.$id").is((Object)new ObjectId(domainId)));
        DBCursor dbCursorPrefix = this.mongoTemplate.getCollection("atlassianHostDomainUser").find(query.getQueryObject());
        List objects = dbCursorPrefix.toArray();
        if (PropertyValidator.isValid((Collection)objects)) {
            responseJson.put("success", true);
        } else {
            responseJson.put("success", false);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/connect/use"})
    public ResponseEntity<Object> getCanUseConnect() {
        String urlPrefix = UserContextUtil.getUserContext().getCurrentCompanyPrefix();
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"urlPrefix").is((Object)urlPrefix));
        DBCursor dbCursorPrefix = this.mongoTemplate.getCollection("atlassianHostDomain").find(query.getQueryObject());
        List objects = dbCursorPrefix.toArray();
        HashMap responseJson = new HashMap();
        ArrayList hostDomains = new ArrayList();
        if (PropertyValidator.isValid((Collection)objects)) {
            for (int i = 0; i < objects.size(); ++i) {
                HashMap<String, Object> obj = new HashMap<String, Object>();
                DBObject vo = (DBObject)objects.get(i);
                DBRef hostRef = (DBRef)vo.get("host");
                obj.put("id", String.valueOf(vo.get("_id")));
                obj.put("urlPrefix", (String)vo.get("urlPrefix"));
                obj.put("jiraUserId", (String)vo.get("jiraUserId"));
                obj.put("defaultGroupId", String.valueOf(vo.get("defaultGroupId")));
                HashMap<String, Object> host = new HashMap<String, Object>();
                host.put("id", String.valueOf(hostRef.getId()));
                Query _query = new Query();
                _query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is(hostRef.getId()));
                DBCursor _dbCursorPrefix = this.mongoTemplate.getCollection("atlassianHost").find(_query.getQueryObject());
                if (_dbCursorPrefix.hasNext()) {
                    DBObject hostObj = _dbCursorPrefix.next();
                    host.put("publicKey", (String)hostObj.get("publicKey"));
                    host.put("oauthClientId", (String)hostObj.get("oauthClientId"));
                    host.put("sharedSecret", (String)hostObj.get("sharedSecret"));
                    host.put("baseUrl", (String)hostObj.get("baseUrl"));
                    host.put("productType", (String)hostObj.get("productType"));
                    host.put("description", (String)hostObj.get("description"));
                    host.put("addonInstalled", (Boolean)hostObj.get("addonInstalled"));
                }
                obj.put("host", host);
                hostDomains.add(obj);
            }
        }
        responseJson.put("hostDomains", hostDomains);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/account/status"})
    @ResponseBody
    public ResponseEntity<Object> updateAlmAccountStatus(@RequestBody String requestStr) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        Gson g = new Gson();
        6 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap reqbody = (HashMap)g.fromJson(requestStr, T.getType());
        String almAccountId = (String)reqbody.get("id");
        Boolean isActive = (Boolean)reqbody.get("active");
        AlmAccount almAccount = this.almAccountRepository.findById(almAccountId);
        almAccount.setIsActive(isActive);
        this.almAccountRepository.save((Object)almAccount);
        responseJson.put("id", almAccountId);
        responseJson.put("active", isActive);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/save/almaccount"})
    public ResponseEntity<Object> saveAlmAccount(@RequestBody AlmAccount almaccount) {
        HashMap<String, Object> responseJson;
        boolean flag;
        block32: {
            flag = false;
            responseJson = new HashMap<String, Object>();
            String loggedInCompanyId = UserContextUtil.getUserContext().getCurrentCompany().getId();
            this.serverCacheRepository.deleteByKey(loggedInCompanyId + "_OTK");
            if (!PropertyValidator.isValid((Object)almaccount.getId())) {
                flag = true;
                try {
                    if (PropertyValidator.isValid((Object)almaccount.getAzureOAuthToken())) {
                        almaccount.setPassword("");
                        break block32;
                    }
                    if (PropertyValidator.isValid((Object)almaccount.getJiraOauthToken())) {
                        almaccount.setPassword("");
                        break block32;
                    }
                    almaccount.setPassword(EncDecUtility.encrypt((String)almaccount.getPassword()));
                }
                catch (Exception e) {
                    LOGGER.error(StringUtils.getTraceString((Throwable)e));
                }
            } else if (PropertyValidator.isValid((Object)almaccount.getJiraOauthToken())) {
                AlmAccount editAlm;
                JiraOauthToken jiraOauthToken = almaccount.getJiraOauthToken();
                if (JiraOauthToken.ServerAuthType.AUTH_2_0.equals((Object)jiraOauthToken.getServerAuthType()) && !PropertyValidator.isValid((Object)almaccount.getSecretKey()) && !jiraOauthToken.isCloud()) {
                    editAlm = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almaccount.getId()));
                    almaccount.setSecretKey(editAlm.getSecretKey());
                    almaccount.setOAuthTokenOwnerUserId(UserContextUtil.getUserContext().getLoggedInUser().getId());
                    almaccount.setJiraOauthToken(editAlm.getJiraOauthToken());
                } else if (!(PropertyValidator.isValid((Object)jiraOauthToken.getPrivateKey()) || JiraOauthToken.ServerAuthType.AUTH_2_0.equals((Object)jiraOauthToken.getServerAuthType()) || jiraOauthToken.isCloud())) {
                    editAlm = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almaccount.getId()));
                    almaccount.setJiraOauthToken(editAlm.getJiraOauthToken());
                    almaccount.setAuthUrl(null);
                    almaccount.setClientId(null);
                } else if (!PropertyValidator.isValid((Object)almaccount.getSecretKey()) && jiraOauthToken.isCloud()) {
                    editAlm = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almaccount.getId()));
                    almaccount.setJiraOauthToken(editAlm.getJiraOauthToken());
                    almaccount.setSecretKey(editAlm.getSecretKey());
                }
            } else {
                try {
                    AlmAccount editAlm = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almaccount.getId()));
                    if (!PropertyValidator.isValid((Object)almaccount.getPassword()) && !PropertyValidator.isValid((Object)almaccount.getAzureOAuthToken())) {
                        almaccount.setPassword(editAlm.getPassword());
                        EncDecUtility.decrypt((String)almaccount.getPassword());
                    }
                    if (PropertyValidator.isValid((Object)almaccount.getAzureOAuthToken()) && !PropertyValidator.isValid((Object)almaccount.getSecretKey())) {
                        almaccount.setSecretKey(editAlm.getSecretKey());
                    }
                }
                catch (Exception e1) {
                    if (PropertyValidator.isValid((Object)almaccount.getPassword()) && !PropertyValidator.isValid((Object)almaccount.getAzureOAuthToken())) {
                        try {
                            almaccount.setPassword(EncDecUtility.encrypt((String)almaccount.getPassword()));
                        }
                        catch (Exception e) {
                            LOGGER.error(StringUtils.getTraceString((Throwable)e));
                        }
                    }
                    LOGGER.error(StringUtils.getTraceString((Throwable)e1));
                }
            }
        }
        if (!EncDecUtility.isKMSEncryption((String)almaccount.getPassword()) && !this.env.getProperty("isLocalDeployment").equals("true")) {
            try {
                almaccount.setPassword(EncDecUtility.encryptKMS((String)EncDecUtility.decrypt((String)almaccount.getPassword())));
            }
            catch (Exception e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
        }
        boolean isNewAccount = false;
        if (almaccount.getId() == null && !almaccount.getType().equals("tfs")) {
            isNewAccount = true;
            this.aLMSyncService.retrieveJiraIssueLinkTypesForAlmAccount(almaccount);
        }
        AlmAccount savedAccount = (AlmAccount)this.almAccountRepository.save((Object)almaccount);
        if (!almaccount.getType().equals("tfs")) {
            this.aLMSyncService.retrieveJiraFields(almaccount, null);
        }
        if (flag) {
            try {
                String webhook = this.webHookSyncService.createWebhook(almaccount.getWebhookURL(), savedAccount);
                savedAccount = (AlmAccount)this.almAccountRepository.save((Object)savedAccount);
                responseJson.put("webhook", PropertyValidator.isValid((Object)webhook) ? webhook : Boolean.valueOf(false));
            }
            catch (Exception e) {
                responseJson.put("webhook", false);
            }
            boolean updateUserProfileOnAlmCreate = false;
            if (PropertyValidator.isValid((Object)almaccount.getPassword()) && JiraOauthToken.isEmptyJiraAuth2Token((JiraOauthToken)almaccount.getJiraOauthToken()) && AzureOAuthToken.isEmptyToken((AzureOAuthToken)almaccount.getAzureOAuthToken())) {
                updateUserProfileOnAlmCreate = true;
            } else if (PropertyValidator.isValid((Object)almaccount.getJiraOauthToken()) && JiraOauthToken.ServerAuthType.AUTH_1_0.equals((Object)almaccount.getJiraOauthToken().getServerAuthType())) {
                updateUserProfileOnAlmCreate = true;
            }
            if (updateUserProfileOnAlmCreate) {
                this.aLMSyncService.updateUserProfileOnAlmCreate(almaccount);
            }
        }
        responseJson.put("almAccount", savedAccount.copyWithoutPwd());
        this.userService.setOnboardingMeta("Connect_To_Jira", true);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/almaccount/{id}/createwebhook"})
    @ResponseBody
    public ResponseEntity<Object> createWebHook(@PathVariable(value="id") String id, @RequestBody String requestBody, HttpServletRequest request) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        Gson gson = new Gson();
        7 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap paramMap = (HashMap)gson.fromJson(requestBody, T.getType());
        String originURL = (String)paramMap.get("originURL");
        AlmAccount almAcc = AlmUtils.getALMAcount((String)id, (AlmAccountRepository)this.almAccountRepository);
        try {
            String webhook = this.webHookSyncService.createWebhook(originURL, almAcc);
            responseJson.put("webhook", webhook);
        }
        catch (Exception e) {
            responseJson.put("error", true);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/almaccount/{id}"})
    @ResponseBody
    public ResponseEntity<Object> getAlmAccount(@PathVariable(value="id") String id, @RequestBody String requestBody, HttpServletRequest request) {
        HashMap<String, Object> responseJson;
        block13: {
            Gson gson = new Gson();
            8 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap paramMap = (HashMap)gson.fromJson(requestBody, T.getType());
            String originURL = (String)paramMap.get("originURL");
            AlmAccount almaccount = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)id));
            responseJson = new HashMap<String, Object>();
            responseJson.put("almaccount", almaccount);
            AlmAccount _alm = new AlmAccount();
            _alm.setId(id);
            List almConfigs = this.almConfigurationsRepository.findByAlmAccount(_alm);
            if (PropertyValidator.isValid((Collection)almConfigs)) {
                List sessions = this.sessionRepository.findSessionsByAlmConfigurationsIn(almConfigs);
                ArrayList<String> sessionsCount = new ArrayList<String>();
                if (PropertyValidator.isValid((Collection)sessions)) {
                    sessionsCount.add(new String());
                    responseJson.put("sessions", sessionsCount);
                }
            }
            if (EncDecUtility.isKMSEncryption((String)almaccount.getPassword())) {
                responseJson.put("isKms", true);
            } else {
                responseJson.put("isKms", false);
            }
            if (PropertyValidator.isValid((Object)almaccount) && PropertyValidator.isValid((Object)almaccount.getUrl()) && almaccount.getUrl().endsWith("atlassian.net")) {
                boolean isCloud;
                boolean bl = isCloud = PropertyValidator.isValid((Object)almaccount.getJiraOauthToken()) && almaccount.getJiraOauthToken().isCloud();
                if (isCloud && !PropertyValidator.isValid((Object)almaccount.getWebhookId())) {
                    responseJson.put("webhook", false);
                } else {
                    try {
                        WebhookResponseVO webhookObj = this.webHookSyncService.checkJiraWebhookExist(id, almaccount, originURL);
                        if (PropertyValidator.isValid((Object)webhookObj)) {
                            if (isCloud) {
                                responseJson.put("webhook", webhookObj.getWebhookCloudResponse());
                            } else {
                                responseJson.put("webhook", webhookObj);
                            }
                            break block13;
                        }
                        responseJson.put("webhook", false);
                    }
                    catch (ViztrendJiraException vJe) {
                        responseJson.put("webhook", false);
                    }
                }
            } else {
                responseJson.put("webhook", false);
            }
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/remove/almaccount"})
    public void removeAlmAccount(@RequestBody AlmAccount almaccount) {
        this.almAccountRepository.delete((Object)almaccount);
    }

    @RequestMapping(value={"/usersCount"})
    public int getUsersCount() {
        String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
        List users = this.userRepository.findByUserCompanies_Company_IdAndUserCompanies_isArchive(cid, Boolean.valueOf(false));
        return users.size();
    }

    @RequestMapping(value={"/all-users"})
    @ResponseBody
    public ResponseEntity<Object> getAllUsers(HttpServletRequest request) {
        HashMap<String, List> responseJson = new HashMap<String, List>();
        String loggedinCompanyId = UserContextUtil.getUserContext().getCurrentCompany().getId();
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        String tenant = String.valueOf(secureUser.getUserContextDTO().getContextMap().get("tenant"));
        Query query = new Query();
        query.with(new Sort(Sort.Direction.ASC, new String[]{"fullName"}));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"rowStatus").is((Object)0));
        Criteria userCompanyCriteria = new Criteria().andOperator(new Criteria[]{Criteria.where((String)"userCompanies").ne(null), Criteria.where((String)"userCompanies.company.id").is((Object)loggedinCompanyId)});
        Criteria tenantCriteria = Criteria.where((String)"tenant").is((Object)tenant);
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        Criteria criteria0 = new Criteria().orOperator(new Criteria[]{userCompanyCriteria, tenantCriteria});
        query.addCriteria((CriteriaDefinition)criteria0);
        query.fields().include("userName");
        query.fields().include("fullName");
        query.fields().include("firstName");
        query.fields().include("lastName");
        query.fields().include("email");
        query.fields().include("backgroundColor");
        query.fields().include("isAdmin");
        query.fields().include("isJiraPluginUser");
        query.fields().include("createdOn");
        query.fields().include("updatedBy");
        query.fields().include("updatedOn");
        query.fields().include("rowStatus");
        query.fields().include("archive");
        query.fields().include("picturePath");
        query.fields().include("userType");
        List users = this.mongoTemplate.find(query, User.class);
        responseJson.put("users", users);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/all-users-wsjf"})
    @ResponseBody
    public ResponseEntity<Object> getAllUsersForWsjfCriteria(HttpServletRequest request) {
        HashMap<String, List> responseJson = new HashMap<String, List>();
        String loggedinCompanyId = UserContextUtil.getUserContext().getCurrentCompany().getId();
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        String tenant = String.valueOf(secureUser.getUserContextDTO().getContextMap().get("tenant"));
        Query query = new Query();
        query.with(new Sort(Sort.Direction.ASC, new String[]{"fullName"}));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"rowStatus").is((Object)0));
        Criteria userCompanyCriteria = new Criteria().andOperator(new Criteria[]{Criteria.where((String)"userCompanies").ne(null), Criteria.where((String)"userCompanies.company.id").is((Object)loggedinCompanyId)});
        Criteria tenantCriteria = Criteria.where((String)"tenant").is((Object)tenant);
        Criteria criteria0 = new Criteria().orOperator(new Criteria[]{userCompanyCriteria, tenantCriteria});
        query.addCriteria((CriteriaDefinition)criteria0);
        query.fields().include("fullName");
        List users = this.mongoTemplate.find(query, User.class);
        responseJson.put("users", users);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/availableUsersCount"})
    public long getAvailableUsersCount() {
        String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
        Company company = this.companyRepository.findById(cid);
        if (company.getUserCount() <= 0L) {
            return -1L;
        }
        List users = this.userRepository.findByUserCompanies_Company_Id(company.getId());
        ArrayList<User> activeUsers = new ArrayList<User>();
        if (PropertyValidator.isValid((Collection)users)) {
            for (User u : users) {
                for (UserCompany c : u.getUserCompanies()) {
                    if (!c.getCompany().getId().equals(cid) || !c.getIsActive().booleanValue() || c.getIsGuest().booleanValue()) continue;
                    activeUsers.add(u);
                }
            }
        }
        long invitaionCount = this.invitationRepository.findAll().size();
        long available = company.getUserCount() - ((long)activeUsers.size() + invitaionCount);
        if (available < 0L) {
            available = 0L;
        }
        return available;
    }

    @RequestMapping(value={"/availableGuestCount"})
    public long getAvailableGuestCount() {
        long available;
        String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
        Company company = this.companyRepository.findById(cid);
        if (company.getGuestUserCount() <= 0L) {
            return -1L;
        }
        List users = this.userRepository.findByUserCompanies_Company_Id(company.getId());
        ArrayList<User> activeUsers = new ArrayList<User>();
        if (PropertyValidator.isValid((Collection)users)) {
            for (User u : users) {
                for (UserCompany c : u.getUserCompanies()) {
                    if (!c.getCompany().getId().equals(cid) || !c.getIsActive().booleanValue() || !c.getIsGuest().booleanValue()) continue;
                    activeUsers.add(u);
                }
            }
        }
        if ((available = company.getGuestUserCount() - (long)activeUsers.size()) < 0L) {
            available = 0L;
        }
        return available;
    }

    @RequestMapping(value={"/existingUsersCount"})
    public long getExistingUsersCount() {
        String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
        Company company = this.companyRepository.findById(cid);
        long usersCount = 0L;
        List users = this.userRepository.findByUserCompanies_Company_Id(company.getId());
        if (PropertyValidator.isValid((Collection)users)) {
            for (User user : users) {
                UserCompany userCompany = null;
                for (UserCompany uc : user.getUserCompanies()) {
                    if (!uc.getCompany().getId().equals(cid)) continue;
                    userCompany = uc;
                    break;
                }
                if (!PropertyValidator.isValid(userCompany) || !userCompany.getIsActive().booleanValue() || userCompany.getIsGuest().booleanValue()) continue;
                ++usersCount;
            }
        }
        long invitaionCount = this.invitationRepository.findAll().size();
        return usersCount + invitaionCount;
    }

    @RequestMapping(value={"/users"})
    public Object[] getUsers() {
        Object[] objects = new Object[7];
        String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
        if (PropertyValidator.isValid((Object)cid)) {
            List users = this.userRepository.findByUserCompanies_Company_IdAndUserCompanies_isArchive(cid, Boolean.valueOf(false));
            List accessRoles = this.workSpaceAccessRoleRepository.findByUserIn(users);
            List groups = this.getGroupsToLink();
            ArrayList<User> anomilatedGroupUsers = new ArrayList<User>();
            for (int i = 0; i < users.size(); ++i) {
                User user = (User)users.get(i);
                for (int j = 0; j < user.getUserCompanies().size(); ++j) {
                    if (!((UserCompany)user.getUserCompanies().get(j)).getCompany().getId().equals(cid)) continue;
                    user.setIsSuperAdmin(((UserCompany)user.getUserCompanies().get(j)).getIsAdmin());
                    user.setIsAdmin(((UserCompany)user.getUserCompanies().get(j)).getIsAdmin());
                    user.setIsActive(((UserCompany)user.getUserCompanies().get(j)).getIsActive());
                    user.setIsGuest(((UserCompany)user.getUserCompanies().get(j)).getIsGuest());
                }
                boolean isAnomilatedGroupUser = false;
                for (Group group : groups) {
                    if (group.getUsers() == null || !group.getUsers().contains(user.getId()) || user.getGroups().contains(group.getId())) continue;
                    HashSet<String> newGroups = new HashSet<String>();
                    newGroups.addAll(user.getGroups());
                    newGroups.add(group.getId());
                    user.setGroups(newGroups);
                    isAnomilatedGroupUser = true;
                }
                if (isAnomilatedGroupUser) {
                    anomilatedGroupUsers.add(user);
                }
                for (WorkSpaceAccessRole accessRole : accessRoles) {
                    User wuser = user;
                    if (!PropertyValidator.isValid((Collection)wuser.getAccessRoles())) {
                        wuser.setAccessRoles(new ArrayList());
                    }
                    if ((!PropertyValidator.isValid((Object)accessRole.getUser()) || !wuser.getId().equals(accessRole.getUser().getId())) && (!PropertyValidator.isValid((Object)accessRole.getGroup()) || !wuser.getGroups().contains(accessRole.getGroup().getId()))) continue;
                    wuser.getAccessRoles().add(accessRole);
                }
            }
            if (PropertyValidator.isValid(anomilatedGroupUsers)) {
                this.userRepository.save(anomilatedGroupUsers);
            }
            List workSpaces = this.workSpaceRepository.findByIsModuleIsFalseOrIsModuleIsNull();
            List roles = this.roleRepository.findAll();
            List customViews = this.objectiveCustomViewRepository.findByReleaseTrainIdIsNullAndRowStatus(0);
            List solutionAreas = this.solutionAreaRepository.findByRowStatus(Integer.valueOf(0));
            objects[0] = users;
            objects[1] = groups;
            objects[2] = workSpaces;
            objects[3] = roles;
            objects[5] = customViews;
            objects[6] = solutionAreas;
        }
        long invitaionCount = this.invitationRepository.findAll().size();
        objects[4] = invitaionCount;
        return objects;
    }

    @RequestMapping(value={"/invite/getPending"})
    @ResponseBody
    public ResponseEntity<Object> getPendingInvites() {
        List invitations = this.invitationRepository.findAll();
        return new ResponseEntity((Object)invitations, HttpStatus.OK);
    }

    @RequestMapping(value={"/invite/delete/{id}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<Object> deleteInvite(@PathVariable(value="id") String id) {
        this.invitationRepository.deleteById(id);
        return new ResponseEntity((Object)id, HttpStatus.OK);
    }

    @RequestMapping(value={"/invite/resend/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> resendInvite(@PathVariable(value="id") String id) {
        Invitation invitation = this.invitationRepository.findById(id);
        Gson g = new Gson();
        9 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap reqbody = (HashMap)g.fromJson(invitation.getInviteJson(), T.getType());
        String userEmail = (String)reqbody.get("email");
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        User _user = (User)secureUser.getUserContextDTO().getContextMap().get("user");
        String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
        Company comp = (Company)this.companyRepository.findOne((Serializable)((Object)cid));
        String baseUrl = this.getHttpScheme() + "://" + comp.getUrlPrefix() + "." + this.env.getProperty("server.domain");
        if (this.env.getProperty("isLocalDeployment").equals("true")) {
            baseUrl = UserContextUtil.getUserContext().getCurrentCompany().getUrl();
        }
        String url = baseUrl + "/welcome?token=" + invitation.getId();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("invitedByEmail", _user.getEmail());
        data.put("invitedByUrl", url);
        this.sendMail(data, "You are invited to join Kendis", "userInviteTemplate", userEmail);
        return new ResponseEntity((Object)id, HttpStatus.OK);
    }

    @RequestMapping(value={"/invite/user"})
    @ResponseBody
    public ResponseEntity<Object> inviteUser(@RequestBody String requestStr) {
        HashMap<String, String> responseJson = new HashMap<String, String>();
        JSONArray jsonResponseArray = new JSONArray();
        Gson g = new Gson();
        10 T = new /* Unavailable Anonymous Inner Class!! */;
        try {
            long _availableUsers;
            HashMap reqbody = (HashMap)g.fromJson(requestStr, T.getType());
            String userStr = (String)reqbody.get("user");
            String notifyUserStr = (String)reqbody.get("notifyUser");
            String groups = (String)reqbody.get("groups");
            String commaSeparatedEmails = (String)reqbody.get("email");
            String[] emailList = null;
            if (PropertyValidator.isValid((Object)commaSeparatedEmails)) {
                emailList = commaSeparatedEmails.split(",");
            }
            if ((_availableUsers = this.getAvailableUsersCount()) == 0L || (long)emailList.length > _availableUsers) {
                JSONObject invitationStatus = new JSONObject();
                invitationStatus.put("status", 0);
                invitationStatus.put("message", (Object)"User limit exceeded");
                invitationStatus.put("email", (Object)commaSeparatedEmails);
                jsonResponseArray.put((Object)invitationStatus);
                responseJson.put("invitationStatus", jsonResponseArray.toString());
                return new ResponseEntity(responseJson, HttpStatus.OK);
            }
            if (PropertyValidator.isValid((Object)commaSeparatedEmails)) {
                for (int index = 0; index < emailList.length; ++index) {
                    String email = emailList[index];
                    JSONObject invitationStatus = new JSONObject();
                    User user = new User();
                    user.setEmail(email);
                    if (!user.hasValidEmail().booleanValue()) {
                        invitationStatus.put("status", -1);
                        invitationStatus.put("message", (Object)"Invalid email address");
                        invitationStatus.put("email", (Object)email);
                        jsonResponseArray.put((Object)invitationStatus);
                        continue;
                    }
                    String domain = user.getEmail().substring(user.getEmail().indexOf("@") + 1);
                    if (PropertyValidator.isValid((Collection)this.blackListUserDomainRepository.findByDomainIgnoreCase(domain))) {
                        invitationStatus.put("status", -2);
                        invitationStatus.put("message", (Object)"Your email domain is blacklisted");
                        invitationStatus.put("email", (Object)email);
                        jsonResponseArray.put((Object)invitationStatus);
                        continue;
                    }
                    11 T2 = new /* Unavailable Anonymous Inner Class!! */;
                    Set grouplist = (Set)g.fromJson(groups, T2.getType());
                    user.setGroups(grouplist);
                    SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
                    User _user = (User)secureUser.getUserContextDTO().getContextMap().get("user");
                    ArrayList<String> emails = new ArrayList<String>();
                    emails.add(user.getEmail());
                    List alreadyEmail = this.userRepository.findByEmailIn(emails);
                    String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
                    Boolean alreadyInCompany = false;
                    if (PropertyValidator.isValid((Collection)alreadyEmail)) {
                        block3: for (User existingUser : alreadyEmail) {
                            List userCompanies = existingUser.getUserCompanies();
                            if (!PropertyValidator.isValid((Collection)userCompanies)) continue;
                            for (int i = 0; i < userCompanies.size(); ++i) {
                                if (!((UserCompany)userCompanies.get(i)).getCompany().getId().equals(cid)) continue;
                                if (((UserCompany)userCompanies.get(i)).getIsArchive().booleanValue()) {
                                    userCompanies.remove(i);
                                    existingUser.setUserCompanies(userCompanies);
                                    this.userRepository.save((Object)existingUser);
                                    invitationStatus.put("status", -3);
                                    invitationStatus.put("message", (Object)"Removed user invited again");
                                    invitationStatus.put("email", (Object)email);
                                    jsonResponseArray.put((Object)invitationStatus);
                                    continue block3;
                                }
                                alreadyInCompany = true;
                                invitationStatus.put("status", -4);
                                invitationStatus.put("message", (Object)"User with this email already exists");
                                invitationStatus.put("email", (Object)email);
                                jsonResponseArray.put((Object)invitationStatus);
                            }
                        }
                    }
                    if (alreadyInCompany.booleanValue()) continue;
                    Invitation alreadyInvited = this.invitationRepository.findOneByInviteJsonContains(email);
                    if (alreadyInvited != null) {
                        invitationStatus.put("status", -5);
                        invitationStatus.put("message", (Object)"User with this email already invited");
                        invitationStatus.put("email", (Object)email);
                        jsonResponseArray.put((Object)invitationStatus);
                    }
                    invitationStatus.put("status", 1);
                    invitationStatus.put("message", (Object)"Invitation sent successfully");
                    invitationStatus.put("email", (Object)email);
                    jsonResponseArray.put((Object)invitationStatus);
                    Company comp = (Company)this.companyRepository.findOne((Serializable)((Object)cid));
                    String usrEmail = _user.getEmail();
                    Date currDate = new Date();
                    HashMap<String, Object> inviteObj = new HashMap<String, Object>();
                    inviteObj.put("companyId", cid);
                    inviteObj.put("email", user.getEmail());
                    inviteObj.put("groups", user.getGroups());
                    inviteObj.put("accessRoles", reqbody.get("accessRoles"));
                    inviteObj.put("notifyUser", Boolean.parseBoolean(notifyUserStr));
                    inviteObj.put("invitationTime", currDate.getTime());
                    if (PropertyValidator.isValid((Collection)alreadyEmail)) {
                        inviteObj.put("userName", ((User)alreadyEmail.get(0)).getUserName());
                        inviteObj.put("fullName", ((User)alreadyEmail.get(0)).getFullName());
                    }
                    if (PropertyValidator.isValid((Object)comp)) {
                        Invitation invitation = new Invitation();
                        invitation.setInviteJson(g.toJson(inviteObj));
                        invitation = (Invitation)this.invitationRepository.save((Object)invitation);
                        String baseUrl = this.getHttpScheme() + "://" + comp.getUrlPrefix() + "." + this.env.getProperty("server.domain");
                        if (this.env.getProperty("isLocalDeployment").equals("true")) {
                            baseUrl = UserContextUtil.getUserContext().getCurrentCompany().getUrl();
                        }
                        String url = baseUrl + "/welcome?token=" + invitation.getId();
                        HashMap<String, String> data = new HashMap<String, String>();
                        data.put("invitedByEmail", usrEmail);
                        data.put("invitedByUrl", url);
                        this.sendMail(data, "You are invited to join Kendis", "userInviteTemplate", user.getEmail());
                        continue;
                    }
                    invitationStatus.put("status", -6);
                    invitationStatus.put("message", (Object)"Company not found!");
                    invitationStatus.put("email", (Object)email);
                    jsonResponseArray.put((Object)invitationStatus);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("FAILED(inviteUser): " + StringUtils.getTraceString((Throwable)e));
        }
        responseJson.put("invitationStatus", jsonResponseArray.toString());
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/save/user"})
    @ResponseBody
    public ResponseEntity<Object> saveUser(@RequestBody User user) {
        boolean isPasswordsame = false;
        boolean isPasswordLarge = false;
        if (!user.hasValidEmail().booleanValue() && !user.isLdap()) {
            HashMap<String, Object> responseJson = new HashMap<String, Object>();
            responseJson.put("msg", "Please provide a valid email address");
            responseJson.put("email", user.getEmail());
            responseJson.put("code", -200);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        String domain = user.getEmail().substring(user.getEmail().indexOf("@") + 1);
        if (PropertyValidator.isValid((Collection)this.blackListUserDomainRepository.findByDomainIgnoreCase(domain))) {
            HashMap<String, String> responseJson = new HashMap<String, String>();
            responseJson.put("msg", "Your email domain is blacklisted");
            return new ResponseEntity(responseJson, HttpStatus.METHOD_NOT_ALLOWED);
        }
        if (user.getIsGuestUserConversion()) {
            long _availableUsers;
            String userType = "User";
            if (user.getIsGuest().booleanValue()) {
                _availableUsers = this.getAvailableGuestCount();
                userType = "Guest User";
            } else {
                _availableUsers = this.getAvailableUsersCount();
            }
            if (_availableUsers == 0L) {
                HashMap<String, String> responseJson = new HashMap<String, String>();
                responseJson.put("msg", userType + " limit exceeded");
                return new ResponseEntity(responseJson, HttpStatus.OK);
            }
        }
        User userr = null;
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        User _user = (User)secureUser.getUserContextDTO().getContextMap().get("user");
        if (PropertyValidator.isValid((Object)user.getId())) {
            Sets.SetView newGroupIds;
            List savedNewGroups;
            Sets.SetView deletedGroupIds;
            List savedDeletedGroups;
            User savedUser = (User)this.userRepository.findOne((Serializable)((Object)user.getId()));
            HashSet savedGroups = savedUser.getGroups();
            HashSet inComingGroups = user.getGroups();
            if (!PropertyValidator.isValid((Collection)savedGroups)) {
                savedGroups = new HashSet();
            }
            if (!PropertyValidator.isValid((Collection)inComingGroups)) {
                inComingGroups = new HashSet();
            }
            if (PropertyValidator.isValid((Collection)(savedDeletedGroups = this.groupRepository.findByIdIn((Set)(deletedGroupIds = Sets.difference(savedGroups, (Set)inComingGroups)))))) {
                for (Group group : savedDeletedGroups) {
                    group.getUsers().remove(user.getId());
                }
                this.groupRepository.save((Iterable)savedDeletedGroups);
            }
            if (PropertyValidator.isValid((Collection)(savedNewGroups = this.groupRepository.findByIdIn((Set)(newGroupIds = Sets.difference(inComingGroups, savedGroups)))))) {
                for (Group group : savedNewGroups) {
                    if (!PropertyValidator.isValid((Collection)group.getUsers())) {
                        group.setUsers(new HashSet());
                    }
                    group.getUsers().add(user.getId());
                }
                this.groupRepository.save((Iterable)savedNewGroups);
            }
            if (PropertyValidator.isValid((Collection)savedUser.getUserCompanies())) {
                user.setUserCompanies(savedUser.getUserCompanies());
                String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
                if (PropertyValidator.isValid((Collection)user.getUserCompanies())) {
                    for (int i = 0; i < user.getUserCompanies().size(); ++i) {
                        if (!cid.equals(((UserCompany)user.getUserCompanies().get(i)).getCompany().getId())) continue;
                        ((UserCompany)user.getUserCompanies().get(i)).setIsGuest(user.getIsGuest());
                        ((UserCompany)user.getUserCompanies().get(i)).setIsAdmin(user.getIsSuperAdmin());
                        break;
                    }
                }
            }
            if (!PropertyValidator.isValid((Object)user.getPassword())) {
                user.setPassword(savedUser.getPassword());
            } else {
                if (PropertyValidator.isValid((Object)user.getPassword()) && user.getPassword().length() < 46 && !user.getPassword().equalsIgnoreCase(savedUser.getEmail())) {
                    user.setPassword(EncDecUtility.bCryptPasswordEncoder((String)user.getPassword()));
                } else if (PropertyValidator.isValid((Object)user.getPassword()) && user.getPassword().length() > 46) {
                    isPasswordLarge = true;
                } else if (PropertyValidator.isValid((Object)user.getPassword()) && user.getPassword().equalsIgnoreCase(savedUser.getEmail())) {
                    isPasswordsame = true;
                }
                if (isPasswordLarge || isPasswordsame) {
                    HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
                    responseJson.put("isPasswordsame", isPasswordsame);
                    responseJson.put("isPasswordLarge", isPasswordLarge);
                    return new ResponseEntity(responseJson, HttpStatus.OK);
                }
            }
            if (!PropertyValidator.isValid((Object)user.getFullName())) {
                user.setFullName(user.getEmail());
            } else {
                user.setFullName(user.getFullName());
            }
            user.setUserName(user.getEmail());
            HashMap<String, Object> vars = new HashMap<String, Object>();
            savedUser.setFirstName(user.getFirstName());
            savedUser.setLastName(user.getLastName());
            savedUser.setFullName(user.getFullName());
            savedUser.setEmail(user.getEmail());
            savedUser.setPassword(user.getPassword());
            savedUser.setIsSuperAdmin(user.getIsSuperAdmin());
            savedUser.setIsGuest(user.getIsGuest());
            vars.put("createdDate", new Date());
            vars.put("email", savedUser.getEmail());
            savedUser.setforcedMFA(user.getforcedMFA());
            if (savedUser.isLocked() && !user.isLocked()) {
                savedUser.setTressPassCount(0);
            }
            savedUser.setLocked(user.isLocked());
            savedUser.setGroups(user.getGroups());
            savedUser.setAccessRoles(user.getAccessRoles());
            userr = (User)this.userRepository.save((Object)savedUser);
            List existingAccessRoles = this.workSpaceAccessRoleRepository.findByUser(user);
            HashSet<WorkSpaceAccessRole> updatedAccessRoles = new HashSet<WorkSpaceAccessRole>(existingAccessRoles);
            WorkSpace objectiveWorkspace = this.workSpaceRepository.findByIsModuleIsTrueAndModuleType("Objectives");
            if (!user.getIsGuest().booleanValue() && !user.getIsGuestUserConversion()) {
                this.workSpaceAccessRoleRepository.deleteByUser(user);
                if (PropertyValidator.isValid((Collection)user.getAccessRoles())) {
                    for (WorkSpaceAccessRole accessRole : user.getAccessRoles()) {
                        accessRole.setUser(new User(userr.getId()));
                        if (!PropertyValidator.isValid((Object)accessRole.getCustomView()) || PropertyValidator.isValid((Object)accessRole.getWorkSpace())) continue;
                        accessRole.setWorkSpace(objectiveWorkspace);
                    }
                    this.workSpaceAccessRoleRepository.save((Iterable)user.getAccessRoles());
                }
            } else {
                List newAccessRoles = user.getAccessRoles();
                LinkedList removedAccessRoles = new LinkedList();
                if (PropertyValidator.isValid((Collection)newAccessRoles)) {
                    for (WorkSpaceAccessRole newRole : newAccessRoles) {
                        if (existingAccessRoles.contains(newRole)) continue;
                        newRole.setUser(new User(user.getId()));
                        if (PropertyValidator.isValid((Object)newRole.getCustomView()) && !PropertyValidator.isValid((Object)newRole.getWorkSpace())) {
                            newRole.setWorkSpace(objectiveWorkspace);
                        }
                        updatedAccessRoles.add(newRole);
                    }
                    existingAccessRoles.forEach(role -> {
                        if (!newAccessRoles.contains(role)) {
                            updatedAccessRoles.remove(role);
                            removedAccessRoles.add(role);
                        }
                    });
                    if (PropertyValidator.isValid(removedAccessRoles)) {
                        this.workSpaceAccessRoleRepository.delete(removedAccessRoles);
                    }
                    this.workSpaceAccessRoleRepository.save(updatedAccessRoles);
                }
            }
            if (_user.getId().equals(userr.getId())) {
                secureUser.getUserContextDTO().getContextMap().put("user", userr);
            }
        } else {
            Sets.SetView newGroupIds;
            List savedNewGroups;
            List<UserCompany> userCompanies;
            String companyPrefix = "app";
            ArrayList<String> emails = new ArrayList<String>();
            emails.add(user.getEmail());
            ArrayList<String> unames = new ArrayList<String>();
            unames.add(user.getUserName());
            String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
            Boolean alreadyInCompany = false;
            ArrayList<User> duplicateEmail = null;
            for (String email : emails) {
                User duplicateUser = this.userRepository.findByUserNameIgnoreCase(email);
                if (!PropertyValidator.isValid((Object)duplicateUser)) continue;
                duplicateEmail = new ArrayList<User>();
                duplicateEmail.add(duplicateUser);
                break;
            }
            alreadyInCompany = false;
            boolean addExistingUser = false;
            if (PropertyValidator.isValid(duplicateEmail)) {
                user = (User)duplicateEmail.get(0);
                userCompanies = ((User)duplicateEmail.get(0)).getUserCompanies();
                for (int i = 0; i < userCompanies.size(); ++i) {
                    if (!((UserCompany)userCompanies.get(i)).getCompany().getId().equals(cid)) continue;
                    alreadyInCompany = true;
                    if (((UserCompany)userCompanies.get(i)).getIsArchive().booleanValue()) {
                        ((UserCompany)userCompanies.get(i)).setIsArchive(Boolean.valueOf(false));
                        user.setUserCompanies(userCompanies);
                        break;
                    }
                    ((User)duplicateEmail.get(0)).setId("duplicateEmail");
                    return new ResponseEntity(duplicateEmail.get(0), HttpStatus.OK);
                }
            }
            user.setUserName(user.getEmail());
            userCompanies = new ArrayList();
            if (!alreadyInCompany.booleanValue()) {
                if (PropertyValidator.isValid(duplicateEmail)) {
                    userCompanies = ((User)duplicateEmail.get(0)).getUserCompanies();
                    addExistingUser = true;
                }
                UserCompany userCompany = new UserCompany();
                Company comp = this.companyRepository.findById(cid);
                companyPrefix = comp.getUrlPrefix();
                userCompany.setCompany(comp);
                userCompany.setIsActive(Boolean.valueOf(true));
                userCompany.setIsOwner(Boolean.valueOf(false));
                userCompany.setIsAdmin(Boolean.valueOf(false));
                userCompany.setIsArchive(Boolean.valueOf(false));
                userCompany.setIsGuest(user.getIsGuest());
                userCompanies.add(userCompany);
                user.setUserCompanies(userCompanies);
                user.setIsActive(Boolean.valueOf(true));
            }
            if (!PropertyValidator.isValid((Object)user.getFullName())) {
                user.setFullName(user.getEmail());
            }
            if (!PropertyValidator.isValid((Object)user.getUserName())) {
                user.setUserName(user.getEmail());
            }
            if (!PropertyValidator.isValid((Object)user.getPassword())) {
                user.setPassword(EncDecUtility.bCryptPasswordEncoder((String)UUID.randomUUID().toString()));
            } else if (!addExistingUser) {
                user.setPassword(EncDecUtility.bCryptPasswordEncoder((String)user.getPassword()));
            }
            userr = (User)this.userRepository.save((Object)user);
            if (PropertyValidator.isValid((Collection)user.getAccessRoles())) {
                for (WorkSpaceAccessRole accessRole : user.getAccessRoles()) {
                    accessRole.setUser(new User(userr.getId()));
                }
                this.workSpaceAccessRoleRepository.save((Iterable)user.getAccessRoles());
            }
            HashSet savedGroups = null;
            HashSet inComingGroups = user.getGroups();
            if (!PropertyValidator.isValid(savedGroups)) {
                savedGroups = new HashSet();
            }
            if (!PropertyValidator.isValid((Collection)inComingGroups)) {
                inComingGroups = new HashSet();
            }
            if (PropertyValidator.isValid((Collection)(savedNewGroups = this.groupRepository.findByIdIn((Set)(newGroupIds = Sets.difference((Set)inComingGroups, savedGroups)))))) {
                for (Group group : savedNewGroups) {
                    if (!PropertyValidator.isValid((Collection)group.getUsers())) {
                        group.setUsers(new HashSet());
                    }
                    group.getUsers().add(user.getId());
                }
                this.groupRepository.save((Iterable)savedNewGroups);
            }
            String usrEmail = _user.getEmail();
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("invitedByEmail", usrEmail);
            String baseUrl = this.getHttpScheme() + "://" + companyPrefix + "." + this.env.getProperty("server.domain");
            if (this.env.getProperty("isLocalDeployment").equals("true")) {
                baseUrl = UserContextUtil.getUserContext().getCurrentCompany().getUrl();
            }
            data.put("invitedByUrl", baseUrl + "/login");
            data.put("param1", user.getUserName());
            if (addExistingUser) {
                data.put("param2", "");
                data.put("param3", "\"please use your existing password.\"");
            } else {
                try {
                    data.put("param2", UserContextUtil.getUserContext().getCurrentCompany().getUrl() + "/forgotpassword?t=" + EncDecUtility.encryptSimple((String)user.getEmail()));
                    data.put("param3", "\"Create password.\"");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.sendMail(data, "You have been added to Kendis", "userImportTemplate", user.getUserName());
        }
        if (PropertyValidator.isValid((Object)userr)) {
            userr.setGuestUserConversion(user.getIsGuestUserConversion());
        }
        return new ResponseEntity((Object)userr, HttpStatus.OK);
    }

    @RequestMapping(value={"/{archive}workflows"})
    @ResponseBody
    public ResponseEntity<Object> getWorkFlows(@PathVariable(value="archive") String archive) {
        List workFlows = new ArrayList();
        workFlows = "archived-".equals(archive) ? this.workFlowRepository.findAllByTfsProjectIdIsNullAndArchiveTrue() : this.workFlowRepository.findAllByTfsProjectIdIsNull();
        HashMap<String, List> response = new HashMap<String, List>();
        response.put("workFlows", workFlows);
        response.put("deaultSeverities", KendisUtils.getDeaultSeverities());
        return new ResponseEntity(response, HttpStatus.OK);
    }

    @RequestMapping(value={"/workflow/default/{wid}"})
    public List<WorkFlow> markDefaultWorkFlow(@PathVariable(value="wid") String wid) {
        this.customRepository.markDefaultWorkFlow(wid);
        return this.workFlowRepository.findAllByTfsProjectIdIsNull();
    }

    @RequestMapping(value={"/save/workflow"})
    public WorkFlow saveWorkFlow(@RequestBody WorkFlow workFlow) {
        if (workFlow.getId() != null) {
            WorkFlow wf = (WorkFlow)this.workFlowRepository.findOne((Serializable)((Object)workFlow.getId()));
            workFlow.setDefault(wf.isDefault());
        }
        WorkFlow workFlow2 = (WorkFlow)this.workFlowRepository.save((Object)workFlow);
        if (PropertyValidator.isValid((Collection)workFlow.getStatuses())) {
            List statuses = workFlow.getStatuses();
            for (Status status : statuses) {
                status.setWorkFlow(new WorkFlow(workFlow2.getId()));
                if (!Boolean.TRUE.equals(status.getIsDeleted())) continue;
                status.setArchive(true);
            }
            statuses = this.statusRepository.save((Iterable)statuses);
            workFlow2.setStatuses(statuses);
        }
        if (PropertyValidator.isValid((Collection)workFlow.getSeverities())) {
            List severities = workFlow.getSeverities();
            for (Severity svr : severities) {
                svr.setWorkFlow(new WorkFlow(workFlow2.getId()));
            }
            severities = this.severityRepository.save((Iterable)severities);
            workFlow2.setSeverities(severities);
        }
        return workFlow2;
    }

    @RequestMapping(value={"/workflow/{id}"})
    public WorkFlow getWorkFlow(@PathVariable(value="id") String wid) {
        WorkFlow workFlow = (WorkFlow)this.workFlowRepository.findOne((Serializable)((Object)wid));
        if (WorkFlow.WorkFlowType.Severity.name().equals(workFlow.getWorkflowType())) {
            workFlow.setSeverities(this.severityRepository.findByWorkFlow(workFlow));
        } else {
            workFlow.setStatuses(this.statusRepository.findByWorkFlow(workFlow));
        }
        this.isWorkFlowLinked(workFlow);
        return workFlow;
    }

    private String isWorkFlowLinked(WorkFlow wf) {
        String error = null;
        Long riskCount = null;
        List sessions1 = null;
        List sessions2 = null;
        List sessions3 = null;
        ScrumOfScrums sos = null;
        String type = wf.getWorkflowType().toLowerCase();
        if (WorkFlow.WorkFlowType.Dependency.name().toLowerCase().equals(type)) {
            sessions3 = this.sessionRepository.findByDependencyWorkFlow(wf);
        } else if (WorkFlow.WorkFlowType.Risk.name().toLowerCase().equals(type)) {
            riskCount = this.riskRegisterRepository.countByWorkflowId(wf.getId());
        } else if (WorkFlow.WorkFlowType.Impediment.name().toLowerCase().equals(type)) {
            sos = this.scrumOfScrumsRepository.findOneByImpedimentWorkFlowId(wf.getId());
        } else if (WorkFlow.WorkFlowType.ActionPoint.name().toLowerCase().equals(type)) {
            sos = this.scrumOfScrumsRepository.findOneByActionPointWorkFlowId(wf.getId());
        } else if (WorkFlow.WorkFlowType.Severity.name().toLowerCase().equals(type)) {
            sos = this.scrumOfScrumsRepository.findOneBySeverityWorkFlowId(wf.getId());
        } else if (WorkFlow.WorkFlowType.Objective.name().toLowerCase().equals(type) || WorkFlow.WorkFlowType.KR.name().toLowerCase().equals(type) || WorkFlow.WorkFlowType.Milestone.name().toLowerCase().equals(type) || WorkFlow.WorkFlowType.Phases.name().toLowerCase().equals(type) || WorkFlow.WorkFlowType.StrategicThemes.name().toLowerCase().equals(type)) {
            error = "This workflow cannot be archived";
        } else {
            sessions1 = this.sessionRepository.findByItemWorkFlow(wf);
            sessions2 = this.sessionRepository.findBySubItemWorkFlow(wf);
        }
        if (PropertyValidator.isValid(sessions1) || PropertyValidator.isValid(sessions2)) {
            error = "This general workflow is linked with one or more program boards. In order to delete this workflow you must delete those program boards, this workflow is associated with";
        } else if (PropertyValidator.isValid((Collection)sessions3)) {
            error = "This dependency workflow is linked with one or more program board(s)";
        } else if (PropertyValidator.isValid((Object)riskCount) && riskCount > 0L) {
            error = "This risk workflow is linked with one or more risk register(s)";
        } else if (PropertyValidator.isValid((Object)sos)) {
            error = "This workflow is linked with one or more sos";
        }
        if (PropertyValidator.isValid((Object)error)) {
            wf.setLinked(true);
        }
        return error;
    }

    @RequestMapping(value={"/user/{id}"})
    public User getUser(@PathVariable(value="id") String uid) {
        User user = (User)this.userRepository.findOne((Serializable)((Object)uid));
        user.setPassword(null);
        String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
        for (int j = 0; j < user.getUserCompanies().size(); ++j) {
            if (!((UserCompany)user.getUserCompanies().get(j)).getCompany().getId().equals(cid)) continue;
            user.setIsSuperAdmin(((UserCompany)user.getUserCompanies().get(j)).getIsAdmin());
            user.setIsGuest(((UserCompany)user.getUserCompanies().get(j)).getIsGuest());
        }
        List accessRoles = this.workSpaceAccessRoleRepository.findByUser(user);
        user.setAccessRoles(accessRoles);
        return user;
    }

    @RequestMapping(value={"/delete/{type}/{id}"})
    public ResponseEntity<Object> delete(@PathVariable(value="type") String type, @PathVariable(value="id") String id) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        String tenant = String.valueOf(secureUser.getUserContextDTO().getContextMap().get("tenant"));
        String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
        if (type.equals("user") || type.equals("guest")) {
            if (this.customRepository.findUnarchviedUsersByCompany(cid).size() > 1) {
                User delUser = this.userRepository.findById(id);
                List userCompanies = delUser.getUserCompanies();
                if (PropertyValidator.isValid((Collection)userCompanies)) {
                    for (int i = 0; i < userCompanies.size(); ++i) {
                        if (!((UserCompany)userCompanies.get(i)).getCompany().getId().equals(cid)) continue;
                        userCompanies.remove(i);
                        break;
                    }
                    delUser.setUserCompanies(userCompanies);
                    if (userCompanies.size() == 0 || this.env.getProperty("isLocalDeployment").equals("true")) {
                        delUser.setEmail(delUser.getEmail() + "-" + delUser.getId());
                        delUser.setUserCompanies(null);
                        delUser.setUserName(delUser.getUserName() + "-" + delUser.getId());
                        delUser.setArchive(true);
                    }
                }
                this.userRepository.save((Object)delUser);
                this.workSpaceAccessRoleRepository.deleteByUser(delUser);
                this.customRepository.removeUserFromGroups(id);
                data.put("isDeleted", Boolean.TRUE);
                data.put("message", "User deleted");
            } else {
                data.put("isDeleted", Boolean.FALSE);
                data.put("message", "There should be atleast one user.");
            }
        } else if (type.equals("userActivate") || type.equals("userDeactivate")) {
            if (type.equals("userDeactivate")) {
                if (this.customRepository.findActiveUsersByCompany(cid).size() > 1) {
                    User user = this.userRepository.findById(id);
                    if (PropertyValidator.isValid((Collection)user.getUserCompanies())) {
                        for (int i = 0; i < user.getUserCompanies().size(); ++i) {
                            if (!cid.equals(((UserCompany)user.getUserCompanies().get(i)).getCompany().getId())) continue;
                            ((UserCompany)user.getUserCompanies().get(i)).setIsActive(Boolean.valueOf(false));
                            break;
                        }
                    }
                    this.userRepository.save((Object)user);
                    data.put("message", "User Deactivated");
                    data.put("isDeleted", Boolean.TRUE);
                } else {
                    data.put("message", "There should be atleast one active user.");
                    data.put("isDeleted", Boolean.FALSE);
                }
            } else {
                User user = this.userRepository.findById(id);
                if (PropertyValidator.isValid((Collection)user.getUserCompanies())) {
                    for (int i = 0; i < user.getUserCompanies().size(); ++i) {
                        if (!cid.equals(((UserCompany)user.getUserCompanies().get(i)).getCompany().getId())) continue;
                        ((UserCompany)user.getUserCompanies().get(i)).setIsActive(Boolean.valueOf(true));
                        break;
                    }
                }
                this.userRepository.save((Object)user);
                data.put("message", "User Activated");
                data.put("isDeleted", Boolean.TRUE);
            }
        } else if (type.equals("userUnlock")) {
            User user = this.userRepository.findById(id);
            user.setLocked(false);
            this.userRepository.save((Object)user);
            data.put("message", "User has been unlocked");
            data.put("isDeleted", Boolean.TRUE);
        } else if (type.equals("status")) {
            boolean exists = this.itemRepository.existsByStatus(new Status(id));
            if (exists) {
                data.put("isDeleted", Boolean.FALSE);
                data.put("message", "This status is linked with items. In order to delete this status, you must deassociate it from items.");
            } else {
                data.put("isDeleted", Boolean.TRUE);
                data.put("message", "Status deleted");
            }
        } else if (type.equals("severity")) {
            boolean exists = this.isAnySeverityLinked(id);
            if (exists) {
                data.put("isDeleted", Boolean.FALSE);
                data.put("message", "This status is linked with items. In order to delete this status, you must deassociate it from items.");
            } else {
                data.put("isDeleted", Boolean.TRUE);
                data.put("message", "Severity deleted");
            }
        } else if (type.equals("group")) {
            if (this.groupRepository.countByTenantAndArchiveFalse(tenant) > 1L) {
                List accessRoles = this.workSpaceAccessRoleRepository.findByGroup(new Group(id));
                if (PropertyValidator.isValid((Collection)accessRoles)) {
                    data.put("isDeleted", Boolean.FALSE);
                    data.put("message", "This group is linked with workspaces. In order to delete this group, you must deassociate it from workspaces.");
                } else {
                    this.customRepository.setArchive(id, Boolean.valueOf(true), Group.class);
                    data.put("isDeleted", Boolean.TRUE);
                    data.put("message", "Group deleted");
                }
            } else {
                data.put("isDeleted", Boolean.FALSE);
                data.put("message", "There should be atleast one group.");
            }
        } else if (type.equals("role")) {
            if (this.roleRepository.countByTenantAndArchiveFalse(tenant) > 1L) {
                ArrayList<Role> roles = new ArrayList<Role>();
                roles.add(new Role(id));
                List accessRoles = this.workSpaceAccessRoleRepository.findByRolesIn(roles);
                if (PropertyValidator.isValid((Collection)accessRoles)) {
                    data.put("isDeleted", Boolean.FALSE);
                    data.put("message", "This Role is linked with workspaces. In order to delete this role, you must deassociate it from workspaces.");
                } else {
                    this.customRepository.setArchive(id, Boolean.valueOf(true), Role.class);
                    data.put("isDeleted", Boolean.TRUE);
                    data.put("message", "Role deleted");
                }
            } else {
                data.put("isDeleted", Boolean.FALSE);
                data.put("message", "There should be atleast one role.");
            }
        } else if (type.equals("team")) {
            this.customRepository.setArchive(id, Boolean.valueOf(true), Team.class);
            data.put("isDeleted", Boolean.TRUE);
            data.put("message", "Team deleted");
        } else if (type.equals("issuetype")) {
            this.customRepository.setArchive(id, Boolean.valueOf(true), IssueType.class);
            data.put("isDeleted", Boolean.TRUE);
            data.put("message", "Issue Type deleted");
        } else if (type.equals("bucket")) {
            this.customRepository.setArchive(id, Boolean.valueOf(true), IssueType.class);
            data.put("isDeleted", Boolean.TRUE);
            data.put("message", "Bucket deleted");
        } else if (type.equals("workflow") || type.startsWith("workflow")) {
            if (this.workFlowRepository.countByTenantAndArchiveFalse(tenant) > 1L) {
                String[] wfAndTpe = type.split("-");
                WorkFlow wf = new WorkFlow(id, null, wfAndTpe.length > 0 ? wfAndTpe[1] : null);
                String error = this.isWorkFlowLinked(wf);
                if (PropertyValidator.isValid((Object)error)) {
                    data.put("isDeleted", Boolean.FALSE);
                    data.put("message", error);
                } else {
                    this.customRepository.setArchive(id, Boolean.valueOf(true), WorkFlow.class);
                    data.put("isDeleted", Boolean.TRUE);
                    data.put("message", "Workflow archived");
                }
            } else {
                data.put("isDeleted", Boolean.FALSE);
                data.put("message", "There should be atleast one workflow.");
            }
        } else if (type.equals("workspace")) {
            if (this.workSpaceRepository.countByTenantAndArchiveFalse(tenant) > 1L) {
                this.customRepository.setArchive(id, Boolean.valueOf(true), WorkSpace.class);
                List accessRoles = this.workSpaceAccessRoleRepository.findByWorkSpace(new WorkSpace(id));
                this.workSpaceAccessRoleRepository.delete((Iterable)accessRoles);
                data.put("isDeleted", Boolean.TRUE);
                data.put("message", "Collection Deleted");
            } else {
                data.put("isDeleted", Boolean.FALSE);
                data.put("message", "There should be atleast one workspace.");
            }
        } else if (type.equals("almaccount")) {
            List sessions;
            AlmAccount almaccount = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)id));
            List almConfigs = null;
            List tfsAlmConfigs = null;
            List artWorkSpaces = null;
            Boolean remove = true;
            if (PropertyValidator.isValid((Object)almaccount)) {
                AlmAccount _alm = new AlmAccount();
                _alm.setId(id);
                almConfigs = this.almConfigurationsRepository.findByAlmAccount(_alm);
                tfsAlmConfigs = this.tfsAlmConfigurationsRepository.findByAlmAccount(_alm);
                artWorkSpaces = this.workSpaceRepository.findByLinkedAlmAccounts(almaccount.getId());
            } else {
                data.put("isDeleted", Boolean.FALSE);
                data.put("message", "Account not deleted.");
            }
            if (PropertyValidator.isValid(artWorkSpaces)) {
                data.put("isDeleted", Boolean.FALSE);
                data.put("message", "Account not deleted. Its asscoiated with ART's");
                remove = false;
            }
            if (PropertyValidator.isValid((Collection)almConfigs) && remove.booleanValue()) {
                sessions = this.sessionRepository.findByAlmConfigurationsIn(almConfigs);
                if (PropertyValidator.isValid((Collection)sessions)) {
                    data.put("isDeleted", Boolean.FALSE);
                    data.put("message", "Account not deleted. Its asscoiated with sessions");
                    remove = false;
                }
            } else if (PropertyValidator.isValid((Collection)tfsAlmConfigs) && remove.booleanValue() && PropertyValidator.isValid((Collection)(sessions = this.sessionRepository.findByTfsAlmConfigurationsIn(tfsAlmConfigs)))) {
                data.put("isDeleted", Boolean.FALSE);
                data.put("message", "Account not deleted. Its asscoiated with sessions");
                remove = false;
            }
            if (remove.booleanValue()) {
                this.almAccountRepository.delete((Object)almaccount);
                data.put("isDeleted", Boolean.TRUE);
                data.put("message", "ALM Account deleted");
            }
        }
        data.put("id", id);
        data.put("type", type);
        return new ResponseEntity(data, HttpStatus.OK);
    }

    @RequestMapping(value={"/remove/user"})
    public void removeUser(@RequestBody User user) {
        this.userRepository.delete((Object)user);
    }

    @RequestMapping(value={"/remove/workflow"})
    public void removeWorkFlow(@RequestBody WorkFlow workFlow) {
        this.workFlowRepository.delete((Object)workFlow);
    }

    @RequestMapping(value={"/recover/workflow/{workflowId}"})
    public WorkFlow recoverWorkFlow(@PathVariable(value="workflowId") String workflowId) {
        WorkFlow workFlow = null;
        workFlow = this.workFlowRepository.findOneByIdAndArchiveTrue(workflowId);
        workFlow.setArchive(false);
        workFlow = (WorkFlow)this.workFlowRepository.save((Object)workFlow);
        return workFlow;
    }

    @RequestMapping(value={"/remove/status"})
    public void removeStatus(@RequestBody Status status) {
        this.statusRepository.delete((Object)status);
    }

    @RequestMapping(value={"/save/status"})
    public Status saveStatus(@RequestBody Status status) {
        return (Status)this.statusRepository.save((Object)status);
    }

    @RequestMapping(value={"/connect/account/active"})
    public void activateConnectAccount(@RequestBody JiraConnectVO jiraConnectVO) {
        this.aLMSyncService.activeConnectAccount(jiraConnectVO);
    }

    @RequestMapping(value={"/emailconfig"})
    public Config getEmailConfig() {
        Config config;
        if (this.env.getProperty("isLocalDeployment").equals("true") && PropertyValidator.isValid((Object)(config = this.retrieveConfiguration()))) {
            config.getMailConfig().setPassword(null);
            config.setLdapConfig(null);
            return config;
        }
        return null;
    }

    private Config retrieveConfiguration() {
        List configs = this.configRepository.findAll();
        if (PropertyValidator.isValid((Collection)configs)) {
            return (Config)configs.get(0);
        }
        return null;
    }

    @RequestMapping(value={"/save/emailconfig"})
    @ResponseBody
    public ResponseEntity<Object> saveEmailConfig(@RequestBody MailConfig mailConfig) {
        if (this.env.getProperty("isLocalDeployment").equals("true")) {
            HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
            Config config = (Config)this.configRepository.findAll().get(0);
            config.setTenant(null);
            this.configRepository.save((Object)config);
            if (PropertyValidator.isValid((Object)mailConfig.getPassword())) {
                try {
                    mailConfig.setPassword(EncDecUtility.encrypt((String)mailConfig.getPassword()));
                }
                catch (Exception e) {
                    LOGGER.error(StringUtils.getTraceString((Throwable)e));
                }
            }
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is(null));
            Update update = new Update();
            update.set("mailConfig", (Object)mailConfig);
            this.customRepository.getMongoTemplate().updateFirst(query, update, Config.class);
            responseJson.put("success", true);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        return null;
    }

    @RequestMapping(value={"/ldapconfig"})
    public Config getLdapConfig() {
        Config config;
        if (this.env.getProperty("isLocalDeployment").equals("true") && PropertyValidator.isValid((Object)(config = this.retrieveConfiguration()))) {
            config.getLdapConfig().setPassword(null);
            config.setMailConfig(null);
            return config;
        }
        return null;
    }

    @RequestMapping(value={"/postreccode"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> postRecoveryCode(@RequestBody String code) {
        try {
            HashMap<String, Object> responseData = new HashMap<String, Object>();
            if (UserContextUtil.getUserContext() != null && UserContextUtil.getUserContext().getLoggedInUser().isRequireMFACode()) {
                User currUser = this.userRepository.findByUserNameIgnoreCase(UserContextUtil.getUserContext().getUsername());
                if (currUser.getrecoveryMFACode() != null && currUser.getrecoveryMFACode().equals(code)) {
                    User savedUser = this.userRepository.findByUserNameIgnoreCase(UserContextUtil.getUserContext().getUsername());
                    UserContextUtil.getUserContext().getLoggedInUser().setRequireMFACode(false);
                    savedUser.setRequireMFACode(false);
                    this.userRepository.save((Object)savedUser);
                    responseData.put("validate", true);
                    responseData.put("reccode", this.recoveryCode());
                    return new ResponseEntity(responseData, HttpStatus.OK);
                }
                responseData.put("validate", false);
                return new ResponseEntity(responseData, HttpStatus.OK);
            }
            responseData.put("validate", false);
            return new ResponseEntity(responseData, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
            e.printStackTrace();
            return new ResponseEntity(null, HttpStatus.OK);
        }
    }

    @RequestMapping(value={"/samlconfig"})
    public ResponseEntity<Object> getSAMLConfig() {
        List samlconfLst = this.samlConfigRepository.findAll();
        SAMLConfig samlconf = null;
        samlconf = !PropertyValidator.isValid((Collection)samlconfLst) ? new SAMLConfig() : (SAMLConfig)samlconfLst.get(0);
        samlconf.setGroups(this.groupRepository.findAll());
        return new ResponseEntity((Object)samlconf, HttpStatus.OK);
    }

    public SAMLConfig getAzureSAMLMeta(@RequestParam(name="url") String url) {
        HttpGet get = new HttpGet(url);
        String path = get.getURI().getPath();
        String subPath = path.substring(1, path.length());
        String appId = subPath.substring(0, subPath.indexOf("/"));
        CloseableHttpClient httpclient = HttpClients.createMinimal();
        try {
            HttpResponse getResponse = httpclient.execute((HttpUriRequest)get);
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(getResponse.getEntity().getContent());
            doc.getDocumentElement().normalize();
            String certificate = doc.getElementsByTagName("X509Certificate").item(0).getTextContent();
            String loginUrl = doc.getElementsByTagName("SingleSignOnService").item(0).getAttributes().getNamedItem("Location").getNodeValue();
            SAMLConfig config = new SAMLConfig();
            config.setIdentityProviderIssuer(appId);
            config.setIdentityProviderSingleSign(loginUrl);
            config.setXcertificate(certificate);
            config.setProvider("azure");
            this.samlConfigRepository.save((Object)config);
            return config;
        }
        catch (Exception ex) {
            LOGGER.error("Error while sending email :" + StringUtils.getTraceString((Throwable)ex));
            return null;
        }
    }

    public SAMLConfig getOktaSAMLMeta(@RequestParam(name="url") String url) {
        HttpGet get = new HttpGet(url);
        CloseableHttpClient httpclient = HttpClients.createMinimal();
        try {
            HttpResponse getResponse = httpclient.execute((HttpUriRequest)get);
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(getResponse.getEntity().getContent());
            doc.getDocumentElement().normalize();
            String entityId = doc.getElementsByTagName("md:EntityDescriptor").item(0).getAttributes().getNamedItem("entityID").getNodeValue();
            String certificate = doc.getElementsByTagName("ds:X509Certificate").item(0).getFirstChild().getTextContent();
            String location = doc.getElementsByTagName("md:SingleSignOnService").item(0).getAttributes().getNamedItem("Location").getNodeValue();
            SAMLConfig config = new SAMLConfig();
            config.setXcertificate(certificate);
            config.setIdentityProviderIssuer(entityId);
            config.setIdentityProviderSingleSign(location);
            return config;
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    @RequestMapping(value={"/apitoken"})
    public ResponseEntity<Object> getApiToken() {
        ApiToken apiToken;
        List apiTokenList = this.apiTokenRepository.findAll();
        if (apiTokenList != null && !apiTokenList.isEmpty()) {
            apiToken = (ApiToken)apiTokenList.get(0);
        } else {
            apiToken = new ApiToken();
            apiToken.setProvider("Okta");
        }
        return new ResponseEntity((Object)apiToken, HttpStatus.OK);
    }

    @RequestMapping(value={"/getPaymentDetails"})
    @ResponseBody
    public ResponseEntity<Object> getPaymentDetails() {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        Stripe.apiKey = this.env.getProperty("stripe.apiKey");
        try {
            JSONObject json = new JSONObject();
            PaymentDetails paymentDetails = this.companyRepository.findById(UserContextUtil.getUserContext().getCurrentCompanyId()).getPaymentDetails();
            if (paymentDetails != null) {
                if (paymentDetails.getIntent_id() != null) {
                    PaymentMethod paymentMethod = PaymentMethod.retrieve((String)paymentDetails.getIntent_id());
                    responseJson.put("brand", paymentMethod.getCard().getBrand());
                    responseJson.put("last4", paymentMethod.getCard().getLast4());
                    responseJson.put("exp_month", paymentMethod.getCard().getExpMonth());
                    responseJson.put("exp_year", paymentMethod.getCard().getExpYear());
                } else {
                    HashMap retrieveParams = new HashMap();
                    String customerIds = paymentDetails.getCustomerId();
                    ArrayList<String> expandList = new ArrayList<String>();
                    expandList.add("sources");
                    retrieveParams.put("expand", expandList);
                    Customer customer = Customer.retrieve((String)customerIds, retrieveParams, null);
                    String sourceJson = ((StripeObject)customer.getSources().getData().get(0)).toJson();
                    JSONObject sourceJsonObj = new JSONObject(sourceJson);
                    JSONObject typeDataJsonObj = (JSONObject)sourceJsonObj.get("card");
                    responseJson.put("brand", typeDataJsonObj.get("brand"));
                    responseJson.put("last4", typeDataJsonObj.get("last4"));
                    responseJson.put("exp_month", typeDataJsonObj.get("exp_month"));
                    responseJson.put("exp_year", typeDataJsonObj.get("exp_year"));
                }
            }
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception ex) {
            LOGGER.error("Error while Getting Payment Details :" + StringUtils.getTraceString((Throwable)ex));
            return null;
        }
    }

    @RequestMapping(value={"/cancelPayment/{days}"})
    public void cancelPayment(@PathVariable(value="days") String days) {
        String bcc = "testput10@gmail.com";
        if ("kendis.io".equals(this.env.getProperty("server.domain"))) {
            bcc = "finance@kendis.io";
        }
        Company company = this.companyRepository.findById(UserContextUtil.getUserContext().getCurrentCompanyId());
        String companyEmail = company.getPaymentDetails().getEmail();
        company.setPaymentDetails(null);
        company.setExpiryDate(company.getNextPaymentDate());
        company.setNextPaymentDate(null);
        company.setPaymentKey(null);
        HashMap<String, String> mailData = new HashMap<String, String>();
        SimpleDateFormat formatter = new SimpleDateFormat("EEE, d MMM yyyy");
        String expiryDate = formatter.format(company.getExpiryDate());
        mailData.put("expiryDate", expiryDate);
        mailData.put("fullName", UserContextUtil.getUserContext().getLoggedInUser().getFullName());
        String baseUrl = this.getHttpScheme() + "://" + company.getUrlPrefix() + "." + this.env.getProperty("server.domain");
        if (this.env.getProperty("isLocalDeployment").equals("true")) {
            baseUrl = company.getUrl();
        }
        mailData.put("paymentURL", baseUrl + "/administration#billing");
        if (company.getPaymentPackageConfig() != null) {
            if (company.getPaymentPackageConfig().getLiveChat().booleanValue()) {
                mailData.put("planType", "Premium Cloud");
            } else {
                mailData.put("planType", "Basic Cloud");
            }
        } else {
            mailData.put("planType", "Legacy");
        }
        this.companyRepository.save((Object)company);
        if (companyEmail.equalsIgnoreCase(UserContextUtil.getUserContext().getLoggedInUser().getEmail())) {
            this.mailSender.sendMail(companyEmail, bcc, "Plan Cancellation", "cancelPaymentTemplate", mailData, true);
        } else {
            this.mailSender.sendMail(companyEmail, "Plan Cancellation", "cancelPaymentTemplate", mailData, true);
            this.mailSender.sendMail(UserContextUtil.getUserContext().getLoggedInUser().getEmail(), bcc, "Plan Cancellation", "cancelPaymentTemplate", mailData, true);
        }
    }

    @RequestMapping(value={"/save/ldapconfig"})
    @ResponseBody
    public ResponseEntity<Object> saveLdapConfig(@RequestBody Config.LDAPConfig ldapConfig) {
        if (this.env.getProperty("isLocalDeployment").equals("true")) {
            List baseDNList;
            HashMap<String, Object> responseJson = new HashMap<String, Object>();
            try {
                baseDNList = this.ldapService.authenticate(ldapConfig.getUserDn(), ldapConfig.getPassword(), ldapConfig);
                if (ldapConfig.getAddUserDn() != null) {
                    List ldapUsers;
                    AndFilter filter = new AndFilter();
                    if (ldapConfig.getLdapType().equals(Config.ACTIVE_DIR)) {
                        filter.and((Filter)new EqualsFilter("sAMAccountName", ldapConfig.getUserDn().split("@")[0]));
                    } else {
                        filter.and((Filter)new EqualsFilter("uid", ldapConfig.getUserDn()));
                    }
                    String searchStr = "(sAMAccountName=" + ldapConfig.getUserDn().split("@")[0] + ")";
                    if (ldapConfig.getLdapType().equals(Config.OPEN_LDAP)) {
                        searchStr = "(uid=" + ldapConfig.getUserDn() + ")";
                    }
                    if (!PropertyValidator.isValid((Collection)(ldapUsers = this.ldapService.searchLdap(ldapConfig.getUserDn(), ldapConfig.getPassword(), ldapConfig.getBaseUrl(), ldapConfig.getBaseDn(), ldapConfig.getAddUserDn(), searchStr, ldapConfig.isSsl())))) {
                        responseJson.put("success", false);
                        responseJson.put("error", true);
                        responseJson.put("message", "Could not found user in " + ldapConfig.getAddUserDn() + "," + ldapConfig.getBaseDn());
                        return new ResponseEntity(responseJson, HttpStatus.OK);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
                responseJson.put("success", false);
                responseJson.put("error", true);
                responseJson.put("message", e.getMessage());
                return new ResponseEntity(responseJson, HttpStatus.OK);
            }
            if (baseDNList == null) {
                responseJson.put("success", false);
                return new ResponseEntity(responseJson, HttpStatus.OK);
            }
            Config config = (Config)this.configRepository.findAll().get(0);
            config.setTenant(null);
            this.configRepository.save((Object)config);
            if (PropertyValidator.isValid((Object)config.getId()) && !PropertyValidator.isValid((Object)ldapConfig.getPassword())) {
                ldapConfig.setPassword(config.getLdapConfig().getPassword());
            }
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is(null));
            Update update = new Update();
            if (PropertyValidator.isValid((Object)ldapConfig.getPassword())) {
                try {
                    ldapConfig.setPassword(EncDecUtility.encrypt((String)ldapConfig.getPassword()));
                }
                catch (Exception e) {
                    LOGGER.error(StringUtils.getTraceString((Throwable)e));
                }
            }
            update.set("ldapConfig", (Object)ldapConfig);
            this.customRepository.getMongoTemplate().updateFirst(query, update, Config.class);
            responseJson.put("success", true);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        return null;
    }

    @RequestMapping(value={"/reset/ldapconfig"})
    @ResponseBody
    public ResponseEntity<Object> resetLdapConfig(@RequestBody Config.LDAPConfig ldapConfig) {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        Config config = (Config)this.configRepository.findAll().get(0);
        if (config.checkDefaultLDAP()) {
            responseJson.put("success", false);
        } else {
            config.setLdapConfig(new Config.LDAPConfig());
            this.configRepository.save((Object)config);
            responseJson.put("success", true);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/check/premiumfeatures"})
    @ResponseBody
    public ResponseEntity<Object> checkSamlAndLdap(@RequestBody Company company) {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        SAMLConfig samlconfig = this.samlConfigRepository.findByTenant(company.getTenant());
        if (samlconfig != null) {
            responseJson.put("saml", true);
        } else {
            responseJson.put("saml", false);
        }
        Config config = (Config)this.configRepository.findAll().get(0);
        if (config.checkDefaultLDAP()) {
            responseJson.put("ldap", false);
        } else {
            responseJson.put("ldap", true);
        }
        List AlmAccounts = this.almAccountRepository.findAll();
        responseJson.put("auth", false);
        for (AlmAccount alm : AlmAccounts) {
            if (alm.getJiraAuthType() == null || !alm.getJiraAuthType().name().equalsIgnoreCase("Auth")) continue;
            responseJson.put("auth", true);
            break;
        }
        boolean apiCreated = this.userApiKeyRepository.existsByTenantAndRevoked(company.getTenant(), false);
        responseJson.put("api", apiCreated);
        responseJson.put("okta", false);
        List apiTokenList = this.apiTokenRepository.findAll();
        if (!apiTokenList.isEmpty()) {
            for (ApiToken apiToken : apiTokenList) {
                if (!apiToken.getProvider().equalsIgnoreCase("Okta")) continue;
                responseJson.put("okta", true);
            }
        }
        Company oldCompany = this.companyRepository.findById(company.getId());
        responseJson.put("security", false);
        if (oldCompany.getSecurityPolicy() != null) {
            responseJson.put("security", true);
        }
        responseJson.put("solutionBoard", false);
        List solutionBoardList = this.solutionBoardRepository.findAll();
        if (solutionBoardList.size() > 0) {
            responseJson.put("solutionBoard", true);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/save/samlconfig"})
    @ResponseBody
    public ResponseEntity<Object> saveSamlConfig(@RequestBody SAMLConfig samlConfig) {
        if (samlConfig != null) {
            HashMap<String, String> responseJson = new HashMap<String, String>();
            String error = null;
            List samlconfList = this.samlConfigRepository.findAll();
            SAMLConfig samlconf = samlconfList != null && !samlconfList.isEmpty() ? (SAMLConfig)samlconfList.get(0) : new SAMLConfig();
            samlconf.setIdentityProviderIssuer(samlConfig.getIdentityProviderIssuer());
            samlconf.setIdentityProviderSingleSign(samlConfig.getIdentityProviderSingleSign());
            samlconf.setIdentityProviderSingleSignOut(samlConfig.getIdentityProviderSingleSignOut());
            samlconf.setXcertificate(samlConfig.getXcertificate());
            samlconf.setGroup(samlConfig.getGroup());
            samlconf.setCallBack(samlConfig.getCallBack());
            samlconf.setAddAsInActiveUser(samlConfig.isAddAsInActiveUser());
            samlconf.setAddkeystore(samlConfig.isAddkeystore());
            samlconf.setForceLogin(samlConfig.isForceLogin());
            samlconf.setCustomMsg(samlConfig.getCustomMsg());
            samlconf.setSignKeyAlias(samlConfig.getSignKeyAlias());
            samlconf.setSignKeyStoreId(samlConfig.getSignKeyStoreId());
            samlconf.setSingKeyPass(samlConfig.getSingKeyPass());
            samlconf.setIncludeAssertionConsumerServiceURL(samlConfig.isIncludeAssertionConsumerServiceURL());
            samlconf.setIdentityProvider(samlConfig.getIdentityProvider());
            if (samlConfig.isAddkeystore() && PropertyValidator.isValid((Object)samlConfig.getKeyStoreFileId())) {
                samlconf.setKeyStoreFileId(samlConfig.getKeyStoreFileId());
            } else if (!samlConfig.isAddkeystore()) {
                samlconf.setKeyStoreFileId("");
            }
            try {
                if (PropertyValidator.isValid((Object)samlconf.getSignKeyStoreId())) {
                    InputStream inputStream = MongoSyncUtils.retrieveStreamDataById((String)samlconf.getKeyStoreFileId(), (AppConfig.MongoConfig)this.mongoConfig);
                    KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
                    ks.load(inputStream, samlconf.getSingKeyPass().toCharArray());
                    if (!ks.containsAlias(samlconf.getSignKeyAlias())) {
                        Enumeration<String> aliasEnum = ks.aliases();
                        ArrayList<String> aliasList = new ArrayList<String>();
                        while (aliasEnum.hasMoreElements()) {
                            String vlaue = aliasEnum.nextElement();
                            aliasList.add(vlaue);
                        }
                        error = "Alias doesn't match. Please enter the correct Alias: " + Arrays.toString(aliasList.toArray());
                        LOGGER.error(error);
                        responseJson.put("error", error);
                        return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
                responseJson.put("error", e.getMessage());
                return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
            }
            SAMLConfig savedSamlConfig = (SAMLConfig)this.samlConfigRepository.save((Object)samlconf);
            if (PropertyValidator.isValid(error)) {
                responseJson.put("errorMessage", error);
            }
            responseJson.put("samlConfig", (String)savedSamlConfig);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        return null;
    }

    @RequestMapping(value={"/user-prompt-{checked}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> updateUserAlmPrompts(@PathVariable(value="checked") String checked) {
        Company companyFetch = this.companyRepository.findById(UserContextUtil.getUserContext().getCurrentCompanyId());
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        responseJson.put("success", false);
        if ("true".equals(checked)) {
            companyFetch.setPrompForProfile(Boolean.valueOf(true));
        } else {
            companyFetch.setPrompForProfile(Boolean.valueOf(false));
        }
        this.companyRepository.save((Object)companyFetch);
        responseJson.put("success", true);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/reset/securitypolicy"})
    @ResponseBody
    public ResponseEntity<Object> resetSecurityPolicy(@RequestBody Company company) {
        Company companyFetch = this.companyRepository.findById(UserContextUtil.getUserContext().getCurrentCompanyId());
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        if (companyFetch.getSecurityPolicy() != null) {
            companyFetch.setSecurityPolicy(null);
            this.companyRepository.save((Object)companyFetch);
            responseJson.put("success", true);
        } else {
            responseJson.put("success", false);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/reset/samlconfig"})
    @ResponseBody
    public ResponseEntity<Object> resetSamlConfig(@RequestBody Company company) {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        SAMLConfig samlconfig = this.samlConfigRepository.findByTenant(company.getTenant());
        if (samlconfig != null) {
            this.samlConfigRepository.delete((Object)samlconfig);
            responseJson.put("success", true);
        } else {
            responseJson.put("success", false);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/reset/premiumfeatures"})
    @ResponseBody
    public ResponseEntity<Object> resetPremiumFeatures(@RequestBody String reqBody) {
        Gson g = new Gson();
        12 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap body = (HashMap)g.fromJson(reqBody, T.getType());
        String companyString = (String)body.get("company");
        String userString = (String)body.get("user");
        ObjectMapper map = new ObjectMapper();
        Company company = null;
        try {
            company = (Company)map.readValue(companyString, Company.class);
        }
        catch (IOException e) {
            System.out.println(e);
        }
        ResponseEntity responseSamlJson = null;
        if (PropertyValidator.isValid((Object)company)) {
            responseSamlJson = this.resetSamlConfig(company);
        }
        if (userString != null) {
            HashMap<String, String> user = new HashMap<String, String>();
            user.put("id", userString);
            ResponseEntity responseEntity = this.disableMFA(user);
        }
        if (PropertyValidator.isValid((Object)company) && PropertyValidator.isValid((Object)company.getSecurityPolicy())) {
            company.setSecurityPolicy(null);
            this.companyRepository.save((Object)company);
        }
        this.resetApiToken();
        return new ResponseEntity((Object)responseSamlJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/save/apitoken"})
    @ResponseBody
    public ResponseEntity<Object> saveApiToken(@RequestBody ApiToken apiToken) {
        if (apiToken != null) {
            ApiToken apitoken;
            List apiTokenList = this.apiTokenRepository.findAll();
            if (apiTokenList != null && !apiTokenList.isEmpty()) {
                apitoken = (ApiToken)apiTokenList.get(0);
                if (!PropertyValidator.isValid((Object)apiToken.getToken())) {
                    apiToken.setToken(apitoken.getToken());
                }
            } else {
                apitoken = new ApiToken();
            }
            apitoken.setProvider(apiToken.getProvider());
            apitoken.setToken(apiToken.getToken());
            ApiToken savedApiToken = (ApiToken)this.apiTokenRepository.save((Object)apitoken);
            return new ResponseEntity((Object)savedApiToken, HttpStatus.OK);
        }
        return null;
    }

    @RequestMapping(value={"/reset/apitoken"})
    @ResponseBody
    public ResponseEntity<Object> resetApiToken() {
        HashMap<String, Boolean> response = new HashMap<String, Boolean>();
        response.put("success", false);
        List apiTokenList = this.apiTokenRepository.findAll();
        if (!apiTokenList.isEmpty()) {
            for (ApiToken apiToken : apiTokenList) {
                if (!apiToken.getProvider().equalsIgnoreCase("Okta")) continue;
                this.apiTokenRepository.delete((Object)apiToken);
                response.put("success", true);
            }
        }
        return new ResponseEntity(response, HttpStatus.OK);
    }

    @RequestMapping(value={"/test/ldapconfig"})
    @ResponseBody
    public ResponseEntity<Object> testLdapConnection(@RequestBody Config.LDAPConfig ldapConfig) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        if (PropertyValidator.isValid((Object)ldapConfig)) {
            try {
                List result = this.ldapService.authenticate(ldapConfig.getUserDn(), ldapConfig.getPassword(), ldapConfig);
                responseJson.put("baseDN", result);
            }
            catch (Exception e) {
                responseJson.put("success", false);
                responseJson.put("error", e.getMessage());
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/test/emailconfig"})
    @ResponseBody
    public ResponseEntity<Object> testSmtpConfig(@RequestBody MailConfig mailConfig) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        User u = (User)secureUser.getUserContextDTO().getContextMap().get("user");
        String usrEmail = u.getEmail();
        try {
            HashMap<String, String> kv = new HashMap<String, String>();
            kv.put("testBy", usrEmail);
            this.mailSender.sendTestMail(usrEmail, "Kendis SMTP settings worked", "testMailTemplate", kv, true, mailConfig);
            responseJson.put("success", true);
            responseJson.put("email", usrEmail);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception ex) {
            responseJson.put("success", false);
            responseJson.put("error", ex.getMessage());
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
    }

    @RequestMapping(value={"/emailexist"})
    @ResponseBody
    public ResponseEntity<Object> isEmailExists(@RequestBody String payload) {
        HashMap<String, Boolean> responseJson;
        block4: {
            responseJson = new HashMap<String, Boolean>();
            try {
                JSONObject reqObj = new JSONObject(payload);
                String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
                ArrayList<String> alreadyEmails = new ArrayList<String>();
                alreadyEmails.add(reqObj.getString("userEmail"));
                SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
                String tenant = String.valueOf(secureUser.getUserContextDTO().getContextMap().get("tenant"));
                Query query = new Query();
                query.with(new Sort(Sort.Direction.DESC, new String[]{"updatedOn"}));
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"email").in(alreadyEmails));
                Criteria criteria = new Criteria();
                criteria = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"userType").is(null), Criteria.where((String)"userType").is((Object)"KENDIS")});
                query.addCriteria((CriteriaDefinition)criteria);
                List alreadyUsers = this.mongoTemplate.find(query, User.class);
                if (!PropertyValidator.isValid((Collection)alreadyUsers)) break block4;
                responseJson.put("alreadyUser", true);
                User alreadyUser = (User)alreadyUsers.get(0);
                List userCompanies = alreadyUser.getUserCompanies();
                for (int i = 0; i < userCompanies.size(); ++i) {
                    if (!((UserCompany)userCompanies.get(i)).getCompany().getId().equals(cid)) continue;
                    responseJson.put("userInCompany", true);
                    if (((UserCompany)userCompanies.get(i)).getIsArchive().booleanValue()) {
                        responseJson.put("archivedInCompany", true);
                    }
                    break;
                }
            }
            catch (Exception e) {
                LOGGER.error("FAILED(isEmailExists): " + StringUtils.getTraceString((Throwable)e));
            }
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/configuration/{type}"})
    public ResponseEntity<Object> getCompanyCustomize(@PathVariable(value="type") String configType) {
        HashMap responseJson = new HashMap();
        String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
        Company _comp = (Company)this.companyRepository.findOne((Serializable)((Object)cid));
        if (!PropertyValidator.isValid((Object)configType) || !configType.equals("security")) {
            _comp.setSecurityPolicy(null);
        }
        responseJson.put("features", EnumFeature.getAllValuesList((boolean)false));
        responseJson.put("orgFeatures", EnumFeature.getAllValuesList((boolean)true));
        responseJson.put("company", _comp);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/toggle/feature"}, method={RequestMethod.POST})
    public HashMap<String, Object> toggleFeature(@RequestBody HashMap<String, Object> data) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            if (PropertyValidator.isValid((Object)data.get("key")) && PropertyValidator.isValid((Object)data.get("value"))) {
                String key = (String)data.get("key");
                Boolean value = (Boolean)data.get("value");
                this.customRepository.updatePaymentPackageConfig(key, value);
            }
            String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
            Company comp = this.companyRepository.findById(cid);
            PaymentPackageConfig paymentPackageConfig = comp.getPaymentPackageConfig();
            UserContextUtil.getUserContext().getCurrentCompany().setPaymentPackageConfig(comp.getPaymentPackageConfig());
            response.put("paymentPackageConfig", paymentPackageConfig);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            response.put("error", e);
            return response;
        }
        return response;
    }

    @RequestMapping(value={"/toggle/externalLinkFeature"}, method={RequestMethod.POST})
    public HashMap<String, Object> toggleExternalFeature(@RequestBody HashMap<String, Object> data) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            if (PropertyValidator.isValid((Object)data.get("key")) && PropertyValidator.isValid((Object)data.get("value"))) {
                String key = (String)data.get("key");
                Boolean value = (Boolean)data.get("value");
                this.customRepository.updateCustomization(key, value);
            }
            String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
            Company comp = this.companyRepository.findById(cid);
            Customize customization = comp.getCustomization();
            response.put("customization", customization);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            response.put("error", e);
            return response;
        }
        return response;
    }

    @RequestMapping(value={"/titleupdate"}, method={RequestMethod.POST})
    public String updateTitle(@RequestBody Map<String, String> request) {
        String title = null;
        try {
            title = request.get("title");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String response = "";
        try {
            String updatedTitle;
            if (PropertyValidator.isValid((Object)title)) {
                this.customRepository.updateExternalLinksTitle("customization.externalLinksHeading", title);
            }
            String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
            Company comp = this.companyRepository.findById(cid);
            response = updatedTitle = comp.getCustomization().getExternalLinksHeading();
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            response = e.getMessage();
            return response;
        }
        return response;
    }

    @RequestMapping(value={"/fetchTitle"}, method={RequestMethod.GET})
    public String fetchTitle() {
        String response = "";
        String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
        Company comp = this.companyRepository.findById(cid);
        response = comp.getCustomization().getExternalLinksHeading();
        return response;
    }

    @RequestMapping(value={"/passwordpolicy/save"})
    public ResponseEntity<Object> saveSecurityPolicy(@RequestBody SecurityPolicy securityPolicy) {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
        Company company = (Company)this.companyRepository.findOne((Serializable)((Object)cid));
        if (PropertyValidator.isValid((Object)company)) {
            if (company.getSecurityPolicy() != null && company.getSecurityPolicy().getExpirySetOn() != null) {
                securityPolicy.setExpirySetOn(company.getSecurityPolicy().getExpirySetOn());
            }
            if (PropertyValidator.isValid((Object)company.getSecurityPolicy())) {
                if (company.getSecurityPolicy().getPasswordChangeDuration() != securityPolicy.getPasswordChangeDuration()) {
                    securityPolicy.setExpirySetOn(new Date());
                }
            } else if (securityPolicy.getPasswordChangeDuration() != -1) {
                securityPolicy.setExpirySetOn(new Date());
            }
            if (PropertyValidator.isValid((Object)securityPolicy.getSessionInactivityTimeout())) {
                securityPolicy.setSessionInactivityTimeout(securityPolicy.getSessionInactivityTimeout());
            } else {
                securityPolicy.setSessionInactivityTimeout(null);
            }
            if (PropertyValidator.isValid((Object)securityPolicy.getSessionMaxAge())) {
                securityPolicy.setSessionMaxAge(securityPolicy.getSessionMaxAge());
            } else {
                securityPolicy.setSessionMaxAge(null);
            }
            company.setSecurityPolicy(securityPolicy);
            this.companyRepository.save((Object)company);
            responseJson.put("success", true);
        } else {
            responseJson.put("success", false);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/orgName/save"})
    public ResponseEntity<Object> saveOrgName(@RequestBody HashMap<String, Object> body) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        String organizationName = (String)body.get("orgName");
        String cid = (String)body.get("cid");
        Company company = (Company)this.companyRepository.findOne((Serializable)((Object)cid));
        if (PropertyValidator.isValid((Object)company)) {
            company.setName(organizationName);
            this.companyRepository.save((Object)company);
            responseJson.put("company", company);
            responseJson.put("success", true);
        } else {
            responseJson.put("success", false);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/headercolor/save"})
    public ResponseEntity<Object> saveHeaderColor(@RequestBody Customize _customize) {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
        Company _comp = (Company)this.companyRepository.findOne((Serializable)((Object)cid));
        if (PropertyValidator.isValid((Object)_comp)) {
            Customize customize = _comp.getCustomization();
            if (!PropertyValidator.isValid((Object)customize)) {
                customize = new Customize();
            }
            customize.setHeaderColor(_customize.getHeaderColor());
            _comp.setCustomization(customize);
            this.companyRepository.save((Object)_comp);
            UserContextUtil.getUserContext().getCurrentCompany().setCustomization(customize);
            responseJson.put("success", true);
            responseJson.put("customize", (Boolean)customize);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/captcha"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> checkCaptcha(@RequestBody String requestPayload) {
        return new ResponseEntity((Object)KendisUtils.isCaptchaValid((String)"6LepnWwUAAAAANBT0IhdChDtop_MsDUdXhnm7WcI", (String)requestPayload), HttpStatus.OK);
    }

    private String[] decryptPaymentKey(String key) {
        String decKey = null;
        try {
            decKey = new KhufiaKari().decrypt(key);
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
        return decKey.split(":");
    }

    private HashMap<String, Object> checkLdapAndSamalConfig(Company company) {
        HashMap<String, Object> paymentDetail = new HashMap<String, Object>();
        try {
            Config config = (Config)this.configRepository.findAll().get(0);
            SAMLConfig samlconfig = this.samlConfigRepository.findByTenant(company.getTenant());
            List solutionBoardList = this.solutionBoardRepository.findAll();
            if (samlconfig != null || !config.checkDefaultLDAP() || solutionBoardList.size() > 0 || company.getSecurityPolicy() != null) {
                paymentDetail.put("smalConfig", samlconfig != null);
                paymentDetail.put("ldapConfig", !config.checkDefaultLDAP());
                paymentDetail.put("solutionBoard", solutionBoardList.size() > 0);
                paymentDetail.put("security", company.getSecurityPolicy() != null);
                paymentDetail.put("All", true);
                return paymentDetail;
            }
            paymentDetail.put("smalConfig", false);
            paymentDetail.put("ldapConfig", false);
            paymentDetail.put("solutionBoard", false);
            paymentDetail.put("security", false);
            paymentDetail.put("All", false);
            return paymentDetail;
        }
        catch (Exception ex) {
            return paymentDetail;
        }
    }

    @RequestMapping(value={"/paymentkey"}, method={RequestMethod.POST})
    public ResponseEntity<Object> savePaymentKey(@RequestBody String requestPayload) throws JSONException {
        String key = null;
        String decKey = null;
        boolean disableAll = false;
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        HashMap paymentDetail = new HashMap();
        JSONObject obj = new JSONObject();
        boolean isDownGrade = false;
        obj = new JSONObject(requestPayload);
        key = obj.getString("key");
        if (obj.has("disableAll") && obj.getString("disableAll") != null) {
            disableAll = true;
        }
        try {
            decKey = new KhufiaKari().decrypt(key);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        if (!PropertyValidator.isValid((Object)decKey)) {
            responseJson.put("success", "false");
            responseJson.put("msg", "Unfortunately the key that you have entered is an invalid key");
            return new ResponseEntity(responseJson, HttpStatus.ACCEPTED);
        }
        String[] splitPaymentKey = decKey.split(":");
        String mode = splitPaymentKey[0];
        String userCount = splitPaymentKey[1];
        String expiry = splitPaymentKey[2];
        String duration = splitPaymentKey[3];
        String guestUserCountStr = null;
        long guestUserCount = 0L;
        String enableArt = null;
        if (splitPaymentKey.length > 4) {
            guestUserCountStr = splitPaymentKey[4];
            guestUserCount = Long.parseLong(guestUserCountStr);
        }
        if (splitPaymentKey.length > 5) {
            enableArt = splitPaymentKey[5];
        }
        long currUsersCount = this.userService.findActiveUserByCompanyId(UserContextUtil.getUserContext().getCurrentCompanyId());
        long currGuestUsersCount = this.userService.findActiveGuestUserByCompanyId(UserContextUtil.getUserContext().getCurrentCompanyId());
        long invitaionCount = this.invitationRepository.findAll().size();
        long totalUsers = currUsersCount + invitaionCount;
        if (totalUsers > Long.parseLong(userCount)) {
            responseJson.put("success", "false");
            responseJson.put("msg", "Your license users are less then your current users count, Please add license with more than or equal to " + totalUsers + " users");
            return new ResponseEntity(responseJson, HttpStatus.ACCEPTED);
        }
        if (currGuestUsersCount > guestUserCount) {
            responseJson.put("success", "false");
            responseJson.put("msg", "Your license guest users are less then your current guest users count, Please add license with more than or equal to " + currGuestUsersCount + " users");
            return new ResponseEntity(responseJson, HttpStatus.ACCEPTED);
        }
        if (Long.parseLong(expiry) < new Date().getTime()) {
            responseJson.put("success", "false");
            responseJson.put("msg", "expired key");
            return new ResponseEntity(responseJson, HttpStatus.ACCEPTED);
        }
        boolean samlLdapEnable = false;
        Company company = this.companyRepository.findById(UserContextUtil.getUserContext().getCurrentCompanyId());
        PaymentPackageConfig paymentConfig = company.getPaymentPackageConfig();
        paymentDetail = this.checkLdapAndSamalConfig(company);
        if (paymentDetail.get("All") != null) {
            samlLdapEnable = (Boolean)paymentDetail.get("All");
        }
        if (guestUserCount <= 0L && !disableAll && company.isGuestEnabled()) {
            isDownGrade = true;
            responseJson.put("guestUserEnabledWarning", true);
        }
        if (!PropertyValidator.isValid((Object)enableArt) && !disableAll && company.isEnableArt()) {
            isDownGrade = true;
            responseJson.put("enableArtWarning", true);
        } else if (PropertyValidator.isValid((Object)enableArt) && enableArt.equalsIgnoreCase("no") && !disableAll && company.isEnableArt()) {
            isDownGrade = true;
            responseJson.put("enableArtWarning", true);
        }
        boolean apiKeysExist = this.userApiKeyRepository.existsByTenantAndRevoked(company.getTenant(), false);
        if (apiKeysExist && !disableAll && company.getIsPremium().booleanValue() && !"paid-p".equals(mode)) {
            isDownGrade = true;
            responseJson.put("enableApiWarning", true);
        }
        if (guestUserCount > 0L) {
            company.setGuestEnabled(true);
            company.setGuestUserCount(guestUserCount);
        } else {
            company.setGuestEnabled(false);
        }
        if (PropertyValidator.isValid((Object)enableArt) && enableArt.equalsIgnoreCase("Yes")) {
            company.setEnableArt(true);
        } else {
            company.setEnableArt(false);
        }
        if (mode.equals("paid-s") && !disableAll && company.getIsPremium().booleanValue()) {
            isDownGrade = true;
            responseJson.put("paymentDetail", paymentDetail);
            if (PropertyValidator.isValid((Object)paymentConfig)) {
                responseJson.put("paymentConfig", company.getPaymentPackageConfig());
            }
            responseJson.put("isPremiumWarning", true);
        }
        if (mode.equals("paid-s")) {
            paymentConfig.setAllFalse();
        } else if (mode.equals("paid-p")) {
            paymentConfig.setAllTrue();
        }
        if (PropertyValidator.isValid((Object)paymentConfig)) {
            company.setPaymentPackageConfig(paymentConfig);
        }
        if (isDownGrade) {
            responseJson.put("downgrade", true);
            responseJson.put("success", "false");
            return new ResponseEntity(responseJson, HttpStatus.ACCEPTED);
        }
        if (key != null) {
            company.setPaymentKey(key);
            this.companyRepository.save((Object)company);
        } else {
            LOGGER.error("input key is null");
        }
        responseJson.put("mode", mode);
        responseJson.put("userCount", userCount);
        responseJson.put("expiry", expiry);
        responseJson.put("duration", duration);
        responseJson.put("success", "true");
        if (PropertyValidator.isValid((Object)guestUserCountStr)) {
            responseJson.put("guestUserCount", guestUserCount);
        }
        if (PropertyValidator.isValid((Object)enableArt)) {
            responseJson.put("enableArt", enableArt);
        }
        return new ResponseEntity(responseJson, HttpStatus.ACCEPTED);
    }

    private boolean isMFAEnabledForAnyCompanyUser() {
        try {
            Company company = this.companyRepository.findById(UserContextUtil.getUserContext().getCurrentCompanyId());
            List allCompanyUsersUnArchived = new ArrayList();
            if (PropertyValidator.isValid((Object)company.getId())) {
                allCompanyUsersUnArchived = this.userRepository.findByUserCompanies_Company_IdAndUserCompanies_isArchive(company.getId(), Boolean.valueOf(false));
            }
            for (User user : allCompanyUsersUnArchived) {
                if (user.getMfaCodeSec() == null && !user.getforcedMFA().booleanValue()) continue;
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return true;
        }
        return false;
    }

    @RequestMapping(value={"/updatePaymentPlan"}, method={RequestMethod.POST})
    public ResponseEntity<Object> updatePaymentPlan(@RequestBody Company company) {
        this.paymentService.updatePaymentPlan(company);
        UserContextUtil.getUserContext().getCurrentCompany().setPaymentPackageConfig(company.getPaymentPackageConfig());
        UserContextUtil.getUserContext().getCurrentCompany().getPaymentDetails().setPlanType(company.getPaymentDetails().getPlanType());
        return new ResponseEntity((Object)this.companyRepository.findById(UserContextUtil.getUserContext().getCurrentCompany().getId()), HttpStatus.ACCEPTED);
    }

    @RequestMapping(value={"/downloadInvoice/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<ByteArrayResource> downloadInvoice(@PathVariable(value="id") String id) {
        LOGGER.debug("download invoice step 1");
        PaymentTransactions payment = this.paymentTransactionsRepository.findById(id);
        LOGGER.debug("" + payment);
        HashMap<String, Object> vars = new HashMap<String, Object>();
        BigDecimal roundedplanPrice = null;
        BigDecimal roundedChargedAmount = null;
        if (PropertyValidator.isValid((Object)payment.getFormat()) && payment.getFormat().equals("new")) {
            roundedChargedAmount = new BigDecimal((double)payment.getChargedAmount() / 100.0).setScale(2, RoundingMode.HALF_UP);
            roundedplanPrice = new BigDecimal((double)payment.getPlanPrice() / 100.0).setScale(2, RoundingMode.HALF_UP);
        } else {
            roundedChargedAmount = new BigDecimal(payment.getChargedAmount()).setScale(2, RoundingMode.HALF_UP);
            roundedplanPrice = new BigDecimal(payment.getPlanPrice()).setScale(2, RoundingMode.HALF_UP);
        }
        float resultplanPrice = roundedplanPrice.floatValue();
        float resultChargedAmount = roundedChargedAmount.floatValue();
        BigDecimal roundedVat = new BigDecimal(resultChargedAmount - resultplanPrice).setScale(2, RoundingMode.HALF_UP);
        float resultVat = roundedVat.floatValue();
        vars.put("invId", Long.parseLong(payment.getGeneratedId()));
        vars.put("users", payment.getUsersCount());
        vars.put("duration", payment.getDuration());
        vars.put("planPrice", Float.valueOf(resultplanPrice));
        vars.put("totalPrice", Float.valueOf(resultChargedAmount));
        vars.put("vat", Float.valueOf(resultVat));
        SimpleDateFormat formatter = new SimpleDateFormat("dd MMM yyyy");
        vars.put("startDate", formatter.format(payment.getCreatedOn()));
        vars.put("endDate", formatter.format(payment.getEndDate()));
        vars.put("name", payment.getBillingCompanyName());
        vars.put("email", payment.getEmail());
        vars.put("address", payment.getAddress());
        vars.put("country", payment.getCountry());
        LOGGER.debug("download invoice step 2");
        if (payment.getVatNo() != null) {
            vars.put("vatNo", payment.getVatNo());
        } else {
            vars.put("vatNo", " ");
        }
        Company company = this.companyRepository.findByTenant(payment.getTenant());
        String baseUrl = this.getHttpScheme() + "://" + company.getUrlPrefix() + "." + this.env.getProperty("server.domain");
        if (this.env.getProperty("isLocalDeployment").equals("true")) {
            baseUrl = UserContextUtil.getUserContext().getCurrentCompany().getUrl();
        }
        vars.put("paymentURL", baseUrl + "/administration#billing");
        if (company.getPaymentPackageConfig() != null) {
            if (company.getPaymentPackageConfig().getLiveChat().booleanValue()) {
                vars.put("planType", "Premium Cloud");
            } else {
                vars.put("planType", "Basic Cloud");
            }
        } else {
            vars.put("planType", "Legacy");
        }
        if (company.getDuration() == 1L) {
            vars.put("monthCount", "month");
        } else {
            vars.put("monthCount", "months");
        }
        String filePath = this.paymentService.createInvoice(vars);
        LOGGER.debug("download invoice step 3");
        LOGGER.debug("" + filePath);
        try {
            File responsefile = new File(filePath);
            Path path = Paths.get(filePath, new String[0]);
            ByteArrayResource resource = new ByteArrayResource(Files.readAllBytes(path));
            HttpHeaders headers = new HttpHeaders();
            headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
            headers.add("Pragma", "no-cache");
            headers.add("Expires", "0");
            headers.add("Content-Disposition", "attachment; filename=" + responsefile.getName());
            LOGGER.debug("download invoice step 4");
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).contentLength(responsefile.length()).contentType(new MediaType("application", "pdf")).body((Object)resource);
        }
        catch (Exception e) {
            LOGGER.error("Error downloading invoice :" + StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    @RequestMapping(value={"/updateBillingDetails"}, method={RequestMethod.POST})
    public ResponseEntity<Object> updateBillingDetails(@RequestBody PaymentDetails paymentDetailsNew) {
        Stripe.apiKey = this.env.getProperty("stripe.apiKey");
        PaymentDetails paymentDetails = this.companyRepository.findById(UserContextUtil.getUserContext().getCurrentCompanyId()).getPaymentDetails();
        String customerId = null;
        if (paymentDetails != null) {
            customerId = paymentDetails.getCustomerId();
        }
        Customer customer = null;
        Company company = null;
        try {
            if (customerId != null) {
                customer = Customer.retrieve((String)customerId);
            }
            company = this.companyRepository.findById(UserContextUtil.getUserContext().getCurrentCompany().getId());
            paymentDetails.setCustomerId(customer.getId());
            paymentDetails.setEmail(paymentDetailsNew.getEmail());
            paymentDetails.setAddress(paymentDetailsNew.getAddress());
            paymentDetails.setName(paymentDetailsNew.getName());
            paymentDetails.setCountry(paymentDetailsNew.getCountry());
            paymentDetails.setPostalCode(paymentDetailsNew.getPostalCode());
            paymentDetails.setVatCountry(new VatCountry(paymentDetailsNew.getVatCountryId()));
            paymentDetails.setCity(paymentDetailsNew.getCity());
            paymentDetails.setBillingCompanyName(paymentDetailsNew.getBillingCompanyName());
            paymentDetails.setVatNo(paymentDetailsNew.getVatNo());
            company.setPaymentFormat("new");
            if (paymentDetailsNew.getPlanPrice() != 0L) {
                company.setPlanPrice(paymentDetailsNew.getPlanPrice());
            }
            company.setTotalPrice(paymentDetailsNew.getTotalPrice());
            company.setVatPct(paymentDetailsNew.getVatPct());
            company.setPaymentDetails(paymentDetails);
            this.companyRepository.save((Object)company);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            HashMap responseJson = new HashMap();
            return new ResponseEntity(responseJson, HttpStatus.NOT_ACCEPTABLE);
        }
        return new ResponseEntity((Object)company, HttpStatus.ACCEPTED);
    }

    @RequestMapping(value={"/vatCountries"})
    public List<VatCountry> getVatCountries() {
        return this.vatCountryRepository.findAll();
    }

    @RequestMapping(value={"/paymentTransactions"})
    public List<PaymentTransactions> getPaymentTransactions() {
        return this.paymentTransactionsRepository.findAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ResponseBody
    public ResponseEntity<Object> fixMultiCompanyForNordea(HttpServletResponse response) {
        block11: {
            String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
            String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
            try {
                if (PropertyValidator.isValid((Object)tenant) && tenant.equals("f0618643-98c3-417d-96fd-bf08a9ba6ac6")) {
                    UserContextUtil.getUserContext().setSkipTenant(true);
                    List companies = this.companyRepository.findAll();
                    if (companies.size() == 1) {
                        UserContextUtil.getUserContext().setSkipTenant(false);
                        LOGGER.debug("Already single company : no need to fix anything");
                        ResponseEntity responseEntity = new ResponseEntity((Object)"Already single company : no need to fix anything", HttpStatus.OK);
                        return responseEntity;
                    }
                    List users = this.userRepository.findAll();
                    LOGGER.debug("Total Users fetched : " + users.size());
                    HashSet<String> userNames = new HashSet<String>();
                    ArrayList<User> duplicatedUsers = new ArrayList<User>();
                    for (User user : users) {
                        if (userNames.contains(user.getUserName().toLowerCase())) {
                            this.workSpaceAccessRoleRepository.deleteByUser(user);
                            this.customRepository.removeUserFromGroups(user.getId());
                            LOGGER.debug("Identified as Duplicate : " + user.getUserName());
                            duplicatedUsers.add(user);
                            this.userRepository.delete((Object)user);
                            continue;
                        }
                        userNames.add(user.getUserName().toLowerCase());
                        if (!PropertyValidator.isValid((Collection)user.getUserCompanies())) continue;
                        ((UserCompany)user.getUserCompanies().get(0)).setCompany(new Company(cid));
                    }
                    users.removeAll(duplicatedUsers);
                    this.userRepository.save((Iterable)users);
                    LOGGER.debug("Total Users saved : " + users.size());
                    for (Company company : companies) {
                        if (company.getId().equals(cid)) continue;
                        this.companyRepository.delete((Object)company);
                        LOGGER.debug("Multiple company Issue : ");
                        LOGGER.debug("Company Name : " + company.getName());
                        LOGGER.debug("Company Tenant : " + company.getTenant());
                    }
                    this.tokenRepository.deleteAll();
                    LOGGER.debug("All Tokens deleted");
                    response.sendRedirect("/signout");
                    break block11;
                }
                LOGGER.debug("Your tenant does not match.");
                ResponseEntity companies = new ResponseEntity((Object)"Your tenant does not match.", HttpStatus.OK);
                return companies;
            }
            catch (Exception ex) {
                LOGGER.error("Error while sending email :" + StringUtils.getTraceString((Throwable)ex));
            }
            finally {
                UserContextUtil.getUserContext().setSkipTenant(false);
            }
        }
        return null;
    }

    @RequestMapping(value={"/saveoauthconfig"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveOauth2Config(Oauth2Config oauth2Config) {
        this.oauth2ConfigRepository.save((Object)oauth2Config);
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        responseJson.put("success", true);
        responseJson.put("oauth2Config", (Boolean)oauth2Config);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    private void sendMail(Map<String, Object> data, String subject, String template, String to) {
        data.put("invitedByEmail", data.get("invitedByEmail"));
        data.put("invitedByUrl", data.get("invitedByUrl"));
        data.put("companyName", UserContextUtil.getUserContext().getCurrentCompany().getName());
        this.mailSender.sendMail(to, subject, template, data, true);
    }

    private String getHttpScheme() {
        if (this.env.getProperty("redirect.from.http.server.port") != null) {
            return "https";
        }
        return "http";
    }

    @RequestMapping(value={"/generateRecoveryCode"}, method={RequestMethod.GET})
    public String recoveryCode() {
        String code = "";
        try {
            UUID idOne = UUID.randomUUID();
            code = "" + idOne;
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
        return code;
    }

    @RequestMapping(value={"/generate-update-recovery-code"}, method={RequestMethod.GET})
    public String generateUpdateRecoveryCode() {
        String code = "";
        try {
            UUID idOne = UUID.randomUUID();
            code = "" + idOne;
            if (code.endsWith("=")) {
                code = code.substring(0, code.length() - 1);
            }
            User savedUser = this.userRepository.findById(UserContextUtil.getUserContext().getLoggedInUser().getId());
            savedUser.setrecoveryMFACode(code);
            savedUser.setreckeyUpdatedDate(new Date());
            UserContextUtil.getUserContext().getLoggedInUser().setreckeyUpdatedDate(new Date());
            this.userRepository.save((Object)savedUser);
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
        return code;
    }

    @RequestMapping(value={"/verifymfacode"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> verifyMFACode(@RequestBody String MFA) {
        HashMap<String, Comparable<Boolean>> response = new HashMap<String, Comparable<Boolean>>();
        try {
            Gson gson = new Gson();
            UUID idOne = UUID.randomUUID();
            13 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap requestMap = (HashMap)gson.fromJson(MFA, T.getType());
            TwoFactorAuthUtil twoFactorAuthUtil = new TwoFactorAuthUtil();
            String mfaCode = twoFactorAuthUtil.generateCurrentNumber((String)requestMap.get("mfacodesec"));
            if (mfaCode.equals((String)requestMap.get("verifycode"))) {
                response.put("verify", Boolean.valueOf(true));
                response.put("recoveryKey", idOne);
            } else {
                response.put("verify", Boolean.valueOf(false));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ResponseEntity(response, HttpStatus.OK);
    }

    @RequestMapping(value={"/reset/mfa/{userId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> resetUserMFA(@PathVariable(value="userId") String userId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            User user = this.userRepository.findById(userId);
            if (PropertyValidator.isValid((Object)user)) {
                user.setRequireMFACode(false);
                user.setMfaCodeSec(null);
                user.setrecoveryMFACode(null);
                user.setreckeyUpdatedDate(new Date());
                this.userRepository.save((Object)user);
                responseJson.put("success", true);
            } else {
                responseJson.put("success", false);
                responseJson.put("msg", "User not found.");
            }
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception ex) {
            responseJson.put("error", true);
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/enableMFA"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> enableMFA() {
        String code = "";
        HashMap<String, String> qrAndScret = new HashMap<String, String>();
        try {
            TwoFactorAuthUtil twoFactorAuthUtil = new TwoFactorAuthUtil();
            String userName = UserContextUtil.getUserContext().getUsername();
            if (PropertyValidator.isValid((Object)userName)) {
                String base32Secret = twoFactorAuthUtil.generateBase32Secret();
                UUID idOne = UUID.randomUUID();
                code = "" + idOne;
                qrAndScret.put("qr", twoFactorAuthUtil.qrImageUrl(userName, base32Secret));
                qrAndScret.put("secret", base32Secret);
                qrAndScret.put("recoveryCode", code);
                return new ResponseEntity(qrAndScret, HttpStatus.OK);
            }
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
        return new ResponseEntity(qrAndScret, HttpStatus.OK);
    }

    @RequestMapping(value={"/disableMFA"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> disableMFA(@RequestBody HashMap<String, Object> user) {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        String id = String.valueOf(user.get("id"));
        User saveduser = this.userRepository.findById(id);
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        if (UserContextUtil.getUserContext().getLoggedInUser().getUserName().equals(saveduser.getUserName()) || UserContextUtil.getUserContext().getLoggedInUser().getIsAdmin().booleanValue()) {
            try {
                saveduser.setMfaCodeSec(null);
                saveduser.setRequireMFACode(false);
                saveduser.setforcedMFA(Boolean.valueOf(false));
                saveduser.setrecoveryMFACode(null);
                saveduser.setMfaDisableDate(new Date());
                this.userRepository.save((Object)saveduser);
                if (saveduser.getEmail().equals(UserContextUtil.getUserContext().getLoggedInUser().getEmail())) {
                    UserContextUtil.getUserContext().getLoggedInUser().setMfaCodeSec(saveduser.getMfaCodeSec());
                    UserContextUtil.getUserContext().getLoggedInUser().setRequireMFACode(saveduser.isRequireMFACode());
                    UserContextUtil.getUserContext().getLoggedInUser().setMfaDisableDate(new Date());
                }
                vars.put("createdDate", new Date());
                vars.put("email", saveduser.getEmail());
                this.localMailSender.sendMail(saveduser.getEmail(), "Two-factor authentication disabled for your Kendis account", "mfaDisable", vars, true);
                responseJson.put("success", true);
                return new ResponseEntity(responseJson, HttpStatus.OK);
            }
            catch (Exception ex) {
                LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            }
        }
        responseJson.put("success", false);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/closeAccount"}, method={RequestMethod.POST})
    public void closeAccount(@RequestBody String strData) {
        Map data = (Map)new Gson().fromJson(strData, Map.class);
        HashMap vars = new HashMap();
        vars.put("a", data.get("c-a"));
        vars.put("b", data.get("c-b"));
        vars.put("c", data.get("c-c"));
        vars.put("d", data.get("c-d"));
        vars.put("e", data.get("c-e"));
        vars.put("txt_reason", data.get("txt_reason"));
        vars.put("user", UserContextUtil.getUserContext().getLoggedInUser().getUserName());
        vars.put("urlPrefix", UserContextUtil.getUserContext().getCurrentCompany().getUrlPrefix());
        this.mailSender.sendMail("support@kendis.io", "close my kendis Account", "closeAccountMailTemplate", vars, true);
    }

    private void convertLdapUserToKendisGroupUser(Group group, HashMap<String, Object> response) {
        Gson gson = new Gson();
        14 T = new /* Unavailable Anonymous Inner Class!! */;
        Map unsaved = (Map)gson.fromJson(group.getUsersUnsaved(), T.getType());
        Set ids = unsaved.keySet();
        List<User> users = new ArrayList();
        ArrayList<UserCompany> userCompanies = new ArrayList<UserCompany>();
        UserCompany userCompany = new UserCompany();
        String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
        Company comp = this.companyRepository.findById(cid);
        userCompany.setCompany(comp);
        userCompany.setIsActive(Boolean.valueOf(true));
        userCompany.setIsOwner(Boolean.valueOf(false));
        userCompany.setIsAdmin(Boolean.valueOf(false));
        userCompany.setIsArchive(Boolean.valueOf(false));
        userCompanies.add(userCompany);
        if (!PropertyValidator.isValid((Collection)group.getUsers())) {
            group.setUsers(new HashSet());
        }
        HashSet<String> gps = new HashSet<String>();
        gps.add(group.getId());
        for (String id : ids) {
            Map ldapUser = (Map)unsaved.get(id);
            User savedUser = this.userRepository.findByUserName((String)ldapUser.get("userName"));
            if (!PropertyValidator.isValid((Object)savedUser)) {
                User user = new User(ldapUser);
                user.setUserCompanies(userCompanies);
                user.setPassword(UUID.randomUUID().toString());
                HashSet<String> perUserGroups = new HashSet<String>();
                perUserGroups.add(group.getId());
                if (PropertyValidator.isValid((Collection)user.getGroups())) {
                    perUserGroups.addAll(user.getGroups());
                }
                if (group.isForGuestUsers() && comp.isGuestEnabled()) {
                    LOGGER.debug("setting user as guest");
                    ((UserCompany)user.getUserCompanies().get(0)).setIsGuest(Boolean.valueOf(true));
                    user.setIsGuest(Boolean.valueOf(true));
                }
                user.setGroups(perUserGroups);
                users.add(user);
            }
            group.getUsers().remove(id);
        }
        users = this.userRepository.save(users);
        for (User user : users) {
            group.getUsers().add(user.getId());
        }
        response.put("groupLdapUsers", users);
    }

    private boolean isAnySeverityLinked(String id) {
        boolean exists = false;
        try {
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)"severity"));
            Fields svrField = (Fields)this.mongoTemplate.findOne(query, Fields.class);
            if (PropertyValidator.isValid((Object)svrField)) {
                query = new Query();
                query.addCriteria((CriteriaDefinition)Criteria.where((String)("fields." + svrField.getId() + ".id")).is((Object)id));
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").ne((Object)true));
                exists = this.mongoTemplate.exists(query, BaseItem.class);
            }
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
        return exists;
    }

    @RequestMapping(value={"/non-kendis-users"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getNonkendisUsers() {
        String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
        ArrayList<Integer> rowStatuses = new ArrayList<Integer>();
        rowStatuses.add(0);
        rowStatuses.add(-1);
        List users = this.userRepository.findByUserCompaniesAndArchiveAndTenantAndRowStatusIn(null, Boolean.valueOf(false), tenant, rowStatuses);
        return new ResponseEntity((Object)users, HttpStatus.OK);
    }

    @RequestMapping(value={"/nonkendisuser/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<Object> getNonkendisUser(@PathVariable(value="id") String uid) {
        User user = (User)this.userRepository.findOne((Serializable)((Object)uid));
        return new ResponseEntity((Object)user, HttpStatus.OK);
    }

    @RequestMapping(value={"save/nonkendisuser"}, method={RequestMethod.POST})
    public ResponseEntity<Object> saveNonkendisUser(@RequestBody User user) {
        if (user.getRowStatus() == 0) {
            user.setFullName(user.getFirstName() + " " + user.getLastName());
        }
        user = (User)this.userRepository.save((Object)user);
        return new ResponseEntity((Object)user, HttpStatus.OK);
    }

    @RequestMapping(value={"/create/apikey"})
    @ResponseBody
    public ResponseEntity<Object> createUserApiKey(@RequestBody Map<String, Object> params) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            int expiryDateSpan;
            Date expiresAt;
            String userApiKeyLabel;
            String apiKey;
            if (!this.validateApiInput(params.get("apiLabel"), params.get("expiresAt"))) {
                responseJson.put("success", false);
                responseJson.put("error", "Invalid input, please try again.");
                return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
            }
            SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            User loggedInUser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
            UserApiKey userApiKey = this.apiService.createUserAPIKey(loggedInUser, apiKey = this.apiService.generateAPIKey(), userApiKeyLabel = String.valueOf(params.get("apiLabel")), expiresAt = KendisUtils.convertStringToDayEndDate((String)((String)params.get("expiresAt"))), expiryDateSpan = KendisUtils.calculateDaysDifference((Date)expiresAt));
            if (!PropertyValidator.isValid((Object)userApiKey)) {
                responseJson.put("success", false);
                responseJson.put("error", "Failed to create user api key");
                return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
            }
            UserApiKey savedUserApiKey = (UserApiKey)this.userApiKeyRepository.save((Object)userApiKey);
            responseJson.put("apiKey", apiKey);
            responseJson.put("success", true);
            responseJson.put("userApiKey", savedUserApiKey);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            responseJson.put("success", false);
            responseJson.put("error", "Failed to create user api key");
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private boolean validateApiInput(Object idOrKey, Object expiresAtObj) {
        if (!PropertyValidator.isValid((Object)idOrKey) || !PropertyValidator.isValid((Object)expiresAtObj)) {
            return false;
        }
        Date expiresAt = KendisUtils.convertStringToDayEndDate((String)String.valueOf(expiresAtObj));
        return this.apiService.isValidExpireDate(expiresAt);
    }

    @RequestMapping(value={"{action}/apikey"})
    public ResponseEntity<Object> updateUserApiKey(@PathVariable(value="action") String action, @RequestBody Map<String, Object> params) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        List<String> actions = Arrays.asList("UPDATE", "REGENERATE", "REVOKE");
        try {
            boolean isValidAction = actions.contains(action.toUpperCase());
            if (!isValidAction) {
                responseJson.put("success", false);
                responseJson.put("error", "Invalid action, valid actions are: " + actions);
                return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
            }
            if ("UPDATE".equalsIgnoreCase(action) && !this.validateApiInput(params.get("id"), params.get("expiresAt"))) {
                responseJson.put("success", false);
                responseJson.put("error", "Invalid input");
                return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
            }
            String id = String.valueOf(params.get("id"));
            UserApiKey userApiKey = this.userApiKeyRepository.findById(id);
            if (!PropertyValidator.isValid((Object)userApiKey)) {
                responseJson.put("success", false);
                responseJson.put("error", "Invalid User api key ID");
                return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
            }
            if (userApiKey.isRevoked()) {
                responseJson.put("success", false);
                responseJson.put("error", "Cannot update a revoked API key");
                return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
            }
            if ("REGENERATE".equalsIgnoreCase(action)) {
                String apiKey = this.apiService.generateAPIKey();
                userApiKey.setApiKey(this.apiService.hashApiKey(apiKey));
                Date expiresAt = this.apiService.calculateNextExpiresAt(userApiKey.getExpiryDateSpan());
                userApiKey.setExpiresAt(expiresAt);
                responseJson.put("apiKey", apiKey);
            }
            if ("UPDATE".equalsIgnoreCase(action)) {
                Date expiresAt = KendisUtils.convertStringToDayEndDate((String)String.valueOf(params.get("expiresAt")));
                int expiryDateSpan = KendisUtils.calculateDaysDifference((Date)expiresAt);
                userApiKey.setExpiresAt(expiresAt);
                userApiKey.setExpiryDateSpan(expiryDateSpan);
            }
            if ("REVOKE".equalsIgnoreCase(action)) {
                userApiKey.setRevoked(true);
            }
            this.userApiKeyRepository.save((Object)userApiKey);
            responseJson.put("success", true);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            responseJson.put("success", false);
            responseJson.put("error", "Failed to " + action + " user api key");
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

