/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.config.interceptor;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.viztrend.safe.persistence.entity.Company;
import com.viztrend.safe.persistence.entity.PaymentPackageConfig;
import com.viztrend.safe.persistence.entity.ServerCache;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.UserApiKey;
import com.viztrend.safe.persistence.entity.dto.UserContextDTO;
import com.viztrend.safe.persistence.repository.ServerCacheRepository;
import com.viztrend.safe.persistence.repository.UserRepository;
import com.viztrend.safe.service.APIService;
import com.viztrend.safe.service.UserService;
import com.viztrend.safe.utils.DBUtils;
import com.viztrend.safe.utils.KendisUtils;
import com.viztrend.safe.utils.PropertyValidator;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class PublicPathInterceptor
extends HandlerInterceptorAdapter {
    @Autowired
    private ServerCacheRepository serverCacheRepository;
    private final APIService apiService;
    private final UserRepository userRepository;
    private final UserService userService;
    private final MongoTemplate mongoTemplate;

    public PublicPathInterceptor(ServerCacheRepository serverCacheRepository, APIService apiService, MongoTemplate mongoTemplate, UserRepository userRepository, UserService userService) {
        this.serverCacheRepository = serverCacheRepository;
        this.apiService = apiService;
        this.mongoTemplate = mongoTemplate;
        this.userRepository = userRepository;
        this.userService = userService;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (request.getRequestURI().contains("/pijourney/public_share")) {
            String token = request.getParameter("token");
            if (this.tokenChecker(token).booleanValue()) {
                return true;
            }
            response.sendRedirect("/unAuthorized");
            return false;
        }
        if (request.getRequestURI().contains("/graphx/public_share")) {
            String token = request.getParameter("token");
            if (this.tokenChecker(token).booleanValue()) {
                return true;
            }
            response.sendRedirect("/unAuthorized");
            return false;
        }
        if (request.getRequestURI().startsWith("/api/") && !request.getMethod().equalsIgnoreCase("OPTIONS")) {
            UserApiKey userApiKey;
            String[] parts;
            String companyPrefix = null;
            if (request.getServerName().endsWith("kendis.io") && (parts = request.getServerName().split("\\.")).length > 0 && !"rest".equals(parts[0])) {
                companyPrefix = parts[0];
            }
            if (!PropertyValidator.isValid((Object)(userApiKey = this.apiService.getUserFromRequest(request)))) {
                this.sendErrorResponse(response, 401, "Invalid API Key or UserID");
                return false;
            }
            if (userApiKey.isRevoked()) {
                this.sendErrorResponse(response, 401, "API key is revoked");
                return false;
            }
            String[] requestUriParts = request.getRequestURI().split("/");
            if (requestUriParts.length < 3) {
                this.sendErrorResponse(response, 400, "Invalid API URL.");
                return false;
            }
            if (PropertyValidator.isValid((Object)request.getHeader("prefix"))) {
                companyPrefix = request.getHeader("prefix");
            }
            if (companyPrefix == null) {
                companyPrefix = requestUriParts[2];
            }
            User user = this.userRepository.findById(userApiKey.getUserId());
            Company apiCompany = this.findCompanyByUrlPrefix(companyPrefix);
            if (!PropertyValidator.isValid((Object)apiCompany) || !apiCompany.getTenant().equals(userApiKey.getTenant())) {
                this.sendErrorResponse(response, 404, "Invalid company prefix in URL.");
                return false;
            }
            if (!this.userService.isPremiumPackageUser(user, apiCompany)) {
                this.sendErrorResponse(response, 401, "API feature is only available for premium packages.");
                return false;
            }
            Date expiryDate = userApiKey.getExpiresAt();
            if (expiryDate != null && expiryDate.before(new Date())) {
                this.sendErrorResponse(response, 401, "API key has expired");
                return false;
            }
            if (userApiKey.getDailyLimit() == 0) {
                this.sendErrorResponse(response, 429, "Daily limit reached.");
                return false;
            }
            HashMap<String, String> userApiContext = new HashMap<String, String>();
            userApiContext.put("apiKeyTenant", userApiKey.getTenant());
            userApiContext.put("apiKeyCompanyId", apiCompany.getId());
            userApiContext.put("apiKeyUsername", user.getUserName());
            UserContextDTO.setInLocalThread(userApiContext);
            AnonymousAuthenticationToken auth = new AnonymousAuthenticationToken("systemKey", (Object)"apiUser", Collections.singletonList(new SimpleGrantedAuthority("ROLE_API")));
            SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
            return true;
        }
        return true;
    }

    public Boolean tokenChecker(String token) {
        ServerCache serverCache = this.serverCacheRepository.findByKey(token);
        if (serverCache != null) {
            return true;
        }
        return false;
    }

    private void sendErrorResponse(HttpServletResponse response, int status, String message) throws IOException {
        response.setStatus(status);
        response.setContentType("application/json");
        PrintWriter writer = response.getWriter();
        writer.write("{\"error\": \"" + message + "\"}");
        writer.flush();
    }

    private Company findCompanyByUrlPrefix(String urlPrefix) {
        if (!PropertyValidator.isValid((Object)urlPrefix)) {
            return null;
        }
        Company company = null;
        try {
            BasicDBObject query = new BasicDBObject("urlPrefix", (Object)urlPrefix).append("archive", (Object)false);
            DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(Company.class));
            BasicDBObject companyDbObj = (BasicDBObject)collection.findOne((DBObject)query);
            if (companyDbObj != null) {
                company = new Company(DBUtils.getIdFromDBObject((BasicDBObject)companyDbObj, (String[])new String[0]));
                company.setTenant(companyDbObj.getString("tenant"));
                if (companyDbObj.containsField("paymentPackageConfig")) {
                    BasicDBObject paymentPackageConfigObj = (BasicDBObject)companyDbObj.get("paymentPackageConfig");
                    PaymentPackageConfig paymentPackageConfig = new PaymentPackageConfig();
                    paymentPackageConfig.setSAML(Boolean.valueOf(paymentPackageConfigObj.getBoolean("SAML")));
                    paymentPackageConfig.setLiveChat(Boolean.valueOf(paymentPackageConfigObj.getBoolean("liveChat")));
                    paymentPackageConfig.setoAuth(Boolean.valueOf(paymentPackageConfigObj.getBoolean("oAuth")));
                    paymentPackageConfig.setSecurity(Boolean.valueOf(paymentPackageConfigObj.getBoolean("security")));
                    paymentPackageConfig.setSolutionBoard(Boolean.valueOf(paymentPackageConfigObj.getBoolean("solutionBoard")));
                    company.setPaymentPackageConfig(paymentPackageConfig);
                }
            }
        }
        catch (Exception ex) {
            return null;
        }
        return company;
    }
}

