/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.config.interceptor;

import com.google.gson.Gson;
import com.viztrend.safe.annotations.GenerateLog;
import com.viztrend.safe.config.interceptor.EntityChangedLogger;
import com.viztrend.safe.persistence.entity.BaseEntity;
import com.viztrend.safe.persistence.entity.Container;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.ItemLog;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.TeamContainer;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.dto.SecureUser;
import com.viztrend.safe.persistence.repository.CustomRepositoryImpl;
import com.viztrend.safe.persistence.repository.ItemRepository;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.ConfigurablePropertyAccessor;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.mapping.event.AfterConvertEvent;
import org.springframework.data.mongodb.core.mapping.event.AfterDeleteEvent;
import org.springframework.data.mongodb.core.mapping.event.AfterLoadEvent;
import org.springframework.data.mongodb.core.mapping.event.AfterSaveEvent;
import org.springframework.data.mongodb.core.mapping.event.BeforeConvertEvent;
import org.springframework.data.mongodb.core.mapping.event.BeforeDeleteEvent;
import org.springframework.data.mongodb.core.mapping.event.BeforeSaveEvent;
import org.springframework.data.mongodb.core.mapping.event.LoggingEventListener;
import org.springframework.data.mongodb.core.mapping.event.MongoMappingEvent;
import org.springframework.scheduling.annotation.Async;
import org.springframework.security.core.context.SecurityContextHolder;

public class EntityInterceptor
extends LoggingEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityInterceptor.class);
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private Gson gson;
    @Autowired
    private CustomRepositoryImpl<?> customRepositoryImpl;
    @Autowired
    private ItemRepository itemRepository;
    @Autowired
    private ApplicationContext applicationContext;

    public void onApplicationEvent(MongoMappingEvent<?> event) {
        if ((event.getSource().getClass().isAnnotationPresent(GenerateLog.class) || event.getClass().getSimpleName().contains("Delete")) && PropertyAccessorFactory.forDirectFieldAccess((Object)event.getSource()).isWritableProperty("suspendActivity") && PropertyAccessorFactory.forDirectFieldAccess((Object)event.getSource()).getPropertyValue("suspendActivity").equals(false)) {
            super.onApplicationEvent(event);
        }
    }

    public void onBeforeConvert(BeforeConvertEvent<Object> event) {
        super.onBeforeConvert(event);
    }

    public void onBeforeSave(BeforeSaveEvent<Object> event) {
        this.setItemOldState(event.getSource(), null);
        if (event.getSource() instanceof Item) {
            String compositId = this.getCompositeJiraKey((Item)event.getSource());
            event.getDBObject().put("compositeJiraKey", (Object)compositId);
        }
        super.onBeforeSave(event);
    }

    @Async
    public void onAfterSave(AfterSaveEvent<Object> event) {
        ItemLog itemLog = new ItemLog();
        SecureUser secureUser = null;
        try {
            if (event.getSource() instanceof Item) {
                Item item = (Item)event.getSource();
                Object oldState = item.getOldSate();
                new Thread(() -> {
                    Item dbItem = this.itemRepository.findById(item.getId());
                    if (PropertyValidator.isValid((Object)dbItem) && PropertyValidator.isValid((Object)dbItem.getParent())) {
                        boolean isSprintChanged = this.isSprintChanged(dbItem, (Item)oldState);
                        boolean isNewJiraTfsItem = this.isNewAlmItem(dbItem, (Item)oldState);
                        if (isSprintChanged && !isNewJiraTfsItem) {
                            this.customRepositoryImpl.addAuditLogEntryInActiveSprintForSingleItem(dbItem);
                        }
                    }
                }).start();
            }
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
        if (SecurityContextHolder.getContext().getAuthentication() != null && SecurityContextHolder.getContext().getAuthentication().getPrincipal() instanceof SecureUser) {
            secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            itemLog.setActivityBy(((User)secureUser.getUserContextDTO().getContextMap().get("user")).getFullName());
        }
        EntityChangedLogger entityChangedLogger = new EntityChangedLogger(event.getSource(), new Date(), "save", this.gson, itemLog, this.applicationContext);
        Thread t = new Thread((Runnable)entityChangedLogger);
        t.start();
        super.onAfterSave(event);
    }

    public void onAfterLoad(AfterLoadEvent<Object> event) {
        super.onAfterLoad(event);
    }

    public void onAfterConvert(AfterConvertEvent<Object> event) {
        super.onAfterConvert(event);
    }

    public void onAfterDelete(AfterDeleteEvent<Object> event) {
        if (event.getType().isAnnotationPresent(GenerateLog.class)) {
            String id = event.getDBObject().get("id").toString();
            BaseEntity baseEntity = new BaseEntity();
            baseEntity.setId(id);
            baseEntity.setEventType("delete");
            SecureUser secureUser = null;
            if (SecurityContextHolder.getContext().getAuthentication() != null) {
                secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            }
            ItemLog itemLog = new ItemLog();
            itemLog.setActivityBy(((User)secureUser.getUserContextDTO().getContextMap().get("user")).getFullName());
            EntityChangedLogger entityChangedLogger = new EntityChangedLogger((Object)baseEntity, new Date(), "delete", this.gson, itemLog, this.applicationContext);
            Thread t = new Thread((Runnable)entityChangedLogger);
            t.start();
        }
        super.onAfterDelete(event);
    }

    public void onBeforeDelete(BeforeDeleteEvent<Object> event) {
        super.onBeforeDelete(event);
    }

    private void setItemOldState(Object source, String eventType) {
        Object baseEntity = source;
        ConfigurablePropertyAccessor pa = PropertyAccessorFactory.forDirectFieldAccess((Object)baseEntity);
        String entityId = (String)pa.getPropertyValue("id");
        if (entityId != null) {
            Object oldObj = this.mongoTemplate.findById((Object)entityId, baseEntity.getClass());
            pa.setPropertyValue("oldSate", oldObj);
            if (eventType != null) {
                pa.setPropertyValue("eventType", (Object)eventType);
            } else {
                pa.setPropertyValue("eventType", (Object)"update");
            }
        } else {
            pa.setPropertyValue("eventType", (Object)"save");
        }
    }

    private boolean isNewAlmItem(Item item, Item oldState) {
        if (PropertyValidator.isValid((Object)item) && !PropertyValidator.isValid((Object)oldState) && PropertyValidator.isValid((Collection)item.getTeamContainers())) {
            if (PropertyValidator.isValid((Object)item.getJiraProjectKey()) && !PropertyValidator.isValid((Object)item.getJiraKey())) {
                return true;
            }
            if (PropertyValidator.isValid((Object)item.getTfsProject()) && !PropertyValidator.isValid((Object)item.getTfsId())) {
                return true;
            }
        }
        return false;
    }

    private boolean isSprintChanged(Item item, Item oldState) {
        if (PropertyValidator.isValid((Object)item) && !PropertyValidator.isValid((Object)oldState) && PropertyValidator.isValid((Collection)item.getTeamContainers())) {
            return true;
        }
        if (PropertyValidator.isValid((Object)item) && PropertyValidator.isValid((Object)oldState)) {
            List itemTeamContainers = item.getTeamContainers();
            List oldStateTeamContainers = oldState.getTeamContainers();
            Container itemContainer = null;
            Container oldStateContainer = null;
            if (PropertyValidator.isValid((Collection)itemTeamContainers)) {
                itemContainer = ((TeamContainer)itemTeamContainers.get(0)).getContainer();
            }
            if (PropertyValidator.isValid((Collection)oldStateTeamContainers)) {
                oldStateContainer = ((TeamContainer)oldStateTeamContainers.get(0)).getContainer();
            }
            if (PropertyValidator.isValid(itemContainer) && !PropertyValidator.isValid(oldStateContainer) || !PropertyValidator.isValid((Object)itemContainer) && PropertyValidator.isValid((Object)oldStateContainer)) {
                return true;
            }
            if (PropertyValidator.isValid((Object)itemContainer) && PropertyValidator.isValid((Object)oldStateContainer)) {
                return !itemContainer.getId().equals(oldStateContainer.getId());
            }
        }
        return false;
    }

    public String getCompositeJiraKey(Item item) {
        if (PropertyValidator.isValid((Collection)item.getSessionBoards()) && PropertyValidator.isValid(item.getSessionBoards().get(0)) && PropertyValidator.isValid((Object)item.getParent()) && PropertyValidator.isValid((Object)item.getParent().getId()) && PropertyValidator.isValid((Object)item.getJiraId())) {
            return ((SessionBoard)item.getSessionBoards().get(0)).getId() + "-" + item.getParent().getId() + "-" + item.getJiraId();
        }
        if (PropertyValidator.isValid((Collection)item.getSessionBoards()) && PropertyValidator.isValid(item.getSessionBoards().get(0)) && PropertyValidator.isValid((Object)item.getJiraId()) && (!PropertyValidator.isValid((Object)item.getParent()) || !PropertyValidator.isValid((Object)item.getParent().getId()))) {
            return ((SessionBoard)item.getSessionBoards().get(0)).getId() + "-" + item.getJiraId();
        }
        return null;
    }
}

