/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.config.interceptor;

import com.google.gson.Gson;
import com.viztrend.safe.annotations.GenerateLog;
import com.viztrend.safe.config.interceptor.BacklogItemChangeLogger;
import com.viztrend.safe.persistence.entity.BacklogItem;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.ConfigurablePropertyAccessor;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.mapping.event.AbstractMongoEventListener;
import org.springframework.data.mongodb.core.mapping.event.AfterConvertEvent;
import org.springframework.data.mongodb.core.mapping.event.AfterDeleteEvent;
import org.springframework.data.mongodb.core.mapping.event.AfterLoadEvent;
import org.springframework.data.mongodb.core.mapping.event.AfterSaveEvent;
import org.springframework.data.mongodb.core.mapping.event.BeforeConvertEvent;
import org.springframework.data.mongodb.core.mapping.event.BeforeDeleteEvent;
import org.springframework.data.mongodb.core.mapping.event.BeforeSaveEvent;
import org.springframework.data.mongodb.core.mapping.event.MongoMappingEvent;
import org.springframework.scheduling.annotation.Async;

public class BacklogItemInterceptor
extends AbstractMongoEventListener<BacklogItem> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BacklogItemInterceptor.class);
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private Gson gson;
    @Autowired
    private ApplicationContext applicationContext;

    public void onApplicationEvent(MongoMappingEvent<?> event) {
        if ((event.getSource().getClass().isAnnotationPresent(GenerateLog.class) || event.getClass().getSimpleName().contains("Delete")) && PropertyAccessorFactory.forDirectFieldAccess((Object)event.getSource()).isWritableProperty("suspendActivity") && PropertyAccessorFactory.forDirectFieldAccess((Object)event.getSource()).getPropertyValue("suspendActivity").equals(false)) {
            super.onApplicationEvent(event);
        }
    }

    public void onBeforeConvert(BeforeConvertEvent<BacklogItem> event) {
        super.onBeforeConvert(event);
    }

    public void onBeforeSave(BeforeSaveEvent<BacklogItem> event) {
        this.setItemOldState(event.getSource(), null);
        super.onBeforeSave(event);
    }

    @Async
    public void onAfterSave(AfterSaveEvent<BacklogItem> event) {
        ConfigurablePropertyAccessor pa = PropertyAccessorFactory.forDirectFieldAccess((Object)event.getSource());
        Object oldState = pa.getPropertyValue("oldState");
        pa.setPropertyValue("oldState", null);
        BacklogItemChangeLogger entityChangedLogger = new BacklogItemChangeLogger(event.getSource(), new Date(), "save", this.gson, this.applicationContext, oldState);
        Thread t = new Thread((Runnable)entityChangedLogger);
        t.start();
        super.onAfterSave(event);
    }

    public void onAfterLoad(AfterLoadEvent<BacklogItem> event) {
        super.onAfterLoad(event);
    }

    public void onAfterConvert(AfterConvertEvent<BacklogItem> event) {
        super.onAfterConvert(event);
    }

    public void onAfterDelete(AfterDeleteEvent<BacklogItem> event) {
    }

    public void onBeforeDelete(BeforeDeleteEvent<BacklogItem> event) {
    }

    private void setItemOldState(Object source, String eventType) {
        Object baseEntity = source;
        ConfigurablePropertyAccessor pa = PropertyAccessorFactory.forDirectFieldAccess((Object)baseEntity);
        String entityId = (String)pa.getPropertyValue("id");
        if (entityId != null) {
            Object oldObj = this.mongoTemplate.findById((Object)entityId, baseEntity.getClass());
            pa.setPropertyValue("oldState", oldObj);
            if (eventType != null) {
                pa.setPropertyValue("eventType", (Object)eventType);
            } else {
                pa.setPropertyValue("eventType", (Object)"update");
            }
        } else {
            pa.setPropertyValue("eventType", (Object)"save");
        }
    }
}

