/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.config.filter;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.util.NestedServletException;

@Component
public class ThrottleFilter
implements Filter,
Runnable {
    private static Logger log = LoggerFactory.getLogger(ThrottleFilter.class);
    private Map<String, Integer> ip2countCache = new ConcurrentHashMap();
    private Set<String> blackList = new HashSet();
    private int maxConcurrentRequests = 500;
    private int releaseRequestCount = 50;
    private static final long PERIOD = 2L;
    private boolean enable = true;

    public ThrottleFilter() {
        ThrottleFilter runable = new ThrottleFilter(this);
        Thread t = new Thread((Runnable)runable);
        t.start();
    }

    public ThrottleFilter(ThrottleFilter t) {
        this.ip2countCache = t.ip2countCache;
        this.blackList = t.blackList;
        this.maxConcurrentRequests = t.maxConcurrentRequests;
        this.enable = t.enable;
        this.releaseRequestCount = t.releaseRequestCount;
    }

    public void init(FilterConfig config) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain nextFilter) throws ServletException, IOException {
        block12: {
            try {
                HttpServletRequest httpReq = (HttpServletRequest)request;
                HttpServletResponse httpServletResponse = (HttpServletResponse)response;
                if (!httpReq.getRequestURI().startsWith(httpReq.getContextPath() + "/assets") && this.enable) {
                    boolean isOverflow;
                    String ip = ((HttpServletRequest)request).getHeader("X-Forwarded-For");
                    if (ip == null || ip == "null") {
                        nextFilter.doFilter(request, (ServletResponse)httpServletResponse);
                        return;
                    }
                    ThrottleFilter throttleFilter = this;
                    synchronized (throttleFilter) {
                        Integer count = 0;
                        if (this.ip2countCache != null && this.ip2countCache.size() > 0) {
                            count = (Integer)this.ip2countCache.get(ip);
                        }
                        if (count == null || count == 0) {
                            count = 0;
                        }
                        if (count < this.maxConcurrentRequests) {
                            isOverflow = false;
                            this.ip2countCache.put(ip, count + 1);
                        } else {
                            isOverflow = true;
                            this.blackList.add(ip);
                        }
                    }
                    if (isOverflow) {
                        return;
                    }
                }
                nextFilter.doFilter(request, (ServletResponse)httpServletResponse);
            }
            catch (NestedServletException e) {
                if (!(e.getRootCause() instanceof MaxUploadSizeExceededException)) break block12;
                response.reset();
                ((HttpServletResponse)response).setHeader("Content-Type", "application/json;charset=UTF-8");
                ((HttpServletResponse)response).setStatus(413);
                response.getWriter().write("error");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(fixedRate=2000L)
    public void throttlingJob() {
        if (this.enable) {
            ThrottleFilter throttleFilter = this;
            synchronized (throttleFilter) {
                for (Map.Entry ip2count : this.ip2countCache.entrySet()) {
                    Integer count = (Integer)ip2count.getValue();
                    String ip = (String)ip2count.getKey();
                    if (count == null || count <= 1) {
                        this.ip2countCache.remove(ip);
                        continue;
                    }
                    if (count == this.maxConcurrentRequests) {
                        log.info("Throttle Filter: removing {} from black list", (Object)ip);
                        this.blackList.remove(ip);
                    }
                    this.ip2countCache.put(ip, count - this.releaseRequestCount);
                }
            }
        }
    }

    public void destroy() {
        log.warn("destorying Throttle Filter");
    }

    public Set<String> getBlackList() {
        return Collections.unmodifiableSet(this.blackList);
    }

    @Override
    public void run() {
    }
}

