/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.config;

import io.swagger.models.auth.In;
import java.io.IOException;
import java.net.URISyntaxException;
import java.time.temporal.Temporal;
import java.util.Arrays;
import java.util.List;
import org.springframework.context.annotation.Bean;
import org.springframework.web.bind.annotation.RequestMethod;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.builders.ResponseMessageBuilder;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.ApiKey;
import springfox.documentation.service.ResponseMessage;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;

public class SwaggerConfig {
    @Bean
    public Docket api() throws IOException, URISyntaxException {
        List<ResponseMessage> globalResponses = Arrays.asList(new ResponseMessageBuilder().code(200).message("OK").build(), new ResponseMessageBuilder().code(400).message("Bad Request").build(), new ResponseMessageBuilder().code(500).message("Internal Error").build());
        return new Docket(DocumentationType.SWAGGER_2).securitySchemes(Arrays.asList(new ApiKey("Basic Auth: base64(email:apiKey)", "Authorization", In.HEADER.name()))).useDefaultResponseMessages(false).globalResponseMessage(RequestMethod.GET, globalResponses).globalResponseMessage(RequestMethod.POST, globalResponses).globalResponseMessage(RequestMethod.DELETE, globalResponses).globalResponseMessage(RequestMethod.PATCH, globalResponses).select().apis(RequestHandlerSelectors.basePackage((String)"com.viztrend.safe.controller.api")).build().apiInfo(this.apiInfo()).directModelSubstitute(Temporal.class, String.class);
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().title("Kendis API Documentation").description("API documentation for Kendis Risk Management, Objectives, and Board Items.\n\n**Authentication:** All endpoints require Basic Authentication with email and API key.\nFormat: `Authorization: Basic base64(email:apiKey)`\n\n**Example:**\n1. Combine your email and API key: `user@example.com:your-api-key`\n2. Base64 encode the combined string\n3. Add to Authorization header: `Basic <encoded_value>`\n\nGet your API key from your user profile in Kendis.").version("1.0").build();
    }
}

