/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.config;

import com.viztrend.safe.config.AppConfig;
import com.viztrend.safe.service.PushRmiService;
import com.viztrend.safe.service.PushRmiServiceImpl;
import javax.annotation.PostConstruct;
import javax.servlet.MultipartConfigElement;
import org.apache.catalina.connector.Connector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.embedded.EmbeddedServletContainerFactory;
import org.springframework.boot.web.servlet.MultipartConfigFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.remoting.rmi.RmiServiceExporter;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.web.client.RestTemplate;

@Configuration
@EnableAsync
public class AppConfig {
    @Autowired
    private Environment env;
    private boolean isLocalDeployment = false;
    private String domain;
    private String appEnv;
    private static final Logger LOGGER = LoggerFactory.getLogger(AppConfig.class);
    private static final Logger LOGGERQUERY = LoggerFactory.getLogger((String)"dbquery");

    @Bean
    public RestTemplate restTemplate() {
        return new RestTemplate();
    }

    @PostConstruct
    public void postConstruct() {
        this.isLocalDeployment = this.env.getProperty("isLocalDeployment").equals("true");
        this.domain = this.env.getProperty("server.domain");
        this.appEnv = this.env.getProperty("app.env");
    }

    @Bean
    RmiServiceExporter exporter(PushRmiServiceImpl implementation) {
        if (!this.env.getProperty("isLocalDeployment").equals("true")) {
            Class<PushRmiService> serviceInterface = PushRmiService.class;
            RmiServiceExporter exporter = new RmiServiceExporter();
            exporter.setServiceInterface(serviceInterface);
            exporter.setService((Object)implementation);
            exporter.setServiceName(serviceInterface.getSimpleName());
            exporter.setRegistryPort(1099);
            return exporter;
        }
        return null;
    }

    @ConditionalOnProperty(matchIfMissing=false, name={"server.ssl.keyStore"})
    @Bean
    public EmbeddedServletContainerFactory servletContainer() {
        1 tomcat = new /* Unavailable Anonymous Inner Class!! */;
        tomcat.addAdditionalTomcatConnectors(new Connector[]{this.createHttpConnector()});
        return tomcat;
    }

    @ConditionalOnProperty(matchIfMissing=false, name={"redirect.from.http.server.port"})
    private Connector createHttpConnector() {
        Connector connector = new Connector("org.apache.coyote.http11.Http11NioProtocol");
        connector.setScheme("http");
        connector.setSecure(false);
        connector.setPort(Integer.parseInt(this.env.getProperty("redirect.from.http.server.port").toString()));
        connector.setRedirectPort(Integer.parseInt(this.env.getProperty("server.port").toString()));
        return connector;
    }

    @Bean
    public MultipartConfigElement multipartConfigElement() {
        MultipartConfigFactory factory = new MultipartConfigFactory();
        factory.setMaxFileSize("10MB");
        factory.setMaxRequestSize("10MB");
        return factory.createMultipartConfig();
    }

    public static void main(String[] args) {
        try {
            Class.forName("com.github.luben.zstd.ZstdInputStream");
            System.out.println("ZstdInputStream loaded");
        }
        catch (ClassNotFoundException e) {
            System.err.println("Class not found: " + e.getMessage());
        }
    }

    static /* synthetic */ Environment access$000(AppConfig x0) {
        return x0.env;
    }

    static /* synthetic */ boolean access$100(AppConfig x0) {
        return x0.isLocalDeployment;
    }

    static /* synthetic */ Logger access$200() {
        return LOGGER;
    }

    static /* synthetic */ String access$300(AppConfig x0) {
        return x0.appEnv;
    }

    static /* synthetic */ String access$400(AppConfig x0) {
        return x0.domain;
    }
}

