/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.change.stream.utils;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.MongoCommandException;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.changestream.ChangeStreamDocument;
import com.viztrend.safe.ReadDbPropertiesPostInit;
import com.viztrend.safe.change.stream.dao.ResumeTokenRepository;
import com.viztrend.safe.change.stream.model.ChangeStreamOldState;
import com.viztrend.safe.change.stream.model.ResumeToken;
import com.viztrend.safe.persistence.entity.ActiveNode;
import com.viztrend.safe.persistence.entity.AppInitConfig;
import com.viztrend.safe.persistence.repository.ActiveNodeRepository;
import com.viztrend.safe.persistence.repository.AppInitConfigRepository;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
public class ServiceUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceUtils.class);

    public static boolean isValidObjectId(String str) {
        if (str == null || str.length() != 24) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') continue;
            return false;
        }
        return true;
    }

    public static String getTimeSeriesCollectionName(ChangeStreamOldState.COLLECTION_NAME collectionName) {
        String timeSeriesCollectionName = collectionName.name();
        return timeSeriesCollectionName + "TimeSeries";
    }

    public static void createTimeSeriesCollectionIfNotExists(String collectionName, MongoDatabase db) {
        boolean collectionExists = ((ArrayList)db.listCollectionNames().into(new ArrayList())).contains(collectionName);
        if (!collectionExists) {
            Document command = new Document("create", (Object)collectionName).append("timeseries", (Object)new Document("timeField", (Object)"eventTime").append("metaField", (Object)"meta"));
            db.runCommand((Bson)command);
            LOGGER.info("Created time-series collection: {}", (Object)collectionName);
        } else {
            LOGGER.info("Collection already exists: {}", (Object)collectionName);
        }
    }

    public static void createIndexForTimeSeriesCollections(MongoTemplate mongoTemplate) {
        try {
            List indexList = ServiceUtils.readIndexFile();
            indexList.forEach(indexMap -> {
                try {
                    mongoTemplate.getDb().getCollection(indexMap.get("collection").toString()).createIndex((DBObject)((BasicDBObject)indexMap.get("index_attrib")));
                }
                catch (Exception ex) {
                    LOGGER.error(ex.getMessage());
                }
            });
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
    }

    private static List<Map<String, Object>> readIndexFile() throws JsonSyntaxException, IOException {
        String line;
        InputStream inputStream = ServiceUtils.class.getResourceAsStream("/timeseries_index/index.json");
        if (inputStream == null) {
            return new LinkedList<Map<String, Object>>();
        }
        InputStreamReader streamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        BufferedReader reader = new BufferedReader(streamReader);
        LinkedList<Map<String, Object>> indexList = new LinkedList<Map<String, Object>>();
        Type mapType = new /* Unavailable Anonymous Inner Class!! */.getType();
        Gson gson = new Gson();
        while ((line = reader.readLine()) != null) {
            Map map = (Map)gson.fromJson(line, mapType);
            Map map2 = (Map)map.get("key");
            BasicDBObject indexOptions = new BasicDBObject();
            HashMap indexFileMap = new HashMap();
            map2.keySet().forEach(arg_0 -> ServiceUtils.lambda$readIndexFile$1((DBObject)indexOptions, arg_0));
            indexFileMap.put("collection", map.get("collection"));
            indexFileMap.put("index_attrib", indexOptions);
            indexList.add(indexFileMap);
        }
        return indexList;
    }

    public static MongoCursor<ChangeStreamDocument<Document>> getChangeStreamCursor(MongoCollection<Document> collection, ResumeToken resumeTokenObj, ChangeStreamOldState.COLLECTION_NAME collectionName, ResumeTokenRepository resumeTokenRepository) {
        if (collection == null) {
            throw new IllegalArgumentException("collection is null");
        }
        MongoCursor cursor = null;
        boolean isResumeTokenInvalid = false;
        try {
            if (resumeTokenObj.getResumeToken() != null) {
                LOGGER.info("{}: Resuming change stream using resume token.", (Object)collection.getNamespace().getCollectionName());
                cursor = collection.watch().resumeAfter(resumeTokenObj.getResumeToken()).iterator();
            }
        }
        catch (MongoCommandException e) {
            if (e.getErrorCode() == 286) {
                LOGGER.warn("{}: ChangeStreamHistoryLost - Resume token is no longer valid. Resetting token and starting a fresh stream.", (Object)collection.getNamespace().getCollectionName());
                isResumeTokenInvalid = true;
            } else {
                LOGGER.error("Unexpected error resuming change stream with token. Starting fresh stream.", (Throwable)e);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to resume change stream with token. Discarding the old token and starting a fresh stream.", (Throwable)e);
        }
        if (cursor == null || isResumeTokenInvalid) {
            LOGGER.info("{}: Starting fresh change stream without resume token.", (Object)collection.getNamespace().getCollectionName());
            cursor = collection.watch().iterator();
            if (isResumeTokenInvalid) {
                ResumeToken freshToken = ServiceUtils.createValidResumeToken((ChangeStreamOldState.COLLECTION_NAME)collectionName);
                freshToken.setId(resumeTokenObj.getId());
                resumeTokenRepository.save((Object)freshToken);
            }
        }
        return cursor;
    }

    public static ResumeToken createValidResumeToken(ChangeStreamOldState.COLLECTION_NAME collectionName) {
        ResumeToken resumeTokenObj = new ResumeToken();
        resumeTokenObj = new ResumeToken();
        resumeTokenObj.setCollectionName(collectionName.name());
        resumeTokenObj.setUpdatedAt(new Date());
        return resumeTokenObj;
    }

    public static boolean isUnderProcessByNode(AppInitConfigRepository appInitConfigRepository, ActiveNodeRepository activeNodeRepository) {
        try {
            AppInitConfig appInitConfig;
            if (PropertyValidator.isValid((Collection)appInitConfigRepository.findAll()) && (appInitConfig = (AppInitConfig)appInitConfigRepository.findAll().get(0)).isEnableMultiNode()) {
                List activeNodes = activeNodeRepository.findAll();
                if (PropertyValidator.isValid((Collection)activeNodes)) {
                    activeNodes.sort(Comparator.comparingLong(ActiveNode::getCreatedAt));
                    return !((ActiveNode)activeNodes.get(0)).getNodeId().equals(ReadDbPropertiesPostInit.nodeId);
                }
                LOGGER.debug("No Node available for Primary selection ");
                return true;
            }
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
        return false;
    }

    public static String getTenantFromOldState(ChangeStreamOldState oldState) {
        if (!PropertyValidator.isValid((Object)oldState)) {
            return null;
        }
        Type mapType = new /* Unavailable Anonymous Inner Class!! */.getType();
        Gson gson = new Gson();
        String newStateJson = gson.toJson(oldState.getBeforeUpdate());
        Map oldStateMap = (Map)gson.fromJson(newStateJson, mapType);
        return oldStateMap.get("tenant") != null ? oldStateMap.get("tenant").toString() : null;
    }

    public static boolean isValidJson(String jsonString) {
        try {
            new JSONObject(jsonString);
            return true;
        }
        catch (JSONException e) {
            try {
                new JSONArray(jsonString);
                return true;
            }
            catch (JSONException ex) {
                LOGGER.info("Invalid Json Object ,Method: isValidJson: Field: JsonString: " + jsonString);
                return false;
            }
        }
    }

    private static /* synthetic */ void lambda$readIndexFile$1(DBObject indexOptions, String key) {
        indexOptions.put(key, (Object)1);
    }
}

