/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.change.stream.service.logger;

import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.viztrend.safe.change.stream.service.logger.AbstractCFDLogger;
import com.viztrend.safe.persistence.entity.TimeSeriesLog;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
public class BaseItemCFDLogger
extends AbstractCFDLogger {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseItemCFDLogger.class);
    private final TimeSeriesLog baseItemHistory;
    private final Type mapType = new /* Unavailable Anonymous Inner Class!! */.getType();

    public BaseItemCFDLogger(Object item, Date eventTime, Object oldState, MongoTemplate mongoTemplate, String tenant, String timeSeriesCollectionName) {
        super(item, oldState, eventTime, mongoTemplate, timeSeriesCollectionName);
        this.baseItemHistory = new TimeSeriesLog(tenant);
    }

    public void checkChanges() {
        try {
            String newStateJson = gson.toJson(this.item);
            String oldStateJson = null;
            Map newStateMap = (Map)gson.fromJson(newStateJson, this.mapType);
            this.baseItemHistory.setEventTime(this.eventTime);
            this.baseItemHistory.setItemId((String)newStateMap.get("id"));
            this.baseItemHistory.setTitle((String)newStateMap.get("title"));
            this.baseItemHistory.setItemType(TimeSeriesLog.ItemType.BASE_ITEM);
            this.baseItemHistory.setKey((String)newStateMap.get("key"));
            if (PropertyValidator.isValid((Object)this.oldState)) {
                oldStateJson = gson.toJson(this.oldState);
            }
            Map changes = BaseItemCFDLogger.retrieveChanges((String)newStateJson, oldStateJson);
            this.baseItemHistory.setChanges(changes);
            if (this.baseItemHistory.getChanges() != null && !this.baseItemHistory.getChanges().isEmpty()) {
                HashMap staticFields = new HashMap();
                if (changes.containsKey("baseItemLinks")) {
                    staticFields.put("baseItemLinks", changes.get("baseItemLinks"));
                } else if (PropertyValidator.isValid(newStateMap.get("baseItemLinks"))) {
                    staticFields.put("baseItemLinks", newStateMap.get("baseItemLinks"));
                }
                if (changes.containsKey("completionCriteria")) {
                    staticFields.put("completionCriteria", changes.get("completionCriteria"));
                } else if (PropertyValidator.isValid(newStateMap.get("completionCriteria"))) {
                    staticFields.put("completionCriteria", newStateMap.get("completionCriteria"));
                }
                if (changes.containsKey("linkedCardWeights")) {
                    staticFields.put("linkedCardWeights", changes.get("linkedCardWeights"));
                } else if (PropertyValidator.isValid(newStateMap.get("linkedCardWeights"))) {
                    staticFields.put("linkedCardWeights", newStateMap.get("linkedCardWeights"));
                }
                if (changes.containsKey("archive")) {
                    staticFields.put("archive", changes.get("archive"));
                } else if (PropertyValidator.isValid(newStateMap.get("archive"))) {
                    staticFields.put("archive", newStateMap.get("archive"));
                }
                if (changes.containsKey("fields")) {
                    staticFields.put("fields", changes.get("fields"));
                } else if (PropertyValidator.isValid(newStateMap.get("fields"))) {
                    staticFields.put("fields", newStateMap.get("fields"));
                }
                if (changes.containsKey("status")) {
                    staticFields.put("status", changes.get("status"));
                } else if (PropertyValidator.isValid(newStateMap.get("status"))) {
                    staticFields.put("status", newStateMap.get("status"));
                }
                this.baseItemHistory.setStaticFields(staticFields);
                LOGGER.debug("Going to save backlog item with id " + this.baseItemHistory.getItemId());
                this.mongoTemplate.save((Object)this.baseItemHistory, this.timeSeriesCollectionName);
            } else {
                LOGGER.debug("Skipping saving for item with id " + this.baseItemHistory.getItemId());
            }
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
    }

    public void logChangesForDeletion() {
        String oldStateJson = gson.toJson(this.oldState);
        Map oldStateMap = (Map)gson.fromJson(oldStateJson, this.mapType);
        this.baseItemHistory.setEventTime(this.eventTime);
        this.baseItemHistory.setItemId((String)oldStateMap.get("id"));
        this.baseItemHistory.setTitle((String)oldStateMap.get("title"));
        this.baseItemHistory.setItemType(TimeSeriesLog.ItemType.BASE_ITEM);
        this.baseItemHistory.setKey((String)oldStateMap.get("key"));
        HashMap<String, Boolean> changes = new HashMap<String, Boolean>();
        changes.put("archive", true);
        this.baseItemHistory.setChanges(changes);
        this.mongoTemplate.save((Object)this.baseItemHistory, this.timeSeriesCollectionName);
    }

    public static Map<String, Object> retrieveChanges(String newJson, String oldJson) {
        Map changes = null;
        try {
            Type mapType = new /* Unavailable Anonymous Inner Class!! */.getType();
            Map newStateMap = (Map)gson.fromJson(newJson, mapType);
            HashMap changeAndOnlyLeftRightItemsMap = new HashMap();
            if (PropertyValidator.isValid((Object)oldJson)) {
                Map oldStateMap = (Map)gson.fromJson(oldJson, mapType);
                MapDifference diffMap = null;
                if (PropertyValidator.isValid((Object)oldStateMap) && PropertyValidator.isValid((Object)newStateMap)) {
                    diffMap = Maps.difference((Map)oldStateMap, (Map)newStateMap);
                }
                if (PropertyValidator.isValid(diffMap)) {
                    HashMap differingRightValues = new HashMap();
                    diffMap.entriesDiffering().forEach((key, valueDifference) -> {
                        if ("almFields".equals(key)) {
                            Map rightValue = (Map)valueDifference.rightValue();
                            Map leftValue = (Map)valueDifference.leftValue();
                            if (rightValue != null && leftValue != null && rightValue.size() == leftValue.size()) {
                                boolean isDifference = true;
                                for (Map.Entry entry : rightValue.entrySet()) {
                                    String rightValueStr;
                                    Object leftValueObj;
                                    if (!leftValue.containsKey(entry.getKey()) || !((leftValueObj = leftValue.get(entry.getKey())) instanceof String) && !(entry.getValue() instanceof String)) continue;
                                    String leftValueStr = leftValueObj.toString();
                                    isDifference = !leftValueStr.equals(rightValueStr = entry.getValue().toString());
                                }
                                if (isDifference) {
                                    differingRightValues.put(key, valueDifference.rightValue());
                                }
                            } else {
                                differingRightValues.put(key, valueDifference.rightValue());
                            }
                        } else if ("fields".equals(key)) {
                            Map rightValue = (Map)valueDifference.rightValue();
                            Map leftValue = (Map)valueDifference.leftValue();
                            leftValue.remove("ChangedDate");
                            leftValue.remove("AlmSyncError");
                            rightValue.remove("ChangedDate");
                            rightValue.remove("AlmSyncError");
                            MapDifference fieldDiff = Maps.difference((Map)leftValue, (Map)rightValue);
                            if (!fieldDiff.areEqual()) {
                                differingRightValues.put(key, valueDifference.rightValue());
                            }
                        } else {
                            differingRightValues.put(key, valueDifference.rightValue());
                        }
                    });
                    changeAndOnlyLeftRightItemsMap.putAll(differingRightValues);
                    changeAndOnlyLeftRightItemsMap.putAll(diffMap.entriesOnlyOnLeft());
                    changeAndOnlyLeftRightItemsMap.putAll(diffMap.entriesOnlyOnRight());
                }
                String changesJson = gson.toJson(changeAndOnlyLeftRightItemsMap);
                changes = (Map)gson.fromJson(changesJson, mapType);
            } else {
                changes = (Map)gson.fromJson(newJson, mapType);
            }
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            LOGGER.info("Old State Json Object is: " + oldJson);
            LOGGER.info("New State Json Object is: " + newJson);
        }
        return changes;
    }
}

