/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.change.stream.service;

import com.viztrend.safe.change.stream.dao.DBRefQueries;
import com.viztrend.safe.change.stream.model.BacklogItemMirror;
import com.viztrend.safe.change.stream.model.BaseItemLinkMirror;
import com.viztrend.safe.change.stream.model.BaseItemMirror;
import com.viztrend.safe.change.stream.model.ItemJiraDependencyMirror;
import com.viztrend.safe.change.stream.model.ItemLinkMirror;
import com.viztrend.safe.change.stream.model.ItemMirror;
import com.viztrend.safe.change.stream.model.RiskMirror;
import com.viztrend.safe.change.stream.model.RiskRegisterMirror;
import com.viztrend.safe.change.stream.model.SessionBoardMirror;
import com.viztrend.safe.change.stream.model.SessionMirror;
import com.viztrend.safe.change.stream.model.StatusMirror;
import com.viztrend.safe.change.stream.model.TeamContainerMirror;
import com.viztrend.safe.persistence.entity.BacklogItem;
import com.viztrend.safe.persistence.entity.BaseItem;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.ItemJiraDependency;
import com.viztrend.safe.persistence.entity.ItemLink;
import com.viztrend.safe.persistence.entity.Risk;
import com.viztrend.safe.persistence.entity.RiskRegister;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.Status;
import com.viztrend.safe.utils.PropertyValidator;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DBRefHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DBRefHandler.class);
    private final DBRefQueries dbRefQueries;

    @Autowired
    public DBRefHandler(DBRefQueries dbRefQueries) {
        this.dbRefQueries = dbRefQueries;
    }

    public Item handleItemRef(Document fullDocument) throws Exception {
        return this.dbRefQueries.itemDBRefQuery(fullDocument);
    }

    public BacklogItem handleBacklogItemRef(Document fullDocument) throws Exception {
        return this.dbRefQueries.backlogItemDBRefQuery(fullDocument);
    }

    public BaseItem handleBaseItemRef(Document fullDocument) throws Exception {
        return this.dbRefQueries.baseItemRefQuery(fullDocument);
    }

    public Risk handleRiskRef(Document fullDocument) throws Exception {
        return this.dbRefQueries.riskRefQuery(fullDocument);
    }

    public RiskRegister handleRiskRegisterRef(Document fullDocument) throws Exception {
        return this.dbRefQueries.riskRegisterRefQuery(fullDocument);
    }

    public Session handleSessionRef(Document fullDocument) throws Exception {
        return this.dbRefQueries.sessionRefQuery(fullDocument);
    }

    public ItemLink handleItemLinkRef(Document fullDocument) throws Exception {
        return this.dbRefQueries.itemLinkDBRefQuery(fullDocument);
    }

    public void mergeItemLinkWithRefs(ItemLinkMirror itemLinkMirror, ItemLink itemLink) throws Exception {
        if (!PropertyValidator.isValid((Object)itemLinkMirror) || !PropertyValidator.isValid((Object)itemLink)) {
            return;
        }
        itemLinkMirror.setWfStatus(StatusMirror.fromStatus((Status)itemLink.getWfStatus()));
        itemLinkMirror.setResponsible(itemLink.getResponsible());
        itemLinkMirror.setReporter(itemLink.getReporter());
        if (PropertyValidator.isValid((Object)itemLink.getJiraDependency())) {
            ItemJiraDependency jiraDependency = itemLink.getJiraDependency();
            ItemJiraDependencyMirror jiraDependencyMirror = new ItemJiraDependencyMirror();
            jiraDependencyMirror.setId(jiraDependency.getId());
            itemLinkMirror.setJiraDependency(jiraDependencyMirror);
        }
    }

    public void mergeSessionWithRefs(SessionMirror sessionMirror, Session session) throws Exception {
        if (!PropertyValidator.isValid((Object)sessionMirror) || !PropertyValidator.isValid((Object)session)) {
            return;
        }
        if (PropertyValidator.isValid((Object)session.getRiskRegister())) {
            RiskRegisterMirror riskRegisterMirror = new RiskRegisterMirror();
            riskRegisterMirror.setId(session.getRiskRegister().getId());
            sessionMirror.setRiskRegister(riskRegisterMirror);
        }
    }

    public void mergeRiskWithRefs(RiskMirror riskMirror, Risk risk) throws Exception {
        if (!PropertyValidator.isValid((Object)riskMirror) || !PropertyValidator.isValid((Object)risk)) {
            return;
        }
        riskMirror.setResponsible(risk.getResponsible());
        if (PropertyValidator.isValid((Object)risk.getRiskRegister())) {
            RiskRegisterMirror riskRegisterMirror = new RiskRegisterMirror();
            riskRegisterMirror.setId(risk.getRiskRegister().getId());
            riskMirror.setRiskRegister(riskRegisterMirror);
        }
        if (PropertyValidator.isValid((Object)risk.getStatus())) {
            riskMirror.setStatus(StatusMirror.fromStatus((Status)risk.getStatus()));
        }
    }

    public void mergeBaseItemWithRefs(BaseItemMirror baseItemMirror, BaseItem baseItem) {
        if (!PropertyValidator.isValid((Object)baseItemMirror) || !PropertyValidator.isValid((Object)baseItem)) {
            return;
        }
        if (PropertyValidator.isValid((Collection)baseItem.getBaseItemLinks())) {
            List dbRefBaseItemLinks = baseItem.getBaseItemLinks();
            List baseItemLinks = dbRefBaseItemLinks.stream().map(baseItemRef -> {
                BaseItemLinkMirror baseItemLinkMirror = new BaseItemLinkMirror();
                baseItemLinkMirror.setId(baseItemRef.getId());
                baseItemLinkMirror.setBaseItemId(baseItemRef.getBaseItemId());
                baseItemLinkMirror.setSessionId(baseItemRef.getSessionId());
                baseItemLinkMirror.setLinkType(baseItemRef.getLinkType());
                baseItemLinkMirror.setWeightage(baseItemRef.getWeightage());
                baseItemLinkMirror.setReleaseTrainId(baseItemRef.getReleaseTrainId());
                baseItemLinkMirror.setLinkedItemById(baseItemRef.getLinkedItemById());
                baseItemLinkMirror.setTeamId(baseItemRef.getTeamId());
                baseItemLinkMirror.setArchive(baseItemRef.isArchive());
                baseItemLinkMirror.setCreatedOn(baseItemRef.getCreatedOn());
                return baseItemLinkMirror;
            }).collect(Collectors.toList());
            baseItemMirror.setBaseItemLinks(baseItemLinks);
        }
        baseItemMirror.setStatus(StatusMirror.fromStatus((Status)baseItem.getStatus()));
    }

    public void mergeItemWithRefs(Object obj, Item dbRefItem) {
        if (!PropertyValidator.isValid((Object)obj) || !PropertyValidator.isValid((Object)dbRefItem)) {
            return;
        }
        if (obj instanceof Item) {
            Item item = (Item)obj;
            item.setSessionBoards(dbRefItem.getSessionBoards());
            item.setTeamContainers(dbRefItem.getTeamContainers());
            item.setStatus(dbRefItem.getStatus());
            item.setParent(dbRefItem.getParent());
            item.setIssueType(dbRefItem.getIssueType());
            item.setItemType(dbRefItem.getItemType());
            item.setItemLinks(dbRefItem.getItemLinks());
        } else if (obj instanceof ItemMirror) {
            ItemMirror itemMirror = (ItemMirror)obj;
            if (PropertyValidator.isValid((Collection)dbRefItem.getSessionBoards())) {
                List sessionBoards = dbRefItem.getSessionBoards();
                List sessionBoardMirrors = sessionBoards.stream().map(SessionBoardMirror::new).collect(Collectors.toList());
                itemMirror.setSessionBoards(sessionBoardMirrors);
            }
            itemMirror.setStatus(StatusMirror.fromStatus((Status)dbRefItem.getStatus()));
            itemMirror.setIssueType(dbRefItem.getIssueType());
            itemMirror.setItemType(dbRefItem.getItemType());
            itemMirror.setItemLinks(dbRefItem.getItemLinks());
            if (PropertyValidator.isValid((Collection)dbRefItem.getTeamContainers())) {
                List dbRefTeamContainers = dbRefItem.getTeamContainers();
                List teamContainers = dbRefTeamContainers.stream().map(TeamContainerMirror::new).collect(Collectors.toList());
                itemMirror.setTeamContainers(teamContainers);
            }
            if (PropertyValidator.isValid((Object)dbRefItem.getParent())) {
                Item parentItem = dbRefItem.getParent();
                ItemMirror parent = new ItemMirror();
                parent.setId(parentItem.getId());
                parent.setTitle(parentItem.getTitle());
                parent.setStoryPoints(parentItem.getStoryPoints());
                parent.setTenant(parentItem.getTenant());
                itemMirror.setParent(parent);
            }
        }
    }

    public void mergeBacklogItemWithRefs(BacklogItemMirror backlogItemMirror, BacklogItem dbRefItem) {
        if (!PropertyValidator.isValid((Object)backlogItemMirror) || !PropertyValidator.isValid((Object)dbRefItem)) {
            return;
        }
        backlogItemMirror.setStatus(StatusMirror.fromStatus((Status)dbRefItem.getStatus()));
    }

    public void mergeRiskRegisterWithRefs(RiskRegisterMirror riskRegisterMirror, RiskRegister dbRefItem) {
        if (!PropertyValidator.isValid((Object)riskRegisterMirror) || !PropertyValidator.isValid((Object)dbRefItem)) {
            return;
        }
        riskRegisterMirror.setStatus(StatusMirror.fromStatus((Status)dbRefItem.getStatus()));
    }
}

