/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.change.stream.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.MongoClient;
import com.mongodb.MongoCommandException;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.changestream.ChangeStreamDocument;
import com.viztrend.safe.change.stream.dao.ChangeStreamOldStateRepository;
import com.viztrend.safe.change.stream.dao.ResumeTokenRepository;
import com.viztrend.safe.change.stream.factory.CFDLoggerFactory;
import com.viztrend.safe.change.stream.factory.MirrorEntityFactory;
import com.viztrend.safe.change.stream.model.ChangeStreamOldState;
import com.viztrend.safe.change.stream.model.CustomObjectMapper;
import com.viztrend.safe.change.stream.model.ResumeToken;
import com.viztrend.safe.change.stream.service.DBRefHandler;
import com.viztrend.safe.change.stream.service.logger.AbstractCFDLogger;
import com.viztrend.safe.change.stream.utils.ServiceUtils;
import com.viztrend.safe.config.AppConfig;
import com.viztrend.safe.persistence.repository.ActiveNodeRepository;
import com.viztrend.safe.persistence.repository.AppInitConfigRepository;
import com.viztrend.safe.utils.DBUtils;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import java.util.Date;
import javax.annotation.PostConstruct;
import org.bson.BsonDocument;
import org.bson.BsonObjectId;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.MatchOperation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.stereotype.Service;

@Service
public class ChangeStreamLoggerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChangeStreamLoggerService.class);
    private final ChangeStreamOldStateRepository changeStreamOldStateRepository;
    private final MongoTemplate mongoTemplate;
    private final DBRefHandler dbRefHandler;
    private final Environment env;
    private final AppConfig.MongoConfig mongoConfig;
    private final AppInitConfigRepository appInitConfigRepository;
    private final ActiveNodeRepository activeNodeRepository;
    private final ResumeTokenRepository resumeTokenRepository;

    @Autowired
    public ChangeStreamLoggerService(ChangeStreamOldStateRepository changeStreamOldStateRepository, AppInitConfigRepository appInitConfigRepository, ActiveNodeRepository activeNodeRepository, MongoTemplate mongoTemplate, DBRefHandler dbRefHandler, AppConfig.MongoConfig mongoConfig, Environment env, ResumeTokenRepository resumeTokenRepository) {
        this.changeStreamOldStateRepository = changeStreamOldStateRepository;
        this.appInitConfigRepository = appInitConfigRepository;
        this.activeNodeRepository = activeNodeRepository;
        this.mongoTemplate = mongoTemplate;
        this.dbRefHandler = dbRefHandler;
        mongoConfig.setEnableCompression(true);
        this.mongoConfig = mongoConfig;
        this.env = env;
        this.resumeTokenRepository = resumeTokenRepository;
    }

    @PostConstruct
    public void init() {
        try {
            if (PropertyValidator.isValid((Object)System.getenv("enableTimeSeries")) && System.getenv("enableTimeSeries").equals("true")) {
                ChangeStreamOldState.COLLECTION_NAME[] collectionNames;
                MongoClient mongoClient = (MongoClient)this.mongoConfig.mongo();
                if (!PropertyValidator.isValid((Object)mongoClient.getReplicaSetStatus())) {
                    LOGGER.info("Database is not a replica set or cluster, skipping time-series initialization");
                    return;
                }
                if (!PropertyValidator.isValid((Object)System.getenv("enableTimeSeries")) || !System.getenv("enableTimeSeries").equals("true")) {
                    LOGGER.info("Change stream not enabled");
                    return;
                }
                LOGGER.info("Change stream is enabled");
                MongoDatabase db = mongoClient.getDatabase(this.env.getProperty("mongo.db"));
                for (ChangeStreamOldState.COLLECTION_NAME collectionName : collectionNames = ChangeStreamOldState.COLLECTION_NAME.values()) {
                    new Thread(() -> this.watchCollection(db, collectionName)).start();
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
    }

    private void initializeCollections(ChangeStreamOldState.COLLECTION_NAME[] collectionNames, MongoDatabase db) {
        for (ChangeStreamOldState.COLLECTION_NAME collectionName : collectionNames) {
            ServiceUtils.createTimeSeriesCollectionIfNotExists((String)ServiceUtils.getTimeSeriesCollectionName((ChangeStreamOldState.COLLECTION_NAME)collectionName), (MongoDatabase)db);
        }
        ServiceUtils.createIndexForTimeSeriesCollections((MongoTemplate)this.mongoTemplate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void watchCollection(MongoDatabase db, ChangeStreamOldState.COLLECTION_NAME collectionName) {
        MongoCollection collection = db.getCollection(collectionName.name());
        ResumeToken resumeTokenObj = this.resumeTokenRepository.findByCollectionName(collectionName.name());
        long backoffTime = 5000L;
        if (!PropertyValidator.isValid((Object)resumeTokenObj)) {
            resumeTokenObj = ServiceUtils.createValidResumeToken((ChangeStreamOldState.COLLECTION_NAME)collectionName);
            this.resumeTokenRepository.save((Object)resumeTokenObj);
        }
        BsonDocument resumeToken = resumeTokenObj.getResumeToken();
        while (true) {
            try (MongoCursor cursor = ServiceUtils.getChangeStreamCursor((MongoCollection)collection, (ResumeToken)resumeTokenObj, (ChangeStreamOldState.COLLECTION_NAME)collectionName, (ResumeTokenRepository)this.resumeTokenRepository);){
                backoffTime = 5000L;
                while (cursor.hasNext()) {
                    ChangeStreamDocument changeStreamDocument = (ChangeStreamDocument)cursor.next();
                    resumeToken = changeStreamDocument.getResumeToken();
                    resumeTokenObj.setResumeToken(resumeToken);
                    resumeTokenObj.setUpdatedAt(new Date());
                    try {
                        this.processCursorEntry(changeStreamDocument, collectionName);
                    }
                    catch (Exception e) {
                        LOGGER.error("Error processing change stream entry: {}", (Object)StringUtils.getTraceString((Throwable)e));
                    }
                    finally {
                        this.resumeTokenRepository.save((Object)resumeTokenObj);
                    }
                }
            }
            catch (MongoCommandException mongoCommandException) {
                if (mongoCommandException.getErrorCode() == 286) {
                    LOGGER.warn("ChangeStreamHistoryLost - Resume token no longer valid: {}");
                    resumeToken = null;
                } else {
                    LOGGER.error("MongoDB connection lost or cursor closed: {}", (Object)StringUtils.getTraceString((Throwable)mongoCommandException));
                }
            }
            catch (Exception e) {
                LOGGER.error("Unexpected error while watching change stream: {}", (Object)StringUtils.getTraceString((Throwable)e));
            }
            LOGGER.info("Retrying connection to MongoDB change stream in {} ms...", (Object)backoffTime);
            try {
                Thread.sleep(backoffTime);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            backoffTime = Math.min(backoffTime * 2L, 60000L);
        }
    }

    private void processCursorEntry(ChangeStreamDocument<Document> changeStreamDocument, ChangeStreamOldState.COLLECTION_NAME collectionName) throws Exception {
        if (!PropertyValidator.isValid(changeStreamDocument)) {
            return;
        }
        Document fullDocument = (Document)changeStreamDocument.getFullDocument();
        ObjectMapper mapper = CustomObjectMapper.getMapper();
        if ("DELETE".equalsIgnoreCase(changeStreamDocument.getOperationType().name()) && PropertyValidator.isValid((Object)changeStreamDocument.getDocumentKey())) {
            BsonDocument documentKey = changeStreamDocument.getDocumentKey();
            String id = DBUtils.getIdFromBsonDocument((BsonDocument)documentKey, (String[])new String[0]);
            this.handleEntryDeleteCase(id, collectionName);
        } else if (PropertyValidator.isValid((Object)fullDocument)) {
            ObjectId id = (ObjectId)fullDocument.get((Object)"_id");
            String itemId = PropertyValidator.isValid((Object)id) ? id.toString() : null;
            ChangeStreamOldState changeStreamOldState = this.changeStreamOldStateRepository.findByItemId(itemId);
            this.handleChangeStreamFromFullDocument(collectionName, fullDocument, changeStreamOldState, mapper);
        } else if (PropertyValidator.isValid((Object)changeStreamDocument.getDocumentKey()) && PropertyValidator.isValid((Object)changeStreamDocument.getDocumentKey().get((Object)"_id"))) {
            Object documentId;
            Document dbFullDocument;
            Object documentKey = changeStreamDocument.getDocumentKey().get((Object)"_id");
            if (documentKey instanceof BsonObjectId) {
                documentKey = ((BsonObjectId)documentKey).getValue().toString();
            }
            if (PropertyValidator.isValid((Object)(dbFullDocument = this.findFullDocumentById(documentId = ServiceUtils.isValidObjectId((String)documentKey.toString()) ? new ObjectId(documentKey.toString()) : documentKey, collectionName)))) {
                ObjectId id = (ObjectId)dbFullDocument.get((Object)"_id");
                String itemId = PropertyValidator.isValid((Object)id) ? id.toString() : null;
                ChangeStreamOldState changeStreamOldState = this.changeStreamOldStateRepository.findByItemId(itemId);
                this.handleChangeStreamFromFullDocument(collectionName, dbFullDocument, changeStreamOldState, mapper);
            }
        }
    }

    private Document findFullDocumentById(Object id, ChangeStreamOldState.COLLECTION_NAME collectionName) {
        Criteria criteria = Criteria.where((String)"_id").is(id);
        MatchOperation match = Aggregation.match((Criteria)criteria);
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{match});
        AggregationResults results = this.mongoTemplate.aggregate(aggregation, collectionName.name(), Document.class);
        return (Document)results.getUniqueMappedResult();
    }

    private void handleEntryDeleteCase(String id, ChangeStreamOldState.COLLECTION_NAME collectionName) {
        ChangeStreamOldState oldState = this.changeStreamOldStateRepository.findByItemId(id);
        if (!PropertyValidator.isValid((Object)oldState)) {
            return;
        }
        String tenant = ServiceUtils.getTenantFromOldState((ChangeStreamOldState)oldState);
        String timeSeriesCollectionName = ServiceUtils.getTimeSeriesCollectionName((ChangeStreamOldState.COLLECTION_NAME)collectionName);
        AbstractCFDLogger cfdLogger = CFDLoggerFactory.createCFDLogger((ChangeStreamOldState.COLLECTION_NAME)collectionName, (Date)new Date(), null, (Object)oldState.getBeforeUpdate(), (MongoTemplate)this.mongoTemplate, (String)tenant, (String)timeSeriesCollectionName);
        cfdLogger.logChangesForDeletion();
        this.changeStreamOldStateRepository.delete((Object)oldState);
    }

    private void handleChangeStreamFromFullDocument(ChangeStreamOldState.COLLECTION_NAME collectionName, Document fullDocument, ChangeStreamOldState changeStreamOldState, ObjectMapper mapper) throws Exception {
        String fullDocumentJson = mapper.writeValueAsString((Object)fullDocument);
        String timeSeriesCollectionName = ServiceUtils.getTimeSeriesCollectionName((ChangeStreamOldState.COLLECTION_NAME)collectionName);
        ObjectId id = (ObjectId)fullDocument.get((Object)"_id");
        String itemId = PropertyValidator.isValid((Object)id) ? id.toString() : null;
        LOGGER.debug("Processing change stream for document with id:  {} and collection name: {}", (Object)itemId, (Object)timeSeriesCollectionName);
        String tenant = fullDocument.getString((Object)"tenant");
        if (!PropertyValidator.isValid((Object)changeStreamOldState)) {
            changeStreamOldState = new ChangeStreamOldState();
            changeStreamOldState.setItemId(itemId);
            changeStreamOldState.setItemType(collectionName.name());
            changeStreamOldState.setTenant(tenant);
        }
        changeStreamOldState.setTenant(tenant);
        Object entityMirror = MirrorEntityFactory.createMirrorEntity((ChangeStreamOldState.COLLECTION_NAME)collectionName, (String)fullDocumentJson, (Document)fullDocument, (DBRefHandler)this.dbRefHandler);
        AbstractCFDLogger cfdLogger = CFDLoggerFactory.createCFDLogger((ChangeStreamOldState.COLLECTION_NAME)collectionName, (Date)new Date(), (Object)entityMirror, (Object)changeStreamOldState.getBeforeUpdate(), (MongoTemplate)this.mongoTemplate, (String)changeStreamOldState.getTenant(), (String)timeSeriesCollectionName);
        cfdLogger.checkChanges();
        changeStreamOldState.setBeforeUpdate(entityMirror);
        this.changeStreamOldStateRepository.save((Object)changeStreamOldState);
    }
}

