/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.change.stream.dao;

import com.mongodb.AggregationOptions;
import com.mongodb.BasicDBObject;
import com.mongodb.Cursor;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import com.viztrend.safe.change.stream.utils.DBOjectConversionUtils;
import com.viztrend.safe.change.stream.utils.QueryUtils;
import com.viztrend.safe.persistence.entity.BacklogItem;
import com.viztrend.safe.persistence.entity.BaseItem;
import com.viztrend.safe.persistence.entity.IssueType;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.ItemJiraDependency;
import com.viztrend.safe.persistence.entity.ItemLink;
import com.viztrend.safe.persistence.entity.ItemType;
import com.viztrend.safe.persistence.entity.Risk;
import com.viztrend.safe.persistence.entity.RiskRegister;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.Status;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.utils.DBUtils;
import com.viztrend.safe.utils.KendisUtils;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

@Service
public class DBRefQueries {
    private final MongoTemplate mongoTemplate;
    private final Logger LOGGER = LoggerFactory.getLogger(DBRefQueries.class);

    @Autowired
    public DBRefQueries(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }

    public Item itemDBRefQuery(Document fullDocument) {
        Item item = new Item();
        BasicDBObject matchStage = QueryUtils.createMatchStageToFindById((Document)fullDocument);
        BasicDBObject statusLookup = DBUtils.createLookup((String)"status", (String)"status.$id", (String)"_id", (String)"status");
        BasicDBObject parentLookup = DBUtils.createLookup((String)"item", (String)"parent.$id", (String)"_id", (String)"parent");
        BasicDBObject sessionBoardLookup = DBUtils.createLookup((String)"sessionBoard", (String)"sessionBoards.$id", (String)"_id", (String)"sessionBoards");
        BasicDBObject teamContainerLookup = DBUtils.createLookup((String)"teamContainer", (String)"teamContainers.$id", (String)"_id", (String)"teamContainers");
        BasicDBObject statusUnWind = DBUtils.createUnWindWithPath((String)"$status", (boolean)true);
        BasicDBObject teamContainersUnWind = DBUtils.createUnWindWithPath((String)"$teamContainers", (boolean)true);
        BasicDBObject parentUnWind = DBUtils.createUnWindWithPath((String)"$parent", (boolean)true);
        BasicDBObject teamLookup = DBUtils.createLookup((String)"team", (String)"teamContainers.team.$id", (String)"_id", (String)"teamContainers.team");
        BasicDBObject containerLookup = DBUtils.createLookup((String)"container", (String)"teamContainers.container.$id", (String)"_id", (String)"teamContainers.container");
        BasicDBObject teamContainerUnWind = DBUtils.createUnWindWithPath((String)"$teamContainers", (boolean)true);
        BasicDBObject teamUnWind = DBUtils.createUnWindWithPath((String)"$teamContainers.team", (boolean)true);
        BasicDBObject containerUnWind = DBUtils.createUnWindWithPath((String)"$teamContainers.container", (boolean)true);
        BasicDBObject groupStage = QueryUtils.itemRefGroupStage();
        BasicDBObject projectionStage = QueryUtils.itemRefProjectionStage();
        List<DBObject> pipeline = Arrays.asList(matchStage, statusLookup, parentLookup, sessionBoardLookup, teamContainerLookup, statusUnWind, teamContainersUnWind, parentUnWind, teamLookup, containerLookup, teamContainerUnWind, teamUnWind, containerUnWind, groupStage, projectionStage);
        DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(Item.class));
        AggregationOptions aggregationOptions = AggregationOptions.builder().allowDiskUse(Boolean.valueOf(true)).build();
        try (Cursor dbCursor = collection.aggregate(pipeline, aggregationOptions);){
            if (dbCursor.hasNext()) {
                List itemLinksObj;
                BasicDBObject itemTypeObj;
                BasicDBObject issueTypeObj;
                List teamContainersObj;
                List teamContainers;
                DBObject object = (DBObject)dbCursor.next();
                if (PropertyValidator.isValid((Object)object.get("status"))) {
                    Status status = new Status((BasicDBObject)object.get("status"));
                    item.setStatus(status);
                }
                if (PropertyValidator.isValid((Collection)(teamContainers = DBOjectConversionUtils.convertToTeamContainers((List)(teamContainersObj = PropertyValidator.isValid((Object)object.get("teamContainers")) ? (List)object.get("teamContainers") : null))))) {
                    item.setTeamContainers(teamContainers);
                }
                BasicDBObject parentObj = PropertyValidator.isValid((Object)object.get("parent")) ? (BasicDBObject)object.get("parent") : null;
                item.setParent(DBOjectConversionUtils.convertToParent((BasicDBObject)parentObj));
                BasicDBObject basicDBObject = issueTypeObj = PropertyValidator.isValid((Object)object.get("issueType")) ? (BasicDBObject)object.get("issueType") : null;
                if (PropertyValidator.isValid((Object)issueTypeObj)) {
                    IssueType issueType = new IssueType();
                    issueType.setId(DBUtils.getIdFromDBObject((BasicDBObject)issueTypeObj, (String[])new String[0]));
                    item.setIssueType(issueType);
                }
                List sessionBoardObj = PropertyValidator.isValid((Object)object.get("sessionBoards")) ? (List)object.get("sessionBoards") : null;
                List sessionBoards = DBOjectConversionUtils.convertToSessionBoards((List)sessionBoardObj);
                item.setSessionBoards(sessionBoards);
                BasicDBObject basicDBObject2 = itemTypeObj = PropertyValidator.isValid((Object)object.get("itemType")) ? (BasicDBObject)object.get("itemType") : null;
                if (PropertyValidator.isValid((Object)itemTypeObj)) {
                    ItemType itemType = new ItemType();
                    itemType.setId(DBUtils.getIdFromDBObject((BasicDBObject)itemTypeObj, (String[])new String[0]));
                    item.setItemType(itemType);
                }
                List list = itemLinksObj = PropertyValidator.isValid((Object)object.get("itemLinks")) ? (List)object.get("itemLinks") : null;
                if (PropertyValidator.isValid((Collection)itemLinksObj)) {
                    ArrayList itemLinks = new ArrayList();
                    itemLinksObj.forEach(itemLinkObj -> {
                        ItemLink itemLink = new ItemLink();
                        itemLink.setId(DBUtils.getIdFromDBObject((BasicDBObject)itemLinkObj, (String[])new String[0]));
                        itemLinks.add(itemLink);
                    });
                    item.setItemLinks(itemLinks);
                }
            }
        }
        catch (Exception e) {
            this.LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return item;
    }

    public BaseItem baseItemRefQuery(Document fullDocument) {
        BaseItem baseItem = new BaseItem();
        BasicDBObject matchStage = QueryUtils.createMatchStageToFindById((Document)fullDocument);
        BasicDBObject statusLookup = DBUtils.createLookup((String)"status", (String)"status.$id", (String)"_id", (String)"status");
        BasicDBObject statusUnWind = DBUtils.createUnWindWithPath((String)"$status", (boolean)true);
        BasicDBObject itemTypeLookup = DBUtils.createLookup((String)"itemType", (String)"itemType.$id", (String)"_id", (String)"itemType");
        BasicDBObject itemTypeUnWind = DBUtils.createUnWindWithPath((String)"$itemType", (boolean)true);
        BasicDBObject baseItemLinkLookup = DBUtils.createLookup((String)"baseItemLink", (String)"baseItemLinks.$id", (String)"_id", (String)"baseItemLinks");
        BasicDBObject baseItemLinkUnWind = DBUtils.createUnWindWithPath((String)"$baseItemLink", (boolean)true);
        BasicDBObject projectionStage = new BasicDBObject("$project", (Object)new BasicDBObject().append("_id", (Object)1).append("title", (Object)1).append("type", (Object)1).append("fields", (Object)1).append("almFields", (Object)1).append("baseItemLinks", (Object)1).append("status._id", (Object)1).append("status.category", (Object)1).append("status.archive", (Object)1).append("status.tenant", (Object)1).append("status.rowStatus", (Object)1).append("itemType", (Object)1).append("baseItemLinks", (Object)1));
        List<DBObject> pipeLine = Arrays.asList(matchStage, statusLookup, statusUnWind, itemTypeLookup, itemTypeUnWind, baseItemLinkLookup, baseItemLinkUnWind, projectionStage);
        DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(BaseItem.class));
        AggregationOptions aggregationOptions = AggregationOptions.builder().allowDiskUse(Boolean.valueOf(true)).build();
        try (Cursor dbCursor = collection.aggregate(pipeLine, aggregationOptions);){
            if (dbCursor.hasNext()) {
                DBObject object = (DBObject)dbCursor.next();
                if (object.containsField("status")) {
                    Status status = new Status((BasicDBObject)object.get("status"));
                    baseItem.setStatus(status);
                }
                if (PropertyValidator.isValid((Object)object.get("baseItemLinks"))) {
                    List baseItemLinkObjs = (List)object.get("baseItemLinks");
                    ArrayList baseItemLinks = new ArrayList();
                    baseItemLinkObjs.forEach(baseItemLinkObj -> baseItemLinks.add(DBOjectConversionUtils.convertToBaseItemLink((BasicDBObject)baseItemLinkObj)));
                    baseItem.setBaseItemLinks(baseItemLinks);
                }
                if (PropertyValidator.isValid((Object)object.get("itemType"))) {
                    BasicDBObject itemTypeObj = (BasicDBObject)object.get("itemType");
                    Map itemTypeParamsMap = itemTypeObj.toMap();
                    ItemType itemType = new ItemType(itemTypeParamsMap);
                    baseItem.setItemType(itemType);
                }
            }
        }
        return baseItem;
    }

    public BacklogItem backlogItemDBRefQuery(Document fullDocument) {
        BacklogItem backlogItem = new BacklogItem();
        BasicDBObject matchStage = QueryUtils.createMatchStageToFindById((Document)fullDocument);
        BasicDBObject statusLookup = DBUtils.createLookup((String)"status", (String)"status.$id", (String)"_id", (String)"status");
        BasicDBObject statusUnWind = DBUtils.createUnWindWithPath((String)"$status", (boolean)true);
        BasicDBObject projectionStage = new BasicDBObject("$project", (Object)new BasicDBObject().append("_id", (Object)1).append("status._id", (Object)1).append("status.category", (Object)1).append("status.archive", (Object)1).append("status.tenant", (Object)1).append("status.rowStatus", (Object)1));
        List<DBObject> pipeLine = Arrays.asList(matchStage, statusLookup, statusUnWind, projectionStage);
        DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(BacklogItem.class));
        AggregationOptions aggregationOptions = AggregationOptions.builder().allowDiskUse(Boolean.valueOf(true)).build();
        try (Cursor dbCursor = collection.aggregate(pipeLine, aggregationOptions);){
            DBObject object;
            if (dbCursor.hasNext() && (object = (DBObject)dbCursor.next()).containsField("status")) {
                Status status = new Status((BasicDBObject)object.get("status"));
                backlogItem.setStatus(status);
            }
        }
        return backlogItem;
    }

    public Risk riskRefQuery(Document fullDocument) {
        Risk risk = new Risk();
        BasicDBObject matchStage = QueryUtils.createMatchStageToFindById((Document)fullDocument);
        BasicDBObject statusLookup = DBUtils.createLookup((String)"status", (String)"status.$id", (String)"_id", (String)"status");
        BasicDBObject statusUnWind = DBUtils.createUnWindWithPath((String)"$status", (boolean)true);
        BasicDBObject userLookup = DBUtils.createLookup((String)"user", (String)"responsible.$id", (String)"_id", (String)"responsible");
        BasicDBObject userUnWind = DBUtils.createUnWindWithPath((String)"$responsible", (boolean)true);
        BasicDBObject projectionStage = new BasicDBObject("$project", (Object)new BasicDBObject().append("_id", (Object)1).append("riskNumber", (Object)1).append("riskTitle", (Object)1).append("riskRegister", (Object)1).append("linkedItemsIds", (Object)1).append("linkedItemsById", (Object)1).append("boardTeams", (Object)1).append("boardSprints", (Object)1).append("status._id", (Object)1).append("status.category", (Object)1).append("status.archive", (Object)1).append("status.tenant", (Object)1).append("status.rowStatus", (Object)1).append("raisedDate", (Object)1).append("resolutionDate", (Object)1).append("responsible._id", (Object)1).append("responsible.userType", (Object)1).append("responsible.userCompanies", (Object)1).append("responsible.tenant", (Object)1));
        List<DBObject> pipeLine = Arrays.asList(matchStage, statusLookup, statusUnWind, userLookup, userUnWind, projectionStage);
        DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(Risk.class));
        AggregationOptions aggregationOptions = AggregationOptions.builder().allowDiskUse(Boolean.valueOf(true)).build();
        try (Cursor dbCursor = collection.aggregate(pipeLine, aggregationOptions);){
            if (dbCursor.hasNext()) {
                DBObject object = (DBObject)dbCursor.next();
                if (object.containsField("riskRegister")) {
                    RiskRegister riskRegister = new RiskRegister();
                    DBRef riskRegisterRef = (DBRef)object.get("riskRegister");
                    riskRegister.setId(riskRegisterRef.getId().toString());
                    risk.setRiskRegister(riskRegister);
                }
                if (object.containsField("responsible")) {
                    User user = DBOjectConversionUtils.convertToUser((BasicDBObject)((BasicDBObject)object.get("responsible")));
                    risk.setResponsible(user);
                }
                if (object.containsField("status")) {
                    Status status = new Status((BasicDBObject)object.get("status"));
                    risk.setStatus(status);
                }
            }
        }
        return risk;
    }

    public RiskRegister riskRegisterRefQuery(Document fullDocument) {
        RiskRegister riskRegister = new RiskRegister();
        BasicDBObject matchStage = QueryUtils.createMatchStageToFindById((Document)fullDocument);
        BasicDBObject statusLookup = DBUtils.createLookup((String)"status", (String)"status.$id", (String)"_id", (String)"status");
        BasicDBObject statusUnWind = DBUtils.createUnWindWithPath((String)"$status", (boolean)true);
        BasicDBObject projectionStage = new BasicDBObject("$project", (Object)new BasicDBObject().append("_id", (Object)1).append("registerKey", (Object)1).append("registerName", (Object)1).append("status._id", (Object)1).append("status.category", (Object)1).append("status.archive", (Object)1).append("status.tenant", (Object)1).append("status.rowStatus", (Object)1));
        List<DBObject> pipeLine = Arrays.asList(matchStage, statusLookup, statusUnWind, projectionStage);
        DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(RiskRegister.class));
        AggregationOptions aggregationOptions = AggregationOptions.builder().allowDiskUse(Boolean.valueOf(true)).build();
        try (Cursor dbCursor = collection.aggregate(pipeLine, aggregationOptions);){
            DBObject object;
            if (dbCursor.hasNext() && (object = (DBObject)dbCursor.next()).containsField("status")) {
                Status status = new Status((BasicDBObject)object.get("status"));
                riskRegister.setStatus(status);
            }
        }
        return riskRegister;
    }

    public Session sessionRefQuery(Document fullDocument) {
        Session session = new Session();
        BasicDBObject matchStage = QueryUtils.createMatchStageToFindById((Document)fullDocument);
        BasicDBObject projectionStage = new BasicDBObject("$project", (Object)new BasicDBObject().append("_id", (Object)1).append("riskRegister", (Object)1));
        List<DBObject> pipeLine = Arrays.asList(matchStage, projectionStage);
        DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(Session.class));
        AggregationOptions aggregationOptions = AggregationOptions.builder().allowDiskUse(Boolean.valueOf(true)).build();
        try (Cursor dbCursor = collection.aggregate(pipeLine, aggregationOptions);){
            DBObject object;
            if (dbCursor.hasNext() && (object = (DBObject)dbCursor.next()).containsField("riskRegister")) {
                DBRef riskRegisterRef = (DBRef)object.get("riskRegister");
                RiskRegister riskRegister = new RiskRegister();
                riskRegister.setId(riskRegisterRef.getId().toString());
                session.setRiskRegister(riskRegister);
            }
        }
        return session;
    }

    public ItemLink itemLinkDBRefQuery(Document fullDocument) {
        ItemLink itemLink = new ItemLink();
        BasicDBObject matchStage = QueryUtils.createMatchStageToFindById((Document)fullDocument);
        BasicDBObject statusLookup = DBUtils.createLookup((String)"status", (String)"wfStatus.$id", (String)"_id", (String)"wfStatus");
        BasicDBObject statusUnWind = DBUtils.createUnWindWithPath((String)"$wfStatus", (boolean)true);
        BasicDBObject userLookup = DBUtils.createLookup((String)"user", (String)"responsible.$id", (String)"_id", (String)"responsible");
        BasicDBObject userUnWind = DBUtils.createUnWindWithPath((String)"$responsible", (boolean)true);
        BasicDBObject projectionStage = new BasicDBObject("$project", (Object)new BasicDBObject().append("_id", (Object)1).append("wfStatus._id", (Object)1).append("wfStatus.category", (Object)1).append("wfStatus.archive", (Object)1).append("wfStatus.tenant", (Object)1).append("wfStatus.rowStatus", (Object)1).append("responsible._id", (Object)1).append("responsible.userType", (Object)1).append("responsible.userCompanies", (Object)1).append("responsible.tenant", (Object)1).append("reporter", (Object)1).append("jiraDependency", (Object)1));
        List<DBObject> pipeLine = Arrays.asList(matchStage, statusLookup, statusUnWind, userLookup, userUnWind, projectionStage);
        DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(ItemLink.class));
        AggregationOptions aggregationOptions = AggregationOptions.builder().allowDiskUse(Boolean.valueOf(true)).build();
        try (Cursor dbCursor = collection.aggregate(pipeLine, aggregationOptions);){
            if (dbCursor.hasNext()) {
                DBObject object = (DBObject)dbCursor.next();
                if (object.containsField("responsible")) {
                    User user = DBOjectConversionUtils.convertToUser((BasicDBObject)((BasicDBObject)object.get("responsible")));
                    itemLink.setResponsible(user);
                }
                if (object.containsField("reporter")) {
                    DBRef reporterRef = (DBRef)object.get("reporter");
                    User user = new User();
                    user.setId(reporterRef.getId().toString());
                    itemLink.setReporter(user);
                }
                if (object.containsField("jiraDependency")) {
                    DBRef jiraDependencyRef = (DBRef)object.get("jiraDependency");
                    ItemJiraDependency jiraDependency = new ItemJiraDependency();
                    jiraDependency.setId(jiraDependencyRef.getId().toString());
                    itemLink.setJiraDependency(jiraDependency);
                }
                if (object.containsField("wfStatus")) {
                    Status status = new Status((BasicDBObject)object.get("wfStatus"));
                    itemLink.setWfStatus(status);
                }
            }
        }
        return itemLink;
    }
}

