/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.aspect;

import com.viztrend.safe.ReadDbPropertiesPostInit;
import com.viztrend.safe.persistence.entity.ActiveNode;
import com.viztrend.safe.persistence.entity.AppInitConfig;
import com.viztrend.safe.persistence.repository.ActiveNodeRepository;
import com.viztrend.safe.persistence.repository.AppInitConfigRepository;
import com.viztrend.safe.persistence.repository.ScheduleLockRepository;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ScheduleLockAspect {
    @Autowired
    ScheduleLockRepository repository;
    @Autowired
    AppInitConfigRepository appInitConfigRepository;
    @Autowired
    ActiveNodeRepository activeNodeRepository;
    private static final Logger LOGGER = LoggerFactory.getLogger(ScheduleLockAspect.class);

    @Around(value="@annotation(com.viztrend.safe.annotations.SchedLock)")
    public void around(ProceedingJoinPoint pjp) throws Throwable {
        try {
            if (PropertyValidator.isValid((Collection)this.appInitConfigRepository.findAll())) {
                AppInitConfig appInitConfig = (AppInitConfig)this.appInitConfigRepository.findAll().get(0);
                if (appInitConfig.isEnableMultiNode()) {
                    List activeNodes = this.activeNodeRepository.findAll();
                    if (PropertyValidator.isValid((Collection)activeNodes)) {
                        activeNodes.sort(Comparator.comparingLong(ActiveNode::getCreatedAt));
                        if (((ActiveNode)activeNodes.get(0)).getNodeId().equals(ReadDbPropertiesPostInit.nodeId)) {
                            pjp.proceed();
                        }
                    } else {
                        LOGGER.debug("No Node available for Primary selection ");
                    }
                } else {
                    pjp.proceed();
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
    }

    private static String initHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "unknown";
        }
    }
}

