/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.alm.jira.bo;

import com.viztrend.safe.alm.jira.bo.JiraStatusCategory;
import com.viztrend.safe.persistence.entity.AlmAccount;
import com.viztrend.safe.persistence.entity.Status;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.repository.StatusRepository;
import com.viztrend.safe.utils.AlmUtils;
import com.viztrend.safe.utils.PropertyValidator;
import java.io.Serializable;
import org.bson.types.ObjectId;

public class JiraStatus
implements Serializable {
    private static final long serialVersionUID = -6460999900602589727L;
    private String id;
    private String self;
    private String name;
    private String description;
    private JiraStatusCategory statusCategory;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getSelf() {
        return this.self;
    }

    public void setSelf(String self) {
        this.self = self;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public JiraStatusCategory getStatusCategory() {
        return this.statusCategory;
    }

    public void setStatusCategory(JiraStatusCategory statusCategory) {
        this.statusCategory = statusCategory;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("JiraStatus [");
        if (this.name != null) {
            builder.append("name=");
            builder.append(this.name);
            builder.append(", ");
        }
        if (this.statusCategory != null) {
            builder.append("statusCategory=");
            builder.append(this.statusCategory);
            builder.append(", ");
        }
        if (this.id != null) {
            builder.append("id=");
            builder.append(this.id);
            builder.append(", ");
        }
        if (this.description != null) {
            builder.append("description=");
            builder.append(this.description);
        }
        builder.append("]");
        return builder.toString();
    }

    public Status convertToKendisStatus(String project, String issueType) {
        Status itemStatus = new Status();
        itemStatus.setSuspendActivity(true);
        itemStatus.setJiraProjKey(project);
        itemStatus.setJiraIssueTypeId(issueType);
        itemStatus.setJiraStatusCatId(this.getStatusCategory().getId());
        itemStatus.setJiraStatusId(this.getId());
        itemStatus.setTitle(this.getName());
        itemStatus.setCategory(AlmUtils.getMappedStatusCategory((String)this.getStatusCategory().getKey()));
        itemStatus.setJiraStatusOriginalCategory(itemStatus.getCategory());
        return itemStatus;
    }

    public Status parseStatus(String pKey, String typeId, AlmAccount alm, User user, StatusRepository statusRepository) {
        Status status = statusRepository.findByJiraProjKeyAndJiraIssueTypeIdAndJiraStatusIdAndAlmId(pKey, typeId, this.getId(), alm.getId());
        if (!PropertyValidator.isValid((Object)status)) {
            status = this.convertToKendisStatus(pKey, typeId);
            status.setId(ObjectId.get().toString());
            status.setAlmId(alm.getId());
            if (user != null) {
                status.setTenant(user.getTenant());
            }
            status = (Status)statusRepository.save((Object)status);
        }
        return status;
    }
}

