/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.alm.jira.bo;

import com.mongodb.DBObject;
import com.viztrend.safe.alm.entity.BaseALMEntity;
import com.viztrend.safe.annotations.PushField;
import java.io.Serializable;
import org.springframework.data.annotation.Transient;

public class JiraIssueLinkType
extends BaseALMEntity
implements Serializable {
    private static final long serialVersionUID = -269240084970162926L;
    private String self;
    @PushField
    private String name = "";
    @PushField
    private String inward = "";
    @PushField
    private String outward = "";
    @PushField
    private String direction;
    private String generatedId;
    private String issueTypeStr;
    private String almAccountId;
    @Transient
    private Boolean reverse;

    public JiraIssueLinkType(String jiraId, String self, String name, String inward, String outward, String direction) {
        this.self = self;
        this.name = name;
        this.inward = inward;
        this.outward = outward;
        this.jiraId = jiraId;
        this.direction = direction;
    }

    public JiraIssueLinkType(DBObject item) {
        this.self = (String)item.get("self");
        this.name = (String)item.get("name");
        this.inward = (String)item.get("inward");
        this.outward = (String)item.get("outward");
        this.jiraId = (String)item.get("jiraId");
        this.direction = (String)item.get("direction");
    }

    public void putJiraIssueLinkType(String generatedId, Boolean reverse) {
        String[] id = generatedId.split("-");
        if (id.length > 0) {
            this.jiraId = id[0];
            if (id.length > 1) {
                this.direction = id[1];
            }
        }
        this.reverse = reverse;
    }

    public JiraIssueLinkType() {
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.inward == null ? 0 : this.inward.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.outward == null ? 0 : this.outward.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JiraIssueLinkType)) {
            return false;
        }
        if (!(obj instanceof BaseALMEntity)) {
            return false;
        }
        JiraIssueLinkType other = (JiraIssueLinkType)obj;
        if (this.jiraId == null ? other.jiraId != null : !this.jiraId.equals(other.jiraId)) {
            return false;
        }
        if (this.mongoId == null) {
            if (other.mongoId != null) {
                return false;
            }
        } else {
            if (!this.mongoId.equals(other.mongoId)) {
                return false;
            }
            if (this.tenant == null ? other.tenant != null : !this.tenant.equals(other.tenant)) {
                return false;
            }
        }
        return true;
    }

    public String getSelf() {
        return this.self;
    }

    public void setSelf(String self) {
        this.self = self;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getInward() {
        return this.inward;
    }

    public void setInward(String inward) {
        this.inward = inward;
    }

    public String getOutward() {
        return this.outward;
    }

    public void setOutward(String outward) {
        this.outward = outward;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("JiraIssueLinkType [");
        if (this.getJiraId() != null) {
            builder.append("jiraId=");
            builder.append(this.getJiraId());
            builder.append(", ");
        }
        if (this.name != null) {
            builder.append("name=");
            builder.append(this.name);
            builder.append(", ");
        }
        if (this.inward != null) {
            builder.append("inward=");
            builder.append(this.inward);
            builder.append(", ");
        }
        if (this.outward != null) {
            builder.append("outward=");
            builder.append(this.outward);
            builder.append(", ");
        }
        if (this.self != null) {
            builder.append("self=");
            builder.append(this.self);
        }
        builder.append("]");
        return builder.toString();
    }

    public String getDirection() {
        return this.direction;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    public String getIssueTypeStr() {
        return this.issueTypeStr;
    }

    public void setIssueTypeStr(String issueTypeStr) {
        this.issueTypeStr = issueTypeStr;
    }

    public String getAlmAccountId() {
        return this.almAccountId;
    }

    public void setAlmAccountId(String almAccountId) {
        this.almAccountId = almAccountId;
    }

    public String getGeneratedId() {
        return this.generatedId;
    }

    public void setGeneratedId(String generatedId) {
        this.generatedId = generatedId;
    }

    public Boolean getReverse() {
        return this.reverse;
    }

    public void setReverse(Boolean reverse) {
        this.reverse = reverse;
    }
}

