/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.alm.jira.bo;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.viztrend.safe.alm.jira.bo.JiraUser;
import com.viztrend.safe.persistence.entity.BacklogMappingLinks;
import com.viztrend.safe.persistence.entity.BaseEntity;
import com.viztrend.safe.persistence.entity.IssueType;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.utils.PropertyValidator;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.mapping.DBRef;

@JsonIgnoreProperties(ignoreUnknown=true)
public class JiraFilter
extends BaseEntity
implements Serializable {
    private static final long serialVersionUID = 9107155790630311144L;
    private String expand;
    private String self;
    private String key;
    private String jql;
    private String name;
    private String viewUrl;
    private String searchUrl;
    private String filterType;
    private Boolean favourite;
    private Integer favouritedCount;
    private JiraUser owner;
    private List<BacklogMappingLinks> featureLinkMappings;
    private Boolean custom = Boolean.FALSE;
    private boolean enabler;
    private Boolean isNexus = Boolean.FALSE;
    private Date lastSyncDate;
    @Transient
    private boolean individualSync;
    @Transient
    private String childQuery;
    @Transient
    private List<List<String>> issueKeys;
    @DBRef
    private User filterFetchedBy;
    @DBRef
    private IssueType issueType;
    private Map<String, Boolean> childIssueTypes;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public JiraFilter() {
    }

    public JiraFilter(String id) {
        this.id = id;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JiraFilter)) {
            return false;
        }
        JiraFilter other = (JiraFilter)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("JiraFilter [");
        if (this.id != null) {
            builder.append("id=");
            builder.append(this.id);
            builder.append(", ");
        }
        if (this.key != null) {
            builder.append("key=");
            builder.append(this.key);
            builder.append(", ");
        }
        if (this.jql != null) {
            builder.append("jql=");
            builder.append(this.jql);
            builder.append(", ");
        }
        if (this.name != null) {
            builder.append("name=");
            builder.append(this.name);
            builder.append(", ");
        }
        if (this.viewUrl != null) {
            builder.append("viewUrl=");
            builder.append(this.viewUrl);
            builder.append(", ");
        }
        if (this.searchUrl != null) {
            builder.append("searchUrl=");
            builder.append(this.searchUrl);
            builder.append(", ");
        }
        if (this.favourite != null) {
            builder.append("favourite=");
            builder.append(this.favourite);
            builder.append(", ");
        }
        if (this.favouritedCount != null) {
            builder.append("favouritedCount=");
            builder.append(this.favouritedCount);
            builder.append(", ");
        }
        if (this.owner != null) {
            builder.append("owner=");
            builder.append(this.owner);
        }
        builder.append("]");
        return builder.toString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getExpand() {
        return this.expand;
    }

    public void setExpand(String expand) {
        this.expand = expand;
    }

    public String getSelf() {
        return this.self;
    }

    public void setSelf(String self) {
        this.self = self;
    }

    public String getJql() {
        return this.jql;
    }

    public void setJql(String jql) {
        this.jql = jql;
    }

    public String getViewUrl() {
        return this.viewUrl;
    }

    public void setViewUrl(String viewUrl) {
        this.viewUrl = viewUrl;
    }

    public String getSearchUrl() {
        return this.searchUrl;
    }

    public void setSearchUrl(String searchUrl) {
        this.searchUrl = searchUrl;
    }

    public Boolean getFavourite() {
        return this.favourite;
    }

    public void setFavourite(Boolean favourite) {
        this.favourite = favourite;
    }

    public Integer getFavouritedCount() {
        return this.favouritedCount;
    }

    public void setFavouritedCount(Integer favouritedCount) {
        this.favouritedCount = favouritedCount;
    }

    public JiraUser getOwner() {
        return this.owner;
    }

    public void setOwner(JiraUser owner) {
        this.owner = owner;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public List<BacklogMappingLinks> getFeatureLinkMappings() {
        return this.featureLinkMappings;
    }

    public void setFeatureLinkMappings(List<BacklogMappingLinks> featureLinkMappings) {
        this.featureLinkMappings = featureLinkMappings;
    }

    public boolean isEnabler() {
        return this.enabler;
    }

    public void setEnabler(boolean enabler) {
        this.enabler = enabler;
    }

    public IssueType getIssueType() {
        return this.issueType;
    }

    public void setIssueType(IssueType issueType) {
        this.issueType = issueType;
    }

    public boolean isIndividualSync() {
        return this.individualSync;
    }

    public void setIndividualSync(boolean individualSync) {
        this.individualSync = individualSync;
    }

    public Boolean getCustom() {
        return this.custom;
    }

    public void setCustom(Boolean custom) {
        this.custom = custom;
    }

    public Boolean getIsNexus() {
        return this.isNexus;
    }

    public void setIsNexus(Boolean isNexus) {
        this.isNexus = isNexus;
    }

    public Map<String, Boolean> getChildIssueTypes() {
        return this.childIssueTypes;
    }

    public void setChildIssueTypes(Map<String, Boolean> childIssueTypes) {
        this.childIssueTypes = childIssueTypes;
    }

    public User getFilterFetchedBy() {
        if (PropertyValidator.isValid((Object)this.filterFetchedBy)) {
            return new User(this.filterFetchedBy.getId(), this.filterFetchedBy.getUserName(), this.filterFetchedBy.getFullName(), this.filterFetchedBy.getFirstName(), this.filterFetchedBy.getLastName(), this.filterFetchedBy.getEmail(), this.filterFetchedBy.getAlmCredentials());
        }
        return this.filterFetchedBy;
    }

    public void setFilterFetchedBy(User filterFetchedBy) {
        if (PropertyValidator.isValid((Object)filterFetchedBy)) {
            this.filterFetchedBy = new User(filterFetchedBy.getId(), filterFetchedBy.getUserName(), filterFetchedBy.getFullName(), filterFetchedBy.getFirstName(), filterFetchedBy.getLastName(), filterFetchedBy.getEmail(), filterFetchedBy.getAlmCredentials());
        }
    }

    public String lastUpdate() {
        Long sec;
        if (this.lastSyncDate != null && (sec = Long.valueOf(System.currentTimeMillis() - this.lastSyncDate.getTime())) > 0L) {
            return "updated > -" + (TimeUnit.MILLISECONDS.toMinutes(sec) + 1L) + "m";
        }
        return "";
    }

    public String query() {
        if (!Boolean.TRUE.equals(this.custom) && PropertyValidator.isValid((Object)this.id)) {
            return "filter = " + this.id;
        }
        int index = this.jql.toUpperCase().indexOf(" ORDER BY ");
        if (index > -1) {
            return this.jql.subSequence(0, index).toString();
        }
        return this.jql;
    }

    public String getFilterType() {
        return this.filterType;
    }

    public void setFilterType(String filterType) {
        this.filterType = filterType;
    }

    public Date getLastSyncDate() {
        return this.lastSyncDate;
    }

    public void setLastSyncDate(Date lastSyncDate) {
        this.lastSyncDate = lastSyncDate;
    }

    public String getChildQuery() {
        return this.childQuery;
    }

    public void setChildQuery(String childQuery) {
        this.childQuery = childQuery;
    }

    public List<List<String>> getIssueKeys() {
        return this.issueKeys;
    }

    public void setIssueKeys(List<List<String>> issueKeys) {
        this.issueKeys = issueKeys;
    }
}

