/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.alm.jira;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.viztrend.exception.ViztrendJiraException;
import com.viztrend.safe.alm.jira.ImportUtil;
import com.viztrend.safe.alm.jira.JiraUtils;
import com.viztrend.safe.alm.jira.bo.JiraBoard;
import com.viztrend.safe.alm.jira.bo.JiraBoardConfig;
import com.viztrend.safe.alm.jira.bo.JiraBoardLocation;
import com.viztrend.safe.alm.jira.bo.JiraBoardWrapper;
import com.viztrend.safe.alm.jira.bo.JiraConnect;
import com.viztrend.safe.alm.jira.bo.JiraData;
import com.viztrend.safe.alm.jira.bo.JiraField;
import com.viztrend.safe.alm.jira.bo.JiraFilter;
import com.viztrend.safe.alm.jira.bo.JiraFilterWrapper;
import com.viztrend.safe.alm.jira.bo.JiraIssueType;
import com.viztrend.safe.alm.jira.bo.JiraProject;
import com.viztrend.safe.alm.jira.bo.JiraProjectWrapper;
import com.viztrend.safe.alm.jira.bo.JiraSearch2;
import com.viztrend.safe.alm.jira.bo.JiraSprint;
import com.viztrend.safe.alm.jira.bo.JiraSprintListWrapper;
import com.viztrend.safe.alm.jira.bo.JiraUser;
import com.viztrend.safe.alm.jira.bo.JiraUserGroup;
import com.viztrend.safe.alm.jira.bo.JiraUserGroupSearch;
import com.viztrend.safe.alm.jira.bo.JiraUserSearch;
import com.viztrend.safe.alm.jira.bo.JiraUsersSearch;
import com.viztrend.safe.alm.jira.bo.JiraVersion;
import com.viztrend.safe.persistence.entity.AlmAccount;
import com.viztrend.safe.persistence.entity.AlmError;
import com.viztrend.safe.utils.EncDecUtility;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class ImportUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImportUtil.class);
    @Autowired
    private Environment ENV;

    public List<JiraSprint> retrieveJiraBoardFutureSprints(String boardId, String url, String username, String password, AlmAccount almAcc) {
        String _url = "/rest/agile/1.0/board/" + boardId + "/sprint/";
        LOGGER.debug("URL: " + _url);
        ArrayList<JiraSprint> jSprints = new ArrayList<JiraSprint>();
        try {
            JiraSprintListWrapper searchResult;
            String access = username + ":" + password;
            Gson gson = new Gson();
            int startAt = 0;
            do {
                String result = this.executeJiraGetRequest(_url, access, almAcc, "?startAt=" + startAt + "&state=future,active,closed");
                searchResult = (JiraSprintListWrapper)gson.fromJson(result, JiraSprintListWrapper.class);
                jSprints.addAll(searchResult.getValues());
                startAt += 50;
            } while (!searchResult.getIsLast().booleanValue());
        }
        catch (Exception ex) {
            LOGGER.error("FAILED: retrieveJiraBoardFutureSprints -->" + ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        return jSprints;
    }

    public List<JiraSprint> retrieveJiraBoardAllSprints(String boardId, String url, String username, String password, AlmAccount almAcc) {
        String _url = "/rest/agile/1.0/board/" + boardId + "/sprint";
        LOGGER.debug("URL: " + _url);
        ArrayList<JiraSprint> jSprints = new ArrayList<JiraSprint>();
        try {
            JiraSprintListWrapper searchResult;
            String access = username + ":" + password;
            Gson gson = new Gson();
            int startAt = 0;
            do {
                String result = this.executeJiraGetRequest(_url, access, almAcc, "?startAt=" + startAt + "&state=future,active,closed");
                searchResult = (JiraSprintListWrapper)gson.fromJson(result, JiraSprintListWrapper.class);
                jSprints.addAll(searchResult.getValues());
                startAt += 50;
            } while (!searchResult.getIsLast().booleanValue());
        }
        catch (Exception ex) {
            LOGGER.error("FAILED: retrieveJiraBoardAllSprints -->" + ex.getMessage(), (Throwable)ex);
        }
        return jSprints;
    }

    public String retrieveProjectDetails(String projectIdOrKey, String url, String username, String password) {
        return this.retrieveProjectDetails(projectIdOrKey, url, username, password, null);
    }

    public String retrieveItemSynapseChildren(String itemKey, AlmAccount almAccount) {
        String _url = "/rest/synapse/latest/public/requirement/" + itemKey + "/getOnlyImmediateChildren";
        String params = "";
        String result = JiraUtils.executeJiraGetRequest((String)_url, (String)almAccount.getUsername(), (String)almAccount.getPassword(), (AlmAccount)almAccount, (String)params, (Environment)this.ENV);
        return result;
    }

    public String retrieveProjectDetails(String projectIdOrKey, String url, String username, String password, AlmAccount almAcc) {
        String _url = "/rest/api/2/project/" + projectIdOrKey;
        String params = "?expand=issueTypes";
        String result = JiraUtils.executeJiraGetRequest((String)_url, (String)username, (String)password, (AlmAccount)almAcc, (String)params, (Environment)this.ENV);
        return result;
    }

    public String retrieveJiraIssueTypes(String url, String username, String password, AlmAccount almAcc) {
        String _url = "/rest/api/2/issuetype";
        String params = null;
        String result = JiraUtils.executeJiraGetRequest((String)_url, (String)username, (String)password, (AlmAccount)almAcc, params, (Environment)this.ENV);
        return result;
    }

    public String retrieveJiraIssueTypesByIssueType(AlmAccount almAcc) {
        String _url = "/rest/internal/3/issuetype/search";
        String access = almAcc.getUsername() + ":" + almAcc.getPassword();
        int startAt = 0;
        int maxResult = 15;
        String orderBy = "type";
        JSONArray fieldsJSONArray = new JSONArray();
        String result = null;
        boolean isLast = false;
        do {
            result = this.executeJiraGetRequest(_url, access, almAcc, "?maxResults=" + maxResult + "&orderBy=-" + orderBy + "&startAt=" + startAt);
            JSONObject fieldsArray = new JSONObject(result);
            isLast = fieldsArray.getBoolean("isLast");
            if (PropertyValidator.isValid((Object)fieldsArray.getJSONArray("values"))) {
                JSONArray valuesArray = fieldsArray.getJSONArray("values");
                for (int i = 0; i < valuesArray.length(); ++i) {
                    fieldsJSONArray.put((Object)valuesArray.getJSONObject(i));
                }
            }
            startAt += 15;
        } while (!isLast);
        if (fieldsJSONArray.length() == 0) {
            return this.retrieveJiraIssueTypes("", almAcc.getUsername(), almAcc.getPassword(), almAcc);
        }
        return fieldsJSONArray.toString();
    }

    public List<JiraField> retrieveJiraFieldsList(String url, String username, String password) {
        return this.retrieveJiraFieldsList(url, username, password, null);
    }

    public String validateJiraUser(String url, String username, String password, AlmAccount almAcc) {
        String _url = "/rest/api/2/myself";
        LOGGER.debug("URL: " + _url);
        String access = username + ":" + password;
        String result = this.executeJiraGetRequest(_url, access, almAcc, null);
        return result;
    }

    public List<JiraField> retrieveJiraFieldsList(String url, String username, String password, AlmAccount almAcc) {
        Gson gson = new Gson();
        String _url = "/rest/api/2/field";
        LOGGER.debug("URL: " + _url);
        String access = username + ":" + password;
        String result = this.executeJiraGetRequest(_url, access, almAcc, null);
        1 T = new /* Unavailable Anonymous Inner Class!! */;
        if (result != null) {
            Collection searchResult = (Collection)gson.fromJson(result, T.getType());
            ArrayList<JiraField> jFields = new ArrayList<JiraField>(searchResult);
            return jFields;
        }
        return null;
    }

    public String retrieveJiraFieldsJSON(String url, String username, String password, AlmAccount almAcc) {
        String _url = "/rest/api/2/field";
        LOGGER.debug("URL: " + _url);
        String access = username + ":" + password;
        String result = this.executeJiraGetRequest(_url, access, almAcc, null);
        return result;
    }

    public String retrieveJiraProjectCreateMeta(AlmAccount almAcc, String projectKey) {
        String _url = "/rest/api/2/issue/createmeta";
        String params = "?expand=projects.issuetypes.fields";
        if (PropertyValidator.isValid((Object)projectKey)) {
            params = params + "&projectKeys=" + projectKey;
        }
        LOGGER.debug("URL: " + _url);
        String access = almAcc.getUsername() + ":" + almAcc.getPassword();
        String result = this.executeJiraGetRequest(_url, access, almAcc, params);
        return result;
    }

    public HashMap<String, Object> retrieveCreateMetaByProjectAndIssueType(String projectIdOrKey, String issueTypeId, AlmAccount almAcc) {
        String _url = "/rest/api/2/issue/createmeta/" + projectIdOrKey + "/issuetypes/" + issueTypeId;
        String params = "";
        LOGGER.debug("URL: " + _url);
        String access = almAcc.getUsername() + ":" + almAcc.getPassword();
        int startAt = 0;
        HashMap<String, Object> fieldsJSONMap = new HashMap<String, Object>();
        String result = null;
        boolean isLast = false;
        do {
            result = this.executeJiraGetRequest(_url, access, almAcc, "?startAt=" + startAt);
            JSONObject fieldsArray = new JSONObject(result);
            isLast = fieldsArray.getBoolean("isLast");
            if (PropertyValidator.isValid((Object)fieldsArray.getJSONArray("values"))) {
                JSONArray valuesArray = fieldsArray.getJSONArray("values");
                for (int i = 0; i < valuesArray.length(); ++i) {
                    String key = "key";
                    if (!valuesArray.getJSONObject(i).isNull(key)) {
                        key = valuesArray.getJSONObject(i).getString(key);
                    } else if (!valuesArray.getJSONObject(i).isNull("fieldId")) {
                        key = valuesArray.getJSONObject(i).getString("fieldId");
                    }
                    fieldsJSONMap.put(key, valuesArray.getJSONObject(i));
                }
            }
            startAt += 50;
        } while (!isLast);
        return fieldsJSONMap;
    }

    public String retrieveTrimmedJiraProjectCreateMeta(AlmAccount almAcc, String projectKey) {
        String _url = "/rest/api/2/issue/createmeta";
        String params = "";
        if (PropertyValidator.isValid((Object)projectKey)) {
            params = params + "/" + projectKey + "/issuetypes";
        }
        LOGGER.debug("URL: " + _url);
        String access = almAcc.getUsername() + ":" + almAcc.getPassword();
        String result = this.executeJiraGetRequest(_url, access, almAcc, params);
        return result;
    }

    public List<JiraField> retrieveJiraFieldsListPreview(String url, String username, String password, AlmAccount almAcc) {
        Gson gson = new Gson();
        String _url = "/rest/api/2/field";
        LOGGER.debug("URL: " + _url);
        String result = JiraUtils.executeJiraPostRequest((String)_url, (String)username, (String)password, (AlmAccount)almAcc, (String)"", (String)"", (Environment)this.ENV);
        2 T = new /* Unavailable Anonymous Inner Class!! */;
        if (result != null) {
            Collection searchResult = (Collection)gson.fromJson(result, T.getType());
            ArrayList<JiraField> jFields = new ArrayList<JiraField>(searchResult);
            return jFields;
        }
        return null;
    }

    public List<JiraProject> retrieveJiraProjectsListByKeys(String username, String password, AlmAccount almAcc, Set<String> projectKeys) {
        ArrayList<JiraProject> projects = new ArrayList<JiraProject>();
        String _url = "/rest/api/3/project/search";
        String access = username + ":" + password;
        LOGGER.debug("URL: " + _url);
        String result = null;
        JiraProjectWrapper searchResult = null;
        projects = new ArrayList();
        Gson gson = new Gson();
        String projectQuery = "expand=issueTypes&";
        3 T = new /* Unavailable Anonymous Inner Class!! */;
        try {
            if (almAcc.isUsingJiraConnect()) {
                this.retrieveJiraProjectsListByKeysOneByOne(username, password, almAcc, projectKeys, access, gson, (TypeToken)T, projects);
            } else if (almAcc.getUrl().contains("atlassian.net")) {
                for (String pKey : projectKeys) {
                    projectQuery = projectQuery + "keys=" + pKey + "&";
                }
                projectQuery = projectQuery.substring(0, projectQuery.length() - 1);
                result = this.executeJiraGetRequest(_url, access, almAcc, "?" + projectQuery);
                searchResult = (JiraProjectWrapper)gson.fromJson(result, JiraProjectWrapper.class);
                projects.addAll(searchResult.getValues());
            } else {
                this.retrieveJiraProjectsListByKeysOneByOne(username, password, almAcc, projectKeys, access, gson, (TypeToken)T, projects);
            }
        }
        catch (Exception ex) {
            LOGGER.error("Failed: retrieveJiraProjectsList by keys --> ", (Throwable)ex);
        }
        return projects;
    }

    private void retrieveJiraProjectsListByKeysOneByOne(String username, String password, AlmAccount almAcc, Set<String> projectKeys, String access, Gson gson, TypeToken<JiraProject> T, List<JiraProject> projects) {
        String result = null;
        LOGGER.info("Failed To get ALL Projects By keys --> ");
        for (String key : projectKeys) {
            String _url = "/rest/api/2/project/" + key;
            try {
                result = this.executeJiraGetRequest(_url, access, almAcc, null);
                JiraProject filter = (JiraProject)gson.fromJson(result, (T = new /* Unavailable Anonymous Inner Class!! */).getType());
                if (!PropertyValidator.isValid((Object)filter)) continue;
                projects.add(filter);
            }
            catch (ViztrendJiraException ve) {
                LOGGER.error("Failed: retrieveJiraProjectsList --> " + _url, (Throwable)ve);
                throw ve;
            }
        }
    }

    public HashMap<String, Object> retrievePaginatedJiraProjectsList(AlmAccount almAcc, String projectName, int startAt) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        ArrayList projects = new ArrayList();
        String username = almAcc.getUsername();
        String password = almAcc.getPassword();
        String _url = "/rest/api/3/project/search";
        String access = username + ":" + password;
        LOGGER.debug("URL: " + _url);
        String result = null;
        JiraProjectWrapper searchResult = null;
        projects = new ArrayList();
        Gson gson = new Gson();
        5 T = new /* Unavailable Anonymous Inner Class!! */;
        try {
            if (!projectName.isEmpty() && almAcc.getUrl().contains("atlassian.net")) {
                result = this.executeJiraGetRequest(_url, access, almAcc, "?startAt=" + startAt + "&query=" + URLEncoder.encode(projectName, "UTF-8"));
                searchResult = (JiraProjectWrapper)gson.fromJson(result, JiraProjectWrapper.class);
                projects.addAll(searchResult.getValues());
            } else if (almAcc.getUrl().contains("atlassian.net")) {
                result = this.executeJiraGetRequest(_url, access, almAcc, "?startAt=" + startAt);
                searchResult = (JiraProjectWrapper)gson.fromJson(result, JiraProjectWrapper.class);
                projects.addAll(searchResult.getValues());
            } else {
                _url = "/rest/api/2/project";
                result = this.executeJiraGetRequest(_url, access, almAcc, null);
                Collection filtersColection = (Collection)gson.fromJson(result, (T = new /* Unavailable Anonymous Inner Class!! */).getType());
                if (PropertyValidator.isValid((Collection)filtersColection)) {
                    projects = new ArrayList(filtersColection);
                }
            }
            response.put("projects", projects);
            if (searchResult != null) {
                response.put("totalProjects", searchResult.getTotal());
            }
        }
        catch (ViztrendJiraException ve) {
            LOGGER.error("Failed: retrievePaginatedJiraProjectsList --> " + _url, (Throwable)ve);
            throw ve;
        }
        catch (Exception ex) {
            LOGGER.error("Failed To get ALL Projects. --> " + _url);
        }
        return response;
    }

    public List<JiraProject> retrieveJiraProjectsList(String url, String username, String password, AlmAccount almAcc) {
        ArrayList<Object> projects = new ArrayList<JiraProject>();
        String _url = "/rest/api/3/project/search";
        String access = username + ":" + password;
        LOGGER.debug("URL: " + _url);
        String result = null;
        JiraProjectWrapper searchResult = null;
        projects = new ArrayList();
        Gson gson = new Gson();
        7 T = new /* Unavailable Anonymous Inner Class!! */;
        try {
            int startAt = 0;
            do {
                result = this.executeJiraGetRequest(_url, access, almAcc, "?startAt=" + startAt);
                searchResult = (JiraProjectWrapper)gson.fromJson(result, JiraProjectWrapper.class);
                projects.addAll(searchResult.getValues());
                startAt += 50;
            } while (!searchResult.getIsLast().booleanValue());
        }
        catch (Exception ex) {
            LOGGER.info("Failed To get ALL Projects. --> " + _url);
            _url = "/rest/api/2/project";
            LOGGER.info("Now going to fetch All projects using " + _url);
            try {
                result = this.executeJiraGetRequest(_url, access, almAcc, null);
                T = new /* Unavailable Anonymous Inner Class!! */;
                Collection filtersColection = (Collection)gson.fromJson(result, T.getType());
                if (PropertyValidator.isValid((Collection)filtersColection)) {
                    projects = new ArrayList(filtersColection);
                }
            }
            catch (ViztrendJiraException ve) {
                LOGGER.error("Failed: retrieveJiraProjectsList --> " + _url, (Throwable)ve);
                throw ve;
            }
        }
        return projects;
    }

    public List<JiraBoard> retrieveJiraBoards(String url, String username, String password) {
        return this.retrieveJiraBoards(url, username, password, null);
    }

    public List<JiraBoard> retrieveJiraBoards(String url, String username, String password, AlmAccount almAcc) {
        String jbUrl = "/rest/agile/1.0/board";
        ArrayList<JiraBoard> jBoards = new ArrayList<JiraBoard>();
        try {
            Gson gson = new Gson();
            String access = username + ":" + password;
            String responseData = "";
            LOGGER.debug("URL: " + jbUrl);
            int startAt = 0;
            int pageSize = 50;
            JiraBoardWrapper boardWrapper = new JiraBoardWrapper();
            while (!boardWrapper.getIsLast().booleanValue()) {
                responseData = this.executeJiraGetRequest(jbUrl, access, almAcc, "?startAt=" + startAt + "&maxResults=" + pageSize);
                if (!PropertyValidator.isValid((Object)responseData)) {
                    LOGGER.error("FAILED: retrieveJiraBoards --> null response.");
                    break;
                }
                gson = new Gson();
                boardWrapper = (JiraBoardWrapper)gson.fromJson(responseData, JiraBoardWrapper.class);
                jBoards.addAll(boardWrapper.getValues());
                startAt += pageSize;
            }
        }
        catch (Exception ex) {
            LOGGER.error("FAILED: retrieveJiraBoards -->" + ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        return jBoards;
    }

    public HashMap<String, Object> retrievePaginatedJiraBoards(AlmAccount almAcc, String boardName, int startAt) throws Exception {
        String jbUrl = "/rest/agile/1.0/board";
        ArrayList jBoards = new ArrayList();
        HashMap<String, Object> response = new HashMap<String, Object>();
        Gson gson = new Gson();
        String access = almAcc.getUsername() + ":" + almAcc.getPassword();
        String responseData = "";
        LOGGER.debug("URL: " + jbUrl);
        int pageSize = 50;
        JiraBoardWrapper boardWrapper = new JiraBoardWrapper();
        if (!boardName.isEmpty()) {
            boardName = URLEncoder.encode(boardName, "UTF-8");
            responseData = this.executeJiraGetRequest(jbUrl, access, almAcc, "?startAt=" + startAt + "&maxResults=" + pageSize + "&name=" + URLEncoder.encode(boardName, "UTF-8"));
        } else {
            responseData = this.executeJiraGetRequest(jbUrl, access, almAcc, "?startAt=" + startAt + "&maxResults=" + pageSize);
        }
        if (PropertyValidator.isValid((Object)responseData)) {
            gson = new Gson();
            boardWrapper = (JiraBoardWrapper)gson.fromJson(responseData, JiraBoardWrapper.class);
            jBoards.addAll(boardWrapper.getValues());
            response.put("boards", boardWrapper.getValues());
            response.put("totalBoards", boardWrapper.getTotal());
        } else {
            LOGGER.error("FAILED: retrieveJiraBoards --> null response.");
        }
        return response;
    }

    public JiraBoard retrieveJiraBoardDetails(JiraBoard jboard, String url, String username, String password) {
        return this.retrieveJiraBoardDetails(jboard, url, username, password, null);
    }

    public JiraBoard retrieveJiraBoardDetails(JiraBoard jboard, String url, String username, String password, AlmAccount almAcc) {
        try {
            String result;
            Gson gson = new Gson();
            if (PropertyValidator.isValid((Object)jboard) && PropertyValidator.isValid((Object)(result = this.retrieveBoardConfig(jboard.getJiraId(), url, username, password, null)))) {
                List boardSprints;
                JiraBoardConfig bConfig = (JiraBoardConfig)gson.fromJson(result, JiraBoardConfig.class);
                JiraBoardLocation loc = bConfig.getLocation();
                if (PropertyValidator.isValid((Object)(result = this.retrieveProjectDetails(loc.getId(), url, username, password, null)))) {
                    jboard.setLocationProject((JiraProject)gson.fromJson(result, JiraProject.class));
                }
                if (PropertyValidator.isValid((Collection)(boardSprints = this.retrieveJiraBoardFutureSprints(jboard.getJiraId(), url, username, password, null)))) {
                    jboard.setBoardSprints(boardSprints);
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("FAILED: retrieveJiraBoards -->" + ex.getMessage(), (Throwable)ex);
        }
        return jboard;
    }

    public String retrieveBoardConfig(String boardId, String url, String username, String password, AlmAccount almAcc) {
        String bcUrl = "/rest/agile/1.0/board/" + boardId + "/configuration";
        LOGGER.info("URL: " + bcUrl);
        String access = username + ":" + password;
        String result = this.executeJiraGetRequest(bcUrl, access, almAcc, null);
        return result;
    }

    public String retrieveBoardProjects(String boardId, String url, String username, String password, AlmAccount almAcc) {
        String bcUrl = "/rest/agile/1.0/board/" + boardId + "/project";
        LOGGER.info("URL: " + bcUrl);
        String access = username + ":" + password;
        String result = this.executeJiraGetRequest(bcUrl, access, almAcc, null);
        return result;
    }

    public Map<String, String> retrieveFiltersList(String url, String username, String password, AlmAccount almAcc) {
        String _url = "/rest/api/2/filter";
        String access = username + ":" + password;
        String result = null;
        HashMap<String, String> resultMap = new HashMap<String, String>();
        try {
            result = this.executeJiraGetRequest(_url, access, almAcc, null);
            resultMap.put("filters", result);
            resultMap.put("favourite", Boolean.toString(false));
        }
        catch (Exception e) {
            LOGGER.info("Failed To get ALL filters. going for favourite Filters NOW******************: ");
            _url = "/rest/api/2/filter/favourite";
            try {
                result = this.executeJiraGetRequest(_url, access, almAcc, null);
                resultMap.put("filters", result);
                resultMap.put("favourite", Boolean.toString(true));
            }
            catch (ViztrendJiraException ve) {
                LOGGER.error("Failed To get Favourite filters. ", (Throwable)ve);
                throw ve;
            }
        }
        return resultMap;
    }

    public HashMap<String, Object> retrievePaginatedFilters(String url, String username, String password, AlmAccount almAcc, String filterName, int startAt) {
        HashMap<String, Object> response;
        block8: {
            String _url = "/rest/api/2/filter/search";
            String access = username + ":" + password;
            String result = null;
            ArrayList jiraFilters = new ArrayList();
            Gson gson = new Gson();
            response = new HashMap<String, Object>();
            JiraFilterWrapper searchResult = null;
            try {
                if (!filterName.isEmpty() && almAcc.getUrl().contains("atlassian.net")) {
                    result = this.executeJiraGetRequest(_url, access, almAcc, "?expand=jql&filterName=" + URLEncoder.encode(filterName, "UTF-8") + "&startAt=" + startAt);
                    searchResult = (JiraFilterWrapper)gson.fromJson(result, JiraFilterWrapper.class);
                    jiraFilters.addAll(searchResult.getValues());
                } else if (almAcc.getUrl().contains("atlassian.net")) {
                    result = this.executeJiraGetRequest(_url, access, almAcc, "?expand=jql&startAt=" + startAt);
                    searchResult = (JiraFilterWrapper)gson.fromJson(result, JiraFilterWrapper.class);
                    jiraFilters.addAll(searchResult.getValues());
                } else {
                    _url = "/rest/api/2/filter/favourite";
                    9 T = new /* Unavailable Anonymous Inner Class!! */;
                    result = this.executeJiraGetRequest(_url, access, almAcc, null);
                    Collection filtersColection = (Collection)gson.fromJson(result, T.getType());
                    if (PropertyValidator.isValid((Collection)filtersColection)) {
                        jiraFilters = new ArrayList(filtersColection);
                    }
                }
                response.put("filters", jiraFilters);
                if (searchResult != null) {
                    response.put("totalCount", searchResult.getTotal());
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed To get filters. ", (Throwable)e);
                if (!(e instanceof ViztrendJiraException)) break block8;
                throw (ViztrendJiraException)((Object)e);
            }
        }
        return response;
    }

    public List<JiraFilter> retrieveAllFilters(String url, String username, String password, AlmAccount almAcc) {
        String _url = "/rest/api/2/filter/search";
        String access = username + ":" + password;
        String result = null;
        ArrayList<Object> jiraFilters = new ArrayList<JiraFilter>();
        Gson gson = new Gson();
        try {
            JiraFilterWrapper searchResult;
            int startAt = 0;
            do {
                result = this.executeJiraGetRequest(_url, access, almAcc, "?expand=jql&startAt=" + startAt);
                searchResult = (JiraFilterWrapper)gson.fromJson(result, JiraFilterWrapper.class);
                jiraFilters.addAll(searchResult.getValues());
                startAt += 50;
            } while (!searchResult.getIsLast().booleanValue());
        }
        catch (Exception e) {
            LOGGER.info("Failed To get ALL filters. going for favourite Filters NOW******************: ");
            _url = "/rest/api/2/filter/favourite";
            try {
                result = this.executeJiraGetRequest(_url, access, almAcc, null);
                10 T = new /* Unavailable Anonymous Inner Class!! */;
                Collection filtersColection = (Collection)gson.fromJson(result, T.getType());
                if (PropertyValidator.isValid((Collection)filtersColection)) {
                    jiraFilters = new ArrayList(filtersColection);
                }
            }
            catch (ViztrendJiraException ve) {
                LOGGER.error("Failed To get Favourite filters. ", (Throwable)ve);
                throw ve;
            }
        }
        return jiraFilters;
    }

    public JiraFilter retrieveFilterByJiraId(String filterId, String username, String password, AlmAccount almAcc) {
        String _url = "/rest/api/2/filter/" + filterId;
        String access = username + ":" + password;
        String result = null;
        JiraFilter jiraFilter = new JiraFilter();
        Gson gson = new Gson();
        try {
            result = this.executeJiraGetRequest(_url, access, almAcc, "");
            jiraFilter = (JiraFilter)gson.fromJson(result, JiraFilter.class);
        }
        catch (ViztrendJiraException ve) {
            if (PropertyValidator.isValid((Object)ve.getCode()) && ve.getCode() == 401) {
                LOGGER.info("Jira Auth error******************: ");
            } else if (PropertyValidator.isValid((Object)ve.getMessage())) {
                HashMap json = (HashMap)gson.fromJson(ve.getMessage(), new /* Unavailable Anonymous Inner Class!! */.getType());
                json.put("filterId", filterId);
                ve.setMessage(gson.toJson((Object)json));
            }
            LOGGER.info("Failed To get filter by id. going for filter by id NOW******************: ");
            throw ve;
        }
        catch (Exception e) {
            LOGGER.info("Failed To get filter by id. going for filter by id NOW******************: ");
        }
        return jiraFilter;
    }

    public JiraSearch2 retrievePagedJiraDataAgainstFilter2(String url, String jql, String username, String password, String nextPageToken, int startAt, int pageSize, Gson gson, List<JiraField> fields, AlmAccount almAcc) {
        String responseData;
        JiraSearch2 searchList = null;
        JSONObject body = this.buildPayloadForJiraSerach(jql, fields, pageSize, nextPageToken, false);
        String _url = JiraUtils.decideSearchAPI((String)"/rest/api/3/search/jql", (boolean)almAcc.cloud(), (JSONObject)body, (int)startAt);
        if (nextPageToken == null) {
            LOGGER.debug("Inside  retrievePagedJiraDataAgainstFilter2. body = " + body);
        }
        if (PropertyValidator.isValid((Object)(searchList = (JiraSearch2)(gson = new Gson()).fromJson(responseData = JiraUtils.executeJiraPostRequest((String)_url, (String)username, (String)password, (AlmAccount)almAcc, (String)body.toString(), (String)"", (Environment)this.ENV), JiraSearch2.class)))) {
            return searchList;
        }
        return null;
    }

    public String retrievePagedJiraDataAgainstFilter(String url, String jql, String username, String password, int startAt, int pageSize, Gson gson, List<JiraField> fields, AlmAccount almAcc) {
        LOGGER.debug("Inside  retrieveDataAgainstFilter. jql = " + jql);
        String _url = "/rest/api/3/search/jql";
        gson = new Gson();
        ArrayList issues = new ArrayList();
        JiraSearch2 searchList = new JiraSearch2();
        searchList.setNextPageToken(null);
        searchList.setIsLast(Boolean.valueOf(false));
        JSONObject body = this.buildPayloadForJiraSerach(jql, fields, pageSize, searchList.getNextPageToken(), false);
        _url = JiraUtils.decideSearchAPI((String)_url, (boolean)almAcc.cloud(), (JSONObject)body, (int)startAt);
        String responseData = JiraUtils.executeJiraPostRequest((String)_url, (String)username, (String)password, (AlmAccount)almAcc, (String)body.toString(), (String)"", (Environment)this.ENV);
        searchList = (JiraSearch2)gson.fromJson(responseData, JiraSearch2.class);
        issues.addAll(searchList.getIssues());
        if (PropertyValidator.isValid(issues)) {
            return gson.toJson(issues);
        }
        if (PropertyValidator.isValid((Collection)searchList.getWarningMessages())) {
            String msg = gson.toJson((Object)searchList);
            AlmError almError = new AlmError();
            almError.setAlmErrorMessage(msg);
            almError.setHttpErrorCode(Integer.valueOf(500));
            throw new ViztrendJiraException(Integer.valueOf(500), msg, almError);
        }
        return null;
    }

    public String retrieveJiraResponse(String url, AlmAccount almAcc, String body) {
        LOGGER.debug("Inside  retrieveJQL->retrieveDataAgainstFilter");
        if (PropertyValidator.isValid((Object)body)) {
            return JiraUtils.executeJiraPostRequest((String)url, (String)almAcc.getUsername(), (String)almAcc.getPassword(), (AlmAccount)almAcc, (String)body, (String)"", (Environment)this.ENV);
        }
        return JiraUtils.executeJiraGetRequest((String)url, (String)almAcc.getUsername(), (String)almAcc.getPassword(), (AlmAccount)almAcc, (String)"", (Environment)this.ENV);
    }

    public String retrieveJiraIssueById(String url, String idStr, String username, String password, AlmAccount almAcc) {
        String _url = "/rest/api/2/issue/" + idStr;
        String access = username + ":" + password;
        try {
            String responseData = this.executeJiraGetRequest(_url, access, almAcc, null);
            if (PropertyValidator.isValid((Object)responseData)) {
                return responseData;
            }
        }
        catch (Exception ex) {
            LOGGER.error("retrieveJiraIssueById: Problem getting Jira Issues.", (Throwable)ex);
            throw ex;
        }
        return null;
    }

    public String retrieveTransitionsByIssueId(String url, String idStr, String username, String password, AlmAccount almAcc) {
        String _url = "/rest/api/2/issue/" + idStr + "/transitions";
        String params = "?expand=transitions";
        String access = username + ":" + password;
        try {
            String responseData = this.executeJiraGetRequest(_url, access, almAcc, params);
            if (PropertyValidator.isValid((Object)responseData)) {
                return responseData;
            }
        }
        catch (Exception ex) {
            LOGGER.error("retrieveTransitionsByIssueId: Problem getting Jira Issues.", (Throwable)ex);
        }
        return null;
    }

    public String searchFromJira(String url, AlmAccount almAcc) {
        String _url = url;
        String access = almAcc.getUsername() + ":" + almAcc.getPassword();
        try {
            String responseData = this.executeJiraGetRequest(_url, access, almAcc, null);
            if (PropertyValidator.isValid((Object)responseData)) {
                return responseData;
            }
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            throw ex;
        }
        return null;
    }

    public String retrieveJiraWebhooks(String url, String username, String password, AlmAccount almAcc) {
        String _url = "/rest/webhooks/1.0/webhook";
        if (PropertyValidator.isValid((Object)almAcc.getJiraOauthToken()) && almAcc.getJiraOauthToken().isCloud()) {
            if (PropertyValidator.isValid((Object)almAcc.getWebhookId())) {
                _url = "/rest/api/3/webhook";
            } else {
                String errMsg = "Webhook not configured for alm account: " + almAcc.getId();
                AlmError almError = new AlmError();
                almError.setAlmErrorMessage(errMsg);
                almError.setHttpErrorCode(Integer.valueOf(500));
                throw new ViztrendJiraException(Integer.valueOf(401), errMsg, almError);
            }
        }
        String access = username + ":" + password;
        String result = this.executeJiraGetRequest(_url, access, almAcc, null);
        return result;
    }

    public List<JiraVersion> retrieveJiraVersions(String projectKey, String username, String password, AlmAccount almAcc) {
        String _url = "/rest/api/3/project/" + projectKey + "/versions";
        String access = username + ":" + password;
        String result = this.executeJiraGetRequest(_url, access, almAcc, null);
        Gson gson = new Gson();
        12 T = new /* Unavailable Anonymous Inner Class!! */;
        List versions = (List)gson.fromJson(result, T.getType());
        return versions;
    }

    public JiraVersion retrieveJiraVersion(String versionId, AlmAccount almAcc) {
        String username = almAcc.getUsername();
        String password = almAcc.getPassword();
        String _url = "/rest/api/3/version/" + versionId;
        String access = username + ":" + password;
        String result = this.executeJiraGetRequest(_url, access, almAcc, null);
        Gson gson = new Gson();
        JiraVersion version = (JiraVersion)gson.fromJson(result, JiraVersion.class);
        return version;
    }

    public void updateJiraVersion(String username, String password, AlmAccount almAcc) {
    }

    public List<JiraBoard> retrieveJiraBoardsByProjectId(String projectKeyOrId, String url, String username, String password, AlmAccount almAcc) throws Exception {
        String jbUrl = "/rest/agile/1.0/board";
        String params = "?projectKeyOrId=";
        ArrayList<JiraBoard> jBoards = new ArrayList<JiraBoard>();
        if (PropertyValidator.isValid((Object)projectKeyOrId)) {
            params = params + URLEncoder.encode(projectKeyOrId, "UTF-8");
            Gson gson = new Gson();
            String access = username + ":" + password;
            String responseData = "";
            int startAt = 0;
            int pageSize = 50;
            JiraBoardWrapper boardWrapper = new JiraBoardWrapper();
            while (!boardWrapper.getIsLast().booleanValue()) {
                responseData = this.executeJiraGetRequest(jbUrl, access, almAcc, params + "&startAt=" + startAt + "&maxResults=" + pageSize);
                if (!PropertyValidator.isValid((Object)responseData)) {
                    LOGGER.error("FAILED: retrieveJiraBoardsByProjectId --> null response.");
                    break;
                }
                gson = new Gson();
                boardWrapper = (JiraBoardWrapper)gson.fromJson(responseData, JiraBoardWrapper.class);
                jBoards.addAll(boardWrapper.getValues());
                startAt += pageSize;
            }
        } else {
            LOGGER.error("ERROR: Invalid Parameter value for projectKeyOrId: " + projectKeyOrId);
            return null;
        }
        return jBoards;
    }

    private String executeJiraGetRequest(String requestUrl, String encoding, AlmAccount almAcc, String bodyOrParams) {
        if (PropertyValidator.isValid((Object)almAcc)) {
            if (almAcc.isUsingJiraConnect()) {
                JiraConnect connect = new JiraConnect(requestUrl, "GET");
                if (PropertyValidator.isValid((Object)bodyOrParams)) {
                    connect.setParams(bodyOrParams.substring(1));
                }
                return JiraUtils.executeJiraRequestByConnect((JiraConnect)connect, (AlmAccount)almAcc, (Environment)this.ENV);
            }
            if (!PropertyValidator.isValid((Object)almAcc.getJiraOauthToken())) {
                String[] encondings;
                String decryptedPassword = almAcc.getPassword();
                try {
                    decryptedPassword = EncDecUtility.decrypt((String)almAcc.getPassword());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                boolean isEncodingValid = false;
                if (PropertyValidator.isValid((Object)encoding) && PropertyValidator.isValid((String[])(encondings = encoding.split(":"))) && encondings.length == 2 && PropertyValidator.isValid((Object)encondings[0]) && PropertyValidator.isValid((Object)encondings[1])) {
                    isEncodingValid = true;
                    String _decryptedPassword = encondings[1];
                    try {
                        _decryptedPassword = EncDecUtility.decrypt((String)_decryptedPassword);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    encoding = encondings[0] + ":" + _decryptedPassword;
                }
                if (!isEncodingValid) {
                    encoding = almAcc.getUsername() + ":" + decryptedPassword;
                }
            }
            String _url = almAcc.getUrl() + requestUrl + (bodyOrParams != null ? bodyOrParams : "");
            return JiraUtils.executeJiraGetRequestBasic((String)_url, (String)encoding, (AlmAccount)almAcc);
        }
        LOGGER.error("INVALID AlmAccount.");
        throw new ViztrendJiraException(Integer.valueOf(99999), "INVALID AlmAccount.");
    }

    public String retrieveIssueLinkTypesList(String url, String username, String password, AlmAccount almAcc) {
        String _url = "/rest/api/2/issueLinkType";
        String access = username + ":" + password;
        String result = this.executeJiraGetRequest(_url, access, almAcc, null);
        return result;
    }

    public List<JiraIssueType> retrieveJiraStatuses(String projectKey, String url, String username, String password, AlmAccount almAcc) {
        ArrayList<Object> jiraIssueTypes = new ArrayList<JiraIssueType>();
        try {
            String access = username + ":" + password;
            String _url = "/rest/api/2/project/" + projectKey + "/statuses";
            String responseData = this.executeJiraGetRequest(_url, access, almAcc, null);
            if (PropertyValidator.isValid((Object)responseData)) {
                jiraIssueTypes = new ArrayList();
                Gson gson = new Gson();
                13 T = new /* Unavailable Anonymous Inner Class!! */;
                Collection stories = (Collection)gson.fromJson(responseData, T.getType());
                jiraIssueTypes = new ArrayList(stories);
            } else {
                jiraIssueTypes = null;
                LOGGER.error("FAILED: retrieveJiraStatuses --> invalid responseData");
            }
        }
        catch (ViztrendJiraException ex) {
            throw ex;
        }
        catch (Exception ex) {
            LOGGER.error("FAILED: retrieveJiraStatuses -->" + ex.getMessage(), (Throwable)ex);
        }
        return jiraIssueTypes;
    }

    public List<JiraUser> retrieveJiraUser(String url, String userToGet, String uid, String pass, AlmAccount almAcc) throws ViztrendJiraException {
        JiraData jiraData = new JiraData();
        try {
            Gson gson = new Gson();
            String access = uid + ":" + pass;
            String responseData = this.executeJiraGetRequest("/rest/api/2/groupuserpicker", access, almAcc, "?query=" + URLEncoder.encode(userToGet, "UTF-8"));
            JiraUser loginUser = null;
            if (PropertyValidator.isValid((Object)responseData)) {
                JiraUserGroupSearch jUsrGs = (JiraUserGroupSearch)gson.fromJson(responseData, JiraUserGroupSearch.class);
                if (PropertyValidator.isValid((Object)jUsrGs.getUsers())) {
                    JiraUsersSearch jus = jUsrGs.getUsers();
                    loginUser = (JiraUser)jus.getUsers().get(0);
                }
                jiraData = new JiraData();
                List jUsers = this.retrieveAllJiraUsers(url, uid, pass, almAcc);
                if (PropertyValidator.isValid((Collection)jUsers)) {
                    jiraData.setjUsers(jUsers);
                } else {
                    JiraUserGroup jGroup = this.retrieveJiraUsers(url, uid, pass, "jira-users", almAcc);
                    if (!(PropertyValidator.isValid((Object)jGroup) && PropertyValidator.isValid((Object)jGroup.getUsers()) && PropertyValidator.isValid((Collection)jGroup.getUsers().getItems()))) {
                        jGroup = this.retrieveJiraUsers(url, uid, pass, "jira-software-users", almAcc);
                    }
                    if (PropertyValidator.isValid((Object)jGroup)) {
                        jiraData.setjUsers(jGroup.getUsers().getItems());
                    }
                    JiraUserGroup jAdminGroup = this.retrieveJiraUsers(url, uid, pass, "administrators", almAcc);
                    ArrayList adminUsers = new ArrayList();
                    if (!(PropertyValidator.isValid((Object)jAdminGroup) && PropertyValidator.isValid((Object)jAdminGroup.getUsers()) && PropertyValidator.isValid((Collection)jAdminGroup.getUsers().getItems()))) {
                        jAdminGroup = this.retrieveJiraUsers(url, uid, pass, "site-admins", almAcc);
                    }
                    if (PropertyValidator.isValid((Object)jAdminGroup)) {
                        adminUsers.addAll(jAdminGroup.getUsers().getItems());
                    }
                    if (PropertyValidator.isValid(adminUsers)) {
                        for (JiraUser adminUser : adminUsers) {
                            if (jiraData.getjUsers().contains(adminUser)) continue;
                            jiraData.getjUsers().add(adminUser);
                        }
                    }
                }
                jiraData.setCompanyUrl(url);
            } else {
                jiraData = null;
            }
        }
        catch (ViztrendJiraException vex) {
            jiraData = null;
            throw vex;
        }
        catch (Exception ex) {
            jiraData = null;
            LOGGER.error("Error while sending email :" + StringUtils.getTraceString((Throwable)ex));
        }
        return jiraData.getjUsers();
    }

    public String searchJiraUsers(String query, String uid, String pass, AlmAccount almAcc) {
        String access = uid + ":" + pass;
        try {
            String responseData = this.executeJiraGetRequest("/rest/api/2/groupuserpicker", access, almAcc, "?query=" + URLEncoder.encode(query, "UTF-8"));
            return responseData;
        }
        catch (ViztrendJiraException ex) {
            LOGGER.error("Error while searchJiraUsers :" + StringUtils.getTraceString((Throwable)ex));
            throw ex;
        }
        catch (Exception ex) {
            LOGGER.error("Error while searchJiraUsers :" + StringUtils.getTraceString((Throwable)ex));
            return null;
        }
    }

    public String retrieveJiraUserById(String userId, String uid, String pass, AlmAccount almAcc) {
        String access = uid + ":" + pass;
        try {
            String responseData = this.executeJiraGetRequest("/rest/api/2/user", access, almAcc, "?accountId=" + URLEncoder.encode(userId, "UTF-8"));
            return responseData;
        }
        catch (Exception ex) {
            LOGGER.error("Error while sending email :" + StringUtils.getTraceString((Throwable)ex));
            return null;
        }
    }

    private JiraUserGroup retrieveJiraUsers(String orgUrl, String uid, String pass, String jiraGroupName, AlmAccount almAcc) {
        String access;
        String responseData;
        JiraUserGroup jiraUserGroup = null;
        if (PropertyValidator.isValid((Object)jiraGroupName) && PropertyValidator.isValid((Object)(responseData = this.executeJiraGetRequest("/rest/api/2/group", access = uid + ":" + pass, almAcc, "?groupname=" + jiraGroupName + "&expand=users")))) {
            Gson gson = new Gson();
            jiraUserGroup = (JiraUserGroup)gson.fromJson(responseData, JiraUserGroup.class);
        }
        return jiraUserGroup;
    }

    private List<JiraUser> retrieveAllJiraUsers(String url, String uid, String pass, AlmAccount almAcc) {
        List<Object> jiraUserList = new ArrayList<JiraUser>();
        try {
            String access = uid + ":" + pass;
            String responseData = this.executeJiraGetRequest("/rest/api/2/user/search", access, almAcc, "?startAt=0&maxResults=1000&includeInactive=true&username=" + URLEncoder.encode("%", "UTF-8"));
            LOGGER.trace(responseData);
            if (PropertyValidator.isValid((Object)responseData)) {
                14 T = new /* Unavailable Anonymous Inner Class!! */;
                Gson gson = new Gson();
                jiraUserList = (List)gson.fromJson(responseData, T.getType());
            } else {
                jiraUserList = null;
            }
        }
        catch (Exception ex) {
            jiraUserList = null;
            LOGGER.error("Error while sending email :" + StringUtils.getTraceString((Throwable)ex));
        }
        return jiraUserList;
    }

    public JiraUser retrieveJiraUserByEmailId(String userEmailId, String uid, String pass, AlmAccount almAcc) {
        JiraUserSearch jiraUserList = null;
        try {
            if (userEmailId != null) {
                String access = uid + ":" + pass;
                String responseData = this.executeJiraGetRequest("/rest/api/2/user/picker", access, almAcc, "?query=" + userEmailId + "&maxResults=5");
                LOGGER.trace(responseData);
                if (PropertyValidator.isValid((Object)responseData)) {
                    Gson gson = new Gson();
                    jiraUserList = (JiraUserSearch)gson.fromJson(responseData, JiraUserSearch.class);
                    if (PropertyValidator.isValid((Collection)jiraUserList.getUsers())) {
                        return (JiraUser)jiraUserList.getUsers().get(0);
                    }
                } else {
                    jiraUserList = null;
                }
            }
        }
        catch (Exception ex) {
            jiraUserList = null;
            LOGGER.error("Error while sending email :" + StringUtils.getTraceString((Throwable)ex));
        }
        return null;
    }

    private JSONObject constructRequestBodyForJiraSearch(String jql, int startAt, int pageSize, List<JiraField> fields, boolean preview) {
        try {
            JSONArray fieldsJsonArr = new JSONArray();
            if (preview) {
                fieldsJsonArr.put((Object)"project");
                fieldsJsonArr.put((Object)"summary");
                fieldsJsonArr.put((Object)"issuelinks");
            } else if (PropertyValidator.isValid(fields)) {
                fieldsJsonArr.put((Object)"key");
                fieldsJsonArr.put((Object)"id");
                fieldsJsonArr.put((Object)"summary");
                fieldsJsonArr.put((Object)"project");
                fieldsJsonArr.put((Object)"status");
                fieldsJsonArr.put((Object)"issuetype");
                fieldsJsonArr.put((Object)"fixVersions");
                fieldsJsonArr.put((Object)"duedate");
                fieldsJsonArr.put((Object)"issuelinks");
                for (JiraField field : fields) {
                    if (field == null) continue;
                    fieldsJsonArr.put((Object)field.getId());
                }
            } else {
                fieldsJsonArr.put((Object)"*all");
            }
            JSONObject body = new JSONObject();
            body.put("jql", (Object)jql);
            if (startAt != -1) {
                body.put("startAt", startAt);
            }
            if (pageSize != -1) {
                body.put("maxResults", pageSize);
            }
            body.put("fields", (Object)fieldsJsonArr);
            body.put("validateQuery", (Object)"false");
            return body;
        }
        catch (JSONException e) {
            LOGGER.error("constructRequestBodyForJira -->Caught JSONException", (Throwable)e);
            return null;
        }
    }

    public JSONObject buildPayloadForJiraSerach(String jql, List<JiraField> fields, int pageSize, String nextPageToken, boolean preview) {
        try {
            JSONArray fieldsJsonArr = new JSONArray();
            if (preview) {
                fieldsJsonArr.put((Object)"project");
                fieldsJsonArr.put((Object)"summary");
                fieldsJsonArr.put((Object)"issuelinks");
            } else if (PropertyValidator.isValid(fields)) {
                fieldsJsonArr.put((Object)"key");
                fieldsJsonArr.put((Object)"id");
                fieldsJsonArr.put((Object)"summary");
                fieldsJsonArr.put((Object)"project");
                fieldsJsonArr.put((Object)"status");
                fieldsJsonArr.put((Object)"issuetype");
                fieldsJsonArr.put((Object)"fixVersions");
                fieldsJsonArr.put((Object)"duedate");
                fieldsJsonArr.put((Object)"issuelinks");
                for (JiraField field : fields) {
                    if (field == null) continue;
                    fieldsJsonArr.put((Object)field.getId());
                }
            } else {
                fieldsJsonArr.put((Object)"*all");
            }
            JSONObject body = new JSONObject();
            body.put("jql", (Object)jql);
            if (pageSize != -1) {
                body.put("maxResults", pageSize);
            }
            body.put("fields", (Object)fieldsJsonArr);
            body.put("fieldsByKeys", true);
            body.put("nextPageToken", (Object)nextPageToken);
            return body;
        }
        catch (JSONException e) {
            LOGGER.error("constructRequestBodyForJira -->Caught JSONException", (Throwable)e);
            return null;
        }
    }

    public JiraBoardConfig retrieveJiraBoardConfig(String boardId, String url, String username, String password, AlmAccount almAcc) {
        Gson gson = new Gson();
        JiraBoardConfig jiraBoardConfig = null;
        try {
            String result2 = this.retrieveBoardConfig(boardId, null, username, password, almAcc);
            if (PropertyValidator.isValid((Object)result2)) {
                jiraBoardConfig = (JiraBoardConfig)gson.fromJson(result2, JiraBoardConfig.class);
            }
        }
        catch (Exception ex) {
            LOGGER.error("FAILED: retrieveJiraBoardConfig -->" + ex.getMessage(), (Throwable)ex);
        }
        return jiraBoardConfig;
    }

    public JiraSprint retrieveSprintDetails(String sprintId, String url, String username, String password, AlmAccount almAcc) {
        String _url = "/rest/agile/1.0/sprint/" + sprintId;
        LOGGER.info("URL: " + _url);
        String access = username + ":" + password;
        JiraSprint jiraSprint = null;
        Gson gson = new Gson();
        String result = this.executeJiraGetRequest(_url, access, almAcc, null);
        if (PropertyValidator.isValid((Object)result)) {
            jiraSprint = (JiraSprint)gson.fromJson(result, JiraSprint.class);
        }
        return jiraSprint;
    }

    public List<JiraSprint> retrieveBoardSprintById(ArrayList<String> sprintIds, String url, String username, String password, AlmAccount almAcc) {
        ArrayList<JiraSprint> jSprints = new ArrayList<JiraSprint>();
        for (String sprintId : sprintIds) {
            jSprints.add(this.retrieveSprintDetails(sprintId, url, username, password, almAcc));
        }
        return jSprints;
    }

    public JiraSearch2 retrieveJiraBoardIssuesForSprint(String boardId, String sprintId, String url, String username, String password, AlmAccount almAcc) {
        String _url = "/rest/agile/1.0/board/" + boardId + "/sprint/" + sprintId + "/issue";
        LOGGER.info("URL: " + _url);
        String access = username + ":" + password;
        JiraSearch2 jiraBoardIssuesForSprint = null;
        Gson gson = new Gson();
        String result = this.executeJiraGetRequest(_url, access, almAcc, null);
        if (PropertyValidator.isValid((Object)result)) {
            jiraBoardIssuesForSprint = (JiraSearch2)gson.fromJson(result, JiraSearch2.class);
        }
        return jiraBoardIssuesForSprint;
    }

    public List<JiraSearch2> retrieveBoardIssuesForSprint(String boardId, ArrayList<String> sprintIds, String url, String username, String password, AlmAccount almAcc) {
        List boardSprints = this.retrieveJiraBoardFutureSprints(boardId, url, username, password, almAcc);
        ArrayList<JiraSearch2> jiraBoardIssuesForSprint = new ArrayList<JiraSearch2>();
        if (PropertyValidator.isValid((Collection)boardSprints)) {
            for (String sprintId : sprintIds) {
                jiraBoardIssuesForSprint.add(this.retrieveJiraBoardIssuesForSprint(boardId, sprintId, url, username, password, almAcc));
            }
        }
        return jiraBoardIssuesForSprint;
    }

    public JiraSearch2 retrieveBoardBacklogIssues(String boardId, String url, String username, String password, AlmAccount almAcc) {
        String bcUrl = "/rest/agile/1.0/board/" + boardId + "/backlog";
        LOGGER.info("URL: " + bcUrl);
        String access = username + ":" + password;
        JiraSearch2 jiraBoardConfig = null;
        Gson gson = new Gson();
        String result = this.executeJiraGetRequest(bcUrl, access, almAcc, null);
        if (PropertyValidator.isValid((Object)result)) {
            jiraBoardConfig = (JiraSearch2)gson.fromJson(result, JiraSearch2.class);
        }
        return jiraBoardConfig;
    }

    public List<JiraSearch2> retrieveIssuesForBacklog(String boardId, String url, String username, String password, AlmAccount almAcc) {
        ArrayList<JiraSearch2> issuesForBacklog = new ArrayList<JiraSearch2>();
        issuesForBacklog.add(this.retrieveBoardBacklogIssues(boardId, url, username, password, almAcc));
        return issuesForBacklog;
    }
}

