/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.alm.jira;

import com.google.gson.Gson;
import com.viztrend.safe.alm.jira.JiraUtils;
import com.viztrend.safe.alm.jira.bo.JiraField;
import com.viztrend.safe.alm.jira.bo.JiraSprint;
import com.viztrend.safe.alm.jira.bo.JiraVersion;
import com.viztrend.safe.persistence.entity.AlmAccount;
import com.viztrend.safe.persistence.entity.AlmConfigurations;
import com.viztrend.safe.persistence.entity.ItemJiraFieldMap;
import com.viztrend.safe.persistence.entity.JiraProjectIssueTypes;
import com.viztrend.safe.persistence.repository.AlmAccountRepository;
import com.viztrend.safe.persistence.repository.JiraFieldRepository;
import com.viztrend.safe.persistence.repository.JiraProjectIssueTypesRepository;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.vos.WebhookVO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class ExportUtil {
    @Autowired
    private AlmAccountRepository almAccountRepository;
    @Autowired
    private JiraProjectIssueTypesRepository jiraProjectIssueTypesRepository;
    @Autowired
    private JiraFieldRepository jiraFieldRepository;
    private static final Logger LOGGER = LoggerFactory.getLogger(ExportUtil.class);
    @Autowired
    private Environment ENV;

    public String deleteParentRequirementFromSynapseRT(String childRequirementKey, AlmAccount almAccount) {
        String _url = "/rest/synapse/latest/requirementMember/deleteParent";
        JSONObject requestBody = this.getJsonObject("currentReqkey", childRequirementKey);
        String response = null;
        try {
            LOGGER.debug(requestBody.toString());
            response = JiraUtils.executeJiraPostRequest((String)_url, (String)almAccount.getUsername(), (String)almAccount.getPassword(), (AlmAccount)almAccount, (String)requestBody.toString(), (String)"", (Environment)this.ENV);
        }
        catch (Exception e) {
            LOGGER.error("SynapseRT :: while deleting parent.", (Throwable)e);
        }
        return response;
    }

    public String addChildRequirementToSynapseRT(String parentRequirementKey, String childRequirementKey, AlmAccount almAccount) {
        String _url = "/rest/synapse/latest/public/requirement/" + parentRequirementKey + "/addChildren";
        ArrayList<String> childKeys = new ArrayList<String>();
        childKeys.add(childRequirementKey);
        String response = null;
        try {
            JSONObject requestBody = this.getJsonObject("requirementKeys", new JSONArray(childKeys));
            LOGGER.debug(requestBody.toString());
            response = JiraUtils.executeJiraPostRequest((String)_url, (String)almAccount.getUsername(), (String)almAccount.getPassword(), (AlmAccount)almAccount, (String)requestBody.toString(), (String)"", (Environment)this.ENV);
        }
        catch (Exception e) {
            LOGGER.error("SynapseRT :: while creating parent link", (Throwable)e);
        }
        return response;
    }

    public String createJiraIssue(String url, String username, String password, Map<String, Object> fieldsToSet, List<ItemJiraFieldMap> jiraMandatoryFields) {
        String _url = "/rest/api/latest/issue/";
        JSONObject requestBody = new JSONObject();
        Boolean sendRequest = Boolean.FALSE;
        try {
            if (fieldsToSet != null && !fieldsToSet.isEmpty()) {
                JSONObject fields = this.constructRequestBodyForJira(fieldsToSet, jiraMandatoryFields);
                requestBody.put("fields", (Object)fields);
                sendRequest = Boolean.TRUE;
            }
        }
        catch (JSONException e) {
            LOGGER.error("JSONException while creating request for Issue creation in JIRA.", (Throwable)e);
        }
        if (sendRequest.booleanValue()) {
            String param = "";
            param = PropertyValidator.isValid((Object)fieldsToSet.get("notifyUsers")) && (Boolean)fieldsToSet.get("notifyUsers") != false ? param + "?notifyUsers=true" : (!fieldsToSet.containsKey("notifyUsers") ? param + "?notifyUsers=true" : param + "?notifyUsers=false");
            AlmAccount almAcc = (AlmAccount)fieldsToSet.get("almAccount");
            LOGGER.debug(requestBody.toString());
            String response = JiraUtils.executeJiraPostRequest((String)_url, (String)username, (String)password, (AlmAccount)almAcc, (String)requestBody.toString(), (String)param, (Environment)this.ENV);
            try {
                if (response == null && fieldsToSet != null && !fieldsToSet.isEmpty()) {
                    fieldsToSet.remove("duedate");
                    fieldsToSet.remove("Story Points");
                    fieldsToSet.remove("sprint");
                    JSONObject fields = this.constructRequestBodyForJira(fieldsToSet, null);
                    requestBody.put("fields", (Object)fields);
                    return JiraUtils.executeJiraPostRequest((String)_url, (String)username, (String)password, (AlmAccount)almAcc, (String)requestBody.toString(), null, (Environment)this.ENV);
                }
            }
            catch (JSONException e) {
                LOGGER.error("JSONException while creating request for Issue creation in JIRA. SECOND ATTEMPT", (Throwable)e);
            }
            return response;
        }
        return null;
    }

    public String createWebhookInJira(WebhookVO webhook, AlmAccount almAccount) {
        String _url = "/rest/webhooks/1.0/webhook";
        if (PropertyValidator.isValid((Object)almAccount.getJiraOauthToken()) && almAccount.getJiraOauthToken().isCloud()) {
            _url = "/rest/api/3/webhook";
        }
        Gson gson = new Gson();
        return JiraUtils.executeJiraPostRequest((String)_url, (String)almAccount.getUsername(), (String)almAccount.getPassword(), (AlmAccount)almAccount, (String)gson.toJson((Object)webhook, WebhookVO.class), null, (Environment)this.ENV);
    }

    public String updateIssueInJira(String issueId, String url, String username, String password, Map<String, Object> fieldsToSet, List<ItemJiraFieldMap> jiraMandatoryFields, boolean isNextGenUpdate) {
        String _url = "/rest/api/latest/issue/" + issueId;
        JSONObject requestBody = new JSONObject();
        Boolean sendRequest = Boolean.FALSE;
        try {
            if (fieldsToSet != null && !fieldsToSet.isEmpty() || PropertyValidator.isValid(jiraMandatoryFields)) {
                JSONObject fields = this.constructUpdateRequestBodyForJira(fieldsToSet, jiraMandatoryFields);
                if (isNextGenUpdate) {
                    requestBody.put("fields", (Object)fields);
                } else {
                    requestBody.put("update", (Object)fields);
                }
                sendRequest = Boolean.TRUE;
            }
        }
        catch (JSONException e) {
            LOGGER.error("JSONException while creating request for Issue updation in JIRA.", (Throwable)e);
        }
        if (sendRequest.booleanValue()) {
            String param = "";
            param = PropertyValidator.isValid((Object)fieldsToSet.get("notifyUsers")) && (Boolean)fieldsToSet.get("notifyUsers") != false ? param + "?notifyUsers=true" : (!fieldsToSet.containsKey("notifyUsers") ? param + "?notifyUsers=true" : param + "?notifyUsers=false");
            AlmAccount almAccount = (AlmAccount)fieldsToSet.get("almAccount");
            LOGGER.debug("updateIssueInJira --> " + requestBody.toString());
            String response = JiraUtils.executeJiraPutRequest((String)_url, (String)username, (String)password, (AlmAccount)almAccount, (String)requestBody.toString(), (String)param, (Environment)this.ENV);
            if (response == null) {
                LOGGER.debug("First attempt FAILED::::::::Going to attempt EDIT with basic attributes." + response);
                try {
                    if (fieldsToSet != null && !fieldsToSet.isEmpty()) {
                        fieldsToSet.remove("duedate");
                        fieldsToSet.remove("Story Points");
                        fieldsToSet.remove("sprint");
                        JSONObject fields = this.constructUpdateRequestBodyForJira(fieldsToSet, jiraMandatoryFields);
                        requestBody.put("update", (Object)fields);
                        return JiraUtils.executeJiraPutRequest((String)_url, (String)username, (String)password, (AlmAccount)almAccount, (String)requestBody.toString(), (String)"", (Environment)this.ENV);
                    }
                }
                catch (JSONException e) {
                    LOGGER.error("JSONException while creating request for Issue updation in JIRA. SECOND ATTEMPT", (Throwable)e);
                }
            }
            return response;
        }
        return null;
    }

    public String doTransitionInJira(String transitionId, String issueId, String url, String username, String password, AlmAccount almAcc, Boolean notifyUserInJira) {
        String _url = "/rest/api/latest/issue/" + issueId + "/transitions";
        JSONObject requestBody = new JSONObject();
        Boolean sendRequest = Boolean.FALSE;
        try {
            JSONObject fields = this.getJsonObject("id", transitionId);
            requestBody.put("transition", (Object)fields);
            sendRequest = Boolean.TRUE;
        }
        catch (JSONException e) {
            LOGGER.error("JSONException while creating request for Issue transition in JIRA.", (Throwable)e);
        }
        if (sendRequest.booleanValue()) {
            LOGGER.debug(requestBody.toString());
            String response = JiraUtils.executeJiraPostRequest((String)_url, (String)username, (String)password, (AlmAccount)almAcc, (String)requestBody.toString(), null, (Environment)this.ENV);
            return response;
        }
        return null;
    }

    public void putSprintInJSON(JSONObject fields, String sprintId, String almAccountId) {
        JiraField jspField = this.jiraFieldRepository.findBySchemaCustomIgnoreCaseAndAlmAccountId("com.pyxis.greenhopper.jira:gh-sprint", almAccountId);
        try {
            fields.put(jspField.getJiraId(), (Object)new Integer(sprintId));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private JSONObject constructRequestBodyForJira(Map<String, Object> fieldsToSet, List<ItemJiraFieldMap> jiraMandatoryFields) {
        block40: {
            try {
                if (fieldsToSet == null || fieldsToSet.isEmpty()) break block40;
                AlmAccount almAccount = (AlmAccount)fieldsToSet.get("almAccount");
                String projectKey1 = (String)fieldsToSet.get("project");
                JiraProjectIssueTypes projectIssueTypes = this.jiraProjectIssueTypesRepository.findByAlmAccountIdAndJiraProjectKey(almAccount.getId(), projectKey1);
                JSONObject fields = new JSONObject();
                for (String key : fieldsToSet.keySet()) {
                    String title;
                    String dateStr;
                    SimpleDateFormat sdf;
                    String issutypeId;
                    String issueTypeId;
                    String projectKey;
                    JSONArray verArr;
                    String versionId;
                    if ("versions".equals(key) && PropertyValidator.isValid((Object)(versionId = (String)fieldsToSet.get(key)))) {
                        verArr = new JSONArray();
                        verArr.put((Object)this.getJsonObject("id", versionId));
                        fields.put("versions", (Object)verArr);
                    }
                    if ("fixVersions".equals(key) && PropertyValidator.isValid((Object)(versionId = (String)fieldsToSet.get(key)))) {
                        verArr = new JSONArray();
                        verArr.put((Object)this.getJsonObject("id", versionId));
                        fields.put("fixVersions", (Object)verArr);
                    }
                    if ("project".equals(key) && PropertyValidator.isValid((Object)(projectKey = (String)fieldsToSet.get(key)))) {
                        fields.put("project", (Object)this.getJsonObject("key", projectKey));
                    }
                    if ("issuetype".equals(key) && PropertyValidator.isValid((Object)(issueTypeId = (String)fieldsToSet.get(key)))) {
                        fields.put("issuetype", (Object)this.getJsonObject("id", issueTypeId));
                    }
                    if ("duedate".equals(key)) {
                        Date duedate;
                        if (PropertyValidator.isValid((Object)projectIssueTypes) && PropertyValidator.isValid((Collection)projectIssueTypes.getSkipSyncFields())) {
                            issutypeId = (String)fieldsToSet.get("issuetype");
                            if (projectIssueTypes.getSkipSyncFields().contains(issutypeId + "_" + "duedate")) continue;
                        }
                        JiraField dueDateField = almAccount.getDueDateField();
                        String dueDateStr = "duedate";
                        if (PropertyValidator.isValid((Object)dueDateField)) {
                            dueDateStr = dueDateField.getId();
                        }
                        if (PropertyValidator.isValid((Object)(duedate = (Date)fieldsToSet.get(key)))) {
                            sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
                            dateStr = sdf.format(duedate);
                            fields.put(dueDateStr, (Object)dateStr);
                        }
                    }
                    if ("startDate".equals(key)) {
                        Date startdate;
                        if (PropertyValidator.isValid((Object)projectIssueTypes) && PropertyValidator.isValid((Collection)projectIssueTypes.getSkipSyncFields())) {
                            issutypeId = (String)fieldsToSet.get("issuetype");
                            if (projectIssueTypes.getSkipSyncFields().contains(issutypeId + "_" + "startDate")) continue;
                        }
                        JiraField startDateField = almAccount.getStartDateField();
                        String startDateStr = "startDate";
                        if (PropertyValidator.isValid((Object)startDateField)) {
                            startDateStr = startDateField.getId();
                        }
                        if (PropertyValidator.isValid((Object)(startdate = (Date)fieldsToSet.get(key)))) {
                            sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
                            dateStr = sdf.format(startdate);
                            fields.put(startDateStr, (Object)dateStr);
                        }
                    }
                    if ("endDate".equals(key)) {
                        Date enddate;
                        if (PropertyValidator.isValid((Object)projectIssueTypes) && PropertyValidator.isValid((Collection)projectIssueTypes.getSkipSyncFields())) {
                            issutypeId = (String)fieldsToSet.get("issuetype");
                            if (projectIssueTypes.getSkipSyncFields().contains(issutypeId + "_" + "endDate")) continue;
                        }
                        JiraField endDateField = almAccount.getEndDateField();
                        String endDateStr = "endDate";
                        if (PropertyValidator.isValid((Object)endDateField)) {
                            endDateStr = endDateField.getId();
                        }
                        if (PropertyValidator.isValid((Object)(enddate = (Date)fieldsToSet.get(key)))) {
                            sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
                            dateStr = sdf.format(enddate);
                            fields.put(endDateStr, (Object)dateStr);
                        }
                    }
                    if ("title".equals(key)) {
                        title = (String)fieldsToSet.get(key);
                        fields.put("summary", (Object)title);
                    }
                    if ("description".equals(key)) {
                        title = (String)fieldsToSet.get(key);
                        fields.put("description", (Object)title);
                    }
                    if ("parent".equals(key)) {
                        String parentKey = (String)fieldsToSet.get(key);
                        JSONObject parentObject = new JSONObject();
                        parentObject.put("key", (Object)parentKey);
                        fields.put("parent", (Object)parentObject);
                    }
                    if ("boardId".equals(key)) {
                        String boardId = (String)fieldsToSet.get(key);
                        try {
                            fields.put("boardId", (Object)new Integer(boardId));
                        }
                        catch (Exception parentObject) {
                            // empty catch block
                        }
                    }
                    if ("sprint".equals(key)) {
                        this.putSprintInJSON(fields, (String)fieldsToSet.get(key), (String)fieldsToSet.get("AlmAccountId"));
                    }
                    if ("Story Points".equalsIgnoreCase(key)) {
                        JiraField storyPointField = almAccount.getStoryPointField();
                        String storyPointFieldKey = "Story Points";
                        if (PropertyValidator.isValid((Object)projectIssueTypes.getStyle()) && "next-gen".equals(projectIssueTypes.getStyle()) && PropertyValidator.isValid((Object)almAccount.getNextGenStoryPointField())) {
                            storyPointField = almAccount.getNextGenStoryPointField();
                        }
                        if (PropertyValidator.isValid((Object)projectIssueTypes) && PropertyValidator.isValid((Collection)projectIssueTypes.getSkipSyncFields())) {
                            String issutypeId2 = (String)fieldsToSet.get("issuetype");
                            if (projectIssueTypes.getSkipSyncFields().contains(issutypeId2 + "_" + "Story Points")) continue;
                        }
                        if (!PropertyValidator.isValid((Object)storyPointField)) {
                            storyPointField = this.jiraFieldRepository.findByNameIgnoreCaseAndAlmAccountId("Story Points", (String)fieldsToSet.get("AlmAccountId"));
                        }
                        Double storyPoints = (Double)fieldsToSet.get(key);
                        try {
                            fields.put(storyPointField.getJiraId(), (Object)storyPoints);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (!almAccount.getJiraEpicLinkLabel().equals(key)) continue;
                    JiraField epicField = this.jiraFieldRepository.findBySchemaCustomIgnoreCaseAndAlmAccountId("com.pyxis.greenhopper.jira:gh-epic-link", (String)fieldsToSet.get("AlmAccountId"));
                    fields.put(epicField.getJiraId(), (Object)((String)fieldsToSet.get(key)));
                }
                if (PropertyValidator.isValid(jiraMandatoryFields)) {
                    for (ItemJiraFieldMap itemJiraFieldMap : jiraMandatoryFields) {
                        try {
                            if (itemJiraFieldMap.getType().equals("JSONArray")) {
                                fields.put(itemJiraFieldMap.getKey(), (Object)new JSONArray(itemJiraFieldMap.getValue()));
                                continue;
                            }
                            if (itemJiraFieldMap.getType().equals("JSONObject")) {
                                if ("project".equals(itemJiraFieldMap.getKey()) && fields.has(itemJiraFieldMap.getKey())) continue;
                                if ("reporter".equals(itemJiraFieldMap.getKey())) {
                                    JSONObject ob = new JSONObject(itemJiraFieldMap.getValue());
                                    if (!ob.keys().hasNext()) continue;
                                    fields.put(itemJiraFieldMap.getKey(), (Object)new JSONObject(itemJiraFieldMap.getValue()));
                                    continue;
                                }
                                fields.put(itemJiraFieldMap.getKey(), (Object)new JSONObject(itemJiraFieldMap.getValue()));
                                continue;
                            }
                            if (itemJiraFieldMap.getType().equals("Double")) {
                                if (itemJiraFieldMap.getValue() == null) continue;
                                fields.put(itemJiraFieldMap.getKey(), (Object)new Double(itemJiraFieldMap.getValue()));
                                continue;
                            }
                            fields.put(itemJiraFieldMap.getKey(), (Object)itemJiraFieldMap.getValue());
                        }
                        catch (Exception e) {
                            LOGGER.error("jira field data Exception \n" + StringUtils.getTraceString((Throwable)e));
                            LOGGER.error("jira field data Exception [" + itemJiraFieldMap.getKey() + "] " + itemJiraFieldMap.getValue());
                        }
                    }
                }
                return fields;
            }
            catch (JSONException e) {
                LOGGER.error("constructRequestBodyForJira -->Caught JSONException", (Throwable)e);
            }
        }
        return null;
    }

    private JSONObject constructUpdateRequestBodyForJira(Map<String, Object> fieldsToSet, List<ItemJiraFieldMap> jiraMandatoryFields) {
        try {
            JSONObject fields = new JSONObject();
            if (fieldsToSet != null && !fieldsToSet.isEmpty()) {
                AlmAccount almAccount = (AlmAccount)fieldsToSet.get("almAccount");
                String projectKey = (String)fieldsToSet.get("projectKey");
                JiraProjectIssueTypes projectIssueTypes = null;
                if (PropertyValidator.isValid((Object)projectKey)) {
                    projectIssueTypes = this.jiraProjectIssueTypesRepository.findByAlmAccountIdAndJiraProjectKey(almAccount.getId(), projectKey);
                }
                for (String key : fieldsToSet.keySet()) {
                    String dateStr;
                    SimpleDateFormat sdf;
                    String issutypeId;
                    JSONArray verArr;
                    String versionId;
                    if ("versions".equals(key) && PropertyValidator.isValid((Object)(versionId = (String)fieldsToSet.get(key)))) {
                        verArr = new JSONArray();
                        verArr.put((Object)this.getJsonObject("add", this.getJsonObject("id", versionId)));
                        fields.put("versions", (Object)verArr);
                    }
                    if ("fixVersions".equals(key)) {
                        String remVersionId;
                        versionId = (String)fieldsToSet.get(key);
                        verArr = new JSONArray();
                        if (PropertyValidator.isValid((Object)versionId)) {
                            verArr.put((Object)this.getJsonObject("add", this.getJsonObject("id", versionId)));
                        }
                        if (PropertyValidator.isValid((Object)(remVersionId = (String)fieldsToSet.get("fixVersions_remove")))) {
                            verArr.put((Object)this.getJsonObject("remove", this.getJsonObject("id", remVersionId)));
                        }
                        fields.put("fixVersions", (Object)verArr);
                    }
                    if ("duedate".equals(key)) {
                        Date duedate;
                        if (PropertyValidator.isValid((Object)projectIssueTypes) && PropertyValidator.isValid((Collection)projectIssueTypes.getSkipSyncFields())) {
                            issutypeId = (String)fieldsToSet.get("issuetype");
                            if (projectIssueTypes.getSkipSyncFields().contains(issutypeId + "_" + "duedate")) continue;
                        }
                        JiraField dueDateField = almAccount.getDueDateField();
                        String dueDateStr = "duedate";
                        if (PropertyValidator.isValid((Object)dueDateField)) {
                            dueDateStr = dueDateField.getId();
                        }
                        if (PropertyValidator.isValid((Object)(duedate = (Date)fieldsToSet.get(key)))) {
                            sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
                            dateStr = sdf.format(duedate);
                            JSONArray dueDateArr = new JSONArray();
                            dueDateArr.put((Object)this.getJsonObject("set", dateStr));
                            fields.put(dueDateStr, (Object)dueDateArr);
                        } else {
                            JSONArray dueDateArr = new JSONArray();
                            dueDateArr.put((Object)this.getNullJsonObject("set"));
                            fields.put(dueDateStr, (Object)dueDateArr);
                        }
                    }
                    if ("startDate".equals(key)) {
                        Date startdate;
                        if (PropertyValidator.isValid((Object)projectIssueTypes) && PropertyValidator.isValid((Collection)projectIssueTypes.getSkipSyncFields())) {
                            issutypeId = (String)fieldsToSet.get("issuetype");
                            if (projectIssueTypes.getSkipSyncFields().contains(issutypeId + "_" + "startDate")) continue;
                        }
                        JiraField startDateField = almAccount.getStartDateField();
                        String startDateStr = "startDate";
                        if (PropertyValidator.isValid((Object)startDateField)) {
                            startDateStr = startDateField.getId();
                        }
                        if (PropertyValidator.isValid((Object)(startdate = (Date)fieldsToSet.get(key)))) {
                            sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
                            dateStr = sdf.format(startdate);
                            JSONArray startDateArr = new JSONArray();
                            startDateArr.put((Object)this.getJsonObject("set", dateStr));
                            fields.put(startDateStr, (Object)startDateArr);
                        } else {
                            JSONArray startDateArr = new JSONArray();
                            startDateArr.put((Object)this.getNullJsonObject("set"));
                            fields.put(startDateStr, (Object)startDateArr);
                        }
                    }
                    if ("endDate".equals(key)) {
                        Date enddate;
                        if (PropertyValidator.isValid((Object)projectIssueTypes) && PropertyValidator.isValid((Collection)projectIssueTypes.getSkipSyncFields())) {
                            issutypeId = (String)fieldsToSet.get("issuetype");
                            if (projectIssueTypes.getSkipSyncFields().contains(issutypeId + "_" + "endDate")) continue;
                        }
                        JiraField endDateField = almAccount.getEndDateField();
                        String endDateStr = "endDate";
                        if (PropertyValidator.isValid((Object)endDateField)) {
                            endDateStr = endDateField.getId();
                        }
                        if (PropertyValidator.isValid((Object)(enddate = (Date)fieldsToSet.get(key)))) {
                            sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
                            dateStr = sdf.format(enddate);
                            JSONArray endDateArr = new JSONArray();
                            endDateArr.put((Object)this.getJsonObject("set", dateStr));
                            fields.put(endDateStr, (Object)endDateArr);
                        } else {
                            JSONArray endDateArr = new JSONArray();
                            endDateArr.put((Object)this.getNullJsonObject("set"));
                            fields.put(endDateStr, (Object)endDateArr);
                        }
                    }
                    if ("title".equals(key)) {
                        String title = (String)fieldsToSet.get(key);
                        JSONArray titleArr = new JSONArray();
                        if (PropertyValidator.isValid((Object)title)) {
                            titleArr.put((Object)this.getJsonObject("set", title));
                            fields.put("summary", (Object)titleArr);
                        }
                    }
                    if ("parent".equals(key)) {
                        String parentKey = (String)fieldsToSet.get(key);
                        JSONObject parentObject = new JSONObject();
                        if (parentKey != null) {
                            parentObject.put("key", (Object)parentKey);
                        }
                        fields.put("parent", (Object)parentObject);
                    }
                    if ("sprint".equals(key)) {
                        // empty if block
                    }
                    if ("Story Points".equalsIgnoreCase(key)) {
                        JiraField storyPointField = almAccount.getStoryPointField();
                        String storyPointFieldKey = "Story Points";
                        if (PropertyValidator.isValid((Object)projectIssueTypes) && PropertyValidator.isValid((Object)projectIssueTypes.getStyle()) && "next-gen".equals(projectIssueTypes.getStyle()) && PropertyValidator.isValid((Object)almAccount.getNextGenStoryPointField())) {
                            storyPointField = almAccount.getNextGenStoryPointField();
                        }
                        if (PropertyValidator.isValid((Object)projectIssueTypes) && PropertyValidator.isValid((Collection)projectIssueTypes.getSkipSyncFields())) {
                            String issutypeId2 = (String)fieldsToSet.get("issuetype");
                            if (projectIssueTypes.getSkipSyncFields().contains(issutypeId2 + "_" + "Story Points")) continue;
                        }
                        if (!PropertyValidator.isValid((Object)storyPointField)) {
                            storyPointField = this.jiraFieldRepository.findByNameIgnoreCaseAndAlmAccountId("Story Points", (String)fieldsToSet.get("AlmAccountId"));
                        }
                        JSONArray pointArr = new JSONArray();
                        Double storyPoints = (Double)fieldsToSet.get(key);
                        if (PropertyValidator.isValid((Object)storyPoints)) {
                            pointArr.put((Object)this.getJsonObject("set", storyPoints));
                            fields.put(storyPointField.getJiraId(), (Object)pointArr);
                        }
                    }
                    if (almAccount.getJiraEpicLinkLabel().equals(key)) {
                        JiraField epicField = this.jiraFieldRepository.findBySchemaCustomIgnoreCaseAndAlmAccountId("com.pyxis.greenhopper.jira:gh-epic-link", (String)fieldsToSet.get("AlmAccountId"));
                        String epicName = (String)fieldsToSet.get(key);
                        JSONArray titleArr = new JSONArray();
                        if (PropertyValidator.isValid((Object)epicName)) {
                            titleArr.put((Object)this.getJsonObject("set", epicName));
                            fields.put(epicField.getJiraId(), (Object)titleArr);
                        }
                    }
                    if (!key.contains("customfield")) continue;
                    Object value = fieldsToSet.get(key);
                    JSONArray parentLinkArray = new JSONArray();
                    if (value instanceof String) {
                        parentLinkArray.put((Object)this.getJsonObject("set", (String)value));
                    } else if (value instanceof Integer) {
                        parentLinkArray.put((Object)this.getJsonObject("set", (Integer)value));
                    }
                    fields.put(key, (Object)parentLinkArray);
                }
            }
            if (PropertyValidator.isValid(jiraMandatoryFields)) {
                for (ItemJiraFieldMap itemJiraFieldMap : jiraMandatoryFields) {
                    try {
                        JSONArray updateSetArray = new JSONArray();
                        if (itemJiraFieldMap.getType().equals("JSONArray")) {
                            if (itemJiraFieldMap.getValue() == null) {
                                fields.put(itemJiraFieldMap.getKey(), (Object)updateSetArray.put((Object)this.getJsonObjectNULL("set")));
                                continue;
                            }
                            fields.put(itemJiraFieldMap.getKey(), (Object)updateSetArray.put((Object)this.getJsonObject("set", new JSONArray(itemJiraFieldMap.getValue()))));
                            continue;
                        }
                        if (itemJiraFieldMap.getType().equals("JSONObject")) {
                            if ("project".equals(itemJiraFieldMap.getKey())) continue;
                            if (itemJiraFieldMap.getValue() == null) {
                                fields.put(itemJiraFieldMap.getKey(), (Object)updateSetArray.put((Object)this.getJsonObjectNULL("set")));
                                continue;
                            }
                            fields.put(itemJiraFieldMap.getKey(), (Object)updateSetArray.put((Object)this.getJsonObject("set", new JSONObject(itemJiraFieldMap.getValue()))));
                            continue;
                        }
                        if (itemJiraFieldMap.getType().equals("Double")) {
                            if (itemJiraFieldMap != null && itemJiraFieldMap.getValue() != null) {
                                fields.put(itemJiraFieldMap.getKey(), (Object)updateSetArray.put((Object)this.getJsonObject("set", new Double(itemJiraFieldMap.getValue()))));
                                continue;
                            }
                            fields.put(itemJiraFieldMap.getKey(), (Object)updateSetArray.put((Object)this.getJsonObjectNULL("set")));
                            continue;
                        }
                        if (itemJiraFieldMap.getValue() == null) {
                            fields.put(itemJiraFieldMap.getKey(), (Object)updateSetArray.put((Object)this.getJsonObjectNULL("set")));
                            continue;
                        }
                        fields.put(itemJiraFieldMap.getKey(), (Object)updateSetArray.put((Object)this.getJsonObject("set", itemJiraFieldMap.getValue())));
                    }
                    catch (Exception e) {
                        LOGGER.error("jira field saving Exception [" + itemJiraFieldMap.getKey() + "] ", (Object)itemJiraFieldMap.getValue());
                        LOGGER.error("jira field saving Exception ", (Throwable)e);
                    }
                }
            }
            return fields;
        }
        catch (JSONException e) {
            LOGGER.error("constructUpdateRequestBodyForJira -->Caught JSONException", (Throwable)e);
            return null;
        }
    }

    public void createJiraIssueLink(String usIssueId, String featureIssueId, String linkName, String url, String username, String password, AlmAccount almAcc) {
        String _url = "/rest/api/latest/issueLink";
        JSONObject requestBody = new JSONObject();
        try {
            JSONObject type = this.getJsonObject("id", linkName);
            JSONObject inwardIssue = this.getJsonObject("id", usIssueId);
            JSONObject outwardIssue = this.getJsonObject("id", featureIssueId);
            requestBody.put("type", (Object)type);
            requestBody.put("inwardIssue", (Object)inwardIssue);
            requestBody.put("outwardIssue", (Object)outwardIssue);
        }
        catch (JSONException e) {
            LOGGER.error("JSONException while creating request for creating issueLink in JIRA.", (Throwable)e);
        }
        LOGGER.info(JiraUtils.executeJiraPostRequest((String)_url, (String)username, (String)password, (AlmAccount)almAcc, (String)requestBody.toString(), null, (Environment)this.ENV));
    }

    public void deleteJiraIssueLink(String linkId, String url, String username, String password, AlmAccount almAccount) {
        String _url = "/rest/api/latest/issueLink/" + linkId;
        JiraUtils.executeJiraDeleteRequest((String)_url, (String)username, (String)password, (AlmAccount)almAccount, null, (Environment)this.ENV);
    }

    public JiraSprint createJiraSprint(JiraSprint sprintToCreate, String url, String username, String password, AlmAccount almAccount) {
        String _url = "/rest/agile/1.0/sprint";
        JSONObject requestBody = new JSONObject();
        try {
            requestBody.put("name", (Object)sprintToCreate.getName());
            if (PropertyValidator.isValid((Object)sprintToCreate.getStartDate())) {
                requestBody.put("startDate", (Object)sprintToCreate.getStartDate());
            }
            if (PropertyValidator.isValid((Object)sprintToCreate.getEndDate())) {
                requestBody.put("endDate", (Object)sprintToCreate.getEndDate());
            }
            requestBody.put("originBoardId", (Object)sprintToCreate.getOriginBoardId());
        }
        catch (JSONException e) {
            LOGGER.error("Error in creating Sprint in Jira.", (Throwable)e);
        }
        LOGGER.debug("Sprint JSON ++++++++++++++++++++++++++++++++++");
        LOGGER.debug("_url : " + _url);
        LOGGER.debug("username : " + username);
        LOGGER.debug("password : " + password);
        LOGGER.debug("Sprint  : " + requestBody.toString());
        LOGGER.debug("Sprint JSON ++++++++++++++++++++++++++++++++++");
        String response = JiraUtils.executeJiraPostRequest((String)_url, (String)username, (String)password, (AlmAccount)almAccount, (String)requestBody.toString(), null, (Environment)this.ENV);
        if (PropertyValidator.isValid((Object)response)) {
            Gson gson = new Gson();
            JiraSprint newSprint = (JiraSprint)gson.fromJson(response, JiraSprint.class);
            return newSprint;
        }
        return null;
    }

    public JiraVersion createJiraVersion(JiraVersion versionToCreate, String url, String username, String password, AlmConfigurations almConfig) {
        String _url = "/rest/api/latest/version";
        JSONObject requestBody = new JSONObject();
        try {
            requestBody.put("name", (Object)versionToCreate.getName());
            requestBody.put("project", (Object)versionToCreate.getProjectKey());
            if (PropertyValidator.isValid((Object)versionToCreate.getStartDate())) {
                requestBody.put("startDate", (Object)versionToCreate.getStartDate());
            }
            if (PropertyValidator.isValid((Object)versionToCreate.getReleaseDate())) {
                requestBody.put("releaseDate", (Object)versionToCreate.getReleaseDate());
            }
            requestBody.put("archived", false);
            requestBody.put("released", false);
        }
        catch (JSONException e) {
            LOGGER.error("Error in creating Version in Jira.", (Throwable)e);
        }
        String response = JiraUtils.executeJiraPostRequest((String)_url, (String)username, (String)password, (AlmAccount)almConfig.getAlmAccount(), (String)requestBody.toString(), null, (Environment)this.ENV);
        if (PropertyValidator.isValid((Object)response)) {
            Gson gson = new Gson();
            JiraVersion newVersn = (JiraVersion)gson.fromJson(response, JiraVersion.class);
            return newVersn;
        }
        return null;
    }

    public JiraVersion updateJiraVersion(JiraVersion versionToUpdate, AlmAccount almAccount) {
        String _url = "/rest/api/3/version/" + versionToUpdate.getJiraId();
        String username = almAccount.getUsername();
        String password = almAccount.getPassword();
        JSONObject requestBody = new JSONObject();
        try {
            requestBody.put("id", (Object)versionToUpdate.getJiraId());
            requestBody.put("name", (Object)versionToUpdate.getName());
            requestBody.put("projectId", (Object)versionToUpdate.getProjectId());
            if (PropertyValidator.isValid((Object)versionToUpdate.getStartDate())) {
                requestBody.put("startDate", (Object)versionToUpdate.getStartDate());
            }
            if (PropertyValidator.isValid((Object)versionToUpdate.getReleaseDate())) {
                requestBody.put("releaseDate", (Object)versionToUpdate.getReleaseDate());
            }
        }
        catch (JSONException e) {
            LOGGER.error("Error in creating Version in Jira.", (Throwable)e);
        }
        String response = JiraUtils.executeJiraPutRequest((String)_url, (String)username, (String)password, (AlmAccount)almAccount, (String)requestBody.toString(), null, (Environment)this.ENV);
        if (PropertyValidator.isValid((Object)response)) {
            Gson gson = new Gson();
            JiraVersion updatedVersion = (JiraVersion)gson.fromJson(response, JiraVersion.class);
            return updatedVersion;
        }
        return null;
    }

    public void moveIssuesToJiraSprint(String sprintId, List<String> issueIds, String url, String username, String password, AlmAccount almAcc) {
        String _url = "/rest/agile/1.0/sprint/" + sprintId + "/issue";
        LOGGER.debug("moveIssuesToJiraSprint " + _url + "\n Issue to be moved " + issueIds);
        JSONObject requestBody = new JSONObject();
        try {
            requestBody.put("issues", (Object)new JSONArray(issueIds));
        }
        catch (JSONException e) {
            LOGGER.error("Error in moveIssuesToJiraSprint.", (Throwable)e);
            return;
        }
        JiraUtils.executeJiraPostRequest((String)_url, (String)username, (String)password, (AlmAccount)almAcc, (String)requestBody.toString(), null, (Environment)this.ENV);
    }

    public void removeIssuesFromJiraEpic(List<String> issueIds, String url, String username, String password, AlmAccount almAcc) {
        String _url = "/rest/agile/1.0/epic/none/issue";
        LOGGER.debug("removeIssuesFromJiraEpic " + _url + "\n Issue to be moved " + issueIds);
        JSONObject requestBody = new JSONObject();
        try {
            requestBody.put("issues", (Object)new JSONArray(issueIds));
        }
        catch (JSONException e) {
            LOGGER.error("Error in removeIssuesFromJiraEpic.", (Throwable)e);
            return;
        }
        JiraUtils.executeJiraPostRequest((String)_url, (String)username, (String)password, (AlmAccount)almAcc, (String)requestBody.toString(), null, (Environment)this.ENV);
    }

    public void moveIssuesToBacklog(List<String> issueIds, String url, String username, String password, AlmAccount almAcc) {
        String _url = "/rest/agile/1.0/backlog/issue";
        LOGGER.debug("moveIssuesToBacklog " + _url + "\n Issue to be moved " + issueIds);
        JSONObject requestBody = new JSONObject();
        try {
            requestBody.put("issues", (Object)new JSONArray(issueIds));
        }
        catch (JSONException e) {
            LOGGER.error("Error in removeIssuesFromJiraEpic.", (Throwable)e);
            return;
        }
        JiraUtils.executeJiraPostRequest((String)_url, (String)username, (String)password, (AlmAccount)almAcc, (String)requestBody.toString(), null, (Environment)this.ENV);
    }

    protected JSONObject getJsonObject(String fieldName, String value) {
        try {
            JSONObject tmpJson = new JSONObject();
            tmpJson.put(fieldName, (Object)value);
            return tmpJson;
        }
        catch (JSONException e) {
            LOGGER.warn("JSONException in getJsonObject.", (Throwable)e);
            return null;
        }
    }

    protected JSONObject getNullJsonObject(String fieldName) {
        try {
            JSONObject tmpJson = new JSONObject();
            tmpJson.put(fieldName, JSONObject.NULL);
            return tmpJson;
        }
        catch (JSONException e) {
            LOGGER.warn("JSONException in getJsonObject.", (Throwable)e);
            return null;
        }
    }

    protected JSONObject getJsonObject(String fieldName, JSONObject value) {
        try {
            JSONObject tmpJson = new JSONObject();
            tmpJson.put(fieldName, (Object)value);
            return tmpJson;
        }
        catch (JSONException e) {
            LOGGER.warn("JSONException in getJsonObject.", (Throwable)e);
            return null;
        }
    }

    protected JSONObject getJsonObject(String fieldName, Double value) {
        try {
            JSONObject tmpJson = new JSONObject();
            tmpJson.put(fieldName, (Object)value);
            return tmpJson;
        }
        catch (JSONException e) {
            LOGGER.warn("JSONException in getJsonObject.", (Throwable)e);
            return null;
        }
    }

    protected JSONObject getJsonObject(String fieldName, Integer value) {
        try {
            JSONObject tmpJson = new JSONObject();
            tmpJson.put(fieldName, (Object)value);
            return tmpJson;
        }
        catch (JSONException e) {
            LOGGER.warn("JSONException in getJsonObject.", (Throwable)e);
            return null;
        }
    }

    protected JSONObject getJsonObject(String fieldName, JSONArray values) {
        try {
            JSONObject tmpJson = new JSONObject();
            tmpJson.put(fieldName, (Object)values);
            return tmpJson;
        }
        catch (JSONException e) {
            LOGGER.warn("JSONException in getJsonObject.", (Throwable)e);
            return null;
        }
    }

    public AlmAccountRepository getAlmAccountRepository() {
        return this.almAccountRepository;
    }

    public void setAlmAccountRepository(AlmAccountRepository almAccountRepository) {
        this.almAccountRepository = almAccountRepository;
    }

    protected JSONObject getJsonObjectNULL(String fieldName) {
        try {
            JSONObject tmpJson = new JSONObject();
            tmpJson.put(fieldName, JSONObject.NULL);
            return tmpJson;
        }
        catch (JSONException e) {
            LOGGER.warn("JSONException in getJsonObject.", (Throwable)e);
            return null;
        }
    }

    public String createBulkJiraIssue(AlmAccount almAccount, List<Map<String, String>> nodes, Map<String, Object> param) {
        JSONObject requestBody = new JSONObject();
        HashMap<String, Object> jiraJson = new HashMap<String, Object>();
        JSONArray fieldsList = new JSONArray();
        String _url = "/rest/api/2/issue/bulk";
        String param1 = "";
        String username = almAccount.getUsername();
        String password = almAccount.getPassword();
        Map proj = (Map)param.get("project");
        Map issueType = (Map)param.get("issueType");
        Map sprint = (Map)param.get("sprint");
        jiraJson.put("almAccount", almAccount);
        jiraJson.put("project", proj.get("projectKey"));
        jiraJson.put("sprint", sprint.get("jiraId"));
        jiraJson.put("issuetype", issueType.get("id"));
        jiraJson.put("AlmAccountId", almAccount.getId());
        try {
            for (Map<String, String> obj : nodes) {
                JSONObject body = new JSONObject();
                jiraJson.put("title", obj.get("summary"));
                JSONObject field = this.constructRequestBodyForJira(jiraJson, null);
                body.put("fields", (Object)field);
                fieldsList.put((Object)body);
            }
            requestBody.put("issueUpdates", (Object)fieldsList);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        String response = "";
        try {
            response = JiraUtils.executeJiraPostRequest((String)_url, (String)username, (String)password, (AlmAccount)almAccount, (String)requestBody.toString(), (String)param1, (Environment)this.ENV);
        }
        catch (Exception e) {
            LOGGER.error("JSONException while creating request for Issue creation in JIRA. SECOND ATTEMPT", (Throwable)e);
        }
        return response;
    }
}

