/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.alm.entity;

import com.google.gson.annotations.SerializedName;
import com.viztrend.safe.persistence.entity.dto.SecureUser;
import com.viztrend.safe.persistence.entity.dto.UserContextDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.security.core.context.SecurityContextHolder;

public class BaseALMEntity {
    public String tenant = this.retCurrentTenant();
    @Id
    protected String mongoId;
    @SerializedName(value="id")
    protected String jiraId;
    @SerializedName(value="tid")
    @Transient
    protected String id;
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseALMEntity.class);

    public String getId() {
        return this.getJiraId();
    }

    public void setId(String id) {
        this.id = id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.jiraId == null ? 0 : this.jiraId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BaseALMEntity)) {
            return false;
        }
        BaseALMEntity other = (BaseALMEntity)obj;
        return !(this.jiraId == null ? other.jiraId != null : !this.jiraId.equals(other.jiraId));
    }

    public String retCurrentTenant() {
        if (SecurityContextHolder.getContext().getAuthentication() != null && !SecurityContextHolder.getContext().getAuthentication().getPrincipal().equals("anonymousUser")) {
            if (SecurityContextHolder.getContext().getAuthentication().getPrincipal() instanceof SecureUser) {
                SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
                String tenant = null;
                if (secureUser.getUserContextDTO() != null) {
                    tenant = String.valueOf(secureUser.getUserContextDTO().getContextMap().get("tenant"));
                }
                return tenant;
            }
            if (SecurityContextHolder.getContext().getAuthentication().getPrincipal().equals("apiUser") && null != UserContextDTO.getFromLocalThread() && null != UserContextDTO.getFromLocalThread().get("apiKeyTenant")) {
                String tenant = (String)UserContextDTO.getFromLocalThread().get("apiKeyTenant");
                return tenant;
            }
        }
        return null;
    }

    public String getTenant() {
        return this.tenant;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public String getJiraId() {
        return this.jiraId;
    }

    public void setJiraId(String jiraId) {
        this.jiraId = jiraId;
    }

    public String getMongoId() {
        return this.mongoId;
    }

    public void setMongoId(String mongoId) {
        this.mongoId = mongoId;
    }
}

