/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe;

import com.viztrend.safe.controller.KhufiaKari;
import com.viztrend.safe.persistence.entity.ActiveNode;
import com.viztrend.safe.persistence.entity.AppInitConfig;
import com.viztrend.safe.persistence.repository.ActiveNodeRepository;
import com.viztrend.safe.persistence.repository.AppInitConfigRepository;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.PushSender;
import com.viztrend.safe.utils.UserContextUtil;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class ReadDbPropertiesPostInit {
    @Autowired
    AppInitConfigRepository appInitConfigRepository;
    @Autowired
    ActiveNodeRepository activeNodeRepository;
    private static final Logger LOGGER = LoggerFactory.getLogger(ReadDbPropertiesPostInit.class);
    AppInitConfig appInitConfig = null;
    public static String nodeId = UserContextUtil.getUUId();

    public void init() {
        List nodeIps;
        List appInitConfigList = this.appInitConfigRepository.findAll();
        this.initConfig(appInitConfigList);
        this.manageNode(nodeId);
        PushSender.ipList = nodeIps = this.appInitConfig.getNodeIps();
        PushSender.appInitConfig = this.appInitConfig;
        PushSender.multiNode = this.appInitConfig.isEnableMultiNode();
    }

    @Scheduled(cron="*/20 * * * * ?")
    public void updateIplist() {
        List appInitConfigList = this.appInitConfigRepository.findAll();
        this.initConfig(appInitConfigList);
        AppInitConfig appInitConfig = (AppInitConfig)this.appInitConfigRepository.findAll().get(0);
        PushSender.ipList = appInitConfig.getNodeIps();
        PushSender.multiNode = appInitConfig.isEnableMultiNode();
        PushSender.appInitConfig = appInitConfig;
    }

    @Scheduled(cron="*/5 * * * * ?")
    public void updateNodeStatus() {
        this.manageNode(nodeId);
    }

    @Scheduled(cron="*/10 * * * * ?")
    public void removeInActiveNode() {
        List activeNodes = this.activeNodeRepository.findAll();
        Long maxInActiveTime = 30000000000L;
        if (PropertyValidator.isValid((Collection)activeNodes)) {
            activeNodes.forEach(node -> {
                Long timeDifference = System.nanoTime() - node.getUpdatedAt();
                if (timeDifference > maxInActiveTime) {
                    this.activeNodeRepository.delete((Serializable)((Object)node.getId()));
                }
            });
        }
    }

    private String initHostAddress() {
        try {
            String hostAddress = InetAddress.getLocalHost().getHostAddress();
            if (ReadDbPropertiesPostInit.isValidHostAddress((String)hostAddress)) {
                return hostAddress;
            }
            return null;
        }
        catch (UnknownHostException e) {
            LOGGER.error("Machine IP not Found");
            return null;
        }
    }

    private void initConfig(List<AppInitConfig> appInitConfigList) {
        String hostAddress = this.initHostAddress();
        String secrets = RandomStringUtils.randomAlphanumeric((int)16);
        if (PropertyValidator.isValid(appInitConfigList) && appInitConfigList.size() > 0) {
            this.appInitConfig = (AppInitConfig)this.appInitConfigRepository.findAll().get(0);
            if (this.appInitConfig.isEnableMultiNode() && PropertyValidator.isValid((Object)hostAddress)) {
                if (PropertyValidator.isValid((Collection)this.appInitConfig.getNodeIps()) && !this.appInitConfig.getNodeIps().contains(hostAddress) && !this.appInitConfig.getNodeIps().contains(hostAddress + ":80")) {
                    this.appInitConfig.getNodeIps().add(hostAddress);
                    this.appInitConfigRepository.save((Object)this.appInitConfig);
                } else if (!PropertyValidator.isValid((Collection)this.appInitConfig.getNodeIps())) {
                    ArrayList<String> nodeIps = new ArrayList<String>();
                    nodeIps.add(hostAddress);
                    this.appInitConfig.setNodeIps(nodeIps);
                    this.appInitConfigRepository.save((Object)this.appInitConfig);
                }
            }
            if (!PropertyValidator.isValid((Object)this.appInitConfig.getKeySecrets())) {
                this.appInitConfig.setKeySecrets(secrets);
                this.appInitConfigRepository.save((Object)this.appInitConfig);
            }
        } else {
            this.appInitConfig = new AppInitConfig();
            this.appInitConfig.setEnableMultiNode(false);
            this.appInitConfig.setKeySecrets(secrets);
            this.appInitConfigRepository.save((Object)this.appInitConfig);
        }
        KhufiaKari.secret = this.appInitConfig.getKeySecrets();
    }

    private void manageNode(String nodeId) {
        ActiveNode activeNode = this.activeNodeRepository.findByNodeId(nodeId);
        if (PropertyValidator.isValid((Object)activeNode)) {
            activeNode.setUpdatedAt(Long.valueOf(System.nanoTime()));
            this.activeNodeRepository.save((Object)activeNode);
        } else {
            ActiveNode newNode = new ActiveNode(nodeId, Long.valueOf(System.nanoTime()), Long.valueOf(System.nanoTime()));
            this.activeNodeRepository.save((Object)newNode);
        }
    }

    public static boolean isValidHostAddress(String ip) {
        String PATTERN = "^(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(\\.(?!$)|$)){4}$";
        return ip.matches(PATTERN);
    }
}

