/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe;

import com.viztrend.safe.ReadDbPropertiesPostInit;
import com.viztrend.safe.controller.HealthController;
import com.viztrend.safe.utils.EncDecUtility;
import com.viztrend.safe.utils.PrintConsoleBox;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.SystemUtil;
import java.util.Properties;
import org.springframework.boot.Banner;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.system.ApplicationPidFileWriter;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.scheduling.annotation.EnableScheduling;

@ServletComponentScan
@SpringBootApplication
@EnableScheduling
public class Application
implements CommandLineRunner {
    private static String[] args;
    private static ConfigurableApplicationContext context;

    public static void main(String[] args) {
        SpringApplication application = new SpringApplication(new Object[]{Application.class});
        if ("true".equals(System.getenv("isWindowExe"))) {
            application.addListeners(new ApplicationListener[]{new ApplicationPidFileWriter(SystemUtil.kendisHomeFolderPath + "/kendis.pid")});
        }
        application.setBannerMode(Banner.Mode.OFF);
        Properties properties = SystemUtil.getDefaultProperties();
        application.setDefaultProperties(properties);
        context = application.run(new String[]{properties.getProperty("server.port"), properties.getProperty("isLocalDeployment")});
        Application.args = args;
        ((ReadDbPropertiesPostInit)context.getBean(ReadDbPropertiesPostInit.class)).init();
    }

    public void run(String ... args) throws Exception {
        if (PropertyValidator.isValid((String[])args)) {
            PrintConsoleBox.printBox((String[])new String[]{"Server Running on port :" + args[0]});
            if (EncDecUtility.use265Bit) {
                PrintConsoleBox.printBox((String[])new String[]{"256 bit encryption mode is on"});
            }
            if (!SystemUtil.isSysEnabled) {
                PrintConsoleBox.printBox((String[])new String[]{"/system interface is disabled"});
            }
            PrintConsoleBox.printBox((String[])new String[]{"Kendis App server is now running.", "You can access using host port you have given while setting up Docker", "e.g http://127.0.0.1:" + args[0] + "/", "or http://<host-ip>:" + args[0] + "/"});
            if (args[1].equals("true")) {
                HealthController.changeLoggerDebug((boolean)false);
            }
        }
    }

    public static void restart() {
        context.close();
        String port = null;
        SpringApplication application = new SpringApplication(new Object[]{Application.class});
        port = PropertyValidator.isValid((String[])args) ? args[0] : "8080";
        application.setDefaultProperties(SystemUtil.getDefaultProperties());
        context = application.run(new String[]{SystemUtil.getDefaultProperties().getProperty("server.port")});
    }
}

