/*
 * Decompiled with CFR 0.152.
 */
package com.okta.saml;

import com.okta.saml.Application;
import com.okta.saml.Configuration;
import com.okta.saml.SAMLLogoutRequest;
import com.okta.saml.SAMLRequest;
import com.okta.saml.SAMLResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import org.opensaml.DefaultBootstrap;
import org.opensaml.ws.security.SecurityPolicyException;
import org.opensaml.xml.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAMLValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SAMLValidator.class);

    public SAMLValidator() throws SecurityPolicyException {
        try {
            DefaultBootstrap.bootstrap();
        }
        catch (ConfigurationException e) {
            LOGGER.error(e.getMessage());
            throw new SecurityPolicyException("Problem while bootstrapping openSAML library");
        }
    }

    public Configuration getConfiguration(String config) throws SecurityPolicyException {
        try {
            return new Configuration(config);
        }
        catch (Exception e) {
            LOGGER.error("Failed to create new Configuration instance", (Throwable)e);
            throw new SecurityPolicyException(e.getMessage());
        }
    }

    public Configuration getConfigurationFrom(String path) throws SecurityPolicyException, IOException {
        try (FileInputStream stream = null;){
            stream = new FileInputStream(new File(path));
            FileChannel channel = stream.getChannel();
            MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
            String config = Charset.forName("UTF-8").decode(buffer).toString();
            Configuration configuration = this.getConfiguration(config);
            return configuration;
        }
    }

    public SAMLRequest getSAMLRequest(Application application, boolean setConsumerServiceURL, String authnContextClassRef) {
        return new SAMLRequest(application, setConsumerServiceURL, authnContextClassRef);
    }

    public SAMLLogoutRequest getSAMLLogoutRequest(Application application, boolean setConsumerServiceURL, String authnContextClassRef, String samlUserId) {
        return new SAMLLogoutRequest(application, setConsumerServiceURL, authnContextClassRef, samlUserId);
    }

    public SAMLResponse getSAMLResponse(String responseString, Configuration configuration) throws SecurityPolicyException {
        return new SAMLResponse(responseString, configuration);
    }
}

