/*
 * Decompiled with CFR 0.152.
 */
package com.okta.saml;

import com.google.inject.Inject;
import com.okta.saml.Application;
import com.okta.saml.util.Clock;
import com.okta.saml.util.Identifier;
import com.okta.saml.util.SimpleClock;
import com.okta.saml.util.UUIDIdentifer;
import com.viztrend.safe.utils.PropertyValidator;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.namespace.QName;
import org.opensaml.Configuration;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.SAMLVersion;
import org.opensaml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.NameIDPolicy;
import org.opensaml.saml2.core.RequestedAuthnContext;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.util.XMLHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLRequest {
    private final AuthnRequest request = (AuthnRequest)this.build(AuthnRequest.DEFAULT_ELEMENT_NAME);

    public SAMLRequest(Application application, boolean setConsumerServiceURL, String authnContextClassRef) {
        this(application, (Identifier)new UUIDIdentifer(), (Clock)new SimpleClock(), setConsumerServiceURL, authnContextClassRef);
    }

    @Inject
    private SAMLRequest(Application application, Identifier identifier, Clock clock, boolean setConsumerServiceURL, String authnContextClassRefValue) {
        this.request.setID(identifier.getId());
        this.request.setVersion(SAMLVersion.VERSION_20);
        this.request.setIssueInstant(clock.dateTimeNow());
        this.request.setProtocolBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        this.request.setDestination(application.getConfig().getIdentityProviderSingleSign());
        if (application.getConfig().isIncludeAssertionConsumerServiceURL()) {
            this.request.setAssertionConsumerServiceURL(application.getConfig().getCallBack());
        }
        Issuer issuer = (Issuer)this.build(Issuer.DEFAULT_ELEMENT_NAME);
        issuer.setValue(application.getIssuer());
        this.request.setIssuer(issuer);
        NameIDPolicy nameIDPolicy = (NameIDPolicy)this.build(NameIDPolicy.DEFAULT_ELEMENT_NAME);
        nameIDPolicy.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
        this.request.setNameIDPolicy(nameIDPolicy);
        RequestedAuthnContext requestedAuthnContext = (RequestedAuthnContext)this.build(RequestedAuthnContext.DEFAULT_ELEMENT_NAME);
        requestedAuthnContext.setComparison(AuthnContextComparisonTypeEnumeration.EXACT);
        this.request.setRequestedAuthnContext(requestedAuthnContext);
        AuthnContextClassRef authnContextClassRef = (AuthnContextClassRef)this.build(AuthnContextClassRef.DEFAULT_ELEMENT_NAME);
        if (PropertyValidator.isValid((Object)authnContextClassRefValue)) {
            authnContextClassRef.setAuthnContextClassRef(authnContextClassRefValue);
        } else {
            authnContextClassRef.setAuthnContextClassRef("urn:oasis:names:tc:SAML:2.0:ac:classes:unspecified");
        }
        requestedAuthnContext.getAuthnContextClassRefs().add(authnContextClassRef);
    }

    private <T extends SAMLObject> T build(QName qName) {
        return (T)((SAMLObject)Configuration.getBuilderFactory().getBuilder(qName).buildObject(qName));
    }

    public String toString() {
        try {
            Marshaller marshaller = Configuration.getMarshallerFactory().getMarshaller((XMLObject)this.request);
            Element dom = marshaller.marshall((XMLObject)this.request);
            StringWriter stringWriter = new StringWriter();
            XMLHelper.writeNode((Node)dom, (Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public AuthnRequest getAuthnRequest() {
        return this.request;
    }
}

