/*
 * Decompiled with CFR 0.152.
 */
package com.okta.saml;

import com.okta.saml.Application;
import com.okta.saml.MetadataNamespaceContext;
import com.okta.saml.util.IPRange;
import com.sun.org.apache.xpath.internal.jaxp.XPathFactoryImpl;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringUtils;
import org.opensaml.ws.security.SecurityPolicyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class Configuration {
    private Map<String, Application> applications;
    private String defaultEntityID = null;
    private boolean suppressErrors;
    private String loginUri;
    static XPath xPath;
    private static XPathExpression configurationRootXPath;
    private static XPathExpression applicationXPath;
    private static XPathExpression entityIdXPath;
    private static XPathExpression defaultAppXPath;
    private static XPathExpression addressXPath;
    private static XPathExpression spUsernamesXPath;
    private static XPathExpression spGroupsXPath;
    private static XPathExpression suppressErrorsXPath;
    private static XPathExpression loginUriXPath;
    private static XPathExpression spUrlsXPath;
    private IPRange oktaUsersIps;
    private IPRange spUsersIps;
    private List<String> spUsernames;
    private List<String> spGroupnames;
    private List<Pattern> spUrlPatterns;
    public static final String SAML_RESPONSE_FORM_NAME = "SAMLResponse";
    public static final String CONFIGURATION_KEY = "okta.config.file";
    public static final String DEFAULT_ENTITY_ID = "okta.config.default_entity_id";
    public static final String REDIR_PARAM = "os_destination";
    public static final String RELAY_STATE_PARAM = "RelayState";
    private static final Logger LOGGER;

    public Configuration(String configuration) throws XPathExpressionException, CertificateException, UnsupportedEncodingException, SecurityPolicyException {
        String suppress;
        InputSource source = new InputSource(new StringReader(configuration));
        Node root = (Node)configurationRootXPath.evaluate(source, XPathConstants.NODE);
        NodeList applicationNodes = (NodeList)applicationXPath.evaluate(root, XPathConstants.NODESET);
        this.defaultEntityID = defaultAppXPath.evaluate(root);
        this.applications = new HashMap();
        this.spUsernames = new ArrayList();
        this.spGroupnames = new ArrayList();
        this.spUrlPatterns = new ArrayList();
        for (int i = 0; i < applicationNodes.getLength(); ++i) {
            Element applicationNode = (Element)applicationNodes.item(i);
            String entityID = entityIdXPath.evaluate(applicationNode);
            Application application = new Application(applicationNode);
            this.applications.put(entityID, application);
        }
        Element allowedAddresses = (Element)addressXPath.evaluate(root, XPathConstants.NODE);
        if (allowedAddresses != null) {
            String oktaFrom = (String)xPath.compile("oktaUsers/ipFrom").evaluate(allowedAddresses, XPathConstants.STRING);
            String oktaTo = (String)xPath.compile("oktaUsers/ipTo").evaluate(allowedAddresses, XPathConstants.STRING);
            String spFrom = (String)xPath.compile("spUsers/ipFrom").evaluate(allowedAddresses, XPathConstants.STRING);
            String spTo = (String)xPath.compile("spUsers/ipTo").evaluate(allowedAddresses, XPathConstants.STRING);
            if (oktaFrom != null) {
                try {
                    this.oktaUsersIps = new IPRange(oktaFrom, oktaTo);
                }
                catch (NumberFormatException e) {
                    LOGGER.error("Invalid IP specified for Okta users addresses: " + e.getMessage());
                }
            }
            if (spFrom != null) {
                try {
                    this.spUsersIps = new IPRange(spFrom, spTo);
                }
                catch (NumberFormatException e) {
                    LOGGER.error("Invalid IP specified for Service Provider users addresses: " + e.getMessage());
                }
            }
        }
        if ((suppress = suppressErrorsXPath.evaluate(root)) != null) {
            suppress = suppress.trim();
        }
        this.suppressErrors = !StringUtils.isBlank((String)suppress) ? Boolean.parseBoolean(suppress) : true;
        this.loginUri = loginUriXPath.evaluate(root);
        if (this.loginUri != null) {
            this.loginUri = this.loginUri.trim();
        }
        this.spUsernames = this.getOptionsByXPath(root, spUsernamesXPath);
        this.spGroupnames = this.getOptionsByXPath(root, spGroupsXPath);
        for (String rawPattern : this.getOptionsByXPath(root, spUrlsXPath)) {
            try {
                this.spUrlPatterns.add(Pattern.compile(rawPattern));
            }
            catch (PatternSyntaxException e) {
                LOGGER.warn("Invalid url pattern: {}. Skipping", (Object)rawPattern, (Object)e);
            }
        }
    }

    private List<String> getOptionsByXPath(Node root, XPathExpression xPath) throws XPathExpressionException {
        return this.getStringsFrom((Collection)this.getElementsByXPath(root, xPath));
    }

    private List<String> getStringsFrom(Collection<Element> rawElements) {
        ArrayList<String> options = new ArrayList<String>();
        for (Element rawElement : rawElements) {
            String option = rawElement.getTextContent();
            if (!StringUtils.isNotBlank((String)option)) continue;
            options.add(option.trim());
        }
        return options;
    }

    private List<Element> getElementsByXPath(Node root, XPathExpression xPath) throws XPathExpressionException {
        NodeList nodes = (NodeList)xPath.evaluate(root, XPathConstants.NODESET);
        ArrayList<Element> elements = new ArrayList<Element>();
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                elements.add((Element)nodes.item(i));
            }
        }
        return elements;
    }

    public Map<String, Application> getApplications() {
        return this.applications;
    }

    public Application getApplication(String entityID) {
        return (Application)this.applications.get(entityID);
    }

    public Application getDefaultApplication() {
        if (StringUtils.isBlank((String)this.defaultEntityID)) {
            return null;
        }
        return (Application)this.applications.get(this.defaultEntityID);
    }

    public String getDefaultEntityID() {
        return this.defaultEntityID;
    }

    public boolean isIpAllowedForOkta(String ip) {
        try {
            boolean isRejectedForSP;
            boolean isRejectedForOkta = this.oktaUsersIps != null && !this.oktaUsersIps.isAddressInRange(ip);
            boolean bl = isRejectedForSP = this.spUsersIps != null && !this.spUsersIps.isAddressInRange(ip);
            if (isRejectedForOkta && isRejectedForSP || !isRejectedForOkta && !isRejectedForSP || this.oktaUsersIps == null && isRejectedForSP || this.spUsersIps == null && this.oktaUsersIps == null) {
                return true;
            }
            if (this.oktaUsersIps == null && !isRejectedForSP || isRejectedForOkta && !isRejectedForSP) {
                return false;
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getClass().getSimpleName() + ": " + e.getMessage());
            return true;
        }
        return true;
    }

    public boolean isUsernameAllowedForOkta(String username) {
        if (StringUtils.isBlank((String)username)) {
            return true;
        }
        return !this.spUsernames.contains(username);
    }

    public boolean isInSPGroups(Collection<String> userGroups) {
        if (userGroups == null || userGroups.isEmpty() || this.spGroupnames.isEmpty()) {
            return false;
        }
        for (String atlGroup : this.spGroupnames) {
            for (String userGroup : userGroups) {
                if (!userGroup.trim().equalsIgnoreCase(atlGroup.trim())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSPUsernamesUsed() {
        return !this.spUsernames.isEmpty();
    }

    public boolean isSPGroupnamesUsed() {
        return !this.spGroupnames.isEmpty();
    }

    public boolean isInSPUrls(String url) {
        for (Pattern pattern : this.spUrlPatterns) {
            if (!pattern.matcher(url).find()) continue;
            return true;
        }
        return false;
    }

    public boolean isIpAllowedForSP(String ip) {
        return !this.isIpAllowedForOkta(ip);
    }

    public boolean suppressingErrors() {
        return this.suppressErrors;
    }

    public String getLoginUri() {
        return this.loginUri;
    }

    static {
        LOGGER = LoggerFactory.getLogger(Configuration.class);
        try {
            XPathFactoryImpl xPathFactory = new XPathFactoryImpl();
            xPath = ((XPathFactory)xPathFactory).newXPath();
            xPath.setNamespaceContext((NamespaceContext)new MetadataNamespaceContext());
            configurationRootXPath = xPath.compile("configuration");
            applicationXPath = xPath.compile("applications/application");
            addressXPath = xPath.compile("allowedAddresses");
            spUsernamesXPath = xPath.compile("spUsers/username");
            spGroupsXPath = xPath.compile("spGroups/groupname");
            entityIdXPath = xPath.compile("md:EntityDescriptor/@entityID");
            defaultAppXPath = xPath.compile("default");
            suppressErrorsXPath = xPath.compile("suppressErrors");
            loginUriXPath = xPath.compile("loginUri");
            spUrlsXPath = xPath.compile("spUrls/url");
        }
        catch (XPathExpressionException e) {
            LOGGER.error("Failed to create XPathFactory instance", (Throwable)e);
        }
    }
}

