/*
 * Decompiled with CFR 0.152.
 */
package com.okta.controller;

import com.okta.saml.Application;
import com.okta.saml.Configuration;
import com.okta.saml.SAMLResponse;
import com.okta.saml.SAMLValidator;
import com.viztrend.safe.utils.StringUtils;
import java.nio.charset.Charset;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.opensaml.ws.security.SecurityPolicyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeepLinkServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeepLinkServlet.class);
    private static final String SAML_RESPONSE = "SAMLResponse";
    protected SAMLValidator validator;
    protected Configuration configuration;
    protected Application app;

    public DeepLinkServlet() {
        try {
            this.validator = new SAMLValidator();
            this.configuration = this.validator.getConfigurationFrom("src/main/resources/valid-config.xml");
            this.app = this.configuration.getDefaultApplication();
            if (this.configuration.getDefaultEntityID() == null) {
                LOGGER.error("Default application has not been configured in configuration.");
            } else if (this.app == null) {
                LOGGER.error("Could not find default application in configuration: " + this.configuration.getDefaultEntityID());
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            String responseString = request.getParameter(SAML_RESPONSE);
            if (responseString == null) {
                throw new Exception("SAMLResponse parameter missing");
            }
            responseString = new String(Base64.decodeBase64((byte[])responseString.getBytes("UTF-8")), Charset.forName("UTF-8"));
            LOGGER.info(responseString);
            SAMLResponse samlResponse = this.validator.getSAMLResponse(responseString, this.configuration);
            LOGGER.info("SAML authentication successful");
            request.setAttribute("user", (Object)samlResponse.getUserID());
        }
        catch (SecurityPolicyException e) {
            LOGGER.info("SAML authentication unsuccessful");
            response.setStatus(401);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            response.setStatus(500);
        }
    }
}

