/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth.client;

import com.atlassian.oauth.client.Command;
import com.atlassian.oauth.client.JiraOAuthClient;
import com.atlassian.oauth.client.PropertiesClient;
import com.google.api.client.auth.oauth.OAuthParameters;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.function.Function;
import org.json.JSONObject;

public class OAuthClient {
    private final Map<Command, Function<List<String>, Optional<Exception>>> actionHandlers;
    private final PropertiesClient propertiesClient;
    private final JiraOAuthClient jiraOAuthClient;

    public OAuthClient(PropertiesClient propertiesClient, JiraOAuthClient jiraOAuthClient) {
        this.propertiesClient = propertiesClient;
        this.jiraOAuthClient = jiraOAuthClient;
        this.actionHandlers = ImmutableMap.builder().put((Object)Command.REQUEST_TOKEN, arg_0 -> this.handleGetRequestTokenAction(arg_0)).put((Object)Command.ACCESS_TOKEN, arg_0 -> this.handleGetAccessToken(arg_0)).put((Object)Command.REQUEST, arg_0 -> this.handleGetRequest(arg_0)).build();
    }

    public void execute(Command action, List<String> arguments) {
        this.actionHandlers.getOrDefault(action, arg_0 -> this.handleUnknownCommand(arg_0)).apply(arguments).ifPresent(Throwable::printStackTrace);
    }

    private Optional<Exception> handleUnknownCommand(List<String> arguments) {
        System.out.println("Command not supported. Only " + Command.names() + " are supported.");
        return Optional.empty();
    }

    private Optional<Exception> handleGetRequestTokenAction(List<String> arguments) {
        Map properties = this.propertiesClient.getPropertiesOrDefaults();
        try {
            String requestToken = this.jiraOAuthClient.getAndAuthorizeTemporaryToken((String)properties.get("consumer_key"), (String)properties.get("private_key"));
            properties.put("request_token", requestToken);
            this.propertiesClient.savePropertiesToFile(properties);
            return Optional.empty();
        }
        catch (Exception e) {
            return Optional.of(e);
        }
    }

    private Optional<Exception> handleGetAccessToken(List<String> arguments) {
        Map properties = this.propertiesClient.getPropertiesOrDefaults();
        String tmpToken = (String)properties.get("request_token");
        String secret = arguments.get(0);
        try {
            this.propertiesClient.savePropertiesToFile(properties);
            return Optional.empty();
        }
        catch (Exception e) {
            return Optional.of(e);
        }
    }

    private Optional<Exception> handleGetRequest(List<String> arguments) {
        Map properties = this.propertiesClient.getPropertiesOrDefaults();
        String tmpToken = (String)properties.get("access_token");
        String secret = (String)properties.get("secret");
        String url = arguments.get(0);
        this.propertiesClient.savePropertiesToFile(properties);
        try {
            return Optional.empty();
        }
        catch (Exception e) {
            return Optional.of(e);
        }
    }

    private void parseResponse(HttpResponse response) throws IOException {
        Scanner s = new Scanner(response.getContent()).useDelimiter("\\A");
        String result = s.hasNext() ? s.next() : "";
        try {
            JSONObject jSONObject = new JSONObject(result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static HttpResponse getResponseFromUrl(OAuthParameters parameters, GenericUrl jiraUrl) throws IOException {
        HttpRequestFactory requestFactory = new NetHttpTransport().createRequestFactory((HttpRequestInitializer)parameters);
        HttpRequest request = requestFactory.buildGetRequest(jiraUrl);
        return request.execute();
    }
}

